/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.xml;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateConverter;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.xml.immoxml.Aktion;
import com.openindex.openestate.impl.xml.immoxml.Alter;
import com.openindex.openestate.impl.xml.immoxml.Anbieter;
import com.openindex.openestate.impl.xml.immoxml.Anhaenge;
import com.openindex.openestate.impl.xml.immoxml.Anhang;
import com.openindex.openestate.impl.xml.immoxml.Ausblick;
import com.openindex.openestate.impl.xml.immoxml.Ausstattung;
import com.openindex.openestate.impl.xml.immoxml.BebaubarNach;
import com.openindex.openestate.impl.xml.immoxml.BueroPraxen;
import com.openindex.openestate.impl.xml.immoxml.Distanzen;
import com.openindex.openestate.impl.xml.immoxml.DistanzenSport;
import com.openindex.openestate.impl.xml.immoxml.Einzelhandel;
import com.openindex.openestate.impl.xml.immoxml.Erschliessung;
import com.openindex.openestate.impl.xml.immoxml.Flaechen;
import com.openindex.openestate.impl.xml.immoxml.Freitexte;
import com.openindex.openestate.impl.xml.immoxml.FreizeitimmobilieGewerblich;
import com.openindex.openestate.impl.xml.immoxml.Gastgewerbe;
import com.openindex.openestate.impl.xml.immoxml.Geo;
import com.openindex.openestate.impl.xml.immoxml.Geokoordinaten;
import com.openindex.openestate.impl.xml.immoxml.Geschlecht;
import com.openindex.openestate.impl.xml.immoxml.Grundstueck;
import com.openindex.openestate.impl.xml.immoxml.HallenLagerProd;
import com.openindex.openestate.impl.xml.immoxml.Haus;
import com.openindex.openestate.impl.xml.immoxml.Immobilie;
import com.openindex.openestate.impl.xml.immoxml.Immoxml;
import com.openindex.openestate.impl.xml.immoxml.Infrastruktur;
import com.openindex.openestate.impl.xml.immoxml.Kontaktperson;
import com.openindex.openestate.impl.xml.immoxml.LageGebiet;
import com.openindex.openestate.impl.xml.immoxml.LandUndForstwirtschaft;
import com.openindex.openestate.impl.xml.immoxml.Objektkategorie;
import com.openindex.openestate.impl.xml.immoxml.Preise;
import com.openindex.openestate.impl.xml.immoxml.Serviceleistungen;
import com.openindex.openestate.impl.xml.immoxml.Sonstige;
import com.openindex.openestate.impl.xml.immoxml.Stellplatz;
import com.openindex.openestate.impl.xml.immoxml.Stellplatzart;
import com.openindex.openestate.impl.xml.immoxml.StpSonstige;
import com.openindex.openestate.impl.xml.immoxml.Uebertragung;
import com.openindex.openestate.impl.xml.immoxml.Unterkellert;
import com.openindex.openestate.impl.xml.immoxml.UserDefinedSimplefield;
import com.openindex.openestate.impl.xml.immoxml.VerwaltungObjekt;
import com.openindex.openestate.impl.xml.immoxml.VerwaltungTechn;
import com.openindex.openestate.impl.xml.immoxml.Wohnung;
import com.openindex.openestate.impl.xml.immoxml.ZinshausRenditeobjekt;
import com.openindex.openestate.impl.xml.immoxml.Zustand;
import com.openindex.openestate.impl.xml.immoxml.ZustandAngaben;
import java.math.BigDecimal;
import java.net.URL;
import java.text.ParseException;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ImmoXmlReader
extends OpenEstateConverter {
    private static final Logger LOGGER = Logger.getLogger(ImmoXmlReader.class);
    public static final int CONVERT_TO_AGENCY = 0;
    public static final int CONVERT_TO_TRANSFER = 1;

    public ImmoXmlReader() {
    }

    public ImmoXmlReader(Locale locale) {
        this();
        this.setOpenEstateLanguage(locale);
    }

    protected AgentImpl convertAnbieter(Anbieter anbieter) {
        AgentImpl agentImpl = this.createEmptyAgent();
        agentImpl.setId(anbieter.getAnbieternr());
        agentImpl.getCompany().setCompanyName(anbieter.getFirma());
        return agentImpl;
    }

    protected EstateImpl convertImmobilie(Immobilie immobilie, Map<String, AgentContactImpl> map) {
        try {
            EstateImpl estateImpl = this.createEmptyEstate();
            this.readImmobilieObjektkategorie(immobilie.getObjektkategorie(), immobilie.getPreise(), estateImpl);
            this.readImmobilieGeo(immobilie.getGeo(), estateImpl);
            this.readImmobilieKontaktperson(immobilie.getKontaktperson(), estateImpl, map);
            this.readImmobiliePreise(immobilie.getPreise(), immobilie.getAusstattung(), estateImpl);
            this.readImmobilieFlaechen(immobilie.getFlaechen(), estateImpl);
            this.readImmobilieAusstattung(immobilie.getAusstattung(), estateImpl);
            this.readImmobilieZustandAngaben(immobilie.getZustandAngaben(), estateImpl);
            this.readImmobilieInfrastruktur(immobilie.getInfrastruktur(), estateImpl);
            this.readImmobilieFreitexte(immobilie.getFreitexte(), estateImpl);
            this.readImmobilieAnhaenge(immobilie.getAnhaenge(), estateImpl);
            this.readImmobilieVerwaltungObjekt(immobilie.getVerwaltungObjekt(), estateImpl);
            this.readImmobilieVerwaltungTechn(immobilie.getVerwaltungTechn(), estateImpl);
            return estateImpl;
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't convert estate!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    protected AgentImpl createEmptyAgent() {
        return new AgentImpl();
    }

    protected EstateImpl createEmptyEstate() {
        return new EstateImpl();
    }

    public SerializableXmlElement read(Immoxml immoxml, int n) {
        switch (n) {
            case 0: {
                return this.readAgency(immoxml);
            }
            case 1: {
                return this.readTransfer(immoxml);
            }
        }
        throw new IllegalArgumentException("invalid convert-mode: " + n);
    }

    public AgencyImpl readAgency(Immoxml immoxml) {
        this.getErrorMap().clear();
        if (immoxml.getAnbieter().isEmpty()) {
            throw new IllegalArgumentException("anbieter is missing!");
        }
        AgencyImpl agencyImpl = new AgencyImpl();
        Anbieter anbieter = immoxml.getAnbieter().get(0);
        AgentImpl agentImpl = this.convertAnbieter(anbieter);
        agentImpl.setId("Agent.1");
        agencyImpl.setAgent(agentImpl);
        HashMap<String, AgentContactImpl> hashMap = new HashMap<String, AgentContactImpl>();
        for (Immobilie object : anbieter.getImmobilie()) {
            EstateImpl estateImpl = this.convertImmobilie(object, hashMap);
            if (estateImpl == null) continue;
            String string = estateImpl.getId();
            if (string == null) {
                string = "Estate." + (agencyImpl.getEstates().size() + 1);
            }
            agencyImpl.getEstates().put(string, estateImpl);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            agencyImpl.getContacts().put((String)entry.getKey(), (AgentContactImpl)entry.getValue());
        }
        return agencyImpl;
    }

    protected void readImmobilieAnhaenge(Anhaenge anhaenge, EstateImpl estateImpl) {
        if (anhaenge == null) {
            return;
        }
        for (Anhang anhang : anhaenge.getAnhang()) {
            try {
                EstateAttachmentImpl estateAttachmentImpl = new EstateAttachmentImpl();
                estateAttachmentImpl.setMimeType(anhang.getFormat());
                estateAttachmentImpl.setTitle(anhang.getAnhangtitel(), this.getOpenEstateLanguage());
                String string = StringUtils.trimToNull((String)anhang.getDaten().getPfad());
                byte[] byArray = anhang.getDaten().getAnhanginhalt();
                if (string != null) {
                    if (string.toLowerCase().startsWith("http://") || string.toLowerCase().startsWith("https://")) {
                        estateAttachmentImpl.setFile(new URL(string));
                    } else {
                        estateAttachmentImpl.setFile(string);
                    }
                } else if (byArray != null) {
                    estateAttachmentImpl.setFile(byArray);
                } else {
                    LOGGER.warn((Object)"daten-element is empty!");
                    continue;
                }
                if (Anhang.Gruppe.AUSSENANSICHTEN.equals((Object)anhang.getGruppe())) {
                    estateAttachmentImpl.setType("IMAGE_OUTER_VIEW");
                } else if (Anhang.Gruppe.BILD.equals((Object)anhang.getGruppe())) {
                    estateAttachmentImpl.setType("IMAGE");
                } else if (Anhang.Gruppe.GRUNDRISS.equals((Object)anhang.getGruppe())) {
                    estateAttachmentImpl.setType("IMAGE_GROUNDPLAN");
                } else if (Anhang.Gruppe.INNENANSICHTEN.equals((Object)anhang.getGruppe())) {
                    estateAttachmentImpl.setType("IMAGE_INNER_VIEW");
                } else if (Anhang.Gruppe.KARTEN_LAGEPLAN.equals((Object)anhang.getGruppe())) {
                    estateAttachmentImpl.setType("IMAGE_MAP");
                } else if (Anhang.Gruppe.PANORAMA.equals((Object)anhang.getGruppe())) {
                    estateAttachmentImpl.setType("IMAGE_PANORAMA");
                }
                estateImpl.getAttachments().add(estateAttachmentImpl);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"could not read attachment!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
    }

    protected void readImmobilieAusstattung(Ausstattung ausstattung, EstateImpl estateImpl) {
        if (ausstattung == null) {
            return;
        }
        if (ausstattung.getAngeschlGastronomie() != null) {
            this.putEstateValue("AUSSTATTUNG", "ANGESCHL_GASTRONOMIE", Boolean.TRUE.equals(ausstattung.getAngeschlGastronomie().isBAR()) || Boolean.TRUE.equals(ausstattung.getAngeschlGastronomie().isHOTELRESTAURANT()), estateImpl);
        }
        this.putEstateValue("AUSSTATTUNG", "BARRIEREFREI", ausstattung.isBarrierefrei(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "BRAUEREIBINDUNG", ausstattung.isBrauereibindung(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "BREITBAND", ausstattung.isBrauereibindung(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "GARTENNUTZUNG", ausstattung.isGartennutzung(), estateImpl);
        this.putEstateValue("FLAECHEN", "GASTTERRASSE", ausstattung.isGastterrasse(), estateImpl);
        try {
            this.putEstateValue("AUSSTATTUNG", "HALLENHOEHE", ausstattung.getHallenhoehe() != null ? Float.valueOf(ausstattung.getHallenhoehe().toString()) : null, estateImpl);
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"openimmo-hallenhoehe konnte nicht ermittelt werden!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
        }
        this.putEstateValue("AUSSTATTUNG", "HEBEBUEHNE", ausstattung.isHebebuehne(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "KAMIN", ausstattung.isKamin(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "KANTINE_CAFETERIA", ausstattung.isKantineCafeteria(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "KLIMATISIERT", ausstattung.isKlimatisiert(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "KRAN", ausstattung.isKran(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "RAMPE", ausstattung.isRampe(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "SAUNA", ausstattung.isSauna(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "SPORTEINRICHTUNGEN", ausstattung.isSporteinrichtungen(), estateImpl);
        try {
            this.putEstateValue("AUSSTATTUNG", "STROMANSCHLUSSWERT", ausstattung.getStromanschlusswert() != null ? Float.valueOf(ausstattung.getStromanschlusswert().toString()) : null, estateImpl);
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"openimmo-stromanschlusswert konnte nicht ermittelt werden!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
        }
        this.putEstateValue("AUSSTATTUNG", "SWIMMINGPOOL", ausstattung.isSwimmingpool(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "TELEFON_FERIENIMMOBILIE", ausstattung.isTelefonFerienimmobilie(), estateImpl);
        this.putEstateValue("AUSSTATTUNG", "WELLNESSBEREICH", ausstattung.isWellnessbereich(), estateImpl);
        if (ausstattung.getAusrichtBalkonTerrasse() != null) {
            if (Boolean.TRUE.equals(ausstattung.getAusrichtBalkonTerrasse().isNORD())) {
                this.putEstateValue("AUSSTATTUNG", "BALKON_TERRASSE_AUSRICHTUNG", "N", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getAusrichtBalkonTerrasse().isOST())) {
                this.putEstateValue("AUSSTATTUNG", "BALKON_TERRASSE_AUSRICHTUNG", "E", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getAusrichtBalkonTerrasse().isSUED())) {
                this.putEstateValue("AUSSTATTUNG", "BALKON_TERRASSE_AUSRICHTUNG", "S", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getAusrichtBalkonTerrasse().isWEST())) {
                this.putEstateValue("AUSSTATTUNG", "BALKON_TERRASSE_AUSRICHTUNG", "W", estateImpl);
            }
        }
        if (Boolean.TRUE.equals(ausstattung.isTeekueche())) {
            this.putEstateValue("AUSSTATTUNG", "RAEUME_GEWERBLICH", "TEEKUECHE", estateImpl);
        }
        if (Boolean.TRUE.equals(ausstattung.isWaschTrockenraum())) {
            this.putEstateValue("AUSSTATTUNG", "RAEUME", "WASCH_TROCKENRAUM", estateImpl);
        }
        if (Boolean.TRUE.equals(ausstattung.isDvVerkabelung())) {
            this.putEstateValue("AUSSTATTUNG", "TECHNIK", "DV_VERKABELUNG", estateImpl);
        }
        if (Boolean.TRUE.equals(ausstattung.isKabelSatTv())) {
            this.putEstateValue("AUSSTATTUNG", "TECHNIK", "KABEL_SAT_TV", estateImpl);
        }
        if (Boolean.TRUE.equals(ausstattung.isRollstuhlgerecht())) {
            this.putEstateValue("AUSSTATTUNG", "EIGNUNG", "ROLLSTUHL", estateImpl);
        }
        if (Boolean.TRUE.equals(ausstattung.isWgGeeignet())) {
            this.putEstateValue("AUSSTATTUNG", "EIGNUNG", "WG", estateImpl);
        }
        if (ausstattung.getBad() != null) {
            if (Boolean.TRUE.equals(ausstattung.getBad().isDUSCHE())) {
                this.putEstateValue("AUSSTATTUNG", "BAD", "DUSCHE", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getBad().isFENSTER())) {
                this.putEstateValue("AUSSTATTUNG", "BAD", "FENSTER", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getBad().isWANNE())) {
                this.putEstateValue("AUSSTATTUNG", "BAD", "WANNE", estateImpl);
            }
        }
        if (ausstattung.getBefeuerung() != null) {
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().isALTERNATIV())) {
                this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "ALTERNATIV", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().isELEKTRO())) {
                this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "ELEKTRO", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().isERDWAERME())) {
                this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "ERDWAERME", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().isGAS())) {
                this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "GAS", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().isOEL())) {
                this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "OEL", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().isSOLAR())) {
                this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "SOLAR", estateImpl);
            }
        }
        if (ausstattung.getBoden() != null) {
            if (Boolean.TRUE.equals(ausstattung.getBoden().isDIELEN())) {
                this.putEstateValue("AUSSTATTUNG", "BODENBELAG", "DIELEN", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().isDOPPELBODEN())) {
                this.putEstateValue("AUSSTATTUNG", "BODENBELAG", "DOPPELBODEN", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().isESTRICH())) {
                this.putEstateValue("AUSSTATTUNG", "BODENBELAG", "ESTRICH", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().isFLIESEN())) {
                this.putEstateValue("AUSSTATTUNG", "BODENBELAG", "FLIESEN", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().isKUNSTSTOFF())) {
                this.putEstateValue("AUSSTATTUNG", "BODENBELAG", "KUNSTSTOFF", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().isPARKETT())) {
                this.putEstateValue("AUSSTATTUNG", "BODENBELAG", "PARKETT", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().isSTEIN())) {
                this.putEstateValue("AUSSTATTUNG", "BODENBELAG", "STEIN", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().isTEPPICH())) {
                this.putEstateValue("AUSSTATTUNG", "BODENBELAG", "TEPPICH", estateImpl);
            }
        }
        if (ausstattung.getFahrstuhl() != null) {
            this.putEstateValue("AUSSTATTUNG", "LAST_LIFT", ausstattung.getFahrstuhl().isLASTEN(), estateImpl);
            this.putEstateValue("AUSSTATTUNG", "PERS_LIFT", ausstattung.getFahrstuhl().isPERSONEN(), estateImpl);
        }
        if (ausstattung.getHeizungsart() != null) {
            if (Boolean.TRUE.equals(ausstattung.getHeizungsart().isETAGE())) {
                this.putEstateValue("AUSSTATTUNG", "HEIZUNGSART", "ETAGE", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getHeizungsart().isFERN())) {
                this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "FERNWAERME", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getHeizungsart().isFUSSBODEN())) {
                this.putEstateValue("AUSSTATTUNG", "HEIZUNGSART", "FUSSBODEN", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getHeizungsart().isOFEN())) {
                this.putEstateValue("AUSSTATTUNG", "HEIZUNGSART", "OFEN", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getHeizungsart().isZENTRAL())) {
                this.putEstateValue("AUSSTATTUNG", "HEIZUNGSART", "ZENTRAL", estateImpl);
            }
        }
        if (ausstattung.getKueche() != null) {
            if (Boolean.TRUE.equals(ausstattung.getKueche().isEBK())) {
                this.putEstateValue("AUSSTATTUNG", "KUECHE", "EINBAUKUECHE", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getKueche().isOFFEN())) {
                this.putEstateValue("AUSSTATTUNG", "KUECHE", "OFFENE_KUECHE", estateImpl);
            }
        }
        if (ausstattung.getMoebliert() != null) {
            if (Boolean.TRUE.equals(ausstattung.getMoebliert().isTEIL())) {
                this.putEstateValue("AUSSTATTUNG", "MOEBLIERT", "TEIL", estateImpl);
            } else if (Boolean.TRUE.equals(ausstattung.getMoebliert().isVOLL())) {
                this.putEstateValue("AUSSTATTUNG", "MOEBLIERT", "JA", estateImpl);
            }
        }
        if (Boolean.TRUE.equals(ausstattung.isRaeumeVeraenderbar())) {
            this.putEstateValue("VERWALTUNG", "RAEUME_VERAENDERBAR", "JA", estateImpl);
        } else if (Boolean.FALSE.equals(ausstattung.isRaeumeVeraenderbar())) {
            this.putEstateValue("VERWALTUNG", "RAEUME_VERAENDERBAR", "NEIN", estateImpl);
        }
        if (ausstattung.getServiceleistungen() != null) {
            for (Serviceleistungen object : ausstattung.getServiceleistungen()) {
                if (Boolean.TRUE.equals(object.isBETREUTESWOHNEN())) {
                    this.putEstateValue("AUSSTATTUNG", "SERVICELEISTUNGEN", "BETREUTES_WOHNEN", estateImpl);
                }
                if (Boolean.TRUE.equals(object.isCATERING())) {
                    this.putEstateValue("AUSSTATTUNG", "SERVICELEISTUNGEN", "CATERING", estateImpl);
                    this.putEstateValue("AUSSTATTUNG", "SERVICELEISTUNGEN_GEWERBE", "CATERING", estateImpl);
                }
                if (Boolean.TRUE.equals(object.isEINKAUF())) {
                    this.putEstateValue("AUSSTATTUNG", "SERVICELEISTUNGEN", "EINKAUF", estateImpl);
                }
                if (Boolean.TRUE.equals(object.isREINIGUNG())) {
                    this.putEstateValue("AUSSTATTUNG", "SERVICELEISTUNGEN", "REINIGUNG", estateImpl);
                    this.putEstateValue("AUSSTATTUNG", "SERVICELEISTUNGEN_GEWERBE", "REINIGUNG", estateImpl);
                }
                if (!Boolean.TRUE.equals(object.isWACHDIENST())) continue;
                this.putEstateValue("AUSSTATTUNG", "SERVICELEISTUNGEN", "WACHDIENST", estateImpl);
                this.putEstateValue("AUSSTATTUNG", "SERVICELEISTUNGEN_GEWERBE", "WACHDIENST", estateImpl);
            }
        }
        if (ausstattung.getSicherheitstechnik() != null) {
            if (Boolean.TRUE.equals(ausstattung.getSicherheitstechnik().isALARMANLAGE())) {
                this.putEstateValue("AUSSTATTUNG", "SICHERHEITSTECHNIK", "ALARMANLAGE", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getSicherheitstechnik().isKAMERA())) {
                this.putEstateValue("AUSSTATTUNG", "SICHERHEITSTECHNIK", "KAMERA", estateImpl);
            }
            if (Boolean.TRUE.equals(ausstattung.getSicherheitstechnik().isPOLIZEIRUF())) {
                this.putEstateValue("AUSSTATTUNG", "SICHERHEITSTECHNIK", "POLIZEIRUF", estateImpl);
            }
        }
        if (ausstattung.getStellplatzart() != null) {
            for (Stellplatzart stellplatzart : ausstattung.getStellplatzart()) {
                if (Boolean.TRUE.equals(stellplatzart.isCARPORT())) {
                    this.putEstateValue("FLAECHEN", "STELLPLATZART", "CARPORT", estateImpl);
                    continue;
                }
                if (Boolean.TRUE.equals(stellplatzart.isDUPLEX())) {
                    this.putEstateValue("FLAECHEN", "STELLPLATZART", "DUPLEX", estateImpl);
                    continue;
                }
                if (Boolean.TRUE.equals(stellplatzart.isFREIPLATZ())) {
                    this.putEstateValue("FLAECHEN", "STELLPLATZART", "STELLPLATZ", estateImpl);
                    continue;
                }
                if (Boolean.TRUE.equals(stellplatzart.isGARAGE())) {
                    this.putEstateValue("FLAECHEN", "STELLPLATZART", "GARAGE", estateImpl);
                    continue;
                }
                if (Boolean.TRUE.equals(stellplatzart.isPARKHAUS())) {
                    this.putEstateValue("FLAECHEN", "STELLPLATZART", "PARKHAUS", estateImpl);
                    continue;
                }
                if (!Boolean.TRUE.equals(stellplatzart.isTIEFGARAGE())) continue;
                this.putEstateValue("FLAECHEN", "STELLPLATZART", "TIEFGARAGE", estateImpl);
            }
        }
        if (ausstattung.getUnterkellert() != null && ausstattung.getUnterkellert().getKeller() != null) {
            Object object = ausstattung.getUnterkellert().getKeller();
            if (Unterkellert.Keller.JA.equals(object)) {
                this.putEstateValue("AUSSTATTUNG", "UNTERKELLERT", "JA", estateImpl);
            } else if (Unterkellert.Keller.NEIN.equals(object)) {
                this.putEstateValue("AUSSTATTUNG", "UNTERKELLERT", "NEIN", estateImpl);
            } else if (Unterkellert.Keller.TEIL.equals(object)) {
                this.putEstateValue("AUSSTATTUNG", "UNTERKELLERT", "TEIL", estateImpl);
            }
        }
    }

    protected void readImmobilieFlaechen(Flaechen flaechen, EstateImpl estateImpl) {
        if (flaechen == null) {
            return;
        }
        this.putEstateValue("FLAECHEN", "ANZ_BADEZIMMER", flaechen.getAnzahlBadezimmer(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_BALKON_TERRASSEN", flaechen.getAnzahlBalkonTerrassen(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_BETTEN", flaechen.getAnzahlBetten(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_GEWERBEEINHEIT", flaechen.getAnzahlGewerbeeinheiten(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_SCHLAFZIMMER", flaechen.getAnzahlSchlafzimmer(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_SEP_WC", flaechen.getAnzahlSepWc(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_STELLPLAETZE", flaechen.getAnzahlStellplaetze(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_TAGUNGSRAEUME", flaechen.getAnzahlTagungsraeume(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_WOHN_SCHLAFZIMMMER", flaechen.getAnzahlWohnSchlafzimmer(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_WOHNEINHEITEN", flaechen.getAnzahlWohneinheiten(), estateImpl);
        this.putEstateValue("FLAECHEN", "ANZ_ZIMMER", flaechen.getAnzahlZimmer(), estateImpl);
        this.putEstateValue("FLAECHEN", "BALKONFLAECHE", flaechen.getBalkonTerrasseFlaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "BEHEIZBARE_FLAECHE", flaechen.getBeheizbareFlaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "BGF", flaechen.getBgf(), estateImpl);
        this.putEstateValue("FLAECHEN", "BMZ", flaechen.getBmz(), estateImpl);
        this.putEstateValue("FLAECHEN", "BUEROFLAECHE", flaechen.getBueroflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "BUEROTEILFLAECHE", flaechen.getBueroteilflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "DACHBODENFLAECHE", flaechen.getDachbodenflaeche(), estateImpl);
        this.putEstateValue("VERWALTUNG", "EINLIEGERWOHNUNG", flaechen.isEinliegerwohnung(), estateImpl);
        this.putEstateValue("FLAECHEN", "FENSTERFRONT_M", flaechen.getFensterfront(), estateImpl);
        this.putEstateValue("FLAECHEN", "FENSTERFRONT", flaechen.getFensterfrontQm(), estateImpl);
        this.putEstateValue("FLAECHEN", "FREIFLAECHE", flaechen.getFreiflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "GARTENFLAECHE", flaechen.getGartenflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "GASTRAUMFLAECHE", flaechen.getGastroflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "GESAMTFLAECHE", flaechen.getGesamtflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "GFZ", flaechen.getGfz(), estateImpl);
        this.putEstateValue("FLAECHEN", "GRUNDSTUECKSFLAECHE", flaechen.getGrundstuecksflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "GRUNDSTUECKSFRONT", flaechen.getGrundstuecksfront(), estateImpl);
        this.putEstateValue("FLAECHEN", "GRZ", flaechen.getGrz(), estateImpl);
        this.putEstateValue("FLAECHEN", "KELLERFLAECHE", flaechen.getKellerflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "LADENFLAECHE", flaechen.getLadenflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "LAGERFLAECHE", flaechen.getLagerflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "NUTZFLAECHE", flaechen.getNutzflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "PLAETZE_GASTRAUM", flaechen.getPlaetzeGastraum(), estateImpl);
        this.putEstateValue("FLAECHEN", "SONSTFLAECHE", flaechen.getSonstflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "TEILBAR_AB", flaechen.getTeilbarAb(), estateImpl);
        this.putEstateValue("FLAECHEN", "VERKAUFSFLAECHE", flaechen.getVerkaufsflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "VERMIETBARE_FLAECHE", flaechen.getVermietbareFlaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "VERWALTUNGSFLAECHE", flaechen.getVerwaltungsflaeche(), estateImpl);
        this.putEstateValue("FLAECHEN", "WOHNFLAECHE", flaechen.getWohnflaeche(), estateImpl);
    }

    protected void readImmobilieFreitexte(Freitexte freitexte, EstateImpl estateImpl) {
        if (freitexte == null) {
            return;
        }
        estateImpl.setTitle(freitexte.getObjekttitel(), this.getOpenEstateLanguage());
        this.putEstateValue("FREITEXTE", "AUSSTATT_BESCHR", freitexte.getAusstattBeschr(), estateImpl);
        this.putEstateValue("FREITEXTE", "KURZ_BESCHR", freitexte.getDreizeiler(), estateImpl);
        this.putEstateValue("FREITEXTE", "LAGE_BESCHR", freitexte.getLage(), estateImpl);
        this.putEstateValue("FREITEXTE", "OBJEKT_BESCHR", freitexte.getObjektbeschreibung(), estateImpl);
        this.putEstateValue("FREITEXTE", "SONSTIGE_ANGABEN", freitexte.getSonstigeAngaben(), estateImpl);
    }

    protected void readImmobilieGeo(Geo geo, EstateImpl estateImpl) {
        if (geo == null) {
            return;
        }
        estateImpl.getAdress().setRegion(geo.getBundesland());
        this.putEstateValue("AUSSTATTUNG", "ETAGE", geo.getEtage(), estateImpl);
        this.putEstateValue("VERWALTUNG", "FLUR", geo.getFlur(), estateImpl);
        this.putEstateValue("VERWALTUNG", "FLURSTUECK", geo.getFlurstueck(), estateImpl);
        this.putEstateValue("VERWALTUNG", "GEMARKUNG", geo.getGemarkung(), estateImpl);
        this.putEstateValue("VERWALTUNG", "GEMEINDECODE", geo.getGemeindecode(), estateImpl);
        estateImpl.getAdress().setStreetNr(geo.getHausnummer());
        if (geo.getLand() != null && geo.getLand().getIsoLand() != null) {
            estateImpl.getAdress().setCountry(OpenEstateUtils.convertToIso2Country(geo.getLand().getIsoLand()));
        }
        List<Object> list = geo.getAnschrift();
        for (Object object : list) {
            Object object2;
            if (object instanceof JAXBElement) {
                object2 = (JAXBElement)object;
                if (object2.getName().getLocalPart().equals("plz")) {
                    estateImpl.getAdress().setPostalCode(object2.getValue().toString());
                    continue;
                }
                if (!object2.getName().getLocalPart().equals("ort")) continue;
                estateImpl.getAdress().setCity(object2.getValue().toString());
                continue;
            }
            if (!(object instanceof Geokoordinaten)) continue;
            try {
                if (list.size() <= 2) continue;
                object2 = (Geokoordinaten)list.get(2);
                Double d = ((Geokoordinaten)object2).getBreitengrad();
                Double d2 = ((Geokoordinaten)object2).getLaengengrad();
                if (d == null || d2 == null) continue;
                estateImpl.getAdress().setLatitude(d);
                estateImpl.getAdress().setLongitude(d2);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"geo-error!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        this.putEstateValue("VERWALTUNG", "REGIONALER_ZUSATZ", geo.getRegionalerZusatz(), estateImpl);
        estateImpl.getAdress().setStreet(geo.getStrasse());
        this.putEstateValue("VERWALTUNG", "WOHNUNGSNR", geo.getWohnungsnr(), estateImpl);
        if (geo.getLageGebiet() != null && geo.getLageGebiet().getGebiete() != null) {
            Object object = geo.getLageGebiet().getGebiete();
            if (LageGebiet.Gebiete.A_LAGE.equals(object)) {
                this.putEstateValue("UMFELD", "LAGE_GEWERBE", "A_LAGE", estateImpl);
            } else if (LageGebiet.Gebiete.B_LAGE.equals(object)) {
                this.putEstateValue("UMFELD", "LAGE_GEWERBE", "B_LAGE", estateImpl);
            } else if (LageGebiet.Gebiete.GEWERBE.equals(object)) {
                this.putEstateValue("UMFELD", "LAGE_GEBIET", "GEWERBE", estateImpl);
            } else if (LageGebiet.Gebiete.INDUSTRIE.equals(object)) {
                this.putEstateValue("UMFELD", "LAGE_GEBIET", "INDUSTRIE", estateImpl);
            } else if (LageGebiet.Gebiete.MISCH.equals(object)) {
                this.putEstateValue("UMFELD", "LAGE_GEBIET", "GEMISCHT", estateImpl);
            } else if (LageGebiet.Gebiete.NEBENZENTRUM.equals(object)) {
                this.putEstateValue("UMFELD", "LAGE_GEBIET", "NEBENZENTRUM", estateImpl);
            } else if (LageGebiet.Gebiete.NEUBAU.equals(object)) {
                this.putEstateValue("UMFELD", "LAGE_GEBIET", "NEUBAU", estateImpl);
            } else if (LageGebiet.Gebiete.ORTSLAGE.equals(object)) {
                this.putEstateValue("UMFELD", "LAGE_GEBIET", "ORTSLAGE", estateImpl);
            } else if (LageGebiet.Gebiete.SIEDLUNG.equals(object)) {
                this.putEstateValue("UMFELD", "LAGE_GEBIET", "SIEDLUNG", estateImpl);
            } else if (LageGebiet.Gebiete.STADTRAND.equals(object)) {
                this.putEstateValue("UMFELD", "LAGE_GEBIET", "STADTRAND", estateImpl);
            } else if (LageGebiet.Gebiete.STADTTEIL.equals(object)) {
                this.putEstateValue("UMFELD", "LAGE_GEBIET", "STADTTEIL", estateImpl);
            } else if (LageGebiet.Gebiete.STADTZENTRUM.equals(object)) {
                this.putEstateValue("UMFELD", "LAGE_GEBIET", "STADTZENTRUM", estateImpl);
            } else if (LageGebiet.Gebiete.WOHN.equals(object)) {
                this.putEstateValue("UMFELD", "LAGE_GEBIET", "WOHN", estateImpl);
            }
        }
        if (geo.getLageImBau() != null) {
            if (Boolean.TRUE.equals(geo.getLageImBau().isHINTEN())) {
                this.putEstateValue("VERWALTUNG", "LAGE_IM_BAU", "HINTERHAUS", estateImpl);
            }
            if (Boolean.TRUE.equals(geo.getLageImBau().isLINKS())) {
                this.putEstateValue("VERWALTUNG", "LAGE_IM_BAU", "SEITENFLUEGEL_LINKS", estateImpl);
            }
            if (Boolean.TRUE.equals(geo.getLageImBau().isRECHTS())) {
                this.putEstateValue("VERWALTUNG", "LAGE_IM_BAU", "SEITENFLUEGEL_RECHTS", estateImpl);
            }
            if (Boolean.TRUE.equals(geo.getLageImBau().isVORNE())) {
                this.putEstateValue("VERWALTUNG", "LAGE_IM_BAU", "VORDERHAUS", estateImpl);
            }
        }
    }

    protected void readImmobilieInfrastruktur(Infrastruktur infrastruktur, EstateImpl estateImpl) {
        Enum enum_;
        if (infrastruktur == null) {
            return;
        }
        if (infrastruktur.getAusblick() != null) {
            Object object = infrastruktur.getAusblick().getBlick();
            if (Ausblick.Blick.BERGE.equals(object)) {
                this.putEstateValue("UMFELD", "AUSBLICK", "BERGBLICK", estateImpl);
            }
            if (Ausblick.Blick.FERNE.equals(object)) {
                this.putEstateValue("UMFELD", "AUSBLICK", "FERNBLICK", estateImpl);
            }
            if (Ausblick.Blick.SEE.equals(object)) {
                this.putEstateValue("UMFELD", "AUSBLICK", "SEEBLICK", estateImpl);
            }
        }
        if (infrastruktur.getDistanzen() != null) {
            for (Distanzen object : infrastruktur.getDistanzen()) {
                enum_ = object.getDistanzZu();
                if (Distanzen.DistanzZu.AUTOBAHN.equals(enum_)) {
                    this.putEstateValue("UMFELD", "DISTANZ_AUTOBAHN", Float.valueOf(object.getValue()), estateImpl);
                    continue;
                }
                if (Distanzen.DistanzZu.BUS.equals(enum_)) {
                    this.putEstateValue("UMFELD", "DISTANZ_BUS", Float.valueOf(object.getValue()), estateImpl);
                    continue;
                }
                if (Distanzen.DistanzZu.EINKAUFSMOEGLICHKEITEN.equals(enum_)) {
                    this.putEstateValue("UMFELD", "DISTANZ_EINKAUF", Float.valueOf(object.getValue()), estateImpl);
                    continue;
                }
                if (Distanzen.DistanzZu.FERNBAHNHOF.equals(enum_)) {
                    this.putEstateValue("UMFELD", "DISTANZ_BHF", Float.valueOf(object.getValue()), estateImpl);
                    continue;
                }
                if (Distanzen.DistanzZu.FLUGHAFEN.equals(enum_)) {
                    this.putEstateValue("UMFELD", "DISTANZ_FLUG", Float.valueOf(object.getValue()), estateImpl);
                    continue;
                }
                if (Distanzen.DistanzZu.GASTSTAETTEN.equals(enum_)) {
                    this.putEstateValue("UMFELD", "DISTANZ_GASTRONOMIE", Float.valueOf(object.getValue()), estateImpl);
                    continue;
                }
                if (Distanzen.DistanzZu.GESAMTSCHULE.equals(enum_)) {
                    this.putEstateValue("UMFELD", "DISTANZ_GESAMTSCHULE", Float.valueOf(object.getValue()), estateImpl);
                    continue;
                }
                if (Distanzen.DistanzZu.GRUNDSCHULE.equals(enum_)) {
                    this.putEstateValue("UMFELD", "DISTANZ_GRUNDSCHULE", Float.valueOf(object.getValue()), estateImpl);
                    continue;
                }
                if (Distanzen.DistanzZu.GYMNASIUM.equals(enum_)) {
                    this.putEstateValue("UMFELD", "DISTANZ_GYMNASIUM", Float.valueOf(object.getValue()), estateImpl);
                    continue;
                }
                if (Distanzen.DistanzZu.HAUPTSCHULE.equals(enum_)) {
                    this.putEstateValue("UMFELD", "DISTANZ_HAUPTSCHULE", Float.valueOf(object.getValue()), estateImpl);
                    continue;
                }
                if (Distanzen.DistanzZu.KINDERGAERTEN.equals(enum_)) {
                    this.putEstateValue("UMFELD", "DISTANZ_KITA", Float.valueOf(object.getValue()), estateImpl);
                    continue;
                }
                if (Distanzen.DistanzZu.REALSCHULE.equals(enum_)) {
                    this.putEstateValue("UMFELD", "DISTANZ_REALSCHULE", Float.valueOf(object.getValue()), estateImpl);
                    continue;
                }
                if (Distanzen.DistanzZu.US_BAHN.equals(enum_)) {
                    this.putEstateValue("UMFELD", "DISTANZ_NAHBHF", Float.valueOf(object.getValue()), estateImpl);
                    continue;
                }
                if (!Distanzen.DistanzZu.ZENTRUM.equals(enum_)) continue;
                this.putEstateValue("UMFELD", "DISTANZ_ZENTRUM", Float.valueOf(object.getValue()), estateImpl);
            }
        }
        if (infrastruktur.getDistanzenSport() != null) {
            for (DistanzenSport distanzenSport : infrastruktur.getDistanzenSport()) {
                enum_ = distanzenSport.getDistanzZuSport();
                if (DistanzenSport.DistanzZuSport.MEER.equals(enum_)) {
                    this.putEstateValue("UMFELD", "DISTANZ_MEER", Float.valueOf(distanzenSport.getValue()), estateImpl);
                    continue;
                }
                if (DistanzenSport.DistanzZuSport.NAHERHOLUNG.equals(enum_)) {
                    this.putEstateValue("UMFELD", "DISTANZ_NAHERHOHLUNG", Float.valueOf(distanzenSport.getValue()), estateImpl);
                    continue;
                }
                if (DistanzenSport.DistanzZuSport.SEE.equals(enum_)) {
                    this.putEstateValue("UMFELD", "DISTANZ_SEE", Float.valueOf(distanzenSport.getValue()), estateImpl);
                    continue;
                }
                if (DistanzenSport.DistanzZuSport.SKIGEBIET.equals(enum_)) {
                    this.putEstateValue("UMFELD", "DISTANZ_SKIGEBIET", Float.valueOf(distanzenSport.getValue()), estateImpl);
                    continue;
                }
                if (DistanzenSport.DistanzZuSport.SPORTANLAGEN.equals(enum_)) {
                    this.putEstateValue("UMFELD", "DISTANZ_SPORTANLAGEN", Float.valueOf(distanzenSport.getValue()), estateImpl);
                    continue;
                }
                if (DistanzenSport.DistanzZuSport.STRAND.equals(enum_)) {
                    this.putEstateValue("UMFELD", "DISTANZ_STRAND", Float.valueOf(distanzenSport.getValue()), estateImpl);
                    continue;
                }
                if (!DistanzenSport.DistanzZuSport.WANDERGEBIETE.equals(enum_)) continue;
                this.putEstateValue("UMFELD", "DISTANZ_WANDERGEBIET", Float.valueOf(distanzenSport.getValue()), estateImpl);
            }
        }
        this.putEstateValue("UMFELD", "ZULIEFERUNG_MOEGLICH", infrastruktur.isZulieferung(), estateImpl);
    }

    protected void readImmobilieKontaktperson(Kontaktperson kontaktperson, EstateImpl estateImpl, Map<String, AgentContactImpl> map) {
        if (kontaktperson == null) {
            return;
        }
        String string = StringUtils.trimToNull((String)kontaktperson.getPersonennummer());
        if (string == null) {
            string = "NewContact." + (map.size() + 1);
        }
        if (map.containsKey(string)) {
            AgentContactImpl agentContactImpl = map.get(string);
            estateImpl.setContactId(agentContactImpl.getId());
        } else {
            AgentContactImpl agentContactImpl = new AgentContactImpl();
            agentContactImpl.setId(string);
            estateImpl.setContactId(string);
            map.put(string, agentContactImpl);
            Object object = kontaktperson.getKontakte().iterator();
            while (object.hasNext()) {
                JAXBElement<String> jAXBElement = object.next();
                if ("email_zentrale".equals(jAXBElement.getName().getLocalPart())) {
                    agentContactImpl.setPersonMail((String)jAXBElement.getValue());
                    continue;
                }
                if ("email_direkt".equals(jAXBElement.getName().getLocalPart())) {
                    agentContactImpl.setPersonMail((String)jAXBElement.getValue());
                    continue;
                }
                if ("tel_zentrale".equals(jAXBElement.getName().getLocalPart())) {
                    agentContactImpl.setPersonPhone((String)jAXBElement.getValue());
                    continue;
                }
                if ("tel_durchw".equals(jAXBElement.getName().getLocalPart())) {
                    agentContactImpl.setPersonPhone((String)jAXBElement.getValue());
                    continue;
                }
                if ("tel_fax".equals(jAXBElement.getName().getLocalPart())) {
                    agentContactImpl.setPersonFax((String)jAXBElement.getValue());
                    continue;
                }
                if (!"tel_handy".equals(jAXBElement.getName().getLocalPart())) continue;
                agentContactImpl.setPersonMobilePhone((String)jAXBElement.getValue());
            }
            if (StringUtils.isBlank((String)agentContactImpl.getPersonMail())) {
                agentContactImpl.setPersonMail(kontaktperson.getEmailPrivat());
            }
            if (StringUtils.isBlank((String)agentContactImpl.getPersonPhone())) {
                agentContactImpl.setPersonPhone(kontaktperson.getTelPrivat());
            }
            if ("FEMALE".equalsIgnoreCase((String)(object = kontaktperson.getAnrede())) || "frau".equalsIgnoreCase((String)object)) {
                agentContactImpl.setPersonGender("FEMALE");
            } else if ("MALE".equalsIgnoreCase((String)object) || "herr".equalsIgnoreCase((String)object)) {
                agentContactImpl.setPersonGender("MALE");
            }
            agentContactImpl.setStreetNr(kontaktperson.getHausnummer());
            if (kontaktperson.getLand() != null && kontaktperson.getLand().getIsoLand() != null) {
                agentContactImpl.setCountry(OpenEstateUtils.convertToIso2Country(kontaktperson.getLand().getIsoLand().toString()));
            }
            agentContactImpl.setPersonLastName(kontaktperson.getName());
            agentContactImpl.setCity(kontaktperson.getOrt());
            agentContactImpl.setPostalCode(kontaktperson.getPlz());
            agentContactImpl.setStreet(kontaktperson.getStrasse());
            agentContactImpl.setPersonFirstName(kontaktperson.getVorname());
        }
    }

    protected void readImmobilieObjektkategorie(Objektkategorie objektkategorie, Preise preise, EstateImpl estateImpl) throws OpenEstateException {
        if (objektkategorie == null) {
            return;
        }
        String string = null;
        OpenEstateType openEstateType = null;
        try {
            Enum enum_;
            if (!objektkategorie.getObjektart().getBueroPraxen().isEmpty()) {
                enum_ = objektkategorie.getObjektart().getBueroPraxen().get(0).getBueroTyp();
                openEstateType = BueroPraxen.BueroTyp.AUSSTELLUNGSFLAECHE.equals(enum_) ? OpenEstateType.newInstance("AUSSTELLUNGSFLAECHE") : (BueroPraxen.BueroTyp.BUEROFLAECHE.equals(enum_) ? OpenEstateType.newInstance("BUEROFLAECHE") : (BueroPraxen.BueroTyp.BUEROHAUS.equals(enum_) ? OpenEstateType.newInstance("BUEROHAUS") : (BueroPraxen.BueroTyp.PRAXIS.equals(enum_) ? OpenEstateType.newInstance("PRAXIS") : OpenEstateType.newInstance("BUERO_PRAXIS"))));
            } else if (!objektkategorie.getObjektart().getEinzelhandel().isEmpty()) {
                enum_ = objektkategorie.getObjektart().getEinzelhandel().get(0).getHandelTyp();
                openEstateType = Einzelhandel.HandelTyp.EINKAUFSZENTRUM.equals(enum_) ? OpenEstateType.newInstance("EINKAUFSZENTRUM") : (Einzelhandel.HandelTyp.EINZELHANDELSLADEN.equals(enum_) ? OpenEstateType.newInstance("LADEN") : (Einzelhandel.HandelTyp.LADENLOKAL.equals(enum_) ? OpenEstateType.newInstance("LADENLOKAL") : (Einzelhandel.HandelTyp.VERBRAUCHERMARKT.equals(enum_) ? OpenEstateType.newInstance("VERBRAUCHERMARKT") : OpenEstateType.newInstance("EINZELHANDEL"))));
            } else if (!objektkategorie.getObjektart().getFreizeitimmobilieGewerblich().isEmpty()) {
                enum_ = objektkategorie.getObjektart().getFreizeitimmobilieGewerblich().get(0).getFreizeitTyp();
                openEstateType = FreizeitimmobilieGewerblich.FreizeitTyp.SPORTANLAGEN.equals(enum_) ? OpenEstateType.newInstance("SPORTANLAGE") : (FreizeitimmobilieGewerblich.FreizeitTyp.VERGNUEGUNGSPARKS_UND_CENTER.equals(enum_) ? OpenEstateType.newInstance("VERGNUEGUNGSPARK") : OpenEstateType.newInstance("FREIZEIT_SPORT"));
            } else if (!objektkategorie.getObjektart().getGastgewerbe().isEmpty()) {
                enum_ = objektkategorie.getObjektart().getGastgewerbe().get(0).getGastgewTyp();
                openEstateType = Gastgewerbe.GastgewTyp.GASTRONOMIE.equals(enum_) ? OpenEstateType.newInstance("GASTRONOMIE") : (Gastgewerbe.GastgewTyp.GASTRONOMIE_UND_WOHNUNG.equals(enum_) ? OpenEstateType.newInstance("GASTRONOMIE_MIT_WOHNUNG") : (Gastgewerbe.GastgewTyp.HOTELS.equals(enum_) ? OpenEstateType.newInstance("HOTEL") : (Gastgewerbe.GastgewTyp.PENSIONEN.equals(enum_) ? OpenEstateType.newInstance("PENSION") : OpenEstateType.newInstance("GAST"))));
            } else if (!objektkategorie.getObjektart().getGrundstueck().isEmpty()) {
                enum_ = objektkategorie.getObjektart().getGrundstueck().get(0).getGrundstTyp();
                openEstateType = Grundstueck.GrundstTyp.FREIZEIT.equals(enum_) ? OpenEstateType.newInstance("FREIZEITGRUND") : (Grundstueck.GrundstTyp.GEMISCHT.equals(enum_) ? OpenEstateType.newInstance("GEMISCHTGRUND") : (Grundstueck.GrundstTyp.GEWERBE.equals(enum_) ? OpenEstateType.newInstance("GEWERBEGRUND") : (Grundstueck.GrundstTyp.INDUSTRIE.equals(enum_) ? OpenEstateType.newInstance("INDUSTRIEGRUND") : (Grundstueck.GrundstTyp.LAND_FORSTWIRSCHAFT.equals(enum_) ? OpenEstateType.newInstance("LAND_FORSTGRUND") : (Grundstueck.GrundstTyp.SONDERNUTZUNG.equals(enum_) ? OpenEstateType.newInstance("SONDERNUTZUNG") : (Grundstueck.GrundstTyp.WOHNEN.equals(enum_) ? OpenEstateType.newInstance("WOHNGRUND") : OpenEstateType.newInstance("MAIN_GRUND")))))));
            } else if (!objektkategorie.getObjektart().getHallenLagerProd().isEmpty()) {
                enum_ = objektkategorie.getObjektart().getHallenLagerProd().get(0).getHallenTyp();
                openEstateType = HallenLagerProd.HallenTyp.FREIFLAECHEN.equals(enum_) ? OpenEstateType.newInstance("FREIFLAECHE") : (HallenLagerProd.HallenTyp.HALLE.equals(enum_) ? OpenEstateType.newInstance("HALLE_LAGER") : (HallenLagerProd.HallenTyp.HOCHREGALLAGER.equals(enum_) ? OpenEstateType.newInstance("HOCHREGALLAGER") : (HallenLagerProd.HallenTyp.LAGER.equals(enum_) ? OpenEstateType.newInstance("LAGERHALLE") : (HallenLagerProd.HallenTyp.PRODUKTION.equals(enum_) ? OpenEstateType.newInstance("PRODUKTION") : (HallenLagerProd.HallenTyp.SERVICE.equals(enum_) ? OpenEstateType.newInstance("SERVICEFLAECHE") : (HallenLagerProd.HallenTyp.WERKSTATT.equals(enum_) ? OpenEstateType.newInstance("WERKSTATT") : OpenEstateType.newInstance("HALLE_LAGER")))))));
            } else if (!objektkategorie.getObjektart().getHaus().isEmpty()) {
                enum_ = objektkategorie.getObjektart().getHaus().get(0).getHaustyp();
                openEstateType = Haus.Haustyp.BAUERNHAUS.equals(enum_) ? OpenEstateType.newInstance("BAUERNHAUS") : (Haus.Haustyp.BERGHUETTE.equals(enum_) ? OpenEstateType.newInstance("BERGHUETTE") : (Haus.Haustyp.CHALET.equals(enum_) ? OpenEstateType.newInstance("CHALET") : (Haus.Haustyp.DOPPELHAUSHAELFTE.equals(enum_) ? OpenEstateType.newInstance("DOPPELHAUSHAELFTE") : (Haus.Haustyp.EINFAMILIENHAUS.equals(enum_) ? OpenEstateType.newInstance("EFH") : (Haus.Haustyp.FERIENHAUS.equals(enum_) ? OpenEstateType.newInstance("FERIENHAUS") : (Haus.Haustyp.LANDHAUS.equals(enum_) ? OpenEstateType.newInstance("LANDHAUS") : (Haus.Haustyp.LAUBE_DATSCHE_GARTENHAUS.equals(enum_) ? OpenEstateType.newInstance("GARTENHAUS") : (Haus.Haustyp.MEHRFAMILIENHAUS.equals(enum_) ? OpenEstateType.newInstance("MFH") : (Haus.Haustyp.REIHENECK.equals(enum_) ? OpenEstateType.newInstance("REIHENECKHAUS") : (Haus.Haustyp.REIHENEND.equals(enum_) ? OpenEstateType.newInstance("REIHENENDHAUS") : (Haus.Haustyp.REIHENHAUS.equals(enum_) ? OpenEstateType.newInstance("REIHENHAUS") : (Haus.Haustyp.REIHENMITTEL.equals(enum_) ? OpenEstateType.newInstance("REIHENMITTELHAUS") : (Haus.Haustyp.RESTHOF.equals(enum_) ? OpenEstateType.newInstance("RESTHOF") : (Haus.Haustyp.SCHLOSS.equals(enum_) ? OpenEstateType.newInstance("SCHLOSS") : (Haus.Haustyp.STADTHAUS.equals(enum_) ? OpenEstateType.newInstance("STADTHAUS") : (Haus.Haustyp.STRANDHAUS.equals(enum_) ? OpenEstateType.newInstance("STRANDHAUS") : (Haus.Haustyp.VILLA.equals(enum_) ? OpenEstateType.newInstance("VILLA") : (Haus.Haustyp.ZWEIFAMILIENHAUS.equals(enum_) ? OpenEstateType.newInstance("ZFH") : OpenEstateType.newInstance("HAUS")))))))))))))))))));
            } else if (!objektkategorie.getObjektart().getLandUndForstwirtschaft().isEmpty()) {
                enum_ = objektkategorie.getObjektart().getLandUndForstwirtschaft().get(0).getLandTyp();
                openEstateType = LandUndForstwirtschaft.LandTyp.ACKERBAU.equals(enum_) ? OpenEstateType.newInstance("ACKERBAU") : (LandUndForstwirtschaft.LandTyp.AUSSIEDLERHOF.equals(enum_) ? OpenEstateType.newInstance("AUSSIEDLERHOF") : (LandUndForstwirtschaft.LandTyp.BAUERNHOF.equals(enum_) ? OpenEstateType.newInstance("BAUERNHOF") : (LandUndForstwirtschaft.LandTyp.GARTENBAU.equals(enum_) ? OpenEstateType.newInstance("GARTENBAU") : (LandUndForstwirtschaft.LandTyp.JAGD_UND_FORSTWIRTSCHAFT.equals(enum_) ? OpenEstateType.newInstance("JAGD_FORSTWIRTSCHAFT") : (LandUndForstwirtschaft.LandTyp.LANDWIRTSCHAFTLICHE_BETRIEBE.equals(enum_) ? OpenEstateType.newInstance("MAIN_LANDWIRTSCHAFT") : (LandUndForstwirtschaft.LandTyp.REITERHOEFE.equals(enum_) ? OpenEstateType.newInstance("REITERHOF") : (LandUndForstwirtschaft.LandTyp.SCHEUNEN.equals(enum_) ? OpenEstateType.newInstance("SCHEUNEN") : (LandUndForstwirtschaft.LandTyp.SONSTIGE_LANDWIRTSCHAFTSIMMOBILIEN.equals(enum_) ? OpenEstateType.newInstance("MAIN_LANDWIRTSCHAFT") : (LandUndForstwirtschaft.LandTyp.TEICH_UND_FISCHWIRTSCHAFT.equals(enum_) ? OpenEstateType.newInstance("TEICH_FISCHWIRTSCHAFT") : (LandUndForstwirtschaft.LandTyp.VIEHWIRTSCHAFT.equals(enum_) ? OpenEstateType.newInstance("VIEHWIRTSCHAFT") : (LandUndForstwirtschaft.LandTyp.WEINBAU.equals(enum_) ? OpenEstateType.newInstance("WEINBAU") : OpenEstateType.newInstance("MAIN_LANDWIRTSCHAFT"))))))))))));
            } else if (!objektkategorie.getObjektart().getSonstige().isEmpty()) {
                enum_ = objektkategorie.getObjektart().getSonstige().get(0).getSonstigeTyp();
                openEstateType = Sonstige.SonstigeTyp.GARAGEN.equals(enum_) ? OpenEstateType.newInstance("GARAGE") : (Sonstige.SonstigeTyp.PARKFLACHE.equals(enum_) ? OpenEstateType.newInstance("MAIN_STELLPLATZ") : (Sonstige.SonstigeTyp.PARKHAUS.equals(enum_) ? OpenEstateType.newInstance("PARKHAUS") : (Sonstige.SonstigeTyp.SONSTIGE.equals(enum_) ? OpenEstateType.newInstance("BESONDERES_HAUS") : (Sonstige.SonstigeTyp.TANKSTELLE.equals(enum_) ? OpenEstateType.newInstance("TANKSTELLE") : null))));
            } else if (!objektkategorie.getObjektart().getWohnung().isEmpty()) {
                enum_ = objektkategorie.getObjektart().getWohnung().get(0).getWohnungtyp();
                openEstateType = Wohnung.Wohnungtyp.DACHGESCHOSS.equals(enum_) ? OpenEstateType.newInstance("DACHWOHNUNG") : (Wohnung.Wohnungtyp.ERDGESCHOSS.equals(enum_) ? OpenEstateType.newInstance("ERDGESCHOSSWOHNUNG") : (Wohnung.Wohnungtyp.ETAGE.equals(enum_) ? OpenEstateType.newInstance("ETAGENWOHNUNG") : (Wohnung.Wohnungtyp.LOFT_STUDIO_ATELIER.equals(enum_) ? OpenEstateType.newInstance("LOFTWOHNUNG") : (Wohnung.Wohnungtyp.MAISONETTE.equals(enum_) ? OpenEstateType.newInstance("MAISONETTWOHNUNG") : (Wohnung.Wohnungtyp.PENTHOUSE.equals(enum_) ? OpenEstateType.newInstance("PENTHOUSEWOHNUNG") : (Wohnung.Wohnungtyp.SOUTERRAIN.equals(enum_) ? OpenEstateType.newInstance("SOUTERRAINWOHNUNG") : (Wohnung.Wohnungtyp.TERRASSEN.equals(enum_) ? OpenEstateType.newInstance("TERRASSENWOHNUNG") : OpenEstateType.newInstance("WOHNUNG"))))))));
            } else if (!objektkategorie.getObjektart().getZimmer().isEmpty()) {
                enum_ = objektkategorie.getObjektart().getZimmer().get(0).getZimmertyp();
                openEstateType = OpenEstateType.newInstance("ZIMMER");
            } else if (!objektkategorie.getObjektart().getZinshausRenditeobjekt().isEmpty()) {
                enum_ = objektkategorie.getObjektart().getZinshausRenditeobjekt().get(0).getZinsTyp();
                openEstateType = ZinshausRenditeobjekt.ZinsTyp.BUEROGEBAEUDE.equals(enum_) ? OpenEstateType.newInstance("BUEROHAUS") : (ZinshausRenditeobjekt.ZinsTyp.EINKAUFSCENTREN.equals(enum_) ? OpenEstateType.newInstance("EINKAUFSZENTRUM") : (ZinshausRenditeobjekt.ZinsTyp.GESCHAEFTSHAUS.equals(enum_) ? OpenEstateType.newInstance("GESCHAEFTSHAUS") : (ZinshausRenditeobjekt.ZinsTyp.INDUSTRIEANLAGEN.equals(enum_) ? OpenEstateType.newInstance("INDUSTRIEANLAGE") : (ZinshausRenditeobjekt.ZinsTyp.MEHRFAMILIENHAUS.equals(enum_) ? OpenEstateType.newInstance("MFH_GEWERBE") : (ZinshausRenditeobjekt.ZinsTyp.SB_MAERKTE.equals(enum_) ? OpenEstateType.newInstance("SB_MARKT") : (ZinshausRenditeobjekt.ZinsTyp.VERBRAUCHERMAERKTE.equals(enum_) ? OpenEstateType.newInstance("VERBRAUCHERMARKT") : (ZinshausRenditeobjekt.ZinsTyp.WOHNANLAGEN.equals(enum_) ? OpenEstateType.newInstance("WOHNANLAGE") : (ZinshausRenditeobjekt.ZinsTyp.WOHN_UND_GESCHAEFTSHAUS.equals(enum_) ? OpenEstateType.newInstance("WOHN_GESCHAEFTSHAUS") : OpenEstateType.newInstance("MFH_GEWERBE")))))))));
            }
            if (objektkategorie.getNutzungsart() != null) {
                if (openEstateType == null && Boolean.TRUE.equals(objektkategorie.getNutzungsart().isANLAGE())) {
                    openEstateType = OpenEstateType.newInstance("MAIN_GEWERBE");
                }
                if (openEstateType == null && Boolean.TRUE.equals(objektkategorie.getNutzungsart().isGEWERBE())) {
                    openEstateType = OpenEstateType.newInstance("MAIN_GEWERBE");
                }
                if (openEstateType == null && Boolean.TRUE.equals(objektkategorie.getNutzungsart().isWOHNEN())) {
                    openEstateType = OpenEstateType.newInstance("MAIN_WOHNEN");
                }
            }
            if (openEstateType == null) {
                throw new Exception("could not find a matching estate-type!");
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load estate-type!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            throw new OpenEstateException("could not load estate-type: " + exception.getLocalizedMessage(), exception);
        }
        if (objektkategorie.getVermarktungsart() == null) {
            string = null;
        } else if (Boolean.TRUE.equals(objektkategorie.getVermarktungsart().isERBPACHT())) {
            string = "ERBPACHT";
        } else if (Boolean.TRUE.equals(objektkategorie.getVermarktungsart().isKAUF())) {
            string = "KAUF";
        } else if (Boolean.TRUE.equals(objektkategorie.getVermarktungsart().isMIETEPACHT())) {
            boolean bl;
            boolean bl2 = Boolean.TRUE.equals(objektkategorie.getNutzungsart().isWAZ());
            boolean bl3 = bl = preise != null && preise.getPacht() != null && preise.getPacht().doubleValue() > 0.0;
            string = bl2 && openEstateType.hasAction("WAZ") ? "WAZ" : (bl && openEstateType.hasAction("PACHT") ? "PACHT" : "MIETE");
        }
        if (string == null && preise != null) {
            BigDecimal bigDecimal = preise.getKaufpreis();
            BigDecimal bigDecimal2 = preise.getPacht();
            BigDecimal bigDecimal3 = preise.getKaltmiete();
            if (bigDecimal3 == null) {
                bigDecimal3 = preise.getWarmmiete();
            }
            if (bigDecimal3 == null) {
                bigDecimal3 = preise.getNettokaltmiete();
            }
            if (bigDecimal != null && bigDecimal.doubleValue() > 0.0) {
                string = "KAUF";
            } else if (bigDecimal3 != null && bigDecimal3.doubleValue() > 0.0) {
                string = "MIETE";
            } else if (bigDecimal2 != null && bigDecimal2.doubleValue() > 0.0) {
                string = "PACHT";
            }
        }
        if (string == null) {
            throw new IllegalArgumentException("Can't find an estate-action!");
        }
        if (!openEstateType.hasAction(string)) {
            throw new IllegalArgumentException("The estate-type '" + openEstateType.getName() + "' does not suppert estate-action '" + string + "'!");
        }
        estateImpl.setType(openEstateType, string);
        if (objektkategorie.getNutzungsart() != null) {
            if (Boolean.TRUE.equals(objektkategorie.getNutzungsart().isANLAGE())) {
                this.putEstateValue("VERWALTUNG", "NUTZUNGSART", "ANLAGE", estateImpl);
            }
            if (Boolean.TRUE.equals(objektkategorie.getNutzungsart().isGEWERBE())) {
                this.putEstateValue("VERWALTUNG", "NUTZUNGSART", "GEWERBE", estateImpl);
            }
            if (Boolean.TRUE.equals(objektkategorie.getNutzungsart().isWOHNEN())) {
                this.putEstateValue("VERWALTUNG", "NUTZUNGSART", "WOHNEN", estateImpl);
            }
        }
    }

    protected void readImmobiliePreise(Preise preise, Ausstattung ausstattung, EstateImpl estateImpl) {
        Object object;
        if (preise == null) {
            return;
        }
        this.putEstateValue("PREISE", "ABSTAND", preise.getAbstand(), estateImpl);
        if (preise.getAussenCourtage() != null) {
            this.putEstateValue("PREISE", "COURTAGE_AUSSEN", preise.getAussenCourtage().getContent(), estateImpl);
            this.putEstateValue("PREISE", "COURTAGE_AUSSEN_TAX", preise.getAussenCourtage().isMitMwst(), estateImpl);
        }
        this.putEstateValue("PREISE", "ERBPACHT_ZINS", preise.getErbpacht(), estateImpl);
        this.putEstateValue("PREISE", "ERSCHLIESSUNGSKOSTEN", preise.getErschliessungskosten(), estateImpl);
        this.putEstateValue("FREITEXTE", "PREIS_BESCHR", preise.getFreitextPreis(), estateImpl);
        this.putEstateValue("PREISE", "GESCHAEFTSGUTHABEN", preise.getGeschaeftsguthaben(), estateImpl);
        this.putEstateValue("PREISE", "HAUSGELD", preise.getHausgeld(), estateImpl);
        this.putEstateValue("PREISE", "HEIZKOSTEN", preise.getHeizkosten(), estateImpl);
        if (preise.getInnenCourtage() != null) {
            this.putEstateValue("PREISE", "COURTAGE_INNEN", preise.getInnenCourtage().getContent(), estateImpl);
            this.putEstateValue("PREISE", "COURTAGE_INNEN_TAX", preise.getInnenCourtage().isMitMwst(), estateImpl);
        }
        this.putEstateValue("PREISE", "KALTMIETE", preise.getKaltmiete(), estateImpl);
        this.putEstateValue("PREISE", "KAUFPREIS", preise.getKaufpreis(), estateImpl);
        this.putEstateValue("PREISE", "KAUFPREIS_QM", preise.getKaufpreisProQm(), estateImpl);
        this.putEstateValue("PREISE", "KAUTION_BETRAG", preise.getKaution(), estateImpl);
        if (preise.getMieteinnahmenIst() != null) {
            this.putEstateValue("PREISE", "MIETEINNAHMEN_IST", Float.valueOf(preise.getMieteinnahmenIst().floatValue()), estateImpl);
        }
        if (preise.getMieteinnahmenSoll() != null) {
            this.putEstateValue("PREISE", "MIETEINNAHMEN_SOLL", Float.valueOf(preise.getMieteinnahmenSoll().floatValue()), estateImpl);
        }
        this.putEstateValue("PREISE", "KALTMIETE_QM", preise.getMietpreisProQm(), estateImpl);
        this.putEstateValue("PREISE", "MIETZUSCHLAEGE", preise.getMietzuschlaege(), estateImpl);
        this.putEstateValue("PREISE", "MWST", preise.getMwstSatz(), estateImpl);
        this.putEstateValue("PREISE", "NEBENKOSTEN", preise.getNebenkosten(), estateImpl);
        this.putEstateValue("PREISE", "KALTMIETE_NETTO", preise.getNettokaltmiete(), estateImpl);
        this.putEstateValue("PREISE", "NETTORENDITE", preise.getNettorendite(), estateImpl);
        this.putEstateValue("PREISE", "PACHT", preise.getPacht(), estateImpl);
        if (preise.getPreisZeiteinheit() != null && preise.getPreisZeiteinheit().getZeiteinheit() != null) {
            if ("WAZ".equals(estateImpl.getAction())) {
                this.putEstateValue("PREISE", "MIETE_PRO", preise.getPreisZeiteinheit().getZeiteinheit().toString(), estateImpl);
            } else {
                this.putEstateValue("VERWALTUNG", "PREIS_ZEITEINHEIT", preise.getPreisZeiteinheit().getZeiteinheit().toString(), estateImpl);
            }
        }
        this.putEstateValue("VERWALTUNG", "PREIS_ZEITRAUM_BIS", preise.getPreisZeitraumBis(), estateImpl);
        this.putEstateValue("VERWALTUNG", "PREIS_ZEITRAUM_VON", preise.getPreisZeitraumVon(), estateImpl);
        Stellplatz object2 = null;
        if (object2 == null && ausstattung != null && ausstattung.getStellplatzart() != null) {
            for (Stellplatzart object3 : ausstattung.getStellplatzart()) {
                if (Boolean.TRUE.equals(object3.isCARPORT())) {
                    object2 = preise.getStpCarport();
                } else if (Boolean.TRUE.equals(object3.isDUPLEX())) {
                    object2 = preise.getStpDuplex();
                } else if (Boolean.TRUE.equals(object3.isFREIPLATZ())) {
                    object2 = preise.getStpFreiplatz();
                } else if (Boolean.TRUE.equals(object3.isGARAGE())) {
                    object2 = preise.getStpGarage();
                } else if (Boolean.TRUE.equals(object3.isPARKHAUS())) {
                    object2 = preise.getStpParkhaus();
                } else if (Boolean.TRUE.equals(object3.isTIEFGARAGE())) {
                    object2 = preise.getStpTiefgarage();
                }
                if (object2 != null && object2.getStellplatzkaufpreis() == null && object2.getStellplatzmiete() == null) {
                    object2 = null;
                }
                if (object2 == null) continue;
                break;
            }
        }
        if (object2 == null) {
            for (StpSonstige stpSonstige : preise.getStpSonstige()) {
                object2 = stpSonstige;
                if (object2 != null && object2.getStellplatzkaufpreis() == null && object2.getStellplatzmiete() == null) {
                    object2 = null;
                }
                if (object2 == null) continue;
                break;
            }
        }
        if (object2 != null) {
            if ("MIETE".equals(estateImpl.getAction()) || "WAZ".equals(estateImpl.getAction())) {
                this.putEstateValue("PREISE", "STELLPLATZ_MIETE", object2.getStellplatzmiete(), estateImpl);
            } else {
                this.putEstateValue("PREISE", "STELLPLATZ_PREIS", object2.getStellplatzkaufpreis(), estateImpl);
            }
        }
        if ("WAZ".equals(estateImpl.getAction())) {
            this.putEstateValue("PREISE", "PAUSCHALMIETE", preise.getWarmmiete(), estateImpl);
        } else {
            this.putEstateValue("PREISE", "WARMMIETE", preise.getWarmmiete(), estateImpl);
        }
        try {
            object = preise.getXFache();
            if (!StringUtils.isBlank((String)object)) {
                this.putEstateValue("PREISE", "X_FACHE", Float.valueOf(((String)object).trim()), estateImpl);
            }
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn((Object)("Can't convert 'XFache' (" + preise.getXFache() + ") into an integer!"));
            LOGGER.warn((Object)("> " + numberFormatException.getLocalizedMessage()), (Throwable)numberFormatException);
        }
        this.putEstateValue("PREISE", "ZZG_MEHRWERTSTEUER", preise.isZzgMehrwertsteuer(), estateImpl);
        if (preise.getWaehrung() != null && preise.getWaehrung().getIsoWaehrung() != null) {
            object = preise.getWaehrung().getIsoWaehrung();
            try {
                Currency currency = Currency.getInstance((String)object);
                if (currency == null) {
                    LOGGER.warn((Object)("unknown currency-code: " + (String)object));
                } else {
                    estateImpl.setCurrency(currency);
                }
            }
            catch (Exception exception) {
                LOGGER.warn((Object)("invalid currency-code: " + (String)object));
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
    }

    protected void readImmobilieVerwaltungObjekt(VerwaltungObjekt verwaltungObjekt, EstateImpl estateImpl) {
        if (verwaltungObjekt == null) {
            return;
        }
        this.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABDATE", verwaltungObjekt.getAbdatum(), estateImpl);
        this.putEstateValue("VERWALTUNG", "ALS_FERIEN", verwaltungObjekt.isAlsFerien(), estateImpl);
        this.putEstateValue("VERWALTUNG", "VERFUEGBAR_BISDATE", verwaltungObjekt.getBisdatum(), estateImpl);
        this.putEstateValue("VERWALTUNG", "BRANCHEN", verwaltungObjekt.getBranchen(), estateImpl);
        this.putEstateValue("VERWALTUNG", "DENKMALGESCHUETZT", verwaltungObjekt.isDenkmalgeschuetzt(), estateImpl);
        this.putEstateValue("VERWALTUNG", "HOCHHAUS", verwaltungObjekt.isHochhaus(), estateImpl);
        this.putEstateValue("VERWALTUNG", "ERBPACHT_DAUER", verwaltungObjekt.getLaufzeit(), estateImpl);
        this.putEstateValue("VERWALTUNG", "MAX_PERSONEN", verwaltungObjekt.getMaxPersonen(), estateImpl);
        estateImpl.getAdress().setAdressPublished(Boolean.TRUE.equals(verwaltungObjekt.isObjektadresseFreigeben()));
        this.putEstateValue("VERWALTUNG", "VERFUEGBAR_ABTEXT", verwaltungObjekt.getVerfuegbarAb(), estateImpl);
        this.putEstateValue("VERWALTUNG", "VERMIETET", verwaltungObjekt.isVermietet(), estateImpl);
        this.putEstateValue("VERWALTUNG", "VERSTEIGERUNGSTERMIN", verwaltungObjekt.getVersteigerungstermin(), estateImpl);
        this.putEstateValue("VERWALTUNG", "WBS_SOZIALWOHNUNG", verwaltungObjekt.isWbsSozialwohnung(), estateImpl);
        this.putEstateValue("VERWALTUNG", "ZUGANG_AB", verwaltungObjekt.getZugang(), estateImpl);
        if (verwaltungObjekt.getGeschlecht() != null && verwaltungObjekt.getGeschlecht().getGeschlAttr() != null) {
            Geschlecht.GeschlAttr geschlAttr = verwaltungObjekt.getGeschlecht().getGeschlAttr();
            if (Geschlecht.GeschlAttr.EGAL.equals((Object)geschlAttr)) {
                this.putEstateValue("VERWALTUNG", "GESCHLECHT", "EGAL", estateImpl);
            } else if (Geschlecht.GeschlAttr.NUR_FRAU.equals((Object)geschlAttr)) {
                this.putEstateValue("VERWALTUNG", "GESCHLECHT", "FRAU", estateImpl);
            } else if (Geschlecht.GeschlAttr.NUR_MANN.equals((Object)geschlAttr)) {
                this.putEstateValue("VERWALTUNG", "GESCHLECHT", "MANN", estateImpl);
            }
        }
        if (Boolean.TRUE.equals(verwaltungObjekt.isGewerblicheNutzung())) {
            this.putEstateValue("VERWALTUNG", "GEWERBLICHE_NUTZUNG", "JA", estateImpl);
        } else if (Boolean.FALSE.equals(verwaltungObjekt.isGewerblicheNutzung())) {
            this.putEstateValue("VERWALTUNG", "GEWERBLICHE_NUTZUNG", "NEIN", estateImpl);
        }
        if (Boolean.TRUE.equals(verwaltungObjekt.isHaustiere())) {
            this.putEstateValue("VERWALTUNG", "HAUSTIERE", "JA", estateImpl);
        } else if (Boolean.FALSE.equals(verwaltungObjekt.isHaustiere())) {
            this.putEstateValue("VERWALTUNG", "HAUSTIERE", "NEIN", estateImpl);
        }
        if (Boolean.TRUE.equals(verwaltungObjekt.isNichtraucher())) {
            this.putEstateValue("VERWALTUNG", "NICHTRAUCHER", "JA", estateImpl);
        } else if (Boolean.FALSE.equals(verwaltungObjekt.isNichtraucher())) {
            this.putEstateValue("VERWALTUNG", "NICHTRAUCHER", "NEIN", estateImpl);
        }
    }

    protected void readImmobilieVerwaltungTechn(VerwaltungTechn verwaltungTechn, EstateImpl estateImpl) {
        if (verwaltungTechn == null) {
            return;
        }
        estateImpl.setPublishEnd(verwaltungTechn.getAktivBis() != null ? verwaltungTechn.getAktivBis().getTime() : null);
        estateImpl.setPublishBegin(verwaltungTechn.getAktivVon() != null ? verwaltungTechn.getAktivVon().getTime() : null);
        estateImpl.setId(verwaltungTechn.getObjektnrIntern());
        estateImpl.setPublicId(verwaltungTechn.getObjektnrExtern());
        this.putEstateValue("VERWALTUNG", "STAND_VOM", verwaltungTechn.getStandVom(), estateImpl);
        this.putEstateValue("VERWALTUNG", "WEITERGABE_GENERELL", verwaltungTechn.isWeitergabeGenerell(), estateImpl);
        this.putEstateValue("VERWALTUNG", "WEITERGABE_NEGATIV", verwaltungTechn.getWeitergabeNegativ(), estateImpl);
        this.putEstateValue("VERWALTUNG", "WEITERGABE_POSITIV", verwaltungTechn.getWeitergabePositiv(), estateImpl);
        if (verwaltungTechn.getAktion() != null && verwaltungTechn.getAktion().getAktionart() != null) {
            estateImpl.getCustomValues().putCustomValue("immoxml.aktion", verwaltungTechn.getAktion().getAktionart().value(), 5);
        } else {
            estateImpl.getCustomValues().putCustomValue("immoxml.aktion", Aktion.AktionArt.CHANGE.value(), 5);
        }
        if (verwaltungTechn.getKennungUrsprung() != null) {
            estateImpl.getCustomValues().putCustomValue("immoxml.kennung_ursprung", verwaltungTechn.getKennungUrsprung(), 5);
        }
        if (verwaltungTechn.getImmoxmlObid() != null) {
            estateImpl.getCustomValues().putCustomValue("immoxml.immoxml_obid", verwaltungTechn.getImmoxmlObid(), 5);
        }
    }

    protected void readImmobilieWeitereAdresse(Immobilie immobilie, EstateImpl estateImpl) {
        throw new UnsupportedOperationException("not implemented yet!");
    }

    protected void readImmobilieZustandAngaben(ZustandAngaben zustandAngaben, EstateImpl estateImpl) {
        Object object;
        Object object2;
        if (zustandAngaben == null) {
            return;
        }
        this.putEstateValue("ZUSTAND", "ALTLASTEN", zustandAngaben.getAltlasten(), estateImpl);
        try {
            object2 = zustandAngaben.getBaujahr();
            if (!StringUtils.isBlank((String)object2)) {
                this.putEstateValue("ZUSTAND", "BAUJAHR", Integer.valueOf(object2.trim()), estateImpl);
            }
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn((Object)("Can't convert 'Baujahr' (" + zustandAngaben.getBaujahr() + ") into an integer!"));
            LOGGER.warn((Object)("> " + numberFormatException.getLocalizedMessage()), (Throwable)numberFormatException);
        }
        if (zustandAngaben.getAlter() != null && zustandAngaben.getAlter().getAlterAttr() != null && (object2 = zustandAngaben.getAlter().getAlterAttr()) != null) {
            if (Alter.AlterAttr.ALTBAU.equals(object2)) {
                this.putEstateValue("ZUSTAND", "ALTER", "ALTBAU", estateImpl);
            } else if (Alter.AlterAttr.NEUBAU.equals(object2)) {
                this.putEstateValue("ZUSTAND", "ALTER", "NEUBAU", estateImpl);
            }
        }
        if (zustandAngaben.getBebaubarNach() != null && zustandAngaben.getBebaubarNach().getBebaubarAttr() != null) {
            object2 = zustandAngaben.getBebaubarNach().getBebaubarAttr();
            if (BebaubarNach.BebaubarAttr.NACHBARSCHAFT.equals(object2)) {
                this.putEstateValue("VERWALTUNG", "BEBAUBAR_NACH", "NACHBARBEBAUUNG", estateImpl);
            } else if (BebaubarNach.BebaubarAttr.AUSSENGEBIET.equals(object2)) {
                this.putEstateValue("VERWALTUNG", "BEBAUBAR_NACH", "AUSSENGEBIET", estateImpl);
            } else if (BebaubarNach.BebaubarAttr.BAUERWARTUNGSLAND.equals(object2)) {
                this.putEstateValue("VERWALTUNG", "BEBAUBAR_NACH", "BAUERWARTUNGSLAND", estateImpl);
            } else if (BebaubarNach.BebaubarAttr.B_PLAN.equals(object2)) {
                this.putEstateValue("VERWALTUNG", "BEBAUBAR_NACH", "BEBAUUNGSPLAN", estateImpl);
            } else if (BebaubarNach.BebaubarAttr.KEIN_BAULAND.equals(object2)) {
                this.putEstateValue("VERWALTUNG", "BEBAUBAR_NACH", "KEIN_BAULAND", estateImpl);
            }
        }
        if (zustandAngaben.getErschliessung() != null && zustandAngaben.getErschliessung().getErschlAttr() != null) {
            object2 = zustandAngaben.getErschliessung().getErschlAttr();
            if (Erschliessung.ErschlAttr.TEILERSCHLOSSEN.equals(object2)) {
                this.putEstateValue("ZUSTAND", "ERSCHLIESSUNG", "TEILERSCHLOSSEN", estateImpl);
            } else if (Erschliessung.ErschlAttr.UNERSCHLOSSEN.equals(object2)) {
                this.putEstateValue("ZUSTAND", "ERSCHLIESSUNG", "UNERSCHLOSSEN", estateImpl);
            } else if (Erschliessung.ErschlAttr.VOLLERSCHLOSSEN.equals(object2)) {
                this.putEstateValue("ZUSTAND", "ERSCHLIESSUNG", "VOLLERSCHLOSSEN", estateImpl);
            }
        }
        if (zustandAngaben.getZustand() != null && zustandAngaben.getZustand().getZustandArt() != null) {
            object2 = zustandAngaben.getZustand().getZustandArt();
            if (Zustand.ZustandArt.ABRISSOBJEKT.equals(object2)) {
                this.putEstateValue("ZUSTAND", "ZUSTAND", "ABRISSOBJEKT", estateImpl);
            } else if (Zustand.ZustandArt.BAUFAELLIG.equals(object2)) {
                this.putEstateValue("ZUSTAND", "ZUSTAND", "BAUFAELLIG", estateImpl);
            } else if (Zustand.ZustandArt.ENTKERNT.equals(object2)) {
                this.putEstateValue("ZUSTAND", "ZUSTAND", "ENTKERNT", estateImpl);
            } else if (Zustand.ZustandArt.ERSTBEZUG.equals(object2)) {
                this.putEstateValue("ZUSTAND", "ZUSTAND", "ERSTBEZUG", estateImpl);
            } else if (Zustand.ZustandArt.GEPFLEGT.equals(object2)) {
                this.putEstateValue("ZUSTAND", "ZUSTAND", "GEPFLEGT", estateImpl);
            } else if (Zustand.ZustandArt.MODERNISIERT.equals(object2)) {
                this.putEstateValue("ZUSTAND", "ZUSTAND", "MODERNISIERT", estateImpl);
            } else if (Zustand.ZustandArt.NACH_VEREINBARUNG.equals(object2)) {
                this.putEstateValue("ZUSTAND", "ZUSTAND", "NACH_VEREINBARUNG", estateImpl);
            } else if (Zustand.ZustandArt.NEUWERTIG.equals(object2)) {
                this.putEstateValue("ZUSTAND", "ZUSTAND", "NEUWERTIG", estateImpl);
            } else if (Zustand.ZustandArt.PROJEKTIERT.equals(object2)) {
                this.putEstateValue("ZUSTAND", "ZUSTAND", "PROJEKTIERT", estateImpl);
            } else if (Zustand.ZustandArt.ROHBAU.equals(object2)) {
                this.putEstateValue("ZUSTAND", "ZUSTAND", "ROHBAU", estateImpl);
            } else if (Zustand.ZustandArt.TEIL_VOLLRENOVIERT.equals(object2)) {
                this.putEstateValue("ZUSTAND", "ZUSTAND", "RENOVIERT_TEIL", estateImpl);
            } else if (Zustand.ZustandArt.TEIL_VOLLRENOVIERUNGSBED.equals(object2)) {
                this.putEstateValue("ZUSTAND", "ZUSTAND", "RENOVIERUNGSBEDARF_TEIL", estateImpl);
            } else if (Zustand.ZustandArt.TEIL_VOLLSANIERT.equals(object2)) {
                this.putEstateValue("ZUSTAND", "ZUSTAND", "SANIERT_TEIL", estateImpl);
            }
        }
        object2 = null;
        for (UserDefinedSimplefield userDefinedSimplefield : zustandAngaben.getUserDefinedSimplefield()) {
            if (!"epass_epart".equalsIgnoreCase(userDefinedSimplefield.getFeldname())) continue;
            object = StringUtils.trimToNull((String)userDefinedSimplefield.getContent());
            if ("bedarf".equalsIgnoreCase((String)object)) {
                object2 = "BEDARF";
                break;
            }
            if (!"verbrauch".equalsIgnoreCase((String)object)) break;
            object2 = "VERBRAUCH";
            break;
        }
        if (object2 != null) {
            this.putEstateValue("ENERGIEPASS", "ART", object2, estateImpl);
            for (UserDefinedSimplefield userDefinedSimplefield : zustandAngaben.getUserDefinedSimplefield()) {
                Object object3;
                if ("epass_endenergiebedarf".equalsIgnoreCase(userDefinedSimplefield.getFeldname())) {
                    if (!"BEDARF".equals(object2)) continue;
                    object = StringUtils.trimToNull((String)userDefinedSimplefield.getContent());
                    object3 = null;
                    try {
                        if (object != null) {
                            object = ((String)object).replace(',', '.');
                        }
                        object3 = object != null ? Double.valueOf((String)object) : null;
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.warn((Object)("Can't convert 'epass_endenergiebedarf' (" + (String)object + ") into a number!"));
                        LOGGER.warn((Object)("> " + numberFormatException.getLocalizedMessage()), (Throwable)numberFormatException);
                    }
                    if (object3 == null || (Double)object3 <= 0.0) continue;
                    this.putEstateValue("ENERGIEPASS", "BEDARF_GESAMT", object3, estateImpl);
                    continue;
                }
                if ("epass_energieverbrauchkennwert".equalsIgnoreCase(userDefinedSimplefield.getFeldname())) {
                    if (!"VERBRAUCH".equals(object2)) continue;
                    object = StringUtils.trimToNull((String)userDefinedSimplefield.getContent());
                    object3 = null;
                    try {
                        if (object != null) {
                            object = ((String)object).replace(',', '.');
                        }
                        object3 = object != null ? Double.valueOf((String)object) : null;
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.warn((Object)("Can't convert 'epass_energieverbrauchkennwert' (" + (String)object + ") into a number!"));
                        LOGGER.warn((Object)("> " + numberFormatException.getLocalizedMessage()), (Throwable)numberFormatException);
                    }
                    if (object3 == null || (Double)object3 <= 0.0) continue;
                    this.putEstateValue("ENERGIEPASS", "VERBRAUCH_GESAMT", object3, estateImpl);
                    continue;
                }
                if ("epass_stromwert".equalsIgnoreCase(userDefinedSimplefield.getFeldname())) {
                    object = StringUtils.trimToNull((String)userDefinedSimplefield.getContent());
                    object3 = null;
                    try {
                        if (object != null) {
                            object = ((String)object).replace(',', '.');
                        }
                        object3 = object != null ? Double.valueOf((String)object) : null;
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.warn((Object)("Can't convert 'epass_stromwert' (" + (String)object + ") into a number!"));
                        LOGGER.warn((Object)("> " + numberFormatException.getLocalizedMessage()), (Throwable)numberFormatException);
                    }
                    if (object3 == null || (Double)object3 <= 0.0) continue;
                    if ("BEDARF".equals(object2)) {
                        this.putEstateValue("ENERGIEPASS", "BEDARF_STROM", object3, estateImpl);
                        continue;
                    }
                    if (!"VERBRAUCH".equals(object2)) continue;
                    this.putEstateValue("ENERGIEPASS", "VERBRAUCH_STROM", object3, estateImpl);
                    continue;
                }
                if ("epass_waermewert".equalsIgnoreCase(userDefinedSimplefield.getFeldname())) {
                    object = StringUtils.trimToNull((String)userDefinedSimplefield.getContent());
                    object3 = null;
                    try {
                        if (object != null) {
                            object = ((String)object).replace(',', '.');
                        }
                        object3 = object != null ? Double.valueOf((String)object) : null;
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.warn((Object)("Can't convert 'epass_waermewert' (" + (String)object + ") into a number!"));
                        LOGGER.warn((Object)("> " + numberFormatException.getLocalizedMessage()), (Throwable)numberFormatException);
                    }
                    if (object3 == null || (Double)object3 <= 0.0) continue;
                    if ("BEDARF".equals(object2)) {
                        this.putEstateValue("ENERGIEPASS", "BEDARF_HEIZUNG", object3, estateImpl);
                        continue;
                    }
                    if (!"VERBRAUCH".equals(object2)) continue;
                    this.putEstateValue("ENERGIEPASS", "VERBRAUCH_HEIZUNG", object3, estateImpl);
                    continue;
                }
                if ("epass_wertklasse".equalsIgnoreCase(userDefinedSimplefield.getFeldname())) {
                    object = StringUtils.trimToNull((String)userDefinedSimplefield.getContent());
                    object3 = null;
                    if ("a+".equalsIgnoreCase((String)object)) {
                        object3 = "A_PLUS";
                    } else if ("a".equalsIgnoreCase((String)object)) {
                        object3 = "A";
                    } else if ("b".equalsIgnoreCase((String)object)) {
                        object3 = "B";
                    } else if ("c".equalsIgnoreCase((String)object)) {
                        object3 = "C";
                    } else if ("d".equalsIgnoreCase((String)object)) {
                        object3 = "D";
                    } else if ("e".equalsIgnoreCase((String)object)) {
                        object3 = "E";
                    } else if ("f".equalsIgnoreCase((String)object)) {
                        object3 = "F";
                    } else if ("g".equalsIgnoreCase((String)object)) {
                        object3 = "G";
                    } else if ("h".equalsIgnoreCase((String)object)) {
                        object3 = "H";
                    }
                    if (object3 == null) continue;
                    this.putEstateValue("ENERGIEPASS", "KLASSE", object3, estateImpl);
                    continue;
                }
                if ("epass_baujahr".equalsIgnoreCase(userDefinedSimplefield.getFeldname())) {
                    object = this.getEstateValueAsInteger("ZUSTAND", "BAUJAHR", estateImpl);
                    if (object != null && (Integer)object > 0) continue;
                    object3 = StringUtils.trimToNull((String)userDefinedSimplefield.getContent());
                    try {
                        if (object3 != null) {
                            object = Integer.valueOf((String)object3);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.warn((Object)("Can't convert 'epass_baujahr' (" + (String)object3 + ") into an integer!"));
                        LOGGER.warn((Object)("> " + numberFormatException.getLocalizedMessage()), (Throwable)numberFormatException);
                    }
                    if (object == null || (Integer)object <= 0) continue;
                    this.putEstateValue("ZUSTAND", "BAUJAHR", object, estateImpl);
                    continue;
                }
                if ("epass_mitwarmwasser".equalsIgnoreCase(userDefinedSimplefield.getFeldname())) {
                    if (!"VERBRAUCH".equals(object2)) continue;
                    object = StringUtils.trimToNull((String)userDefinedSimplefield.getContent());
                    object3 = null;
                    try {
                        object3 = "0".equalsIgnoreCase((String)object) ? Boolean.valueOf(false) : ("1".equalsIgnoreCase((String)object) ? Boolean.valueOf(true) : (object != null ? Boolean.valueOf((String)object) : null));
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.warn((Object)("Can't convert 'epass_mitwarmwasser' (" + (String)object + ") into a boolean!"));
                        LOGGER.warn((Object)("> " + numberFormatException.getLocalizedMessage()), (Throwable)numberFormatException);
                    }
                    if (object3 == null) continue;
                    this.putEstateValue("ENERGIEPASS", "VERBRAUCH_INKL_WARMWASSER", object3, estateImpl);
                    continue;
                }
                if (!"epass_gueltig_bis".equalsIgnoreCase(userDefinedSimplefield.getFeldname())) continue;
                object = StringUtils.trimToNull((String)userDefinedSimplefield.getContent());
                object3 = null;
                try {
                    object3 = OpenEstateUtils.parseDate(userDefinedSimplefield.getContent());
                }
                catch (ParseException parseException) {
                    LOGGER.warn((Object)("Can't convert 'epass_gueltig_bis' (" + (String)object + ") into a date!"));
                    LOGGER.warn((Object)("> " + parseException.getLocalizedMessage()), (Throwable)parseException);
                }
                if (object3 == null) continue;
                this.putEstateValue("ENERGIEPASS", "ABLAUF_DATUM", object3, estateImpl);
            }
        }
    }

    public TransferImpl readTransfer(Immoxml immoxml) {
        this.getErrorMap().clear();
        if (immoxml.getAnbieter().isEmpty()) {
            throw new IllegalArgumentException("anbieter is missing!");
        }
        Uebertragung uebertragung = immoxml.getUebertragung();
        TransferImpl transferImpl = new TransferImpl();
        transferImpl.setSenderSoftwareMail(uebertragung != null ? StringUtils.trimToEmpty((String)uebertragung.getTechnEmail()) : "");
        transferImpl.setSenderSoftwareName(uebertragung != null ? StringUtils.trimToEmpty((String)uebertragung.getSendersoftware()) : "");
        transferImpl.setSenderSoftwareVersion(uebertragung != null ? StringUtils.trimToEmpty((String)uebertragung.getVersion()) : "");
        for (Anbieter anbieter : immoxml.getAnbieter()) {
            TransferAgencyImpl transferAgencyImpl = new TransferAgencyImpl();
            transferAgencyImpl.setRemoveUnmodifiedEstates(uebertragung != null && Uebertragung.Umfang.VOLL.equals((Object)uebertragung.getUmfang()));
            AgentImpl agentImpl = this.convertAnbieter(anbieter);
            agentImpl.setId("Agent." + (transferImpl.getAgencies().size() + 1));
            transferAgencyImpl.setAgent(agentImpl);
            HashMap<String, AgentContactImpl> hashMap = new HashMap<String, AgentContactImpl>();
            for (Immobilie immobilie : anbieter.getImmobilie()) {
                EstateImpl estateImpl;
                if (immobilie.getVerwaltungTechn() != null) {
                    boolean bl;
                    boolean bl2 = bl = immobilie.getVerwaltungTechn().getAktion() != null && Aktion.AktionArt.DELETE.equals((Object)immobilie.getVerwaltungTechn().getAktion().getAktionart());
                    if (bl) {
                        String string = StringUtils.trimToNull((String)immobilie.getVerwaltungTechn().getObjektnrIntern());
                        if (string == null) {
                            string = StringUtils.trimToNull((String)immobilie.getVerwaltungTechn().getImmoxmlObid());
                        }
                        if (string == null) {
                            string = StringUtils.trimToNull((String)immobilie.getVerwaltungTechn().getObjektnrExtern());
                        }
                        if (string == null) {
                            LOGGER.warn((Object)"Can't read estate-id for deletion!");
                            continue;
                        }
                        if (transferAgencyImpl.getEstateIdsToRemove().contains(string)) {
                            LOGGER.warn((Object)"Estate-id for deletion is defined more then once!");
                            continue;
                        }
                        transferAgencyImpl.getEstateIdsToRemove().add(string);
                        continue;
                    }
                }
                if ((estateImpl = this.convertImmobilie(immobilie, hashMap)) == null) continue;
                transferAgencyImpl.getEstatesToSave().add(estateImpl);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                transferAgencyImpl.getContacts().put((String)entry.getKey(), (AgentContactImpl)entry.getValue());
            }
            transferImpl.getAgencies().add(transferAgencyImpl);
        }
        return transferImpl;
    }
}

