/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.xml;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateConverter;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.xml.ImmobiliareUtils;
import com.openindex.openestate.impl.xml.immobiliare.Box;
import com.openindex.openestate.impl.xml.immobiliare.Building;
import com.openindex.openestate.impl.xml.immobiliare.ClassEnergy;
import com.openindex.openestate.impl.xml.immobiliare.Feed;
import com.openindex.openestate.impl.xml.immobiliare.Floor;
import com.openindex.openestate.impl.xml.immobiliare.Furniture;
import com.openindex.openestate.impl.xml.immobiliare.Garden;
import com.openindex.openestate.impl.xml.immobiliare.Heat;
import com.openindex.openestate.impl.xml.immobiliare.Kitchen;
import com.openindex.openestate.impl.xml.immobiliare.LandSizeType;
import com.openindex.openestate.impl.xml.immobiliare.Langtxt;
import com.openindex.openestate.impl.xml.immobiliare.LocationStructure;
import com.openindex.openestate.impl.xml.immobiliare.Operation;
import com.openindex.openestate.impl.xml.immobiliare.PictureExtended;
import com.openindex.openestate.impl.xml.immobiliare.PictureProject;
import com.openindex.openestate.impl.xml.immobiliare.PriceType;
import com.openindex.openestate.impl.xml.immobiliare.PropertyType;
import com.openindex.openestate.impl.xml.immobiliare.PropertyTypeBusiness;
import com.openindex.openestate.impl.xml.immobiliare.PropertyTypeSimple;
import com.openindex.openestate.impl.xml.immobiliare.Publisher;
import com.openindex.openestate.impl.xml.immobiliare.SizeType;
import com.openindex.openestate.impl.xml.immobiliare.Status;
import com.openindex.openestate.impl.xml.immobiliare.TerrainType;
import com.openindex.openestate.impl.xml.immobiliare.TransactionType;
import com.openindex.openestate.impl.xml.immobiliare.VideoProject;
import com.openindex.openestate.impl.xml.immobiliare.VideoType;
import com.openindex.openestate.impl.xml.immobiliare.YesNoReady;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ImmobiliareReader
extends OpenEstateConverter {
    private static final Logger LOGGER = Logger.getLogger(ImmobiliareReader.class);
    public static final int CONVERT_TO_AGENCY = 0;
    public static final int CONVERT_TO_TRANSFER = 1;
    private static final Map<ImmobiliareUtils.Category, String> CATEGORIES;
    private static final Map<PropertyType, String> TYPES;
    private static final Map<PropertyTypeBusiness, String> COMMMERCIAL_TYPES;
    private static final Map<TerrainType, String> TERRAINS;
    private static final Map<ImmobiliareUtils.Transaction, String> TRANSACTIONS;
    private static final Map<PropertyTypeSimple, String> OLD_TYPES;

    public ImmobiliareReader() {
    }

    public ImmobiliareReader(Locale locale) {
        this();
        this.setOpenEstateLanguage(locale);
    }

    protected AgentImpl convertAnbieter(Publisher publisher) {
        AgentImpl agentImpl = this.createEmptyAgent();
        agentImpl.getCompany().setCompanyMail(publisher.getEmail());
        agentImpl.getCompany().setCompanyName(publisher.getName());
        agentImpl.getCompany().setCompanyPhone(publisher.getPhone());
        String string = StringUtils.trimToNull((String)publisher.getSite());
        if (string != null) {
            try {
                agentImpl.getCompany().setCompanyWebsite(new URL(string));
            }
            catch (Exception exception) {
                LOGGER.warn((Object)("Can't read publisher website: " + string));
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        return agentImpl;
    }

    /*
     * WARNING - void declaration
     */
    protected EstateImpl convertImmobilie(Feed.Properties.Property property, Map<String, AgentContactImpl> map) throws OpenEstateException {
        Object object;
        Object object2;
        Object object3;
        Object object6;
        Object object7;
        Object object8;
        Object object922;
        PropertyTypeBusiness propertyTypeBusiness;
        EstateImpl estateImpl = this.createEmptyEstate();
        TransactionType transactionType = property.getTransactionType();
        if (transactionType == null) {
            throw new OpenEstateException("No transaction was provided!");
        }
        Building building = property.getBuilding();
        PropertyType propertyType = building != null ? building.getType() : null;
        PropertyTypeSimple propertyTypeSimple = property.getPropertyType() != null ? property.getPropertyType().getType() : null;
        ImmobiliareUtils.Category category = building != null && building.getCategory() != null ? building.getCategory() : property.getCategory();
        PropertyTypeBusiness propertyTypeBusiness2 = propertyTypeBusiness = building != null && building.getDetail() != null ? building.getDetail() : null;
        if (propertyTypeBusiness == null && property.getPropertyType() != null && property.getPropertyType().getBusinessType() != null) {
            propertyTypeBusiness = property.getPropertyType().getBusinessType().getValue();
        }
        ArrayList<TerrainType> arrayList = new ArrayList<TerrainType>();
        if (building != null && building.getTerrains() != null) {
            arrayList.addAll(building.getTerrains().getTerrain());
        } else if (property.getPropertyType() != null && property.getPropertyType().getTerrains() != null) {
            arrayList.addAll(property.getPropertyType().getTerrains().getTerrain());
        }
        Status status = building.getStatus();
        if (status == null) {
            status = property.getBuildingStatus();
        }
        if (Status.ABITABILE.equals((Object)status)) {
            this.putEstateValue("ZUSTAND", "ZUSTAND", "BEWOHNBAR", estateImpl);
        } else if (Status.BUONO.equals((Object)status)) {
            this.putEstateValue("ZUSTAND", "ZUSTAND", "GUT", estateImpl);
        } else if (Status.DA_RISTRUTTURARE.equals((Object)status)) {
            this.putEstateValue("ZUSTAND", "ZUSTAND", "SANIERUNGSBEDARF_VOLL", estateImpl);
        } else if (Status.DISCRETO.equals((Object)status)) {
            this.putEstateValue("ZUSTAND", "ZUSTAND", "PASSABEL", estateImpl);
        } else if (Status.IN_COSTRUZIONE.equals((Object)status)) {
            this.putEstateValue("ZUSTAND", "ZUSTAND", "ROHBAU", estateImpl);
        } else if (Status.NUOVO.equals((Object)status)) {
            this.putEstateValue("ZUSTAND", "ZUSTAND", "NEUWERTIG", estateImpl);
        } else if (Status.OTTIMO.equals((Object)status)) {
            this.putEstateValue("ZUSTAND", "ZUSTAND", "AUSGEZEICHNET", estateImpl);
        } else if (Status.RISTRUTTURATO.equals((Object)status)) {
            this.putEstateValue("ZUSTAND", "ZUSTAND", "RENOVIERT_VOLL", estateImpl);
        }
        String string = null;
        if (propertyTypeBusiness != null && COMMMERCIAL_TYPES.containsKey((Object)propertyTypeBusiness)) {
            if (PropertyTypeBusiness.AGRICOLO.equals((Object)propertyTypeBusiness)) {
                for (Object object922 : arrayList) {
                    if (!TERRAINS.containsKey(object922)) continue;
                    string = TERRAINS.get(object922);
                    break;
                }
            }
            if (string == null) {
                string = COMMMERCIAL_TYPES.get((Object)propertyTypeBusiness);
            }
        } else if (propertyType != null && TYPES.containsKey((Object)propertyType)) {
            string = TYPES.get((Object)propertyType);
        } else if (propertyTypeSimple != null && OLD_TYPES.containsKey((Object)propertyTypeSimple)) {
            string = OLD_TYPES.get((Object)propertyTypeSimple);
        } else if (category != null && CATEGORIES.containsKey((Object)category)) {
            string = CATEGORIES.get((Object)category);
        }
        if (string == null) {
            throw new OpenEstateException("Can't find a usable estate-type!");
        }
        OpenEstateType openEstateType = OpenEstateType.newInstance(string);
        object922 = null;
        ImmobiliareUtils.Transaction transaction = ImmobiliareUtils.Transaction.fromValue(transactionType.getValue());
        if (transaction == null || !TRANSACTIONS.containsKey((Object)transaction)) {
            throw new OpenEstateException("Can't find a usable estate-action from: " + transactionType.getValue());
        }
        object922 = TRANSACTIONS.get((Object)transaction);
        if ("MIETE".equals(object922) && !openEstateType.hasAction((String)object922)) {
            if (openEstateType.hasAction("PACHT")) {
                object922 = "PACHT";
            } else if (openEstateType.hasAction("ERBPACHT")) {
                object922 = "ERBPACHT";
            } else if (openEstateType.hasAction("WAZ")) {
                object922 = "WAZ";
            }
        }
        if (!openEstateType.hasAction((String)object922)) {
            throw new OpenEstateException("The estate-action '" + (String)object922 + "' " + "is not supported by the estate-type '" + string + "'!");
        }
        estateImpl.setType(openEstateType, (String)object922);
        List<String> list = null;
        try {
            list = Arrays.asList(OpenEstateUtils.getEstateTypePath(openEstateType));
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not load estate-types!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
        estateImpl.setTitle(OpenEstateUtils.translateEstate(estateImpl.getType().getName(), this.getOpenEstateLanguage()) + " / " + OpenEstateUtils.translateAction(estateImpl.getAction(), this.getOpenEstateLanguage()), this.getOpenEstateLanguage());
        if (property.getUniqueId() != null) {
            estateImpl.setId(property.getUniqueId().toString());
            estateImpl.setPublicId(property.getUniqueId().toString());
        }
        if (property.getDateExpiration() != null) {
            estateImpl.setPublishEnd(property.getDateExpiration().getTime());
        }
        if (property.getDateUpdated() != null) {
            this.putEstateValue("VERWALTUNG", "STAND_VOM", property.getDateUpdated().getTime(), estateImpl);
        }
        if (property.getLocation() != null) {
            object8 = StringUtils.trimToNull((String)property.getLocation().getCountryCode());
            if (object8 != null && ((String)object8).length() == 3) {
                estateImpl.getAdress().setCountry(OpenEstateUtils.convertToIso2Country((String)object8));
                estateImpl.getCustomValues().putCustomValue("geodb.immobiliare.0", object8, 5);
            } else if (object8 != null && ((String)object8).length() == 2) {
                estateImpl.getAdress().setCountry((String)object8);
                estateImpl.getCustomValues().putCustomValue("geodb.immobiliare.0", OpenEstateUtils.convertToIso3Country((String)object8), 5);
            }
            if (property.getLocation().getCity() != null) {
                estateImpl.getAdress().setCity(property.getLocation().getCity().getValue());
            }
            if (property.getLocation().getLocality() != null) {
                void var21_45;
                LocationStructure.Locality.Thoroughfare object52;
                estateImpl.getAdress().setPostalCode(property.getLocation().getLocality().getPostalCode());
                object7 = property.getLocation().getLocality().getLatitude();
                object6 = property.getLocation().getLocality().getLongitude();
                if (object7 != null && object6 != null) {
                    estateImpl.getAdress().setLatitude((Double)object7);
                    estateImpl.getAdress().setLongitude((Double)object6);
                }
                if ((object52 = property.getLocation().getLocality().getThoroughfare()) != null) {
                    estateImpl.getAdress().setStreet(object52.getValue());
                    estateImpl.getAdress().setAdressPublished(Boolean.TRUE.equals(object52.isDisplay()));
                }
                String string2 = "";
                if (property.getLocation().getAdministrativeArea() != null) {
                    void var21_39;
                    if (string2.length() > 0) {
                        String string3 = string2 + " / ";
                    }
                    String string4 = (String)var21_39 + property.getLocation().getAdministrativeArea();
                }
                if (property.getLocation().getSubAdministrativeArea() != null) {
                    void var21_43;
                    void var21_41;
                    if (var21_41.length() > 0) {
                        String string5 = (String)var21_41 + " / ";
                    }
                    String string6 = (String)var21_43 + property.getLocation().getSubAdministrativeArea().getValue();
                }
                if (var21_45.length() > 0) {
                    estateImpl.getAdress().setRegion((String)var21_45);
                }
            }
        }
        if (arrayList.contains((Object)TerrainType.SEMINATIVO) || arrayList.contains((Object)TerrainType.SEMINATIVO_ARBORATO) || arrayList.contains((Object)TerrainType.SEMINATIVO_ARBORATO_IRRIGUO) || arrayList.contains((Object)TerrainType.SEMINATIVO_IRRIGUO)) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "ACKER", estateImpl);
        }
        if (arrayList.contains((Object)TerrainType.FRUTTETO) || arrayList.contains((Object)TerrainType.AGRUMETO) || arrayList.contains((Object)TerrainType.ULIVETO) || arrayList.contains((Object)TerrainType.RISAIA_STABILE) || arrayList.contains((Object)TerrainType.CASTAGNETO_DA_FRUTTO) || arrayList.contains((Object)TerrainType.ORTO) || arrayList.contains((Object)TerrainType.ORTO_IRRIGUO)) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "OBSTPFLANZUNG", estateImpl);
        }
        if (arrayList.contains((Object)TerrainType.BOSCO_ALTO_FUSTO) || arrayList.contains((Object)TerrainType.BOSCO_CEDUO) || arrayList.contains((Object)TerrainType.BOSCO_MISTO)) {
            this.putEstateValue("VERWALTUNG", "BEBAUBAR_MIT", "WALD", estateImpl);
        }
        if (property.getFeatures() != null) {
            this.putEstateValue("FLAECHEN", "ANZ_ZIMMER", property.getFeatures().getRooms(), estateImpl);
            object8 = property.getFeatures().getPrice();
            if (object8 != null) {
                estateImpl.setCurrency(((PriceType)object8).getCurrency());
                estateImpl.setHiddenPrices(((PriceType)object8).isReserved());
                if ("KAUF".equals(estateImpl.getAction())) {
                    this.putEstateValue("PREISE", "KAUFPREIS", ((PriceType)object8).getValue(), estateImpl);
                } else if ("MIETE".equals(estateImpl.getAction())) {
                    this.putEstateValue("PREISE", "KALTMIETE", ((PriceType)object8).getValue(), estateImpl);
                } else if ("WAZ".equals(estateImpl.getAction())) {
                    this.putEstateValue("PREISE", "PAUSCHALMIETE", ((PriceType)object8).getValue(), estateImpl);
                } else if ("PACHT".equals(estateImpl.getAction()) || "ERBPACHT".equals(estateImpl.getAction())) {
                    this.putEstateValue("PREISE", "PACHT", ((PriceType)object8).getValue(), estateImpl);
                }
            }
            if ((object7 = property.getFeatures().getSize()) != null) {
                if (list.contains("MAIN_LANDWIRTSCHAFT")) {
                    this.putEstateValue("FLAECHEN", "GESAMTFLAECHE", ((SizeType)object7).getValue(), estateImpl);
                } else if (list.contains("MAIN_GEWERBE")) {
                    this.putEstateValue("FLAECHEN", "GEWERBEFLAECHE", ((SizeType)object7).getValue(), estateImpl);
                } else if (list.contains("MAIN_GRUND")) {
                    this.putEstateValue("FLAECHEN", "GRUNDSTUECKSFLAECHE", ((SizeType)object7).getValue(), estateImpl);
                } else if (list.contains("MAIN_STELLPLATZ")) {
                    this.putEstateValue("FLAECHEN", "STELLPLATZFLAECHE", ((SizeType)object7).getValue(), estateImpl);
                } else if (list.contains("MAIN_WOHNEN")) {
                    this.putEstateValue("FLAECHEN", "WOHNFLAECHE", ((SizeType)object7).getValue(), estateImpl);
                } else {
                    this.putEstateValue("FLAECHEN", "GESAMTFLAECHE", ((SizeType)object7).getValue(), estateImpl);
                }
            }
            for (Langtxt langtxt : property.getFeatures().getDescription()) {
                Locale locale = langtxt.getLanguage() != null ? OpenEstateUtils.buildLocale(langtxt.getLanguage().value()) : this.getOpenEstateLanguage();
                this.putEstateValue("FREITEXTE", "OBJEKT_BESCHR", langtxt.getValue(), estateImpl, locale);
            }
            object6 = null;
            ClassEnergy classEnergy = property.getFeatures().getEnergyClass();
            if (ClassEnergy.A_PLUS.equals((Object)classEnergy)) {
                object6 = "A_PLUS";
            } else if (ClassEnergy.A.equals((Object)classEnergy)) {
                object6 = "A";
            } else if (ClassEnergy.B.equals((Object)classEnergy)) {
                object6 = "B";
            } else if (ClassEnergy.C.equals((Object)classEnergy)) {
                object6 = "C";
            } else if (ClassEnergy.D.equals((Object)classEnergy)) {
                object6 = "D";
            } else if (ClassEnergy.E.equals((Object)classEnergy)) {
                object6 = "E";
            } else if (ClassEnergy.F.equals((Object)classEnergy)) {
                object6 = "F";
            } else if (ClassEnergy.G.equals((Object)classEnergy)) {
                object6 = "G";
            }
            if (object6 != null) {
                this.putEstateValue("ENERGIEPASS", "KLASSE", object6, estateImpl);
            }
            if (property.getFeatures().getEnergyPerformance() != null) {
                this.putEstateValue("ENERGIEPASS", "VORHANDEN", property.getFeatures().getEnergyPerformance().isCertified(), estateImpl);
                String string7 = property.getFeatures().getEnergyPerformance().getValue();
                object3 = property.getFeatures().getEnergyPerformance().getUnit();
                if (string7 != null && ImmobiliareUtils.EnergyUnit.KWH_M2ANNO.equals(object3)) {
                    this.putEstateValue("ENERGIEPASS", "ART", "VERBRAUCH", estateImpl);
                    this.putEstateValue("ENERGIEPASS", "VERBRAUCH_GESAMT", string7, estateImpl);
                }
            }
        }
        if (property.getExtraFeatures() != null) {
            Kitchen kitchen;
            this.putEstateValue("FLAECHEN", "ANZ_BADEZIMMER", property.getExtraFeatures().getBathrooms(), estateImpl);
            this.putEstateValue("AUSSTATTUNG", "HALLENHOEHE", property.getExtraFeatures().getBeamHeight(), estateImpl);
            this.putEstateValue("FLAECHEN", "ANZ_SCHLAFZIMMER", property.getExtraFeatures().getBedrooms(), estateImpl);
            this.putEstateValue("ZUSTAND", "BAUJAHR", property.getExtraFeatures().getBuildYear(), estateImpl);
            this.putEstateValue("FREITEXTE", "PREIS_BESCHR", property.getExtraFeatures().getFreeConditions(), estateImpl);
            this.putEstateValue("AUSSTATTUNG", "ETAGE_GESAMT", property.getExtraFeatures().getNumFloors(), estateImpl);
            this.putEstateValue("AUSSTATTUNG", "KLIMATISIERT", property.getExtraFeatures().isAirConditioning(), estateImpl);
            if (property.getExtraFeatures().getAdditionalCosts() != null) {
                if ("KAUF".equals(object922)) {
                    this.putEstateValue("PREISE", "HAUSGELD", property.getExtraFeatures().getAdditionalCosts().getValue(), estateImpl);
                } else {
                    this.putEstateValue("PREISE", "NEBENKOSTEN", property.getExtraFeatures().getAdditionalCosts().getValue(), estateImpl);
                }
            }
            if (Boolean.TRUE.equals(property.getExtraFeatures().isBalcony()) || Boolean.TRUE.equals(property.getExtraFeatures().isTerrace())) {
                this.putEstateValue("AUSSTATTUNG", "BALKON_TERRASSE", Boolean.TRUE, estateImpl);
            } else if (Boolean.FALSE.equals(property.getExtraFeatures().isBalcony()) || Boolean.FALSE.equals(property.getExtraFeatures().isTerrace())) {
                this.putEstateValue("AUSSTATTUNG", "BALKON_TERRASSE", Boolean.FALSE, estateImpl);
            }
            if (Boolean.TRUE.equals(property.getExtraFeatures().isSecurityAlarm())) {
                this.putEstateValue("AUSSTATTUNG", "SICHERHEITSTECHNIK", "ALARMANLAGE", estateImpl);
            }
            if (Boolean.TRUE.equals(property.getExtraFeatures().isNet())) {
                this.putEstateValue("AUSSTATTUNG", "TECHNIK", "DV_VERKABELUNG", estateImpl);
            }
            if (openEstateType.hasAttrib("AUSSTATTUNG", "PERS_LIFT")) {
                this.putEstateValue("AUSSTATTUNG", "PERS_LIFT", property.getExtraFeatures().isElevator(), estateImpl);
            } else if (openEstateType.hasAttrib("AUSSTATTUNG", "LAST_LIFT")) {
                this.putEstateValue("AUSSTATTUNG", "LAST_LIFT", property.getExtraFeatures().isElevator(), estateImpl);
            }
            object8 = property.getExtraFeatures().getOverheadCrane();
            if (object8 != null) {
                if (YesNoReady.YES.equals(object8)) {
                    this.putEstateValue("AUSSTATTUNG", "KRAN", Boolean.TRUE, estateImpl);
                } else if (YesNoReady.NO.equals(object8)) {
                    this.putEstateValue("AUSSTATTUNG", "KRAN", Boolean.FALSE, estateImpl);
                }
            }
            if ((object7 = property.getExtraFeatures().getOfficeSize()) != null) {
                this.putEstateValue("FLAECHEN", "BUEROFLAECHE", ((SizeType)object7).getValue(), estateImpl);
            }
            if ((object6 = property.getExtraFeatures().getExternalArea()) != null) {
                this.putEstateValue("FLAECHEN", "GRUNDSTUECKSFLAECHE", ((LandSizeType)object6).getValue(), estateImpl);
            }
            if (Kitchen.ABITABILE.equals((Object)(kitchen = property.getExtraFeatures().getKitchen()))) {
                this.putEstateValue("AUSSTATTUNG", "KUECHE", "WOHNKUECHE", estateImpl);
            } else if (Kitchen.ANGOLO_COTTURA.equals((Object)kitchen)) {
                this.putEstateValue("AUSSTATTUNG", "KUECHE", "KOCHECKE", estateImpl);
            } else if (Kitchen.CUCINOTTO.equals((Object)kitchen)) {
                this.putEstateValue("AUSSTATTUNG", "KUECHE", "KLEINE_KUECHE", estateImpl);
            } else if (Kitchen.SEMI_ABITABILE.equals((Object)kitchen)) {
                this.putEstateValue("AUSSTATTUNG", "KUECHE", "OFFENE_KUECHE", estateImpl);
            }
            Heat heat = property.getExtraFeatures().getHeating();
            if (Heat.AUTONOMO.equals((Object)heat)) {
                this.putEstateValue("AUSSTATTUNG", "HEIZUNGSART", "AUTONOM", estateImpl);
            } else if (Heat.CENTRALIZZATO.equals((Object)heat)) {
                this.putEstateValue("AUSSTATTUNG", "HEIZUNGSART", "ZENTRAL", estateImpl);
            } else if (Heat.TELERISCALDAMENTO.equals((Object)heat)) {
                this.putEstateValue("AUSSTATTUNG", "BEFEUERUNG", "FERNWAERME", estateImpl);
            }
            object3 = property.getExtraFeatures().getGarden();
            if (Garden.COMUNE.equals(object3)) {
                this.putEstateValue("AUSSTATTUNG", "GARTENNUTZUNG", Boolean.TRUE, estateImpl);
            } else if (Garden.NESSUNO.equals(object3)) {
                this.putEstateValue("AUSSTATTUNG", "GARTENNUTZUNG", Boolean.FALSE, estateImpl);
            } else if (Garden.PRIVATO.equals(object3)) {
                this.putEstateValue("AUSSTATTUNG", "GARTENNUTZUNG", Boolean.TRUE, estateImpl);
            }
            object2 = property.getExtraFeatures().getGarage();
            if (object2 != null) {
                this.putEstateValue("FLAECHEN", "ANZ_STELLPLAETZE", ((Box)object2).getValue(), estateImpl);
                if (Box.BoxType.BOX.equals((Object)((Box)object2).getType())) {
                    this.putEstateValue("FLAECHEN", "STELLPLATZART", "GARAGE", estateImpl);
                } else if (Box.BoxType.POSTO_AUTO.equals((Object)((Box)object2).getType())) {
                    this.putEstateValue("FLAECHEN", "STELLPLATZART", "STELLPLATZ", estateImpl);
                } else if (Box.BoxType.RIMESSA.equals((Object)((Box)object2).getType())) {
                    this.putEstateValue("FLAECHEN", "STELLPLATZART", "CARPORT", estateImpl);
                }
            }
            if (Furniture.ARREDATO.equals(object = property.getExtraFeatures().getFurniture())) {
                this.putEstateValue("AUSSTATTUNG", "MOEBLIERT", "JA", estateImpl);
            } else if (Furniture.NON_ARREDATO.equals(object)) {
                this.putEstateValue("AUSSTATTUNG", "MOEBLIERT", "NEIN", estateImpl);
            } else if (Furniture.PARZIALMENTE_ARREDATO.equals(object)) {
                this.putEstateValue("AUSSTATTUNG", "MOEBLIERT", "TEIL", estateImpl);
            }
            Floor floor = property.getExtraFeatures().getFloor();
            if (floor != null) {
                this.putEstateValue("AUSSTATTUNG", "ETAGE", floor.getValue(), estateImpl);
            }
        }
        if ((object8 = property.getPictures()) != null) {
            object7 = ((Feed.Properties.Property.Pictures)object8).getPictureUrlAndPicture().iterator();
            while (object7.hasNext()) {
                void var21_56;
                void var20_33;
                void var20_31;
                object6 = object7.next();
                Object var20_29 = null;
                if (object6 instanceof PictureExtended) {
                    String string8 = StringUtils.trimToNull((String)((PictureExtended)object6).getUrl());
                }
                if (var20_31 == null) {
                    String string9 = StringUtils.trimToNull((String)((PictureProject)object6).getValue());
                }
                if (var20_33 == null) continue;
                Object var21_53 = null;
                try {
                    URL uRL = new URL((String)var20_33);
                }
                catch (Exception exception) {
                    Object var21_55 = null;
                }
                object3 = new EstateAttachmentImpl();
                ((EstateAttachmentImpl)object3).setPublished(true);
                if (var21_56 != null) {
                    ((EstateAttachmentImpl)object3).setFile((URL)var21_56);
                    estateImpl.getAttachments().add((EstateAttachmentImpl)object3);
                    continue;
                }
                if (var20_33 == null) continue;
                ((EstateAttachmentImpl)object3).setFile((String)var20_33);
                estateImpl.getAttachments().add((EstateAttachmentImpl)object3);
            }
        }
        if ((object7 = property.getBlueprints()) != null) {
            object6 = ((Feed.Properties.Property.Blueprints)object7).getBlueprint().iterator();
            while (object6.hasNext()) {
                void var21_60;
                PictureExtended pictureExtended = (PictureExtended)object6.next();
                String string10 = StringUtils.trimToNull((String)pictureExtended.getUrl());
                if (string10 == null) {
                    String string11 = StringUtils.trimToNull((String)pictureExtended.getValue());
                }
                if (var21_60 == null) continue;
                object3 = null;
                try {
                    object3 = new URL((String)var21_60);
                }
                catch (Exception exception) {
                    object3 = null;
                }
                object2 = new EstateAttachmentImpl();
                ((EstateAttachmentImpl)object2).setPublished(true);
                ((EstateAttachmentImpl)object2).setType("IMAGE_GROUNDPLAN");
                if (object3 != null) {
                    ((EstateAttachmentImpl)object2).setFile((URL)object3);
                    estateImpl.getAttachments().add((EstateAttachmentImpl)object2);
                    continue;
                }
                if (var21_60 == null) continue;
                ((EstateAttachmentImpl)object2).setFile((String)var21_60);
                estateImpl.getAttachments().add((EstateAttachmentImpl)object2);
            }
        }
        if ((object6 = property.getVideos()) != null) {
            for (VideoProject videoProject : ((Feed.Properties.Property.Videos)object6).getVideo()) {
                if (!VideoType.LOCAL.equals((Object)videoProject.getType()) || (object3 = StringUtils.trimToNull((String)videoProject.getValue())) == null) continue;
                object2 = null;
                try {
                    object2 = new URL((String)object3);
                }
                catch (Exception exception) {
                    object2 = null;
                }
                object = new EstateAttachmentImpl();
                object.setPublished(true);
                if (object2 != null) {
                    object.setFile((URL)object2);
                    estateImpl.getAttachments().add((EstateAttachmentImpl)object);
                    continue;
                }
                if (object3 == null) continue;
                object.setFile((String)object3);
                estateImpl.getAttachments().add((EstateAttachmentImpl)object);
            }
        }
        return estateImpl;
    }

    public SerializableXmlElement read(Feed feed, int n) {
        switch (n) {
            case 0: {
                return this.readAgency(feed);
            }
            case 1: {
                return this.readTransfer(feed);
            }
        }
        throw new IllegalArgumentException("invalid convert-mode: " + n);
    }

    protected AgentImpl createEmptyAgent() {
        return new AgentImpl();
    }

    protected EstateImpl createEmptyEstate() {
        return new EstateImpl();
    }

    public AgencyImpl readAgency(Feed feed) {
        this.getErrorMap().clear();
        AgentImpl agentImpl = feed.getMetadata() != null && feed.getMetadata().getPublisher() != null ? this.convertAnbieter(feed.getMetadata().getPublisher()) : this.createEmptyAgent();
        agentImpl.setId("Agent.1");
        AgencyImpl agencyImpl = new AgencyImpl();
        agencyImpl.setAgent(agentImpl);
        HashMap<String, AgentContactImpl> hashMap = new HashMap<String, AgentContactImpl>();
        if (feed.getProperties() != null) {
            for (Feed.Properties.Property object : feed.getProperties().getProperty()) {
                try {
                    EstateImpl estateImpl = this.convertImmobilie(object, hashMap);
                    if (estateImpl == null) continue;
                    agencyImpl.getEstates().put(estateImpl.getId(), estateImpl);
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"could not read agency-estate!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            agencyImpl.getContacts().put((String)entry.getKey(), (AgentContactImpl)entry.getValue());
        }
        return agencyImpl;
    }

    public TransferImpl readTransfer(Feed feed) {
        this.getErrorMap().clear();
        AgentImpl agentImpl = feed.getMetadata() != null && feed.getMetadata().getPublisher() != null ? this.convertAnbieter(feed.getMetadata().getPublisher()) : this.createEmptyAgent();
        agentImpl.setId("Agent.1");
        TransferImpl transferImpl = new TransferImpl();
        TransferAgencyImpl transferAgencyImpl = new TransferAgencyImpl();
        transferAgencyImpl.setRemoveUnmodifiedEstates(false);
        transferAgencyImpl.setAgent(agentImpl);
        HashMap<String, AgentContactImpl> hashMap = new HashMap<String, AgentContactImpl>();
        if (feed.getProperties() != null) {
            for (Feed.Properties.Property object : feed.getProperties().getProperty()) {
                Object object2;
                if (Operation.DELETE.equals((Object)object.getOperation())) {
                    object2 = StringUtils.trimToNull((String)object.getUniqueId().toString());
                    if (object2 == null) {
                        LOGGER.warn((Object)"Can't read estate-id for deletion!");
                        continue;
                    }
                    if (transferAgencyImpl.getEstateIdsToRemove().contains(object2)) {
                        LOGGER.warn((Object)"Estate-id for deletion is defined more then once!");
                        continue;
                    }
                    transferAgencyImpl.getEstateIdsToRemove().add((String)object2);
                    continue;
                }
                try {
                    object2 = this.convertImmobilie(object, hashMap);
                    if (object2 == null) continue;
                    transferAgencyImpl.getEstatesToSave().add((EstateImpl)object2);
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"could not read agency-estate!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            transferAgencyImpl.getContacts().put((String)entry.getKey(), (AgentContactImpl)entry.getValue());
        }
        transferImpl.getAgencies().add(transferAgencyImpl);
        return transferImpl;
    }

    static {
        TRANSACTIONS = new EnumMap<ImmobiliareUtils.Transaction, String>(ImmobiliareUtils.Transaction.class);
        TRANSACTIONS.put(ImmobiliareUtils.Transaction.RENT, "MIETE");
        TRANSACTIONS.put(ImmobiliareUtils.Transaction.SALE, "KAUF");
        CATEGORIES = new EnumMap<ImmobiliareUtils.Category, String>(ImmobiliareUtils.Category.class);
        CATEGORIES.put(ImmobiliareUtils.Category.COMMERCIALE, "MAIN_GEWERBE");
        CATEGORIES.put(ImmobiliareUtils.Category.RESIDENZIALE, "MAIN_WOHNEN");
        CATEGORIES.put(ImmobiliareUtils.Category.VACANZE, "FERIENHAUS");
        OLD_TYPES = new EnumMap<PropertyTypeSimple, String>(PropertyTypeSimple.class);
        OLD_TYPES.put(PropertyTypeSimple.AGRITURISMO, "BAUERNHOF");
        OLD_TYPES.put(PropertyTypeSimple.APPARTAMENTO, "WOHNUNG");
        OLD_TYPES.put(PropertyTypeSimple.ATTICO, "PENTHOUSEWOHNUNG");
        OLD_TYPES.put(PropertyTypeSimple.BAITA, "BERGHUETTE");
        OLD_TYPES.put(PropertyTypeSimple.BED_AND_BREAKFAST, "FREMDENZIMMER");
        OLD_TYPES.put(PropertyTypeSimple.BUNGALOW, "BUNGALOW");
        OLD_TYPES.put(PropertyTypeSimple.CAMERA, "ZIMMER");
        OLD_TYPES.put(PropertyTypeSimple.CASALE, "BAUERNHAUS");
        OLD_TYPES.put(PropertyTypeSimple.CASA_INDIPENDENTE, "HAUS");
        OLD_TYPES.put(PropertyTypeSimple.CASA_PER_FERIE_GRUPPI, "FERIENHAUS");
        OLD_TYPES.put(PropertyTypeSimple.CHALET, "CHALET");
        OLD_TYPES.put(PropertyTypeSimple.GARAGE, "GARAGE");
        OLD_TYPES.put(PropertyTypeSimple.HOTEL, "HOTEL");
        OLD_TYPES.put(PropertyTypeSimple.LOFT, "LOFTWOHNUNG");
        OLD_TYPES.put(PropertyTypeSimple.MANSARDA, "DACHWOHNUNG");
        OLD_TYPES.put(PropertyTypeSimple.MULTIPROPRIET\u00c0, "WOHNANLAGE");
        OLD_TYPES.put(PropertyTypeSimple.PALAZZO, "BESONDERES_HAUS");
        OLD_TYPES.put(PropertyTypeSimple.PARCO_VACANZE, "FREIZEIT_SPORT");
        OLD_TYPES.put(PropertyTypeSimple.RESIDENCE, "WOHNUNG");
        OLD_TYPES.put(PropertyTypeSimple.RUSTICO, "LANDHAUS");
        OLD_TYPES.put(PropertyTypeSimple.STABILE, "HAUS");
        OLD_TYPES.put(PropertyTypeSimple.STANZA, "ZIMMER");
        OLD_TYPES.put(PropertyTypeSimple.VILLA, "VILLA");
        OLD_TYPES.put(PropertyTypeSimple.VILLETTA, "VILLA");
        OLD_TYPES.put(PropertyTypeSimple.VILLETTA_A_SCHIERA, "REIHENHAUS");
        TYPES = new EnumMap<PropertyType, String>(PropertyType.class);
        TYPES.put(PropertyType.AGRITURISMO, "BAUERNHOF");
        TYPES.put(PropertyType.APPARTAMENTO, "WOHNUNG");
        TYPES.put(PropertyType.ATTICO, "PENTHOUSEWOHNUNG");
        TYPES.put(PropertyType.BAITA, "BERGHUETTE");
        TYPES.put(PropertyType.BED_AND_BREAKFAST, "FREMDENZIMMER");
        TYPES.put(PropertyType.BUNGALOW, "BUNGALOW");
        TYPES.put(PropertyType.CAMERA, "ZIMMER");
        TYPES.put(PropertyType.CASALE, "BAUERNHAUS");
        TYPES.put(PropertyType.CASA_INDIPENDENTE, "HAUS");
        TYPES.put(PropertyType.CASA_PER_FERIE_GRUPPI, "FERIENHAUS");
        TYPES.put(PropertyType.CHALET, "CHALET");
        TYPES.put(PropertyType.GARAGE, "GARAGE");
        TYPES.put(PropertyType.HOTEL, "HOTEL");
        TYPES.put(PropertyType.LOFT, "LOFTWOHNUNG");
        TYPES.put(PropertyType.MANSARDA, "DACHWOHNUNG");
        TYPES.put(PropertyType.MULTIPROPRIET\u00c0, "WOHNANLAGE");
        TYPES.put(PropertyType.PALAZZO, "BESONDERES_HAUS");
        TYPES.put(PropertyType.PARCO_VACANZE, "FREIZEIT_SPORT");
        TYPES.put(PropertyType.RESIDENCE, "WOHNUNG");
        TYPES.put(PropertyType.RUSTICO, "LANDHAUS");
        TYPES.put(PropertyType.STABILE, "HAUS");
        TYPES.put(PropertyType.STANZA, "ZIMMER");
        TYPES.put(PropertyType.VILLA, "VILLA");
        TYPES.put(PropertyType.VILLETTA, "VILLA");
        TYPES.put(PropertyType.VILLETTA_A_SCHIERA, "REIHENHAUS");
        COMMMERCIAL_TYPES = new EnumMap<PropertyTypeBusiness, String>(PropertyTypeBusiness.class);
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.ABBIGLIAMENTO, "EINZELHANDEL");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.AGRICOLO, "LAND_FORSTGRUND");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.ALBERGO, "GAST");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.ALIMENTARI, "GESCHAEFTSLOKAL");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.ALTRO_ALIMENTARE, "GESCHAEFTSLOKAL");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.ALTRO_NON_ALIMENTARE, "GESCHAEFTSLOKAL");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.AUTO_OFFICINA, "WERKSTATT");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.AZIENDA_AGRICOLA, "MAIN_LANDWIRTSCHAFT");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.BAR, "BAR");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.BED_AND_BREAKFAST, "FREMDENZIMMER");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.CAPANNONE, "HALLE_LAGER");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.CAPANNONE_INDUSTRIALE, "INDUSTRIEHALLE");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.CARTOLERIA, "EINZELHANDEL");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.CASALINGHI, "EINZELHANDEL");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.CASA_DI_CURA, "FREIZEIT_SPORT");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.CENTRO_COMMERCIALE, "EINKAUFSZENTRUM");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.COMMERCIALE, "GEWERBEGRUND");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.DISCOTECA, "DISKO");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.EDICOLA, "EINZELHANDEL");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.ESTETICA_SOLARIUM, "SONNENSTUDIO");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.FERRAMENTA, "EINZELHANDEL");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.GARAGE, "GARAGE");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.GELATERIA, "GASTRONOMIE");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.GIOCHI, "EINZELHANDEL");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.HOTEL, "HOTEL");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.INDUSTRIALE, "INDUSTRIEGRUND");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.INFORMATICA, "EINZELHANDEL");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.LABORATORIO, "BUERO_PRAXIS");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.LAVANDERIA, "EINZELHANDEL");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.LIBRERIA, "EINZELHANDEL");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.MAGAZZINO, "LAGERHALLE");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.NEGOZIO, "GESCHAEFTSLOKAL");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.PALESTRA, "FITNESSTUDIO");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.PANETTERIA, "EINZELHANDEL");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.PARRUCCHIERE_UOMO_DONNA, "MAIN_GEWERBE");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.PASTICCERIA, "EINZELHANDEL");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.PENSIONE, "PENSION");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.PIZZA_AL_TAGLIO, "GASTRONOMIE");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.PIZZERIA, "PIZZERIA");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.PUB, "BAR");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.RESIDENZIALE, "WOHNGRUND");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.RISTORANTE, "RESTAURANT");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.ROSTICCERIA, "RESTAURANT");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.SCOMMESSE, "MAIN_GEWERBE");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.SCUDERIA, "MAIN_LANDWIRTSCHAFT");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.SHOWROOM, "AUSSTELLUNGSFLAECHE");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.STABILE, "HAUS");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.STABILIMENTO_BALNEARE, "FREIZEIT_SPORT");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.TABACCHERIA, "EINZELHANDEL");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.TELEFONIA, "EINZELHANDEL");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.TINTORIA, "EINZELHANDEL");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.UFFICIO, "BUERO_GESCHAEFTSLOKAL");
        COMMMERCIAL_TYPES.put(PropertyTypeBusiness.VIDEONOLEGGIO, "EINZELHANDEL");
        TERRAINS = new EnumMap<TerrainType, String>(TerrainType.class);
        TERRAINS.put(TerrainType.SEMINATIVO, "ACKERBAU");
        TERRAINS.put(TerrainType.SEMINATIVO_ARBORATO, "ACKERBAU");
        TERRAINS.put(TerrainType.SEMINATIVO_ARBORATO_IRRIGUO, "ACKERBAU");
        TERRAINS.put(TerrainType.SEMINATIVO_IRRIGUO, "ACKERBAU");
        TERRAINS.put(TerrainType.VIGNETO, "WEINBAU");
    }
}

