/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.xml;

import com.openindex.openestate.impl.xml.immobiliare.ObjectFactory;
import java.util.Calendar;
import java.util.Currency;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ImmobiliareUtils {
    private static final Logger LOGGER = Logger.getLogger(ImmobiliareUtils.class);
    public static final String NAMESPACE = "";
    public static final String PACKAGE = "com.openindex.openestate.impl.xml.immobiliare";
    public static final String VERSION = "2.5";
    private static final ObjectFactory FACTORY = new ObjectFactory();
    private static JAXBContext JAXB = null;

    private ImmobiliareUtils() {
    }

    public static Marshaller createMarshaller() throws JAXBException {
        return ImmobiliareUtils.createMarshaller("UTF-8", true);
    }

    public static Marshaller createMarshaller(String string, boolean bl) throws JAXBException {
        Marshaller marshaller = ImmobiliareUtils.getContext().createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)string);
        marshaller.setProperty("jaxb.formatted.output", (Object)bl);
        return marshaller;
    }

    public static Unmarshaller createUnmarshaller() throws JAXBException {
        return ImmobiliareUtils.getContext().createUnmarshaller();
    }

    public static JAXBContext getContext() throws JAXBException {
        if (JAXB == null) {
            JAXB = JAXBContext.newInstance((String)PACKAGE);
        }
        return JAXB;
    }

    public static ObjectFactory getFactory() {
        return FACTORY;
    }

    public static boolean isValidDateUpdatedType(Calendar calendar) {
        Calendar calendar2 = DatatypeConverter.parseDateTime((String)"2000-12-31T00:00:00");
        return calendar != null && !calendar.before(calendar2);
    }

    public static boolean isValidEmailType(String string) {
        return string != null && string.matches("[^@]+@[^\\.]+\\..+");
    }

    public static boolean isValidLatitude(Double d) {
        return d != null && d >= 27.2 && d <= 71.1;
    }

    public static boolean isValidLongitude(Double d) {
        return d != null && d >= -31.2 && d <= 38.9;
    }

    public static boolean isValidRooms(Integer n) {
        return n != null && n >= 1 && n <= 100;
    }

    public static boolean isValidYear(Integer n) {
        return n != null && n >= 1000 && n <= 2020;
    }

    public static Category parseCategory(String string) {
        if ("c".equalsIgnoreCase(string)) {
            return Category.COMMERCIALE;
        }
        if ("r".equalsIgnoreCase(string)) {
            return Category.RESIDENZIALE;
        }
        if ("v".equalsIgnoreCase(string)) {
            return Category.VACANZE;
        }
        return null;
    }

    public static Currency parseCurrency(String string) {
        try {
            return string != null && string.trim().length() == 3 ? Currency.getInstance(string.trim().toUpperCase()) : null;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("Can't parse currency: " + string));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public static String parseEmailType(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        return string.matches("[^@]+@[^\\.]+\\..+") ? string : null;
    }

    public static EnergyUnit parseEnergyUnit(String string) {
        if ("kWh/m2anno".equalsIgnoreCase(string)) {
            return EnergyUnit.KWH_M2ANNO;
        }
        if ("kWh/m3anno".equalsIgnoreCase(string)) {
            return EnergyUnit.KWH_M3ANNO;
        }
        return null;
    }

    public static LandSizeUnit parseLandSizeUnit(String string) {
        if ("ha".equalsIgnoreCase(string)) {
            return LandSizeUnit.HA;
        }
        if ("m2".equalsIgnoreCase(string)) {
            return LandSizeUnit.M2;
        }
        if ("sft".equalsIgnoreCase(string)) {
            return LandSizeUnit.SFT;
        }
        return null;
    }

    public static Double parseLatitude(String string) {
        try {
            return string != null ? Double.valueOf(string) : null;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("Can't parse latitude: " + string));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public static Double parseLongitude(String string) {
        try {
            return string != null ? Double.valueOf(string) : null;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("Can't parse longitude: " + string));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public static Integer parseRooms(String string) {
        try {
            return string != null ? Integer.valueOf(string) : null;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("Can't parse rooms: " + string));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public static SizeUnit parseSizeUnit(String string) {
        if ("m2".equalsIgnoreCase(string)) {
            return SizeUnit.M2;
        }
        if ("sft".equalsIgnoreCase(string)) {
            return SizeUnit.SFT;
        }
        return null;
    }

    private static String parseText(String string, int n) {
        return string;
    }

    public static String parseText2(String string) {
        return ImmobiliareUtils.parseText(string, 2);
    }

    public static String parseText3000(String string) {
        return ImmobiliareUtils.parseText(string, 3000);
    }

    public static Transaction parseTransaction(String string) {
        if ("s".equalsIgnoreCase(string)) {
            return Transaction.SALE;
        }
        if ("r".equalsIgnoreCase(string)) {
            return Transaction.RENT;
        }
        return null;
    }

    public static Integer parseYear(String string) {
        try {
            return Integer.valueOf(string);
        }
        catch (Exception exception) {
            LOGGER.warn((Object)("Can't parse year: " + string));
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public static Boolean parseYesNo(String string) {
        if ("yes".equalsIgnoreCase(string)) {
            return true;
        }
        if ("no".equalsIgnoreCase(string)) {
            return false;
        }
        return null;
    }

    public static Boolean parseYN(String string) {
        if ("y".equalsIgnoreCase(string)) {
            return true;
        }
        if ("n".equalsIgnoreCase(string)) {
            return false;
        }
        return null;
    }

    public static String printCategory(Category category) {
        if (Category.COMMERCIALE.equals((Object)category)) {
            return "C";
        }
        if (Category.RESIDENZIALE.equals((Object)category)) {
            return "R";
        }
        if (Category.VACANZE.equals((Object)category)) {
            return "V";
        }
        throw new IllegalArgumentException("Invalid category: " + (Object)((Object)category));
    }

    public static String printCurrency(Currency currency) {
        if (currency == null) {
            throw new IllegalArgumentException("Empty currency!");
        }
        return currency.getCurrencyCode();
    }

    public static String printDateUpdatedType(Calendar calendar) {
        if (ImmobiliareUtils.isValidDateUpdatedType(calendar)) {
            return DatatypeConverter.printDateTime((Calendar)calendar);
        }
        throw new IllegalArgumentException("Invalid date-updated: " + calendar);
    }

    public static String printEmailType(String string) {
        if (ImmobiliareUtils.isValidEmailType(string)) {
            return string;
        }
        throw new IllegalArgumentException("Invalid email: " + string);
    }

    public static String printEnergyUnit(EnergyUnit energyUnit) {
        if (EnergyUnit.KWH_M2ANNO.equals((Object)energyUnit)) {
            return "kWh/m2anno";
        }
        if (EnergyUnit.KWH_M3ANNO.equals((Object)energyUnit)) {
            return "kWh/m3anno";
        }
        throw new IllegalArgumentException("Invalid energy-unit: " + (Object)((Object)energyUnit));
    }

    public static String printLandSizeUnit(LandSizeUnit landSizeUnit) {
        if (LandSizeUnit.HA.equals((Object)landSizeUnit)) {
            return "ha";
        }
        if (LandSizeUnit.M2.equals((Object)landSizeUnit)) {
            return "m2";
        }
        if (LandSizeUnit.SFT.equals((Object)landSizeUnit)) {
            return "sft";
        }
        throw new IllegalArgumentException("Invalid land-size-unit: " + (Object)((Object)landSizeUnit));
    }

    public static String printLatitude(Double d) {
        if (ImmobiliareUtils.isValidLatitude(d)) {
            return d.toString();
        }
        throw new IllegalArgumentException("Invalid latitude: " + d);
    }

    public static String printLongitude(Double d) {
        if (ImmobiliareUtils.isValidLongitude(d)) {
            return d.toString();
        }
        throw new IllegalArgumentException("Invalid longitude: " + d);
    }

    public static String printRooms(Integer n) {
        if (ImmobiliareUtils.isValidRooms(n)) {
            return n.toString();
        }
        throw new IllegalArgumentException("Invalid rooms: " + n);
    }

    public static String printSizeUnit(SizeUnit sizeUnit) {
        if (SizeUnit.M2.equals((Object)sizeUnit)) {
            return "m2";
        }
        if (SizeUnit.SFT.equals((Object)sizeUnit)) {
            return "sft";
        }
        throw new IllegalArgumentException("Invalid size-unit: " + (Object)((Object)sizeUnit));
    }

    private static String printText(String string, int n) {
        int n2 = (string = StringUtils.trimToEmpty((String)string)).length();
        if (n2 <= 0) {
            return null;
        }
        if (n2 <= n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String printText2(String string) {
        return ImmobiliareUtils.printText(string, 2);
    }

    public static String printText3000(String string) {
        return ImmobiliareUtils.printText(string, 3000);
    }

    public static String printTransaction(Transaction transaction) {
        if (Transaction.SALE.equals((Object)transaction)) {
            return "S";
        }
        if (Transaction.RENT.equals((Object)transaction)) {
            return "R";
        }
        throw new IllegalArgumentException("Invalid transaction: " + (Object)((Object)transaction));
    }

    public static String printYear(Integer n) {
        if (ImmobiliareUtils.isValidYear(n)) {
            return n.toString();
        }
        throw new IllegalArgumentException("Invalid year: " + n);
    }

    public static String printYesNo(Boolean bl) {
        if (Boolean.TRUE.equals(bl)) {
            return "yes";
        }
        if (Boolean.FALSE.equals(bl)) {
            return "no";
        }
        throw new IllegalArgumentException("Invalid yes-no: " + bl);
    }

    public static String printYN(Boolean bl) {
        if (Boolean.TRUE.equals(bl)) {
            return "Y";
        }
        if (Boolean.FALSE.equals(bl)) {
            return "N";
        }
        throw new IllegalArgumentException("Invalid y-n: " + bl);
    }

    public static enum Transaction {
        SALE("S"),
        RENT("R");

        private final String xmlValue;

        private Transaction(String string2) {
            this.xmlValue = string2;
        }

        public String getXmlValue() {
            return this.xmlValue;
        }

        public static Transaction fromValue(String string) {
            for (Transaction transaction : Transaction.values()) {
                if (!transaction.xmlValue.equalsIgnoreCase(string)) continue;
                return transaction;
            }
            return null;
        }
    }

    public static enum SizeUnit {
        M2,
        SFT;

    }

    public static enum LandSizeUnit {
        HA,
        M2,
        SFT;

    }

    public static enum EnergyUnit {
        KWH_M2ANNO,
        KWH_M3ANNO;

    }

    public static enum Category {
        COMMERCIALE,
        RESIDENZIALE,
        VACANZE;

    }
}

