/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.xml;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttribsFreitexte;
import com.openindex.openestate.impl.OpenEstateConverter;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.ValueImpl;
import com.openindex.openestate.impl.xml.ImmobiliareUtils;
import com.openindex.openestate.impl.xml.immobiliare.Box;
import com.openindex.openestate.impl.xml.immobiliare.ClassEnergy;
import com.openindex.openestate.impl.xml.immobiliare.Feed;
import com.openindex.openestate.impl.xml.immobiliare.Floor;
import com.openindex.openestate.impl.xml.immobiliare.Furniture;
import com.openindex.openestate.impl.xml.immobiliare.Garden;
import com.openindex.openestate.impl.xml.immobiliare.Heat;
import com.openindex.openestate.impl.xml.immobiliare.Kitchen;
import com.openindex.openestate.impl.xml.immobiliare.Langtxt;
import com.openindex.openestate.impl.xml.immobiliare.LocationStructure;
import com.openindex.openestate.impl.xml.immobiliare.NationCode;
import com.openindex.openestate.impl.xml.immobiliare.Operation;
import com.openindex.openestate.impl.xml.immobiliare.PictureExtended;
import com.openindex.openestate.impl.xml.immobiliare.PictureProject;
import com.openindex.openestate.impl.xml.immobiliare.PropertyType;
import com.openindex.openestate.impl.xml.immobiliare.PropertyTypeBusiness;
import com.openindex.openestate.impl.xml.immobiliare.Publisher;
import com.openindex.openestate.impl.xml.immobiliare.Rental;
import com.openindex.openestate.impl.xml.immobiliare.Status;
import com.openindex.openestate.impl.xml.immobiliare.TerrainType;
import com.openindex.openestate.impl.xml.immobiliare.Terrains;
import com.openindex.openestate.impl.xml.immobiliare.TransactionType;
import com.openindex.openestate.impl.xml.immobiliare.Version;
import com.openindex.openestate.impl.xml.immobiliare.VideoProject;
import com.openindex.openestate.impl.xml.immobiliare.VideoType;
import com.openindex.openestate.impl.xml.immobiliare.YesNoReady;
import java.math.BigInteger;
import java.net.URL;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ImmobiliareWriter
extends OpenEstateConverter {
    private static final Logger LOGGER = Logger.getLogger(ImmobiliareWriter.class);
    private static final Map<String, ImmobiliareUtils.Transaction> ACTIONS = new HashMap<String, ImmobiliareUtils.Transaction>();
    private static final Map<String, ImmobiliareUtils.Category> CATEGORIES;
    private static final Map<ImmobiliareUtils.Category, Map<String, PropertyType>> TYPES;
    private static final Map<PropertyType, Map<String, PropertyTypeBusiness>> COMMMERCIAL_TYPES;
    private static final Map<String, TerrainType> TERRAINS;
    private Date now = new Date();
    private String baseUrl = null;
    private boolean energyCertificateAppendedToDescription = false;

    public ImmobiliareWriter() {
    }

    public ImmobiliareWriter(Locale locale) {
        this();
        this.setOpenEstateLanguage(locale);
    }

    public Publisher convertAgent(AgentImpl agentImpl) {
        Publisher publisher = ImmobiliareUtils.getFactory().createPublisher();
        publisher.setName(agentImpl.getCompany().getCompanyName());
        String string = StringUtils.trimToNull((String)agentImpl.getCompany().getCompanyPhone());
        publisher.setPhone(string != null ? string : "+3906XXXXX");
        String string2 = StringUtils.trimToNull((String)agentImpl.getCompany().getCompanyMail());
        publisher.setEmail(ImmobiliareUtils.isValidEmailType(string2) ? string2 : "unknown@immobiliare.it");
        URL uRL = agentImpl.getCompany().getCompanyWebsite();
        if (uRL != null && !StringUtils.isBlank((String)uRL.getHost())) {
            publisher.setSite(uRL.toString());
        }
        return publisher;
    }

    /*
     * WARNING - void declaration
     */
    public Feed.Properties.Property convertEstate(EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl, List<String> list) {
        Object object;
        Double d;
        Integer n;
        BigInteger bigInteger;
        List<String> list2;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        Object object3;
        Object object2;
        Object object4;
        Object object5;
        String string;
        Object object9;
        Object object10;
        List<String> list3;
        Object object11;
        Object object12;
        Object object13;
        int n2;
        Feed.Properties.Property property = ImmobiliareUtils.getFactory().createFeedPropertiesProperty();
        property.setBuilding(ImmobiliareUtils.getFactory().createBuilding());
        property.setUniqueId(estateImpl.getId());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.now);
        if (ImmobiliareUtils.isValidDateUpdatedType(calendar)) {
            property.setDateUpdated(calendar);
        }
        if (estateImpl.getPublishEnd() != null) {
            property.setDateExpiration(Calendar.getInstance());
            property.getDateExpiration().setTime(estateImpl.getPublishEnd());
        }
        if (!ACTIONS.containsKey(estateImpl.getAction())) {
            list.add("Vermarktungsart '" + estateImpl.getAction() + "' wird nicht unterst\u00fctzt!");
            return null;
        }
        Object object14 = ImmobiliareUtils.getFactory().createTransactionType();
        ((TransactionType)object14).setValue(ACTIONS.get(estateImpl.getAction()).getXmlValue());
        ((TransactionType)object14).setAuction(Boolean.FALSE);
        property.setTransactionType((TransactionType)object14);
        object14 = null;
        try {
            object14 = Arrays.asList(OpenEstateUtils.getEstateTypePath(estateImpl.getType()));
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not load estate-types!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            list.add("Immobilienart konnte nicht ermittelt werden!");
            return null;
        }
        ImmobiliareUtils.Category category = null;
        for (n2 = object14.size(); n2 > 0; --n2) {
            object13 = (String)object14.get(n2 - 1);
            if (!TYPES.get((Object)ImmobiliareUtils.Category.VACANZE).containsKey(object13)) continue;
            category = ImmobiliareUtils.Category.VACANZE;
            break;
        }
        if (category == null) {
            for (n2 = object14.size(); n2 > 0; --n2) {
                object13 = (String)object14.get(n2 - 1);
                if (!CATEGORIES.containsKey(object13)) continue;
                category = CATEGORIES.get(object13);
                break;
            }
        }
        if (category == null) {
            list.add("Immobilienart " + estateImpl.getType().getName() + " wird nicht unterst\u00fctzt!");
            return null;
        }
        property.getBuilding().setCategory(category);
        if (ImmobiliareUtils.Category.RESIDENZIALE.equals((Object)category) || ImmobiliareUtils.Category.VACANZE.equals((Object)category)) {
            object12 = null;
            for (int i = object14.size(); i > 0; --i) {
                object11 = (String)object14.get(i - 1);
                if (!TYPES.get((Object)category).containsKey(object11)) continue;
                object12 = TYPES.get((Object)category).get(object11);
                break;
            }
            if (object12 == null) {
                object12 = PropertyType.OTHER;
            }
            property.getBuilding().setType((PropertyType)((Object)object12));
        } else if (ImmobiliareUtils.Category.COMMERCIALE.equals((Object)category)) {
            int n3;
            object12 = null;
            object13 = null;
            for (n3 = object14.size(); n3 > 0; --n3) {
                list3 = (String)object14.get(n3 - 1);
                if (!COMMMERCIAL_TYPES.get((Object)PropertyType.ATTIVIT\u00c0).containsKey(list3)) continue;
                object12 = PropertyType.ATTIVIT\u00c0;
                break;
            }
            if (object12 == null) {
                for (n3 = object14.size(); n3 > 0; --n3) {
                    list3 = (String)object14.get(n3 - 1);
                    if (!TYPES.get((Object)category).containsKey(list3)) continue;
                    object12 = TYPES.get((Object)category).get(list3);
                    break;
                }
            }
            if (object12 == null) {
                object12 = PropertyType.IMMOBILE;
            }
            property.getBuilding().setType((PropertyType)((Object)object12));
            for (n3 = object14.size(); n3 > 0; --n3) {
                list3 = (String)object14.get(n3 - 1);
                if (!COMMMERCIAL_TYPES.get(object12).containsKey(list3)) continue;
                object13 = COMMMERCIAL_TYPES.get(object12).get(list3);
                break;
            }
            property.getBuilding().setDetail((PropertyTypeBusiness)((Object)object13));
            if (object12 == PropertyType.TERRENO && object13 == PropertyTypeBusiness.AGRICOLO) {
                Terrains terrains = ImmobiliareUtils.getFactory().createTerrains();
                list3 = object14.iterator();
                while (list3.hasNext()) {
                    object10 = (String)list3.next();
                    if (!TERRAINS.containsKey(object10)) continue;
                    object9 = TERRAINS.get(object10);
                    if (terrains.getTerrain().contains(object9)) continue;
                    terrains.getTerrain().add((TerrainType)((Object)object9));
                }
                list3 = this.getEstateValueAsList("VERWALTUNG", "BEBAUBAR_MIT", estateImpl);
                if (list3.contains("ACKER") && !terrains.getTerrain().contains((Object)TerrainType.SEMINATIVO)) {
                    terrains.getTerrain().add(TerrainType.SEMINATIVO);
                }
                if (list3.contains("OBSTPFLANZUNG") && !terrains.getTerrain().contains((Object)TerrainType.FRUTTETO)) {
                    terrains.getTerrain().add(TerrainType.FRUTTETO);
                }
                if (list3.contains("WALD") && !terrains.getTerrain().contains((Object)TerrainType.PASCOLO_ARBORATO)) {
                    terrains.getTerrain().add(TerrainType.PASCOLO_ARBORATO);
                }
                if (!terrains.getTerrain().isEmpty()) {
                    property.getBuilding().setTerrains(terrains);
                }
            }
        } else {
            list.add("Immobilien-Kategorie ist ung\u00fcltig!");
            return null;
        }
        object12 = this.getEstateValueAsList("ZUSTAND", "ZUSTAND", estateImpl);
        if (object12.contains("ERSTBEZUG") || object12.contains("NEUWERTIG")) {
            property.getBuilding().setStatus(Status.NUOVO);
        } else if (object12.contains("AUSGEZEICHNET")) {
            property.getBuilding().setStatus(Status.OTTIMO);
        } else if (object12.contains("GEPFLEGT") || object12.contains("GUT")) {
            property.getBuilding().setStatus(Status.BUONO);
        } else if (object12.contains("PASSABEL")) {
            property.getBuilding().setStatus(Status.DISCRETO);
        } else if (object12.contains("BEWOHNBAR")) {
            property.getBuilding().setStatus(Status.ABITABILE);
        } else if (object12.contains("RENOVIERT_TEIL") || object12.contains("RENOVIERT_VOLL") || object12.contains("SANIERT_TEIL") || object12.contains("SANIERT_VOLL") || object12.contains("ERSTBEZUG_NACH_SANIERUNG") || object12.contains("MODERNISIERT")) {
            property.getBuilding().setStatus(Status.RISTRUTTURATO);
        } else if (object12.contains("SANIERUNGSBEDARF_TEIL") || object12.contains("SANIERUNGSBEDARF_VOLL") || object12.contains("RENOVIERUNGSBEDARF_TEIL") || object12.contains("RENOVIERUNGSBEDARF_VOLL")) {
            property.getBuilding().setStatus(Status.DA_RISTRUTTURARE);
        } else if (object12.contains("BAUFAELLIG") || object12.contains("ENTKERNT") || object12.contains("ROHBAU")) {
            property.getBuilding().setStatus(Status.IN_COSTRUZIONE);
        } else {
            property.getBuilding().setStatus(Status.ND);
        }
        property.setAgent(ImmobiliareUtils.getFactory().createFeedPropertiesPropertyAgent());
        property.getAgent().setOfficeName(agentImpl != null && agentImpl.getCompany() != null ? StringUtils.trimToEmpty((String)agentImpl.getCompany().getCompanyName()) : "");
        String string2 = string = agentContactImpl != null ? agentContactImpl.getPersonMail().trim() : null;
        if (!ImmobiliareUtils.isValidEmailType(string)) {
            string = agentImpl != null ? agentImpl.getCompany().getCompanyMail().trim() : null;
        }
        property.getAgent().setEmail(ImmobiliareUtils.isValidEmailType(string) ? string : "unknown@immobiliare.it");
        property.setLocation(ImmobiliareUtils.getFactory().createLocationStructure());
        property.getLocation().setCountryCode(estateImpl.getAdress().getCountry());
        property.getLocation().setAdministrativeArea(StringUtils.trimToEmpty((String)estateImpl.getAdress().getRegion()));
        property.getLocation().setSubAdministrativeArea(ImmobiliareUtils.getFactory().createLocationStructureSubAdministrativeArea());
        property.getLocation().getSubAdministrativeArea().setValue(StringUtils.trimToEmpty((String)estateImpl.getAdress().getRegion()));
        property.getLocation().setCity(ImmobiliareUtils.getFactory().createLocationStructureCity());
        property.getLocation().getCity().setValue(StringUtils.trimToEmpty((String)estateImpl.getAdress().getCity()));
        property.getLocation().setLocality(ImmobiliareUtils.getFactory().createLocationStructureLocality());
        property.getLocation().getLocality().setPostalCode(estateImpl.getAdress().getPostalCode());
        property.getLocation().getLocality().setNeighbourhood(ImmobiliareUtils.getFactory().createLocationStructureLocalityNeighbourhood());
        property.getLocation().getLocality().getNeighbourhood().setValue(StringUtils.trimToEmpty((String)estateImpl.getAdress().getCityPart()));
        property.getLocation().getLocality().getNeighbourhood().setType(LocationStructure.Locality.Neighbourhood.LocationNeighbourhoodType.AREA);
        object11 = estateImpl.getAdress().getLatitude();
        list3 = estateImpl.getAdress().getLongitude();
        if (ImmobiliareUtils.isValidLatitude((Double)object11) && ImmobiliareUtils.isValidLongitude((Double)((Object)list3))) {
            property.getLocation().getLocality().setLatitude((Double)object11);
            property.getLocation().getLocality().setLongitude((Double)((Object)list3));
        }
        property.getLocation().getLocality().setThoroughfare(ImmobiliareUtils.getFactory().createLocationStructureLocalityThoroughfare());
        property.getLocation().getLocality().getThoroughfare().setDisplay(Boolean.TRUE.equals(estateImpl.getAdress().isAdressPublished()));
        property.getLocation().getLocality().getThoroughfare().setValue(estateImpl.getAdress().writeStreet());
        property.setFeatures(ImmobiliareUtils.getFactory().createFeedPropertiesPropertyFeatures());
        object10 = this.getEstateValueAsInteger("FLAECHEN", "ANZ_ZIMMER", estateImpl);
        property.getFeatures().setRooms((Integer)(ImmobiliareUtils.isValidRooms((Integer)object10) ? object10 : Integer.valueOf(1)));
        property.getFeatures().setPrice(ImmobiliareUtils.getFactory().createPriceType());
        property.getFeatures().getPrice().setCurrency(estateImpl.getCurrency());
        property.getFeatures().getPrice().setReserved(estateImpl.isHiddenPrices());
        object9 = null;
        if (estateImpl.isHiddenPrices()) {
            object9 = BigInteger.ZERO;
        } else if ("MIETE".equals(estateImpl.getAction())) {
            object9 = this.getEstateValueAsBigInteger("PREISE", "KALTMIETE", estateImpl);
            if (object9 == null) {
                object9 = this.getEstateValueAsBigInteger("PREISE", "WARMMIETE", estateImpl);
            }
        } else if ("PACHT".equals(estateImpl.getAction()) || "ERBPACHT".equals(estateImpl.getAction())) {
            object9 = this.getEstateValueAsBigInteger("PREISE", "PACHT", estateImpl);
            if (object9 == null) {
                object9 = this.getEstateValueAsBigInteger("PREISE", "PACHT_QM", estateImpl);
            }
        } else if ("WAZ".equals(estateImpl.getAction())) {
            object9 = this.getEstateValueAsBigInteger("PREISE", "PAUSCHALMIETE", estateImpl);
        } else if ("KAUF".equals(estateImpl.getAction())) {
            object9 = this.getEstateValueAsBigInteger("PREISE", "KAUFPREIS", estateImpl);
        }
        property.getFeatures().getPrice().setValue((BigInteger)(object9 != null ? object9 : BigInteger.ZERO));
        BigInteger bigInteger4 = null;
        bigInteger4 = this.getEstateValueAsBigInteger("FLAECHEN", "BRUTTOFLAECHE", estateImpl);
        if (bigInteger4 == null || bigInteger4.longValue() <= 0L) {
            bigInteger4 = this.getEstateValueAsBigInteger("FLAECHEN", "GESAMTFLAECHE", estateImpl);
        }
        if (bigInteger4 == null || bigInteger4.longValue() <= 0L) {
            bigInteger4 = this.getEstateValueAsBigInteger("FLAECHEN", "GRUNDSTUECKSFLAECHE", estateImpl);
        }
        if (bigInteger4 == null || bigInteger4.longValue() <= 0L) {
            bigInteger4 = this.getEstateValueAsBigInteger("FLAECHEN", "WOHNFLAECHE", estateImpl);
        }
        if (bigInteger4 == null || bigInteger4.longValue() <= 0L) {
            bigInteger4 = this.getEstateValueAsBigInteger("FLAECHEN", "GEWERBEFLAECHE", estateImpl);
        }
        if (bigInteger4 == null || bigInteger4.longValue() <= 0L) {
            bigInteger4 = this.getEstateValueAsBigInteger("FLAECHEN", "VERKAUFSFLAECHE", estateImpl);
        }
        if (bigInteger4 == null || bigInteger4.longValue() <= 0L) {
            bigInteger4 = this.getEstateValueAsBigInteger("FLAECHEN", "STELLPLATZFLAECHE", estateImpl);
        }
        property.getFeatures().setSize(ImmobiliareUtils.getFactory().createSizeType());
        property.getFeatures().getSize().setUnit(ImmobiliareUtils.SizeUnit.M2);
        property.getFeatures().getSize().setValue(bigInteger4 != null ? bigInteger4 : BigInteger.ZERO);
        for (String object82 : OpenEstateAttribsFreitexte.getValues()) {
            if ("KURZ_BESCHR".equals(object82) || !estateImpl.hasAttribute("FREITEXTE", object82) || (object5 = estateImpl.getAttribute("FREITEXTE." + object82)) == null) continue;
            for (String string3 : ((ValueImpl)object5).getLangages()) {
                object4 = null;
                try {
                    object4 = NationCode.fromValue(string3.toLowerCase());
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)("Can't create nation-code from: " + string3));
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()));
                    continue;
                }
                object2 = ImmobiliareUtils.getFactory().createLangtxt();
                ((Langtxt)object2).setLanguage((NationCode)((Object)object4));
                ((Langtxt)object2).setValue(OpenEstateUtils.serializeString(((ValueImpl)object5).writeValue(OpenEstateUtils.buildLocale(string3)), this.getXmlLineSeparator()));
                property.getFeatures().getDescription().add((Langtxt)object2);
                if (property.getFeatures().getDescription().size() >= 25) break;
            }
            if (!property.getFeatures().getDescription().isEmpty()) break;
        }
        if (property.getFeatures().getDescription().isEmpty()) {
            object3 = ImmobiliareUtils.getFactory().createLangtxt();
            ((Langtxt)object3).setLanguage(NationCode.IT);
            ((Langtxt)object3).setValue("");
            property.getFeatures().getDescription().add((Langtxt)object3);
        }
        if (this.isEnergyCertificateAppendedToDescription()) {
            object3 = this.getXmlLineSeparator() + this.getXmlLineSeparator() + StringUtils.repeat((String)"-", (int)15) + this.getXmlLineSeparator() + this.getXmlLineSeparator();
            for (Langtxt langtxt : property.getFeatures().getDescription()) {
                void var21_45;
                String string4 = langtxt.getLanguage().value().toLowerCase();
                object5 = OpenEstateUtils.writeEstateEnergyCertificate(estateImpl, new Locale(string4.toLowerCase()), this.getXmlLineSeparator());
                if (StringUtils.isBlank((String)object5)) continue;
                String string5 = StringUtils.trimToNull((String)langtxt.getValue());
                if (string5 == null) {
                    List<String> list4 = object5;
                } else {
                    String string6 = (String)object5 + (String)object3 + string5;
                }
                langtxt.setValue(StringUtils.trimToEmpty((String)var21_45));
            }
        }
        property.setExtraFeatures(ImmobiliareUtils.getFactory().createFeedPropertiesPropertyExtraFeatures());
        property.getExtraFeatures().setAirConditioning(this.getEstateValueAsBoolean("AUSSTATTUNG", "KLIMATISIERT", estateImpl));
        property.getExtraFeatures().setBalcony(this.getEstateValueAsBoolean("AUSSTATTUNG", "BALKON_TERRASSE", estateImpl));
        property.getExtraFeatures().setBathrooms(this.getEstateValueAsBigInteger("FLAECHEN", "ANZ_BADEZIMMER", estateImpl));
        property.getExtraFeatures().setBedrooms(this.getEstateValueAsBigInteger("FLAECHEN", "ANZ_SCHLAFZIMMER", estateImpl));
        property.getExtraFeatures().setNumFloors(this.getEstateValueAsBigInteger("AUSSTATTUNG", "ETAGE_GESAMT", estateImpl));
        property.getExtraFeatures().setTerrace(this.getEstateValueAsBoolean("AUSSTATTUNG", "BALKON_TERRASSE", estateImpl));
        object3 = BigInteger.ZERO;
        if ("KAUF".equals(estateImpl.getAction()) && (bigInteger3 = this.getEstateValueAsBigInteger("PREISE", "HAUSGELD", estateImpl)) != null) {
            object3 = ((BigInteger)object3).add(bigInteger3);
        }
        if (((BigInteger)object3).compareTo(BigInteger.ZERO) < 1) {
            BigInteger bigInteger5 = this.getEstateValueAsBigInteger("PREISE", "NEBENKOSTEN", estateImpl);
            BigInteger bigInteger6 = this.getEstateValueAsBigInteger("PREISE", "HEIZKOSTEN", estateImpl);
            Boolean bl = this.getEstateValueAsBoolean("PREISE", "NEBENKOSTEN_INKL_HEIZKOSTEN", estateImpl);
            if (bigInteger5 != null) {
                object3 = ((BigInteger)object3).add(bigInteger5);
            }
            if (bigInteger6 != null && !Boolean.TRUE.equals(bl)) {
                object3 = ((BigInteger)object3).add(bigInteger6);
            }
        }
        if (((BigInteger)object3).compareTo(BigInteger.ZERO) > 0) {
            property.getExtraFeatures().setAdditionalCosts(ImmobiliareUtils.getFactory().createAdditionalCostsType());
            property.getExtraFeatures().getAdditionalCosts().setValue((BigInteger)object3);
            property.getExtraFeatures().getAdditionalCosts().setCurrency(estateImpl.getCurrency());
        }
        if ((bigInteger2 = this.getEstateValueAsBigInteger("FLAECHEN", "ANZ_STELLPLAETZE", estateImpl)) != null && bigInteger2.longValue() >= 0L) {
            property.getExtraFeatures().setGarage(ImmobiliareUtils.getFactory().createBox());
            if (bigInteger2.longValue() < 1L) {
                property.getExtraFeatures().getGarage().setValue(BigInteger.ZERO);
                property.getExtraFeatures().getGarage().setType(Box.BoxType.NO);
            } else {
                property.getExtraFeatures().getGarage().setValue(bigInteger2);
                List<String> list4 = this.getEstateValueAsList("FLAECHEN", "STELLPLATZART", estateImpl);
                if (list4.contains("GARAGE") || list4.contains("DOPPELGARAGE")) {
                    property.getExtraFeatures().getGarage().setType(Box.BoxType.BOX);
                } else if (list4.contains("CARPORT") || list4.contains("DUPLEX")) {
                    property.getExtraFeatures().getGarage().setType(Box.BoxType.RIMESSA);
                } else {
                    property.getExtraFeatures().getGarage().setType(Box.BoxType.POSTO_AUTO);
                }
            }
        }
        if ((list2 = this.getEstateValueAsList("AUSSTATTUNG", "KUECHE", estateImpl)).contains("WOHNKUECHE")) {
            property.getExtraFeatures().setKitchen(Kitchen.ABITABILE);
        } else if (list2.contains("KOCHECKE")) {
            property.getExtraFeatures().setKitchen(Kitchen.ANGOLO_COTTURA);
        } else if (list2.contains("KLEINE_KUECHE")) {
            property.getExtraFeatures().setKitchen(Kitchen.SEMI_ABITABILE);
        }
        List<String> list5 = this.getEstateValueAsList("AUSSTATTUNG", "HEIZUNGSART", estateImpl);
        object5 = this.getEstateValueAsList("AUSSTATTUNG", "BEFEUERUNG", estateImpl);
        if (list5.contains("AUTONOM")) {
            property.getExtraFeatures().setHeating(Heat.AUTONOMO);
        } else if (object5.contains("FERNWAERME")) {
            property.getExtraFeatures().setHeating(Heat.TELERISCALDAMENTO);
        } else if (list5.contains("ZENTRAL")) {
            property.getExtraFeatures().setHeating(Heat.CENTRALIZZATO);
        }
        Boolean bl = this.getEstateValueAsBoolean("AUSSTATTUNG", "GARTENNUTZUNG", estateImpl);
        if (Boolean.TRUE.equals(bl)) {
            property.getExtraFeatures().setGarden(Garden.PRIVATO);
        } else if (Boolean.FALSE.equals(bl)) {
            property.getExtraFeatures().setGarden(Garden.NESSUNO);
        }
        Boolean bl2 = this.getEstateValueAsBoolean("AUSSTATTUNG", "PERS_LIFT", estateImpl);
        if (!Boolean.TRUE.equals(bl2)) {
            bl2 = this.getEstateValueAsBoolean("AUSSTATTUNG", "LAST_LIFT", estateImpl);
        }
        property.getExtraFeatures().setElevator(bl2);
        String string7 = this.getEstateValueAsString("AUSSTATTUNG", "MOEBLIERT", estateImpl);
        if ("JA".equals(string7)) {
            property.getExtraFeatures().setFurniture(Furniture.ARREDATO);
        } else if ("NEIN".equals(string7)) {
            property.getExtraFeatures().setFurniture(Furniture.NON_ARREDATO);
        } else if ("TEIL".equals(string7)) {
            property.getExtraFeatures().setFurniture(Furniture.PARZIALMENTE_ARREDATO);
        }
        BigInteger bigInteger5 = this.getEstateValueAsBigInteger("AUSSTATTUNG", "ETAGE", estateImpl);
        if (bigInteger5 != null) {
            property.getExtraFeatures().setFloor(ImmobiliareUtils.getFactory().createFloor());
            property.getExtraFeatures().getFloor().setValue(bigInteger5);
            if (object14.contains("DACHWOHNUNG") || object14.contains("PENTHOUSEWOHNUNG")) {
                property.getExtraFeatures().getFloor().setType(Floor.FloorType.ATTICO);
            } else if (object14.contains("ERDGESCHOSSWOHNUNG")) {
                property.getExtraFeatures().getFloor().setType(Floor.FloorType.PIANO_TERRA);
            } else if (object14.contains("HOCHPARTERRE")) {
                property.getExtraFeatures().getFloor().setType(Floor.FloorType.RIALZATO);
            }
        }
        if ("WAZ".equals(estateImpl.getAction())) {
            property.getExtraFeatures().setRentContract(Rental.TRANSITORIO);
        } else if ("MIETE".equals(estateImpl.getAction())) {
            if (object14.contains("STUDENTENWG")) {
                property.getExtraFeatures().setRentContract(Rental.STUDENTI);
            } else {
                property.getExtraFeatures().setRentContract(Rental.CONCORDATO);
            }
        }
        property.getExtraFeatures().setSecurityAlarm(this.hasEstateValue("AUSSTATTUNG", "SICHERHEITSTECHNIK", "ALARMANLAGE", estateImpl));
        property.getExtraFeatures().setNet(this.hasEstateValue("AUSSTATTUNG", "TECHNIK", "DV_VERKABELUNG", estateImpl));
        property.getExtraFeatures().setFreeConditions(this.getEstateValueAsString("FREITEXTE", "PREIS_BESCHR", estateImpl));
        object4 = this.getEstateValueAsBoolean("AUSSTATTUNG", "KRAN", estateImpl);
        if (Boolean.TRUE.equals(object4)) {
            property.getExtraFeatures().setOverheadCrane(YesNoReady.YES);
        } else if (Boolean.FALSE.equals(object4)) {
            property.getExtraFeatures().setOverheadCrane(YesNoReady.NO);
        }
        property.getExtraFeatures().setBeamHeight(this.getEstateValueAsBigInteger("AUSSTATTUNG", "HALLENHOEHE", estateImpl));
        object2 = this.getEstateValueAsBigInteger("FLAECHEN", "BUEROFLAECHE", estateImpl);
        if (object2 != null && ((BigInteger)object2).longValue() > 0L) {
            property.getExtraFeatures().setOfficeSize(ImmobiliareUtils.getFactory().createSizeType());
            property.getExtraFeatures().getOfficeSize().setUnit(ImmobiliareUtils.SizeUnit.M2);
            property.getExtraFeatures().getOfficeSize().setValue((BigInteger)object2);
        }
        if ((bigInteger = this.getEstateValueAsBigInteger("FLAECHEN", "GRUNDSTUECKSFLAECHE", estateImpl)) != null && bigInteger.longValue() > 0L) {
            property.getExtraFeatures().setExternalArea(ImmobiliareUtils.getFactory().createLandSizeType());
            property.getExtraFeatures().getExternalArea().setUnit(ImmobiliareUtils.LandSizeUnit.M2);
            property.getExtraFeatures().getExternalArea().setValue(bigInteger);
        }
        if (ImmobiliareUtils.isValidYear(n = this.getEstateValueAsInteger("ZUSTAND", "BAUJAHR", estateImpl))) {
            property.getExtraFeatures().setBuildYear(n);
        }
        if ((d = this.getEstateValueAsDouble("ENERGIEPASS", "VERBRAUCH_GESAMT", estateImpl)) != null && d > 0.0) {
            object = NumberFormat.getNumberInstance(Locale.ENGLISH);
            ((NumberFormat)object).setGroupingUsed(false);
            ((NumberFormat)object).setMinimumFractionDigits(2);
            Boolean bl3 = this.getEstateValueAsBoolean("ENERGIEPASS", "VORHANDEN", estateImpl);
            if (bl3 == null) {
                String string8 = this.getEstateValueAsString("ENERGIEPASS", "ART", estateImpl);
                bl3 = "VERBRAUCH".equals(string8);
            }
            property.getFeatures().setEnergyPerformance(ImmobiliareUtils.getFactory().createClassEnergyPerformance());
            property.getFeatures().getEnergyPerformance().setCertified(bl3);
            property.getFeatures().getEnergyPerformance().setUnit(ImmobiliareUtils.EnergyUnit.KWH_M2ANNO);
            property.getFeatures().getEnergyPerformance().setValue(((Format)object).format(d));
        }
        property.getFeatures().setEnergyClass(ClassEnergy.ESENTE);
        object = this.getEstateValueAsString("ENERGIEPASS", "KLASSE", estateImpl);
        if ("A_PLUS".equals(object)) {
            property.getFeatures().setEnergyClass(ClassEnergy.A_PLUS);
        } else if ("A".equals(object)) {
            property.getFeatures().setEnergyClass(ClassEnergy.A);
        } else if ("B".equals(object)) {
            property.getFeatures().setEnergyClass(ClassEnergy.B);
        } else if ("C".equals(object)) {
            property.getFeatures().setEnergyClass(ClassEnergy.C);
        } else if ("D".equals(object)) {
            property.getFeatures().setEnergyClass(ClassEnergy.D);
        } else if ("E".equals(object)) {
            property.getFeatures().setEnergyClass(ClassEnergy.E);
        } else if ("F".equals(object)) {
            property.getFeatures().setEnergyClass(ClassEnergy.F);
        } else if ("G".equals(object)) {
            property.getFeatures().setEnergyClass(ClassEnergy.G);
        } else {
            object = OpenEstateUtils.getEnergyCertificateClass(d, estateImpl.getAdress().getCountry());
            if ("A_PLUS".equals(object)) {
                property.getFeatures().setEnergyClass(ClassEnergy.A_PLUS);
            } else if ("A".equals(object)) {
                property.getFeatures().setEnergyClass(ClassEnergy.A);
            } else if ("B".equals(object)) {
                property.getFeatures().setEnergyClass(ClassEnergy.B);
            } else if ("C".equals(object)) {
                property.getFeatures().setEnergyClass(ClassEnergy.C);
            } else if ("D".equals(object)) {
                property.getFeatures().setEnergyClass(ClassEnergy.D);
            } else if ("E".equals(object)) {
                property.getFeatures().setEnergyClass(ClassEnergy.E);
            } else if ("F".equals(object)) {
                property.getFeatures().setEnergyClass(ClassEnergy.F);
            } else if ("G".equals(object)) {
                property.getFeatures().setEnergyClass(ClassEnergy.G);
            } else {
                property.getFeatures().setEnergyClass(ClassEnergy.ESENTE);
                property.getFeatures().setEnergyPerformance(ImmobiliareUtils.getFactory().createClassEnergyPerformance());
                property.getFeatures().getEnergyPerformance().setCertified(false);
                property.getFeatures().getEnergyPerformance().setUnit(ImmobiliareUtils.EnergyUnit.KWH_M2ANNO);
                property.getFeatures().getEnergyPerformance().setValue("0");
            }
        }
        Feed.Properties.Property.Pictures pictures = ImmobiliareUtils.getFactory().createFeedPropertiesPropertyPictures();
        Feed.Properties.Property.Blueprints blueprints = ImmobiliareUtils.getFactory().createFeedPropertiesPropertyBlueprints();
        Feed.Properties.Property.Videos videos = ImmobiliareUtils.getFactory().createFeedPropertiesPropertyVideos();
        String string9 = StringUtils.trimToNull((String)this.getBaseUrl());
        if (string9 != null) {
            if (!string9.endsWith("/")) {
                string9 = string9 + "/";
            }
            for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getAttachments()) {
                Object object6;
                String string10;
                if (!estateAttachmentImpl.isName() && !estateAttachmentImpl.isUrl() || !(string10 = StringUtils.trimToEmpty((String)estateAttachmentImpl.getMimeType()).toLowerCase()).startsWith("image/") && !string10.startsWith("video/")) continue;
                URL uRL = null;
                try {
                    if (estateAttachmentImpl.isName()) {
                        uRL = new URL(string9 + estateAttachmentImpl.getFileAsName());
                    } else if (estateAttachmentImpl.isUrl()) {
                        uRL = estateAttachmentImpl.getFileAsUrl();
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Can't set attachment-url!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
                if (uRL == null) continue;
                if (string10.startsWith("video/")) {
                    if (videos.getVideo().size() < 4) {
                        object6 = ImmobiliareUtils.getFactory().createVideoProject();
                        ((VideoProject)object6).setType(VideoType.LOCAL);
                        ((VideoProject)object6).setValue(uRL.toString());
                        videos.getVideo().add((VideoProject)object6);
                    }
                } else if (string10.startsWith("image/")) {
                    object6 = ImmobiliareUtils.getFactory().createPictureExtended();
                    ((PictureExtended)object6).setUrl(uRL.toString());
                    if ("IMAGE_GROUNDPLAN".equalsIgnoreCase(estateAttachmentImpl.getType()) && blueprints.getBlueprint().size() < 10) {
                        ((PictureProject)object6).setPosition(BigInteger.valueOf(blueprints.getBlueprint().size() + 1));
                        blueprints.getBlueprint().add((PictureExtended)object6);
                    } else if (pictures.getPictureUrlAndPicture().size() < 15) {
                        ((PictureProject)object6).setPosition(BigInteger.valueOf(pictures.getPictureUrlAndPicture().size() + 1));
                        pictures.getPictureUrlAndPicture().add((PictureProject)object6);
                    }
                }
                if (pictures.getPictureUrlAndPicture().size() < 15 || blueprints.getBlueprint().size() < 10 || videos.getVideo().size() < 4) continue;
                break;
            }
        }
        if (!pictures.getPictureUrlAndPicture().isEmpty()) {
            property.setPictures(pictures);
        }
        if (!blueprints.getBlueprint().isEmpty()) {
            property.setBlueprints(blueprints);
        }
        if (!videos.getVideo().isEmpty()) {
            property.setVideos(videos);
        }
        return property;
    }

    public Feed createRoot() {
        Feed feed = ImmobiliareUtils.getFactory().createFeed();
        feed.setVersion(Version.fromValue("2.5"));
        feed.setMetadata(ImmobiliareUtils.getFactory().createFeedMetadata());
        feed.getMetadata().setBuildDate(Calendar.getInstance());
        feed.getMetadata().getBuildDate().setTime(this.now);
        feed.getMetadata().setMultipage(ImmobiliareUtils.getFactory().createFeedMetadataMultipage());
        feed.getMetadata().getMultipage().setCurrent(BigInteger.valueOf(1L));
        feed.getMetadata().getMultipage().setLast(BigInteger.valueOf(1L));
        return feed;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public boolean isEnergyCertificateAppendedToDescription() {
        return this.energyCertificateAppendedToDescription;
    }

    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }

    public void setEnergyCertificateAppendedToDescription(boolean bl) {
        this.energyCertificateAppendedToDescription = bl;
    }

    public Feed write(SerializableXmlElement serializableXmlElement) {
        if (serializableXmlElement instanceof AgencyImpl) {
            return this.write((AgencyImpl)serializableXmlElement);
        }
        if (serializableXmlElement instanceof TransferImpl) {
            return this.write((TransferImpl)serializableXmlElement);
        }
        throw new IllegalArgumentException("unsupported src-class: " + (serializableXmlElement != null ? serializableXmlElement.getClass().getName() : "null"));
    }

    public Feed write(AgencyImpl agencyImpl) {
        this.getErrorMap().clear();
        Feed feed = this.createRoot();
        if (agencyImpl == null) {
            LOGGER.warn((Object)"no agency was provided!");
            return feed;
        }
        feed.getMetadata().setPublisher(this.convertAgent(agencyImpl.getAgent()));
        feed.setProperties(ImmobiliareUtils.getFactory().createFeedProperties());
        for (EstateImpl estateImpl : agencyImpl.getEstates().values()) {
            try {
                AgentContactImpl agentContactImpl = null;
                String string = estateImpl.getContactId();
                if (string != null && agencyImpl.getContacts().containsKey(string)) {
                    agentContactImpl = agencyImpl.getContacts().get(string);
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                Feed.Properties.Property property = this.convertEstate(estateImpl, agencyImpl.getAgent(), agentContactImpl, arrayList);
                if (!arrayList.isEmpty() || property == null) {
                    this.putErrors(estateImpl.getId(), arrayList);
                    continue;
                }
                property.setOperation(Operation.WRITE);
                feed.getProperties().getProperty().add(property);
            }
            catch (Exception exception) {
                LOGGER.error((Object)"Fehler beim Parsen der Immobilie!");
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        return feed;
    }

    public Feed write(TransferImpl transferImpl) {
        this.getErrorMap().clear();
        Feed feed = this.createRoot();
        if (transferImpl == null) {
            LOGGER.warn((Object)"no transfer was provided!");
        } else if (transferImpl.getAgencies().isEmpty()) {
            LOGGER.warn((Object)"no transferable agent found!");
        } else {
            Object exception;
            TransferAgencyImpl transferAgencyImpl = transferImpl.getAgencies().get(0);
            feed.getMetadata().setPublisher(this.convertAgent(transferAgencyImpl.getAgent()));
            feed.setProperties(ImmobiliareUtils.getFactory().createFeedProperties());
            for (EstateImpl object2 : transferAgencyImpl.getEstatesToSave()) {
                try {
                    exception = null;
                    String string = object2.getContactId();
                    if (string != null && transferAgencyImpl.getContacts().containsKey(string)) {
                        exception = transferAgencyImpl.getContacts().get(string);
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    Feed.Properties.Property property = this.convertEstate(object2, transferAgencyImpl.getAgent(), (AgentContactImpl)exception, arrayList);
                    if (!arrayList.isEmpty() || property == null) {
                        this.putErrors(object2.getId(), arrayList);
                        continue;
                    }
                    property.setOperation(Operation.WRITE);
                    feed.getProperties().getProperty().add(property);
                }
                catch (Exception exception2) {
                    LOGGER.error((Object)"Fehler beim Parsen der Immobilie!");
                    LOGGER.error((Object)("> " + exception2.getLocalizedMessage()), (Throwable)exception2);
                }
            }
            for (String string : transferAgencyImpl.getEstateIdsToRemove()) {
                try {
                    exception = ImmobiliareUtils.getFactory().createFeedPropertiesProperty();
                    ((Feed.Properties.Property)exception).setOperation(Operation.DELETE);
                    ((Feed.Properties.Property)exception).setUniqueId(string);
                    ((Feed.Properties.Property)exception).setDateUpdated(Calendar.getInstance());
                    ((Feed.Properties.Property)exception).getDateUpdated().setTime(this.now);
                    feed.getProperties().getProperty().add((Feed.Properties.Property)exception);
                }
                catch (Exception exception3) {
                    LOGGER.error((Object)"Fehler beim Parsen der Immobilie!");
                    LOGGER.error((Object)("> " + exception3.getLocalizedMessage()), (Throwable)exception3);
                }
            }
        }
        return feed;
    }

    static {
        ACTIONS.put("MIETE", ImmobiliareUtils.Transaction.RENT);
        ACTIONS.put("PACHT", ImmobiliareUtils.Transaction.RENT);
        ACTIONS.put("ERBPACHT", ImmobiliareUtils.Transaction.RENT);
        ACTIONS.put("WAZ", ImmobiliareUtils.Transaction.RENT);
        ACTIONS.put("KAUF", ImmobiliareUtils.Transaction.SALE);
        CATEGORIES = new HashMap<String, ImmobiliareUtils.Category>();
        CATEGORIES.put("MAIN_GEWERBE", ImmobiliareUtils.Category.COMMERCIALE);
        CATEGORIES.put("MAIN_GRUND", ImmobiliareUtils.Category.COMMERCIALE);
        CATEGORIES.put("MAIN_LANDWIRTSCHAFT", ImmobiliareUtils.Category.COMMERCIALE);
        CATEGORIES.put("MAIN_STELLPLATZ", ImmobiliareUtils.Category.RESIDENZIALE);
        CATEGORIES.put("MAIN_WOHNEN", ImmobiliareUtils.Category.RESIDENZIALE);
        TYPES = new EnumMap<ImmobiliareUtils.Category, Map<String, PropertyType>>(ImmobiliareUtils.Category.class);
        HashMap<String, PropertyType> hashMap = new HashMap<String, PropertyType>();
        hashMap.put("MAIN_GRUND", PropertyType.TERRENO);
        hashMap.put("MAIN_GEWERBE", PropertyType.IMMOBILE);
        TYPES.put(ImmobiliareUtils.Category.COMMERCIALE, hashMap);
        hashMap = new HashMap();
        hashMap.put("WOHNUNG", PropertyType.APPARTAMENTO);
        hashMap.put("DACHWOHNUNG", PropertyType.ATTICO);
        hashMap.put("TERRASSENWOHNUNG", PropertyType.ATTICO);
        hashMap.put("PENTHOUSEWOHNUNG", PropertyType.MANSARDA);
        hashMap.put("MAIN_STELLPLATZ", PropertyType.GARAGE);
        hashMap.put("BESONDERES_HAUS", PropertyType.PALAZZO);
        hashMap.put("HAUS", PropertyType.STABILE);
        hashMap.put("LANDHAUS", PropertyType.RUSTICO);
        hashMap.put("BAUERNHAUS", PropertyType.CASALE);
        hashMap.put("VILLA", PropertyType.VILLA);
        hashMap.put("LOFTWOHNUNG", PropertyType.LOFT);
        hashMap.put("MAIN_WOHNEN", PropertyType.OTHER);
        hashMap.put("REIHENHAUS", PropertyType.VILLETTA_A_SCHIERA);
        TYPES.put(ImmobiliareUtils.Category.RESIDENZIALE, hashMap);
        hashMap = new HashMap();
        hashMap.put("BAUERNHOF", PropertyType.AGRITURISMO);
        hashMap.put("BUNGALOW", PropertyType.BUNGALOW);
        hashMap.put("CHALET", PropertyType.CHALET);
        hashMap.put("BERGHUETTE", PropertyType.BAITA);
        hashMap.put("HOTEL", PropertyType.HOTEL);
        hashMap.put("HOSTEL", PropertyType.HOTEL);
        hashMap.put("FREIZEIT_SPORT", PropertyType.PARCO_VACANZE);
        hashMap.put("ZIMMER", PropertyType.STANZA);
        hashMap.put("FERIENHAUS", PropertyType.CASA_PER_FERIE_GRUPPI);
        TYPES.put(ImmobiliareUtils.Category.VACANZE, hashMap);
        COMMMERCIAL_TYPES = new EnumMap<PropertyType, Map<String, PropertyTypeBusiness>>(PropertyType.class);
        HashMap<String, PropertyTypeBusiness> hashMap2 = new HashMap<String, PropertyTypeBusiness>();
        hashMap2.put("EINKAUFSZENTRUM", PropertyTypeBusiness.CENTRO_COMMERCIALE);
        hashMap2.put("MAIN_LANDWIRTSCHAFT", PropertyTypeBusiness.AZIENDA_AGRICOLA);
        hashMap2.put("RESTAURANT", PropertyTypeBusiness.RISTORANTE);
        hashMap2.put("BAR", PropertyTypeBusiness.BAR);
        hashMap2.put("PIZZERIA", PropertyTypeBusiness.PIZZERIA);
        hashMap2.put("DISKO", PropertyTypeBusiness.DISCOTECA);
        hashMap2.put("FREMDENZIMMER", PropertyTypeBusiness.BED_AND_BREAKFAST);
        hashMap2.put("PENSION", PropertyTypeBusiness.PENSIONE);
        hashMap2.put("GESCHAEFTSLOKAL", PropertyTypeBusiness.NEGOZIO);
        hashMap2.put("FITNESSTUDIO", PropertyTypeBusiness.PALESTRA);
        hashMap2.put("SONNENSTUDIO", PropertyTypeBusiness.ESTETICA_SOLARIUM);
        hashMap2.put("WERKSTATT", PropertyTypeBusiness.AUTO_OFFICINA);
        COMMMERCIAL_TYPES.put(PropertyType.ATTIVIT\u00c0, hashMap2);
        hashMap2 = new HashMap();
        hashMap2.put("WOHNGRUND", PropertyTypeBusiness.RESIDENZIALE);
        hashMap2.put("MAIN_GRUND", PropertyTypeBusiness.RESIDENZIALE);
        hashMap2.put("GEWERBEGRUND", PropertyTypeBusiness.COMMERCIALE);
        hashMap2.put("INDUSTRIEGRUND", PropertyTypeBusiness.INDUSTRIALE);
        hashMap2.put("LAND_FORSTGRUND", PropertyTypeBusiness.AGRICOLO);
        COMMMERCIAL_TYPES.put(PropertyType.TERRENO, hashMap2);
        hashMap2 = new HashMap();
        hashMap2.put("HALLE_LAGER", PropertyTypeBusiness.CAPANNONE);
        hashMap2.put("MAIN_LANDWIRTSCHAFT", PropertyTypeBusiness.AZIENDA_AGRICOLA);
        hashMap2.put("MAIN_STELLPLATZ", PropertyTypeBusiness.GARAGE);
        hashMap2.put("GESCHAEFTSLOKAL", PropertyTypeBusiness.NEGOZIO);
        hashMap2.put("BUERO_PRAXIS", PropertyTypeBusiness.UFFICIO);
        hashMap2.put("HAUS", PropertyTypeBusiness.STABILE);
        hashMap2.put("INDUSTRIEHALLE", PropertyTypeBusiness.CAPANNONE_INDUSTRIALE);
        hashMap2.put("AUSSTELLUNGSFLAECHE", PropertyTypeBusiness.SHOWROOM);
        hashMap2.put("GAST", PropertyTypeBusiness.ALBERGO);
        hashMap2.put("MAIN_GEWERBE", PropertyTypeBusiness.ALTRO);
        COMMMERCIAL_TYPES.put(PropertyType.IMMOBILE, hashMap2);
        TERRAINS = new HashMap<String, TerrainType>();
        TERRAINS.put("ACKERBAU", TerrainType.SEMINATIVO);
        TERRAINS.put("WEINBAU", TerrainType.VIGNETO);
    }
}

