/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.xml;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateConverter;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateTypes;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.xml.KyeroType;
import com.openindex.openestate.impl.xml.kyero.BoolType;
import com.openindex.openestate.impl.xml.kyero.ImagesType;
import com.openindex.openestate.impl.xml.kyero.PriceFreqType;
import com.openindex.openestate.impl.xml.kyero.PropertyType;
import com.openindex.openestate.impl.xml.kyero.Root;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class KyeroReader
extends OpenEstateConverter {
    private static final Logger LOGGER = Logger.getLogger(KyeroReader.class);
    public static final int CONVERT_TO_AGENCY = 0;
    public static final int CONVERT_TO_TRANSFER = 1;
    private Locale[] locales = OpenEstateUtils.getAvailableLocales();

    public KyeroReader() {
    }

    public KyeroReader(Locale locale) {
        this();
        this.setOpenEstateLanguage(locale);
    }

    protected AgentImpl convertAnbieter(Root.Agent agent) {
        AgentImpl agentImpl = this.createEmptyAgent();
        agentImpl.getCompany().setStreet(agent.getAddr1());
        agentImpl.getCompany().setStreet2(agent.getAddr2());
        agentImpl.getCompany().setCompanyMail(agent.getEmail());
        agentImpl.getCompany().setCompanyFax(agent.getFax());
        agentImpl.getCompany().setCompanyMobilePhone(agent.getMob());
        agentImpl.getCompany().setCompanyName(agent.getName());
        agentImpl.getCompany().setPostalCode(agent.getPostcode());
        agentImpl.getCompany().setRegion(agent.getRegion());
        agentImpl.getCompany().setCompanyPhone(agent.getTel());
        agentImpl.getCompany().setCity(agent.getTown());
        return agentImpl;
    }

    protected EstateImpl convertImmobilie(PropertyType propertyType, Map<String, AgentContactImpl> map) throws OpenEstateException {
        List<String> list;
        Object object;
        EstateImpl estateImpl = this.createEmptyEstate();
        OpenEstateType openEstateType = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (propertyType.getType() != null) {
            object = StringUtils.trimToNull((String)propertyType.getType().getEn());
            if (object != null) {
                arrayList.add(object);
            }
            if ((object = StringUtils.trimToNull((String)propertyType.getType().getDe())) != null) {
                arrayList.add(object);
            }
            if ((object = StringUtils.trimToNull((String)propertyType.getType().getEs())) != null) {
                arrayList.add(object);
            }
            if ((object = StringUtils.trimToNull((String)propertyType.getType().getFr())) != null) {
                arrayList.add(object);
            }
            if ((object = StringUtils.trimToNull((String)propertyType.getType().getNl())) != null) {
                arrayList.add(object);
            }
        }
        block2: for (KyeroType image : KyeroType.values()) {
            for (String string : arrayList) {
                if (!image.getXmlValue().equalsIgnoreCase(string) || (openEstateType = image.getType()) == null) continue;
                continue block2;
            }
        }
        if (openEstateType == null) {
            for (String string : arrayList) {
                String list2 = string.replaceAll("\\W", "").trim();
                for (String string2 : OpenEstateTypes.getValues()) {
                    String string3 = string2.replaceAll("\\W", "").trim();
                    if (string3.equalsIgnoreCase(list2)) {
                        openEstateType = OpenEstateType.newInstance(string2);
                        break;
                    }
                    for (Locale locale : this.locales) {
                        String string4 = OpenEstateUtils.translateEstate(string2, locale);
                        if (StringUtils.isBlank((String)string4) || !(string3 = string4.replaceAll("\\W", "").trim()).equalsIgnoreCase(list2)) continue;
                        openEstateType = OpenEstateType.newInstance(string2);
                        break;
                    }
                    if (openEstateType != null) break;
                }
                if (openEstateType == null) continue;
                break;
            }
        }
        if (openEstateType == null) {
            throw new OpenEstateException("Unsupported kyero-type: " + StringUtils.join(arrayList, (String)" / "));
        }
        object = null;
        if (PriceFreqType.SALE.equals((Object)propertyType.getPriceFreq())) {
            object = BoolType.TRUE.equals((Object)propertyType.getLeasehold()) && openEstateType.hasAction("PACHT") ? "PACHT" : "KAUF";
            estateImpl.setType(openEstateType, (String)object);
        } else if (PriceFreqType.WEEK.equals((Object)propertyType.getPriceFreq())) {
            object = "MIETE";
            estateImpl.setType(openEstateType, (String)object);
            this.putEstateValue("PREISE", "MIETE_PRO", "WOCHE", estateImpl);
        } else if (PriceFreqType.MONTH.equals((Object)propertyType.getPriceFreq())) {
            object = "MIETE";
            estateImpl.setType(openEstateType, (String)object);
            this.putEstateValue("PREISE", "MIETE_PRO", "MONAT", estateImpl);
        }
        if ("MIETE".equals(object) && !openEstateType.hasAction("MIETE") && openEstateType.hasAction("WAZ")) {
            object = "WAZ";
            estateImpl.setType(openEstateType, (String)object);
        }
        if (object == null) {
            throw new OpenEstateException("Unknown estate-action!");
        }
        Object var7_10 = null;
        try {
            list = Arrays.asList(OpenEstateUtils.getEstateTypePath(openEstateType));
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not load estate-types!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
        estateImpl.setId(propertyType.getId());
        estateImpl.setPublicId(propertyType.getRef());
        estateImpl.setCurrency(Currency.getInstance(propertyType.getCurrency() != null ? propertyType.getCurrency().value() : "EUR"));
        if ("KAUF".equals(object)) {
            this.putEstateValue("PREISE", "KAUFPREIS", propertyType.getPrice(), estateImpl);
        } else if ("MIETE".equals(object)) {
            this.putEstateValue("PREISE", "KALTMIETE", propertyType.getPrice(), estateImpl);
        } else if ("WAZ".equals(object)) {
            this.putEstateValue("PREISE", "PAUSCHALMIETE", propertyType.getPrice(), estateImpl);
        } else if ("PACHT".equals(object) || "ERBPACHT".equals(object)) {
            this.putEstateValue("PREISE", "PACHT", propertyType.getPrice(), estateImpl);
        }
        if (propertyType.getSurfaceArea() != null) {
            if (propertyType.getSurfaceArea().getPlot() != null) {
                this.putEstateValue("FLAECHEN", "GRUNDSTUECKSFLAECHE", propertyType.getSurfaceArea().getPlot().longValue(), estateImpl);
            }
            if (propertyType.getSurfaceArea().getBuilt() != null) {
                if (list.contains("MAIN_WOHNEN")) {
                    this.putEstateValue("FLAECHEN", "WOHNFLAECHE", propertyType.getSurfaceArea().getBuilt().longValue(), estateImpl);
                } else if (list.contains("MAIN_GEWERBE")) {
                    this.putEstateValue("FLAECHEN", "GEWERBEFLAECHE", propertyType.getSurfaceArea().getBuilt().longValue(), estateImpl);
                } else if (list.contains("MAIN_LANDWIRTSCHAFT")) {
                    this.putEstateValue("FLAECHEN", "NUTZFLAECHE", propertyType.getSurfaceArea().getBuilt().longValue(), estateImpl);
                } else if (list.contains("MAIN_STELLPLATZ")) {
                    this.putEstateValue("FLAECHEN", "STELLPLATZFLAECHE", propertyType.getSurfaceArea().getBuilt().longValue(), estateImpl);
                } else if (list.contains("MAIN_GRUND")) {
                    this.putEstateValue("FLAECHEN", "NUTZFLAECHE", propertyType.getSurfaceArea().getBuilt().longValue(), estateImpl);
                }
            }
        }
        estateImpl.getAdress().setCity(propertyType.getTown());
        estateImpl.getAdress().setCityPart(propertyType.getLocationDetail());
        estateImpl.getAdress().setRegion(propertyType.getProvince());
        estateImpl.getAdress().setCountry("ES");
        if (propertyType.getBaths() != null && propertyType.getBaths().getValue() != null) {
            this.putEstateValue("FLAECHEN", "ANZ_BADEZIMMER", ((BigInteger)propertyType.getBaths().getValue()).longValue(), estateImpl);
        }
        if (propertyType.getBeds() != null && propertyType.getBeds().getValue() != null) {
            this.putEstateValue("FLAECHEN", "ANZ_SCHLAFZIMMER", ((BigInteger)propertyType.getBeds().getValue()).longValue(), estateImpl);
        }
        if (list.contains("MAIN_WOHNEN")) {
            long l = 0L;
            if (propertyType.getBeds() != null && propertyType.getBeds().getValue() != null) {
                l += ((BigInteger)propertyType.getBeds().getValue()).longValue();
            }
            this.putEstateValue("FLAECHEN", "ANZ_ZIMMER", l, estateImpl);
        }
        if (BoolType.TRUE.equals((Object)propertyType.getPool())) {
            this.putEstateValue("AUSSTATTUNG", "SWIMMINGPOOL", true, estateImpl);
        }
        if (propertyType.getDate() != null) {
            this.putEstateValue("VERWALTUNG", "STAND_VOM", propertyType.getDate(), estateImpl);
        }
        if (propertyType.getDesc() != null) {
            if (!StringUtils.isBlank((String)propertyType.getDesc().getDe())) {
                this.putLanguage(estateImpl, "de");
                this.putEstateValue("FREITEXTE", "OBJEKT_BESCHR", propertyType.getDesc().getDe(), estateImpl, new Locale("de"));
            }
            if (!StringUtils.isBlank((String)propertyType.getDesc().getEn())) {
                this.putLanguage(estateImpl, "en");
                this.putEstateValue("FREITEXTE", "OBJEKT_BESCHR", propertyType.getDesc().getEn(), estateImpl, new Locale("en"));
            }
            if (!StringUtils.isBlank((String)propertyType.getDesc().getEs())) {
                this.putLanguage(estateImpl, "es");
                this.putEstateValue("FREITEXTE", "OBJEKT_BESCHR", propertyType.getDesc().getEs(), estateImpl, new Locale("es"));
            }
            if (!StringUtils.isBlank((String)propertyType.getDesc().getFr())) {
                this.putLanguage(estateImpl, "fr");
                this.putEstateValue("FREITEXTE", "OBJEKT_BESCHR", propertyType.getDesc().getFr(), estateImpl, new Locale("fr"));
            }
            if (!StringUtils.isBlank((String)propertyType.getDesc().getNl())) {
                this.putLanguage(estateImpl, "nl");
                this.putEstateValue("FREITEXTE", "OBJEKT_BESCHR", propertyType.getDesc().getNl(), estateImpl, new Locale("nl"));
            }
        }
        if (propertyType.getImages() != null) {
            for (ImagesType.Image image : propertyType.getImages().getImage()) {
                EstateAttachmentImpl estateAttachmentImpl = new EstateAttachmentImpl();
                estateAttachmentImpl.setFile(image.getUrl());
                if (image.getTitle() != null) {
                    if (!StringUtils.isBlank((String)image.getTitle().getDe())) {
                        this.putLanguage(estateImpl, "de");
                        estateAttachmentImpl.setTitle(image.getTitle().getDe(), "de");
                    }
                    if (!StringUtils.isBlank((String)image.getTitle().getEn())) {
                        this.putLanguage(estateImpl, "en");
                        estateAttachmentImpl.setTitle(image.getTitle().getEn(), "en");
                    }
                    if (!StringUtils.isBlank((String)image.getTitle().getEs())) {
                        this.putLanguage(estateImpl, "es");
                        estateAttachmentImpl.setTitle(image.getTitle().getEs(), "es");
                    }
                    if (!StringUtils.isBlank((String)image.getTitle().getFr())) {
                        this.putLanguage(estateImpl, "fr");
                        estateAttachmentImpl.setTitle(image.getTitle().getFr(), "fr");
                    }
                    if (!StringUtils.isBlank((String)image.getTitle().getNl())) {
                        this.putLanguage(estateImpl, "nl");
                        estateAttachmentImpl.setTitle(image.getTitle().getNl(), "nl");
                    }
                }
                estateImpl.getAttachments().add(estateAttachmentImpl);
            }
        }
        for (String string : estateImpl.getLanguages()) {
            Locale locale = null;
            for (Locale locale2 : OpenEstateUtils.getAvailableLocales()) {
                if (!locale2.getLanguage().equals(string)) continue;
                locale = locale2;
                break;
            }
            if (locale == null) continue;
            String string5 = OpenEstateUtils.translateEstate(estateImpl.getType().getName(), locale);
            String string6 = OpenEstateUtils.translateAction(estateImpl.getAction(), locale);
            if (string5 == null || string6 == null) continue;
            estateImpl.setTitle(string5 + " / " + string6, string);
        }
        return estateImpl;
    }

    protected AgentImpl createEmptyAgent() {
        return new AgentImpl();
    }

    protected EstateImpl createEmptyEstate() {
        return new EstateImpl();
    }

    private void putLanguage(EstateImpl estateImpl, String string) {
        if (!estateImpl.getLanguages().contains(string)) {
            estateImpl.getLanguages().add(string);
        }
    }

    public SerializableXmlElement read(Root root, int n) {
        switch (n) {
            case 0: {
                return this.readAgency(root);
            }
            case 1: {
                return this.readTransfer(root);
            }
        }
        throw new IllegalArgumentException("invalid convert-mode: " + n);
    }

    public AgencyImpl readAgency(Root root) {
        this.getErrorMap().clear();
        AgentImpl agentImpl = root.getAgent() != null ? this.convertAnbieter(root.getAgent()) : this.createEmptyAgent();
        agentImpl.setId("Agent.1");
        AgencyImpl agencyImpl = new AgencyImpl();
        agencyImpl.setAgent(agentImpl);
        HashMap<String, AgentContactImpl> hashMap = new HashMap<String, AgentContactImpl>();
        for (PropertyType object : root.getProperty()) {
            try {
                EstateImpl estateImpl = this.convertImmobilie(object, hashMap);
                if (estateImpl == null) continue;
                agencyImpl.getEstates().put(estateImpl.getId(), estateImpl);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"could not read agency-estate!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            agencyImpl.getContacts().put((String)entry.getKey(), (AgentContactImpl)entry.getValue());
        }
        return agencyImpl;
    }

    public TransferImpl readTransfer(Root root) {
        this.getErrorMap().clear();
        AgentImpl agentImpl = root.getAgent() != null ? this.convertAnbieter(root.getAgent()) : this.createEmptyAgent();
        agentImpl.setId("Agent.1");
        TransferImpl transferImpl = new TransferImpl();
        TransferAgencyImpl transferAgencyImpl = new TransferAgencyImpl();
        transferAgencyImpl.setRemoveUnmodifiedEstates(false);
        transferAgencyImpl.setAgent(agentImpl);
        HashMap<String, AgentContactImpl> hashMap = new HashMap<String, AgentContactImpl>();
        for (PropertyType object : root.getProperty()) {
            try {
                EstateImpl estateImpl = this.convertImmobilie(object, hashMap);
                if (estateImpl == null) continue;
                transferAgencyImpl.getEstatesToSave().add(estateImpl);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"could not read agency-estate!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            transferAgencyImpl.getContacts().put((String)entry.getKey(), (AgentContactImpl)entry.getValue());
        }
        transferImpl.getAgencies().add(transferAgencyImpl);
        return transferImpl;
    }
}

