/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.xml;

import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateType;
import org.apache.log4j.Logger;

public enum KyeroType {
    APARTMENT("apartment", "WOHNUNG", true),
    APARTMENT_DUPLEX("duplex", "DOPPELHAUSHAELFTE", true),
    APARTMENT_PENTHOUSE("penthouse", "PENTHOUSEWOHNUNG", true),
    APARTMENT_STUDIO("studio", "STUDIOWOHNUNG", true),
    APARTMENT_TRIPLEX("triplex", "WOHNUNG", false),
    VILLA("villa", "VILLA", true),
    VILLA_BUNGALOW("bungalow", "BUNGALOW", true),
    TOWN_HOUSE("town house", "HAUS", true),
    TOWN_HOUSE_TERRACED("terraced house", "REIHENHAUS", true),
    TOWN_HOUSE_VILLAGE("village house", "STADTHAUS", false),
    COUNTRY_HOUSE("country house", "LANDHAUS", true),
    COUNTRY_HOUSE_FARM("farm", "BAUERNHOF", true),
    COUNTRY_HOUSE_FARM_HOUSE("farmhouse", "BAUERNHAUS", true),
    COUNTRY_HOUSE_CORTIJO("cortijo", "LANDHAUS", false),
    COUNTRY_HOUSE_FINCA("finca", "GARTENHAUS", true),
    LAND("land", "MAIN_GRUND", true),
    LAND_RUIN("ruin", "MAIN_GRUND", false),
    CAVE_HOUSE("cave house", "MAIN_WOHNEN", false),
    GARAGE("garage", "GARAGE", true),
    GARAGE_PARKING_SPACE("parking space", "MAIN_STELLPLATZ", true),
    COMMERCIAL_PROPERTY("commercial property", "MAIN_GEWERBE", true),
    WOODEN_HOME("wooden home", "MAIN_WOHNEN", false),
    WOODEN_HOME_MOBILE("mobile home", "MAIN_WOHNEN", false),
    WOODEN_HOME_CHALET("wooden chalet", "MAIN_WOHNEN", false);

    private static final Logger LOGGER;
    private final String xmlValue;
    private final String typeName;
    private final boolean writable;

    private KyeroType(String string2, String string3, boolean bl) {
        this.xmlValue = string2;
        this.typeName = string3;
        this.writable = bl;
    }

    public OpenEstateType getType() {
        try {
            return OpenEstateType.newInstance(this.typeName);
        }
        catch (OpenEstateException openEstateException) {
            LOGGER.warn((Object)("Can't load estate type from '" + this.name() + "'!"));
            LOGGER.warn((Object)("> " + openEstateException.getLocalizedMessage()), (Throwable)openEstateException);
            return null;
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getXmlValue() {
        return this.xmlValue;
    }

    public boolean isWritable() {
        return this.writable;
    }

    static {
        LOGGER = Logger.getLogger(KyeroType.class);
    }
}

