/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.xml;

import com.openindex.openestate.impl.xml.kyero.ObjectFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;

public class KyeroUtils {
    private static final Logger LOGGER = Logger.getLogger(KyeroUtils.class);
    public static final String PACKAGE = "com.openindex.openestate.impl.xml.kyero";
    public static final String VERSION = "2.1";
    private static final ObjectFactory FACTORY = new ObjectFactory();
    private static JAXBContext JAXB = null;

    private KyeroUtils() {
    }

    public static Marshaller createMarshaller() throws JAXBException {
        return KyeroUtils.createMarshaller(Charset.defaultCharset().name(), true);
    }

    public static Marshaller createMarshaller(String string, boolean bl) throws JAXBException {
        Marshaller marshaller = KyeroUtils.getContext().createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)string);
        marshaller.setProperty("jaxb.formatted.output", (Object)bl);
        return marshaller;
    }

    public static Unmarshaller createUnmarshaller() throws JAXBException {
        return KyeroUtils.getContext().createUnmarshaller();
    }

    public static JAXBContext getContext() throws JAXBException {
        if (JAXB == null) {
            JAXB = JAXBContext.newInstance((String)PACKAGE);
        }
        return JAXB;
    }

    public static DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static DateFormat getDateFormatAlternative() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static ObjectFactory getFactory() {
        return FACTORY;
    }

    public static boolean isValidCustomIdType(Integer n) {
        return n != null && n > 0 && n <= 4;
    }

    public static boolean isValidFeedVersionType(String string) {
        return string != null && string.length() > 0 && string.length() <= 3;
    }

    public static boolean isValidIdType(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean isValidImageAttributeType(Integer n) {
        return n != null && n >= 0 && n <= 100;
    }

    public static boolean isValidImageUrlType(URL uRL) {
        if (uRL == null) {
            return false;
        }
        if (!"http".equals(uRL.getProtocol()) && !"ftp".equals(uRL.getProtocol())) {
            return false;
        }
        if (uRL.getPath() == null) {
            return false;
        }
        String string = uRL.getPath().toLowerCase();
        return string.endsWith(".gif") || string.endsWith(".jpg") || string.endsWith(".jpeg") || string.endsWith(".png");
    }

    public static boolean isValidRefType(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean isValidRequiredType(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean isValidTypeDataType(String string) {
        return string != null && string.matches("([a-zA-Z&\\s\\(\\)/\\-]+)");
    }

    public static boolean isValidUrlType(URL uRL) {
        if (uRL == null) {
            return false;
        }
        if (!"http".equals(uRL.getProtocol())) {
            return false;
        }
        return uRL.toString().length() <= 255;
    }

    public static Integer parseCustomIdType(String string) {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn((Object)"Can't parse custom-id!");
            LOGGER.warn((Object)("> value: " + string));
            LOGGER.warn((Object)("> " + numberFormatException.getLocalizedMessage()), (Throwable)numberFormatException);
            return null;
        }
    }

    public static Calendar parseDateType(String string) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(KyeroUtils.getDateFormat().parse(string));
            return calendar;
        }
        catch (ParseException parseException) {
            try {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(KyeroUtils.getDateFormatAlternative().parse(string));
                return calendar;
            }
            catch (ParseException parseException2) {
                LOGGER.warn((Object)"Can't parse date!");
                LOGGER.warn((Object)("> value: " + string));
                LOGGER.warn((Object)("> " + parseException.getLocalizedMessage()), (Throwable)parseException);
                return null;
            }
        }
    }

    public static String parseFeedVersionType(String string) {
        return string;
    }

    public static String parseIdType(String string) {
        return string;
    }

    public static Integer parseImageAttributeType(String string) {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn((Object)"Can't parse image-attribute!");
            LOGGER.warn((Object)("> value: " + string));
            LOGGER.warn((Object)("> " + numberFormatException.getLocalizedMessage()), (Throwable)numberFormatException);
            return null;
        }
    }

    public static URL parseImageUrlType(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.warn((Object)"Can't parse image-url!");
            LOGGER.warn((Object)("> value: " + string));
            LOGGER.warn((Object)("> " + malformedURLException.getLocalizedMessage()), (Throwable)malformedURLException);
            return null;
        }
    }

    public static String parseLocationType(String string) {
        return string;
    }

    public static Long parsePriceType(String string) {
        try {
            return Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn((Object)"Can't parse price!");
            LOGGER.warn((Object)("> value: " + string));
            LOGGER.warn((Object)("> " + numberFormatException.getLocalizedMessage()), (Throwable)numberFormatException);
            return null;
        }
    }

    public static String parseRefType(String string) {
        return string;
    }

    public static String parseRequiredType(String string) {
        return string;
    }

    public static String parseTypeDataType(String string) {
        return string;
    }

    public static URL parseUrlType(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.warn((Object)"Can't parse url!");
            LOGGER.warn((Object)("> value: " + string));
            LOGGER.warn((Object)("> " + malformedURLException.getLocalizedMessage()), (Throwable)malformedURLException);
            return null;
        }
    }

    public static String printCustomIdType(Integer n) {
        if (KyeroUtils.isValidCustomIdType(n)) {
            return n.toString();
        }
        throw new IllegalArgumentException("Invalid custom-id value: " + n);
    }

    public static String printDateType(Calendar calendar) {
        if (calendar != null) {
            return KyeroUtils.getDateFormat().format(calendar.getTime());
        }
        throw new IllegalArgumentException("Date value is null!");
    }

    public static String printFeedVersionType(String string) {
        if (KyeroUtils.isValidFeedVersionType(string)) {
            return string.toString();
        }
        throw new IllegalArgumentException("Invalid feed-version value: " + string);
    }

    public static String printIdType(String string) {
        if (KyeroUtils.isValidIdType(string)) {
            return string.length() > 20 ? string.substring(0, 20) : string.toString();
        }
        throw new IllegalArgumentException("Invalid id value: " + string);
    }

    public static String printImageAttributeType(Integer n) {
        if (KyeroUtils.isValidImageAttributeType(n)) {
            return n.toString();
        }
        throw new IllegalArgumentException("Invalid image-attribute value: " + n);
    }

    public static String printImageUrlType(URL uRL) {
        if (KyeroUtils.isValidImageUrlType(uRL)) {
            return uRL.toString();
        }
        throw new IllegalArgumentException("Invalid image-url value: " + uRL);
    }

    public static String printLocationType(String string) {
        if (string != null) {
            return string.length() > 50 ? string.substring(0, 50) : string;
        }
        throw new IllegalArgumentException("Location value is null!");
    }

    public static String printPriceType(Long l) {
        if (l != null) {
            return l.toString();
        }
        throw new IllegalArgumentException("Price value is null!");
    }

    public static String printRefType(String string) {
        if (KyeroUtils.isValidRefType(string)) {
            return string.length() > 15 ? string.substring(0, 15) : string.toString();
        }
        throw new IllegalArgumentException("Invalid ref value: " + string);
    }

    public static String printRequiredType(String string) {
        if (KyeroUtils.isValidRequiredType(string)) {
            return string.toString();
        }
        throw new IllegalArgumentException("Invalid required value: " + string);
    }

    public static String printTypeDataType(String string) {
        if (KyeroUtils.isValidTypeDataType(string)) {
            return string.toString();
        }
        throw new IllegalArgumentException("Invalid type-data value: " + string);
    }

    public static String printUrlType(URL uRL) {
        if (KyeroUtils.isValidUrlType(uRL)) {
            return uRL.toString();
        }
        throw new IllegalArgumentException("Invalid url value: " + uRL);
    }
}

