/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.xml;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateAttribsAusstattung;
import com.openindex.openestate.impl.OpenEstateConverter;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.ValueImpl;
import com.openindex.openestate.impl.attribs.ComplexEnumAttrib;
import com.openindex.openestate.impl.attribs.SimpleBooleanAttrib;
import com.openindex.openestate.impl.attribs.SimpleEnumAttrib;
import com.openindex.openestate.impl.xml.KyeroType;
import com.openindex.openestate.impl.xml.KyeroUtils;
import com.openindex.openestate.impl.xml.kyero.BoolType;
import com.openindex.openestate.impl.xml.kyero.CurrencyType;
import com.openindex.openestate.impl.xml.kyero.ImagesType;
import com.openindex.openestate.impl.xml.kyero.PriceFreqType;
import com.openindex.openestate.impl.xml.kyero.PropertyType;
import com.openindex.openestate.impl.xml.kyero.Root;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class KyeroWriter
extends OpenEstateConverter {
    private static final Logger LOGGER = Logger.getLogger(KyeroWriter.class);
    private Date now = new Date();
    private String baseUrl = null;
    private boolean energyCertificateAppendedToDescription = false;

    public KyeroWriter() {
    }

    public KyeroWriter(Locale locale) {
        this();
        this.setOpenEstateLanguage(locale);
    }

    public Root.Agent convertAgent(AgentImpl agentImpl) {
        Root.Agent agent = KyeroUtils.getFactory().createRootAgent();
        agent.setAddr1(agentImpl.getCompany().getStreet());
        agent.setAddr2(agentImpl.getCompany().getStreet2());
        agent.setCountry(agentImpl.getCompany().writeCountry(this.getOpenEstateLanguage()));
        agent.setEmail(agentImpl.getCompany().getCompanyMail());
        agent.setFax(agentImpl.getCompany().getCompanyFax());
        agent.setMob(agentImpl.getCompany().getCompanyMobilePhone());
        agent.setName(agentImpl.getCompany().getCompanyName());
        agent.setPostcode(agentImpl.getCompany().getPostalCode());
        agent.setRegion(agentImpl.getCompany().getRegion());
        agent.setTel(agentImpl.getCompany().getCompanyPhone());
        agent.setTown(agentImpl.getCompany().getCity());
        return agent;
    }

    public PropertyType convertEstate(EstateImpl estateImpl, List<String> list) throws OpenEstateException {
        Object object;
        String string;
        Object object22;
        String string2;
        Object object3;
        Object object4;
        Object object5;
        PropertyType propertyType = KyeroUtils.getFactory().createPropertyType();
        KyeroType kyeroType = null;
        List<String> list2 = Arrays.asList(OpenEstateUtils.getEstateTypePath(estateImpl.getType()));
        for (int i = list2.size() - 1; i > -1; --i) {
            object5 = list2.get(i);
            object4 = KyeroType.values();
            int n = ((KyeroType[])object4).length;
            for (int j = 0; j < n; ++j) {
                object3 = object4[j];
                if (!object3.isWritable() || !object3.getTypeName().equalsIgnoreCase((String)object5)) continue;
                kyeroType = object3;
                break;
            }
            if (kyeroType != null) break;
        }
        if (kyeroType == null) {
            if (list2.contains("MAIN_GEWERBE")) {
                kyeroType = KyeroType.COMMERCIAL_PROPERTY;
            } else if (list2.contains("MAIN_LANDWIRTSCHAFT")) {
                kyeroType = KyeroType.COUNTRY_HOUSE;
            } else if (list2.contains("MAIN_GRUND")) {
                kyeroType = KyeroType.LAND;
            } else if (list2.contains("MAIN_STELLPLATZ")) {
                kyeroType = KyeroType.GARAGE_PARKING_SPACE;
            } else if (list2.contains("MAIN_WOHNEN")) {
                kyeroType = KyeroType.APARTMENT;
            }
        }
        if (kyeroType == null) {
            list.add("Immobilienart ist nicht exportierbar: " + estateImpl.getType().getName());
            return null;
        }
        propertyType.setType(KyeroUtils.getFactory().createEnLangType());
        propertyType.getType().setEn(kyeroType.getXmlValue());
        if ("KAUF".equals(estateImpl.getAction())) {
            propertyType.setPriceFreq(PriceFreqType.SALE);
            propertyType.setPrice(this.getEstateValueAsLong("PREISE", "KAUFPREIS", estateImpl));
        } else if ("PACHT".equals(estateImpl.getAction()) || "ERBPACHT".equals(estateImpl.getAction())) {
            propertyType.setLeasehold(BoolType.TRUE);
            propertyType.setPriceFreq(PriceFreqType.SALE);
            propertyType.setPrice(this.getEstateValueAsLong("PREISE", "PACHT", estateImpl));
        } else if ("MIETE".equals(estateImpl.getAction())) {
            propertyType.setPriceFreq(PriceFreqType.MONTH);
            propertyType.setPrice(this.getEstateValueAsLong("PREISE", "KALTMIETE", estateImpl));
            if (propertyType.getPrice() == null) {
                propertyType.setPrice(this.getEstateValueAsLong("PREISE", "WARMMIETE", estateImpl));
            }
        } else if ("WAZ".equals(estateImpl.getAction())) {
            String string3 = this.getEstateValueAsString("PREISE", "MIETE_PRO", estateImpl);
            if ("MONAT".equals(string3)) {
                propertyType.setPriceFreq(PriceFreqType.MONTH);
            } else if ("WOCHE".equals(string3)) {
                propertyType.setPriceFreq(PriceFreqType.WEEK);
            }
            propertyType.setPrice(this.getEstateValueAsLong("PREISE", "PAUSCHALMIETE", estateImpl));
        }
        if (propertyType.getPriceFreq() == null) {
            list.add("Vermarktungsart ist nicht exportierbar: " + estateImpl.getAction());
            return null;
        }
        if (propertyType.getPrice() == null) {
            list.add("Kein Preis ermittelbar!");
            return null;
        }
        try {
            propertyType.setCurrency(CurrencyType.valueOf(estateImpl.getCurrency().getCurrencyCode()));
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't export currency!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            list.add("W\u00e4hrung ist nicht exportierbar: " + estateImpl.getCurrency());
            return null;
        }
        propertyType.setId(StringUtils.trimToNull((String)estateImpl.getId()));
        propertyType.setRef(StringUtils.defaultIfBlank((String)StringUtils.trimToNull((String)estateImpl.getPublicId()), (String)propertyType.getId()));
        propertyType.setDate(Calendar.getInstance());
        propertyType.getDate().setTime(this.now);
        propertyType.setTown(StringUtils.trimToNull((String)estateImpl.getAdress().getCity()));
        propertyType.setLocationDetail(StringUtils.trimToNull((String)estateImpl.getAdress().getCityPart()));
        propertyType.setProvince(StringUtils.defaultIfBlank((String)StringUtils.trimToNull((String)estateImpl.getAdress().getRegion()), (String)propertyType.getTown()));
        if (!KyeroUtils.isValidRequiredType(propertyType.getTown())) {
            list.add("Ort ist nicht angegeben!");
            return null;
        }
        if (!KyeroUtils.isValidRequiredType(propertyType.getProvince())) {
            list.add("Region / Provinz ist nicht angegeben!");
            return null;
        }
        BigInteger bigInteger = this.getEstateValueAsBigInteger("FLAECHEN", "ANZ_BADEZIMMER", estateImpl);
        if (bigInteger != null) {
            propertyType.setBaths((JAXBElement<BigInteger>)new JAXBElement(new QName("baths"), BigInteger.class, (Object)bigInteger));
        }
        if ((object5 = this.getEstateValueAsBigInteger("FLAECHEN", "ANZ_SCHLAFZIMMER", estateImpl)) != null) {
            propertyType.setBeds((JAXBElement<BigInteger>)new JAXBElement(new QName("beds"), BigInteger.class, object5));
        }
        if (Boolean.TRUE.equals(object4 = this.getEstateValueAsBoolean("AUSSTATTUNG", "SWIMMINGPOOL", estateImpl))) {
            propertyType.setPool(BoolType.TRUE);
        }
        propertyType.setSurfaceArea(KyeroUtils.getFactory().createSurfaceType());
        BigInteger bigInteger2 = this.getEstateValueAsBigInteger("FLAECHEN", "GRUNDSTUECKSFLAECHE", estateImpl);
        if (bigInteger2 != null) {
            propertyType.getSurfaceArea().setPlot(bigInteger2);
        }
        BigInteger bigInteger3 = null;
        if (list2.contains("MAIN_LANDWIRTSCHAFT")) {
            bigInteger3 = this.getEstateValueAsBigInteger("FLAECHEN", "GESAMTFLAECHE", estateImpl);
        } else if (list2.contains("MAIN_GEWERBE")) {
            bigInteger3 = this.getEstateValueAsBigInteger("FLAECHEN", "GEWERBEFLAECHE", estateImpl);
        } else if (list2.contains("MAIN_STELLPLATZ")) {
            bigInteger3 = this.getEstateValueAsBigInteger("FLAECHEN", "STELLPLATZFLAECHE", estateImpl);
        } else if (list2.contains("MAIN_WOHNEN")) {
            bigInteger3 = this.getEstateValueAsBigInteger("FLAECHEN", "WOHNFLAECHE", estateImpl);
        }
        if (bigInteger3 == null) {
            bigInteger3 = this.getEstateValueAsBigInteger("FLAECHEN", "GESAMTFLAECHE", estateImpl);
        }
        if (bigInteger3 != null) {
            propertyType.getSurfaceArea().setBuilt(bigInteger3);
        }
        if ((object3 = estateImpl.getAttribute("FREITEXTE", "OBJEKT_BESCHR")) != null) {
            string2 = this.getXmlLineSeparator() + this.getXmlLineSeparator() + StringUtils.repeat((String)"-", (int)15) + this.getXmlLineSeparator() + this.getXmlLineSeparator();
            for (String iterator : ((ValueImpl)object3).getLangages()) {
                object22 = (String)((ValueImpl)object3).getValueObject(iterator);
                if ("de".equalsIgnoreCase(iterator)) {
                    if (propertyType.getDesc() == null) {
                        propertyType.setDesc(KyeroUtils.getFactory().createLangType());
                    }
                    propertyType.getDesc().setDe((String)object22);
                    if (!this.isEnergyCertificateAppendedToDescription() || StringUtils.isBlank((String)(string = OpenEstateUtils.writeEstateEnergyCertificate(estateImpl, new Locale("de"), this.getXmlLineSeparator())))) continue;
                    object = StringUtils.trimToNull((String)propertyType.getDesc().getDe());
                    object = object == null ? string : string + string2 + (String)object;
                    propertyType.getDesc().setDe(StringUtils.trimToEmpty((String)object));
                    continue;
                }
                if ("en".equalsIgnoreCase(iterator)) {
                    if (propertyType.getDesc() == null) {
                        propertyType.setDesc(KyeroUtils.getFactory().createLangType());
                    }
                    propertyType.getDesc().setEn((String)object22);
                    if (!this.isEnergyCertificateAppendedToDescription() || StringUtils.isBlank((String)(string = OpenEstateUtils.writeEstateEnergyCertificate(estateImpl, new Locale("en"), this.getXmlLineSeparator())))) continue;
                    object = StringUtils.trimToNull((String)propertyType.getDesc().getEn());
                    object = object == null ? string : string + string2 + (String)object;
                    propertyType.getDesc().setEn(StringUtils.trimToEmpty((String)object));
                    continue;
                }
                if ("es".equalsIgnoreCase(iterator)) {
                    if (propertyType.getDesc() == null) {
                        propertyType.setDesc(KyeroUtils.getFactory().createLangType());
                    }
                    propertyType.getDesc().setEs((String)object22);
                    if (!this.isEnergyCertificateAppendedToDescription() || StringUtils.isBlank((String)(string = OpenEstateUtils.writeEstateEnergyCertificate(estateImpl, new Locale("es"), this.getXmlLineSeparator())))) continue;
                    object = StringUtils.trimToNull((String)propertyType.getDesc().getEs());
                    object = object == null ? string : string + string2 + (String)object;
                    propertyType.getDesc().setEs(StringUtils.trimToEmpty((String)object));
                    continue;
                }
                if ("fr".equalsIgnoreCase(iterator)) {
                    if (propertyType.getDesc() == null) {
                        propertyType.setDesc(KyeroUtils.getFactory().createLangType());
                    }
                    propertyType.getDesc().setFr((String)object22);
                    if (!this.isEnergyCertificateAppendedToDescription() || StringUtils.isBlank((String)(string = OpenEstateUtils.writeEstateEnergyCertificate(estateImpl, new Locale("fr"), this.getXmlLineSeparator())))) continue;
                    object = StringUtils.trimToNull((String)propertyType.getDesc().getFr());
                    object = object == null ? string : string + string2 + (String)object;
                    propertyType.getDesc().setFr(StringUtils.trimToEmpty((String)object));
                    continue;
                }
                if (!"nl".equalsIgnoreCase(iterator)) continue;
                if (propertyType.getDesc() == null) {
                    propertyType.setDesc(KyeroUtils.getFactory().createLangType());
                }
                propertyType.getDesc().setNl((String)object22);
                if (!this.isEnergyCertificateAppendedToDescription() || StringUtils.isBlank((String)(string = OpenEstateUtils.writeEstateEnergyCertificate(estateImpl, new Locale("nl"), this.getXmlLineSeparator())))) continue;
                object = StringUtils.trimToNull((String)propertyType.getDesc().getNl());
                object = object == null ? string : string + string2 + (String)object;
                propertyType.getDesc().setNl(StringUtils.trimToEmpty((String)object));
            }
        }
        if ((string2 = StringUtils.trimToNull((String)this.getBaseUrl())) != null) {
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getAttachments()) {
                if (estateAttachmentImpl == null || !estateAttachmentImpl.isName() && !estateAttachmentImpl.isUrl() || !estateAttachmentImpl.getMimeType().startsWith("image/")) continue;
                ImagesType.Image image = KyeroUtils.getFactory().createImagesTypeImage();
                try {
                    if (estateAttachmentImpl.isUrl()) {
                        image.setUrl(estateAttachmentImpl.getFileAsUrl());
                    } else {
                        image.setUrl(new URL(string2 + estateAttachmentImpl.getFileAsName()));
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Can't set attachment-url!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    continue;
                }
                for (Object object22 : estateAttachmentImpl.getTitleLanguages()) {
                    if ("de".equalsIgnoreCase((String)object22)) {
                        if (image.getTitle() == null) {
                            image.setTitle(KyeroUtils.getFactory().createLangType());
                        }
                        image.getTitle().setDe(estateAttachmentImpl.getTitle((String)object22));
                    }
                    if ("en".equalsIgnoreCase((String)object22)) {
                        if (image.getTitle() == null) {
                            image.setTitle(KyeroUtils.getFactory().createLangType());
                        }
                        image.getTitle().setEn(estateAttachmentImpl.getTitle((String)object22));
                    }
                    if ("es".equalsIgnoreCase((String)object22)) {
                        if (image.getTitle() == null) {
                            image.setTitle(KyeroUtils.getFactory().createLangType());
                        }
                        image.getTitle().setEs(estateAttachmentImpl.getTitle((String)object22));
                    }
                    if ("fr".equalsIgnoreCase((String)object22)) {
                        if (image.getTitle() == null) {
                            image.setTitle(KyeroUtils.getFactory().createLangType());
                        }
                        image.getTitle().setFr(estateAttachmentImpl.getTitle((String)object22));
                    }
                    if (!"nl".equalsIgnoreCase((String)object22)) continue;
                    if (image.getTitle() == null) {
                        image.setTitle(KyeroUtils.getFactory().createLangType());
                    }
                    image.getTitle().setNl(estateAttachmentImpl.getTitle((String)object22));
                }
                if (propertyType.getImages() == null) {
                    propertyType.setImages(KyeroUtils.getFactory().createImagesType());
                }
                image.setPrimary(propertyType.getImages().getImage().isEmpty() ? BoolType.TRUE : BoolType.FALSE);
                image.setId(propertyType.getImages().getImage().size() + 1);
                propertyType.getImages().getImage().add(image);
                if (propertyType.getImages().getImage().size() < 10) continue;
                break;
            }
        }
        propertyType.setFeatures(KyeroUtils.getFactory().createFeaturesType());
        for (String string3 : OpenEstateAttribsAusstattung.getValues()) {
            String[] stringArray;
            if ("SWIMMINGPOOL".equals(string3) || !estateImpl.getType().hasAttrib("AUSSTATTUNG", string3) || !estateImpl.hasAttribute("AUSSTATTUNG", string3)) continue;
            object22 = estateImpl.getType().getAttrib("AUSSTATTUNG", string3);
            string = OpenEstateUtils.translateAttribute(((OpenEstateAttrib)object22).getGroup(), ((OpenEstateAttrib)object22).getName(), Locale.ENGLISH);
            object = estateImpl.getAttribute(((OpenEstateAttrib)object22).getGroup(), ((OpenEstateAttrib)object22).getName());
            if (object22 instanceof SimpleBooleanAttrib) {
                if (Boolean.TRUE.equals(((ValueImpl)object).getValueObject())) {
                    propertyType.getFeatures().getFeature().add(string);
                }
            } else if (object22 instanceof SimpleEnumAttrib) {
                stringArray = StringUtils.trimToNull((String)((ValueImpl)object).writeValue(Locale.ENGLISH));
                if (stringArray != null) {
                    propertyType.getFeatures().getFeature().add(string + " / " + (String)stringArray);
                }
            } else if (object22 instanceof ComplexEnumAttrib) {
                for (String string4 : stringArray = (String[])((ValueImpl)object).getValueObject()) {
                    String string5 = StringUtils.trimToNull((String)OpenEstateUtils.translateAttribute(((OpenEstateAttrib)object22).getGroup(), ((OpenEstateAttrib)object22).getName(), string4, Locale.ENGLISH));
                    if (string5 == null) continue;
                    propertyType.getFeatures().getFeature().add(string + " / " + string5);
                    if (propertyType.getFeatures().getFeature().size() >= 50) break;
                }
            }
            if (propertyType.getFeatures().getFeature().size() >= 50) break;
        }
        if (propertyType.getFeatures().getFeature().isEmpty()) {
            propertyType.getFeatures().getFeature().add("No features provided");
        }
        return propertyType;
    }

    public Root createRoot() {
        Root root = KyeroUtils.getFactory().createRoot();
        root.setKyero(KyeroUtils.getFactory().createKyeroType());
        root.getKyero().setFeedVersion("2.1".replace('.', '_'));
        root.getKyero().setFeedGenerated(Calendar.getInstance());
        root.getKyero().getFeedGenerated().setTime(this.now);
        return root;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public boolean isEnergyCertificateAppendedToDescription() {
        return this.energyCertificateAppendedToDescription;
    }

    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }

    public void setEnergyCertificateAppendedToDescription(boolean bl) {
        this.energyCertificateAppendedToDescription = bl;
    }

    public Root write(SerializableXmlElement serializableXmlElement) {
        if (serializableXmlElement instanceof AgencyImpl) {
            return this.write((AgencyImpl)serializableXmlElement);
        }
        if (serializableXmlElement instanceof TransferImpl) {
            return this.write((TransferImpl)serializableXmlElement);
        }
        throw new IllegalArgumentException("unsupported src-class: " + (serializableXmlElement != null ? serializableXmlElement.getClass().getName() : "null"));
    }

    public Root write(AgencyImpl agencyImpl) {
        this.getErrorMap().clear();
        Root root = this.createRoot();
        if (agencyImpl == null) {
            LOGGER.warn((Object)"no agency was provided!");
            return root;
        }
        root.setAgent(this.convertAgent(agencyImpl.getAgent()));
        for (EstateImpl estateImpl : agencyImpl.getEstates().values()) {
            try {
                ArrayList<String> arrayList = new ArrayList<String>();
                PropertyType propertyType = this.convertEstate(estateImpl, arrayList);
                if (!arrayList.isEmpty() || propertyType == null) {
                    this.putErrors(estateImpl.getId(), arrayList);
                    continue;
                }
                root.getProperty().add(propertyType);
            }
            catch (Exception exception) {
                LOGGER.error((Object)"Fehler beim Parsen der Immobilie!");
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        return root;
    }

    public Root write(TransferImpl transferImpl) {
        this.getErrorMap().clear();
        Root root = this.createRoot();
        if (transferImpl == null) {
            LOGGER.warn((Object)"no transfer was provided!");
        } else if (transferImpl.getAgencies().isEmpty()) {
            LOGGER.warn((Object)"no transferable agent found!");
        } else {
            TransferAgencyImpl transferAgencyImpl = transferImpl.getAgencies().get(0);
            root.setAgent(this.convertAgent(transferAgencyImpl.getAgent()));
            for (EstateImpl estateImpl : transferAgencyImpl.getEstatesToSave()) {
                try {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    PropertyType propertyType = this.convertEstate(estateImpl, arrayList);
                    if (!arrayList.isEmpty() || propertyType == null) {
                        this.putErrors(estateImpl.getId(), arrayList);
                        continue;
                    }
                    root.getProperty().add(propertyType);
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"Fehler beim Parsen der Immobilie!");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
        }
        return root;
    }
}

