/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.xml;

import com.openindex.openestate.impl.OpenEstateUtils;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

public class OpenImmoAnswer {
    private static final Logger LOGGER = Logger.getLogger(OpenImmoAnswer.class);
    private List<Anbieter> anbieter = new ArrayList<Anbieter>();
    private Gesamt gesamt = null;

    public List<Anbieter> getAnbieter() {
        return this.anbieter;
    }

    public Gesamt getGesamt() {
        return this.gesamt;
    }

    public static OpenImmoAnswer read(InputStream inputStream) throws DocumentException {
        return OpenImmoAnswer.read(OpenEstateUtils.loadDocument(inputStream));
    }

    public static OpenImmoAnswer read(Reader reader) throws DocumentException {
        return OpenImmoAnswer.read(OpenEstateUtils.loadDocument(reader));
    }

    public static OpenImmoAnswer read(Document document) throws DocumentException {
        Object object;
        Element element = document.getRootElement();
        if (element == null) {
            throw new DocumentException("No root element was found!");
        }
        if (!element.getName().equalsIgnoreCase("immoanswer")) {
            throw new DocumentException("Root element '<" + element.getName() + ">' does not match '<immoanswer>'!");
        }
        OpenImmoAnswer openImmoAnswer = new OpenImmoAnswer();
        Node node = element.selectSingleNode("gesamt");
        if (node != null) {
            object = new Gesamt();
            ((Gesamt)object).setFehler(OpenImmoAnswer.readNode(node.selectSingleNode("nicht_importierbar/text()")));
            ((Gesamt)object).setGeaendert(OpenImmoAnswer.readNode(node.selectSingleNode("geaenderte/text()")));
            ((Gesamt)object).setIdentisch(OpenImmoAnswer.readNode(node.selectSingleNode("identische/text()")));
            ((Gesamt)object).setNeu(OpenImmoAnswer.readNode(node.selectSingleNode("neue/text()")));
            ((Gesamt)object).setGesamtUebertragen(OpenImmoAnswer.readNode(node.selectSingleNode("gesamt_uebertragen/text()")));
            openImmoAnswer.setGesamt((Gesamt)object);
        }
        object = new HashMap();
        for (Object object2 : element.selectNodes("anbieter")) {
            Node node2 = (Node)object2;
            String string = OpenImmoAnswer.readNode(node2.selectSingleNode("anbieternr/text()"));
            if (string == null || string.trim().length() == 0) {
                string = "0";
                LOGGER.warn((Object)"No matching <anbieternr> was found, fallback to <anbieternr>0</anbieternr>!");
            } else {
                string = string.trim();
            }
            Anbieter anbieter = null;
            if (object.containsKey(string)) {
                anbieter = (Anbieter)object.get(string);
            } else {
                anbieter = new Anbieter(string);
                object.put(anbieter.getNr(), anbieter);
            }
            for (Object e : node2.selectNodes("immobilie")) {
                Node node3 = (Node)e;
                Immobilie immobilie = new Immobilie();
                try {
                    immobilie.setAntwortArt(OpenImmoAnswer.readNode(node3.selectSingleNode("antwort/@art")));
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Can't read <antwort art=\"XXXXXXXXX\" />!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
                try {
                    immobilie.setMessage(OpenImmoAnswer.readNode(node3.selectSingleNode("meldung/freitext/text()")));
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Can't read <meldung><freitext/></meldung>!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
                try {
                    immobilie.setExposeId(OpenImmoAnswer.readNode(node3.selectSingleNode("expose_id/text()")));
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Can't read <expose_id/>!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
                try {
                    immobilie.setObjektNrExtern(OpenImmoAnswer.readNode(node3.selectSingleNode("objektnr_extern/text()")));
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Can't read <objektnr_extern/>!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
                try {
                    immobilie.setObjektNrIntern(OpenImmoAnswer.readNode(node3.selectSingleNode("objektnr_intern/text()")));
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)"Can't read <objektnr_intern/>!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
                try {
                    String string2 = OpenImmoAnswer.readNode(node3.selectSingleNode("openimmo_obid/text()"));
                    if (string2 == null) {
                        string2 = OpenImmoAnswer.readNode(node3.selectSingleNode("immoxml_obid/text()"));
                    }
                    immobilie.setObjektId(string2);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                    LOGGER.warn((Object)"Can't read <openimmo_obid/> or <immoxml_obid/>!");
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
                anbieter.getImmobilie().add(immobilie);
            }
        }
        for (Object object2 : object.values()) {
            openImmoAnswer.getAnbieter().add((Anbieter)object2);
        }
        return openImmoAnswer;
    }

    private static String readNode(Node node) {
        return node != null ? node.getText() : null;
    }

    public void setGesamt(Gesamt gesamt) {
        this.gesamt = gesamt;
    }

    public static class Immobilie {
        private String antwortArt;
        private String objektId;
        private String objektNrExtern;
        private String objektNrIntern;
        private String exposeId;
        private String message;

        public String getAntwortArt() {
            return this.antwortArt;
        }

        public String getExposeId() {
            return this.exposeId;
        }

        public String getMessage() {
            return this.message;
        }

        public String getObjektId() {
            return this.objektId;
        }

        public String getObjektNrExtern() {
            return this.objektNrExtern;
        }

        public String getObjektNrIntern() {
            return this.objektNrIntern;
        }

        public boolean isFEHLER() {
            return "FEHLER".equalsIgnoreCase(this.getAntwortArt());
        }

        public boolean isOK() {
            return "OK".equalsIgnoreCase(this.getAntwortArt());
        }

        public void setAntwortArt(String string) {
            this.antwortArt = string != null ? string.trim() : null;
        }

        public void setExposeId(String string) {
            this.exposeId = string != null ? string.trim() : null;
        }

        public void setMessage(String string) {
            this.message = string != null ? string.trim() : null;
        }

        public void setObjektId(String string) {
            this.objektId = string != null ? string.trim() : null;
        }

        public void setObjektNrExtern(String string) {
            this.objektNrExtern = string != null ? string.trim() : null;
        }

        public void setObjektNrIntern(String string) {
            this.objektNrIntern = string != null ? string.trim() : null;
        }
    }

    public static class Gesamt {
        private long gesamtUebertragen = 0L;
        private long neu = 0L;
        private long geaendert = 0L;
        private long identisch = 0L;
        private long fehler = 0L;

        public long getFehler() {
            return this.fehler;
        }

        public long getGeaendert() {
            return this.geaendert;
        }

        public long getGesamtUebertragen() {
            return this.gesamtUebertragen;
        }

        public long getIdentisch() {
            return this.identisch;
        }

        public long getNeu() {
            return this.neu;
        }

        public void setFehler(String string) {
            try {
                this.setFehler(Long.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.setFehler(0L);
            }
        }

        public void setFehler(long l) {
            this.fehler = l > 0L ? l : 0L;
        }

        public void setGeaendert(String string) {
            try {
                this.setGeaendert(Long.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.setGeaendert(0L);
            }
        }

        public void setGeaendert(long l) {
            this.geaendert = l > 0L ? l : 0L;
        }

        public void setGesamtUebertragen(String string) {
            try {
                this.setGesamtUebertragen(Long.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.setGesamtUebertragen(0L);
            }
        }

        public void setGesamtUebertragen(long l) {
            this.gesamtUebertragen = l > 0L ? l : 0L;
        }

        public void setIdentisch(String string) {
            try {
                this.setIdentisch(Long.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.setIdentisch(0L);
            }
        }

        public void setIdentisch(long l) {
            this.identisch = l > 0L ? l : 0L;
        }

        public void setNeu(String string) {
            try {
                this.setNeu(Long.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.setNeu(0L);
            }
        }

        public void setNeu(long l) {
            this.neu = l > 0L ? l : 0L;
        }
    }

    public static class Anbieter {
        private String nr;
        private List<Immobilie> immobilie;

        public Anbieter() {
            this(null);
        }

        public Anbieter(String string) {
            this.nr = string;
            this.immobilie = new ArrayList<Immobilie>();
        }

        public List<Immobilie> getImmobilie() {
            return this.immobilie;
        }

        public String getNr() {
            return this.nr;
        }

        public void setNr(String string) {
            this.nr = string != null ? string.trim() : null;
        }
    }
}

