/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.xml;

import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.xml.NamespaceFilterXMLReader;
import com.openindex.openestate.impl.xml.openimmo.ObjectFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Calendar;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OpenImmoUtils {
    private static final Logger LOGGER = Logger.getLogger(OpenImmoUtils.class);
    public static final String PACKAGE = "com.openindex.openestate.impl.xml.openimmo";
    public static final String VERSION = "1.2.1";
    public static final String VERSION_AT = "1.2.1/AT1.0";
    private static final ObjectFactory FACTORY = new ObjectFactory();
    private static JAXBContext JAXB = null;

    private OpenImmoUtils() {
    }

    public static Marshaller createMarshaller() throws JAXBException {
        return OpenImmoUtils.createMarshaller(Charset.defaultCharset().name(), true);
    }

    public static Marshaller createMarshaller(String string, boolean bl) throws JAXBException {
        Marshaller marshaller = OpenImmoUtils.getContext().createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)string);
        marshaller.setProperty("jaxb.formatted.output", (Object)bl);
        return marshaller;
    }

    public static Unmarshaller createUnmarshaller() throws JAXBException {
        return OpenImmoUtils.getContext().createUnmarshaller();
    }

    public static JAXBContext getContext() throws JAXBException {
        if (JAXB == null) {
            JAXB = JAXBContext.newInstance((String)PACKAGE);
        }
        return JAXB;
    }

    public static ObjectFactory getFactory() {
        return FACTORY;
    }

    public static String printDate(Calendar calendar) {
        return calendar != null ? OpenEstateUtils.getXsdDateFormat().format(calendar.getTime()) : null;
    }

    public static Object unmarshallWithoutNamespace(File file) throws IOException, JAXBException {
        return OpenImmoUtils.unmarshallWithoutNamespace(OpenImmoUtils.createUnmarshaller(), file);
    }

    public static Object unmarshallWithoutNamespace(InputStream inputStream) throws IOException, JAXBException {
        return OpenImmoUtils.unmarshallWithoutNamespace(OpenImmoUtils.createUnmarshaller(), inputStream);
    }

    public static Object unmarshallWithoutNamespace(Reader reader) throws IOException, JAXBException {
        return OpenImmoUtils.unmarshallWithoutNamespace(OpenImmoUtils.createUnmarshaller(), reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object unmarshallWithoutNamespace(Unmarshaller unmarshaller, File file) throws IOException, JAXBException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            Object object = OpenImmoUtils.unmarshallWithoutNamespace(unmarshaller, fileInputStream);
            return object;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"could not close file!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
    }

    public static Object unmarshallWithoutNamespace(Unmarshaller unmarshaller, InputStream inputStream) throws IOException, JAXBException {
        try {
            NamespaceFilterXMLReader namespaceFilterXMLReader = new NamespaceFilterXMLReader("");
            InputSource inputSource = new InputSource(inputStream);
            SAXSource sAXSource = new SAXSource(namespaceFilterXMLReader, inputSource);
            return unmarshaller.unmarshal((Source)sAXSource);
        }
        catch (SAXException sAXException) {
            throw new JAXBException((Throwable)sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JAXBException((Throwable)parserConfigurationException);
        }
    }

    public static Object unmarshallWithoutNamespace(Unmarshaller unmarshaller, Reader reader) throws IOException, JAXBException {
        try {
            NamespaceFilterXMLReader namespaceFilterXMLReader = new NamespaceFilterXMLReader("");
            InputSource inputSource = new InputSource(reader);
            SAXSource sAXSource = new SAXSource(namespaceFilterXMLReader, inputSource);
            return unmarshaller.unmarshal((Source)sAXSource);
        }
        catch (SAXException sAXException) {
            throw new JAXBException((Throwable)sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JAXBException((Throwable)parserConfigurationException);
        }
    }
}

