/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.xml;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateConverter;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.PersonAdressImpl;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.xml.OpenImmoUtils;
import com.openindex.openestate.impl.xml.openimmo.Aktion;
import com.openindex.openestate.impl.xml.openimmo.Alter;
import com.openindex.openestate.impl.xml.openimmo.Anbieter;
import com.openindex.openestate.impl.xml.openimmo.Anhaenge;
import com.openindex.openestate.impl.xml.openimmo.Anhang;
import com.openindex.openestate.impl.xml.openimmo.Ausblick;
import com.openindex.openestate.impl.xml.openimmo.AusrichtBalkonTerrasse;
import com.openindex.openestate.impl.xml.openimmo.Ausstattung;
import com.openindex.openestate.impl.xml.openimmo.Bad;
import com.openindex.openestate.impl.xml.openimmo.BebaubarNach;
import com.openindex.openestate.impl.xml.openimmo.Befeuerung;
import com.openindex.openestate.impl.xml.openimmo.Bewertung;
import com.openindex.openestate.impl.xml.openimmo.Bieterverfahren;
import com.openindex.openestate.impl.xml.openimmo.Boden;
import com.openindex.openestate.impl.xml.openimmo.BueroPraxen;
import com.openindex.openestate.impl.xml.openimmo.Distanzen;
import com.openindex.openestate.impl.xml.openimmo.DistanzenSport;
import com.openindex.openestate.impl.xml.openimmo.Einzelhandel;
import com.openindex.openestate.impl.xml.openimmo.Energiepass;
import com.openindex.openestate.impl.xml.openimmo.Erschliessung;
import com.openindex.openestate.impl.xml.openimmo.Flaechen;
import com.openindex.openestate.impl.xml.openimmo.Freitexte;
import com.openindex.openestate.impl.xml.openimmo.FreizeitimmobilieGewerblich;
import com.openindex.openestate.impl.xml.openimmo.Gastgewerbe;
import com.openindex.openestate.impl.xml.openimmo.Geo;
import com.openindex.openestate.impl.xml.openimmo.Geokoordinaten;
import com.openindex.openestate.impl.xml.openimmo.Geschlecht;
import com.openindex.openestate.impl.xml.openimmo.Grundstueck;
import com.openindex.openestate.impl.xml.openimmo.HallenLagerProd;
import com.openindex.openestate.impl.xml.openimmo.Haus;
import com.openindex.openestate.impl.xml.openimmo.Heizungsart;
import com.openindex.openestate.impl.xml.openimmo.Immobilie;
import com.openindex.openestate.impl.xml.openimmo.Infrastruktur;
import com.openindex.openestate.impl.xml.openimmo.Kontaktperson;
import com.openindex.openestate.impl.xml.openimmo.Kueche;
import com.openindex.openestate.impl.xml.openimmo.LageGebiet;
import com.openindex.openestate.impl.xml.openimmo.LageImBau;
import com.openindex.openestate.impl.xml.openimmo.LandUndForstwirtschaft;
import com.openindex.openestate.impl.xml.openimmo.Moebliert;
import com.openindex.openestate.impl.xml.openimmo.Objektkategorie;
import com.openindex.openestate.impl.xml.openimmo.Openimmo;
import com.openindex.openestate.impl.xml.openimmo.PreisZeiteinheit;
import com.openindex.openestate.impl.xml.openimmo.Preise;
import com.openindex.openestate.impl.xml.openimmo.Serviceleistungen;
import com.openindex.openestate.impl.xml.openimmo.Sicherheitstechnik;
import com.openindex.openestate.impl.xml.openimmo.Sonstige;
import com.openindex.openestate.impl.xml.openimmo.Stellplatz;
import com.openindex.openestate.impl.xml.openimmo.Stellplatzart;
import com.openindex.openestate.impl.xml.openimmo.Uebertragung;
import com.openindex.openestate.impl.xml.openimmo.Unterkellert;
import com.openindex.openestate.impl.xml.openimmo.UserDefinedAnyfield;
import com.openindex.openestate.impl.xml.openimmo.UserDefinedSimplefield;
import com.openindex.openestate.impl.xml.openimmo.VerwaltungObjekt;
import com.openindex.openestate.impl.xml.openimmo.VerwaltungTechn;
import com.openindex.openestate.impl.xml.openimmo.Wohnung;
import com.openindex.openestate.impl.xml.openimmo.Zimmer;
import com.openindex.openestate.impl.xml.openimmo.ZinshausRenditeobjekt;
import com.openindex.openestate.impl.xml.openimmo.Zustand;
import com.openindex.openestate.impl.xml.openimmo.ZustandAngaben;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OpenImmoWriter
extends OpenEstateConverter {
    private static final Logger LOGGER = Logger.getLogger(OpenImmoWriter.class);
    private String version = "1.2.1";
    private boolean energyCertificateAppendedToDescription = false;

    public OpenImmoWriter() {
    }

    public OpenImmoWriter(Locale locale) {
        this();
        this.setOpenEstateLanguage(locale);
    }

    protected Anbieter convertAgent(AgentImpl agentImpl) {
        Anbieter anbieter = this.createEmptyAnbieter();
        anbieter.setOpenimmoAnid("");
        anbieter.setAnbieternr(agentImpl.getId());
        anbieter.setImpressum(OpenEstateUtils.serializeString(agentImpl.getTerms(this.getOpenEstateLanguage()), this.getXmlLineSeparator()));
        anbieter.setFirma(OpenEstateUtils.serializeString(agentImpl.getCompany().getCompanyName(), this.getXmlLineSeparator()));
        anbieter.setImpressumStrukt(OpenImmoUtils.getFactory().createImpressumStrukt());
        anbieter.getImpressumStrukt().setBerufsaufsichtsbehoerde("");
        anbieter.getImpressumStrukt().setFirmenanschrift(agentImpl.getCompany().writeFullAdress(this.getXmlLineSeparator(), this.getOpenEstateLanguage()));
        anbieter.getImpressumStrukt().setFirmenname(OpenEstateUtils.serializeString(agentImpl.getCompany().getCompanyName(), this.getXmlLineSeparator()));
        anbieter.getImpressumStrukt().setHandelsregister("");
        anbieter.getImpressumStrukt().setHandelsregisterNr("");
        anbieter.getImpressumStrukt().setSteuernummer("");
        anbieter.getImpressumStrukt().setTelefon("");
        anbieter.getImpressumStrukt().setUmsstId("");
        anbieter.getImpressumStrukt().setVertretungsberechtigter(OpenEstateUtils.serializeString(agentImpl.getCompany().writePersonFullName(), this.getXmlLineSeparator()));
        anbieter.getImpressumStrukt().setWeiteres("");
        return anbieter;
    }

    protected Immobilie convertEstate(EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl, List<String> list) {
        try {
            Immobilie immobilie = this.createEmptyImmobilie();
            immobilie.setObjektkategorie(OpenImmoUtils.getFactory().createObjektkategorie());
            this.writeImmobilieObjektkategorie(immobilie.getObjektkategorie(), estateImpl);
            immobilie.setGeo(OpenImmoUtils.getFactory().createGeo());
            this.writeImmobilieGeo(immobilie.getGeo(), estateImpl);
            immobilie.setKontaktperson(OpenImmoUtils.getFactory().createKontaktperson());
            if (agentContactImpl != null) {
                this.writeImmobilieKontaktperson(immobilie.getKontaktperson(), agentContactImpl, agentImpl);
            } else {
                this.writeImmobilieKontaktperson(immobilie.getKontaktperson(), agentImpl.getCompany(), agentImpl);
                immobilie.getKontaktperson().setPersonennummer("0");
            }
            immobilie.setPreise(OpenImmoUtils.getFactory().createPreise());
            this.writeImmobiliePreise(immobilie.getPreise(), estateImpl);
            immobilie.setFlaechen(OpenImmoUtils.getFactory().createFlaechen());
            this.writeImmobilieFlaechen(immobilie.getFlaechen(), estateImpl);
            immobilie.setAusstattung(OpenImmoUtils.getFactory().createAusstattung());
            this.writeImmobilieAusstattung(immobilie.getAusstattung(), estateImpl);
            immobilie.setZustandAngaben(OpenImmoUtils.getFactory().createZustandAngaben());
            this.writeImmobilieZustandAngaben(immobilie.getZustandAngaben(), estateImpl);
            immobilie.setInfrastruktur(OpenImmoUtils.getFactory().createInfrastruktur());
            this.writeImmobilieInfrastruktur(immobilie.getInfrastruktur(), estateImpl);
            immobilie.setFreitexte(OpenImmoUtils.getFactory().createFreitexte());
            this.writeImmobilieFreitexte(immobilie.getFreitexte(), estateImpl);
            immobilie.setAnhaenge(OpenImmoUtils.getFactory().createAnhaenge());
            this.writeImmobilieAnhaenge(immobilie.getAnhaenge(), estateImpl);
            immobilie.setVerwaltungObjekt(OpenImmoUtils.getFactory().createVerwaltungObjekt());
            this.writeImmobilieVerwaltungObjekt(immobilie.getVerwaltungObjekt(), estateImpl);
            immobilie.setVerwaltungTechn(OpenImmoUtils.getFactory().createVerwaltungTechn());
            this.writeImmobilieVerwaltungTechn(immobilie.getVerwaltungTechn(), estateImpl);
            return immobilie;
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't convert estate!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    private Distanzen createDistanz(Distanzen.DistanzZu distanzZu, Float f) {
        if (distanzZu == null || f == null) {
            return null;
        }
        Distanzen distanzen = OpenImmoUtils.getFactory().createDistanzen();
        distanzen.setDistanzZu(distanzZu);
        distanzen.setValue(f.floatValue());
        return distanzen;
    }

    private DistanzenSport createDistanzSport(DistanzenSport.DistanzZuSport distanzZuSport, Float f) {
        if (distanzZuSport == null || f == null) {
            return null;
        }
        DistanzenSport distanzenSport = OpenImmoUtils.getFactory().createDistanzenSport();
        distanzenSport.setDistanzZuSport(distanzZuSport);
        distanzenSport.setValue(f.floatValue());
        return distanzenSport;
    }

    protected Anbieter createEmptyAnbieter() {
        return OpenImmoUtils.getFactory().createAnbieter();
    }

    protected Immobilie createEmptyImmobilie() {
        return OpenImmoUtils.getFactory().createImmobilie();
    }

    protected Openimmo createRoot() {
        Openimmo openimmo = OpenImmoUtils.getFactory().createOpenimmo();
        openimmo.setUebertragung(OpenImmoUtils.getFactory().createUebertragung());
        openimmo.getUebertragung().setArt(Uebertragung.Art.OFFLINE);
        openimmo.getUebertragung().setModus(Uebertragung.Modus.NEW);
        openimmo.getUebertragung().setSendersoftware("OpenEstate-DevUtils");
        openimmo.getUebertragung().setSenderversion("1.0");
        openimmo.getUebertragung().setTechnEmail("http://www.openestate.org/");
        openimmo.getUebertragung().setUmfang(Uebertragung.Umfang.VOLL);
        openimmo.getUebertragung().setVersion(this.getVersion());
        return openimmo;
    }

    private BueroPraxen.BueroTyp getObjektartBueroTyp(String string) {
        if (string.equals("AUSSTELLUNGSFLAECHE")) {
            return BueroPraxen.BueroTyp.AUSSTELLUNGSFLAECHE;
        }
        if (string.equals("BUEROFLAECHE")) {
            return BueroPraxen.BueroTyp.BUEROFLAECHE;
        }
        if (string.equals("BUEROHAUS")) {
            return BueroPraxen.BueroTyp.BUEROHAUS;
        }
        if (string.equals("PRAXIS")) {
            return BueroPraxen.BueroTyp.PRAXIS;
        }
        return null;
    }

    private FreizeitimmobilieGewerblich.FreizeitTyp getObjektartFreizeitTyp(String string) {
        if (string.equals("SPORTANLAGE")) {
            return FreizeitimmobilieGewerblich.FreizeitTyp.SPORTANLAGEN;
        }
        if (string.equals("VERGNUEGUNGSPARK")) {
            return FreizeitimmobilieGewerblich.FreizeitTyp.VERGNUEGUNGSPARKS_UND_CENTER;
        }
        return null;
    }

    private Gastgewerbe.GastgewTyp getObjektartGastgewTyp(String string) {
        if (string.equals("GASTRONOMIE")) {
            return Gastgewerbe.GastgewTyp.GASTRONOMIE;
        }
        if (string.equals("GASTRONOMIE_MIT_WOHNUNG")) {
            return Gastgewerbe.GastgewTyp.GASTRONOMIE_UND_WOHNUNG;
        }
        if (string.equals("HOTEL")) {
            return Gastgewerbe.GastgewTyp.HOTELS;
        }
        if (string.equals("PENSION")) {
            return Gastgewerbe.GastgewTyp.PENSIONEN;
        }
        if (string.equals("JUGENDHERBERGE") || string.equals("HOSTEL") || string.equals("FREMDENZIMMER")) {
            return Gastgewerbe.GastgewTyp.WEITERE_BEHERBERGUNGSBETRIEBE;
        }
        return null;
    }

    private Grundstueck.GrundstTyp getObjektartGrundstTyp(String string) {
        if (string.equals("FREIZEITGRUND")) {
            return Grundstueck.GrundstTyp.FREIZEIT;
        }
        if (string.equals("GEMISCHTGRUND")) {
            return Grundstueck.GrundstTyp.GEMISCHT;
        }
        if (string.equals("GEWERBEGRUND")) {
            return Grundstueck.GrundstTyp.GEWERBE;
        }
        if (string.equals("INDUSTRIEGRUND")) {
            return Grundstueck.GrundstTyp.INDUSTRIE;
        }
        if (string.equals("LAND_FORSTGRUND")) {
            return Grundstueck.GrundstTyp.LAND_FORSTWIRSCHAFT;
        }
        if (string.equals("SONDERNUTZUNG")) {
            return Grundstueck.GrundstTyp.SONDERNUTZUNG;
        }
        if (string.equals("WOHNGRUND")) {
            return Grundstueck.GrundstTyp.WOHNEN;
        }
        return null;
    }

    private HallenLagerProd.HallenTyp getObjektartHallenTyp(String string) {
        if (string.equals("FREIFLAECHE")) {
            return HallenLagerProd.HallenTyp.FREIFLAECHEN;
        }
        if (string.equals("HALLE_LAGER")) {
            return HallenLagerProd.HallenTyp.HALLE;
        }
        if (string.equals("HOCHREGALLAGER")) {
            return HallenLagerProd.HallenTyp.HOCHREGALLAGER;
        }
        if (string.equals("LAGERHALLE")) {
            return HallenLagerProd.HallenTyp.LAGER;
        }
        if (string.equals("PRODUKTION")) {
            return HallenLagerProd.HallenTyp.PRODUKTION;
        }
        if (string.equals("SERVICEFLAECHE")) {
            return HallenLagerProd.HallenTyp.SERVICE;
        }
        if (string.equals("WERKSTATT")) {
            return HallenLagerProd.HallenTyp.WERKSTATT;
        }
        return null;
    }

    private Einzelhandel.HandelTyp getObjektartHandelTyp(String string) {
        if (string.equals("EINKAUFSZENTRUM")) {
            return Einzelhandel.HandelTyp.EINKAUFSZENTRUM;
        }
        if (string.equals("LADEN")) {
            return Einzelhandel.HandelTyp.EINZELHANDELSLADEN;
        }
        if (string.equals("LADENLOKAL") || string.equals("GESCHAEFTSLOKAL")) {
            return Einzelhandel.HandelTyp.LADENLOKAL;
        }
        if (string.equals("VERBRAUCHERMARKT")) {
            return Einzelhandel.HandelTyp.VERBRAUCHERMARKT;
        }
        return null;
    }

    private Haus.Haustyp getObjektartHaustyp(String string) {
        if (string.equals("BAUERNHAUS")) {
            return Haus.Haustyp.BAUERNHAUS;
        }
        if (string.equals("BERGHUETTE")) {
            return Haus.Haustyp.BERGHUETTE;
        }
        if (string.equals("BETREUTES_WOHNEN")) {
            return Haus.Haustyp.BETREUTES_WOHNEN;
        }
        if (string.equals("BUNGALOW")) {
            return Haus.Haustyp.BUNGALOW;
        }
        if (string.equals("CHALET")) {
            return Haus.Haustyp.CHALET;
        }
        if (string.equals("DOPPELHAUSHAELFTE")) {
            return Haus.Haustyp.DOPPELHAUSHAELFTE;
        }
        if (string.equals("EFH")) {
            return Haus.Haustyp.EINFAMILIENHAUS;
        }
        if (string.equals("FERIENHAUS")) {
            return Haus.Haustyp.FERIENHAUS;
        }
        if (string.equals("KRANKENHAUS")) {
            return Haus.Haustyp.KRANKENHAUS;
        }
        if (string.equals("LANDHAUS")) {
            return Haus.Haustyp.LANDHAUS;
        }
        if (string.equals("FREIZEITHAUS")) {
            return Haus.Haustyp.LAUBE_DATSCHE_GARTENHAUS;
        }
        if (string.equals("MFH")) {
            return Haus.Haustyp.MEHRFAMILIENHAUS;
        }
        if (string.equals("REIHENECKHAUS")) {
            return Haus.Haustyp.REIHENECK;
        }
        if (string.equals("REIHENENDHAUS")) {
            return Haus.Haustyp.REIHENEND;
        }
        if (string.equals("REIHENHAUS")) {
            return Haus.Haustyp.REIHENHAUS;
        }
        if (string.equals("REIHENMITTELHAUS")) {
            return Haus.Haustyp.REIHENMITTEL;
        }
        if (string.equals("RESTHOF")) {
            return Haus.Haustyp.RESTHOF;
        }
        if (string.equals("SANATORIUM")) {
            return Haus.Haustyp.SANATORIUM;
        }
        if (string.equals("SCHLOSS") || string.equals("BURG")) {
            return Haus.Haustyp.SCHLOSS;
        }
        if (string.equals("WOHNANLAGE_FUER_SENIOREN")) {
            return Haus.Haustyp.SENIORENHEIM;
        }
        if (string.equals("STADTHAUS")) {
            return Haus.Haustyp.STADTHAUS;
        }
        if (string.equals("STRANDHAUS")) {
            return Haus.Haustyp.STRANDHAUS;
        }
        if (string.equals("VILLA")) {
            return Haus.Haustyp.VILLA;
        }
        if (string.equals("ZFH")) {
            return Haus.Haustyp.ZWEIFAMILIENHAUS;
        }
        return null;
    }

    private LandUndForstwirtschaft.LandTyp getObjektartLandTyp(String string) {
        if (string.equals("ACKERBAU")) {
            return LandUndForstwirtschaft.LandTyp.ACKERBAU;
        }
        if (string.equals("AUSSIEDLERHOF")) {
            return LandUndForstwirtschaft.LandTyp.AUSSIEDLERHOF;
        }
        if (string.equals("BAUERNHOF")) {
            return LandUndForstwirtschaft.LandTyp.BAUERNHOF;
        }
        if (string.equals("GARTENBAU")) {
            return LandUndForstwirtschaft.LandTyp.GARTENBAU;
        }
        if (string.equals("JAGD_FORSTWIRTSCHAFT")) {
            return LandUndForstwirtschaft.LandTyp.JAGD_UND_FORSTWIRTSCHAFT;
        }
        if (string.equals("REITERHOF")) {
            return LandUndForstwirtschaft.LandTyp.REITERHOEFE;
        }
        if (string.equals("SCHEUNEN")) {
            return LandUndForstwirtschaft.LandTyp.SCHEUNEN;
        }
        if (string.equals("TEICH_FISCHWIRTSCHAFT")) {
            return LandUndForstwirtschaft.LandTyp.TEICH_UND_FISCHWIRTSCHAFT;
        }
        if (string.equals("VIEHWIRTSCHAFT")) {
            return LandUndForstwirtschaft.LandTyp.VIEHWIRTSCHAFT;
        }
        if (string.equals("WEINBAU")) {
            return LandUndForstwirtschaft.LandTyp.WEINBAU;
        }
        return null;
    }

    private Sonstige.SonstigeTyp getObjektartSonstigeTyp(String string) {
        if (string.equals("GARAGE")) {
            return Sonstige.SonstigeTyp.GARAGEN;
        }
        if (string.equals("MAIN_STELLPLATZ")) {
            return Sonstige.SonstigeTyp.PARKFLACHE;
        }
        if (string.equals("PARKHAUS")) {
            return Sonstige.SonstigeTyp.PARKHAUS;
        }
        if (string.equals("TANKSTELLE")) {
            return Sonstige.SonstigeTyp.TANKSTELLE;
        }
        return null;
    }

    private Wohnung.Wohnungtyp getObjektartWohnungtyp(String string) {
        if (string.equals("DACHWOHNUNG")) {
            return Wohnung.Wohnungtyp.DACHGESCHOSS;
        }
        if (string.equals("ERDGESCHOSSWOHNUNG")) {
            return Wohnung.Wohnungtyp.ERDGESCHOSS;
        }
        if (string.equals("ETAGENWOHNUNG")) {
            return Wohnung.Wohnungtyp.ETAGE;
        }
        if (string.equals("LOFTWOHNUNG") || string.equals("STUDIOWOHNUNG") || string.equals("ATELIERWOHNUNG")) {
            return Wohnung.Wohnungtyp.LOFT_STUDIO_ATELIER;
        }
        if (string.equals("MAISONETTWOHNUNG")) {
            return Wohnung.Wohnungtyp.MAISONETTE;
        }
        if (string.equals("PENTHOUSEWOHNUNG")) {
            return Wohnung.Wohnungtyp.PENTHOUSE;
        }
        if (string.equals("SOUTERRAINWOHNUNG")) {
            return Wohnung.Wohnungtyp.SOUTERRAIN;
        }
        if (string.equals("TERRASSENWOHNUNG")) {
            return Wohnung.Wohnungtyp.TERRASSEN;
        }
        return null;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isEnergyCertificateAppendedToDescription() {
        return this.energyCertificateAppendedToDescription;
    }

    public void setEnergyCertificateAppendedToDescription(boolean bl) {
        this.energyCertificateAppendedToDescription = bl;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public Openimmo write(SerializableXmlElement serializableXmlElement) {
        if (serializableXmlElement instanceof AgencyImpl) {
            return this.write((AgencyImpl)serializableXmlElement);
        }
        if (serializableXmlElement instanceof TransferImpl) {
            return this.write((TransferImpl)serializableXmlElement);
        }
        throw new IllegalArgumentException("unsupported xml-class: " + (serializableXmlElement != null ? serializableXmlElement.getClass().getName() : "null"));
    }

    public Openimmo write(AgencyImpl agencyImpl) {
        this.getErrorMap().clear();
        Openimmo openimmo = this.createRoot();
        Anbieter anbieter = this.convertAgent(agencyImpl.getAgent());
        for (EstateImpl estateImpl : agencyImpl.getEstates().values()) {
            String string = estateImpl.getContactId();
            AgentContactImpl agentContactImpl = string != null && agencyImpl.getContacts().containsKey(string) ? agencyImpl.getContacts().get(string) : null;
            ArrayList<String> arrayList = new ArrayList<String>();
            Immobilie immobilie = this.convertEstate(estateImpl, agencyImpl.getAgent(), agentContactImpl, arrayList);
            if (!arrayList.isEmpty()) {
                this.putErrors(estateImpl.getId(), arrayList);
                continue;
            }
            if (immobilie == null) continue;
            immobilie.getVerwaltungTechn().getAktion().setAktionart(Aktion.AktionArt.CHANGE);
            anbieter.getImmobilie().add(immobilie);
        }
        openimmo.getAnbieter().add(anbieter);
        return openimmo;
    }

    public Openimmo write(TransferImpl transferImpl) {
        this.getErrorMap().clear();
        Openimmo openimmo = this.createRoot();
        for (TransferAgencyImpl transferAgencyImpl : transferImpl.getAgencies()) {
            Object object;
            Object object2;
            Object object3;
            Anbieter anbieter = this.convertAgent(transferAgencyImpl.getAgent());
            for (EstateImpl estateImpl : transferAgencyImpl.getEstatesToSave()) {
                object3 = estateImpl.getContactId();
                object2 = transferAgencyImpl.getContacts().containsKey(object3) ? transferAgencyImpl.getContacts().get(object3) : null;
                object = new ArrayList<String>();
                Immobilie immobilie = this.convertEstate(estateImpl, transferAgencyImpl.getAgent(), (AgentContactImpl)object2, (List<String>)object);
                if (!object.isEmpty()) {
                    this.putErrors(estateImpl.getId(), (List<String>)object);
                    continue;
                }
                if (immobilie == null) continue;
                immobilie.getVerwaltungTechn().getAktion().setAktionart(Aktion.AktionArt.CHANGE);
                anbieter.getImmobilie().add(immobilie);
            }
            for (String string : transferAgencyImpl.getEstateIdsToRemove()) {
                object3 = new EstateImpl();
                ((EstateImpl)object3).setId(string);
                ((EstateImpl)object3).setCurrency(Currency.getInstance(Locale.GERMANY));
                ((EstateImpl)object3).getAdress().setPostalCode("13125");
                try {
                    ((EstateImpl)object3).setType("MAIN_WOHNEN", "MIETE");
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)exception.getLocalizedMessage(), (Throwable)exception);
                }
                object2 = new ArrayList();
                object = this.convertEstate((EstateImpl)object3, transferAgencyImpl.getAgent(), null, (List<String>)object2);
                if (!object2.isEmpty()) {
                    this.putErrors(((EstateImpl)object3).getId(), (List<String>)object2);
                    continue;
                }
                if (object == null) continue;
                ((Immobilie)object).getVerwaltungTechn().getAktion().setAktionart(Aktion.AktionArt.DELETE);
                anbieter.getImmobilie().add((Immobilie)object);
            }
            openimmo.getAnbieter().add(anbieter);
        }
        return openimmo;
    }

    protected void writeImmobilieAnhaenge(Anhaenge anhaenge, EstateImpl estateImpl) {
        for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getAttachments()) {
            Anhang anhang = OpenImmoUtils.getFactory().createAnhang();
            String string = estateAttachmentImpl.getTitle(this.getOpenEstateLanguage());
            String string2 = estateAttachmentImpl.getMimeType();
            anhang.setAnhangtitel(StringUtils.trimToEmpty((String)string));
            anhang.setFormat(string2);
            anhang.setLocation(estateAttachmentImpl.isUrl() ? Anhang.Location.EXTERN : Anhang.Location.INTERN);
            anhang.setDaten(OpenImmoUtils.getFactory().createDaten());
            if (estateAttachmentImpl.isUrl()) {
                anhang.getDaten().setPfad(estateAttachmentImpl.getFileAsUrl().toString());
            } else if (estateAttachmentImpl.isName()) {
                anhang.getDaten().setPfad(estateAttachmentImpl.getFileAsName());
            } else if (estateAttachmentImpl.isBase64()) {
                anhang.getDaten().setAnhanginhalt(estateAttachmentImpl.getFileAsBase64());
            } else {
                LOGGER.warn((Object)"invalid attachment!");
                continue;
            }
            if (estateAttachmentImpl.isUrl()) {
                anhang.setGruppe(Anhang.Gruppe.LINKS);
            } else if ("IMAGE_OUTER_VIEW".equals(estateAttachmentImpl.getType())) {
                anhang.setGruppe(Anhang.Gruppe.AUSSENANSICHTEN);
            } else if ("IMAGE".equals(estateAttachmentImpl.getType())) {
                anhang.setGruppe(Anhang.Gruppe.BILD);
            } else if ("IMAGE_GROUNDPLAN".equals(estateAttachmentImpl.getType())) {
                anhang.setGruppe(Anhang.Gruppe.GRUNDRISS);
            } else if ("IMAGE_INNER_VIEW".equals(estateAttachmentImpl.getType())) {
                anhang.setGruppe(Anhang.Gruppe.INNENANSICHTEN);
            } else if ("IMAGE_MAP".equals(estateAttachmentImpl.getType())) {
                anhang.setGruppe(Anhang.Gruppe.KARTEN_LAGEPLAN);
            } else if ("IMAGE_PANORAMA".equals(estateAttachmentImpl.getType())) {
                anhang.setGruppe(Anhang.Gruppe.PANORAMA);
            } else if (string2.startsWith("image/")) {
                anhang.setGruppe(Anhang.Gruppe.BILD);
            } else {
                anhang.setGruppe(Anhang.Gruppe.DOKUMENTE);
            }
            anhaenge.getAnhang().add(anhang);
        }
    }

    protected void writeImmobilieAusstattung(Ausstattung ausstattung, EstateImpl estateImpl) {
        String string;
        Object object;
        Object object2;
        Object object3;
        String string2;
        List<String> list;
        List<String> list2;
        Object object4;
        Object object5;
        List<String> list3;
        List<String> list4;
        BigDecimal bigDecimal;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        List<String> list5;
        ausstattung.setBarrierefrei(this.getEstateValueAsBoolean("AUSSTATTUNG", "BARRIEREFREI", estateImpl));
        ausstattung.setBrauereibindung(this.getEstateValueAsBoolean("AUSSTATTUNG", "BRAUEREIBINDUNG", estateImpl));
        ausstattung.setGartennutzung(this.getEstateValueAsBoolean("AUSSTATTUNG", "GARTENNUTZUNG", estateImpl));
        ausstattung.setGastterrasse(this.getEstateValueAsBoolean("FLAECHEN", "GASTTERRASSE", estateImpl));
        ausstattung.setHallenhoehe(this.getEstateValueAsFloat("AUSSTATTUNG", "HALLENHOEHE", estateImpl));
        ausstattung.setHebebuehne(this.getEstateValueAsBoolean("AUSSTATTUNG", "HEBEBUEHNE", estateImpl));
        ausstattung.setKamin(this.getEstateValueAsBoolean("AUSSTATTUNG", "KAMIN", estateImpl));
        ausstattung.setKantineCafeteria(this.getEstateValueAsBoolean("AUSSTATTUNG", "KANTINE_CAFETERIA", estateImpl));
        ausstattung.setKlimatisiert(this.getEstateValueAsBoolean("AUSSTATTUNG", "KLIMATISIERT", estateImpl));
        ausstattung.setKran(this.getEstateValueAsBoolean("AUSSTATTUNG", "KRAN", estateImpl));
        ausstattung.setRampe(this.getEstateValueAsBoolean("AUSSTATTUNG", "RAMPE", estateImpl));
        ausstattung.setRolladen(this.getEstateValueAsBoolean("AUSSTATTUNG", "ROLLADEN", estateImpl));
        ausstattung.setSauna(this.getEstateValueAsBoolean("AUSSTATTUNG", "SAUNA", estateImpl));
        ausstattung.setSporteinrichtungen(this.getEstateValueAsBoolean("AUSSTATTUNG", "SPORTEINRICHTUNGEN", estateImpl));
        ausstattung.setStromanschlusswert(this.getEstateValueAsFloat("AUSSTATTUNG", "STROMANSCHLUSSWERT", estateImpl));
        ausstattung.setSwimmingpool(this.getEstateValueAsBoolean("AUSSTATTUNG", "SWIMMINGPOOL", estateImpl));
        ausstattung.setTelefonFerienimmobilie(this.getEstateValueAsBoolean("AUSSTATTUNG", "TELEFON_FERIENIMMOBILIE", estateImpl));
        ausstattung.setWellnessbereich(this.getEstateValueAsBoolean("AUSSTATTUNG", "WELLNESSBEREICH", estateImpl));
        Boolean bl = (Boolean)this.getEstateValue("AUSSTATTUNG", "ANGESCHL_GASTRONOMIE", estateImpl);
        if (Boolean.TRUE.equals(bl)) {
            ausstattung.setAngeschlGastronomie(OpenImmoUtils.getFactory().createAngeschlGastronomie());
        }
        if ((list5 = this.getEstateValueAsList("AUSSTATTUNG", "BALKON_TERRASSE_AUSRICHTUNG", estateImpl)) != null && !list5.isEmpty()) {
            object9 = OpenImmoUtils.getFactory().createAusrichtBalkonTerrasse();
            if (list5.contains("N")) {
                if (ausstattung.getAusrichtBalkonTerrasse() == null) {
                    ausstattung.setAusrichtBalkonTerrasse((AusrichtBalkonTerrasse)object9);
                }
                ausstattung.getAusrichtBalkonTerrasse().setNORD(true);
            }
            if (list5.contains("E")) {
                if (ausstattung.getAusrichtBalkonTerrasse() == null) {
                    ausstattung.setAusrichtBalkonTerrasse((AusrichtBalkonTerrasse)object9);
                }
                ausstattung.getAusrichtBalkonTerrasse().setOST(true);
            }
            if (list5.contains("S")) {
                if (ausstattung.getAusrichtBalkonTerrasse() == null) {
                    ausstattung.setAusrichtBalkonTerrasse((AusrichtBalkonTerrasse)object9);
                }
                ausstattung.getAusrichtBalkonTerrasse().setSUED(true);
            }
            if (list5.contains("W")) {
                if (ausstattung.getAusrichtBalkonTerrasse() == null) {
                    ausstattung.setAusrichtBalkonTerrasse((AusrichtBalkonTerrasse)object9);
                }
                ausstattung.getAusrichtBalkonTerrasse().setWEST(true);
            }
        }
        if ((object9 = this.getEstateValueAsList("AUSSTATTUNG", "BAD", estateImpl)) != null && !object9.isEmpty()) {
            object8 = OpenImmoUtils.getFactory().createBad();
            if (object9.contains("DUSCHE")) {
                if (ausstattung.getBad() == null) {
                    ausstattung.setBad((Bad)object8);
                }
                ausstattung.getBad().setDUSCHE(true);
            }
            if (object9.contains("FENSTER")) {
                if (ausstattung.getBad() == null) {
                    ausstattung.setBad((Bad)object8);
                }
                ausstattung.getBad().setFENSTER(true);
            }
            if (object9.contains("WANNE")) {
                if (ausstattung.getBad() == null) {
                    ausstattung.setBad((Bad)object8);
                }
                ausstattung.getBad().setWANNE(true);
            }
        }
        if ((object8 = this.getEstateValueAsList("AUSSTATTUNG", "BEFEUERUNG", estateImpl)) != null && !object8.isEmpty()) {
            object7 = OpenImmoUtils.getFactory().createBefeuerung();
            if (object8.contains("ALTERNATIV")) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)object7);
                }
                ausstattung.getBefeuerung().setALTERNATIV(true);
            }
            if (object8.contains("BLOCK")) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)object7);
                }
                ausstattung.getBefeuerung().setBLOCK(true);
            }
            if (object8.contains("ELEKTRO")) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)object7);
                }
                ausstattung.getBefeuerung().setELEKTRO(true);
            }
            if (object8.contains("ERDWAERME")) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)object7);
                }
                ausstattung.getBefeuerung().setERDWAERME(true);
            }
            if (object8.contains("FERNWAERME")) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)object7);
                }
                ausstattung.getBefeuerung().setFERN(true);
            }
            if (object8.contains("GAS")) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)object7);
                }
                ausstattung.getBefeuerung().setGAS(true);
            }
            if (object8.contains("HACKSCHNITZEL")) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)object7);
                }
                ausstattung.getBefeuerung().setALTERNATIV(true);
            }
            if (object8.contains("OEL")) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)object7);
                }
                ausstattung.getBefeuerung().setOEL(true);
            }
            if (object8.contains("PELLETS")) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)object7);
                }
                ausstattung.getBefeuerung().setALTERNATIV(true);
            }
            if (object8.contains("SOLAR")) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)object7);
                }
                ausstattung.getBefeuerung().setSOLAR(true);
            }
            if (object8.contains("WASSER_ELEKTRO")) {
                if (ausstattung.getBefeuerung() == null) {
                    ausstattung.setBefeuerung((Befeuerung)object7);
                }
                ausstattung.getBefeuerung().setWASSERELEKTRO(true);
            }
        }
        if ((object7 = this.getEstateValueAsList("AUSSTATTUNG", "BODENBELAG", estateImpl)) != null && !object7.isEmpty()) {
            object6 = OpenImmoUtils.getFactory().createBoden();
            if (object7.contains("DIELEN") || object7.contains("DIELEN_GESCHLIFFEN")) {
                if (ausstattung.getBoden() == null) {
                    ausstattung.setBoden((Boden)object6);
                }
                ausstattung.getBoden().setDIELEN(true);
            }
            if (object7.contains("DOPPELBODEN")) {
                if (ausstattung.getBoden() == null) {
                    ausstattung.setBoden((Boden)object6);
                }
                ausstattung.getBoden().setDOPPELBODEN(true);
            }
            if (object7.contains("ESTRICH") || object7.contains("BETON")) {
                if (ausstattung.getBoden() == null) {
                    ausstattung.setBoden((Boden)object6);
                }
                ausstattung.getBoden().setESTRICH(true);
            }
            if (object7.contains("FLIESEN") || object7.contains("KERAMIK") || object7.contains("TERRAKOTTA")) {
                if (ausstattung.getBoden() == null) {
                    ausstattung.setBoden((Boden)object6);
                }
                ausstattung.getBoden().setFLIESEN(true);
            }
            if (object7.contains("KUNSTSTOFF") || object7.contains("PVC")) {
                if (ausstattung.getBoden() == null) {
                    ausstattung.setBoden((Boden)object6);
                }
                ausstattung.getBoden().setKUNSTSTOFF(true);
            }
            if (object7.contains("PARKETT")) {
                if (ausstattung.getBoden() == null) {
                    ausstattung.setBoden((Boden)object6);
                }
                ausstattung.getBoden().setPARKETT(true);
            }
            if (object7.contains("STEIN") || object7.contains("GRANIT") || object7.contains("MARMOR") || object7.contains("SCHIEFER")) {
                if (ausstattung.getBoden() == null) {
                    ausstattung.setBoden((Boden)object6);
                }
                ausstattung.getBoden().setSTEIN(true);
            }
            if (object7.contains("TEPPICH") || object7.contains("TEPPICH_ANTISTAT") || object7.contains("NATURFASER")) {
                if (ausstattung.getBoden() == null) {
                    ausstattung.setBoden((Boden)object6);
                }
                ausstattung.getBoden().setTEPPICH(true);
            }
        }
        if (!StringUtils.isBlank((String)(object6 = this.getEstateValueAsString("AUSSTATTUNG", "BREITBAND", estateImpl)))) {
            if (ausstattung.getBreitbandZugang() == null) {
                ausstattung.setBreitbandZugang(OpenImmoUtils.getFactory().createBreitbandZugang());
            }
            ausstattung.getBreitbandZugang().setArt((String)object6);
        }
        if ((bigDecimal = this.getEstateValueAsBigDecimal("AUSSTATTUNG", "BREITBAND_GESCHWINDIGKEIT", estateImpl)) != null) {
            if (ausstattung.getBreitbandZugang() == null) {
                ausstattung.setBreitbandZugang(OpenImmoUtils.getFactory().createBreitbandZugang());
            }
            ausstattung.getBreitbandZugang().setSpeed(bigDecimal);
        }
        if ((list4 = this.getEstateValueAsList("AUSSTATTUNG", "EIGNUNG", estateImpl)) != null && !list4.isEmpty()) {
            if (list4.contains("ROLLSTUHL")) {
                ausstattung.setRollstuhlgerecht(true);
            }
            if (list4.contains("WG")) {
                ausstattung.setWgGeeignet(true);
            }
        }
        if (estateImpl.hasAttribute("AUSSTATTUNG", "LAST_LIFT")) {
            if (ausstattung.getFahrstuhl() == null) {
                ausstattung.setFahrstuhl(OpenImmoUtils.getFactory().createFahrstuhl());
            }
            ausstattung.getFahrstuhl().setLASTEN(this.getEstateValueAsBoolean("AUSSTATTUNG", "LAST_LIFT", estateImpl));
        }
        if (estateImpl.hasAttribute("AUSSTATTUNG", "PERS_LIFT")) {
            if (ausstattung.getFahrstuhl() == null) {
                ausstattung.setFahrstuhl(OpenImmoUtils.getFactory().createFahrstuhl());
            }
            ausstattung.getFahrstuhl().setPERSONEN(this.getEstateValueAsBoolean("AUSSTATTUNG", "PERS_LIFT", estateImpl));
        }
        if ((list3 = this.getEstateValueAsList("AUSSTATTUNG", "HEIZUNGSART", estateImpl)) != null && !list3.isEmpty()) {
            object5 = OpenImmoUtils.getFactory().createHeizungsart();
            if (list3.contains("ETAGE")) {
                if (ausstattung.getHeizungsart() == null) {
                    ausstattung.setHeizungsart((Heizungsart)object5);
                }
                ausstattung.getHeizungsart().setETAGE(true);
            }
            if (list3.contains("FUSSBODEN")) {
                if (ausstattung.getHeizungsart() == null) {
                    ausstattung.setHeizungsart((Heizungsart)object5);
                }
                ausstattung.getHeizungsart().setFUSSBODEN(true);
            }
            if (list3.contains("OFEN")) {
                if (ausstattung.getHeizungsart() == null) {
                    ausstattung.setHeizungsart((Heizungsart)object5);
                }
                ausstattung.getHeizungsart().setOFEN(true);
            }
            if (list3.contains("ZENTRAL")) {
                if (ausstattung.getHeizungsart() == null) {
                    ausstattung.setHeizungsart((Heizungsart)object5);
                }
                ausstattung.getHeizungsart().setZENTRAL(true);
            }
        }
        if (object8 != null && object8.contains("FERNWAERME")) {
            if (ausstattung.getHeizungsart() == null) {
                ausstattung.setHeizungsart(OpenImmoUtils.getFactory().createHeizungsart());
            }
            ausstattung.getHeizungsart().setFERN(true);
        }
        if ((object5 = this.getEstateValueAsList("AUSSTATTUNG", "KUECHE", estateImpl)) != null && !object5.isEmpty()) {
            object4 = OpenImmoUtils.getFactory().createKueche();
            if (object5.contains("EINBAUKUECHE")) {
                if (ausstattung.getKueche() == null) {
                    ausstattung.setKueche((Kueche)object4);
                }
                ausstattung.getKueche().setEBK(true);
            }
            if (object5.contains("OFFENE_KUECHE")) {
                if (ausstattung.getKueche() == null) {
                    ausstattung.setKueche((Kueche)object4);
                }
                ausstattung.getKueche().setOFFEN(true);
            }
        }
        if ((object4 = this.getEstateValueAsString("AUSSTATTUNG", "MOEBLIERT", estateImpl)) != null) {
            if ("JA".equals(object4)) {
                ausstattung.setMoebliert(OpenImmoUtils.getFactory().createMoebliert());
                ausstattung.getMoebliert().setMoeb(Moebliert.Moeb.VOLL);
            } else if ("TEIL".equals(object4)) {
                ausstattung.setMoebliert(OpenImmoUtils.getFactory().createMoebliert());
                ausstattung.getMoebliert().setMoeb(Moebliert.Moeb.TEIL);
            }
        }
        if ((list2 = this.getEstateValueAsList("AUSSTATTUNG", "RAEUME", estateImpl)) != null && !list2.isEmpty()) {
            if (list2.contains("ABSTELLRAUM")) {
                ausstattung.setAbstellraum(true);
            }
            if (list2.contains("FAHRRADRAUM")) {
                ausstattung.setFahrradraum(true);
            }
            if (list2.contains("WASCH_TROCKENRAUM")) {
                ausstattung.setWaschTrockenraum(true);
            }
        }
        if ((list = this.getEstateValueAsList("AUSSTATTUNG", "RAEUME_GEWERBLICH", estateImpl)) != null && !list.isEmpty() && list.contains("TEEKUECHE")) {
            ausstattung.setTeekueche(true);
        }
        if ((string2 = this.getEstateValueAsString("VERWALTUNG", "RAEUME_VERAENDERBAR", estateImpl)) != null) {
            ausstattung.setRaeumeVeraenderbar(string2.equals("JA") || string2.equals("TEIL"));
        }
        List<String> list6 = this.getEstateValueAsList("AUSSTATTUNG", "SERVICELEISTUNGEN", estateImpl);
        List<String> list7 = this.getEstateValueAsList("AUSSTATTUNG", "SERVICELEISTUNGEN_GEWERBE", estateImpl);
        if (!list6.isEmpty() || !list7.isEmpty()) {
            object3 = OpenImmoUtils.getFactory().createServiceleistungen();
            if (list6.contains("BETREUTES_WOHNEN")) {
                if (ausstattung.getServiceleistungen().isEmpty()) {
                    ausstattung.getServiceleistungen().add((Serviceleistungen)object3);
                }
                ausstattung.getServiceleistungen().get(0).setBETREUTESWOHNEN(true);
            }
            if (list6.contains("CATERING") || list7.contains("CATERING")) {
                if (ausstattung.getServiceleistungen().isEmpty()) {
                    ausstattung.getServiceleistungen().add((Serviceleistungen)object3);
                }
                ausstattung.getServiceleistungen().get(0).setCATERING(true);
            }
            if (list6.contains("EINKAUF")) {
                if (ausstattung.getServiceleistungen().isEmpty()) {
                    ausstattung.getServiceleistungen().add((Serviceleistungen)object3);
                }
                ausstattung.getServiceleistungen().get(0).setEINKAUF(true);
            }
            if (list6.contains("REINIGUNG") || list7.contains("REINIGUNG")) {
                if (ausstattung.getServiceleistungen().isEmpty()) {
                    ausstattung.getServiceleistungen().add((Serviceleistungen)object3);
                }
                ausstattung.getServiceleistungen().get(0).setREINIGUNG(true);
            }
            if (list6.contains("WACHDIENST") || list7.contains("WACHDIENST")) {
                if (ausstattung.getServiceleistungen().isEmpty()) {
                    ausstattung.getServiceleistungen().add((Serviceleistungen)object3);
                }
                ausstattung.getServiceleistungen().get(0).setWACHDIENST(true);
            }
        }
        if ((object3 = this.getEstateValueAsList("AUSSTATTUNG", "SICHERHEITSTECHNIK", estateImpl)) != null && !object3.isEmpty()) {
            object2 = OpenImmoUtils.getFactory().createSicherheitstechnik();
            if (object3.contains("ALARMANLAGE")) {
                if (ausstattung.getSicherheitstechnik() == null) {
                    ausstattung.setSicherheitstechnik((Sicherheitstechnik)object2);
                }
                ausstattung.getSicherheitstechnik().setALARMANLAGE(true);
            }
            if (object3.contains("KAMERA")) {
                if (ausstattung.getSicherheitstechnik() == null) {
                    ausstattung.setSicherheitstechnik((Sicherheitstechnik)object2);
                }
                ausstattung.getSicherheitstechnik().setKAMERA(true);
            }
            if (object3.contains("POLIZEIRUF") || object3.contains("NOTRUF")) {
                if (ausstattung.getSicherheitstechnik() == null) {
                    ausstattung.setSicherheitstechnik((Sicherheitstechnik)object2);
                }
                ausstattung.getSicherheitstechnik().setPOLIZEIRUF(true);
            }
        }
        if ((object2 = this.getEstateValueAsList("FLAECHEN", "STELLPLATZART", estateImpl)) != null && !object2.isEmpty()) {
            object = OpenImmoUtils.getFactory().createStellplatzart();
            if (object2.contains("CARPORT")) {
                if (ausstattung.getStellplatzart().isEmpty()) {
                    ausstattung.getStellplatzart().add((Stellplatzart)object);
                }
                ausstattung.getStellplatzart().get(0).setCARPORT(true);
            }
            if (object2.contains("DUPLEX")) {
                if (ausstattung.getStellplatzart().isEmpty()) {
                    ausstattung.getStellplatzart().add((Stellplatzart)object);
                }
                ausstattung.getStellplatzart().get(0).setDUPLEX(true);
            }
            if (object2.contains("AUSSEN") || object2.contains("STELLPLATZ")) {
                if (ausstattung.getStellplatzart().isEmpty()) {
                    ausstattung.getStellplatzart().add((Stellplatzart)object);
                }
                ausstattung.getStellplatzart().get(0).setFREIPLATZ(true);
            }
            if (object2.contains("GARAGE")) {
                if (ausstattung.getStellplatzart().isEmpty()) {
                    ausstattung.getStellplatzart().add((Stellplatzart)object);
                }
                ausstattung.getStellplatzart().get(0).setGARAGE(true);
            }
            if (object2.contains("PARKHAUS")) {
                if (ausstattung.getStellplatzart().isEmpty()) {
                    ausstattung.getStellplatzart().add((Stellplatzart)object);
                }
                ausstattung.getStellplatzart().get(0).setPARKHAUS(true);
            }
            if (object2.contains("TIEFGARAGE")) {
                if (ausstattung.getStellplatzart().isEmpty()) {
                    ausstattung.getStellplatzart().add((Stellplatzart)object);
                }
                ausstattung.getStellplatzart().get(0).setTIEFGARAGE(true);
            }
        }
        if ((object = this.getEstateValueAsList("AUSSTATTUNG", "TECHNIK", estateImpl)) != null && !object.isEmpty()) {
            if (object.contains("DV_VERKABELUNG")) {
                ausstattung.setDvVerkabelung(true);
            }
            if (object.contains("DVBT_EMPFANG")) {
                ausstattung.setDvbt(true);
            }
            if (object.contains("UMTS_EMPFANG")) {
                ausstattung.setUmtsEmpfang(true);
            }
            if (object.contains("KABEL_SAT_TV")) {
                ausstattung.setKabelSatTv(true);
            } else if (object.contains("KABEL_TV")) {
                ausstattung.setKabelSatTv(true);
            } else if (object.contains("SAT_TV")) {
                ausstattung.setKabelSatTv(true);
            } else {
                ausstattung.setKabelSatTv(false);
            }
        }
        if ((string = this.getEstateValueAsString("AUSSTATTUNG", "UNTERKELLERT", estateImpl)) != null) {
            ausstattung.setUnterkellert(OpenImmoUtils.getFactory().createUnterkellert());
            if (string.equals("JA")) {
                ausstattung.getUnterkellert().setKeller(Unterkellert.Keller.JA);
            } else if (string.equals("TEIL")) {
                ausstattung.getUnterkellert().setKeller(Unterkellert.Keller.TEIL);
            } else if (string.equals("NEIN")) {
                ausstattung.getUnterkellert().setKeller(Unterkellert.Keller.NEIN);
            }
        }
    }

    protected void writeImmobilieBewertung(Bewertung bewertung, EstateImpl estateImpl) {
        throw new UnsupportedOperationException("not implemented yet!");
    }

    protected void writeImmobilieBieterverfahren(Bieterverfahren bieterverfahren, EstateImpl estateImpl) {
        throw new UnsupportedOperationException("not implemented yet!");
    }

    protected void writeImmobilieFlaechen(Flaechen flaechen, EstateImpl estateImpl) {
        flaechen.setAnzahlBadezimmer(this.getEstateValueAsBigDecimal("FLAECHEN", "ANZ_BADEZIMMER", estateImpl));
        flaechen.setAnzahlBalkonTerrassen(this.getEstateValueAsBigDecimal("FLAECHEN", "ANZ_BALKON_TERRASSEN", estateImpl));
        flaechen.setAnzahlBetten(this.getEstateValueAsBigDecimal("FLAECHEN", "ANZ_BETTEN", estateImpl));
        flaechen.setAnzahlGewerbeeinheiten(this.getEstateValueAsBigDecimal("FLAECHEN", "ANZ_GEWERBEEINHEIT", estateImpl));
        flaechen.setAnzahlSchlafzimmer(this.getEstateValueAsBigDecimal("FLAECHEN", "ANZ_SCHLAFZIMMER", estateImpl));
        flaechen.setAnzahlSepWc(this.getEstateValueAsBigDecimal("FLAECHEN", "ANZ_SEP_WC", estateImpl));
        flaechen.setAnzahlStellplaetze(this.getEstateValueAsBigDecimal("FLAECHEN", "ANZ_STELLPLAETZE", estateImpl));
        flaechen.setAnzahlTagungsraeume(this.getEstateValueAsBigDecimal("FLAECHEN", "ANZ_TAGUNGSRAEUME", estateImpl));
        flaechen.setAnzahlWohnSchlafzimmer(this.getEstateValueAsBigDecimal("FLAECHEN", "ANZ_WOHN_SCHLAFZIMMMER", estateImpl));
        flaechen.setAnzahlWohneinheiten(this.getEstateValueAsBigDecimal("FLAECHEN", "ANZ_WOHNEINHEITEN", estateImpl));
        flaechen.setAnzahlZimmer(this.getEstateValueAsBigDecimal("FLAECHEN", "ANZ_ZIMMER", estateImpl));
        flaechen.setBalkonTerrasseFlaeche(this.getEstateValueAsBigDecimal("FLAECHEN", "BALKONFLAECHE", estateImpl));
        flaechen.setBeheizbareFlaeche(this.getEstateValueAsBigDecimal("FLAECHEN", "BEHEIZBARE_FLAECHE", estateImpl));
        flaechen.setBgf(this.getEstateValueAsString("FLAECHEN", "BGF", estateImpl));
        flaechen.setBmz(this.getEstateValueAsString("FLAECHEN", "BMZ", estateImpl));
        flaechen.setBueroflaeche(this.getEstateValueAsBigDecimal("FLAECHEN", "BUEROFLAECHE", estateImpl));
        flaechen.setBueroteilflaeche(this.getEstateValueAsBigDecimal("FLAECHEN", "BUEROFLAECHE", estateImpl));
        flaechen.setDachbodenflaeche(this.getEstateValueAsBigDecimal("FLAECHEN", "DACHBODENFLAECHE", estateImpl));
        flaechen.setEinliegerwohnung(this.getEstateValueAsBoolean("VERWALTUNG", "EINLIEGERWOHNUNG", estateImpl));
        flaechen.setFensterfront(this.getEstateValueAsBigDecimal("FLAECHEN", "FENSTERFRONT_M", estateImpl));
        flaechen.setFensterfrontQm(this.getEstateValueAsBigDecimal("FLAECHEN", "FENSTERFRONT", estateImpl));
        flaechen.setFreiflaeche(this.getEstateValueAsBigDecimal("FLAECHEN", "FREIFLAECHE", estateImpl));
        flaechen.setGartenflaeche(this.getEstateValueAsBigDecimal("FLAECHEN", "GARTENFLAECHE", estateImpl));
        flaechen.setGastroflaeche(this.getEstateValueAsBigDecimal("FLAECHEN", "GASTRAUMFLAECHE", estateImpl));
        flaechen.setGesamtflaeche(this.getEstateValueAsBigDecimal("FLAECHEN", "GESAMTFLAECHE", estateImpl));
        flaechen.setGfz(this.getEstateValueAsString("FLAECHEN", "GFZ", estateImpl));
        flaechen.setGrundstuecksflaeche(this.getEstateValueAsBigDecimal("FLAECHEN", "GRUNDSTUECKSFLAECHE", estateImpl));
        flaechen.setGrundstuecksfront(this.getEstateValueAsBigDecimal("FLAECHEN", "GRUNDSTUECKSFRONT", estateImpl));
        flaechen.setGrz(this.getEstateValueAsString("FLAECHEN", "GRZ", estateImpl));
        flaechen.setKellerflaeche(this.getEstateValueAsBigDecimal("FLAECHEN", "KELLERFLAECHE", estateImpl));
        flaechen.setLadenflaeche(this.getEstateValueAsBigDecimal("FLAECHEN", "LADENFLAECHE", estateImpl));
        flaechen.setLagerflaeche(this.getEstateValueAsBigDecimal("FLAECHEN", "LAGERFLAECHE", estateImpl));
        flaechen.setNutzflaeche(this.getEstateValueAsBigDecimal("FLAECHEN", "NUTZFLAECHE", estateImpl));
        flaechen.setPlaetzeGastraum(this.getEstateValueAsBigDecimal("FLAECHEN", "PLAETZE_GASTRAUM", estateImpl));
        flaechen.setSonstflaeche(this.getEstateValueAsBigDecimal("FLAECHEN", "SONSTFLAECHE", estateImpl));
        flaechen.setTeilbarAb(this.getEstateValueAsBigDecimal("FLAECHEN", "TEILBAR_AB", estateImpl));
        flaechen.setVerkaufsflaeche(this.getEstateValueAsBigDecimal("FLAECHEN", "VERKAUFSFLAECHE", estateImpl));
        flaechen.setVermietbareFlaeche(this.getEstateValueAsBigDecimal("FLAECHEN", "VERMIETBARE_FLAECHE", estateImpl));
        flaechen.setVerkaufsflaeche(this.getEstateValueAsBigDecimal("FLAECHEN", "VERWALTUNGSFLAECHE", estateImpl));
        flaechen.setWohnflaeche(this.getEstateValueAsBigDecimal("FLAECHEN", "WOHNFLAECHE", estateImpl));
    }

    protected void writeImmobilieFreitexte(Freitexte freitexte, EstateImpl estateImpl) {
        freitexte.setAusstattBeschr(this.getEstateValueAsString("FREITEXTE", "AUSSTATT_BESCHR", estateImpl));
        freitexte.setDreizeiler(this.getEstateValueAsString("FREITEXTE", "KURZ_BESCHR", estateImpl));
        freitexte.setLage(this.getEstateValueAsString("FREITEXTE", "LAGE_BESCHR", estateImpl));
        freitexte.setObjektbeschreibung(this.getEstateValueAsString("FREITEXTE", "OBJEKT_BESCHR", estateImpl));
        freitexte.setObjekttitel(OpenEstateUtils.serializeString(estateImpl.getTitle(this.getOpenEstateLanguage()), this.getXmlLineSeparator()));
        freitexte.setSonstigeAngaben(this.getEstateValueAsString("FREITEXTE", "SONSTIGE_ANGABEN", estateImpl));
        if (this.isEnergyCertificateAppendedToDescription()) {
            String string = OpenEstateUtils.writeEstateEnergyCertificate(estateImpl, this.getOpenEstateLanguage(), this.getXmlLineSeparator());
            String string2 = this.getXmlLineSeparator() + this.getXmlLineSeparator() + StringUtils.repeat((String)"-", (int)15) + this.getXmlLineSeparator() + this.getXmlLineSeparator();
            if (!StringUtils.isBlank((String)string)) {
                String string3 = StringUtils.trimToNull((String)freitexte.getObjektbeschreibung());
                string3 = string3 == null ? string : string + string2 + string3;
                freitexte.setObjektbeschreibung(StringUtils.trimToEmpty((String)string3));
            }
        }
    }

    protected void writeImmobilieGeo(Geo geo, EstateImpl estateImpl) {
        Object object;
        Object object2;
        String string;
        geo.setAnzahlEtagen(this.getEstateValueAsInteger("AUSSTATTUNG", "ETAGE_GESAMT", estateImpl));
        geo.setBundesland(estateImpl.getAdress().getRegion());
        geo.setEtage(this.getEstateValueAsInteger("AUSSTATTUNG", "ETAGE", estateImpl));
        geo.setFlur(this.getEstateValueAsString("VERWALTUNG", "FLUR", estateImpl));
        geo.setFlurstueck(this.getEstateValueAsString("VERWALTUNG", "FLURSTUECK", estateImpl));
        geo.setGemarkung(this.getEstateValueAsString("VERWALTUNG", "GEMARKUNG", estateImpl));
        geo.setGemeindecode(this.getEstateValueAsString("VERWALTUNG", "GEMEINDECODE", estateImpl));
        geo.setHausnummer(estateImpl.getAdress().getStreetNr());
        if (!StringUtils.isBlank((String)estateImpl.getAdress().getCountry())) {
            string = OpenEstateUtils.convertToIso3Country(estateImpl.getAdress().getCountry());
            if (string != null && string.length() == 3) {
                geo.setLand(OpenImmoUtils.getFactory().createLand());
                geo.getLand().setIsoLand(string);
            } else {
                LOGGER.warn((Object)("Can't convert country: " + estateImpl.getAdress().getCountry() + " => " + string));
            }
        }
        geo.setStrasse(estateImpl.getAdress().getStreet());
        geo.setWohnungsnr(this.getEstateValueAsString("VERWALTUNG", "WOHNUNGSNR", estateImpl));
        string = this.getEstateValueAsString("VERWALTUNG", "REGIONALER_ZUSATZ", estateImpl);
        if (StringUtils.isBlank((String)string)) {
            string = estateImpl.getAdress().getCityPart();
        }
        geo.setRegionalerZusatz(StringUtils.trimToNull((String)string));
        if (!StringUtils.isBlank((String)estateImpl.getAdress().getPostalCode())) {
            geo.getAnschrift().add(new JAXBElement(new QName("plz"), String.class, (Object)estateImpl.getAdress().getPostalCode().trim()));
        }
        if (!StringUtils.isBlank((String)estateImpl.getAdress().getCity())) {
            geo.getAnschrift().add(new JAXBElement(new QName("ort"), String.class, (Object)estateImpl.getAdress().getCity().trim()));
        }
        if (estateImpl.getAdress().getLatitude() != null && estateImpl.getAdress().getLongitude() != null) {
            object2 = OpenImmoUtils.getFactory().createGeokoordinaten();
            ((Geokoordinaten)object2).setBreitengrad(estateImpl.getAdress().getLatitude());
            ((Geokoordinaten)object2).setLaengengrad(estateImpl.getAdress().getLongitude());
            geo.getAnschrift().add(object2);
        }
        object2 = this.getEstateValueAsList("UMFELD", "LAGE_GEBIET", estateImpl);
        List<String> list = this.getEstateValueAsList("UMFELD", "LAGE_GEWERBE", estateImpl);
        if (!object2.isEmpty() || !list.isEmpty()) {
            object = OpenImmoUtils.getFactory().createLageGebiet();
            if (list.contains("A_LAGE") || list.contains("1A_LAGE") || list.contains("2A_LAGE")) {
                ((LageGebiet)object).setGebiete(LageGebiet.Gebiete.A_LAGE);
                geo.setLageGebiet((LageGebiet)object);
            } else if (list.contains("B_LAGE") || list.contains("1B_LAGE") || list.contains("2B_LAGE")) {
                ((LageGebiet)object).setGebiete(LageGebiet.Gebiete.B_LAGE);
                geo.setLageGebiet((LageGebiet)object);
            } else if (list.contains("EINKAUFSZENTRUM") || list.contains("FUSSGAENGERZONE") || object2.contains("GEWERBE")) {
                ((LageGebiet)object).setGebiete(LageGebiet.Gebiete.GEWERBE);
                geo.setLageGebiet((LageGebiet)object);
            } else if (object2.contains("GEMISCHT")) {
                ((LageGebiet)object).setGebiete(LageGebiet.Gebiete.MISCH);
                geo.setLageGebiet((LageGebiet)object);
            } else if (object2.contains("INDUSTRIE")) {
                ((LageGebiet)object).setGebiete(LageGebiet.Gebiete.INDUSTRIE);
                geo.setLageGebiet((LageGebiet)object);
            } else if (object2.contains("NEBENZENTRUM")) {
                ((LageGebiet)object).setGebiete(LageGebiet.Gebiete.NEBENZENTRUM);
                geo.setLageGebiet((LageGebiet)object);
            } else if (object2.contains("NEUBAU")) {
                ((LageGebiet)object).setGebiete(LageGebiet.Gebiete.NEUBAU);
                geo.setLageGebiet((LageGebiet)object);
            } else if (object2.contains("ORTSLAGE") || object2.contains("DORFRAND") || object2.contains("DORFZENTRUM")) {
                ((LageGebiet)object).setGebiete(LageGebiet.Gebiete.ORTSLAGE);
                geo.setLageGebiet((LageGebiet)object);
            } else if (object2.contains("SIEDLUNG")) {
                ((LageGebiet)object).setGebiete(LageGebiet.Gebiete.SIEDLUNG);
                geo.setLageGebiet((LageGebiet)object);
            } else if (object2.contains("STADTRAND")) {
                ((LageGebiet)object).setGebiete(LageGebiet.Gebiete.STADTRAND);
                geo.setLageGebiet((LageGebiet)object);
            } else if (object2.contains("STADTTEIL")) {
                ((LageGebiet)object).setGebiete(LageGebiet.Gebiete.STADTTEIL);
                geo.setLageGebiet((LageGebiet)object);
            } else if (object2.contains("STADTZENTRUM")) {
                ((LageGebiet)object).setGebiete(LageGebiet.Gebiete.STADTZENTRUM);
                geo.setLageGebiet((LageGebiet)object);
            } else if (object2.contains("WOHN")) {
                ((LageGebiet)object).setGebiete(LageGebiet.Gebiete.WOHN);
                geo.setLageGebiet((LageGebiet)object);
            }
        }
        if ((object = this.getEstateValueAsList("VERWALTUNG", "LAGE_IM_BAU", estateImpl)) != null && !object.isEmpty()) {
            LageImBau lageImBau = OpenImmoUtils.getFactory().createLageImBau();
            if (object.contains("HINTERHAUS")) {
                if (geo.getLageImBau() == null) {
                    geo.setLageImBau(lageImBau);
                }
                geo.getLageImBau().setHINTEN(true);
            }
            if (object.contains("SEITENFLUEGEL_LINKS")) {
                if (geo.getLageImBau() == null) {
                    geo.setLageImBau(lageImBau);
                }
                geo.getLageImBau().setLINKS(true);
            }
            if (object.contains("SEITENFLUEGEL_RECHTS")) {
                if (geo.getLageImBau() == null) {
                    geo.setLageImBau(lageImBau);
                }
                geo.getLageImBau().setRECHTS(true);
            }
            if (object.contains("VORDERHAUS")) {
                if (geo.getLageImBau() == null) {
                    geo.setLageImBau(lageImBau);
                }
                geo.getLageImBau().setVORNE(true);
            }
        }
    }

    protected void writeImmobilieInfrastruktur(Infrastruktur infrastruktur, EstateImpl estateImpl) {
        Object object;
        List<String> list = this.getEstateValueAsList("UMFELD", "AUSBLICK", estateImpl);
        if (list != null && !list.isEmpty()) {
            object = OpenImmoUtils.getFactory().createAusblick();
            if (list.contains("BERGBLICK")) {
                if (infrastruktur.getAusblick() == null) {
                    infrastruktur.setAusblick((Ausblick)object);
                }
                infrastruktur.getAusblick().setBlick(Ausblick.Blick.BERGE);
            }
            if (list.contains("FERNBLICK")) {
                if (infrastruktur.getAusblick() == null) {
                    infrastruktur.setAusblick((Ausblick)object);
                }
                infrastruktur.getAusblick().setBlick(Ausblick.Blick.FERNE);
            }
            if (list.contains("SEEBLICK")) {
                if (infrastruktur.getAusblick() == null) {
                    infrastruktur.setAusblick((Ausblick)object);
                }
                infrastruktur.getAusblick().setBlick(Ausblick.Blick.SEE);
            }
            if (list.contains("MEERBLICK")) {
                if (infrastruktur.getAusblick() == null) {
                    infrastruktur.setAusblick((Ausblick)object);
                }
                infrastruktur.getAusblick().setBlick(Ausblick.Blick.SEE);
            }
        }
        if ((object = this.getEstateValueAsFloat("UMFELD", "DISTANZ_AUTOBAHN", estateImpl)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.AUTOBAHN, (Float)object));
        }
        if ((object = this.getEstateValueAsFloat("UMFELD", "DISTANZ_BUS", estateImpl)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.BUS, (Float)object));
        }
        if ((object = this.getEstateValueAsFloat("UMFELD", "DISTANZ_EINKAUF", estateImpl)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.EINKAUFSMOEGLICHKEITEN, (Float)object));
        }
        if ((object = this.getEstateValueAsFloat("UMFELD", "DISTANZ_BHF", estateImpl)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.FERNBAHNHOF, (Float)object));
        }
        if ((object = this.getEstateValueAsFloat("UMFELD", "DISTANZ_FLUG", estateImpl)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.FLUGHAFEN, (Float)object));
        }
        if ((object = this.getEstateValueAsFloat("UMFELD", "DISTANZ_GASTRONOMIE", estateImpl)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.GASTSTAETTEN, (Float)object));
        }
        if ((object = this.getEstateValueAsFloat("UMFELD", "DISTANZ_GESAMTSCHULE", estateImpl)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.GESAMTSCHULE, (Float)object));
        }
        if ((object = this.getEstateValueAsFloat("UMFELD", "DISTANZ_GRUNDSCHULE", estateImpl)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.GRUNDSCHULE, (Float)object));
        }
        if ((object = this.getEstateValueAsFloat("UMFELD", "DISTANZ_GYMNASIUM", estateImpl)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.GYMNASIUM, (Float)object));
        }
        if ((object = this.getEstateValueAsFloat("UMFELD", "DISTANZ_HAUPTSCHULE", estateImpl)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.HAUPTSCHULE, (Float)object));
        }
        if ((object = this.getEstateValueAsFloat("UMFELD", "DISTANZ_KITA", estateImpl)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.KINDERGAERTEN, (Float)object));
        }
        if ((object = this.getEstateValueAsFloat("UMFELD", "DISTANZ_REALSCHULE", estateImpl)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.REALSCHULE, (Float)object));
        }
        if ((object = this.getEstateValueAsFloat("UMFELD", "DISTANZ_NAHBHF", estateImpl)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.US_BAHN, (Float)object));
        }
        if ((object = this.getEstateValueAsFloat("UMFELD", "DISTANZ_ZENTRUM", estateImpl)) != null) {
            infrastruktur.getDistanzen().add(this.createDistanz(Distanzen.DistanzZu.ZENTRUM, (Float)object));
        }
        if ((object = this.getEstateValueAsFloat("UMFELD", "DISTANZ_MEER", estateImpl)) != null) {
            infrastruktur.getDistanzenSport().add(this.createDistanzSport(DistanzenSport.DistanzZuSport.MEER, (Float)object));
        }
        if ((object = this.getEstateValueAsFloat("UMFELD", "DISTANZ_NAHERHOHLUNG", estateImpl)) != null) {
            infrastruktur.getDistanzenSport().add(this.createDistanzSport(DistanzenSport.DistanzZuSport.NAHERHOLUNG, (Float)object));
        }
        if ((object = this.getEstateValueAsFloat("UMFELD", "DISTANZ_SEE", estateImpl)) != null) {
            infrastruktur.getDistanzenSport().add(this.createDistanzSport(DistanzenSport.DistanzZuSport.SEE, (Float)object));
        }
        if ((object = this.getEstateValueAsFloat("UMFELD", "DISTANZ_SKIGEBIET", estateImpl)) != null) {
            infrastruktur.getDistanzenSport().add(this.createDistanzSport(DistanzenSport.DistanzZuSport.SKIGEBIET, (Float)object));
        }
        if ((object = this.getEstateValueAsFloat("UMFELD", "DISTANZ_SPORTANLAGEN", estateImpl)) != null) {
            infrastruktur.getDistanzenSport().add(this.createDistanzSport(DistanzenSport.DistanzZuSport.SPORTANLAGEN, (Float)object));
        }
        if ((object = this.getEstateValueAsFloat("UMFELD", "DISTANZ_STRAND", estateImpl)) != null) {
            infrastruktur.getDistanzenSport().add(this.createDistanzSport(DistanzenSport.DistanzZuSport.STRAND, (Float)object));
        }
        if ((object = this.getEstateValueAsFloat("UMFELD", "DISTANZ_WANDERGEBIET", estateImpl)) != null) {
            infrastruktur.getDistanzenSport().add(this.createDistanzSport(DistanzenSport.DistanzZuSport.WANDERGEBIETE, (Float)object));
        }
        infrastruktur.setZulieferung(this.getEstateValueAsBoolean("UMFELD", "ZULIEFERUNG_MOEGLICH", estateImpl));
    }

    protected void writeImmobilieKontaktperson(Kontaktperson kontaktperson, AgentContactImpl agentContactImpl, AgentImpl agentImpl) {
        this.writeImmobilieKontaktperson(kontaktperson, (PersonAdressImpl)agentContactImpl, agentImpl);
        kontaktperson.setPersonennummer(StringUtils.trimToNull((String)agentContactImpl.getId()));
    }

    protected void writeImmobilieKontaktperson(Kontaktperson kontaktperson, PersonAdressImpl personAdressImpl, AgentImpl agentImpl) {
        String string;
        kontaktperson.setHausnummer(StringUtils.trimToNull((String)personAdressImpl.getStreetNr()));
        kontaktperson.setName(StringUtils.trimToNull((String)personAdressImpl.getPersonLastName()));
        kontaktperson.setOrt(StringUtils.trimToNull((String)personAdressImpl.getCity()));
        kontaktperson.setPersonennummer(null);
        kontaktperson.setPlz(StringUtils.trimToNull((String)personAdressImpl.getPostalCode()));
        kontaktperson.setStrasse(StringUtils.trimToNull((String)personAdressImpl.getStreet()));
        kontaktperson.setTitel(StringUtils.trimToNull((String)personAdressImpl.getPersonTitle()));
        kontaktperson.setVorname(StringUtils.trimToNull((String)personAdressImpl.getPersonFirstName()));
        if (!StringUtils.isBlank((String)personAdressImpl.getCountry()) && (string = OpenEstateUtils.convertToIso3Country(personAdressImpl.getCountry())) != null && string.length() == 3) {
            kontaktperson.setLand(OpenImmoUtils.getFactory().createLand());
            kontaktperson.getLand().setIsoLand(string);
        }
        if (!StringUtils.isBlank((String)agentImpl.getCompany().getCompanyMail())) {
            kontaktperson.getKontakte().add((JAXBElement<String>)new JAXBElement(new QName("email_zentrale"), String.class, (Object)agentImpl.getCompany().getCompanyMail().trim()));
        }
        if (!StringUtils.isBlank((String)personAdressImpl.getPersonMail())) {
            kontaktperson.getKontakte().add((JAXBElement<String>)new JAXBElement(new QName("email_direkt"), String.class, (Object)personAdressImpl.getPersonMail().trim()));
        }
        if (!StringUtils.isBlank((String)agentImpl.getCompany().getCompanyPhone())) {
            kontaktperson.getKontakte().add((JAXBElement<String>)new JAXBElement(new QName("tel_zentrale"), String.class, (Object)agentImpl.getCompany().getCompanyPhone().trim()));
        }
        if (!StringUtils.isBlank((String)personAdressImpl.getPersonPhone())) {
            kontaktperson.getKontakte().add((JAXBElement<String>)new JAXBElement(new QName("tel_durchw"), String.class, (Object)personAdressImpl.getPersonPhone().trim()));
        }
        if (!StringUtils.isBlank((String)personAdressImpl.getPersonFax())) {
            kontaktperson.getKontakte().add((JAXBElement<String>)new JAXBElement(new QName("tel_fax"), String.class, (Object)personAdressImpl.getPersonFax().trim()));
        }
        if (!StringUtils.isBlank((String)personAdressImpl.getPersonMobilePhone())) {
            kontaktperson.getKontakte().add((JAXBElement<String>)new JAXBElement(new QName("tel_handy"), String.class, (Object)personAdressImpl.getPersonMobilePhone().trim()));
        }
    }

    protected void writeImmobilieObjektkategorie(Objektkategorie objektkategorie, EstateImpl estateImpl) throws OpenEstateException {
        if (estateImpl.getAction() == null || estateImpl.getType() == null) {
            return;
        }
        String string = estateImpl.getAction();
        String string2 = estateImpl.getType().getName();
        List<String> list = Arrays.asList(OpenEstateUtils.getEstateTypePath(estateImpl.getType()));
        objektkategorie.setVermarktungsart(OpenImmoUtils.getFactory().createVermarktungsart());
        objektkategorie.getVermarktungsart().setERBPACHT("ERBPACHT".equals(string));
        objektkategorie.getVermarktungsart().setKAUF("KAUF".equals(string));
        objektkategorie.getVermarktungsart().setMIETEPACHT("MIETE".equals(string) || "PACHT".equals(string) || "VERSTEIGERUNG".equals(string) || "WAZ".equals(string));
        objektkategorie.setNutzungsart(OpenImmoUtils.getFactory().createNutzungsart());
        objektkategorie.getNutzungsart().setWAZ("WAZ".equals(string));
        objektkategorie.getNutzungsart().setGEWERBE(Boolean.TRUE.equals(this.hasEstateValue("VERWALTUNG", "NUTZUNGSART", "GEWERBE", estateImpl)));
        objektkategorie.getNutzungsart().setWOHNEN(Boolean.TRUE.equals(this.hasEstateValue("VERWALTUNG", "NUTZUNGSART", "WOHNEN", estateImpl)));
        objektkategorie.getNutzungsart().setANLAGE(Boolean.TRUE.equals(this.hasEstateValue("VERWALTUNG", "NUTZUNGSART", "ANLAGE", estateImpl)));
        if (!(objektkategorie.getNutzungsart().isANLAGE().booleanValue() || objektkategorie.getNutzungsart().isGEWERBE() || objektkategorie.getNutzungsart().isWAZ().booleanValue() || objektkategorie.getNutzungsart().isWOHNEN())) {
            if (list.contains("MAIN_WOHNEN") || list.contains("MFH_GEWERBE") || list.contains("WOHNGRUND")) {
                objektkategorie.getNutzungsart().setWOHNEN(true);
            }
            if (list.contains("MAIN_GEWERBE") || list.contains("MAIN_LANDWIRTSCHAFT") || list.contains("MFH_GEWERBE") || list.contains("GEWERBEGRUND") || list.contains("INDUSTRIEGRUND")) {
                objektkategorie.getNutzungsart().setGEWERBE(true);
            }
        }
        objektkategorie.setObjektart(OpenImmoUtils.getFactory().createObjektart());
        if (list.contains("BUEROHAUS") || list.contains("BUEROZENTRUM")) {
            ZinshausRenditeobjekt zinshausRenditeobjekt = OpenImmoUtils.getFactory().createZinshausRenditeobjekt();
            zinshausRenditeobjekt.setZinsTyp(ZinshausRenditeobjekt.ZinsTyp.BUEROGEBAEUDE);
            objektkategorie.getObjektart().getZinshausRenditeobjekt().add(zinshausRenditeobjekt);
        } else if (list.contains("EINKAUFSZENTRUM") || list.contains("KAUFHAUS")) {
            ZinshausRenditeobjekt zinshausRenditeobjekt = OpenImmoUtils.getFactory().createZinshausRenditeobjekt();
            zinshausRenditeobjekt.setZinsTyp(ZinshausRenditeobjekt.ZinsTyp.EINKAUFSCENTREN);
            objektkategorie.getObjektart().getZinshausRenditeobjekt().add(zinshausRenditeobjekt);
        } else if (list.contains("BUERO_GESCHAEFTSHAUS")) {
            ZinshausRenditeobjekt zinshausRenditeobjekt = OpenImmoUtils.getFactory().createZinshausRenditeobjekt();
            zinshausRenditeobjekt.setZinsTyp(ZinshausRenditeobjekt.ZinsTyp.GESCHAEFTSHAUS);
            objektkategorie.getObjektart().getZinshausRenditeobjekt().add(zinshausRenditeobjekt);
        } else if (list.contains("INDUSTRIEANLAGE") || list.contains("INDUSTRIEHALLE")) {
            ZinshausRenditeobjekt zinshausRenditeobjekt = OpenImmoUtils.getFactory().createZinshausRenditeobjekt();
            zinshausRenditeobjekt.setZinsTyp(ZinshausRenditeobjekt.ZinsTyp.INDUSTRIEANLAGEN);
            objektkategorie.getObjektart().getZinshausRenditeobjekt().add(zinshausRenditeobjekt);
        } else if (objektkategorie.getNutzungsart().isANLAGE().booleanValue() && list.contains("MFH")) {
            ZinshausRenditeobjekt zinshausRenditeobjekt = OpenImmoUtils.getFactory().createZinshausRenditeobjekt();
            zinshausRenditeobjekt.setZinsTyp(ZinshausRenditeobjekt.ZinsTyp.MEHRFAMILIENHAUS);
            objektkategorie.getObjektart().getZinshausRenditeobjekt().add(zinshausRenditeobjekt);
        } else if (list.contains("SB_MARKT")) {
            ZinshausRenditeobjekt zinshausRenditeobjekt = OpenImmoUtils.getFactory().createZinshausRenditeobjekt();
            zinshausRenditeobjekt.setZinsTyp(ZinshausRenditeobjekt.ZinsTyp.SB_MAERKTE);
            objektkategorie.getObjektart().getZinshausRenditeobjekt().add(zinshausRenditeobjekt);
        } else if (list.contains("VERBRAUCHERMARKT")) {
            ZinshausRenditeobjekt zinshausRenditeobjekt = OpenImmoUtils.getFactory().createZinshausRenditeobjekt();
            zinshausRenditeobjekt.setZinsTyp(ZinshausRenditeobjekt.ZinsTyp.VERBRAUCHERMAERKTE);
            objektkategorie.getObjektart().getZinshausRenditeobjekt().add(zinshausRenditeobjekt);
        } else if (list.contains("WOHNANLAGE")) {
            ZinshausRenditeobjekt zinshausRenditeobjekt = OpenImmoUtils.getFactory().createZinshausRenditeobjekt();
            zinshausRenditeobjekt.setZinsTyp(ZinshausRenditeobjekt.ZinsTyp.WOHNANLAGEN);
            objektkategorie.getObjektart().getZinshausRenditeobjekt().add(zinshausRenditeobjekt);
        } else if (list.contains("WOHN_GESCHAEFTSHAUS")) {
            ZinshausRenditeobjekt zinshausRenditeobjekt = OpenImmoUtils.getFactory().createZinshausRenditeobjekt();
            zinshausRenditeobjekt.setZinsTyp(ZinshausRenditeobjekt.ZinsTyp.WOHN_UND_GESCHAEFTSHAUS);
            objektkategorie.getObjektart().getZinshausRenditeobjekt().add(zinshausRenditeobjekt);
        } else if (list.contains("ZIMMER")) {
            Zimmer zimmer = OpenImmoUtils.getFactory().createZimmer();
            zimmer.setZimmertyp(Zimmer.Zimmertyp.ZIMMER);
            objektkategorie.getObjektart().getZimmer().add(zimmer);
        } else if (list.contains("MAIN_STELLPLATZ") || list.contains("TANKSTELLE")) {
            Sonstige sonstige = OpenImmoUtils.getFactory().createSonstige();
            for (int i = list.size(); i > 0; --i) {
                Sonstige.SonstigeTyp sonstigeTyp = this.getObjektartSonstigeTyp(list.get(i - 1));
                if (sonstigeTyp == null) continue;
                sonstige.setSonstigeTyp(sonstigeTyp);
                break;
            }
            objektkategorie.getObjektart().getSonstige().add(sonstige);
        } else if (list.contains("BUERO_PRAXIS") || list.contains("BUERO_GESCHAEFTSLOKAL") || list.contains("AUSSTELLUNGSFLAECHE")) {
            BueroPraxen bueroPraxen = OpenImmoUtils.getFactory().createBueroPraxen();
            for (int i = list.size(); i > 0; --i) {
                BueroPraxen.BueroTyp bueroTyp = this.getObjektartBueroTyp(list.get(i - 1));
                if (bueroTyp == null) continue;
                bueroPraxen.setBueroTyp(bueroTyp);
                break;
            }
            objektkategorie.getObjektart().getBueroPraxen().add(bueroPraxen);
        } else if (list.contains("EINZELHANDEL")) {
            Einzelhandel einzelhandel = OpenImmoUtils.getFactory().createEinzelhandel();
            for (int i = list.size(); i > 0; --i) {
                Einzelhandel.HandelTyp handelTyp = this.getObjektartHandelTyp(list.get(i - 1));
                if (handelTyp == null) continue;
                einzelhandel.setHandelTyp(handelTyp);
                break;
            }
            objektkategorie.getObjektart().getEinzelhandel().add(einzelhandel);
        } else if ((list.contains("MAIN_LANDWIRTSCHAFT") || list.contains("REITERHOF")) && !list.contains("RESTHOF")) {
            LandUndForstwirtschaft landUndForstwirtschaft = OpenImmoUtils.getFactory().createLandUndForstwirtschaft();
            for (int i = list.size(); i > 0; --i) {
                LandUndForstwirtschaft.LandTyp landTyp = this.getObjektartLandTyp(list.get(i - 1));
                if (landTyp == null) continue;
                landUndForstwirtschaft.setLandTyp(landTyp);
                break;
            }
            if (landUndForstwirtschaft.getLandTyp() == null) {
                landUndForstwirtschaft.setLandTyp(LandUndForstwirtschaft.LandTyp.SONSTIGE_LANDWIRTSCHAFTSIMMOBILIEN);
            }
            objektkategorie.getObjektart().getLandUndForstwirtschaft().add(landUndForstwirtschaft);
        } else if (list.contains("FREIZEIT_SPORT")) {
            FreizeitimmobilieGewerblich freizeitimmobilieGewerblich = OpenImmoUtils.getFactory().createFreizeitimmobilieGewerblich();
            for (int i = list.size(); i > 0; --i) {
                FreizeitimmobilieGewerblich.FreizeitTyp freizeitTyp = this.getObjektartFreizeitTyp(list.get(i - 1));
                if (freizeitTyp == null) continue;
                freizeitimmobilieGewerblich.setFreizeitTyp(freizeitTyp);
                break;
            }
            objektkategorie.getObjektart().getFreizeitimmobilieGewerblich().add(freizeitimmobilieGewerblich);
        } else if (list.contains("GAST") || list.contains("GASTRONOMIE")) {
            Gastgewerbe gastgewerbe = OpenImmoUtils.getFactory().createGastgewerbe();
            for (int i = list.size(); i > 0; --i) {
                Gastgewerbe.GastgewTyp gastgewTyp = this.getObjektartGastgewTyp(list.get(i - 1));
                if (gastgewTyp == null) continue;
                gastgewerbe.setGastgewTyp(gastgewTyp);
                break;
            }
            objektkategorie.getObjektart().getGastgewerbe().add(gastgewerbe);
        } else if (list.contains("MAIN_GRUND")) {
            Grundstueck grundstueck = OpenImmoUtils.getFactory().createGrundstueck();
            for (int i = list.size(); i > 0; --i) {
                Grundstueck.GrundstTyp grundstTyp = this.getObjektartGrundstTyp(list.get(i - 1));
                if (grundstTyp == null) continue;
                grundstueck.setGrundstTyp(grundstTyp);
                break;
            }
            objektkategorie.getObjektart().getGrundstueck().add(grundstueck);
        } else if (list.contains("HALLE_LAGER") || list.contains("PRODUKTION") || list.contains("SERVICEFLAECHE")) {
            HallenLagerProd hallenLagerProd = OpenImmoUtils.getFactory().createHallenLagerProd();
            for (int i = list.size(); i > 0; --i) {
                HallenLagerProd.HallenTyp hallenTyp = this.getObjektartHallenTyp(list.get(i - 1));
                if (hallenTyp == null) continue;
                hallenLagerProd.setHallenTyp(hallenTyp);
                break;
            }
            objektkategorie.getObjektart().getHallenLagerProd().add(hallenLagerProd);
        } else if (list.contains("HAUS") || list.contains("KRANKENHAUS") || list.contains("BETREUTES_WOHNEN") || list.contains("WOHNANLAGE_FUER_SENIOREN") || list.contains("RESTHOF")) {
            Haus haus = OpenImmoUtils.getFactory().createHaus();
            for (int i = list.size(); i > 0; --i) {
                Haus.Haustyp haustyp = this.getObjektartHaustyp(list.get(i - 1));
                if (haustyp == null) continue;
                haus.setHaustyp(haustyp);
                break;
            }
            objektkategorie.getObjektart().getHaus().add(haus);
        } else if (list.contains("MAIN_WOHNEN") || list.contains("WOHNANLAGE")) {
            Wohnung wohnung = OpenImmoUtils.getFactory().createWohnung();
            for (int i = list.size(); i > 0; --i) {
                Wohnung.Wohnungtyp wohnungtyp = this.getObjektartWohnungtyp(list.get(i - 1));
                if (wohnungtyp == null) continue;
                wohnung.setWohnungtyp(wohnungtyp);
                break;
            }
            objektkategorie.getObjektart().getWohnung().add(wohnung);
        } else {
            LOGGER.debug((Object)("Can't resolve estate-type for " + string2 + ", fallback to <Sonstige>"));
            Sonstige sonstige = OpenImmoUtils.getFactory().createSonstige();
            sonstige.setSonstigeTyp(Sonstige.SonstigeTyp.SONSTIGE);
            objektkategorie.getObjektart().getSonstige().add(sonstige);
        }
    }

    protected void writeImmobiliePreise(Preise preise, EstateImpl estateImpl) {
        Object object;
        Object object2;
        preise.setAbstand(this.getEstateValueAsBigDecimal("PREISE", "ABSTAND", estateImpl));
        if (estateImpl.hasAttribute("PREISE", "COURTAGE_AUSSEN")) {
            preise.setAussenCourtage(OpenImmoUtils.getFactory().createAussenCourtage());
            preise.getAussenCourtage().setContent(this.getEstateValueAsString("PREISE", "COURTAGE_AUSSEN", estateImpl));
            preise.getAussenCourtage().setMitMwst(this.getEstateValueAsBoolean("PREISE", "COURTAGE_AUSSEN_TAX", estateImpl));
        }
        preise.setErbpacht(this.getEstateValueAsBigDecimal("PREISE", "ERBPACHT_ZINS", estateImpl));
        preise.setErschliessungskosten(this.getEstateValueAsBigDecimal("PREISE", "ERSCHLIESSUNGSKOSTEN", estateImpl));
        preise.setFreitextPreis(this.getEstateValueAsString("FREITEXTE", "PREIS_BESCHR", estateImpl));
        preise.setGeschaeftsguthaben(this.getEstateValueAsBigDecimal("PREISE", "GESCHAEFTSGUTHABEN", estateImpl));
        preise.setHausgeld(this.getEstateValueAsBigDecimal("PREISE", "HAUSGELD", estateImpl));
        preise.setHeizkosten(this.getEstateValueAsBigDecimal("PREISE", "HEIZKOSTEN", estateImpl));
        preise.setHeizkostenEnthalten(this.getEstateValueAsBoolean("PREISE", "NEBENKOSTEN_INKL_HEIZKOSTEN", estateImpl));
        if (estateImpl.hasAttribute("PREISE", "COURTAGE_INNEN")) {
            preise.setInnenCourtage(OpenImmoUtils.getFactory().createInnenCourtage());
            preise.getInnenCourtage().setContent(this.getEstateValueAsString("PREISE", "COURTAGE_INNEN", estateImpl));
            preise.getInnenCourtage().setMitMwst(this.getEstateValueAsBoolean("PREISE", "COURTAGE_INNEN_TAX", estateImpl));
        }
        preise.setKaltmiete(this.getEstateValueAsBigDecimal("PREISE", "KALTMIETE", estateImpl));
        preise.setKaufpreis(this.getEstateValueAsBigDecimal("PREISE", "KAUFPREIS", estateImpl));
        preise.setKaufpreisProQm(this.getEstateValueAsBigDecimal("PREISE", "KAUFPREIS_QM", estateImpl));
        preise.setKaution(this.getEstateValueAsBigDecimal("PREISE", "KAUTION_BETRAG", estateImpl));
        if (estateImpl.hasAttribute("PREISE", "MIETEINNAHMEN_IST")) {
            preise.setMieteinnahmenIst(OpenImmoUtils.getFactory().createMieteinnahmenIst());
            preise.getMieteinnahmenIst().setValue(this.getEstateValueAsBigDecimal("PREISE", "MIETEINNAHMEN_IST", estateImpl));
        }
        if (estateImpl.hasAttribute("PREISE", "MIETEINNAHMEN_SOLL")) {
            preise.setMieteinnahmenSoll(OpenImmoUtils.getFactory().createMieteinnahmenSoll());
            preise.getMieteinnahmenSoll().setValue(this.getEstateValueAsBigDecimal("PREISE", "MIETEINNAHMEN_SOLL", estateImpl));
        }
        preise.setMietpreisProQm(this.getEstateValueAsBigDecimal("PREISE", "KALTMIETE_QM", estateImpl));
        preise.setMietzuschlaege(this.getEstateValueAsBigDecimal("PREISE", "MIETZUSCHLAEGE", estateImpl));
        preise.setMwstSatz(this.getEstateValueAsBigDecimal("PREISE", "MWST", estateImpl));
        preise.setNebenkosten(this.getEstateValueAsBigDecimal("PREISE", "NEBENKOSTEN", estateImpl));
        preise.setNettokaltmiete(this.getEstateValueAsBigDecimal("PREISE", "KALTMIETE_NETTO", estateImpl));
        preise.setNettorendite(this.getEstateValueAsBigDecimal("PREISE", "NETTORENDITE", estateImpl));
        preise.setPacht(this.getEstateValueAsBigDecimal("PREISE", "PACHT", estateImpl));
        if (estateImpl.hasAttribute("PREISE", "MIETE_PRO")) {
            object2 = this.getEstateValueAsString("PREISE", "MIETE_PRO", estateImpl);
            if (PreisZeiteinheit.Zeiteinheit.JAHR.value().equalsIgnoreCase((String)object2)) {
                preise.setPreisZeiteinheit(OpenImmoUtils.getFactory().createPreisZeiteinheit());
                preise.getPreisZeiteinheit().setZeiteinheit(PreisZeiteinheit.Zeiteinheit.JAHR);
            } else if (PreisZeiteinheit.Zeiteinheit.MONAT.value().equalsIgnoreCase((String)object2)) {
                preise.setPreisZeiteinheit(OpenImmoUtils.getFactory().createPreisZeiteinheit());
                preise.getPreisZeiteinheit().setZeiteinheit(PreisZeiteinheit.Zeiteinheit.MONAT);
            } else if (PreisZeiteinheit.Zeiteinheit.TAG.value().equalsIgnoreCase((String)object2)) {
                preise.setPreisZeiteinheit(OpenImmoUtils.getFactory().createPreisZeiteinheit());
                preise.getPreisZeiteinheit().setZeiteinheit(PreisZeiteinheit.Zeiteinheit.TAG);
            } else if (PreisZeiteinheit.Zeiteinheit.WOCHE.value().equalsIgnoreCase((String)object2)) {
                preise.setPreisZeiteinheit(OpenImmoUtils.getFactory().createPreisZeiteinheit());
                preise.getPreisZeiteinheit().setZeiteinheit(PreisZeiteinheit.Zeiteinheit.WOCHE);
            }
        }
        preise.setPreisZeitraumBis(this.getEstateValueAsCalendar("VERWALTUNG", "PREIS_ZEITRAUM_BIS", estateImpl));
        preise.setPreisZeitraumVon(this.getEstateValueAsCalendar("VERWALTUNG", "PREIS_ZEITRAUM_VON", estateImpl));
        for (String object3 : this.getEstateValueAsList("FLAECHEN", "STELLPLATZART", estateImpl)) {
            object = OpenImmoUtils.getFactory().createStellplatz();
            ((Stellplatz)object).setStellplatzkaufpreis(this.getEstateValueAsBigDecimal("PREISE", "STELLPLATZ_PREIS", estateImpl));
            ((Stellplatz)object).setStellplatzmiete(this.getEstateValueAsBigDecimal("PREISE", "STELLPLATZ_MIETE", estateImpl));
            if ("AUSSEN".equals(object3)) {
                preise.setStpFreiplatz((Stellplatz)object);
                continue;
            }
            if ("CARPORT".equals(object3)) {
                preise.setStpCarport((Stellplatz)object);
                continue;
            }
            if ("DOPPELGARAGE".equals(object3)) {
                preise.setStpGarage((Stellplatz)object);
                continue;
            }
            if ("DUPLEX".equals(object3)) {
                preise.setStpDuplex((Stellplatz)object);
                continue;
            }
            if ("GARAGE".equals(object3)) {
                preise.setStpGarage((Stellplatz)object);
                continue;
            }
            if ("PARKHAUS".equals(object3)) {
                preise.setStpParkhaus((Stellplatz)object);
                continue;
            }
            if ("STELLPLATZ".equals(object3)) {
                preise.setStpFreiplatz((Stellplatz)object);
                continue;
            }
            if ("STELLPLATZ_GEMEINSCHAFT".equals(object3)) {
                preise.setStpFreiplatz((Stellplatz)object);
                continue;
            }
            if (!"TIEFGARAGE".equals(object3)) continue;
            preise.setStpTiefgarage((Stellplatz)object);
        }
        if (estateImpl.getCurrency() != null) {
            preise.setWaehrung(OpenImmoUtils.getFactory().createWaehrung());
            preise.getWaehrung().setIsoWaehrung(estateImpl.getCurrency().getCurrencyCode());
        }
        if ("WAZ".equals(estateImpl.getAction())) {
            preise.setWarmmiete(this.getEstateValueAsBigDecimal("PREISE", "PAUSCHALMIETE", estateImpl));
        } else {
            preise.setWarmmiete(this.getEstateValueAsBigDecimal("PREISE", "WARMMIETE", estateImpl));
        }
        preise.setXFache(this.getEstateValueAsString("PREISE", "X_FACHE", estateImpl));
        preise.setZzgMehrwertsteuer(this.getEstateValueAsBoolean("PREISE", "ZZG_MEHRWERTSTEUER", estateImpl));
        if ("1.2.1/AT1.0".equalsIgnoreCase(this.getVersion())) {
            object2 = OpenImmoUtils.getFactory().createUserDefinedAnyfield();
            BigDecimal bigDecimal = this.getEstateValueAsBigDecimal("PREISE", "MWST_BETRAG", estateImpl);
            if (bigDecimal != null) {
                ((UserDefinedAnyfield)object2).getContent().add(new JAXBElement(new QName("mwst_gesamt"), BigDecimal.class, (Object)bigDecimal));
                if (preise.getWarmmiete() != null && preise.getKaltmiete() != null && preise.getNebenkosten() != null && preise.getHeizkosten() != null) {
                    object = preise.getWarmmiete().subtract(preise.getKaltmiete()).subtract(preise.getNebenkosten()).subtract(preise.getHeizkosten()).subtract(bigDecimal);
                    ((UserDefinedAnyfield)object2).getContent().add(new JAXBElement(new QName("sonstige_kosten"), BigDecimal.class, object));
                }
            }
            if (!((UserDefinedAnyfield)object2).getContent().isEmpty()) {
                preise.getUserDefinedAnyfield().add((UserDefinedAnyfield)object2);
            }
        }
    }

    protected void writeImmobilieVerwaltungObjekt(VerwaltungObjekt verwaltungObjekt, EstateImpl estateImpl) {
        String string;
        String string2;
        String string3;
        verwaltungObjekt.setAbdatum(this.getEstateValueAsCalendar("VERWALTUNG", "VERFUEGBAR_ABDATE", estateImpl));
        verwaltungObjekt.setAlsFerien(this.getEstateValueAsBoolean("VERWALTUNG", "ALS_FERIEN", estateImpl));
        verwaltungObjekt.setBisdatum(this.getEstateValueAsCalendar("VERWALTUNG", "VERFUEGBAR_BISDATE", estateImpl));
        verwaltungObjekt.setBranchen(this.getEstateValueAsString("VERWALTUNG", "BRANCHEN", estateImpl));
        verwaltungObjekt.setDenkmalgeschuetzt(this.getEstateValueAsBoolean("VERWALTUNG", "DENKMALGESCHUETZT", estateImpl));
        verwaltungObjekt.setHochhaus(this.getEstateValueAsBoolean("VERWALTUNG", "HOCHHAUS", estateImpl));
        verwaltungObjekt.setLaufzeit(this.getEstateValueAsBigDecimal("VERWALTUNG", "ERBPACHT_DAUER", estateImpl));
        verwaltungObjekt.setMaxPersonen(this.getEstateValueAsBigInteger("VERWALTUNG", "MAX_PERSONEN", estateImpl));
        verwaltungObjekt.setObjektadresseFreigeben(estateImpl.getAdress().isAdressPublished());
        verwaltungObjekt.setVerfuegbarAb(this.getEstateValueAsString("VERWALTUNG", "VERFUEGBAR_ABTEXT", estateImpl));
        verwaltungObjekt.setVermietet(this.getEstateValueAsBoolean("VERWALTUNG", "VERMIETET", estateImpl));
        verwaltungObjekt.setVersteigerungstermin(this.getEstateValueAsCalendar("VERWALTUNG", "VERSTEIGERUNGSTERMIN", estateImpl));
        verwaltungObjekt.setWbsSozialwohnung(this.getEstateValueAsBoolean("VERWALTUNG", "WBS_SOZIALWOHNUNG", estateImpl));
        verwaltungObjekt.setZugang(this.getEstateValueAsString("VERWALTUNG", "ZUGANG_AB", estateImpl));
        String string4 = (String)this.getEstateValue("VERWALTUNG", "GESCHLECHT", estateImpl);
        if (string4 != null) {
            verwaltungObjekt.setGeschlecht(OpenImmoUtils.getFactory().createGeschlecht());
            if ("EGAL".equals(string4)) {
                verwaltungObjekt.getGeschlecht().setGeschlAttr(Geschlecht.GeschlAttr.EGAL);
            } else if ("FRAU".equals(string4)) {
                verwaltungObjekt.getGeschlecht().setGeschlAttr(Geschlecht.GeschlAttr.NUR_FRAU);
            } else if ("MANN".equals(string4)) {
                verwaltungObjekt.getGeschlecht().setGeschlAttr(Geschlecht.GeschlAttr.NUR_MANN);
            }
        }
        if ((string3 = (String)this.getEstateValue("VERWALTUNG", "GEWERBLICHE_NUTZUNG", estateImpl)) != null) {
            verwaltungObjekt.setGewerblicheNutzung("JA".equals(string3) || "TEIL".equals(string3));
        }
        if ("JA".equals(string2 = this.getEstateValueAsString("VERWALTUNG", "HAUSTIERE", estateImpl))) {
            verwaltungObjekt.setHaustiere(true);
        } else if ("NEIN".equals(string2)) {
            verwaltungObjekt.setHaustiere(false);
        }
        if (estateImpl.hasAttribute("VERWALTUNG", "MAX_MIETDAUER")) {
            verwaltungObjekt.setMaxMietdauer(OpenImmoUtils.getFactory().createMaxMietdauer());
            verwaltungObjekt.getMaxMietdauer().setContent(this.getEstateValueAsString("VERWALTUNG", "MAX_MIETDAUER", estateImpl));
        }
        if (estateImpl.hasAttribute("VERWALTUNG", "MIN_MIETDAUER")) {
            verwaltungObjekt.setMinMietdauer(OpenImmoUtils.getFactory().createMinMietdauer());
            verwaltungObjekt.getMinMietdauer().setContent(this.getEstateValueAsString("VERWALTUNG", "MIN_MIETDAUER", estateImpl));
        }
        if ("JA".equals(string = (String)this.getEstateValue("VERWALTUNG", "NICHTRAUCHER", estateImpl))) {
            verwaltungObjekt.setNichtraucher(Boolean.TRUE);
        } else if ("NEIN".equals(string)) {
            verwaltungObjekt.setNichtraucher(Boolean.FALSE);
        }
    }

    protected void writeImmobilieVerwaltungTechn(VerwaltungTechn verwaltungTechn, EstateImpl estateImpl) {
        Object object;
        verwaltungTechn.setAktion(OpenImmoUtils.getFactory().createAktion());
        verwaltungTechn.getAktion().setAktionart(Aktion.AktionArt.CHANGE);
        if (estateImpl.getPublishEnd() != null) {
            object = Calendar.getInstance();
            ((Calendar)object).setTime(estateImpl.getPublishEnd());
            verwaltungTechn.setAktivBis((Calendar)object);
        }
        if (estateImpl.getPublishBegin() != null) {
            object = Calendar.getInstance();
            ((Calendar)object).setTime(estateImpl.getPublishBegin());
            verwaltungTechn.setAktivVon((Calendar)object);
        }
        object = StringUtils.trimToNull((String)estateImpl.getId());
        String string = StringUtils.trimToNull((String)estateImpl.getPublicId());
        verwaltungTechn.setObjektnrExtern((String)(string != null ? string : object));
        verwaltungTechn.setObjektnrIntern((String)object);
        verwaltungTechn.setOpenimmoObid((String)object);
        verwaltungTechn.setStandVom(this.getEstateValueAsCalendar("VERWALTUNG", "STAND_VOM", estateImpl));
        verwaltungTechn.setWeitergabeGenerell(this.getEstateValueAsBoolean("VERWALTUNG", "WEITERGABE_GENERELL", estateImpl));
        verwaltungTechn.setWeitergabeNegativ(this.getEstateValueAsString("VERWALTUNG", "WEITERGABE_NEGATIV", estateImpl));
        verwaltungTechn.setWeitergabePositiv(this.getEstateValueAsString("VERWALTUNG", "WEITERGABE_POSITIV", estateImpl));
        if (verwaltungTechn.getStandVom() == null) {
            verwaltungTechn.setStandVom(Calendar.getInstance());
        }
    }

    protected void writeImmobilieWeitereAdresse(Immobilie immobilie, EstateImpl estateImpl) {
        throw new UnsupportedOperationException("not implemented yet!");
    }

    protected void writeImmobilieZustandAngaben(ZustandAngaben zustandAngaben, EstateImpl estateImpl) {
        Object object;
        Object object2;
        Object object3;
        Double d;
        Object object4;
        Object object5;
        String string;
        String string2;
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMaximumFractionDigits(2);
        zustandAngaben.setAltlasten(this.getEstateValueAsString("ZUSTAND", "ALTLASTEN", estateImpl));
        zustandAngaben.setBaujahr(this.getEstateValueAsString("ZUSTAND", "BAUJAHR", estateImpl));
        String string3 = (String)this.getEstateValue("ZUSTAND", "ALTER", estateImpl);
        if (string3 != null) {
            zustandAngaben.setAlter(OpenImmoUtils.getFactory().createAlter());
            if ("ALTBAU".equals(string3)) {
                zustandAngaben.getAlter().setAlterAttr(Alter.AlterAttr.ALTBAU);
            } else if ("NEUBAU".equals(string3)) {
                zustandAngaben.getAlter().setAlterAttr(Alter.AlterAttr.NEUBAU);
            }
        }
        if ((string2 = (String)this.getEstateValue("VERWALTUNG", "BEBAUBAR_NACH", estateImpl)) != null) {
            zustandAngaben.setBebaubarNach(OpenImmoUtils.getFactory().createBebaubarNach());
            if ("AUSSENGEBIET".equals(string2)) {
                zustandAngaben.getBebaubarNach().setBebaubarAttr(BebaubarNach.BebaubarAttr.AUSSENGEBIET);
            } else if ("BAUERWARTUNGSLAND".equals(string2)) {
                zustandAngaben.getBebaubarNach().setBebaubarAttr(BebaubarNach.BebaubarAttr.BAUERWARTUNGSLAND);
            } else if ("BEBAUUNGSPLAN".equals(string2)) {
                zustandAngaben.getBebaubarNach().setBebaubarAttr(BebaubarNach.BebaubarAttr.B_PLAN);
            } else if ("KEIN_BAULAND".equals(string2)) {
                zustandAngaben.getBebaubarNach().setBebaubarAttr(BebaubarNach.BebaubarAttr.KEIN_BAULAND);
            } else if ("NACHBARBEBAUUNG".equals(string2)) {
                zustandAngaben.getBebaubarNach().setBebaubarAttr(BebaubarNach.BebaubarAttr.NACHBARSCHAFT);
            }
        }
        if ((string = this.getEstateValueAsString("ENERGIEPASS", "ART", estateImpl)) != null) {
            if ("BEDARF".equals(string)) {
                zustandAngaben.setEnergiepass(OpenImmoUtils.getFactory().createEnergiepass());
                zustandAngaben.getEnergiepass().setArt(Energiepass.Art.BEDARF);
                object5 = this.getEstateValueAsDouble("ENERGIEPASS", "BEDARF_GESAMT", estateImpl);
                if (object5 != null && (Double)object5 > 0.0) {
                    zustandAngaben.getEnergiepass().setEndenergiebedarf(numberFormat.format(object5));
                }
            } else if ("VERBRAUCH".equals(string)) {
                zustandAngaben.setEnergiepass(OpenImmoUtils.getFactory().createEnergiepass());
                zustandAngaben.getEnergiepass().setArt(Energiepass.Art.VERBRAUCH);
                zustandAngaben.getEnergiepass().setMitwarmwasser(this.getEstateValueAsBoolean("ENERGIEPASS", "VERBRAUCH_INKL_WARMWASSER", estateImpl));
                object5 = this.getEstateValueAsDouble("ENERGIEPASS", "VERBRAUCH_GESAMT", estateImpl);
                if (object5 != null && (Double)object5 > 0.0) {
                    zustandAngaben.getEnergiepass().setEnergieverbrauchkennwert(numberFormat.format(object5));
                }
            }
        } else {
            object5 = this.getEstateValueAsDouble("ENERGIEPASS", "VERBRAUCH_GESAMT", estateImpl);
            object4 = this.getEstateValueAsBoolean("ENERGIEPASS", "VORHANDEN", estateImpl);
            if (Boolean.TRUE.equals(object4) && object5 != null && (Double)object5 > 0.0) {
                zustandAngaben.setEnergiepass(OpenImmoUtils.getFactory().createEnergiepass());
                zustandAngaben.getEnergiepass().setArt(Energiepass.Art.VERBRAUCH);
                zustandAngaben.getEnergiepass().setEnergieverbrauchkennwert(numberFormat.format(object5));
                zustandAngaben.getEnergiepass().setGueltigBis("");
            }
        }
        if (zustandAngaben.getEnergiepass() != null) {
            object5 = new SimpleDateFormat("MM-yyyy");
            object4 = null;
            try {
                object4 = this.getEstateValueAsDate("ENERGIEPASS", "ABLAUF_DATUM", estateImpl);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"Ablaufdatum des Energiepasses konnte nicht ermittelt werden!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                object4 = null;
            }
            zustandAngaben.getEnergiepass().setGueltigBis(object4 != null ? ((DateFormat)object5).format((Date)object4) : "");
        }
        if ((object5 = (String)this.getEstateValue("ZUSTAND", "ERSCHLIESSUNG", estateImpl)) != null) {
            zustandAngaben.setErschliessung(OpenImmoUtils.getFactory().createErschliessung());
            if ("TEILERSCHLOSSEN".equals(object5)) {
                zustandAngaben.getErschliessung().setErschlAttr(Erschliessung.ErschlAttr.TEILERSCHLOSSEN);
            } else if ("UNERSCHLOSSEN".equals(object5)) {
                zustandAngaben.getErschliessung().setErschlAttr(Erschliessung.ErschlAttr.UNERSCHLOSSEN);
            } else if ("VOLLERSCHLOSSEN".equals(object5)) {
                zustandAngaben.getErschliessung().setErschlAttr(Erschliessung.ErschlAttr.VOLLERSCHLOSSEN);
            }
        }
        if ((object4 = (String)this.getEstateValue("ZUSTAND", "ZUSTAND", estateImpl)) != null) {
            zustandAngaben.setZustand(OpenImmoUtils.getFactory().createZustand());
            if ("ABRISSOBJEKT".equals(object4)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.ABRISSOBJEKT);
            } else if ("AUSGEZEICHNET".equals(object4)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.GEPFLEGT);
            } else if ("BAUFAELLIG".equals(object4)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.BAUFAELLIG);
            } else if ("ENTKERNT".equals(object4)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.ENTKERNT);
            } else if ("ERSTBEZUG".equals(object4)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.ERSTBEZUG);
            } else if ("ERSTBEZUG_NACH_SANIERUNG".equals(object4)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.ERSTBEZUG);
            } else if ("GEPFLEGT".equals(object4)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.GEPFLEGT);
            } else if ("GUT".equals(object4)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.GEPFLEGT);
            } else if ("MODERNISIERT".equals(object4)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.MODERNISIERT);
            } else if ("NACH_VEREINBARUNG".equals(object4)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.NACH_VEREINBARUNG);
            } else if ("NEUWERTIG".equals(object4)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.NEUWERTIG);
            } else if ("PROJEKTIERT".equals(object4)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.PROJEKTIERT);
            } else if ("RENOVIERT_TEIL".equals(object4)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.TEIL_VOLLRENOVIERT);
            } else if ("RENOVIERT_VOLL".equals(object4)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.TEIL_VOLLRENOVIERT);
            } else if ("RENOVIERUNGSBEDARF_TEIL".equals(object4)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.TEIL_VOLLRENOVIERUNGSBED);
            } else if ("RENOVIERUNGSBEDARF_VOLL".equals(object4)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.TEIL_VOLLRENOVIERUNGSBED);
            } else if ("ROHBAU".equals(object4)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.ROHBAU);
            } else if ("SANIERT_TEIL".equals(object4)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.TEIL_VOLLSANIERT);
            } else if ("SANIERT_VOLL".equals(object4)) {
                zustandAngaben.getZustand().setZustandArt(Zustand.ZustandArt.TEIL_VOLLSANIERT);
            }
        }
        if (zustandAngaben.getEnergiepass() != null) {
            UserDefinedSimplefield userDefinedSimplefield;
            Object object6;
            Object object7;
            d = null;
            object3 = null;
            object2 = null;
            if ("BEDARF".equals(string)) {
                d = this.getEstateValueAsDouble("ENERGIEPASS", "BEDARF_GESAMT", estateImpl);
                object3 = this.getEstateValueAsDouble("ENERGIEPASS", "BEDARF_HEIZUNG", estateImpl);
                object2 = this.getEstateValueAsDouble("ENERGIEPASS", "BEDARF_STROM", estateImpl);
            } else if ("VERBRAUCH".equals(string)) {
                d = this.getEstateValueAsDouble("ENERGIEPASS", "VERBRAUCH_GESAMT", estateImpl);
                object3 = this.getEstateValueAsDouble("ENERGIEPASS", "VERBRAUCH_HEIZUNG", estateImpl);
                object2 = this.getEstateValueAsDouble("ENERGIEPASS", "VERBRAUCH_STROM", estateImpl);
            }
            if (object3 != null && (Double)object3 > 0.0) {
                object = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
                ((UserDefinedSimplefield)object).setFeldname("epass_waermewert");
                ((UserDefinedSimplefield)object).setContent(numberFormat.format(object3));
                zustandAngaben.getUserDefinedSimplefield().add((UserDefinedSimplefield)object);
            }
            if (object2 != null && (Double)object2 > 0.0) {
                object = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
                ((UserDefinedSimplefield)object).setFeldname("epass_stromwert");
                ((UserDefinedSimplefield)object).setContent(numberFormat.format(object2));
                zustandAngaben.getUserDefinedSimplefield().add((UserDefinedSimplefield)object);
            }
            if (StringUtils.isBlank((String)(object = this.getEstateValueAsString("ENERGIEPASS", "KLASSE", estateImpl))) && estateImpl.getAdress() != null && d != null) {
                object = OpenEstateUtils.getEnergyCertificateClass(d, estateImpl.getAdress().getCountry());
            }
            if (!StringUtils.isBlank((String)object)) {
                object7 = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
                ((UserDefinedSimplefield)object7).setFeldname("epass_wertklasse");
                ((UserDefinedSimplefield)object7).setContent(((String)object).trim());
                zustandAngaben.getUserDefinedSimplefield().add((UserDefinedSimplefield)object7);
            }
            if (!StringUtils.isBlank((String)(object7 = this.getEstateValueAsString("ZUSTAND", "BAUJAHR", estateImpl)))) {
                object6 = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
                ((UserDefinedSimplefield)object6).setFeldname("epass_baujahr");
                ((UserDefinedSimplefield)object6).setContent(((String)object7).trim());
                zustandAngaben.getUserDefinedSimplefield().add((UserDefinedSimplefield)object6);
            }
            object6 = null;
            try {
                object6 = this.getEstateValueAsDate("ENERGIEPASS", "ERSTELLUNG_DATUM", estateImpl);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"Erstellungsdatum des Energiepasses konnte nicht ermittelt werden!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                object6 = null;
            }
            if (object6 != null) {
                userDefinedSimplefield = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
                userDefinedSimplefield.setFeldname("epass_ausstelldatum");
                userDefinedSimplefield.setContent(OpenEstateUtils.getXsdDateFormat().format((Date)object6));
                zustandAngaben.getUserDefinedSimplefield().add(userDefinedSimplefield);
            }
            if (object6 != null) {
                userDefinedSimplefield = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
                userDefinedSimplefield.setFeldname("epass_jahrgang");
                userDefinedSimplefield.setContent(new SimpleDateFormat("yyyy").format((Date)object6));
                zustandAngaben.getUserDefinedSimplefield().add(userDefinedSimplefield);
            }
        }
        if ((d = this.getEstateValueAsDouble("ENERGIEPASS", "AUSTRIA_HWB", estateImpl)) != null && d > 0.0) {
            object3 = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
            ((UserDefinedSimplefield)object3).setFeldname("epass_hwbwert");
            ((UserDefinedSimplefield)object3).setContent(numberFormat.format(d));
            zustandAngaben.getUserDefinedSimplefield().add((UserDefinedSimplefield)object3);
            object2 = d <= 10.0 ? "A++" : (d <= 15.0 ? "A+" : (d <= 25.0 ? "A" : (d <= 50.0 ? "B" : (d <= 100.0 ? "C" : (d <= 150.0 ? "D" : (d <= 200.0 ? "E" : (d <= 250.0 ? "F" : "G")))))));
            object3 = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
            ((UserDefinedSimplefield)object3).setFeldname("epass_hwbklasse");
            ((UserDefinedSimplefield)object3).setContent((String)object2);
            zustandAngaben.getUserDefinedSimplefield().add((UserDefinedSimplefield)object3);
        }
        if ((object3 = this.getEstateValueAsDouble("ENERGIEPASS", "AUSTRIA_FGEE", estateImpl)) != null && (Double)object3 > 0.0) {
            object2 = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
            ((UserDefinedSimplefield)object2).setFeldname("epass_fgeewert");
            ((UserDefinedSimplefield)object2).setContent(numberFormat.format(object3));
            zustandAngaben.getUserDefinedSimplefield().add((UserDefinedSimplefield)object2);
            object = (Double)object3 <= 0.55 ? "A++" : ((Double)object3 <= 0.7 ? "A+" : ((Double)object3 <= 0.85 ? "A" : ((Double)object3 <= 1.0 ? "B" : ((Double)object3 <= 1.75 ? "C" : ((Double)object3 <= 2.5 ? "D" : ((Double)object3 <= 3.25 ? "E" : ((Double)object3 <= 4.0 ? "F" : "G")))))));
            object2 = OpenImmoUtils.getFactory().createUserDefinedSimplefield();
            ((UserDefinedSimplefield)object2).setFeldname("epass_fgeeklasse");
            ((UserDefinedSimplefield)object2).setContent((String)object);
            zustandAngaben.getUserDefinedSimplefield().add((UserDefinedSimplefield)object2);
        }
    }
}

