/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.xml;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateConverter;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.xml.TrovitUtils;
import com.openindex.openestate.impl.xml.trovit.Ad;
import com.openindex.openestate.impl.xml.trovit.Picture;
import com.openindex.openestate.impl.xml.trovit.Trovit;
import com.openindex.openestate.impl.xml.trovit.TypeNew;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TrovitWriter
extends OpenEstateConverter {
    private static final Logger LOGGER = Logger.getLogger(TrovitWriter.class);
    private Date now = new Date();
    private String baseUrl = null;
    private boolean energyCertificateAppendedToDescription = false;

    public TrovitWriter() {
    }

    public TrovitWriter(Locale locale) {
        this();
        this.setOpenEstateLanguage(locale);
    }

    protected Ad convertEstate(EstateImpl estateImpl, AgentImpl agentImpl, List<String> list) {
        Serializable serializable;
        Long[] longArray;
        String string;
        Ad ad = TrovitUtils.getFactory().createAd();
        ad.setAddress(estateImpl.getAdress().writeStreet());
        if (agentImpl != null) {
            ad.setAgency(agentImpl.getCompany().getCompanyName());
        }
        ad.setBathrooms(this.getEstateValueAsString("FLAECHEN", "ANZ_BADEZIMMER", estateImpl));
        ad.setCity(estateImpl.getAdress().getCity());
        ad.setCityArea(estateImpl.getAdress().getCityPart());
        ad.setDate(estateImpl.getPublishBegin() != null ? TrovitUtils.getDateFormat().format(estateImpl.getPublishBegin()) : TrovitUtils.getDateFormat().format(this.now));
        ad.setExpirationDate(estateImpl.getPublishEnd() != null ? TrovitUtils.getDateFormat().format(estateImpl.getPublishEnd()) : null);
        ad.setFloorNumber(this.getEstateValueAsString("AUSSTATTUNG", "ETAGE", estateImpl));
        ad.setId(estateImpl.getId());
        ad.setLatitude(estateImpl.getAdress().getLatitude() != null ? estateImpl.getAdress().getLatitude().toString() : "");
        ad.setLongitude(estateImpl.getAdress().getLongitude() != null ? estateImpl.getAdress().getLongitude().toString() : "");
        ad.setPostcode(estateImpl.getAdress().getPostalCode());
        ad.setPropertyType(OpenEstateUtils.translateEstate(estateImpl.getType().getName()));
        ad.setRegion(estateImpl.getAdress().getRegion());
        ad.setRooms(this.getEstateValueAsString("FLAECHEN", "ANZ_SCHLAFZIMMER", estateImpl));
        ad.setTime(TrovitUtils.getTimeFormat().format(estateImpl.getPublishBegin() != null ? estateImpl.getPublishBegin() : this.now));
        ad.setTitle(estateImpl.getTitle());
        Long l = this.getEstateValueAsLong("ZUSTAND", "BAUJAHR", estateImpl);
        if (l != null && l > 999L && l < 10000L) {
            ad.setYear(l.toString());
        }
        if (!StringUtils.isBlank((String)(string = this.getEstateValueAsString("ZUSTAND", "ZUSTAND", estateImpl)))) {
            ad.setCondition(OpenEstateUtils.translateAttribute("ZUSTAND", "ZUSTAND", string.trim(), this.getOpenEstateLanguage()));
        }
        String string2 = "";
        String string3 = StringUtils.trimToNull((String)estateImpl.getTitle(this.getOpenEstateLanguage()));
        if (string3 != null) {
            string2 = string2 + string3 + "<hr/>";
        }
        string2 = string2 + OpenEstateUtils.translateEstate(estateImpl.getType().getName());
        string2 = string2 + " / " + OpenEstateUtils.translateAction(estateImpl.getAction(), this.getOpenEstateLanguage());
        string2 = string2 + "<hr/>" + estateImpl.getAdress().writeFullAdress(", ", this.getOpenEstateLanguage());
        String string4 = StringUtils.trimToNull((String)this.getEstateValueAsString("FREITEXTE", "OBJEKT_BESCHR", estateImpl));
        if (string4 != null) {
            string2 = string2 + "<hr/><b>" + OpenEstateUtils.translateAttribute("FREITEXTE", "OBJEKT_BESCHR", this.getOpenEstateLanguage()) + "</b>";
            string2 = string2 + "<br/>" + string4;
        }
        if ((string4 = StringUtils.trimToNull((String)this.getEstateValueAsString("FREITEXTE", "AUSSTATT_BESCHR", estateImpl))) != null) {
            string2 = string2 + "<hr/><b>" + OpenEstateUtils.translateAttribute("FREITEXTE", "AUSSTATT_BESCHR", this.getOpenEstateLanguage()) + "</b>";
            string2 = string2 + "<br/>" + string4;
        }
        if ((string4 = StringUtils.trimToNull((String)this.getEstateValueAsString("FREITEXTE", "LAGE_BESCHR", estateImpl))) != null) {
            string2 = string2 + "<hr/><b>" + OpenEstateUtils.translateAttribute("FREITEXTE", "LAGE_BESCHR", this.getOpenEstateLanguage()) + "</b>";
            string2 = string2 + "<br/>" + string4;
        }
        if ((string4 = StringUtils.trimToNull((String)this.getEstateValueAsString("FREITEXTE", "PREIS_BESCHR", estateImpl))) != null) {
            string2 = string2 + "<hr/><b>" + OpenEstateUtils.translateAttribute("FREITEXTE", "PREIS_BESCHR", this.getOpenEstateLanguage()) + "</b>";
            string2 = string2 + "<br/>" + string4;
        }
        if ((string4 = StringUtils.trimToNull((String)this.getEstateValueAsString("FREITEXTE", "PROVISION_BESCHR", estateImpl))) != null) {
            string2 = string2 + "<hr/><b>" + OpenEstateUtils.translateAttribute("FREITEXTE", "PROVISION_BESCHR", this.getOpenEstateLanguage()) + "</b>";
            string2 = string2 + "<br/>" + string4;
        }
        if (this.isEnergyCertificateAppendedToDescription() && !StringUtils.isBlank((String)(longArray = OpenEstateUtils.writeEstateEnergyCertificate(estateImpl, this.getOpenEstateLanguage(), "<br/>")))) {
            string2 = string2 + "<hr/>" + (String)longArray;
        }
        ad.setContent(string2);
        longArray = new Long[]{this.getEstateValueAsLong("FLAECHEN", "GESAMTFLAECHE", estateImpl), this.getEstateValueAsLong("FLAECHEN", "WOHNFLAECHE", estateImpl), this.getEstateValueAsLong("FLAECHEN", "GEWERBEFLAECHE", estateImpl), this.getEstateValueAsLong("FLAECHEN", "GRUNDSTUECKSFLAECHE", estateImpl)};
        Object object = longArray;
        int n = ((Long[])object).length;
        for (int i = 0; i < n; ++i) {
            serializable = object[i];
            if (serializable == null || (Long)serializable <= 0L) continue;
            ad.setFloorArea(TrovitUtils.getFactory().createFloorArea());
            ad.getFloorArea().setUnit("meters");
            ad.getFloorArea().setValue(((Long)serializable).toString());
            break;
        }
        if (estateImpl.isHiddenPrices()) {
            ad.setPrice(TrovitUtils.getFactory().createPrice());
            ad.getPrice().setValue("0");
        } else if ("ERBPACHT".equals(estateImpl.getAction()) || "PACHT".equals(estateImpl.getAction())) {
            object = this.getEstateValueAsLong("PREISE", "PACHT", estateImpl);
            if (object != null && (Long)object > 0L) {
                ad.setPrice(TrovitUtils.getFactory().createPrice());
                ad.getPrice().setValue(((Long)object).toString());
            }
        } else if ("KAUF".equals(estateImpl.getAction()) || "VERSTEIGERUNG".equals(estateImpl.getAction())) {
            object = this.getEstateValueAsLong("PREISE", "KAUFPREIS", estateImpl);
            if (object != null && (Long)object > 0L) {
                ad.setPrice(TrovitUtils.getFactory().createPrice());
                ad.getPrice().setValue(((Long)object).toString());
            }
        } else if ("MIETE".equals(estateImpl.getAction())) {
            object = this.getEstateValueAsLong("PREISE", "KALTMIETE", estateImpl);
            if (object == null || (Long)object <= 0L) {
                object = this.getEstateValueAsLong("PREISE", "WARMMIETE", estateImpl);
            }
            if (object != null && (Long)object > 0L) {
                ad.setPrice(TrovitUtils.getFactory().createPrice());
                ad.getPrice().setValue(((Long)object).toString());
            }
        } else if ("WAZ".equals(estateImpl.getAction()) && (object = this.getEstateValueAsLong("PREISE", "PAUSCHALMIETE", estateImpl)) != null && (Long)object > 0L) {
            ad.setPrice(TrovitUtils.getFactory().createPrice());
            ad.getPrice().setValue(((Long)object).toString());
            if (Boolean.TRUE.equals(this.hasEstateValue("PREISE", "MIETE_PRO", "MONAT", estateImpl))) {
                ad.getPrice().setPeriod("monthly");
            } else if (Boolean.TRUE.equals(this.hasEstateValue("PREISE", "MIETE_PRO", "WOCHE", estateImpl))) {
                ad.getPrice().setPeriod("weekly");
            }
        }
        if (Boolean.TRUE.equals(this.hasEstateValue("ZUSTAND", "ALTER", "NEUBAU", estateImpl))) {
            ad.setIsNew(TypeNew.NEW);
        } else if (Boolean.TRUE.equals(this.hasEstateValue("ZUSTAND", "ALTER", "ALTBAU", estateImpl))) {
            ad.setIsNew(TypeNew.NOT_NEW);
        }
        if (Boolean.TRUE.equals(this.hasEstateValue("AUSSTATTUNG", "BALKON_TERRASSE_AUSRICHTUNG", "E", estateImpl))) {
            ad.setOrientation("east");
        } else if (Boolean.TRUE.equals(this.hasEstateValue("AUSSTATTUNG", "BALKON_TERRASSE_AUSRICHTUNG", "N", estateImpl))) {
            ad.setOrientation("north");
        } else if (Boolean.TRUE.equals(this.hasEstateValue("AUSSTATTUNG", "BALKON_TERRASSE_AUSRICHTUNG", "S", estateImpl))) {
            ad.setOrientation("south");
        } else if (Boolean.TRUE.equals(this.hasEstateValue("AUSSTATTUNG", "BALKON_TERRASSE_AUSRICHTUNG", "W", estateImpl))) {
            ad.setOrientation("west");
        }
        if ("KAUF".equals(estateImpl.getAction())) {
            ad.setType("FOR SALE");
        } else if ("MIETE".equals(estateImpl.getAction()) || "WAZ".equals(estateImpl.getAction())) {
            ad.setType("FOR RENT");
        } else {
            list.add("Vermarktungsart wird nicht unterst\u00fctzt '" + estateImpl.getAction() + "'!");
            return null;
        }
        object = StringUtils.trimToNull((String)this.getBaseUrl());
        if (object != null) {
            if (!((String)object).endsWith("/")) {
                object = (String)object + "/";
            }
            for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getAttachments()) {
                block48: {
                    if (!estateAttachmentImpl.isName() && !estateAttachmentImpl.isUrl() || !estateAttachmentImpl.getMimeType().startsWith("image/")) continue;
                    serializable = null;
                    try {
                        if (estateAttachmentImpl.isName()) {
                            serializable = new URL((String)object + estateAttachmentImpl.getFileAsName());
                            break block48;
                        }
                        if (!estateAttachmentImpl.isUrl()) break block48;
                        serializable = estateAttachmentImpl.getFileAsUrl();
                    }
                    catch (Exception exception) {
                        LOGGER.warn((Object)"Can't set attachment-url!");
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                        continue;
                    }
                }
                if (serializable == null) continue;
                if (ad.getPictures() == null) {
                    ad.setPictures(TrovitUtils.getFactory().createPictures());
                }
                Picture picture = TrovitUtils.getFactory().createPicture();
                picture.setPictureTitle(estateAttachmentImpl.getTitle(this.getOpenEstateLanguage()));
                picture.setPictureUrl(((URL)serializable).toString());
                ad.getPictures().getPicture().add(picture);
            }
        }
        return ad;
    }

    protected Trovit createRoot() {
        Trovit trovit = TrovitUtils.getFactory().createTrovit();
        return trovit;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public boolean isEnergyCertificateAppendedToDescription() {
        return this.energyCertificateAppendedToDescription;
    }

    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }

    public void setEnergyCertificateAppendedToDescription(boolean bl) {
        this.energyCertificateAppendedToDescription = bl;
    }

    public Trovit write(SerializableXmlElement serializableXmlElement) {
        if (serializableXmlElement instanceof AgencyImpl) {
            return this.write((AgencyImpl)serializableXmlElement);
        }
        if (serializableXmlElement instanceof TransferImpl) {
            return this.write((TransferImpl)serializableXmlElement);
        }
        throw new IllegalArgumentException("unsupported src-class: " + (serializableXmlElement != null ? serializableXmlElement.getClass().getName() : "null"));
    }

    public Trovit write(AgencyImpl agencyImpl) {
        this.getErrorMap().clear();
        Trovit trovit = this.createRoot();
        if (agencyImpl == null) {
            LOGGER.warn((Object)"no agency was provided!");
        } else {
            for (EstateImpl estateImpl : agencyImpl.getEstates().values()) {
                try {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    Ad ad = this.convertEstate(estateImpl, agencyImpl.getAgent(), arrayList);
                    if (!arrayList.isEmpty()) {
                        this.putErrors(estateImpl.getId(), arrayList);
                        continue;
                    }
                    trovit.getAd().add(ad);
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"Fehler beim Parsen der Immobilie!");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
        }
        return trovit;
    }

    public Trovit write(TransferImpl transferImpl) {
        this.getErrorMap().clear();
        Trovit trovit = this.createRoot();
        if (transferImpl == null) {
            LOGGER.warn((Object)"no transfer was provided!");
        } else if (transferImpl.getAgencies().isEmpty()) {
            LOGGER.warn((Object)"no transferable agent found!");
        } else {
            TransferAgencyImpl transferAgencyImpl = transferImpl.getAgencies().get(0);
            for (EstateImpl estateImpl : transferAgencyImpl.getEstatesToSave()) {
                try {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    Ad ad = this.convertEstate(estateImpl, transferAgencyImpl.getAgent(), arrayList);
                    if (!arrayList.isEmpty()) {
                        this.putErrors(estateImpl.getId(), arrayList);
                        continue;
                    }
                    trovit.getAd().add(ad);
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"Fehler beim Parsen der Immobilie!");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
        }
        return trovit;
    }

    public Ad write(EstateImpl estateImpl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Ad ad = this.convertEstate(estateImpl, null, arrayList);
        if (!arrayList.isEmpty()) {
            LOGGER.warn((Object)("could not write estate #" + estateImpl.getId() + ", " + arrayList.size() + " errors"));
            for (String string : arrayList) {
                LOGGER.warn((Object)("> " + string));
            }
        }
        return arrayList.isEmpty() ? ad : null;
    }

    public Ad write(EstateImpl estateImpl, String string) {
        Ad ad = this.write(estateImpl);
        if (ad != null && string != null) {
            ad.setAddress(string);
        }
        return ad;
    }
}

