/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.xml;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateConverter;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.ValueImpl;
import com.openindex.openestate.impl.xml.WisITUtils;
import com.openindex.openestate.impl.xml.wis_it.BENUTZER;
import com.openindex.openestate.impl.xml.wis_it.OBJEKT;
import com.openindex.openestate.impl.xml.wis_it.WIS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class WisITWriter
extends OpenEstateConverter {
    private static final Logger LOGGER = Logger.getLogger(WisITWriter.class);
    private boolean energyCertificateAppendedToDescription = false;

    public WisITWriter() {
    }

    public WisITWriter(Locale locale) {
        this();
        this.setOpenEstateLanguage(locale);
    }

    public BENUTZER convertAgent(AgentImpl agentImpl) {
        BENUTZER bENUTZER = WisITUtils.getFactory().createBENUTZER();
        bENUTZER.setKDNR(agentImpl.getId());
        return bENUTZER;
    }

    public OBJEKT convertEstate(EstateImpl estateImpl, List<String> list) {
        String string;
        String string2;
        String string3;
        ValueImpl valueImpl;
        String string42;
        Object object;
        String string5;
        List<String> list2;
        Object object2;
        Boolean bl;
        Boolean bl2;
        Integer n;
        Integer n2;
        String string6;
        Object object3;
        Object object4;
        OBJEKT oBJEKT = WisITUtils.getFactory().createOBJEKT();
        Calendar calendar = Calendar.getInstance();
        if (estateImpl.getPublishBegin() != null) {
            calendar.setTime(estateImpl.getPublishBegin());
        } else {
            calendar.add(2, 6);
        }
        oBJEKT.setGUELTIGBIS(WisITUtils.getDateTimeFormat().format(calendar.getTime()));
        try {
            object4 = Arrays.asList(OpenEstateUtils.getEstateTypePath(estateImpl.getType()));
            object3 = object4.contains("BAUERNHOF") ? "bauernhof" : (object4.contains("BUERO_PRAXIS") ? "buero" : (object4.contains("GAST") ? "gastgewerbeobjekt" : (object4.contains("EINZELHANDEL") ? "geschaeft" : (object4.contains("KAUFHAUS") || object4.contains("HALLE_LAGER") || object4.contains("SB_MARKT") || object4.contains("VERKAUFSHALLE") || object4.contains("VERKAUFSFLAECHE") || object4.contains("VERBRAUCHERMARKT") ? "gewerbehalle" : (object4.contains("REIHENHAUS") ? "reihenhaus" : (object4.contains("HAUS") ? "einfamilienhaus" : (object4.contains("WOHNUNG") ? "wohnung" : (object4.contains("LAND_FORSTGRUND") ? "kulturgrund" : (object4.contains("MAIN_GEWERBE") ? "geschaeft" : (object4.contains("MAIN_GRUND") ? "baugrund" : (object4.contains("MAIN_LANDWIRTSCHAFT") ? "kulturgrund" : (object4.contains("MAIN_STELLPLATZ") ? "garage" : (object4.contains("MAIN_WOHNEN") ? "wohnung" : null)))))))))))));
            if (object3 == null) {
                list.add("Can't find a matching estate-type for: " + estateImpl.getType().getName());
                return null;
            }
            oBJEKT.setIMMOBILIENART((String)object3);
        }
        catch (Exception exception) {
            list.add("Can't set estate-type: " + exception.getLocalizedMessage());
            return null;
        }
        object4 = null;
        if ("KAUF".equals(estateImpl.getAction())) {
            oBJEKT.setMIETEKAUF("kauf");
            object4 = this.getEstateValueAsFloat("PREISE", "KAUFPREIS", estateImpl);
        } else if ("MIETE".equals(estateImpl.getAction())) {
            oBJEKT.setMIETEKAUF("miete");
            object4 = this.getEstateValueAsFloat("PREISE", "KALTMIETE", estateImpl);
        } else if ("PACHT".equals(estateImpl.getAction())) {
            oBJEKT.setMIETEKAUF("miete");
            object4 = this.getEstateValueAsFloat("PREISE", "PACHT", estateImpl);
        } else if ("ERBPACHT".equals(estateImpl.getAction())) {
            oBJEKT.setMIETEKAUF("miete");
            object4 = this.getEstateValueAsFloat("PREISE", "PACHT", estateImpl);
        } else if ("WAZ".equals(estateImpl.getAction())) {
            oBJEKT.setMIETEKAUF("miete");
            object4 = this.getEstateValueAsFloat("PREISE", "PAUSCHALMIETE", estateImpl);
        } else {
            list.add("Can't find a matching estate-action for: " + estateImpl.getAction());
            return null;
        }
        if (estateImpl.isHiddenPrices()) {
            oBJEKT.setPREIS(WisITUtils.FLOAT_FORMAT.format(0L));
            oBJEKT.setAUFANFRAGE("1");
        } else {
            if (object4 == null || ((Float)object4).floatValue() <= 0.0f) {
                list.add("Can't find a valid price: " + object4);
                return null;
            }
            oBJEKT.setPREIS(WisITUtils.FLOAT_FORMAT.format(((Float)object4).floatValue()));
            oBJEKT.setAUFANFRAGE("0");
        }
        object3 = null;
        String string7 = "netto";
        object3 = this.getEstateValueAsFloat("FLAECHEN", "BRUTTOFLAECHE", estateImpl);
        if (object3 != null && ((Float)object3).longValue() > 0L) {
            string7 = "brutto";
        } else {
            if (object3 == null || ((Float)object3).longValue() <= 0L) {
                object3 = this.getEstateValueAsFloat("FLAECHEN", "GESAMTFLAECHE", estateImpl);
            }
            if (object3 == null || ((Float)object3).longValue() <= 0L) {
                object3 = this.getEstateValueAsFloat("FLAECHEN", "GRUNDSTUECKSFLAECHE", estateImpl);
            }
            if (object3 == null || ((Float)object3).longValue() <= 0L) {
                object3 = this.getEstateValueAsFloat("FLAECHEN", "WOHNFLAECHE", estateImpl);
            }
            if (object3 == null || ((Float)object3).longValue() <= 0L) {
                object3 = this.getEstateValueAsFloat("FLAECHEN", "GEWERBEFLAECHE", estateImpl);
            }
            if (object3 == null || ((Float)object3).longValue() <= 0L) {
                object3 = this.getEstateValueAsFloat("FLAECHEN", "VERKAUFSFLAECHE", estateImpl);
            }
            if (object3 == null || ((Float)object3).longValue() <= 0L) {
                object3 = this.getEstateValueAsFloat("FLAECHEN", "STELLPLATZFLAECHE", estateImpl);
            }
        }
        if (object3 == null || ((Float)object3).longValue() <= 0L) {
            object3 = Float.valueOf("0");
        }
        oBJEKT.setNUTZFLAECHE(WisITUtils.FLOAT_FORMAT.format(object3));
        oBJEKT.setFLAECHEART(string7);
        String string8 = this.getEstateValueAsString("PREISE", "KONVENTIONIERT", estateImpl);
        if ("JA".equals(string8)) {
            oBJEKT.setKONVENTIONIERT("ja");
        } else if ("BEIDES".equals(string8)) {
            oBJEKT.setKONVENTIONIERT("nein");
        } else if ("NEIN".equals(string8)) {
            oBJEKT.setKONVENTIONIERT("nein");
        }
        Float f = this.getEstateValueAsFloat("FLAECHEN", "KUBATUR", estateImpl);
        if (f != null && f.floatValue() >= 0.0f) {
            oBJEKT.setKUBATUR(WisITUtils.FLOAT_FORMAT.format(f));
        }
        if ("ERSTBEZUG".equals(string6 = this.getEstateValueAsString("ZUSTAND", "ZUSTAND", estateImpl))) {
            oBJEKT.setZUSTAND("neu");
        } else if ("ERSTBEZUG_NACH_SANIERUNG".equals(string6)) {
            oBJEKT.setZUSTAND("neu");
        } else if ("MODERNISIERT".equals(string6)) {
            oBJEKT.setZUSTAND("neu");
        } else if ("NEUWERTIG".equals(string6)) {
            oBJEKT.setZUSTAND("neu");
        } else if ("RENOVIERT_VOLL".equals(string6)) {
            oBJEKT.setZUSTAND("neu");
        } else if ("SANIERT_VOLL".equals(string6)) {
            oBJEKT.setZUSTAND("neu");
        } else if (string6 != null) {
            oBJEKT.setZUSTAND("gebraucht");
        }
        Integer n3 = this.getEstateValueAsInteger("FLAECHEN", "ANZ_ZIMMER", estateImpl);
        if (n3 != null && n3 > 0) {
            oBJEKT.setZIMMER(n3.toString());
        }
        if ((n2 = this.getEstateValueAsInteger("AUSSTATTUNG", "ETAGE_GESAMT", estateImpl)) != null && n2 > 0) {
            oBJEKT.setSTOCKWERKE(n2.toString());
        }
        if ((n = this.getEstateValueAsInteger("AUSSTATTUNG", "ETAGE", estateImpl)) != null && n > 0) {
            oBJEKT.setSTOCKWERK(n.toString());
        }
        if ((bl2 = this.getEstateValueAsBoolean("AUSSTATTUNG", "PERS_LIFT", estateImpl)) == null) {
            bl2 = this.getEstateValueAsBoolean("AUSSTATTUNG", "LAST_LIFT", estateImpl);
        }
        if (Boolean.TRUE.equals(bl2)) {
            oBJEKT.setAUFZUG("ja");
        } else if (Boolean.FALSE.equals(bl2)) {
            oBJEKT.setAUFZUG("nein");
        }
        List<String> list3 = this.getEstateValueAsList("FLAECHEN", "STELLPLATZART", estateImpl);
        if (list3 != null) {
            if (list3.contains("GARAGE")) {
                oBJEKT.setGARAGE("ja");
            } else if (list3.contains("DUPLEX")) {
                oBJEKT.setGARAGE("ja");
            } else if (list3.contains("CARPORT")) {
                oBJEKT.setGARAGE("ja");
            } else if (list3.contains("DOPPELGARAGE")) {
                oBJEKT.setGARAGE("ja");
            } else if (list3.contains("TIEFGARAGE")) {
                oBJEKT.setGARAGE("ja");
            }
            if (list3.contains("AUSSEN")) {
                oBJEKT.setABSTELLPLATZ("ja");
            } else if (list3.contains("PARKHAUS")) {
                oBJEKT.setABSTELLPLATZ("ja");
            } else if (list3.contains("STELLPLATZ")) {
                oBJEKT.setABSTELLPLATZ("ja");
            } else if (list3.contains("STELLPLATZ_GEMEINSCHAFT")) {
                oBJEKT.setABSTELLPLATZ("ja");
            }
        }
        if (Boolean.TRUE.equals(bl = this.getEstateValueAsBoolean("AUSSTATTUNG", "GARTENNUTZUNG", estateImpl))) {
            oBJEKT.setGRUENFLAECHE("ja");
        } else if (Boolean.FALSE.equals(bl)) {
            oBJEKT.setGRUENFLAECHE("nein");
        }
        Boolean bl3 = this.getEstateValueAsBoolean("AUSSTATTUNG", "KELLER", estateImpl);
        if (Boolean.TRUE.equals(bl3)) {
            oBJEKT.setKELLER("ja");
        } else if (Boolean.FALSE.equals(bl3)) {
            oBJEKT.setKELLER("nein");
        } else {
            object2 = this.getEstateValueAsString("AUSSTATTUNG", "UNTERKELLERT", estateImpl);
            if ("JA".equals(object2)) {
                oBJEKT.setKELLER("ja");
            } else if ("TEIL".equals(object2)) {
                oBJEKT.setKELLER("ja");
            } else if ("NEIN".equals(object2)) {
                oBJEKT.setKELLER("nein");
            }
        }
        object2 = this.getEstateValueAsBoolean("AUSSTATTUNG", "BALKON_TERRASSE", estateImpl);
        if (Boolean.TRUE.equals(object2)) {
            oBJEKT.setBALKON("ja");
            oBJEKT.setTERRASSE("ja");
        } else if (Boolean.FALSE.equals(object2)) {
            oBJEKT.setBALKON("nein");
            oBJEKT.setTERRASSE("nein");
        }
        List<String> list4 = this.getEstateValueAsList("AUSSTATTUNG", "RAEUME", estateImpl);
        if (list4 != null) {
            if (list4.contains("DACHBODEN")) {
                oBJEKT.setDACHBODEN("ja");
            } else if (!list4.isEmpty()) {
                oBJEKT.setDACHBODEN("nein");
            }
        }
        if ((list2 = this.getEstateValueAsList("AUSSTATTUNG", "HEIZUNGSART", estateImpl)) != null) {
            if (list2.contains("ZENTRAL")) {
                oBJEKT.setHEIZUNG("zentral");
            } else if (list2.contains("AUTONOM")) {
                oBJEKT.setHEIZUNG("autonom");
            }
        }
        if (StringUtils.isEmpty((String)(string5 = this.getEstateValueAsString("VERWALTUNG", "VERFUEGBAR_ABTEXT", estateImpl))) && (object = this.getEstateValueAsCalendar("VERWALTUNG", "VERFUEGBAR_ABDATE", estateImpl)) != null) {
            string5 = WisITUtils.getDateFormat().format(((Calendar)object).getTime());
        }
        if (!StringUtils.isEmpty((String)string5)) {
            oBJEKT.setUEBERGABEZEITPUNKT(string5.trim());
        }
        if (!StringUtils.isBlank((String)(object = this.getEstateValueAsString("ZUSTAND", "BAUJAHR", estateImpl)))) {
            oBJEKT.setBAUJAHR(((String)object).trim());
        }
        String[] stringArray = new String[]{"OBJEKT_BESCHR", "AUSSTATT_BESCHR", "LAGE_BESCHR", "KURZ_BESCHR"};
        String string9 = this.getXmlLineSeparator() + this.getXmlLineSeparator() + StringUtils.repeat((String)"-", (int)15) + this.getXmlLineSeparator() + this.getXmlLineSeparator();
        for (String string42 : stringArray) {
            valueImpl = estateImpl.getAttribute("FREITEXTE." + string42);
            if (valueImpl == null || (string3 = StringUtils.trimToNull((String)valueImpl.writeValue(Locale.GERMAN))) == null) continue;
            oBJEKT.setINFODE(string3);
            if (!this.isEnergyCertificateAppendedToDescription() || StringUtils.isBlank((String)(string2 = OpenEstateUtils.writeEstateEnergyCertificate(estateImpl, new Locale("de"), this.getXmlLineSeparator())))) break;
            string = StringUtils.trimToNull((String)oBJEKT.getINFODE());
            string = string == null ? string2 : string2 + string9 + string;
            oBJEKT.setINFODE(StringUtils.trimToEmpty((String)string));
            break;
        }
        for (String string42 : stringArray) {
            valueImpl = estateImpl.getAttribute("FREITEXTE." + string42);
            if (valueImpl == null || (string3 = StringUtils.trimToNull((String)valueImpl.writeValue(Locale.ITALIAN))) == null) continue;
            oBJEKT.setINFOIT(string3);
            if (!this.isEnergyCertificateAppendedToDescription() || StringUtils.isBlank((String)(string2 = OpenEstateUtils.writeEstateEnergyCertificate(estateImpl, new Locale("it"), this.getXmlLineSeparator())))) break;
            string = StringUtils.trimToNull((String)oBJEKT.getINFOIT());
            string = string == null ? string2 : string2 + string9 + string;
            oBJEKT.setINFOIT(StringUtils.trimToEmpty((String)string));
            break;
        }
        oBJEKT.setID(estateImpl.getId());
        oBJEKT.setLOESCHEN("0");
        oBJEKT.setORT(estateImpl.getAdress().getCity());
        int n4 = 0;
        for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getAttachments()) {
            if (!estateAttachmentImpl.isPublished() || !estateAttachmentImpl.isName() && !estateAttachmentImpl.isUrl() || !estateAttachmentImpl.getMimeType().startsWith("image/") || (string42 = estateAttachmentImpl.isName() ? StringUtils.trimToNull((String)estateAttachmentImpl.getFileAsName()) : (estateAttachmentImpl.isUrl() ? StringUtils.trimToNull((String)estateAttachmentImpl.getFileAsUrl().getFile()) : null)) == null) continue;
            if (n4 == 0) {
                oBJEKT.setBILD1(string42);
            } else if (n4 == 1) {
                oBJEKT.setBILD2(string42);
            } else if (n4 == 2) {
                oBJEKT.setBILD3(string42);
            } else if (n4 == 3) {
                oBJEKT.setBILD4(string42);
            } else if (n4 == 4) {
                oBJEKT.setBILD5(string42);
            } else if (n4 == 5) {
                oBJEKT.setBILD6(string42);
            } else if (n4 == 6) {
                oBJEKT.setBILD7(string42);
            } else if (n4 == 7) {
                oBJEKT.setBILD8(string42);
            } else if (n4 == 8) {
                oBJEKT.setBILD9(string42);
            } else {
                if (n4 != 9) break;
                oBJEKT.setBILD10(string42);
            }
            ++n4;
        }
        n4 = 0;
        for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getAttachments()) {
            if (!estateAttachmentImpl.isPublished() || !estateAttachmentImpl.isName() && !estateAttachmentImpl.isUrl() || estateAttachmentImpl.getMimeType().startsWith("image/") || (string42 = estateAttachmentImpl.isName() ? StringUtils.trimToNull((String)estateAttachmentImpl.getFileAsName()) : (estateAttachmentImpl.isUrl() ? StringUtils.trimToNull((String)estateAttachmentImpl.getFileAsUrl().getFile()) : null)) == null) continue;
            if (n4 == 0) {
                oBJEKT.setDOWNLOAD1(string42);
            } else if (n4 == 1) {
                oBJEKT.setDOWNLOAD2(string42);
            } else {
                if (n4 != 2) break;
                oBJEKT.setDOWNLOAD3(string42);
            }
            ++n4;
        }
        return oBJEKT;
    }

    public WIS createRoot() {
        WIS wIS = WisITUtils.getFactory().createWIS();
        wIS.setOBJEKTE(WisITUtils.getFactory().createOBJEKTE());
        return wIS;
    }

    public boolean isEnergyCertificateAppendedToDescription() {
        return this.energyCertificateAppendedToDescription;
    }

    public void setEnergyCertificateAppendedToDescription(boolean bl) {
        this.energyCertificateAppendedToDescription = bl;
    }

    public WIS write(SerializableXmlElement serializableXmlElement) {
        if (serializableXmlElement instanceof AgencyImpl) {
            return this.write((AgencyImpl)serializableXmlElement);
        }
        if (serializableXmlElement instanceof TransferImpl) {
            return this.write((TransferImpl)serializableXmlElement);
        }
        throw new IllegalArgumentException("unsupported src-class: " + (serializableXmlElement != null ? serializableXmlElement.getClass().getName() : "null"));
    }

    public WIS write(AgencyImpl agencyImpl) {
        WIS wIS = this.createRoot();
        if (agencyImpl == null) {
            LOGGER.warn((Object)"no agency was provided!");
            wIS.getOBJEKTE().setANZAHL("0");
            return wIS;
        }
        wIS.setBENUTZER(this.convertAgent(agencyImpl.getAgent()));
        for (EstateImpl estateImpl : agencyImpl.getEstates().values()) {
            try {
                ArrayList<String> arrayList = new ArrayList<String>();
                OBJEKT oBJEKT = this.convertEstate(estateImpl, arrayList);
                if (!arrayList.isEmpty()) {
                    this.putErrors(estateImpl.getId(), arrayList);
                    continue;
                }
                oBJEKT.setLOESCHEN("0");
                wIS.getOBJEKTE().getOBJEKT().add(oBJEKT);
            }
            catch (Exception exception) {
                LOGGER.error((Object)"Fehler beim Parsen der Immobilie!");
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        wIS.getOBJEKTE().setANZAHL(String.valueOf(wIS.getOBJEKTE().getOBJEKT().size()));
        return wIS;
    }

    public WIS write(TransferImpl transferImpl) {
        Object exception;
        this.getErrorMap().clear();
        WIS wIS = this.createRoot();
        TransferAgencyImpl transferAgencyImpl = transferImpl.getAgencies().iterator().next();
        if (transferAgencyImpl == null) {
            LOGGER.warn((Object)"no agency was provided!");
            wIS.getOBJEKTE().setANZAHL("0");
            return wIS;
        }
        wIS.setBENUTZER(this.convertAgent(transferAgencyImpl.getAgent()));
        for (EstateImpl object2 : transferAgencyImpl.getEstatesToSave()) {
            try {
                exception = new ArrayList<String>();
                OBJEKT oBJEKT = this.convertEstate(object2, (List<String>)exception);
                if (!exception.isEmpty()) {
                    this.putErrors(object2.getId(), (List<String>)exception);
                    continue;
                }
                oBJEKT.setLOESCHEN("0");
                wIS.getOBJEKTE().getOBJEKT().add(oBJEKT);
            }
            catch (Exception exception2) {
                LOGGER.error((Object)"Fehler beim Parsen der Immobilie!");
                LOGGER.error((Object)("> " + exception2.getLocalizedMessage()), (Throwable)exception2);
            }
        }
        for (String string : transferAgencyImpl.getEstateIdsToRemove()) {
            try {
                exception = WisITUtils.getFactory().createOBJEKT();
                ((OBJEKT)exception).setID(string);
                ((OBJEKT)exception).setLOESCHEN("1");
                wIS.getOBJEKTE().getOBJEKT().add((OBJEKT)exception);
            }
            catch (Exception exception3) {
                LOGGER.error((Object)"Fehler beim Parsen der Immobilie!");
                LOGGER.error((Object)("> " + exception3.getLocalizedMessage()), (Throwable)exception3);
            }
        }
        wIS.getOBJEKTE().setANZAHL(String.valueOf(wIS.getOBJEKTE().getOBJEKT().size()));
        return wIS;
    }
}

