/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarObject;
import com.openindex.openestate.tool.calendar.CalendarPluginUtils;
import com.openindex.openestate.tool.calendar.VirtualCalendarObject;
import com.openindex.openestate.tool.calendar.utils.XCalUtils;
import java.awt.Color;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.property.Comment;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.util.UidGenerator;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.modules.XMLResource;

public abstract class CalendarEntry<ComponentType> {
    private static final Logger LOGGER = Logger.getLogger(CalendarEntry.class);
    public static final String LOCAL_CALENDAR = "LOCAL-CALENDAR";
    public static final String VIRTUAL_CALENDAR = "VIRTUAL-CALENDAR";
    private static final TimeZoneRegistry TIMEZONE_REGISTRY;
    private static UidGenerator UID_GENERATOR;
    private ComponentType component;
    private long calendarId = 0L;

    public CalendarEntry(ComponentType ComponentType) {
        if (ComponentType instanceof Component) {
            this.component = ComponentType;
            if (this.getProperty("ORGANIZER") == null) {
                this.putProperty((Property)new Organizer());
            }
        } else {
            throw new IllegalArgumentException("invalid component-class: " + ComponentType.getClass().getName());
        }
    }

    public String extractCommentParameter(String string) {
        String string2 = string + ":";
        for (Object e : this.getProperties().getProperties("COMMENT")) {
            String string3 = ((Comment)e).getValue();
            if (!string3.startsWith(string2)) continue;
            return string3.substring(string2.length());
        }
        return null;
    }

    public static Uid generateUid() {
        return UID_GENERATOR.generateUid();
    }

    public long getCalendarId() {
        return this.calendarId;
    }

    public ComponentType getComponent() {
        return this.component;
    }

    public abstract Date getBegin();

    public Description getDescription() {
        return (Description)this.getProperties().getProperty("DESCRIPTION");
    }

    public String getDescriptionString() {
        Description description = this.getDescription();
        return description != null ? description.getValue() : "";
    }

    public abstract Date getEnd();

    public abstract String getEntryName();

    public LastModified getLastModified() {
        return (LastModified)this.getProperties().getProperty("LAST-MODIFIED");
    }

    public String getLocalCalendarFromComment() {
        return this.extractCommentParameter(LOCAL_CALENDAR);
    }

    public long getLocalCalendarIdFromComment() {
        String string = this.getLocalCalendarFromComment();
        if (string == null) {
            return 0L;
        }
        String[] stringArray = string.split("\\.");
        return stringArray.length > 1 ? Long.valueOf(stringArray[1]) : 0L;
    }

    public PropertyList getProperties() {
        return ((Component)this.getComponent()).getProperties();
    }

    public Property getProperty(String string) {
        return this.getProperties().getProperty(string);
    }

    public Status getStatus() {
        return (Status)this.getProperties().getProperty("STATUS");
    }

    public abstract Color getStatusColor();

    public Summary getSummary() {
        return (Summary)this.getProperties().getProperty("SUMMARY");
    }

    public String getSummaryString() {
        Summary summary = this.getSummary();
        return summary != null ? summary.getValue() : "";
    }

    public static synchronized TimeZone getTimeZone() {
        java.util.TimeZone timeZone = java.util.TimeZone.getDefault();
        String string = timeZone.getID();
        TimeZone timeZone2 = CalendarEntry.getTimeZoneRegistry().getTimeZone(string);
        if (timeZone2 != null) {
            return timeZone2;
        }
        return CalendarEntry.getTimeZoneRegistry().getTimeZone("Europe/Berlin");
    }

    public static TimeZoneRegistry getTimeZoneRegistry() {
        return TIMEZONE_REGISTRY;
    }

    public Uid getUId() {
        return (Uid)this.getProperties().getProperty("UID");
    }

    public Class getVirtualCalendarClassFromComment() {
        String string = this.extractCommentParameter(VIRTUAL_CALENDAR);
        try {
            return string != null ? Class.forName(string) : null;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't create virtual calendar class!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public String getVirtualCalendarNameFromComment() {
        VirtualCalendarObject virtualCalendarObject = this.getVirtualCalendarObjectFromComment();
        return virtualCalendarObject != null ? virtualCalendarObject.getTitle() : null;
    }

    public VirtualCalendarObject getVirtualCalendarObjectFromComment() {
        try {
            Class clazz = this.getVirtualCalendarClassFromComment();
            return clazz != null ? (VirtualCalendarObject)clazz.newInstance() : null;
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't create virtual calendar instance!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public abstract boolean hasBeginDate();

    public abstract boolean hasBeginTime();

    public abstract boolean hasEndDate();

    public abstract boolean hasEndTime();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CalendarEntry loadEntry(long l, String string) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = CalendarPluginUtils.openPluginCollection("");
            CalendarEntry calendarEntry = CalendarEntry.loadEntry(l, string, collection);
            return calendarEntry;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static CalendarEntry loadEntry(long l, String string, Collection collection) throws ImmoToolDbException {
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Calendar")) {
                throw new ImmoToolDbException("invalid collection!");
            }
            String string2 = "declare namespace xCal=\"http://ietf.org/rfc/rfcXXXX.txt\";\ndeclare namespace xmldb=\"http://exist-db.org/xquery/xmldb\";\nlet $cals := xmldb:document( 'ImmoTool/OpenEstate-Calendar/calendar." + l + ".xml' )//" + "xCal" + ":vcalendar\n" + "return\n" + "<iCalendar>\n" + "<" + "xCal" + ":vcalendar xmlns:" + "xCal" + "=\"" + "http://ietf.org/rfc/rfcXXXX.txt" + "\">\n" + "<" + "xCal" + ":prodid>-//OpenEstate.org//iCal4j 1.0//EN</" + "xCal" + ":prodid>\n" + "<" + "xCal" + ":version>2.0</" + "xCal" + ":version>\n" + "<" + "xCal" + ":calscale>GREGORIAN</" + "xCal" + ":calscale>\n" + "{\n" + "  for $cal in $cals\n" + "    for $t in $cal/" + "xCal" + ":vtodo | $cal/" + "xCal" + ":vjournal | $cal/" + "xCal" + ":vevent\n" + "      where $t/" + "xCal" + ":uid='" + StringEscapeUtils.escapeSql((String)string) + "'\n" + "      return $t\n" + "}\n" + "</" + "xCal" + ":vcalendar>\n" + "</iCalendar>";
            ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string2);
            if (resourceSet == null) {
                throw new Exception("could not load result-calendar!");
            }
            XMLResource xMLResource = (XMLResource)resourceSet.getResource(0L);
            if (xMLResource == null) {
                throw new Exception("could not get result-calendar!");
            }
            CalendarObject calendarObject = new CalendarObject();
            calendarObject.setCalendar(XCalUtils.read(new StringReader((String)xMLResource.getContent())));
            CalendarEntry calendarEntry = calendarObject.getFirstEntry();
            if (calendarEntry == null) {
                return null;
            }
            calendarEntry.setCalendarId(l);
            return calendarEntry;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("Can't load entry '" + string + "' for calendar #" + l, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, List<String>> loadUids() throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = CalendarPluginUtils.openPluginCollection("");
            Map<Long, List<String>> map = CalendarEntry.loadUids(collection);
            return map;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static Map<Long, List<String>> loadUids(Collection collection) throws ImmoToolDbException {
        return CalendarEntry.loadUids(0L, collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, List<String>> loadUids(long l) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = CalendarPluginUtils.openPluginCollection("");
            Map<Long, List<String>> map = CalendarEntry.loadUids(l, collection);
            return map;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static Map<Long, List<String>> loadUids(long l, Collection collection) throws ImmoToolDbException {
        HashMap<Long, List<String>> hashMap = new HashMap<Long, List<String>>();
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Calendar")) {
                throw new ImmoToolDbException("invalid collection!");
            }
            String string = "declare namespace xCal=\"http://ietf.org/rfc/rfcXXXX.txt\";\ndeclare namespace openestate=\"http://www.openestate.org/1.0/\";\ndeclare namespace xmldb=\"http://exist-db.org/xquery/xmldb\";\nlet $cals := xmldb:xcollection( 'ImmoTool/OpenEstate-Calendar' )//xCal:vcalendar\nfor $cal in $cals\n  for $t in $cal//xCal:uid\n    return <entry cal=\"{util:document-name($t)}\" uid=\"{$t/text()}\"/>";
            ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string);
            if (resourceSet == null) {
                throw new ImmoToolDbException("could not load result!");
            }
            if (resourceSet.getSize() <= 0L) {
                return hashMap;
            }
            for (long i = 0L; i < resourceSet.getSize(); ++i) {
                XMLResource xMLResource = (XMLResource)resourceSet.getResource(i);
                String string2 = xMLResource.getContentAsDOM().getAttributes().getNamedItem("cal").getNodeValue();
                Long l2 = Long.valueOf(string2.split("\\.")[1]);
                if (!hashMap.containsKey(l2)) {
                    hashMap.put(l2, new ArrayList());
                }
                String string3 = xMLResource.getContentAsDOM().getAttributes().getNamedItem("uid").getNodeValue();
                ((List)hashMap.get(l2)).add(string3);
            }
            return hashMap;
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void putProperty(Property property) {
        Property property2 = null;
        try {
            property2 = this.getProperty(property.getName());
            if (property2 != null) {
                this.getProperties().remove(property2);
            }
            this.getProperties().add(property);
        }
        catch (Exception exception) {
            if (property2 != null) {
                this.removeProperty(property2.getName());
            }
            LOGGER.warn((Object)("could not put property: " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    public void removeProperty(String string) {
        Property property = this.getProperty(string);
        if (property != null) {
            this.getProperties().remove(property);
        }
    }

    public abstract void setBeginDate(Date var1);

    public abstract void setBeginTime(Date var1);

    public void setCalendarId(long l) {
        this.calendarId = l;
    }

    public void setComponent(ComponentType ComponentType) {
        this.component = ComponentType;
    }

    public abstract void setEndDate(Date var1);

    public abstract void setEndTime(Date var1);

    public void setSummary(String string) {
        if (string == null) {
            this.removeProperty("SUMMARY");
        } else {
            this.putProperty((Property)new Summary(string));
        }
    }

    public static String writePriority(Priority priority) {
        if (Priority.UNDEFINED.equals((Object)priority)) {
            return ImmoToolUtils.getResourceMap(CalendarEntry.class).getString("priority.undefined", new Object[0]);
        }
        if (Priority.LOW.equals((Object)priority)) {
            return ImmoToolUtils.getResourceMap(CalendarEntry.class).getString("priority.low", new Object[0]);
        }
        if (Priority.MEDIUM.equals((Object)priority)) {
            return ImmoToolUtils.getResourceMap(CalendarEntry.class).getString("priority.medium", new Object[0]);
        }
        if (Priority.HIGH.equals((Object)priority)) {
            return ImmoToolUtils.getResourceMap(CalendarEntry.class).getString("priority.high", new Object[0]);
        }
        return "";
    }

    public abstract String writeStatus();

    public static String writeStatusForEvent(Status status) {
        if (Status.VEVENT_CANCELLED.equals((Object)status)) {
            return ImmoToolUtils.getResourceMap(CalendarEntry.class).getString("status.event.cancelled", new Object[0]);
        }
        if (Status.VEVENT_CONFIRMED.equals((Object)status)) {
            return ImmoToolUtils.getResourceMap(CalendarEntry.class).getString("status.event.confirmed", new Object[0]);
        }
        if (Status.VEVENT_TENTATIVE.equals((Object)status)) {
            return ImmoToolUtils.getResourceMap(CalendarEntry.class).getString("status.event.tentative", new Object[0]);
        }
        return "";
    }

    public static String writeStatusForJournal(Status status) {
        if (Status.VJOURNAL_CANCELLED.equals((Object)status)) {
            return ImmoToolUtils.getResourceMap(CalendarEntry.class).getString("status.journal.cancelled", new Object[0]);
        }
        if (Status.VJOURNAL_DRAFT.equals((Object)status)) {
            return ImmoToolUtils.getResourceMap(CalendarEntry.class).getString("status.journal.draft", new Object[0]);
        }
        if (Status.VJOURNAL_FINAL.equals((Object)status)) {
            return ImmoToolUtils.getResourceMap(CalendarEntry.class).getString("status.journal.final", new Object[0]);
        }
        return "";
    }

    public static String writeStatusForTodo(Status status) {
        if (Status.VTODO_CANCELLED.equals((Object)status)) {
            return ImmoToolUtils.getResourceMap(CalendarEntry.class).getString("status.todo.cancelled", new Object[0]);
        }
        if (Status.VTODO_COMPLETED.equals((Object)status)) {
            return ImmoToolUtils.getResourceMap(CalendarEntry.class).getString("status.todo.completed", new Object[0]);
        }
        if (Status.VTODO_IN_PROCESS.equals((Object)status)) {
            return ImmoToolUtils.getResourceMap(CalendarEntry.class).getString("status.todo.inProcess", new Object[0]);
        }
        if (Status.VTODO_NEEDS_ACTION.equals((Object)status)) {
            return ImmoToolUtils.getResourceMap(CalendarEntry.class).getString("status.todo.needsAction", new Object[0]);
        }
        return "";
    }

    static {
        UID_GENERATOR = null;
        TIMEZONE_REGISTRY = TimeZoneRegistryFactory.getInstance().createRegistry();
        try {
            UID_GENERATOR = new UidGenerator("OpenEstate-Calendar");
        }
        catch (Exception exception) {
            LOGGER.fatal((Object)"Can't load uid-generator!");
            LOGGER.fatal((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            System.exit(1);
        }
    }
}

