/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarPlugin;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.ResourceMap;

public class CalendarEntryDayModel
extends DefaultTableModel {
    public static final int COLUMN_TIME = 0;
    public static final int COLUMN_ENTRY = 1;
    private static final Map<Integer, String> COLUMN_NAMES = new HashMap<Integer, String>();
    private static final Map<Integer, Class> COLUMN_CLASSES;
    private final ResourceMap resourceMap = ImmoToolUtils.getResourceMap(CalendarEntryDayModel.class);
    private boolean fullView = false;

    public CalendarEntryDayModel() {
        this.clear(new Date());
    }

    public void addEmptyEntry() {
        int n = this.getColumnCount();
        this.setColumnCount(n + 1);
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.setValueAt(null, i, n);
        }
    }

    public void addCalendarEntry(CalendarEntry calendarEntry) {
        Calendar calendar;
        Date date;
        int n = this.getColumnCount();
        this.setColumnCount(n + 1);
        Date date2 = calendarEntry.getBegin();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        int n2 = calendar2.get(12);
        int n3 = n2 % 15;
        if (n3 > 0) {
            calendar2.add(12, n3 * -1);
            date2 = calendar2.getTime();
        }
        if ((date = calendarEntry.getEnd()) != null) {
            calendar = Calendar.getInstance();
            calendar.setTime(date);
            n2 = calendar.get(12);
            n3 = n2 % 15;
            if (n3 > 0) {
                calendar.add(12, 15 - n3);
                date = calendar.getTime();
            }
        }
        calendar = !this.isFullView() ? CalendarPlugin.getWorkTimeBegin() : null;
        Calendar calendar3 = Calendar.getInstance();
        calendar3.setTime(date2);
        calendar3.set(11, !this.isFullView() ? calendar.get(11) : 0);
        calendar3.set(12, !this.isFullView() ? calendar.get(12) : 0);
        calendar3.set(13, 0);
        calendar3.set(14, 0);
        Calendar calendar4 = null;
        if (this.isFullView()) {
            calendar4 = Calendar.getInstance();
            calendar4.setTime(calendar3.getTime());
            calendar4.set(11, 23);
            calendar4.set(12, 59);
            calendar4.set(13, 59);
        } else {
            calendar4 = CalendarPlugin.getWorkTimeEnd();
            calendar4.set(1, calendar3.get(1));
            calendar4.set(6, calendar3.get(6));
            calendar4.set(13, 0);
            calendar4.set(14, 0);
        }
        int n4 = 0;
        while (!calendar3.after(calendar4)) {
            if (date2.getTime() <= calendar3.getTimeInMillis() && (date == null || date.getTime() > calendar3.getTimeInMillis())) {
                this.setValueAt(calendarEntry, n4, n);
            } else {
                this.setValueAt(null, n4, n);
            }
            calendar3.add(12, 15);
            ++n4;
        }
    }

    public void clear(Date date) {
        this.setColumnCount(1);
        while (this.getRowCount() > 0) {
            this.removeRow(0);
        }
        Calendar calendar = !this.isFullView() ? CalendarPlugin.getWorkTimeBegin() : null;
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        calendar2.set(11, !this.isFullView() ? calendar.get(11) : 0);
        calendar2.set(12, !this.isFullView() ? calendar.get(12) : 0);
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        Calendar calendar3 = null;
        if (this.isFullView()) {
            calendar3 = Calendar.getInstance();
            calendar3.setTime(calendar2.getTime());
            calendar3.set(11, 23);
            calendar3.set(12, 59);
            calendar3.set(13, 59);
        } else {
            calendar3 = CalendarPlugin.getWorkTimeEnd();
            calendar3.set(1, calendar2.get(1));
            calendar3.set(6, calendar2.get(6));
            calendar3.set(13, 0);
            calendar3.set(14, 0);
        }
        while (!calendar2.after(calendar3)) {
            this.addRow(new Object[]{calendar2.getTime()});
            calendar2.add(12, 15);
        }
    }

    public Class getColumnClass(int n) {
        return COLUMN_CLASSES.containsKey(n) ? COLUMN_CLASSES.get(n) : COLUMN_CLASSES.get(1);
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return this.resourceMap.getString(COLUMN_NAMES.get(0), new Object[0]);
        }
        return this.resourceMap.getString(COLUMN_NAMES.get(1), new Object[]{n});
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public boolean isFullView() {
        return this.fullView;
    }

    public void setFullView(boolean bl) {
        this.fullView = bl;
    }

    static {
        COLUMN_NAMES.put(0, "col.time");
        COLUMN_NAMES.put(1, "col.entry");
        COLUMN_CLASSES = new HashMap<Integer, Class>();
        COLUMN_CLASSES.put(0, Date.class);
        COLUMN_CLASSES.put(1, CalendarEntry.class);
    }
}

