/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolTabPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarEntryDayModel;
import com.openindex.openestate.tool.calendar.CalendarEntryRemoveTask;
import com.openindex.openestate.tool.calendar.CalendarEntryViewPanel;
import com.openindex.openestate.tool.calendar.CalendarEntryViewTask;
import com.openindex.openestate.tool.calendar.CalendarEventEntry;
import com.openindex.openestate.tool.calendar.CalendarJournalEntry;
import com.openindex.openestate.tool.calendar.CalendarObject;
import com.openindex.openestate.tool.calendar.CalendarPlugin;
import com.openindex.openestate.tool.calendar.CalendarSource;
import com.openindex.openestate.tool.calendar.CalendarTodoEntry;
import com.openindex.openestate.tool.calendar.VirtualCalendarObject;
import com.openindex.openestate.tool.utils.TabComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.fortuna.ical4j.model.property.Status;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.PinstripePainter;

public class CalendarEntryDayPanel
extends ImmoToolTabPanel {
    private static final Logger LOGGER = Logger.getLogger(CalendarEntryDayPanel.class);
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private JPopupMenu actionsMenu;
    private JPopupMenu addMenu;
    private CalendarEntryDayModel dayTableModel;
    private JComboBox searchCalendarBox;
    private JComboBox searchEntryBox;
    private JComboBox searchStatusBox;
    private JSpinner searchDayField;
    private DateFormat dateTimeBeginFormatter;
    private DateFormat dateTimeEndFormatter;
    private DateFormat dayAndDateFormatter;
    private DateFormat fullTitleFormatter;
    private DateFormat timeFormatter;
    private DateFormat toolTipFormatter;
    private Map<Class, VirtualCalendarObject> virtualCalendars;
    private boolean isSearching = false;
    private JButton actionButton;
    private JButton addButton;
    private JButton closeButton;
    private JXTitledSeparator dayLabel;
    private JXTable dayTable;
    private JScrollPane dayTableScroller;
    private JPanel formPanel;
    private JButton helpButton;
    private JButton nextPageButton;
    private JButton prevPageButton;
    private JButton searchButton;
    private JToggleButton switchToFullViewButton;
    private JXTitledSeparator titleLabel;
    private JButton todayPageButton;

    public CalendarEntryDayPanel() {
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(CalendarEntryDayPanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(CalendarEntryDayPanel.class);
        this.initComponents();
        this.buildFormPanel();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.virtualCalendars = new HashMap<Class, VirtualCalendarObject>();
        try {
            for (VirtualCalendarObject virtualCalendarObject : VirtualCalendarObject.getUsableCalendars()) {
                this.virtualCalendars.put(virtualCalendarObject.getClass(), virtualCalendarObject);
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't load virtual calendars!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        this.dateTimeBeginFormatter = new SimpleDateFormat(this.resourceMap.getString("format.dateTime.begin", new Object[0]));
        this.dateTimeEndFormatter = new SimpleDateFormat(this.resourceMap.getString("format.dateTime.end", new Object[0]));
        this.dayAndDateFormatter = new SimpleDateFormat(this.resourceMap.getString("format.dayAndDate", new Object[0]));
        this.fullTitleFormatter = new SimpleDateFormat(this.resourceMap.getString("format.full.title", new Object[0]));
        this.timeFormatter = new SimpleDateFormat(this.resourceMap.getString("format.time", new Object[0]));
        this.toolTipFormatter = new SimpleDateFormat(this.resourceMap.getString("format.full.toolTip", new Object[0]));
        this.actionsMenu = new JPopupMenu();
        this.addMenu = new JPopupMenu();
        this.addMenu.add(new JMenuItem(this.actionMap.get("doAddTodo")));
        this.addMenu.add(new JMenuItem(this.actionMap.get("doAddEvent")));
        ImmoToolUtils.configureTable((JXTable)this.dayTable);
        this.dayTable.setHighlighters(new Highlighter[0]);
        this.dayTableModel = new CalendarEntryDayModel();
        this.dayTable.setModel((TableModel)this.dayTableModel);
        this.dayTable.getTableHeader().setReorderingAllowed(false);
        this.dayTable.getColumn(0).setMaxWidth(50);
        this.dayTable.getColumn(0).setMinWidth(50);
        this.dayTable.setColumnSelectionAllowed(true);
        this.dayTable.setRowSelectionAllowed(true);
        this.dayTable.setSortable(false);
        this.dayTable.setShowGrid(false);
        this.dayTable.setColumnMargin(1);
        this.dayTable.setRowMargin(0);
        this.dayTable.setDefaultRenderer(Date.class, (TableCellRenderer)new CalendarTimeRenderer());
        this.dayTable.setDefaultRenderer(CalendarEntry.class, (TableCellRenderer)new CalendarEntryTableCellRenderer());
        this.dayTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 || mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
                    int n = CalendarEntryDayPanel.this.dayTable.rowAtPoint(mouseEvent.getPoint());
                    if (n < 0) {
                        n = CalendarEntryDayPanel.this.dayTable.getSelectedRow();
                    }
                    if (n < 0) {
                        return;
                    }
                    int n2 = CalendarEntryDayPanel.this.dayTable.columnAtPoint(mouseEvent.getPoint());
                    if (n2 < 0) {
                        n2 = CalendarEntryDayPanel.this.dayTable.getSelectedColumn();
                    }
                    if (n2 < 0) {
                        return;
                    }
                    if (n >= 0 && n != CalendarEntryDayPanel.this.dayTable.getSelectedRow() || n2 >= 0 && n2 != CalendarEntryDayPanel.this.dayTable.getSelectedColumn()) {
                        CalendarEntryDayPanel.this.dayTable.clearSelection();
                        CalendarEntryDayPanel.this.dayTable.changeSelection(n, n2, false, false);
                    }
                    CalendarEntryDayPanel.this.showActions((JComponent)CalendarEntryDayPanel.this.dayTable, ((CalendarEntryDayPanel)CalendarEntryDayPanel.this).dayTable.getMousePosition().x, ((CalendarEntryDayPanel)CalendarEntryDayPanel.this).dayTable.getMousePosition().y);
                }
            }
        });
        this.dayTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CalendarEntryDayPanel.this.actionButton.setEnabled(CalendarEntryDayPanel.this.dayTable.getSelectedRow() >= 0 && CalendarEntryDayPanel.this.dayTable.getSelectedColumn() > 0);
            }
        });
        this.nextPageButton.setAction(this.actionMap.get(this.nextPageButton.getText()));
        this.prevPageButton.setAction(this.actionMap.get(this.prevPageButton.getText()));
        this.todayPageButton.setAction(this.actionMap.get(this.todayPageButton.getText()));
        this.searchButton.setAction(this.actionMap.get(this.searchButton.getText()));
        this.addButton.setAction(this.actionMap.get(this.addButton.getText()));
        this.closeButton.setAction(this.actionMap.get(this.closeButton.getText()));
        this.helpButton.setAction(this.actionMap.get(this.helpButton.getText()));
        this.switchToFullViewButton.setAction(this.actionMap.get(this.switchToFullViewButton.getText()));
        this.actionButton.setAction(this.actionMap.get(this.actionButton.getText()));
        this.actionButton.setEnabled(false);
        this.searchEntryBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CalendarEntryDayPanel.this.searchEntryBox.isEnabled()) {
                    return;
                }
                int n = CalendarEntryDayPanel.this.searchEntryBox.getSelectedIndex();
                CalendarEntryDayPanel.this.searchStatusBox.setEnabled(false);
                CalendarEntryDayPanel.this.searchStatusBox.removeAllItems();
                CalendarEntryDayPanel.this.searchStatusBox.addItem(null);
                if (n > 0) {
                    Integer n2 = (Integer)CalendarEntryDayPanel.this.searchEntryBox.getItemAt(n);
                    Status[] statusArray = null;
                    statusArray = n2 == 1 ? CalendarEventEntry.getStatusOptions() : (n2 == 2 ? CalendarTodoEntry.getStatusOptions() : (n2 == 4 ? CalendarJournalEntry.getStatusOptions() : new Status[]{}));
                    for (Status status : statusArray) {
                        CalendarEntryDayPanel.this.searchStatusBox.addItem(status);
                    }
                    CalendarEntryDayPanel.this.searchStatusBox.setSelectedIndex(0);
                }
                CalendarEntryDayPanel.this.searchStatusBox.setEnabled(true);
            }
        });
    }

    private void buildFormPanel() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && !CalendarEntryDayPanel.this.isSearching) {
                    ImmoToolUtils.executeTask((Task)CalendarEntryDayPanel.this.doSearch());
                }
            }
        };
        this.searchCalendarBox = new JComboBox();
        this.searchCalendarBox.setName("searchCalendarBox");
        this.searchCalendarBox.addItem(null);
        this.searchCalendarBox.setRenderer(new CalendarSourceRenderer());
        this.searchEntryBox = new JComboBox();
        this.searchEntryBox.setName("searchEntryBox");
        this.searchEntryBox.addItem(null);
        this.searchEntryBox.addItem(1);
        this.searchEntryBox.addItem(2);
        this.searchEntryBox.addItem(4);
        this.searchEntryBox.setRenderer(new CalendarEntryListCellRenderer());
        this.searchStatusBox = new JComboBox();
        this.searchStatusBox.setName("searchStatusBox");
        this.searchStatusBox.addItem(null);
        this.searchStatusBox.setRenderer(new CalendarStatusRenderer());
        this.searchStatusBox.setEnabled(false);
        this.searchDayField = new JSpinner(new SpinnerDateModel());
        ((SpinnerDateModel)this.searchDayField.getModel()).setCalendarField(6);
        this.searchDayField.setName("searchDayField");
        this.searchDayField.setEditor(new JSpinner.DateEditor(this.searchDayField, "dd. MMMMM yyyy"));
        this.searchDayField.getEditor().addKeyListener(keyAdapter);
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, pref:grow, 3dlu, right:pref, 3dlu, pref:grow", (JPanel)this.formPanel);
        defaultFormBuilder.append(this.resourceMap.getString("label.search.calendar", new Object[0]), (Component)this.searchCalendarBox);
        defaultFormBuilder.append(this.resourceMap.getString("label.search.entries", new Object[0]), (Component)this.searchEntryBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.search.date", new Object[0]), (Component)this.searchDayField);
        defaultFormBuilder.append(this.resourceMap.getString("label.search.status", new Object[0]), (Component)this.searchStatusBox);
        defaultFormBuilder.nextLine();
        this.formPanel.revalidate();
        this.formPanel.repaint();
    }

    @Action
    public void doAction() {
        this.showActions(this.actionButton, 0, this.actionButton.getSize().height);
    }

    @Action
    public void doAdd() {
        this.addMenu.show(this.addButton, 0, this.addButton.getSize().height);
    }

    @Action
    public Task doAddEvent() {
        String string = CalendarEntryViewPanel.getInstanceTabTitle((String)null, 0L, 0);
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<CalendarEntryViewPanel>(){

            protected CalendarEntryViewPanel executeTask() throws Exception {
                CalendarEntryViewPanel calendarEntryViewPanel = new CalendarEntryViewPanel(0);
                calendarEntryViewPanel.setCalendarEntry(null);
                calendarEntryViewPanel.setEditable(true);
                int n = CalendarEntryDayPanel.this.dayTable.getSelectedRow();
                int n2 = CalendarEntryDayPanel.this.dayTable.getSelectedColumn();
                if (n >= 0 && n2 > 0) {
                    Date date = (Date)CalendarEntryDayPanel.this.dayTable.getValueAt(n, 0);
                    calendarEntryViewPanel.setDateInterval(date, null);
                }
                return calendarEntryViewPanel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarEntryDayPanel.this.resourceMap.getString("error.cantCreateForm", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                CalendarEntryDayPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(CalendarEntryViewPanel calendarEntryViewPanel) {
                super.succeeded((Object)calendarEntryViewPanel);
                calendarEntryViewPanel.executeFormTasks();
                ImmoToolUtils.showPanel((TabComponent)calendarEntryViewPanel);
            }
        };
    }

    @Action
    public Task doAddTodo() {
        String string = CalendarEntryViewPanel.getInstanceTabTitle((String)null, 0L, 1);
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<CalendarEntryViewPanel>(){

            protected CalendarEntryViewPanel executeTask() throws Exception {
                CalendarEntryViewPanel calendarEntryViewPanel = new CalendarEntryViewPanel(1);
                calendarEntryViewPanel.setCalendarEntry(null);
                calendarEntryViewPanel.setEditable(true);
                int n = CalendarEntryDayPanel.this.dayTable.getSelectedRow();
                int n2 = CalendarEntryDayPanel.this.dayTable.getSelectedColumn();
                if (n >= 0 && n2 > 0) {
                    Date date = (Date)CalendarEntryDayPanel.this.dayTable.getValueAt(n, 0);
                    calendarEntryViewPanel.setDateInterval(date, null);
                }
                return calendarEntryViewPanel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarEntryDayPanel.this.resourceMap.getString("error.cantCreateForm", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                CalendarEntryDayPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(CalendarEntryViewPanel calendarEntryViewPanel) {
                super.succeeded((Object)calendarEntryViewPanel);
                calendarEntryViewPanel.executeFormTasks();
                ImmoToolUtils.showPanel((TabComponent)calendarEntryViewPanel);
            }
        };
    }

    @Action
    public void doClose() {
        ImmoToolUtils.removePanel((String)this.getTabTitle());
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog((String)"calendar.entries");
    }

    @Action
    public Task doNextPage() {
        try {
            this.searchDayField.commitEdit();
        }
        catch (Exception exception) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidDate", new Object[0]), (Throwable)exception);
            return null;
        }
        this.searchDayField.setValue(this.searchDayField.getNextValue());
        return this.doSearch();
    }

    @Action
    public Task doPrevPage() {
        try {
            this.searchDayField.commitEdit();
        }
        catch (Exception exception) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidDate", new Object[0]), (Throwable)exception);
            return null;
        }
        this.searchDayField.setValue(this.searchDayField.getPreviousValue());
        return this.doSearch();
    }

    @Action
    public Task doSearch() {
        try {
            this.searchDayField.commitEdit();
        }
        catch (Exception exception) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidDate", new Object[0]), (Throwable)exception);
            return null;
        }
        this.dayTableModel.clear((Date)this.searchDayField.getValue());
        this.dayTable.setEnabled(false);
        this.setButtonsEnabled(false);
        final Integer n = this.searchEntryBox.isEnabled() ? (Integer)this.searchEntryBox.getSelectedItem() : null;
        final Status status = this.searchStatusBox.isEnabled() ? (Status)this.searchStatusBox.getSelectedItem() : null;
        final Object object = this.searchCalendarBox != null ? this.searchCalendarBox.getSelectedItem() : null;
        return new ImmoToolTask<CalendarObject>(){

            protected CalendarObject executeTask() throws Exception {
                CalendarObject calendarObject = new CalendarObject();
                if (object instanceof VirtualCalendarObject) {
                    VirtualCalendarObject virtualCalendarObject = (VirtualCalendarObject)object;
                    CalendarEntry[] calendarEntryArray = null;
                    if (n == null) {
                        calendarEntryArray = virtualCalendarObject.getEntries();
                    } else if (n == 1) {
                        calendarEntryArray = virtualCalendarObject.getEventEntries();
                    } else if (n == 2) {
                        calendarEntryArray = virtualCalendarObject.getTodoEntries();
                    } else if (n == 4) {
                        calendarEntryArray = virtualCalendarObject.getJournalEntries();
                    } else {
                        throw new Exception("Unknown entry-type: " + n);
                    }
                    for (CalendarEntry calendarEntry : calendarEntryArray) {
                        if (status != null && !calendarEntry.getStatus().equals((Object)status)) continue;
                        calendarObject.add(calendarEntry);
                    }
                } else if (object instanceof CalendarSource) {
                    CalendarEntry[] calendarEntryArray;
                    CalendarSource calendarSource = (CalendarSource)object;
                    int n2 = 0;
                    if (n != null) {
                        n2 = n;
                    } else {
                        n2 |= 1;
                        n2 |= 4;
                        n2 |= 2;
                    }
                    for (CalendarEntry calendarEntry : calendarEntryArray = CalendarObject.search(new long[]{calendarSource.getCalendarId()}, status, n2)) {
                        calendarObject.add(calendarEntry);
                    }
                } else {
                    int n3 = 0;
                    if (n != null) {
                        n3 = n;
                    } else {
                        n3 |= 1;
                        n3 |= 4;
                        n3 |= 2;
                    }
                    CalendarEntry[] calendarEntryArray = CalendarObject.search(null, status, n3);
                    for (CalendarEntry calendarEntry : calendarEntryArray) {
                        calendarObject.add(calendarEntry);
                    }
                    for (VirtualCalendarObject virtualCalendarObject : CalendarEntryDayPanel.this.virtualCalendars.values()) {
                        calendarEntryArray = null;
                        if (n == null) {
                            calendarEntryArray = virtualCalendarObject.getEntries();
                        } else if (n == 1) {
                            calendarEntryArray = virtualCalendarObject.getEventEntries();
                        } else if (n == 2) {
                            calendarEntryArray = virtualCalendarObject.getTodoEntries();
                        } else if (n == 4) {
                            calendarEntryArray = virtualCalendarObject.getJournalEntries();
                        } else {
                            throw new Exception("Unknown entry-type: " + n);
                        }
                        for (CalendarEntry calendarEntry : calendarEntryArray) {
                            if (status != null && !calendarEntry.getStatus().equals((Object)status)) continue;
                            calendarObject.add(calendarEntry);
                        }
                    }
                }
                return calendarObject;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarEntryDayPanel.this.resourceMap.getString("error.cantExecuteSearch", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                CalendarEntryDayPanel.this.dayTable.setEnabled(true);
                CalendarEntryDayPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(CalendarObject calendarObject) {
                super.succeeded((Object)calendarObject);
                Date date = (Date)CalendarEntryDayPanel.this.searchDayField.getValue();
                Calendar calendar = Calendar.getInstance();
                if (date == null) {
                    calendar.setTimeInMillis(0L);
                } else {
                    calendar.setTime(date);
                }
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                Date date2 = calendar.getTime();
                calendar.add(6, 1);
                calendar.set(14, -1);
                Date date3 = calendar.getTime();
                for (CalendarEntry calendarEntry : calendarObject.filterEntries(date2, date3, true)) {
                    CalendarEntryDayPanel.this.dayTableModel.addCalendarEntry(calendarEntry);
                }
                CalendarEntryDayPanel.this.dayTable.getColumn(0).setMaxWidth(50);
                CalendarEntryDayPanel.this.dayTable.getColumn(0).setMinWidth(50);
                for (int i = 1; i < CalendarEntryDayPanel.this.dayTable.getColumnCount() - 1; ++i) {
                    CalendarEntryDayPanel.this.dayTable.packColumn(i, 5, 100);
                }
                CalendarEntryDayPanel.this.dayLabel.setTitle(CalendarEntryDayPanel.this.resourceMap.getString("dayLabel.title", new Object[0]) + " / " + CalendarEntryDayPanel.this.dayAndDateFormatter.format(date2));
            }
        };
    }

    @Action
    public Task doSwitchToFullView() {
        this.dayTableModel.setFullView(this.switchToFullViewButton.isSelected());
        return this.doSearch();
    }

    @Action
    public Task doTodayPage() {
        try {
            this.searchDayField.commitEdit();
        }
        catch (Exception exception) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidDate", new Object[0]), (Throwable)exception);
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.searchDayField.setValue(new Date());
        return this.doSearch();
    }

    public static String getInstanceTabTitle() {
        return ImmoToolUtils.getResourceMap(CalendarEntryDayPanel.class).getString("tabTitle", new Object[0]);
    }

    public String getTabInfo() {
        return this.resourceMap.getString("tabInfo", new Object[0]);
    }

    public String getTabTitle() {
        return CalendarEntryDayPanel.getInstanceTabTitle();
    }

    public void loadSources() throws ImmoToolDbException {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        for (CalendarSource calendarSource : CalendarSource.loadSources()) {
            String string = calendarSource.getName();
            int n = 0;
            while (treeMap.containsKey(string)) {
                string = calendarSource.getName() + "_" + n;
            }
            treeMap.put(string, calendarSource);
        }
        try {
            for (VirtualCalendarObject virtualCalendarObject : this.virtualCalendars.values()) {
                String string = virtualCalendarObject.getTitle();
                int n = 0;
                while (treeMap.containsKey(string)) {
                    string = virtualCalendarObject.getTitle() + "_" + n;
                }
                treeMap.put(string, virtualCalendarObject);
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't load virtual calendars!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        this.searchCalendarBox.setEnabled(false);
        this.searchCalendarBox.removeAllItems();
        this.searchCalendarBox.addItem(null);
        for (Object e : treeMap.values()) {
            this.searchCalendarBox.addItem(e);
        }
        this.searchCalendarBox.setSelectedIndex(0);
        this.searchCalendarBox.setEnabled(true);
    }

    public void refreshTab() {
        ImmoToolUtils.executeTask((Task)this.doSearch());
    }

    private void setButtonsEnabled(boolean bl) {
        this.addButton.setEnabled(bl);
        this.searchButton.setEnabled(bl);
        this.actionButton.setEnabled(bl && this.dayTable.getSelectedRowCount() > 0);
        this.nextPageButton.setEnabled(bl);
        this.prevPageButton.setEnabled(bl);
        this.todayPageButton.setEnabled(bl);
        this.switchToFullViewButton.setEnabled(bl);
        this.searchDayField.setEnabled(bl);
    }

    private void showActions(JComponent jComponent, int n, int n2) {
        int n3 = this.dayTable.getSelectedRow();
        int n4 = this.dayTable.getSelectedColumn();
        if (n3 < 0 || n4 < 0) {
            return;
        }
        this.actionsMenu.setVisible(false);
        this.actionsMenu.removeAll();
        Date date = (Date)this.dayTable.getValueAt(n3, 0);
        if (n4 == 0) {
            this.actionsMenu.add(new JLabel("<html>&nbsp;<b>" + this.timeFormatter.format(date) + "</b></html>"));
            this.actionsMenu.show(jComponent, n, n2);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        JLabel jLabel = new JLabel("<html>" + this.fullTitleFormatter.format(calendar.getTime()) + "</html>");
        jLabel.setOpaque(true);
        jLabel.setBackground(Color.WHITE);
        this.actionsMenu.add(jLabel);
        this.actionsMenu.addSeparator();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doAddEvent")));
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doAddTodo")));
        final CalendarEntry calendarEntry = (CalendarEntry)this.dayTable.getValueAt(n3, n4);
        if (calendarEntry != null) {
            JMenu jMenu = new JMenu(calendarEntry.getSummaryString());
            if (calendarEntry.getCalendarId() > 0L) {
                JMenuItem jMenuItem = null;
                AbstractButton abstractButton = null;
                if (calendarEntry instanceof CalendarEventEntry) {
                    jMenu.setIcon(CalendarPlugin.EVENT_ICON);
                    jMenuItem = new JMenuItem(this.resourceMap.getString("label.event.open", new Object[0]));
                    abstractButton = new JMenuItem(this.resourceMap.getString("label.event.remove", new Object[0]));
                } else if (calendarEntry instanceof CalendarTodoEntry) {
                    jMenu.setIcon(CalendarPlugin.TODO_ICON);
                    jMenuItem = new JMenuItem(this.resourceMap.getString("label.task.open", new Object[0]));
                    abstractButton = new JMenuItem(this.resourceMap.getString("label.task.remove", new Object[0]));
                } else if (calendarEntry instanceof CalendarJournalEntry) {
                    jMenu.setIcon(CalendarPlugin.JOURNAL_ICON);
                    jMenuItem = new JMenuItem(this.resourceMap.getString("label.journal.open", new Object[0]));
                }
                if (jMenuItem != null) {
                    jMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ImmoToolUtils.executeTask((Task)new CalendarEntryViewTask(calendarEntry));
                        }
                    });
                }
                if (abstractButton != null) {
                    jMenu.add((JMenuItem)abstractButton);
                    abstractButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            CalendarEntryRemoveTask calendarEntryRemoveTask = new CalendarEntryRemoveTask(calendarEntry){

                                @Override
                                protected void succeeded(Boolean bl) {
                                    super.succeeded(bl);
                                    ImmoToolUtils.executeTask((Task)CalendarEntryDayPanel.this.doSearch());
                                }
                            };
                            ImmoToolUtils.executeTask((Task)calendarEntryRemoveTask);
                        }
                    });
                }
                this.actionsMenu.addSeparator();
                this.actionsMenu.add(jMenu);
            } else {
                javax.swing.Action[] actionArray;
                Class clazz = calendarEntry.getVirtualCalendarClassFromComment();
                if (clazz != null && this.virtualCalendars.containsKey(clazz) && (actionArray = this.virtualCalendars.get(clazz).getActions(calendarEntry)) != null && actionArray.length > 0) {
                    for (javax.swing.Action action : actionArray) {
                        jMenu.add(new JMenuItem(action));
                    }
                    this.actionsMenu.addSeparator();
                    this.actionsMenu.add(jMenu);
                }
            }
        }
        this.actionsMenu.show(jComponent, n, n2);
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.searchButton = new JButton();
        this.addButton = new JButton();
        this.actionButton = new JButton();
        this.helpButton = new JButton();
        this.closeButton = new JButton();
        this.formPanel = new JPanel();
        this.dayLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.nextPageButton = new JButton();
        this.todayPageButton = new JButton();
        this.prevPageButton = new JButton();
        this.dayTableScroller = new JScrollPane();
        this.dayTable = new CalendarDayTable();
        this.switchToFullViewButton = new JToggleButton();
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle("titleLabel");
        this.searchButton.setText("doSearch");
        this.addButton.setText("doAdd");
        this.actionButton.setText("doAction");
        this.helpButton.setText("doHelp");
        this.closeButton.setText("doClose");
        GroupLayout groupLayout = new GroupLayout(this.formPanel);
        this.formPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 742, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 41, Short.MAX_VALUE));
        this.dayLabel.setName("dayLabel");
        this.dayLabel.setTitle("dayLabel");
        this.nextPageButton.setText("doNextPage");
        this.todayPageButton.setText("doTodayPage");
        this.prevPageButton.setText("doPrevPage");
        this.dayTableScroller.setViewportView((Component)this.dayTable);
        this.switchToFullViewButton.setText("doSwitchToFullView");
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.dayTableScroller, GroupLayout.Alignment.LEADING, -1, 742, Short.MAX_VALUE).addComponent(this.formPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 255, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.searchButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton)).addGroup(groupLayout2.createSequentialGroup().addComponent((Component)this.dayLabel, -1, 167, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.switchToFullViewButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.prevPageButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.todayPageButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextPageButton))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.helpButton).addComponent(this.actionButton).addComponent(this.addButton).addComponent(this.searchButton)).addComponent((Component)this.titleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.formPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nextPageButton).addComponent(this.todayPageButton).addComponent(this.prevPageButton).addComponent(this.switchToFullViewButton)).addComponent((Component)this.dayLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dayTableScroller, -1, 315, Short.MAX_VALUE).addContainerGap()));
    }

    private static class CalendarTimeRenderer
    extends JLabel
    implements TableCellRenderer {
        private DateFormat formatter;

        public CalendarTimeRenderer() {
            this.setOpaque(true);
            this.formatter = new SimpleDateFormat("HH:mm");
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground(bl ? jTable.getSelectionBackground() : Color.WHITE);
            this.setForeground(bl ? jTable.getSelectionForeground() : Color.BLACK);
            if (object instanceof Date) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((Date)object);
                int n3 = calendar.get(12);
                String string = this.formatter.format(calendar.getTime());
                string = n3 == 0 ? "<b>" + string + "</b>" : "<span style=\"font-size:0.9em;\">" + string + "</span>";
                this.setText("<html>" + string + "</html>");
            } else {
                this.setText("");
            }
            return this;
        }
    }

    private class CalendarStatusRenderer
    extends JLabel
    implements ListCellRenderer {
        public CalendarStatusRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof Status) {
                Status status = (Status)object;
                if (CalendarEventEntry.CANCELLED.equals((Object)status)) {
                    this.setText(CalendarEventEntry.writeStatus(CalendarEventEntry.CANCELLED));
                } else if (CalendarEventEntry.CONFIRMED.equals((Object)status)) {
                    this.setText(CalendarEventEntry.writeStatus(CalendarEventEntry.CONFIRMED));
                } else if (CalendarEventEntry.TENTATIVE.equals((Object)status)) {
                    this.setText(CalendarEventEntry.writeStatus(CalendarEventEntry.TENTATIVE));
                } else if (CalendarTodoEntry.CANCELLED.equals((Object)status)) {
                    this.setText(CalendarTodoEntry.writeStatus(CalendarTodoEntry.CANCELLED));
                } else if (CalendarTodoEntry.COMPLETED.equals((Object)status)) {
                    this.setText(CalendarTodoEntry.writeStatus(CalendarTodoEntry.COMPLETED));
                } else if (CalendarTodoEntry.IN_PROCESS.equals((Object)status)) {
                    this.setText(CalendarTodoEntry.writeStatus(CalendarTodoEntry.IN_PROCESS));
                } else if (CalendarTodoEntry.NEEDS_ACTION.equals((Object)status)) {
                    this.setText(CalendarTodoEntry.writeStatus(CalendarTodoEntry.NEEDS_ACTION));
                } else if (CalendarJournalEntry.CANCELLED.equals((Object)status)) {
                    this.setText(CalendarJournalEntry.writeStatus(CalendarJournalEntry.CANCELLED));
                } else if (CalendarJournalEntry.DRAFT.equals((Object)status)) {
                    this.setText(CalendarJournalEntry.writeStatus(CalendarJournalEntry.DRAFT));
                } else if (CalendarJournalEntry.FINAL.equals((Object)status)) {
                    this.setText(CalendarJournalEntry.writeStatus(CalendarJournalEntry.FINAL));
                } else {
                    this.setText("");
                }
            } else {
                this.setText(n == 0 ? "[ " + CalendarEntryDayPanel.this.resourceMap.getString("label.search.status.all", new Object[0]) + " ]" : "");
            }
            return this;
        }
    }

    private class CalendarSourceRenderer
    extends JLabel
    implements ListCellRenderer {
        public CalendarSourceRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof CalendarSource) {
                this.setText(((CalendarSource)object).getName());
            } else if (object instanceof VirtualCalendarObject) {
                this.setText(((VirtualCalendarObject)object).getTitle());
            } else {
                this.setText(n == 0 ? "[ " + CalendarEntryDayPanel.this.resourceMap.getString("label.search.calendar.all", new Object[0]) + " ]" : "");
            }
            return this;
        }
    }

    private class CalendarEntryTableCellRenderer
    extends JXLabel
    implements TableCellRenderer {
        private transient Painter todayPainter;

        public CalendarEntryTableCellRenderer() {
            this.setOpaque(true);
            this.todayPainter = new PinstripePainter((Paint)Color.WHITE.darker().darker(), 30.0, 0.5, 8.5);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3;
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime((Date)jTable.getValueAt(n, 0));
            boolean bl4 = bl3 = calendar2.get(1) == calendar.get(1) && calendar2.get(2) == calendar.get(2) && calendar2.get(5) == calendar.get(5);
            if (object instanceof CalendarEntry) {
                Color color;
                boolean bl5 = n == 0 || jTable.getValueAt(n - 1, n2) == null;
                boolean bl6 = !bl5 && (n <= 1 || jTable.getValueAt(n - 2, n2) == null);
                boolean bl7 = !bl6 && (n <= 2 || jTable.getValueAt(n - 3, n2) == null);
                boolean bl8 = n == jTable.getRowCount() - 1 || (CalendarEntry)jTable.getValueAt(n + 1, n2) == null;
                CalendarEntry calendarEntry = (CalendarEntry)object;
                Color color2 = Color.WHITE;
                Color color3 = color = bl5 ? calendarEntry.getStatusColor() : null;
                if (color == null) {
                    color = Color.BLACK;
                }
                ImageIcon imageIcon = null;
                if (object instanceof CalendarEventEntry) {
                    imageIcon = bl5 ? CalendarPlugin.EVENT_ICON : null;
                    color2 = CalendarPlugin.EVENT_BG_COLOR;
                } else if (object instanceof CalendarJournalEntry) {
                    imageIcon = bl5 ? CalendarPlugin.JOURNAL_ICON : null;
                    color2 = CalendarPlugin.JOURNAL_BG_COLOR;
                } else if (object instanceof CalendarTodoEntry) {
                    imageIcon = bl5 ? CalendarPlugin.TODO_ICON : null;
                    color2 = CalendarPlugin.TODO_BG_COLOR;
                }
                String string = "";
                if (bl5) {
                    string = "<html>&nbsp;<b>" + calendarEntry.getSummaryString() + "</b></html>";
                } else if (bl6 && calendarEntry.getBegin() != null) {
                    string = "<html>" + CalendarEntryDayPanel.this.dateTimeBeginFormatter.format(calendarEntry.getBegin()) + "</html>";
                } else if (bl7 && calendarEntry.getEnd() != null) {
                    string = "<html>" + CalendarEntryDayPanel.this.dateTimeEndFormatter.format(calendarEntry.getEnd()) + "</html>";
                }
                this.setText(string);
                this.setIcon(imageIcon);
                Color color4 = bl ? jTable.getSelectionBackground() : color2;
                Color color5 = new Color(color4.getRed(), color4.getGreen(), color4.getBlue(), 100);
                this.setForeground(bl ? jTable.getSelectionForeground() : color);
                if (bl3) {
                    this.setBackgroundPainter((Painter)new CompoundPainter(new Painter[]{new MattePainter((Paint)(bl ? jTable.getSelectionBackground() : jTable.getBackground())), new MattePainter((Paint)color5), this.todayPainter}));
                } else {
                    this.setBackgroundPainter((Painter)new CompoundPainter(new Painter[]{new MattePainter((Paint)(bl ? jTable.getSelectionBackground() : jTable.getBackground())), new MattePainter((Paint)color5)}));
                }
                if (bl5 || bl8) {
                    this.setBorder(BorderFactory.createMatteBorder(bl5 ? 2 : 0, 0, bl8 ? 2 : 0, 0, color4));
                } else {
                    this.setBorder(Borders.EMPTY);
                }
            } else {
                this.setText("");
                this.setIcon(null);
                if (bl3) {
                    this.setBackgroundPainter((Painter)new CompoundPainter(new Painter[]{new MattePainter((Paint)(bl ? jTable.getSelectionBackground() : jTable.getBackground())), this.todayPainter}));
                } else {
                    this.setBackgroundPainter((Painter)new CompoundPainter(new Painter[]{new MattePainter((Paint)(bl ? jTable.getSelectionBackground() : jTable.getBackground()))}));
                }
                this.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
                this.setBorder(Borders.EMPTY);
            }
            return this;
        }
    }

    private class CalendarEntryListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public CalendarEntryListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof Integer) {
                Integer n2 = (Integer)object;
                if (n2 == 1) {
                    this.setText(CalendarEntryDayPanel.this.resourceMap.getString("label.event", new Object[0]));
                } else if (n2 == 2) {
                    this.setText(CalendarEntryDayPanel.this.resourceMap.getString("label.task", new Object[0]));
                } else if (n2 == 4) {
                    this.setText(CalendarEntryDayPanel.this.resourceMap.getString("label.journal", new Object[0]));
                } else {
                    this.setText("");
                }
            } else {
                this.setText(n == 0 ? "[ " + CalendarEntryDayPanel.this.resourceMap.getString("label.search.entries.all", new Object[0]) + " ]" : "");
            }
            return this;
        }
    }

    private class CalendarDayTable
    extends JXTable {
        private CalendarDayTable() {
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.columnAtPoint(mouseEvent.getPoint());
            int n2 = this.rowAtPoint(mouseEvent.getPoint());
            if (n < 0 || n2 < 0) {
                return null;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)this.getValueAt(n2, 0));
            String string = "";
            string = n <= 0 ? "<b>" + CalendarEntryDayPanel.this.timeFormatter.format(calendar.getTime()) + "</b>" : CalendarEntryDayPanel.this.toolTipFormatter.format(calendar.getTime()) + "<hr>";
            if (n > 0) {
                CalendarEntry calendarEntry = (CalendarEntry)this.getValueAt(n2, n);
                if (calendarEntry == null) {
                    string = string + "<i>" + CalendarEntryDayPanel.this.resourceMap.getString("label.noEntries", new Object[0]) + "</i>";
                } else {
                    String string2;
                    string = string + "<p style=\"margin-top:3px; margin-bottom:3px;\">";
                    string = string + "<b>" + calendarEntry.getSummaryString() + "</b>";
                    Color color = calendarEntry.getStatusColor();
                    if (color == null) {
                        color = Color.BLACK;
                    }
                    if ((string2 = calendarEntry.writeStatus()) != null && string2.trim().length() > 0) {
                        string = string + "<br>\u00bb <span style=\"color:#" + ImmoToolUtils.writeHexColor((Color)color) + "\">" + string2 + "</span>";
                    }
                    if (calendarEntry.getBegin() != null) {
                        string = string + "<br>\u00bb " + CalendarEntryDayPanel.this.dateTimeBeginFormatter.format(calendarEntry.getBegin()).trim();
                    }
                    if (calendarEntry.getEnd() != null) {
                        string = string + "<br>\u00bb " + CalendarEntryDayPanel.this.dateTimeEndFormatter.format(calendarEntry.getEnd()).trim();
                    }
                    string = string + "</p>";
                }
            }
            return "<html><div style=\"margin:5px;\">" + string + "</div></html>";
        }
    }
}

