/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.ResourceMap;

public class CalendarEntryMonthModel
extends DefaultTableModel {
    public static final int COLUMN_WEEK = 0;
    public static final int COLUMN_DAY1 = 1;
    public static final int COLUMN_DAY2 = 2;
    public static final int COLUMN_DAY3 = 3;
    public static final int COLUMN_DAY4 = 4;
    public static final int COLUMN_DAY5 = 5;
    public static final int COLUMN_DAY6 = 6;
    public static final int COLUMN_DAY7 = 7;
    private static final Map<Integer, String> COLUMN_NAMES = new HashMap<Integer, String>();
    private static final Map<Integer, Class> COLUMN_CLASSES;
    private final ResourceMap resourceMap = ImmoToolUtils.getResourceMap(CalendarEntryMonthModel.class);

    public CalendarEntryMonthModel() {
        this.setColumnCount(COLUMN_NAMES.size());
    }

    public void addCalendarEntries(CalendarEntry[] calendarEntryArray, Date date) {
        if (calendarEntryArray == null || calendarEntryArray.length == 0) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 2);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        int n = -1;
        int n2 = -1;
        while (true) {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTimeInMillis(calendar.getTimeInMillis());
            calendar2.set(11, 0);
            calendar2.set(12, 0);
            calendar2.set(13, 0);
            calendar2.set(14, 0);
            ArrayList<CalendarEntry> arrayList = new ArrayList<CalendarEntry>();
            for (CalendarEntry calendarEntry : calendarEntryArray) {
                Calendar calendar3 = Calendar.getInstance();
                calendar3.setTimeInMillis(calendar2.getTimeInMillis());
                calendar3.add(10, 24);
                Date date2 = calendarEntry.getBegin();
                Date date3 = calendarEntry.getEnd();
                if (date2 == null || date2.getTime() >= calendar3.getTimeInMillis() || (date3 != null || date2.getTime() < calendar2.getTimeInMillis()) && (date3 == null || date3.getTime() <= calendar2.getTimeInMillis())) continue;
                arrayList.add(calendarEntry);
            }
            if (calendar.get(7) == 2) {
                ++n;
                n2 = 1;
            } else {
                n2 = calendar.get(7) == 1 ? this.getColumnCount() - 1 : ++n2;
            }
            if (this.getRowCount() <= n) break;
            CalendarEntry[] calendarEntryArray2 = arrayList.toArray(new CalendarEntry[arrayList.size()]);
            this.setValueAt(calendarEntryArray2, n, n2);
            calendar.add(7, 1);
        }
    }

    public void clear() {
        Calendar calendar = Calendar.getInstance();
        this.clear(calendar.get(1), calendar.get(2));
    }

    public void clear(int n, int n2) {
        block2: {
            while (this.getRowCount() > 0) {
                this.removeRow(0);
            }
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, n);
            calendar.set(2, n2);
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            while (calendar.get(2) <= n2 && calendar.get(1) == n) {
                this.writeWeek(calendar, n2);
                calendar.add(3, 1);
            }
            calendar.set(7, 2);
            if (calendar.get(2) != n2) break block2;
            this.writeWeek(calendar, n2);
        }
    }

    public Class getColumnClass(int n) {
        return COLUMN_CLASSES.containsKey(n) ? COLUMN_CLASSES.get(n) : null;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES.containsKey(n) ? this.resourceMap.getString(COLUMN_NAMES.get(n), new Object[0]) : null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    private void writeWeek(Calendar calendar, int n) {
        ArrayList<Date> arrayList = new ArrayList<Date>();
        while (calendar.get(7) != 2) {
            calendar.add(7, -1);
        }
        arrayList.add(calendar.getTime());
        while (true) {
            arrayList.add(null);
            if (calendar.get(7) == 1) break;
            calendar.add(7, 1);
        }
        this.addRow(arrayList.toArray(new Object[arrayList.size()]));
    }

    static {
        COLUMN_NAMES.put(0, "col.week");
        COLUMN_NAMES.put(1, "col.monday");
        COLUMN_NAMES.put(2, "col.tuesday");
        COLUMN_NAMES.put(3, "col.wednesday");
        COLUMN_NAMES.put(4, "col.thursday");
        COLUMN_NAMES.put(5, "col.friday");
        COLUMN_NAMES.put(6, "col.saturday");
        COLUMN_NAMES.put(7, "col.sunday");
        COLUMN_CLASSES = new HashMap<Integer, Class>();
        COLUMN_CLASSES.put(0, Date.class);
        COLUMN_CLASSES.put(1, CalendarEntry[].class);
        COLUMN_CLASSES.put(2, CalendarEntry[].class);
        COLUMN_CLASSES.put(3, CalendarEntry[].class);
        COLUMN_CLASSES.put(4, CalendarEntry[].class);
        COLUMN_CLASSES.put(5, CalendarEntry[].class);
        COLUMN_CLASSES.put(6, CalendarEntry[].class);
        COLUMN_CLASSES.put(7, CalendarEntry[].class);
    }
}

