/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolTabPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarEntryMonthModel;
import com.openindex.openestate.tool.calendar.CalendarEntryRemoveTask;
import com.openindex.openestate.tool.calendar.CalendarEntryViewPanel;
import com.openindex.openestate.tool.calendar.CalendarEntryViewTask;
import com.openindex.openestate.tool.calendar.CalendarEventEntry;
import com.openindex.openestate.tool.calendar.CalendarJournalEntry;
import com.openindex.openestate.tool.calendar.CalendarObject;
import com.openindex.openestate.tool.calendar.CalendarPlugin;
import com.openindex.openestate.tool.calendar.CalendarSource;
import com.openindex.openestate.tool.calendar.CalendarTodoEntry;
import com.openindex.openestate.tool.calendar.VirtualCalendarObject;
import com.openindex.openestate.tool.utils.TabComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.fortuna.ical4j.model.property.Status;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.PinstripePainter;

public class CalendarEntryMonthPanel
extends ImmoToolTabPanel {
    private static final Logger LOGGER = Logger.getLogger(CalendarEntryMonthPanel.class);
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private JPopupMenu actionsMenu;
    private JPopupMenu addMenu;
    private CalendarEntryMonthModel monthTableModel;
    private JComboBox searchCalendarBox;
    private JComboBox searchEntryBox;
    private JComboBox searchStatusBox;
    private JSpinner searchMonthField;
    private DateFormat dateTimeBeginFormatter;
    private DateFormat dateTimeEndFormatter;
    private DateFormat fullTitleFormatter;
    private DateFormat monthFormatter;
    private DateFormat weekNumberFormatter;
    private Map<Class, VirtualCalendarObject> virtualCalendars;
    private int selectedMonth = -1;
    private int selectedYear = -1;
    private boolean isSearching = false;
    private JButton actionButton;
    private JButton addButton;
    private JButton closeButton;
    private JPanel formPanel;
    private JButton helpButton;
    private JXTitledSeparator monthLabel;
    private JXTable monthTable;
    private JScrollPane monthTableScroller;
    private JButton nextPageButton;
    private JButton prevPageButton;
    private JButton searchButton;
    private JXTitledSeparator titleLabel;
    private JButton todayPageButton;

    public CalendarEntryMonthPanel() {
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(CalendarEntryMonthPanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(CalendarEntryMonthPanel.class);
        this.initComponents();
        this.buildFormPanel();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.virtualCalendars = new HashMap<Class, VirtualCalendarObject>();
        try {
            for (VirtualCalendarObject virtualCalendarObject : VirtualCalendarObject.getUsableCalendars()) {
                this.virtualCalendars.put(virtualCalendarObject.getClass(), virtualCalendarObject);
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't load virtual calendars!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        this.dateTimeBeginFormatter = new SimpleDateFormat(this.resourceMap.getString("format.dateTime.begin", new Object[0]));
        this.dateTimeEndFormatter = new SimpleDateFormat(this.resourceMap.getString("format.dateTime.end", new Object[0]));
        this.fullTitleFormatter = new SimpleDateFormat(this.resourceMap.getString("format.full.title", new Object[0]));
        this.monthFormatter = new SimpleDateFormat(this.resourceMap.getString("format.month", new Object[0]));
        this.weekNumberFormatter = new SimpleDateFormat(this.resourceMap.getString("format.weekNumber", new Object[0]));
        this.actionsMenu = new JPopupMenu();
        this.addMenu = new JPopupMenu();
        this.addMenu.add(new JMenuItem(this.actionMap.get("doAddTodo")));
        this.addMenu.add(new JMenuItem(this.actionMap.get("doAddEvent")));
        ImmoToolUtils.configureTable((JXTable)this.monthTable);
        this.monthTableModel = new CalendarEntryMonthModel();
        this.monthTable.setModel((TableModel)this.monthTableModel);
        this.monthTable.setRowHeight(100);
        this.monthTable.getTableHeader().setReorderingAllowed(false);
        this.monthTable.getColumn(0).setMaxWidth(30);
        this.monthTable.getColumn(0).setMinWidth(30);
        this.monthTable.setColumnSelectionAllowed(true);
        this.monthTable.setRowSelectionAllowed(true);
        this.monthTable.setSortable(false);
        this.monthTable.setShowGrid(true);
        this.monthTable.setGridColor(Color.GRAY);
        this.monthTable.setColumnMargin(1);
        this.monthTable.setRowMargin(0);
        this.monthTable.setDefaultRenderer(Date.class, (TableCellRenderer)new CalendarWeekRenderer());
        this.monthTable.setDefaultRenderer(CalendarEntry[].class, (TableCellRenderer)new CalendarEntriesRenderer());
        this.monthTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 || mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
                    int n = CalendarEntryMonthPanel.this.monthTable.rowAtPoint(mouseEvent.getPoint());
                    if (n < 0) {
                        n = CalendarEntryMonthPanel.this.monthTable.getSelectedRow();
                    }
                    if (n < 0) {
                        return;
                    }
                    int n2 = CalendarEntryMonthPanel.this.monthTable.columnAtPoint(mouseEvent.getPoint());
                    if (n2 < 0) {
                        n2 = CalendarEntryMonthPanel.this.monthTable.getSelectedColumn();
                    }
                    if (n2 < 0) {
                        return;
                    }
                    if (n >= 0 && n != CalendarEntryMonthPanel.this.monthTable.getSelectedRow() || n2 >= 0 && n2 != CalendarEntryMonthPanel.this.monthTable.getSelectedColumn()) {
                        CalendarEntryMonthPanel.this.monthTable.clearSelection();
                        CalendarEntryMonthPanel.this.monthTable.changeSelection(n, n2, false, false);
                    }
                    CalendarEntryMonthPanel.this.showActions((JComponent)CalendarEntryMonthPanel.this.monthTable, ((CalendarEntryMonthPanel)CalendarEntryMonthPanel.this).monthTable.getMousePosition().x, ((CalendarEntryMonthPanel)CalendarEntryMonthPanel.this).monthTable.getMousePosition().y);
                }
            }
        });
        this.monthTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CalendarEntryMonthPanel.this.actionButton.setEnabled(CalendarEntryMonthPanel.this.monthTable.getSelectedRow() >= 0 && CalendarEntryMonthPanel.this.monthTable.getSelectedColumn() > 0);
            }
        });
        this.nextPageButton.setAction(this.actionMap.get(this.nextPageButton.getText()));
        this.prevPageButton.setAction(this.actionMap.get(this.prevPageButton.getText()));
        this.todayPageButton.setAction(this.actionMap.get(this.todayPageButton.getText()));
        this.searchButton.setAction(this.actionMap.get(this.searchButton.getText()));
        this.addButton.setAction(this.actionMap.get(this.addButton.getText()));
        this.closeButton.setAction(this.actionMap.get(this.closeButton.getText()));
        this.helpButton.setAction(this.actionMap.get(this.helpButton.getText()));
        this.actionButton.setAction(this.actionMap.get(this.actionButton.getText()));
        this.actionButton.setEnabled(false);
        this.searchEntryBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CalendarEntryMonthPanel.this.searchEntryBox.isEnabled()) {
                    return;
                }
                int n = CalendarEntryMonthPanel.this.searchEntryBox.getSelectedIndex();
                CalendarEntryMonthPanel.this.searchStatusBox.setEnabled(false);
                CalendarEntryMonthPanel.this.searchStatusBox.removeAllItems();
                CalendarEntryMonthPanel.this.searchStatusBox.addItem(null);
                if (n > 0) {
                    Integer n2 = (Integer)CalendarEntryMonthPanel.this.searchEntryBox.getItemAt(n);
                    Status[] statusArray = null;
                    statusArray = n2 == 1 ? CalendarEventEntry.getStatusOptions() : (n2 == 2 ? CalendarTodoEntry.getStatusOptions() : (n2 == 4 ? CalendarJournalEntry.getStatusOptions() : new Status[]{}));
                    for (Status status : statusArray) {
                        CalendarEntryMonthPanel.this.searchStatusBox.addItem(status);
                    }
                    CalendarEntryMonthPanel.this.searchStatusBox.setSelectedIndex(0);
                }
                CalendarEntryMonthPanel.this.searchStatusBox.setEnabled(true);
            }
        });
    }

    private void buildFormPanel() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && !CalendarEntryMonthPanel.this.isSearching) {
                    ImmoToolUtils.executeTask((Task)CalendarEntryMonthPanel.this.doSearch());
                }
            }
        };
        this.searchCalendarBox = new JComboBox();
        this.searchCalendarBox.setName("searchCalendarBox");
        this.searchCalendarBox.addItem(null);
        this.searchCalendarBox.setRenderer(new CalendarSourceRenderer());
        this.searchEntryBox = new JComboBox();
        this.searchEntryBox.setName("searchEntryBox");
        this.searchEntryBox.addItem(null);
        this.searchEntryBox.addItem(1);
        this.searchEntryBox.addItem(2);
        this.searchEntryBox.addItem(4);
        this.searchEntryBox.setRenderer(new CalendarEntryRenderer());
        this.searchStatusBox = new JComboBox();
        this.searchStatusBox.setName("searchStatusBox");
        this.searchStatusBox.addItem(null);
        this.searchStatusBox.setRenderer(new CalendarStatusRenderer());
        this.searchStatusBox.setEnabled(false);
        this.searchMonthField = new JSpinner(new SpinnerDateModel());
        ((SpinnerDateModel)this.searchMonthField.getModel()).setCalendarField(2);
        this.searchMonthField.setName("searchMonthField");
        this.searchMonthField.setEditor(new JSpinner.DateEditor(this.searchMonthField, "MMMMM yyyy"));
        this.searchMonthField.getEditor().addKeyListener(keyAdapter);
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, pref:grow, 3dlu, right:pref, 3dlu, pref:grow", (JPanel)this.formPanel);
        defaultFormBuilder.append(this.resourceMap.getString("label.search.calendar", new Object[0]), (Component)this.searchCalendarBox);
        defaultFormBuilder.append(this.resourceMap.getString("label.search.entries", new Object[0]), (Component)this.searchEntryBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.search.month", new Object[0]), (Component)this.searchMonthField);
        defaultFormBuilder.append(this.resourceMap.getString("label.search.status", new Object[0]), (Component)this.searchStatusBox);
        defaultFormBuilder.nextLine();
        this.formPanel.revalidate();
        this.formPanel.repaint();
    }

    @Action
    public void doAction() {
        this.showActions(this.actionButton, 0, this.actionButton.getSize().height);
    }

    @Action
    public void doAdd() {
        this.addMenu.show(this.addButton, 0, this.addButton.getSize().height);
    }

    @Action
    public Task doAddEvent() {
        String string = CalendarEntryViewPanel.getInstanceTabTitle((String)null, 0L, 0);
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<CalendarEntryViewPanel>(){

            protected CalendarEntryViewPanel executeTask() throws Exception {
                CalendarEntryViewPanel calendarEntryViewPanel = new CalendarEntryViewPanel(0);
                calendarEntryViewPanel.setCalendarEntry(null);
                calendarEntryViewPanel.setEditable(true);
                int n = CalendarEntryMonthPanel.this.monthTable.getSelectedRow();
                int n2 = CalendarEntryMonthPanel.this.monthTable.getSelectedColumn();
                if (n >= 0 && n2 > 0) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime((Date)CalendarEntryMonthPanel.this.monthTable.getValueAt(n, 0));
                    calendar.add(10, 24 * (n2 - 1));
                    calendarEntryViewPanel.setDateInterval(calendar.getTime(), null);
                }
                return calendarEntryViewPanel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarEntryMonthPanel.this.resourceMap.getString("error.cantCreateForm", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                CalendarEntryMonthPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(CalendarEntryViewPanel calendarEntryViewPanel) {
                super.succeeded((Object)calendarEntryViewPanel);
                calendarEntryViewPanel.executeFormTasks();
                ImmoToolUtils.showPanel((TabComponent)calendarEntryViewPanel);
            }
        };
    }

    @Action
    public Task doAddTodo() {
        String string = CalendarEntryViewPanel.getInstanceTabTitle((String)null, 0L, 1);
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<CalendarEntryViewPanel>(){

            protected CalendarEntryViewPanel executeTask() throws Exception {
                CalendarEntryViewPanel calendarEntryViewPanel = new CalendarEntryViewPanel(1);
                calendarEntryViewPanel.setCalendarEntry(null);
                calendarEntryViewPanel.setEditable(true);
                int n = CalendarEntryMonthPanel.this.monthTable.getSelectedRow();
                int n2 = CalendarEntryMonthPanel.this.monthTable.getSelectedColumn();
                if (n >= 0 && n2 > 0) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime((Date)CalendarEntryMonthPanel.this.monthTable.getValueAt(n, 0));
                    calendar.add(10, 24 * (n2 - 1));
                    calendarEntryViewPanel.setDateInterval(calendar.getTime(), null);
                }
                return calendarEntryViewPanel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarEntryMonthPanel.this.resourceMap.getString("error.cantCreateForm", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                CalendarEntryMonthPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(CalendarEntryViewPanel calendarEntryViewPanel) {
                super.succeeded((Object)calendarEntryViewPanel);
                calendarEntryViewPanel.executeFormTasks();
                ImmoToolUtils.showPanel((TabComponent)calendarEntryViewPanel);
            }
        };
    }

    @Action
    public void doClose() {
        ImmoToolUtils.removePanel((String)this.getTabTitle());
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog((String)"calendar.entries");
    }

    @Action
    public Task doNextPage() {
        try {
            this.searchMonthField.commitEdit();
        }
        catch (Exception exception) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidMonth", new Object[0]), (Throwable)exception);
            return null;
        }
        this.searchMonthField.setValue(this.searchMonthField.getNextValue());
        return this.doSearch();
    }

    @Action
    public Task doPrevPage() {
        try {
            this.searchMonthField.commitEdit();
        }
        catch (Exception exception) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidMonth", new Object[0]), (Throwable)exception);
            return null;
        }
        this.searchMonthField.setValue(this.searchMonthField.getPreviousValue());
        return this.doSearch();
    }

    @Action
    public Task doSearch() {
        try {
            this.searchMonthField.commitEdit();
        }
        catch (Exception exception) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidMonth", new Object[0]), (Throwable)exception);
            return null;
        }
        this.monthTable.setEnabled(false);
        this.setButtonsEnabled(false);
        final Integer n = this.searchEntryBox.isEnabled() ? (Integer)this.searchEntryBox.getSelectedItem() : null;
        final Status status = this.searchStatusBox.isEnabled() ? (Status)this.searchStatusBox.getSelectedItem() : null;
        final Object object = this.searchCalendarBox != null ? this.searchCalendarBox.getSelectedItem() : null;
        return new ImmoToolTask<CalendarObject>(){

            protected CalendarObject executeTask() throws Exception {
                CalendarObject calendarObject = new CalendarObject();
                if (object instanceof VirtualCalendarObject) {
                    VirtualCalendarObject virtualCalendarObject = (VirtualCalendarObject)object;
                    CalendarEntry[] calendarEntryArray = null;
                    if (n == null) {
                        calendarEntryArray = virtualCalendarObject.getEntries();
                    } else if (n == 1) {
                        calendarEntryArray = virtualCalendarObject.getEventEntries();
                    } else if (n == 2) {
                        calendarEntryArray = virtualCalendarObject.getTodoEntries();
                    } else if (n == 4) {
                        calendarEntryArray = virtualCalendarObject.getJournalEntries();
                    } else {
                        throw new Exception("Unknown entry-type: " + n);
                    }
                    for (CalendarEntry calendarEntry : calendarEntryArray) {
                        if (status != null && !calendarEntry.getStatus().equals((Object)status)) continue;
                        calendarObject.add(calendarEntry);
                    }
                } else if (object instanceof CalendarSource) {
                    CalendarEntry[] calendarEntryArray;
                    CalendarSource calendarSource = (CalendarSource)object;
                    int n2 = 0;
                    if (n != null) {
                        n2 = n;
                    } else {
                        n2 |= 1;
                        n2 |= 4;
                        n2 |= 2;
                    }
                    for (CalendarEntry calendarEntry : calendarEntryArray = CalendarObject.search(new long[]{calendarSource.getCalendarId()}, status, n2)) {
                        calendarObject.add(calendarEntry);
                    }
                } else {
                    int n3 = 0;
                    if (n != null) {
                        n3 = n;
                    } else {
                        n3 |= 1;
                        n3 |= 4;
                        n3 |= 2;
                    }
                    CalendarEntry[] calendarEntryArray = CalendarObject.search(null, status, n3);
                    for (CalendarEntry calendarEntry : calendarEntryArray) {
                        calendarObject.add(calendarEntry);
                    }
                    for (VirtualCalendarObject virtualCalendarObject : CalendarEntryMonthPanel.this.virtualCalendars.values()) {
                        calendarEntryArray = null;
                        if (n == null) {
                            calendarEntryArray = virtualCalendarObject.getEntries();
                        } else if (n == 1) {
                            calendarEntryArray = virtualCalendarObject.getEventEntries();
                        } else if (n == 2) {
                            calendarEntryArray = virtualCalendarObject.getTodoEntries();
                        } else if (n == 4) {
                            calendarEntryArray = virtualCalendarObject.getJournalEntries();
                        } else {
                            throw new Exception("Unknown entry-type: " + n);
                        }
                        for (CalendarEntry calendarEntry : calendarEntryArray) {
                            if (status != null && !calendarEntry.getStatus().equals((Object)status)) continue;
                            calendarObject.add(calendarEntry);
                        }
                    }
                }
                return calendarObject;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarEntryMonthPanel.this.resourceMap.getString("error.cantExecuteSearch", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                CalendarEntryMonthPanel.this.monthTable.setEnabled(true);
                CalendarEntryMonthPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(CalendarObject calendarObject) {
                super.succeeded((Object)calendarObject);
                Date date = (Date)CalendarEntryMonthPanel.this.searchMonthField.getValue();
                Calendar calendar = Calendar.getInstance();
                if (date == null) {
                    calendar.setTimeInMillis(0L);
                } else {
                    calendar.setTime(date);
                }
                calendar.set(5, 1);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                CalendarEntryMonthPanel.this.selectedMonth = calendar.get(2);
                CalendarEntryMonthPanel.this.selectedYear = calendar.get(1);
                Calendar calendar2 = Calendar.getInstance();
                calendar2.setTimeInMillis(calendar.getTimeInMillis());
                Calendar calendar3 = Calendar.getInstance();
                calendar3.setTimeInMillis(calendar.getTimeInMillis());
                calendar3.set(7, 2);
                Calendar calendar4 = Calendar.getInstance();
                calendar4.setTimeInMillis(calendar.getTimeInMillis());
                calendar4.add(2, 1);
                calendar4.add(14, -1);
                if (calendar4.get(7) != 1) {
                    calendar4.set(7, 1);
                }
                ArrayList<CalendarEntry> arrayList = new ArrayList<CalendarEntry>();
                arrayList.addAll(Arrays.asList(calendarObject.filterEntries(calendar3.getTime(), calendar4.getTime(), true)));
                CalendarEntryMonthPanel.this.monthTableModel.clear(CalendarEntryMonthPanel.this.selectedYear, CalendarEntryMonthPanel.this.selectedMonth);
                CalendarEntryMonthPanel.this.monthTableModel.addCalendarEntries(arrayList.toArray(new CalendarEntry[arrayList.size()]), calendar2.getTime());
                CalendarEntryMonthPanel.this.monthTable.getColumn(0).setMaxWidth(30);
                CalendarEntryMonthPanel.this.monthTable.getColumn(0).setMinWidth(30);
                for (int i = 1; i < CalendarEntryMonthPanel.this.monthTable.getColumnCount() - 1; ++i) {
                    CalendarEntryMonthPanel.this.monthTable.packColumn(i, 5, 100);
                }
                CalendarEntryMonthPanel.this.monthLabel.setTitle(CalendarEntryMonthPanel.this.resourceMap.getString("monthLabel.title", new Object[0]) + " / " + CalendarEntryMonthPanel.this.monthFormatter.format(calendar2.getTime()));
            }
        };
    }

    @Action
    public Task doTodayPage() {
        try {
            this.searchMonthField.commitEdit();
        }
        catch (Exception exception) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidMonth", new Object[0]), (Throwable)exception);
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.searchMonthField.setValue(calendar.getTime());
        return this.doSearch();
    }

    public static String getInstanceTabTitle() {
        return ImmoToolUtils.getResourceMap(CalendarEntryMonthPanel.class).getString("tabTitle", new Object[0]);
    }

    public String getTabInfo() {
        return this.resourceMap.getString("tabInfo", new Object[0]);
    }

    public String getTabTitle() {
        return CalendarEntryMonthPanel.getInstanceTabTitle();
    }

    public void loadSources() throws ImmoToolDbException {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        for (CalendarSource calendarSource : CalendarSource.loadSources()) {
            String string = calendarSource.getName();
            int n = 0;
            while (treeMap.containsKey(string)) {
                string = calendarSource.getName() + "_" + n;
            }
            treeMap.put(string, calendarSource);
        }
        try {
            for (VirtualCalendarObject virtualCalendarObject : this.virtualCalendars.values()) {
                String string = virtualCalendarObject.getTitle();
                int n = 0;
                while (treeMap.containsKey(string)) {
                    string = virtualCalendarObject.getTitle() + "_" + n;
                }
                treeMap.put(string, virtualCalendarObject);
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't load virtual calendars!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        this.searchCalendarBox.setEnabled(false);
        this.searchCalendarBox.removeAllItems();
        this.searchCalendarBox.addItem(null);
        for (Object e : treeMap.values()) {
            this.searchCalendarBox.addItem(e);
        }
        this.searchCalendarBox.setSelectedIndex(0);
        this.searchCalendarBox.setEnabled(true);
    }

    public void refreshTab() {
        ImmoToolUtils.executeTask((Task)this.doSearch());
    }

    private void setButtonsEnabled(boolean bl) {
        this.addButton.setEnabled(bl);
        this.searchButton.setEnabled(bl);
        this.actionButton.setEnabled(bl && this.monthTable.getSelectedRowCount() > 0);
        this.nextPageButton.setEnabled(bl);
        this.prevPageButton.setEnabled(bl);
        this.todayPageButton.setEnabled(bl);
        this.searchMonthField.setEnabled(bl);
    }

    private void showActions(JComponent jComponent, int n, int n2) {
        int n3 = this.monthTable.getSelectedRow();
        int n4 = this.monthTable.getSelectedColumn();
        if (n3 < 0 || n4 < 0) {
            return;
        }
        this.actionsMenu.setVisible(false);
        this.actionsMenu.removeAll();
        Date date = (Date)this.monthTable.getValueAt(n3, 0);
        if (n4 == 0) {
            this.actionsMenu.add(new JLabel("<html>&nbsp;<b>" + this.weekNumberFormatter.format(date) + "</b></html>"));
            this.actionsMenu.show(jComponent, n, n2);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(11, 24 * (n4 - 1));
        JLabel jLabel = new JLabel("<html>" + this.fullTitleFormatter.format(calendar.getTime()) + "</html>");
        jLabel.setOpaque(true);
        jLabel.setBackground(Color.WHITE);
        this.actionsMenu.add(jLabel);
        this.actionsMenu.addSeparator();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doAddEvent")));
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doAddTodo")));
        CalendarEntry[] calendarEntryArray = (CalendarEntry[])this.monthTable.getValueAt(n3, n4);
        if (calendarEntryArray == null || calendarEntryArray.length == 0) {
            this.actionsMenu.show(jComponent, n, n2);
            return;
        }
        boolean bl = false;
        for (final CalendarEntry calendarEntry : calendarEntryArray) {
            Object object;
            Serializable serializable;
            if (calendarEntry == null) continue;
            JMenu jMenu = new JMenu(calendarEntry.getSummaryString());
            if (calendarEntry.getCalendarId() > 0L) {
                serializable = null;
                object = null;
                if (calendarEntry instanceof CalendarEventEntry) {
                    jMenu.setIcon(CalendarPlugin.EVENT_ICON);
                    serializable = new JMenuItem(this.resourceMap.getString("label.event.open", new Object[0]));
                    object = new JMenuItem(this.resourceMap.getString("label.event.remove", new Object[0]));
                } else if (calendarEntry instanceof CalendarTodoEntry) {
                    jMenu.setIcon(CalendarPlugin.TODO_ICON);
                    serializable = new JMenuItem(this.resourceMap.getString("label.task.open", new Object[0]));
                    object = new JMenuItem(this.resourceMap.getString("label.task.remove", new Object[0]));
                } else if (calendarEntry instanceof CalendarJournalEntry) {
                    jMenu.setIcon(CalendarPlugin.JOURNAL_ICON);
                    serializable = new JMenuItem(this.resourceMap.getString("label.journal.open", new Object[0]));
                }
                if (serializable != null) {
                    jMenu.add((JMenuItem)serializable);
                    ((AbstractButton)serializable).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ImmoToolUtils.executeTask((Task)new CalendarEntryViewTask(calendarEntry));
                        }
                    });
                }
                if (object != null) {
                    jMenu.add((JMenuItem)object);
                    object.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            CalendarEntryRemoveTask calendarEntryRemoveTask = new CalendarEntryRemoveTask(calendarEntry){

                                @Override
                                protected void succeeded(Boolean bl) {
                                    super.succeeded(bl);
                                    ImmoToolUtils.executeTask((Task)CalendarEntryMonthPanel.this.doSearch());
                                }
                            };
                            ImmoToolUtils.executeTask((Task)calendarEntryRemoveTask);
                        }
                    });
                }
                if (!bl) {
                    this.actionsMenu.addSeparator();
                }
                bl = true;
                this.actionsMenu.add(jMenu);
                continue;
            }
            serializable = calendarEntry.getVirtualCalendarClassFromComment();
            if (serializable == null || !this.virtualCalendars.containsKey(serializable) || (object = this.virtualCalendars.get(serializable).getActions(calendarEntry)) == null || ((javax.swing.Action[])object).length == 0) continue;
            for (javax.swing.Action action : object) {
                jMenu.add(new JMenuItem(action));
            }
            if (!bl) {
                this.actionsMenu.addSeparator();
            }
            bl = true;
            this.actionsMenu.add(jMenu);
        }
        this.actionsMenu.show(jComponent, n, n2);
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.searchButton = new JButton();
        this.addButton = new JButton();
        this.actionButton = new JButton();
        this.helpButton = new JButton();
        this.closeButton = new JButton();
        this.formPanel = new JPanel();
        this.monthLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.prevPageButton = new JButton();
        this.todayPageButton = new JButton();
        this.nextPageButton = new JButton();
        this.monthTableScroller = new JScrollPane();
        this.monthTable = new CalendarMonthTable();
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle("titleLabel");
        this.searchButton.setText("doSearch");
        this.searchButton.setName("searchButton");
        this.addButton.setText("doAdd");
        this.addButton.setName("addButton");
        this.actionButton.setText("doAction");
        this.actionButton.setName("actionButton");
        this.helpButton.setText("doHelp");
        this.helpButton.setName("helpButton");
        this.closeButton.setText("doClose");
        this.closeButton.setName("closeButton");
        this.formPanel.setName("formPanel");
        GroupLayout groupLayout = new GroupLayout(this.formPanel);
        this.formPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 762, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 41, Short.MAX_VALUE));
        this.monthLabel.setName("monthLabel");
        this.monthLabel.setTitle("monthLabel");
        this.prevPageButton.setText("doPrevPage");
        this.prevPageButton.setName("prevPageButton");
        this.todayPageButton.setText("doTodayPage");
        this.todayPageButton.setName("todayPageButton");
        this.nextPageButton.setText("doNextPage");
        this.nextPageButton.setName("nextPageButton");
        this.monthTableScroller.setName("monthTableScroller");
        this.monthTable.setName("monthTable");
        this.monthTableScroller.setViewportView((Component)this.monthTable);
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.monthTableScroller, GroupLayout.Alignment.TRAILING, -1, 762, Short.MAX_VALUE).addComponent(this.formPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 275, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.searchButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addComponent((Component)this.monthLabel, -1, 368, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.prevPageButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.todayPageButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextPageButton))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.helpButton).addComponent(this.actionButton).addComponent(this.addButton).addComponent(this.searchButton)).addComponent((Component)this.titleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.formPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nextPageButton).addComponent(this.todayPageButton).addComponent(this.prevPageButton)).addComponent((Component)this.monthLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.monthTableScroller, -1, 333, Short.MAX_VALUE).addContainerGap()));
    }

    private static class CalendarWeekRenderer
    extends JLabel
    implements TableCellRenderer {
        private DateFormat weekFormatter = new SimpleDateFormat("w");

        public CalendarWeekRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, jTable.getGridColor()));
            if (object instanceof Date) {
                this.setText(this.weekFormatter.format((Date)object));
            } else {
                this.setText("");
            }
            return this;
        }
    }

    private class CalendarStatusRenderer
    extends JLabel
    implements ListCellRenderer {
        public CalendarStatusRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof Status) {
                Status status = (Status)object;
                if (CalendarEventEntry.CANCELLED.equals((Object)status)) {
                    this.setText(CalendarEventEntry.writeStatus(CalendarEventEntry.CANCELLED));
                } else if (CalendarEventEntry.CONFIRMED.equals((Object)status)) {
                    this.setText(CalendarEventEntry.writeStatus(CalendarEventEntry.CONFIRMED));
                } else if (CalendarEventEntry.TENTATIVE.equals((Object)status)) {
                    this.setText(CalendarEventEntry.writeStatus(CalendarEventEntry.TENTATIVE));
                } else if (CalendarTodoEntry.CANCELLED.equals((Object)status)) {
                    this.setText(CalendarTodoEntry.writeStatus(CalendarTodoEntry.CANCELLED));
                } else if (CalendarTodoEntry.COMPLETED.equals((Object)status)) {
                    this.setText(CalendarTodoEntry.writeStatus(CalendarTodoEntry.COMPLETED));
                } else if (CalendarTodoEntry.IN_PROCESS.equals((Object)status)) {
                    this.setText(CalendarTodoEntry.writeStatus(CalendarTodoEntry.IN_PROCESS));
                } else if (CalendarTodoEntry.NEEDS_ACTION.equals((Object)status)) {
                    this.setText(CalendarTodoEntry.writeStatus(CalendarTodoEntry.NEEDS_ACTION));
                } else if (CalendarJournalEntry.CANCELLED.equals((Object)status)) {
                    this.setText(CalendarJournalEntry.writeStatus(CalendarJournalEntry.CANCELLED));
                } else if (CalendarJournalEntry.DRAFT.equals((Object)status)) {
                    this.setText(CalendarJournalEntry.writeStatus(CalendarJournalEntry.DRAFT));
                } else if (CalendarJournalEntry.FINAL.equals((Object)status)) {
                    this.setText(CalendarJournalEntry.writeStatus(CalendarJournalEntry.FINAL));
                } else {
                    this.setText("");
                }
            } else {
                this.setText(n == 0 ? "[ " + CalendarEntryMonthPanel.this.resourceMap.getString("label.search.status.all", new Object[0]) + " ]" : "");
            }
            return this;
        }
    }

    private class CalendarSourceRenderer
    extends JLabel
    implements ListCellRenderer {
        public CalendarSourceRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof CalendarSource) {
                this.setText(((CalendarSource)object).getName());
            } else if (object instanceof VirtualCalendarObject) {
                this.setText(((VirtualCalendarObject)object).getTitle());
            } else {
                this.setText(n == 0 ? "[ " + CalendarEntryMonthPanel.this.resourceMap.getString("label.search.calendar.all", new Object[0]) + " ]" : "");
            }
            return this;
        }
    }

    private class CalendarMonthTable
    extends JXTable {
        private CalendarMonthTable() {
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.columnAtPoint(mouseEvent.getPoint());
            int n2 = this.rowAtPoint(mouseEvent.getPoint());
            if (n < 0 || n2 < 0) {
                return null;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)this.getValueAt(n2, 0));
            calendar.add(11, 24 * (n - 1));
            StringBuilder stringBuilder = new StringBuilder();
            if (n <= 0) {
                stringBuilder.append("<b>").append(CalendarEntryMonthPanel.this.weekNumberFormatter.format(calendar.getTime())).append("</b>");
            } else {
                stringBuilder.append(CalendarEntryMonthPanel.this.fullTitleFormatter.format(calendar.getTime())).append("<hr>");
            }
            if (n > 0) {
                CalendarEntry[] calendarEntryArray = (CalendarEntry[])this.getValueAt(n2, n);
                boolean bl = false;
                if (calendarEntryArray != null) {
                    for (CalendarEntry calendarEntry : calendarEntryArray) {
                        String string;
                        if (calendarEntry == null) continue;
                        bl = true;
                        stringBuilder.append("<p style=\"margin-top:3px; margin-bottom:3px;\">");
                        stringBuilder.append("<b>").append(calendarEntry.getSummaryString()).append("</b>");
                        Color color = calendarEntry.getStatusColor();
                        if (color == null) {
                            color = Color.BLACK;
                        }
                        if (!StringUtils.isEmpty((String)(string = calendarEntry.writeStatus()))) {
                            stringBuilder.append("<br>\u00bb <span style=\"color:#").append(ImmoToolUtils.writeHexColor((Color)color)).append("\">").append(string).append("</span>");
                        }
                        if (calendarEntry.getBegin() != null) {
                            stringBuilder.append("<br>\u00bb ").append(CalendarEntryMonthPanel.this.dateTimeBeginFormatter.format(calendarEntry.getBegin()));
                        }
                        if (calendarEntry.getEnd() != null) {
                            stringBuilder.append("<br>\u00bb ").append(CalendarEntryMonthPanel.this.dateTimeEndFormatter.format(calendarEntry.getEnd()));
                        }
                        stringBuilder.append("</p>");
                    }
                }
                if (!bl) {
                    stringBuilder.append("<i>").append(CalendarEntryMonthPanel.this.resourceMap.getString("label.noEntries", new Object[0])).append("</i>");
                }
            }
            return "<html><div style=\"margin:5px;\">" + stringBuilder.toString() + "</div></html>";
        }
    }

    private class CalendarEntryRenderer
    extends JLabel
    implements ListCellRenderer {
        public CalendarEntryRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof Integer) {
                Integer n2 = (Integer)object;
                if (n2 == 1) {
                    this.setText(CalendarEntryMonthPanel.this.resourceMap.getString("label.event", new Object[0]));
                } else if (n2 == 2) {
                    this.setText(CalendarEntryMonthPanel.this.resourceMap.getString("label.task", new Object[0]));
                } else if (n2 == 4) {
                    this.setText(CalendarEntryMonthPanel.this.resourceMap.getString("label.journal", new Object[0]));
                } else {
                    this.setText("");
                }
            } else {
                this.setText(n == 0 ? "[ " + CalendarEntryMonthPanel.this.resourceMap.getString("label.search.entries.all", new Object[0]) + " ]" : "");
            }
            return this;
        }
    }

    private class CalendarEntriesRenderer
    extends JXPanel
    implements TableCellRenderer {
        private JLabel titleLabel = new JLabel();
        private JPanel entryPanel = new JPanel(new FlowLayout(0));
        private DateFormat dayNumFormatter;
        private DateFormat monthNameFormatter;
        private transient Painter todayPainter;

        public CalendarEntriesRenderer() {
            this.entryPanel.setOpaque(false);
            this.setOpaque(true);
            this.setLayout(new BorderLayout());
            this.add(this.titleLabel, "North");
            this.add(this.entryPanel, "Center");
            this.dayNumFormatter = new SimpleDateFormat("d");
            this.monthNameFormatter = new SimpleDateFormat("MMMMM");
            this.todayPainter = new PinstripePainter((Paint)Color.WHITE.darker(), 30.0, 0.5, 8.0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            CalendarEntry[] calendarEntryArray = (CalendarEntry[])object;
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime((Date)jTable.getValueAt(n, 0));
            calendar2.add(10, 24 * (n2 - 1));
            boolean bl3 = CalendarEntryMonthPanel.this.selectedMonth == calendar2.get(2);
            boolean bl4 = calendar2.get(1) == calendar.get(1) && calendar2.get(2) == calendar.get(2) && calendar2.get(5) == calendar.get(5);
            String string = bl3 ? "#000000" : "#c0c0c0";
            this.titleLabel.setText("<html><b style=\"font-size:1.5em;color:" + string + ";\">" + this.dayNumFormatter.format(calendar2.getTime()) + "</b>" + "&nbsp;<span style=\"color:" + string + ";\">" + this.monthNameFormatter.format(calendar2.getTime()) + "</span>" + "</html>");
            this.entryPanel.removeAll();
            if (calendarEntryArray != null) {
                for (int i = 0; i < calendarEntryArray.length; ++i) {
                    CalendarEntry calendarEntry = calendarEntryArray[i];
                    Color color = calendarEntry != null ? calendarEntry.getStatusColor() : null;
                    ImageIcon imageIcon = null;
                    String string2 = "";
                    if (calendarEntry == null) {
                        string2 = "";
                    } else if (calendarEntry instanceof CalendarEventEntry) {
                        string2 = calendarEntry.getSummaryString();
                        imageIcon = bl3 ? CalendarPlugin.EVENT_ICON : CalendarPlugin.EVENT_ICON_DISABLED;
                    } else if (calendarEntry instanceof CalendarJournalEntry) {
                        string2 = calendarEntry.getSummaryString();
                        imageIcon = bl3 ? CalendarPlugin.JOURNAL_ICON : CalendarPlugin.JOURNAL_ICON_DISABLED;
                    } else if (calendarEntry instanceof CalendarTodoEntry) {
                        string2 = calendarEntry.getSummaryString();
                        imageIcon = bl3 ? CalendarPlugin.TODO_ICON : CalendarPlugin.TODO_ICON_DISABLED;
                    }
                    String string3 = "font-size:0.9em;";
                    string3 = !bl3 || color == null ? string3 + "color:" + string : string3 + "color:#" + ImmoToolUtils.writeHexColor((Color)color) + ";";
                    string2 = "<html>&nbsp;<span style=\"" + string3 + "\">" + string2 + "</span></html>";
                    JLabel jLabel = new JLabel(string2);
                    if (imageIcon != null) {
                        jLabel.setIcon(imageIcon);
                    }
                    this.entryPanel.add(jLabel);
                }
            }
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, jTable.getGridColor()), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
            this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.setForeground(bl ? jTable.getSelectionForeground() : Color.BLACK);
            this.setBackgroundPainter(bl4 ? this.todayPainter : null);
            return this;
        }
    }
}

