/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarEntryViewAddonPanel;
import com.openindex.openestate.tool.calendar.CalendarObject;
import com.openindex.openestate.tool.calendar.CalendarSource;
import com.openindex.openestate.tool.utils.ModificationHandler;
import com.openindex.openestate.tool.utils.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.Summary;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXPanel;

public abstract class CalendarEntryPanel<EntryType>
extends CalendarEntryViewAddonPanel {
    private ModificationHandler modifications = ImmoToolUtils.createModificationHandler();
    private ResourceMap resourceMap = ImmoToolUtils.getResourceMap(CalendarEntryPanel.class);
    protected JLabel entryInfoLabel;
    protected JTextField entrySummaryField;
    private JComboBox entryCalendarBox;
    private long entryCalendarSourceId = 0L;

    protected void buildPanel() {
        this.entryInfoLabel = new JLabel();
        this.entryInfoLabel.setName("entryInfoLabel");
        this.entrySummaryField = new JTextField();
        this.entrySummaryField.setName("entrySummaryField");
        this.entryCalendarBox = new JComboBox();
        this.entryCalendarBox.setName("entryCalendarBox");
        this.entryCalendarBox.setRenderer(new CalendarSourceRenderer());
        this.getValidationHandler().putRule((JComponent)this.entrySummaryField, ValidationHandler.NOT_BLANK);
        this.getValidationHandler().putRule((JComponent)this.entryCalendarBox, (ValidationRule)new NonEmptyComboBoxRule(this.entryCalendarBox));
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:[50dlu,pref], 3dlu, pref:grow");
        defaultFormBuilder.border(Borders.DIALOG);
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.general", new Object[0])), 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.general.title", new Object[0]), (Component)this.entrySummaryField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.general.calendar", new Object[0]), (Component)this.entryCalendarBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.entryInfoLabel, 3);
        defaultFormBuilder.nextLine();
        this.resourceMap.injectComponents((Component)((Object)this));
        JXPanel jXPanel = new JXPanel();
        jXPanel.setLayout((LayoutManager)new BorderLayout(5, 5));
        jXPanel.add((Component)defaultFormBuilder.getPanel(), (Object)"North");
        jXPanel.add((Component)this.createEntryPanel(), (Object)"Center");
        JScrollPane jScrollPane = new JScrollPane((Component)jXPanel);
        jScrollPane.setBorder(Borders.EMPTY);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.setLayout(new BorderLayout());
        this.add(jScrollPane, "Center");
        this.revalidate();
        this.repaint();
    }

    public abstract EntryType createEntry();

    protected abstract JPanel createEntryPanel();

    @Override
    public final Task doLoadInBackground() {
        this.entryCalendarBox.setEnabled(false);
        return new ImmoToolTask<DefaultComboBoxModel>(){

            protected DefaultComboBoxModel executeTask() throws Exception {
                DefaultComboBoxModel<CalendarSource> defaultComboBoxModel = new DefaultComboBoxModel<CalendarSource>();
                defaultComboBoxModel.addElement(null);
                for (CalendarSource calendarSource : CalendarSource.loadSources()) {
                    defaultComboBoxModel.addElement(calendarSource);
                }
                return defaultComboBoxModel;
            }

            protected void finished() {
                super.finished();
                CalendarEntryPanel.this.entryCalendarBox.setEnabled(true);
            }

            protected void succeeded(DefaultComboBoxModel defaultComboBoxModel) {
                super.succeeded((Object)defaultComboBoxModel);
                CalendarEntryPanel.this.entryCalendarBox.setModel(defaultComboBoxModel);
                if (CalendarEntryPanel.this.entryCalendarSourceId > 0L) {
                    for (int i = 0; i < CalendarEntryPanel.this.entryCalendarBox.getItemCount(); ++i) {
                        CalendarSource calendarSource = (CalendarSource)CalendarEntryPanel.this.entryCalendarBox.getItemAt(i);
                        if (calendarSource == null || calendarSource.getCalendarId() != CalendarEntryPanel.this.entryCalendarSourceId) continue;
                        CalendarEntryPanel.this.entryCalendarBox.setSelectedIndex(i);
                        break;
                    }
                }
                CalendarEntryPanel.this.modifications.putValue((JComponent)CalendarEntryPanel.this.entryCalendarBox);
            }
        };
    }

    public long getCalendarId() {
        int n = this.entryCalendarBox.getSelectedIndex();
        CalendarSource calendarSource = n >= 0 ? (CalendarSource)this.entryCalendarBox.getItemAt(n) : null;
        return calendarSource != null ? calendarSource.getCalendarId() : 0L;
    }

    @Override
    public final boolean isLoadedInBackground() {
        return true;
    }

    public boolean isFormModified() {
        return this.modifications.isModified();
    }

    @Override
    public void load(CalendarEntry calendarEntry) throws ImmoToolException {
        this.load((EntryType)calendarEntry);
    }

    public void load(EntryType EntryType) throws ImmoToolException {
        CalendarEntry calendarEntry = (CalendarEntry)EntryType;
        this.entryCalendarSourceId = calendarEntry != null ? calendarEntry.getCalendarId() : 0L;
        this.entrySummaryField.setText(calendarEntry != null ? calendarEntry.getSummaryString() : "");
        this.entryInfoLabel.setText("<html></html>");
        this.entryCalendarBox.setEnabled(EntryType == null);
        this.modifications.clear();
        this.modifications.putValue((JComponent)this.entrySummaryField);
    }

    @Override
    public void save(CalendarEntry calendarEntry) throws ImmoToolException {
        this.save((EntryType)calendarEntry);
    }

    public void save(EntryType EntryType) throws ImmoToolException {
        CalendarEntry calendarEntry = (CalendarEntry)EntryType;
        calendarEntry.putProperty((Property)new Summary(ImmoToolUtils.replaceTags((String)this.entrySummaryField.getText()).trim()));
        calendarEntry.putProperty((Property)new LastModified(new DateTime(new Date())));
        calendarEntry.setCalendarId(this.getCalendarId());
    }

    @Override
    public void saveFinished(CalendarObject calendarObject, CalendarEntry calendarEntry) throws ImmoToolException {
        this.saveFinished(calendarObject, (EntryType)calendarEntry);
    }

    public void saveFinished(CalendarObject calendarObject, EntryType EntryType) throws ImmoToolException {
    }

    public void setDate(Date date) {
    }

    public void setDateInterval(Date date, Date date2) {
    }

    @Override
    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.entrySummaryField.setEditable(bl);
        this.entryCalendarBox.setEnabled(bl);
    }

    protected class PriorityRenderer
    extends JLabel
    implements ListCellRenderer {
        public PriorityRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof Priority) {
                Priority priority = (Priority)object;
                this.setText(CalendarEntry.writePriority(priority));
            } else {
                this.setText(object != null ? object.toString() : "");
            }
            return this;
        }
    }

    private class CalendarSourceRenderer
    extends JLabel
    implements ListCellRenderer {
        public CalendarSourceRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof CalendarSource) {
                CalendarSource calendarSource = (CalendarSource)object;
                this.setText(calendarSource.getName());
            } else {
                this.setText(n == 0 ? "[ " + CalendarEntryPanel.this.resourceMap.getString("label.general.calendar.select", new Object[0]) + " ]" : "");
            }
            return this;
        }
    }
}

