/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarObject;
import org.jdesktop.application.ResourceMap;

public class CalendarEntryRemoveTask
extends ImmoToolTask<Boolean> {
    private ResourceMap resourceMap = null;
    private long entryCalId;
    private String entryUId;

    public CalendarEntryRemoveTask(CalendarEntry calendarEntry) {
        this(calendarEntry.getCalendarId(), calendarEntry.getUId().getValue());
    }

    public CalendarEntryRemoveTask(long l, String string) {
        this.entryCalId = l;
        this.entryUId = string;
        this.resourceMap = ImmoToolUtils.getResourceMap(CalendarEntryRemoveTask.class);
        this.setTitle(this.resourceMap.getString("title", new Object[0]));
    }

    protected Boolean executeTask() throws Exception {
        CalendarEntry calendarEntry = CalendarEntry.loadEntry(this.entryCalId, this.entryUId);
        if (calendarEntry == null) {
            throw new Exception("Can't find calendar-entry for uid: " + this.entryUId);
        }
        CalendarObject calendarObject = CalendarObject.load(this.entryCalId);
        if (calendarObject == null) {
            throw new Exception("Can't create calendar object #" + this.entryCalId);
        }
        if (calendarObject.getCalendar().getComponents().remove(calendarEntry.getComponent())) {
            calendarObject.save();
            return Boolean.TRUE;
        }
        throw new Exception("Can't remove entry (" + this.entryUId + ") from calendar #" + this.entryCalId);
    }

    protected void failed(Throwable throwable) {
        super.failed(throwable);
        ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantDeleteCalendarEntry", new Object[0]), (Throwable)throwable);
    }

    protected void succeeded(Boolean bl) {
        super.succeeded((Object)bl);
    }
}

