/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarJournalEntry;
import java.awt.Component;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.application.ResourceMap;

public class CalendarEntryTableModel
extends DefaultTableModel {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_DATE_BEGIN = 1;
    public static final int COLUMN_DATE_FINISH = 2;
    public static final int COLUMN_SUMMARY = 3;
    public static final int COLUMN_CALENDAR = 4;
    public static final int COLUMN_TYPE = 5;
    public static final int COLUMN_STATUS = 6;
    private static final Map<Integer, String> COLUMN_NAMES = new HashMap<Integer, String>();
    private static final Map<Integer, Class> COLUMN_CLASSES;
    private ResourceMap resourceMap;

    public CalendarEntryTableModel() {
        this.setColumnCount(COLUMN_NAMES.size());
        this.resourceMap = ImmoToolUtils.getResourceMap(CalendarEntryTableModel.class);
    }

    public void addCalendarEntry(CalendarEntry calendarEntry, String string) {
        this.addRow(this.buildRow(calendarEntry, string));
    }

    private Object[] buildRow(CalendarEntry calendarEntry, String string) {
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        treeMap.put(0, calendarEntry);
        treeMap.put(4, string);
        treeMap.put(3, calendarEntry.getSummaryString());
        treeMap.put(5, calendarEntry.getEntryName());
        treeMap.put(6, calendarEntry.writeStatus());
        if (calendarEntry.hasBeginTime()) {
            treeMap.put(1, new CalendarDate(calendarEntry.getBegin(), true));
        } else if (calendarEntry.hasBeginDate()) {
            treeMap.put(1, new CalendarDate(calendarEntry.getBegin(), false));
        } else {
            treeMap.put(1, null);
        }
        if (calendarEntry.hasEndTime()) {
            treeMap.put(2, new CalendarDate(calendarEntry.getEnd(), true));
        } else if (calendarEntry.hasEndDate()) {
            treeMap.put(2, new CalendarDate(calendarEntry.getEnd(), false));
        } else {
            treeMap.put(2, null);
        }
        return treeMap.values().toArray(new Object[treeMap.size()]);
    }

    public void clear() {
        while (this.getRowCount() > 0) {
            this.removeRow(0);
        }
    }

    public Class getColumnClass(int n) {
        return COLUMN_CLASSES.containsKey(n) ? COLUMN_CLASSES.get(n) : null;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES.containsKey(n) ? this.resourceMap.getString(COLUMN_NAMES.get(n), new Object[0]) : null;
    }

    public CalendarEntry getEntry(int n) {
        return (CalendarEntry)this.getValueAt(n, 0);
    }

    public long getEntryCalId(int n) {
        CalendarEntry calendarEntry = this.getEntry(n);
        return calendarEntry != null ? calendarEntry.getCalendarId() : 0L;
    }

    public String getEntryUId(int n) {
        CalendarEntry calendarEntry = this.getEntry(n);
        return calendarEntry != null && calendarEntry.getUId() != null ? calendarEntry.getUId().getValue() : null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public boolean isJournalEntry(int n) {
        CalendarEntry calendarEntry = this.getEntry(n);
        return calendarEntry != null && CalendarJournalEntry.class.isInstance(calendarEntry);
    }

    public void setCalendarEntry(int n, CalendarEntry calendarEntry, String string) {
        Object[] objectArray = this.buildRow(calendarEntry, string);
        for (int i = 0; i < objectArray.length; ++i) {
            this.setValueAt(objectArray[i], n, i);
        }
    }

    static {
        COLUMN_NAMES.put(0, "col.id");
        COLUMN_NAMES.put(4, "col.calendar");
        COLUMN_NAMES.put(1, "col.begin");
        COLUMN_NAMES.put(2, "col.end");
        COLUMN_NAMES.put(3, "col.title");
        COLUMN_NAMES.put(5, "col.type");
        COLUMN_NAMES.put(6, "col.status");
        COLUMN_CLASSES = new HashMap<Integer, Class>();
        COLUMN_CLASSES.put(0, CalendarEntry.class);
        COLUMN_CLASSES.put(4, String.class);
        COLUMN_CLASSES.put(1, CalendarDate.class);
        COLUMN_CLASSES.put(2, CalendarDate.class);
        COLUMN_CLASSES.put(3, String.class);
        COLUMN_CLASSES.put(5, String.class);
        COLUMN_CLASSES.put(6, String.class);
    }

    public static class CalendarDateRenderer
    extends JLabel
    implements TableCellRenderer {
        private DateFormat dateFormatter;
        private DateFormat dateTimeformatter;

        public CalendarDateRenderer() {
            this.setOpaque(true);
            this.dateFormatter = DateFormat.getDateInstance(2);
            this.dateTimeformatter = DateFormat.getDateTimeInstance(2, 3);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            if (object instanceof CalendarDate) {
                CalendarDate calendarDate = (CalendarDate)object;
                if (calendarDate.isWithTime()) {
                    this.setText(this.dateTimeformatter.format(calendarDate));
                } else {
                    this.setText(this.dateFormatter.format(calendarDate));
                }
            } else if (object instanceof Date) {
                Date date = (Date)object;
                this.setText(this.dateTimeformatter.format(date));
            } else {
                this.setText("");
            }
            return this;
        }
    }

    public static class CalendarDate
    extends Date {
        private boolean withTime;

        public CalendarDate(Date date, boolean bl) {
            this(date.getTime(), bl);
        }

        public CalendarDate(long l, boolean bl) {
            super(l);
            this.withTime = bl;
        }

        public boolean isWithTime() {
            return this.withTime;
        }
    }
}

