/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolTabPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarEntryRemoveTask;
import com.openindex.openestate.tool.calendar.CalendarEntryTableModel;
import com.openindex.openestate.tool.calendar.CalendarEntryViewPanel;
import com.openindex.openestate.tool.calendar.CalendarEntryViewTask;
import com.openindex.openestate.tool.calendar.CalendarEventEntry;
import com.openindex.openestate.tool.calendar.CalendarJournalEntry;
import com.openindex.openestate.tool.calendar.CalendarObject;
import com.openindex.openestate.tool.calendar.CalendarSource;
import com.openindex.openestate.tool.calendar.CalendarTodoEntry;
import com.openindex.openestate.tool.calendar.VirtualCalendarObject;
import com.openindex.openestate.tool.utils.QuickTableExport;
import com.openindex.openestate.tool.utils.TabComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import net.fortuna.ical4j.model.property.Status;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;

public class CalendarEntryTablePanel
extends ImmoToolTabPanel {
    private static final Logger LOGGER = Logger.getLogger(CalendarEntryTablePanel.class);
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private JPopupMenu actionsMenu;
    private JMenuItem actionViewItem;
    private JMenuItem actionRemoveItem;
    private JPopupMenu addMenu;
    private JComboBox searchCalendarBox;
    private JComboBox searchEntryBox;
    private JComboBox searchStatusBox;
    private JSpinner searchBeginDateField;
    private JSpinner searchEndDateField;
    private CalendarEntryTableModel resultTableModel;
    private Map<Class, VirtualCalendarObject> virtualCalendars;
    private boolean isSearching = false;
    private JButton actionButton;
    private JButton addButton;
    private JButton closeButton;
    private JPanel formPanel;
    private JButton helpButton;
    private JXTitledSeparator resultLabel;
    private JXTable resultTable;
    private JScrollPane resultTableScroller;
    private JButton searchButton;
    private JXTitledSeparator titleLabel;

    public CalendarEntryTablePanel() {
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(CalendarEntryTablePanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(CalendarEntryTablePanel.class);
        this.initComponents();
        this.buildFormPanel();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.virtualCalendars = new HashMap<Class, VirtualCalendarObject>();
        try {
            for (VirtualCalendarObject virtualCalendarObject : VirtualCalendarObject.getUsableCalendars()) {
                this.virtualCalendars.put(virtualCalendarObject.getClass(), virtualCalendarObject);
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't load virtual calendars!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        this.actionsMenu = new JPopupMenu();
        this.actionViewItem = new JMenuItem(this.actionMap.get("doView"));
        this.actionRemoveItem = new JMenuItem(this.actionMap.get("doRemove"));
        this.actionsMenu.add(this.actionViewItem);
        this.actionsMenu.add(this.actionRemoveItem);
        this.addMenu = new JPopupMenu();
        this.addMenu.add(new JMenuItem(this.actionMap.get("doAddTodo")));
        this.addMenu.add(new JMenuItem(this.actionMap.get("doAddEvent")));
        this.resultTableModel = new CalendarEntryTableModel();
        this.resultTable.setModel((TableModel)this.resultTableModel);
        this.resultTable.setSortable(true);
        this.resultTable.getSelectionModel().setSelectionMode(0);
        this.resultTable.getColumn(1).setCellRenderer(new CalendarEntryTableModel.CalendarDateRenderer());
        this.resultTable.getColumn(2).setCellRenderer(new CalendarEntryTableModel.CalendarDateRenderer());
        this.resultTable.getColumnModel().removeColumn(this.resultTable.getColumn(0));
        this.resultTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!CalendarEntryTablePanel.this.resultTable.isEnabled()) {
                    return;
                }
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    Task task = CalendarEntryTablePanel.this.doView();
                    if (task != null) {
                        ImmoToolUtils.executeTask((Task)task);
                    }
                } else if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
                    int n = CalendarEntryTablePanel.this.resultTable.rowAtPoint(mouseEvent.getPoint());
                    if (n >= 0 && n != CalendarEntryTablePanel.this.resultTable.getSelectedRow() && n >= 0) {
                        CalendarEntryTablePanel.this.resultTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    if (n < 0) {
                        n = CalendarEntryTablePanel.this.resultTable.getSelectedRow();
                    }
                    if (n < 0) {
                        return;
                    }
                    CalendarEntryTablePanel.this.showActions((JComponent)CalendarEntryTablePanel.this.resultTable, ((CalendarEntryTablePanel)CalendarEntryTablePanel.this).resultTable.getMousePosition().x, ((CalendarEntryTablePanel)CalendarEntryTablePanel.this).resultTable.getMousePosition().y);
                }
            }
        });
        this.resultTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!CalendarEntryTablePanel.this.resultTable.isEnabled()) {
                    return;
                }
                CalendarEntryTablePanel.this.actionButton.setEnabled(CalendarEntryTablePanel.this.resultTable.getSelectedRow() >= 0);
            }
        });
        this.resultTable.setColumnControl((JComponent)QuickTableExport.createColumnControl((JXTable)this.resultTable));
        ImmoToolUtils.configureTable((JXTable)this.resultTable);
        this.searchButton.setAction(this.actionMap.get(this.searchButton.getText()));
        this.addButton.setAction(this.actionMap.get(this.addButton.getText()));
        this.closeButton.setAction(this.actionMap.get(this.closeButton.getText()));
        this.helpButton.setAction(this.actionMap.get(this.helpButton.getText()));
        this.actionButton.setAction(this.actionMap.get(this.actionButton.getText()));
        this.actionButton.setEnabled(false);
        this.searchEntryBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CalendarEntryTablePanel.this.searchEntryBox.isEnabled()) {
                    return;
                }
                int n = CalendarEntryTablePanel.this.searchEntryBox.getSelectedIndex();
                CalendarEntryTablePanel.this.searchStatusBox.setEnabled(false);
                CalendarEntryTablePanel.this.searchStatusBox.removeAllItems();
                CalendarEntryTablePanel.this.searchStatusBox.addItem(null);
                if (n > 0) {
                    Integer n2 = (Integer)CalendarEntryTablePanel.this.searchEntryBox.getItemAt(n);
                    Status[] statusArray = null;
                    statusArray = n2 == 1 ? CalendarEventEntry.getStatusOptions() : (n2 == 2 ? CalendarTodoEntry.getStatusOptions() : (n2 == 4 ? CalendarJournalEntry.getStatusOptions() : new Status[]{}));
                    for (Status status : statusArray) {
                        CalendarEntryTablePanel.this.searchStatusBox.addItem(status);
                    }
                    CalendarEntryTablePanel.this.searchStatusBox.setSelectedIndex(0);
                }
                CalendarEntryTablePanel.this.searchStatusBox.setEnabled(true);
            }
        });
    }

    private void buildFormPanel() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && !CalendarEntryTablePanel.this.isSearching) {
                    ImmoToolUtils.executeTask((Task)CalendarEntryTablePanel.this.doSearch());
                }
            }
        };
        this.searchBeginDateField = new JSpinner();
        this.searchBeginDateField.setName("searchBeginDateField");
        this.searchBeginDateField.setModel(new SpinnerDateModel());
        this.searchBeginDateField.setEditor(new JSpinner.DateEditor(this.searchBeginDateField, "dd.MM.yyyy"));
        this.searchBeginDateField.addKeyListener(keyAdapter);
        this.searchEndDateField = new JSpinner();
        this.searchEndDateField.setName("searchEndDateField");
        this.searchEndDateField.setModel(new SpinnerDateModel());
        this.searchEndDateField.setEditor(new JSpinner.DateEditor(this.searchEndDateField, "dd.MM.yyyy"));
        this.searchEndDateField.addKeyListener(keyAdapter);
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.searchBeginDateField.setValue(calendar.getTime());
        calendar.add(2, 1);
        calendar.add(6, -1);
        this.searchEndDateField.setValue(calendar.getTime());
        this.searchCalendarBox = new JComboBox();
        this.searchCalendarBox.setName("searchCalendarBox");
        this.searchCalendarBox.addItem(null);
        this.searchCalendarBox.setRenderer(new CalendarSourceRenderer());
        this.searchEntryBox = new JComboBox();
        this.searchEntryBox.setName("searchEntryBox");
        this.searchEntryBox.addItem(null);
        this.searchEntryBox.addItem(1);
        this.searchEntryBox.addItem(2);
        this.searchEntryBox.addItem(4);
        this.searchEntryBox.setRenderer(new CalendarEntryRenderer());
        this.searchStatusBox = new JComboBox();
        this.searchStatusBox.setName("searchStatusBox");
        this.searchStatusBox.addItem(null);
        this.searchStatusBox.setRenderer(new CalendarStatusRenderer());
        this.searchStatusBox.setEnabled(false);
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, pref:grow, 3dlu, right:pref, 3dlu, pref:grow, 3dlu, right:pref, 3dlu, pref:grow", (JPanel)this.formPanel);
        defaultFormBuilder.append(this.resourceMap.getString("label.search.calendar", new Object[0]), (Component)this.searchCalendarBox, 5);
        defaultFormBuilder.append(this.resourceMap.getString("label.search.entries", new Object[0]), (Component)this.searchEntryBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.search.time.begin", new Object[0]), (Component)this.searchBeginDateField);
        defaultFormBuilder.append(this.resourceMap.getString("label.search.time.end", new Object[0]), (Component)this.searchEndDateField);
        defaultFormBuilder.append(this.resourceMap.getString("label.search.status", new Object[0]), (Component)this.searchStatusBox);
        defaultFormBuilder.nextLine();
        this.formPanel.revalidate();
        this.formPanel.repaint();
    }

    @Action
    public void doAction() {
        this.showActions(this.actionButton, 0, this.actionButton.getSize().height);
    }

    @Action
    public void doAdd() {
        this.addMenu.show(this.addButton, 0, this.addButton.getSize().height);
    }

    @Action
    public Task doAddEvent() {
        String string = CalendarEntryViewPanel.getInstanceTabTitle((String)null, 0L, 0);
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<CalendarEntryViewPanel>(){

            protected CalendarEntryViewPanel executeTask() throws Exception {
                CalendarEntryViewPanel calendarEntryViewPanel = new CalendarEntryViewPanel(0);
                calendarEntryViewPanel.setCalendarEntry(null);
                calendarEntryViewPanel.setEditable(true);
                return calendarEntryViewPanel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarEntryTablePanel.this.resourceMap.getString("error.cantCreateForm", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                CalendarEntryTablePanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(CalendarEntryViewPanel calendarEntryViewPanel) {
                super.succeeded((Object)calendarEntryViewPanel);
                calendarEntryViewPanel.executeFormTasks();
                ImmoToolUtils.showPanel((TabComponent)calendarEntryViewPanel);
            }
        };
    }

    @Action
    public Task doAddTodo() {
        String string = CalendarEntryViewPanel.getInstanceTabTitle((String)null, 0L, 1);
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<CalendarEntryViewPanel>(){

            protected CalendarEntryViewPanel executeTask() throws Exception {
                CalendarEntryViewPanel calendarEntryViewPanel = new CalendarEntryViewPanel(1);
                calendarEntryViewPanel.setCalendarEntry(null);
                calendarEntryViewPanel.setEditable(true);
                return calendarEntryViewPanel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarEntryTablePanel.this.resourceMap.getString("error.cantCreateForm", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                CalendarEntryTablePanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(CalendarEntryViewPanel calendarEntryViewPanel) {
                super.succeeded((Object)calendarEntryViewPanel);
                calendarEntryViewPanel.executeFormTasks();
                ImmoToolUtils.showPanel((TabComponent)calendarEntryViewPanel);
            }
        };
    }

    @Action
    public void doClose() {
        ImmoToolUtils.removePanel((String)this.getTabTitle());
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog((String)"calendar.entries");
    }

    @Action
    public Task doSearch() {
        this.resultTableModel.clear();
        this.resultTable.setEnabled(false);
        this.setButtonsEnabled(false);
        final Integer n = this.searchEntryBox.isEnabled() ? (Integer)this.searchEntryBox.getSelectedItem() : null;
        final Status status = this.searchStatusBox.isEnabled() ? (Status)this.searchStatusBox.getSelectedItem() : null;
        final Object object = this.searchCalendarBox != null ? this.searchCalendarBox.getSelectedItem() : null;
        return new ImmoToolTask<CalendarObject>(){

            protected CalendarObject executeTask() throws Exception {
                CalendarObject calendarObject = new CalendarObject();
                if (object instanceof VirtualCalendarObject) {
                    VirtualCalendarObject virtualCalendarObject = (VirtualCalendarObject)object;
                    CalendarEntry[] calendarEntryArray = null;
                    if (n == null) {
                        calendarEntryArray = virtualCalendarObject.getEntries();
                    } else if (n == 1) {
                        calendarEntryArray = virtualCalendarObject.getEventEntries();
                    } else if (n == 2) {
                        calendarEntryArray = virtualCalendarObject.getTodoEntries();
                    } else if (n == 4) {
                        calendarEntryArray = virtualCalendarObject.getJournalEntries();
                    } else {
                        throw new Exception("Unknown entry-type: " + n);
                    }
                    for (CalendarEntry calendarEntry : calendarEntryArray) {
                        if (status != null && !calendarEntry.getStatus().equals((Object)status)) continue;
                        calendarObject.add(calendarEntry);
                    }
                } else if (object instanceof CalendarSource) {
                    CalendarEntry[] calendarEntryArray;
                    CalendarSource calendarSource = (CalendarSource)object;
                    int n2 = 0;
                    if (n != null) {
                        n2 = n;
                    } else {
                        n2 |= 1;
                        n2 |= 4;
                        n2 |= 2;
                    }
                    for (CalendarEntry calendarEntry : calendarEntryArray = CalendarObject.search(new long[]{calendarSource.getCalendarId()}, status, n2)) {
                        calendarObject.add(calendarEntry);
                    }
                } else {
                    int n3 = 0;
                    if (n != null) {
                        n3 = n;
                    } else {
                        n3 |= 1;
                        n3 |= 4;
                        n3 |= 2;
                    }
                    CalendarEntry[] calendarEntryArray = CalendarObject.search(null, status, n3);
                    for (CalendarEntry calendarEntry : calendarEntryArray) {
                        calendarObject.add(calendarEntry);
                    }
                    for (VirtualCalendarObject virtualCalendarObject : CalendarEntryTablePanel.this.virtualCalendars.values()) {
                        calendarEntryArray = null;
                        if (n == null) {
                            calendarEntryArray = virtualCalendarObject.getEntries();
                        } else if (n == 1) {
                            calendarEntryArray = virtualCalendarObject.getEventEntries();
                        } else if (n == 2) {
                            calendarEntryArray = virtualCalendarObject.getTodoEntries();
                        } else if (n == 4) {
                            calendarEntryArray = virtualCalendarObject.getJournalEntries();
                        } else {
                            throw new Exception("Unknown entry-type: " + n);
                        }
                        for (CalendarEntry calendarEntry : calendarEntryArray) {
                            if (status != null && !calendarEntry.getStatus().equals((Object)status)) continue;
                            calendarObject.add(calendarEntry);
                        }
                    }
                }
                return calendarObject;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarEntryTablePanel.this.resourceMap.getString("error.cantExecuteSearch", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                CalendarEntryTablePanel.this.resultTable.setEnabled(true);
                CalendarEntryTablePanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(CalendarObject calendarObject) {
                Cloneable cloneable;
                super.succeeded((Object)calendarObject);
                Date date = null;
                Date date2 = null;
                if (CalendarEntryTablePanel.this.searchBeginDateField.getValue() == null) {
                    cloneable = Calendar.getInstance();
                    ((Calendar)cloneable).setTimeInMillis(0L);
                    date = ((Calendar)cloneable).getTime();
                } else {
                    cloneable = Calendar.getInstance();
                    ((Calendar)cloneable).setTime((Date)CalendarEntryTablePanel.this.searchBeginDateField.getValue());
                    ((Calendar)cloneable).set(11, 0);
                    ((Calendar)cloneable).set(12, 0);
                    ((Calendar)cloneable).set(13, 0);
                    ((Calendar)cloneable).set(14, 0);
                    date = ((Calendar)cloneable).getTime();
                }
                if (CalendarEntryTablePanel.this.searchEndDateField.getValue() == null) {
                    cloneable = Calendar.getInstance();
                    ((Calendar)cloneable).setTimeInMillis(Long.MAX_VALUE);
                    date2 = ((Calendar)cloneable).getTime();
                } else {
                    cloneable = Calendar.getInstance();
                    ((Calendar)cloneable).setTime((Date)CalendarEntryTablePanel.this.searchEndDateField.getValue());
                    ((Calendar)cloneable).add(6, 1);
                    ((Calendar)cloneable).set(11, 0);
                    ((Calendar)cloneable).set(12, 0);
                    ((Calendar)cloneable).set(13, 0);
                    ((Calendar)cloneable).set(14, 0);
                    date2 = ((Calendar)cloneable).getTime();
                }
                cloneable = new HashMap();
                for (CalendarEntry calendarEntry : calendarObject.filterEntries(date, date2, true)) {
                    CalendarSource calendarSource = null;
                    if (calendarEntry.getCalendarId() > 0L) {
                        if (cloneable.containsKey(calendarEntry.getCalendarId())) {
                            calendarSource = (CalendarSource)cloneable.get(calendarEntry.getCalendarId());
                        } else {
                            try {
                                calendarSource = CalendarSource.load(calendarEntry.getCalendarId());
                                if (calendarSource != null) {
                                    cloneable.put(calendarEntry.getCalendarId(), calendarSource);
                                }
                            }
                            catch (Exception exception) {
                                LOGGER.warn((Object)("Can't load calendar #" + calendarEntry.getCalendarId()));
                                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                            }
                        }
                    }
                    String string = null;
                    if (calendarSource != null) {
                        string = calendarSource.getName();
                    } else {
                        Class clazz = calendarEntry.getVirtualCalendarClassFromComment();
                        if (clazz != null && CalendarEntryTablePanel.this.virtualCalendars.containsKey(clazz)) {
                            string = ((VirtualCalendarObject)CalendarEntryTablePanel.this.virtualCalendars.get(clazz)).getTitle();
                        }
                    }
                    CalendarEntryTablePanel.this.resultTableModel.addCalendarEntry(calendarEntry, string);
                }
                CalendarEntryTablePanel.this.resultLabel.setTitle(CalendarEntryTablePanel.this.resourceMap.getString("resultLabel.title", new Object[0]) + " / " + CalendarEntryTablePanel.this.resourceMap.getString("message.resultCount", new Object[]{NumberFormat.getIntegerInstance().format(CalendarEntryTablePanel.this.resultTable.getRowCount())}));
                CalendarEntryTablePanel.this.resultTable.packAll();
            }
        };
    }

    @Action
    public Task doRemove() {
        int n = this.resultTable.convertRowIndexToModel(this.resultTable.getSelectedRow());
        if (n < 0) {
            return null;
        }
        CalendarEntry calendarEntry = this.resultTableModel.getEntry(n);
        if (calendarEntry == null || calendarEntry.getCalendarId() < 1L) {
            return null;
        }
        if (this.resultTableModel.isJournalEntry(n)) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantDeleteJournalCalendarEntry", new Object[0]));
            return null;
        }
        if (!ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyDeleteCalendarEntry", new Object[0]))) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new CalendarEntryRemoveTask(calendarEntry){

            protected void finished() {
                super.finished();
                CalendarEntryTablePanel.this.setButtonsEnabled(true);
            }

            @Override
            protected void succeeded(Boolean bl) {
                super.succeeded(bl);
                if (!Boolean.TRUE.equals(bl)) {
                    return;
                }
                ImmoToolUtils.executeTask((Task)CalendarEntryTablePanel.this.doSearch());
            }
        };
    }

    @Action
    public Task doView() {
        int n = this.resultTable.convertRowIndexToModel(this.resultTable.getSelectedRow());
        if (n < 0) {
            return null;
        }
        CalendarEntry calendarEntry = this.resultTableModel.getEntry(n);
        if (calendarEntry == null) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantLoadCalendarEntry", new Object[0]));
            return null;
        }
        long l = calendarEntry.getCalendarId();
        if (l > 0L) {
            return new CalendarEntryViewTask(calendarEntry);
        }
        Class clazz = calendarEntry.getVirtualCalendarClassFromComment();
        if (clazz == null || !this.virtualCalendars.containsKey(clazz)) {
            return null;
        }
        final CalendarEntryTablePanel calendarEntryTablePanel = this;
        final javax.swing.Action action = this.virtualCalendars.get(clazz).getViewAction(calendarEntry);
        if (action == null) {
            return null;
        }
        return new ImmoToolTask<Boolean>(){

            protected Boolean executeTask() throws Exception {
                action.actionPerformed(new ActionEvent((Object)calendarEntryTablePanel, 0, ""));
                return true;
            }
        };
    }

    public static String getInstanceTabTitle() {
        return ImmoToolUtils.getResourceMap(CalendarEntryTablePanel.class).getString("tabTitle", new Object[0]);
    }

    public String getTabInfo() {
        return this.resourceMap.getString("tabInfo", new Object[0]);
    }

    public String getTabTitle() {
        return CalendarEntryTablePanel.getInstanceTabTitle();
    }

    public void loadSources() throws ImmoToolDbException {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        for (CalendarSource calendarSource : CalendarSource.loadSources()) {
            String string = calendarSource.getName();
            int n = 0;
            while (treeMap.containsKey(string)) {
                string = calendarSource.getName() + "_" + n;
            }
            treeMap.put(string, calendarSource);
        }
        try {
            for (VirtualCalendarObject virtualCalendarObject : this.virtualCalendars.values()) {
                String string = virtualCalendarObject.getTitle();
                int n = 0;
                while (treeMap.containsKey(string)) {
                    string = virtualCalendarObject.getTitle() + "_" + n;
                }
                treeMap.put(string, virtualCalendarObject);
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't load virtual calendars!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        this.searchCalendarBox.setEnabled(false);
        this.searchCalendarBox.removeAllItems();
        this.searchCalendarBox.addItem(null);
        for (Object e : treeMap.values()) {
            this.searchCalendarBox.addItem(e);
        }
        this.searchCalendarBox.setSelectedIndex(0);
        this.searchCalendarBox.setEnabled(true);
    }

    public void refreshTab() {
        ImmoToolUtils.executeTask((Task)this.doSearch());
    }

    private void setButtonsEnabled(boolean bl) {
        this.addButton.setEnabled(bl);
        this.searchButton.setEnabled(bl);
        if (!bl) {
            this.actionButton.setEnabled(false);
        } else {
            this.actionButton.setEnabled(this.resultTable.getSelectedRow() >= 0);
        }
    }

    private void showActions(JComponent jComponent, int n, int n2) {
        int n3 = this.resultTable.convertRowIndexToModel(this.resultTable.getSelectedRow());
        if (n3 < 0) {
            return;
        }
        CalendarEntry calendarEntry = this.resultTableModel.getEntry(n3);
        if (calendarEntry == null) {
            return;
        }
        long l = calendarEntry.getCalendarId();
        if (l > 0L) {
            this.actionRemoveItem.setEnabled(!this.resultTableModel.isJournalEntry(n3));
            this.actionsMenu.show(jComponent, n, n2);
        } else {
            Class clazz = calendarEntry.getVirtualCalendarClassFromComment();
            if (clazz == null || !this.virtualCalendars.containsKey(clazz)) {
                return;
            }
            javax.swing.Action[] actionArray = this.virtualCalendars.get(clazz).getActions(calendarEntry);
            if (actionArray == null || actionArray.length == 0) {
                return;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            for (javax.swing.Action action : actionArray) {
                jPopupMenu.add(new JMenuItem(action));
            }
            jPopupMenu.show(jComponent, n, n2);
        }
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.searchButton = new JButton();
        this.addButton = new JButton();
        this.actionButton = new JButton();
        this.helpButton = new JButton();
        this.closeButton = new JButton();
        this.formPanel = new JPanel();
        this.resultLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.resultTableScroller = new JScrollPane();
        this.resultTable = new JXTable();
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle("titleLabel");
        this.searchButton.setText("doSearch");
        this.searchButton.setName("searchButton");
        this.addButton.setText("doAdd");
        this.addButton.setName("addButton");
        this.actionButton.setText("doAction");
        this.actionButton.setName("actionButton");
        this.helpButton.setText("doHelp");
        this.helpButton.setName("helpButton");
        this.closeButton.setText("doClose");
        this.closeButton.setName("closeButton");
        this.formPanel.setName("formPanel");
        GroupLayout groupLayout = new GroupLayout(this.formPanel);
        this.formPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 731, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 41, Short.MAX_VALUE));
        this.resultLabel.setName("resultLabel");
        this.resultLabel.setTitle("resultLabel");
        this.resultTableScroller.setName("resultTableScroller");
        this.resultTable.setColumnControlVisible(true);
        this.resultTable.setName("resultTable");
        this.resultTableScroller.setViewportView((Component)this.resultTable);
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.resultLabel, -1, 731, Short.MAX_VALUE).addComponent(this.formPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 244, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.searchButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton)).addComponent(this.resultTableScroller, -1, 731, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.helpButton).addComponent(this.actionButton).addComponent(this.addButton).addComponent(this.searchButton)).addComponent((Component)this.titleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.formPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.resultLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultTableScroller, -1, 305, Short.MAX_VALUE).addContainerGap()));
    }

    private class CalendarStatusRenderer
    extends JLabel
    implements ListCellRenderer {
        public CalendarStatusRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof Status) {
                Status status = (Status)object;
                if (CalendarEventEntry.CANCELLED.equals((Object)status)) {
                    this.setText(CalendarEventEntry.writeStatus(CalendarEventEntry.CANCELLED));
                } else if (CalendarEventEntry.CONFIRMED.equals((Object)status)) {
                    this.setText(CalendarEventEntry.writeStatus(CalendarEventEntry.CONFIRMED));
                } else if (CalendarEventEntry.TENTATIVE.equals((Object)status)) {
                    this.setText(CalendarEventEntry.writeStatus(CalendarEventEntry.TENTATIVE));
                } else if (CalendarTodoEntry.CANCELLED.equals((Object)status)) {
                    this.setText(CalendarTodoEntry.writeStatus(CalendarTodoEntry.CANCELLED));
                } else if (CalendarTodoEntry.COMPLETED.equals((Object)status)) {
                    this.setText(CalendarTodoEntry.writeStatus(CalendarTodoEntry.COMPLETED));
                } else if (CalendarTodoEntry.IN_PROCESS.equals((Object)status)) {
                    this.setText(CalendarTodoEntry.writeStatus(CalendarTodoEntry.IN_PROCESS));
                } else if (CalendarTodoEntry.NEEDS_ACTION.equals((Object)status)) {
                    this.setText(CalendarTodoEntry.writeStatus(CalendarTodoEntry.NEEDS_ACTION));
                } else if (CalendarJournalEntry.CANCELLED.equals((Object)status)) {
                    this.setText(CalendarJournalEntry.writeStatus(CalendarJournalEntry.CANCELLED));
                } else if (CalendarJournalEntry.DRAFT.equals((Object)status)) {
                    this.setText(CalendarJournalEntry.writeStatus(CalendarJournalEntry.DRAFT));
                } else if (CalendarJournalEntry.FINAL.equals((Object)status)) {
                    this.setText(CalendarJournalEntry.writeStatus(CalendarJournalEntry.FINAL));
                } else {
                    this.setText("");
                }
            } else {
                this.setText(n == 0 ? "[ " + CalendarEntryTablePanel.this.resourceMap.getString("label.search.status.all", new Object[0]) + " ]" : "");
            }
            return this;
        }
    }

    private class CalendarSourceRenderer
    extends JLabel
    implements ListCellRenderer {
        public CalendarSourceRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof CalendarSource) {
                this.setText(((CalendarSource)object).getName());
            } else if (object instanceof VirtualCalendarObject) {
                this.setText(((VirtualCalendarObject)object).getTitle());
            } else {
                this.setText(n == 0 ? "[ " + CalendarEntryTablePanel.this.resourceMap.getString("label.search.calendar.all", new Object[0]) + " ]" : "");
            }
            return this;
        }
    }

    private class CalendarEntryRenderer
    extends JLabel
    implements ListCellRenderer {
        public CalendarEntryRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof Integer) {
                Integer n2 = (Integer)object;
                if (n2 == 1) {
                    this.setText(CalendarEntryTablePanel.this.resourceMap.getString("label.event", new Object[0]));
                } else if (n2 == 2) {
                    this.setText(CalendarEntryTablePanel.this.resourceMap.getString("label.task", new Object[0]));
                } else if (n2 == 4) {
                    this.setText(CalendarEntryTablePanel.this.resourceMap.getString("label.journal", new Object[0]));
                } else {
                    this.setText("");
                }
            } else {
                this.setText(n == 0 ? "[ " + CalendarEntryTablePanel.this.resourceMap.getString("label.search.entries.all", new Object[0]) + " ]" : "");
            }
            return this;
        }
    }
}

