/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolFrontpageWidget;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarEntryTableModel;
import com.openindex.openestate.tool.calendar.CalendarEntryViewTask;
import com.openindex.openestate.tool.calendar.CalendarObject;
import com.openindex.openestate.tool.calendar.CalendarSource;
import com.openindex.openestate.tool.calendar.VirtualCalendarObject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import net.fortuna.ical4j.model.property.Comment;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;

public class CalendarEntryTableWidget
extends ImmoToolFrontpageWidget {
    private static final Logger LOGGER = Logger.getLogger(CalendarEntryTableWidget.class);
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private JPanel calendarPanel;
    private JXTable calendarTable;
    private CalendarEntryTableModel calendarTableModel;
    private JButton prevDayButton;
    private JButton nextDayButton;
    private JButton todayButton;
    private Calendar calendarTime;
    private JXTitledSeparator titleLabel;
    private Map<Class, VirtualCalendarObject> virtualCalendars;

    public CalendarEntryTableWidget() {
        this(new Date());
    }

    public CalendarEntryTableWidget(Date date) {
        super(CalendarEntryTableWidget.getInstanceTitle());
        this.build(date);
    }

    private void build(Date date) {
        this.setDate(date);
        this.actionMap = ImmoToolUtils.getActionMap(CalendarEntryTableWidget.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(CalendarEntryTableWidget.class);
        this.virtualCalendars = new HashMap<Class, VirtualCalendarObject>();
        try {
            for (VirtualCalendarObject virtualCalendarObject : VirtualCalendarObject.getUsableCalendars()) {
                this.virtualCalendars.put(virtualCalendarObject.getClass(), virtualCalendarObject);
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't load virtual calendars!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        this.showWidget();
    }

    protected JComponent buildWidget() {
        if (this.calendarPanel == null) {
            this.calendarTableModel = new CalendarEntryTableModel();
            this.calendarTable = new JXTable((TableModel)this.calendarTableModel);
            ImmoToolUtils.configureTable((JXTable)this.calendarTable);
            this.calendarTable.setColumnControlVisible(true);
            this.calendarTable.setSortable(true);
            this.calendarTable.getSelectionModel().setSelectionMode(0);
            this.calendarTable.getColumn(1).setCellRenderer(new CalendarEntryTableModel.CalendarDateRenderer());
            this.calendarTable.getColumn(2).setCellRenderer(new CalendarEntryTableModel.CalendarDateRenderer());
            this.calendarTable.getColumnModel().removeColumn(this.calendarTable.getColumn(0));
            this.calendarTable.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                        ImmoToolUtils.executeTask((Task)CalendarEntryTableWidget.this.doView());
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane((Component)this.calendarTable);
            jScrollPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
            this.prevDayButton = new JButton(this.actionMap.get("doShowPrevDate"));
            this.prevDayButton.setName("prevDayButton");
            this.nextDayButton = new JButton(this.actionMap.get("doShowNextDate"));
            this.nextDayButton.setName("nextDayButton");
            this.todayButton = new JButton(this.actionMap.get("doShowTodayDate"));
            this.todayButton.setName("todayButton");
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(this.prevDayButton);
            jPanel.add(this.todayButton);
            jPanel.add(this.nextDayButton);
            this.titleLabel = ImmoToolUtils.createHead1Separator((String)this.getTitle());
            this.titleLabel.setName("titleLabel");
            this.titleLabel.setTitle(this.resourceMap.getString("subtitle", new Object[0]));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            jPanel2.add((Component)this.titleLabel, "Center");
            jPanel2.add((Component)jPanel, "East");
            this.calendarPanel = new JPanel(new BorderLayout());
            this.calendarPanel.add((Component)jPanel2, "North");
            this.calendarPanel.add((Component)jScrollPane, "Center");
        }
        return this.calendarPanel;
    }

    @Action
    public Task doReloadTable() {
        this.calendarTableModel.clear();
        this.calendarTable.setEnabled(false);
        this.prevDayButton.setEnabled(false);
        this.nextDayButton.setEnabled(false);
        this.todayButton.setEnabled(false);
        return new ImmoToolTask<CalendarObject>(){

            protected CalendarObject executeTask() throws Exception {
                CalendarObject calendarObject = new CalendarObject();
                int n = 0;
                n |= 1;
                n |= 4;
                CalendarEntry[] calendarEntryArray = CalendarObject.search(null, null, n |= 2);
                for (CalendarEntry calendarEntry : calendarEntryArray) {
                    calendarObject.add(calendarEntry);
                }
                for (VirtualCalendarObject virtualCalendarObject : CalendarEntryTableWidget.this.virtualCalendars.values()) {
                    for (CalendarEntry calendarEntry : calendarEntryArray = virtualCalendarObject.getEntries()) {
                        calendarObject.add(calendarEntry);
                    }
                }
                return calendarObject;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarEntryTableWidget.this.resourceMap.getString("error.cantExecuteSearch", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                CalendarEntryTableWidget.this.calendarTable.setEnabled(true);
                CalendarEntryTableWidget.this.prevDayButton.setEnabled(true);
                CalendarEntryTableWidget.this.nextDayButton.setEnabled(true);
                CalendarEntryTableWidget.this.todayButton.setEnabled(true);
            }

            protected void succeeded(CalendarObject calendarObject) {
                super.succeeded((Object)calendarObject);
                Date date = CalendarEntryTableWidget.this.calendarTime.getTime();
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(date.getTime());
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                date = calendar.getTime();
                calendar.add(6, 1);
                Date date2 = calendar.getTime();
                HashMap<Long, String[]> hashMap = new HashMap<Long, String[]>();
                for (CalendarEntry calendarEntry : calendarObject.filterEntries(date, date2, true)) {
                    Object object;
                    Comment comment = (Comment)calendarEntry.getProperty("COMMENT");
                    if (comment != null) {
                        object = comment.getValue().split("\\.");
                        calendarEntry.setCalendarId(Long.valueOf(object[1]));
                    }
                    object = null;
                    if (calendarEntry.getCalendarId() > 0L) {
                        if (hashMap.containsKey(calendarEntry.getCalendarId())) {
                            object = (CalendarSource)hashMap.get(calendarEntry.getCalendarId());
                        } else {
                            try {
                                object = CalendarSource.load(calendarEntry.getCalendarId());
                                if (object != null) {
                                    hashMap.put(calendarEntry.getCalendarId(), (String[])object);
                                }
                            }
                            catch (Exception exception) {
                                LOGGER.warn((Object)("Can't load calendar #" + calendarEntry.getCalendarId()));
                                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                            }
                        }
                    }
                    String string = object != null ? object.getName() : calendarEntry.getVirtualCalendarNameFromComment();
                    CalendarEntryTableWidget.this.calendarTableModel.addCalendarEntry(calendarEntry, string);
                }
                CalendarEntryTableWidget.this.titleLabel.setTitle(CalendarEntryTableWidget.this.resourceMap.getString("subtitle", new Object[0]) + " (" + DateFormat.getDateInstance(2).format(date) + ")");
                CalendarEntryTableWidget.this.calendarTable.packAll();
            }
        };
    }

    @Action
    public Task doShowNextDate() {
        this.calendarTime.add(6, 1);
        return this.doReloadTable();
    }

    @Action
    public Task doShowPrevDate() {
        this.calendarTime.add(6, -1);
        return this.doReloadTable();
    }

    @Action
    public Task doShowTodayDate() {
        this.setDate(new Date());
        return this.doReloadTable();
    }

    @Action
    public Task doView() {
        int n = this.calendarTable.convertRowIndexToModel(this.calendarTable.getSelectedRow());
        if (n < 0) {
            return null;
        }
        CalendarEntry calendarEntry = this.calendarTableModel.getEntry(n);
        if (calendarEntry == null) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.noCalendarEntryFound", new Object[0]));
            return null;
        }
        long l = calendarEntry.getCalendarId();
        if (l > 0L) {
            return new CalendarEntryViewTask(calendarEntry);
        }
        Class clazz = calendarEntry.getVirtualCalendarClassFromComment();
        if (clazz == null || !this.virtualCalendars.containsKey(clazz)) {
            return null;
        }
        final CalendarEntryTableWidget calendarEntryTableWidget = this;
        final javax.swing.Action action = this.virtualCalendars.get(clazz).getViewAction(calendarEntry);
        if (action == null) {
            return null;
        }
        return new ImmoToolTask<Boolean>(){

            protected Boolean executeTask() throws Exception {
                action.actionPerformed(new ActionEvent((Object)calendarEntryTableWidget, 0, ""));
                return true;
            }
        };
    }

    public static String getInstanceTitle() {
        ResourceMap resourceMap = ImmoToolUtils.getResourceMap(CalendarEntryTableWidget.class);
        return resourceMap.getString("title", new Object[0]) + " | " + resourceMap.getString("subtitle", new Object[0]);
    }

    public void reload() {
        ImmoToolUtils.executeTask((Task)this.doReloadTable());
    }

    public void setDate(Date date) {
        this.calendarTime = Calendar.getInstance();
        this.calendarTime.setTime(date);
        this.calendarTime.set(10, 0);
        this.calendarTime.set(12, 0);
        this.calendarTime.set(13, 0);
        this.calendarTime.set(14, 0);
    }
}

