/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTabPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarEntryPanel;
import com.openindex.openestate.tool.calendar.CalendarEntryRemoveTask;
import com.openindex.openestate.tool.calendar.CalendarEntryViewAddonPanel;
import com.openindex.openestate.tool.calendar.CalendarEventEntryPanel;
import com.openindex.openestate.tool.calendar.CalendarJournalEntryPanel;
import com.openindex.openestate.tool.calendar.CalendarObject;
import com.openindex.openestate.tool.calendar.CalendarPluginUtils;
import com.openindex.openestate.tool.calendar.CalendarTodoEntryPanel;
import com.openindex.openestate.tool.utils.ModificationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Uid;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.fife.ui.rtextarea.RTextArea;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskEvent;
import org.jdesktop.application.TaskListener;
import org.jdesktop.swingx.JXTitledSeparator;
import org.xmldb.api.base.Collection;

public class CalendarEntryViewPanel
extends ImmoToolTabPanel {
    private static final Logger LOGGER = Logger.getLogger(CalendarEntryViewPanel.class);
    public static final int VIEW_EVENT = 0;
    public static final int VIEW_TODO = 1;
    public static final int VIEW_JOURNAL = 2;
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private NotesPanel notesPanel;
    private int entryView;
    private CalendarEntryPanel entryFormPanel;
    private JPopupMenu actionsMenu;
    private List<CalendarEntryViewAddonPanel> entryAddonPanels;
    private Uid entryUId = null;
    private long entryCalId = 0L;
    private String entryTitle = null;
    private JButton actionButton;
    private JButton closeButton;
    private JButton helpButton;
    private JButton submitButton;
    private JTabbedPane tabPanel;
    private JXTitledSeparator titleLabel;

    public CalendarEntryViewPanel(int n) {
        this.build(n);
    }

    private void build(int n) {
        this.entryView = n;
        this.actionMap = ImmoToolUtils.getActionMap(CalendarEntryViewPanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(CalendarEntryViewPanel.class);
        this.initComponents();
        this.resourceMap.injectComponents((Component)((Object)this));
        if (n == 0) {
            this.entryFormPanel = new CalendarEventEntryPanel();
        } else if (n == 2) {
            this.entryFormPanel = new CalendarJournalEntryPanel();
        } else if (n == 1) {
            this.entryFormPanel = new CalendarTodoEntryPanel();
        } else {
            throw new IllegalArgumentException("invalid entry-type!");
        }
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.entryFormPanel));
        jScrollPane.setBorder(Borders.EMPTY);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.tabPanel.add(this.entryFormPanel.getTitle(), jScrollPane);
        this.entryAddonPanels = new ArrayList<CalendarEntryViewAddonPanel>();
        try {
            for (CalendarEntryViewAddonPanel calendarEntryViewAddonPanel : CalendarEntryViewAddonPanel.getUsablePanels()) {
                this.entryAddonPanels.add(calendarEntryViewAddonPanel);
                this.tabPanel.addTab(calendarEntryViewAddonPanel.getTitle(), (Component)((Object)calendarEntryViewAddonPanel));
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"could not load addon-panels!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        this.notesPanel = new NotesPanel();
        this.tabPanel.add(this.notesPanel.getTitle(), (Component)((Object)this.notesPanel));
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            Component component = this.tabPanel.getComponentAt(i);
            if (component instanceof JScrollPane) {
                component = ((JScrollPane)component).getViewport().getView();
            }
            if (!(component instanceof CalendarEntryViewAddonPanel)) continue;
            this.tabPanel.setEnabledAt(i, false);
        }
        this.actionsMenu = new JPopupMenu();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doCopy")));
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doRemove")));
        this.actionsMenu.addSeparator();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doPrintNotes")));
        this.submitButton.setAction(this.actionMap.get(this.submitButton.getText()));
        this.actionButton.setAction(this.actionMap.get(this.actionButton.getText()));
        this.helpButton.setAction(this.actionMap.get(this.helpButton.getText()));
        this.closeButton.setAction(this.actionMap.get(this.closeButton.getText()));
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.tabPanel.setTabPlacement(1);
        }
    }

    @Action
    public void doAction() {
        this.actionsMenu.show(this.actionButton, 0, this.actionButton.getSize().height);
    }

    @Action
    public void doClose() {
        ImmoToolUtils.removePanel((String)this.getTabTitle());
    }

    @Action
    public Task doCopy() {
        if (this.entryUId == null || this.entryCalId <= 0L) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            Component component = this.tabPanel.getComponentAt(i);
            if (component instanceof JScrollPane) {
                component = ((JScrollPane)component).getViewport().getView();
            }
            if (!(component instanceof CalendarEntryViewAddonPanel)) continue;
            CalendarEntryViewAddonPanel calendarEntryViewAddonPanel = (CalendarEntryViewAddonPanel)((Object)component);
            calendarEntryViewAddonPanel.validateForm();
            if (calendarEntryViewAddonPanel.isFormValid()) continue;
            arrayList.add(this.resourceMap.getString("error.invalidTab", new Object[]{calendarEntryViewAddonPanel.getTitle()}));
        }
        if (!arrayList.isEmpty()) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidInput", new Object[0]), arrayList);
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<CalendarEntry>(){
            private long calendarId;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected CalendarEntry executeTask() throws Exception {
                Collection collection = null;
                try {
                    CalendarEntryViewAddonPanel calendarEntryViewAddonPanel;
                    Component component;
                    int n;
                    collection = CalendarPluginUtils.openPluginCollection("");
                    CalendarEntry calendarEntry = (CalendarEntry)CalendarEntryViewPanel.this.entryFormPanel.createEntry();
                    if (calendarEntry == null) {
                        throw new Exception("no entry found!");
                    }
                    calendarEntry.putProperty((Property)CalendarEntry.generateUid());
                    this.calendarId = CalendarEntryViewPanel.this.entryFormPanel.getCalendarId();
                    CalendarObject calendarObject = CalendarObject.load(this.calendarId, collection);
                    if (calendarObject == null) {
                        throw new Exception("destination-calendar #" + this.calendarId + " not found!");
                    }
                    calendarEntry.setCalendarId(this.calendarId);
                    for (n = 0; n < CalendarEntryViewPanel.this.tabPanel.getTabCount(); ++n) {
                        component = CalendarEntryViewPanel.this.tabPanel.getComponentAt(n);
                        if (component instanceof JScrollPane) {
                            component = ((JScrollPane)component).getViewport().getView();
                        }
                        if (!(component instanceof CalendarEntryViewAddonPanel)) continue;
                        calendarEntryViewAddonPanel = (CalendarEntryViewAddonPanel)((Object)component);
                        calendarEntryViewAddonPanel.save(calendarEntry);
                    }
                    calendarObject.getCalendar().getComponents().add(calendarEntry.getComponent());
                    calendarObject.save(collection);
                    for (n = 0; n < CalendarEntryViewPanel.this.tabPanel.getTabCount(); ++n) {
                        component = CalendarEntryViewPanel.this.tabPanel.getComponentAt(n);
                        if (component instanceof JScrollPane) {
                            component = ((JScrollPane)component).getViewport().getView();
                        }
                        if (!(component instanceof CalendarEntryViewAddonPanel)) continue;
                        calendarEntryViewAddonPanel = (CalendarEntryViewAddonPanel)((Object)component);
                        calendarEntryViewAddonPanel.saveFinished(calendarObject, calendarEntry);
                    }
                    CalendarEntry calendarEntry2 = calendarEntry;
                    return calendarEntry2;
                }
                finally {
                    ImmoToolDbUtils.close((Collection)collection);
                }
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarEntryViewPanel.this.resourceMap.getString("error.cantSaveCalendarEntry", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                CalendarEntryViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(CalendarEntry calendarEntry) {
                super.succeeded((Object)calendarEntry);
                CalendarEntryViewPanel.this.setCalendarEntry(calendarEntry);
                CalendarEntryViewPanel.this.executeFormTasks();
                ImmoToolUtils.updateTabs();
            }
        };
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog((String)"calendar.entries.form");
    }

    @Action
    public void doPrintNotes() {
        try {
            ImmoToolUtils.print((Printable)this.notesPanel.notesField);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Printing failed!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)"Printing failed!", (Throwable)exception);
        }
    }

    @Action
    public Task doRemove() {
        if (this.entryUId == null || this.entryCalId <= 0L) {
            return null;
        }
        if (!ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyDeleteCalendarEntry", new Object[0]))) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new CalendarEntryRemoveTask(this.entryCalId, this.entryUId.getValue()){

            protected void finished() {
                super.finished();
                CalendarEntryViewPanel.this.setButtonsEnabled(true);
            }

            @Override
            protected void succeeded(Boolean bl) {
                super.succeeded(bl);
                if (Boolean.TRUE.equals(bl)) {
                    ImmoToolUtils.removePanel((String)CalendarEntryViewPanel.this.getTabTitle(), (boolean)true);
                }
            }
        };
    }

    @Action
    public Task doSubmit() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            Component component = this.tabPanel.getComponentAt(i);
            if (component instanceof JScrollPane) {
                component = ((JScrollPane)component).getViewport().getView();
            }
            if (!(component instanceof CalendarEntryViewAddonPanel)) continue;
            CalendarEntryViewAddonPanel calendarEntryViewAddonPanel = (CalendarEntryViewAddonPanel)((Object)component);
            calendarEntryViewAddonPanel.validateForm();
            if (calendarEntryViewAddonPanel.isFormValid()) continue;
            arrayList.add(this.resourceMap.getString("error.invalidTab", new Object[]{calendarEntryViewAddonPanel.getTitle()}));
        }
        if (!arrayList.isEmpty()) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidInput", new Object[0]), arrayList);
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<CalendarEntry>(){
            private long newCalendarId;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected CalendarEntry executeTask() throws Exception {
                CalendarEntry calendarEntry;
                Collection collection = null;
                try {
                    Object object;
                    int n;
                    Object object2;
                    boolean bl = false;
                    collection = CalendarPluginUtils.openPluginCollection("");
                    long l = CalendarEntryViewPanel.this.entryCalId;
                    CalendarObject calendarObject = null;
                    CalendarEntry calendarEntry2 = null;
                    if (CalendarEntryViewPanel.this.entryUId == null || l <= 0L) {
                        bl = true;
                        calendarEntry2 = (CalendarEntry)CalendarEntryViewPanel.this.entryFormPanel.createEntry();
                        calendarEntry2.putProperty((Property)CalendarEntry.generateUid());
                    } else {
                        calendarObject = CalendarObject.load(l, collection);
                        if (calendarObject == null) {
                            throw new Exception("source-calendar #" + l + " not found!");
                        }
                        object2 = calendarObject.getEntries();
                        n = ((CalendarEntry[])object2).length;
                        for (int i = 0; i < n; ++i) {
                            object = object2[i];
                            if (!((CalendarEntry)object).getUId().getValue().equals(CalendarEntryViewPanel.this.entryUId.getValue())) continue;
                            calendarEntry2 = object;
                            break;
                        }
                    }
                    if (calendarEntry2 == null) {
                        throw new Exception("no entry found!");
                    }
                    this.newCalendarId = CalendarEntryViewPanel.this.entryFormPanel.getCalendarId();
                    Object object3 = object2 = this.newCalendarId > 0L && l == this.newCalendarId ? calendarObject : CalendarObject.load(this.newCalendarId, collection);
                    if (object2 == null) {
                        throw new Exception("destination-calendar #" + this.newCalendarId + " not found!");
                    }
                    if (l > 0L && l != this.newCalendarId) {
                        bl = true;
                        calendarObject.getCalendar().getComponents().remove(calendarEntry2.getComponent());
                        calendarObject.save(collection);
                    }
                    calendarEntry2.setCalendarId(this.newCalendarId);
                    for (n = 0; n < CalendarEntryViewPanel.this.tabPanel.getTabCount(); ++n) {
                        Component component = CalendarEntryViewPanel.this.tabPanel.getComponentAt(n);
                        if (component instanceof JScrollPane) {
                            component = ((JScrollPane)component).getViewport().getView();
                        }
                        if (!(component instanceof CalendarEntryViewAddonPanel)) continue;
                        object = (CalendarEntryViewAddonPanel)((Object)component);
                        ((CalendarEntryViewAddonPanel)((Object)object)).save(calendarEntry2);
                    }
                    if (bl) {
                        ((CalendarObject)object2).getCalendar().getComponents().add(calendarEntry2.getComponent());
                    }
                    ((CalendarObject)object2).save(collection);
                    for (n = 0; n < CalendarEntryViewPanel.this.tabPanel.getTabCount(); ++n) {
                        Component component = CalendarEntryViewPanel.this.tabPanel.getComponentAt(n);
                        if (component instanceof JScrollPane) {
                            component = ((JScrollPane)component).getViewport().getView();
                        }
                        if (!(component instanceof CalendarEntryViewAddonPanel)) continue;
                        object = (CalendarEntryViewAddonPanel)((Object)component);
                        ((CalendarEntryViewAddonPanel)((Object)object)).saveFinished((CalendarObject)object2, calendarEntry2);
                    }
                    calendarEntry = calendarEntry2;
                }
                catch (Throwable throwable) {
                    ImmoToolDbUtils.close(collection);
                    throw throwable;
                }
                ImmoToolDbUtils.close((Collection)collection);
                return calendarEntry;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarEntryViewPanel.this.resourceMap.getString("error.cantSaveCalendarEntry", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                CalendarEntryViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(CalendarEntry calendarEntry) {
                super.succeeded((Object)calendarEntry);
                CalendarEntryViewPanel.this.setCalendarEntry(calendarEntry);
                CalendarEntryViewPanel.this.executeFormTasks();
                ImmoToolUtils.updateTabs();
            }
        };
    }

    public void executeFormTasks() {
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            CalendarEntryViewAddonPanel calendarEntryViewAddonPanel;
            Component component = this.tabPanel.getComponentAt(i);
            if (component instanceof JScrollPane) {
                component = ((JScrollPane)component).getViewport().getView();
            }
            if (!(component instanceof CalendarEntryViewAddonPanel) || !(calendarEntryViewAddonPanel = (CalendarEntryViewAddonPanel)((Object)component)).isLoadedInBackground()) continue;
            Task task = calendarEntryViewAddonPanel.doLoadInBackground();
            if (task == null) {
                this.tabPanel.setEnabledAt(i, calendarEntryViewAddonPanel.isFormEnabled());
                continue;
            }
            final int n = i;
            task.addTaskListener(new TaskListener(){

                public void doInBackground(TaskEvent taskEvent) {
                }

                public void process(TaskEvent taskEvent) {
                }

                public void succeeded(TaskEvent taskEvent) {
                    CalendarEntryViewPanel.this.tabPanel.setEnabledAt(n, calendarEntryViewAddonPanel.isFormEnabled());
                }

                public void failed(TaskEvent taskEvent) {
                }

                public void cancelled(TaskEvent taskEvent) {
                }

                public void interrupted(TaskEvent taskEvent) {
                }

                public void finished(TaskEvent taskEvent) {
                }
            });
            ImmoToolUtils.executeTask((Task)task);
        }
    }

    public static String getInstanceTabTitle(Uid uid, long l, int n) {
        return CalendarEntryViewPanel.getInstanceTabTitle(uid != null ? uid.getValue() : null, l, n);
    }

    public static String getInstanceTabTitle(String string, long l, int n) {
        ResourceMap resourceMap = ImmoToolUtils.getResourceMap(CalendarEntryViewPanel.class);
        String string2 = string;
        if (string2 != null && string2.contains("-")) {
            string2 = string2.substring(0, string2.indexOf("-"));
        } else if (string2 != null && string2.contains("@")) {
            string2 = string2.substring(0, string2.indexOf("@"));
        }
        if (n == 0) {
            return string != null ? resourceMap.getString("tabTitle.event.edit", new Object[]{l + "-" + string2}) : resourceMap.getString("tabTitle.event.add", new Object[0]);
        }
        if (n == 2) {
            return string != null ? resourceMap.getString("tabTitle.journal.edit", new Object[]{l + "-" + string2}) : resourceMap.getString("tabTitle.journal.add", new Object[0]);
        }
        if (n == 1) {
            return string != null ? resourceMap.getString("tabTitle.todo.edit", new Object[]{l + "-" + string2}) : resourceMap.getString("tabTitle.todo.add", new Object[0]);
        }
        return resourceMap.getString("tabTitle.invalid", new Object[0]);
    }

    public String getTabInfo() {
        if (this.entryUId == null) {
            if (this.entryView == 0) {
                return this.resourceMap.getString("tabInfo.event.add", new Object[0]);
            }
            if (this.entryView == 2) {
                return this.resourceMap.getString("tabInfo.journal.add", new Object[0]);
            }
            if (this.entryView == 1) {
                return this.resourceMap.getString("tabInfo.todo.add", new Object[0]);
            }
        } else {
            if (this.entryView == 0) {
                return StringEscapeUtils.escapeHtml((String)this.entryTitle);
            }
            if (this.entryView == 2) {
                return StringEscapeUtils.escapeHtml((String)this.entryTitle);
            }
            if (this.entryView == 1) {
                return StringEscapeUtils.escapeHtml((String)this.entryTitle);
            }
        }
        return null;
    }

    public String getTabTitle() {
        return CalendarEntryViewPanel.getInstanceTabTitle(this.entryUId, this.entryCalId, this.entryView);
    }

    public boolean isTabModified() {
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            CalendarEntryViewAddonPanel calendarEntryViewAddonPanel;
            Component component = this.tabPanel.getComponentAt(i);
            if (component instanceof JScrollPane) {
                component = ((JScrollPane)component).getViewport().getView();
            }
            if (!(component instanceof CalendarEntryViewAddonPanel) || !(calendarEntryViewAddonPanel = (CalendarEntryViewAddonPanel)((Object)component)).isFormModified()) continue;
            return true;
        }
        return false;
    }

    public void refreshTab() {
        if (this.entryCalId <= 0L || this.entryUId == null) {
            return;
        }
        ImmoToolTask<Boolean> immoToolTask = new ImmoToolTask<Boolean>(){

            protected Boolean executeTask() throws Exception {
                CalendarEntry calendarEntry = CalendarEntry.loadEntry(CalendarEntryViewPanel.this.entryCalId, CalendarEntryViewPanel.this.entryUId.getValue());
                CalendarEntryViewPanel.this.setCalendarEntry(calendarEntry);
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarEntryViewPanel.this.resourceMap.getString("error.cantRefresh", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                CalendarEntryViewPanel.this.setButtonsEnabled(true);
            }
        };
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((Task)immoToolTask);
    }

    public ImmoToolTask saveModifications() {
        return (ImmoToolTask)this.doSubmit();
    }

    private void setButtonsEnabled(boolean bl) {
        this.submitButton.setEnabled(bl);
        this.closeButton.setEnabled(bl);
        this.actionButton.setEnabled(this.entryUId != null && this.entryCalId > 0L && bl);
    }

    public void setCalendarEntry(CalendarEntry calendarEntry) {
        this.entryUId = calendarEntry != null ? calendarEntry.getUId() : null;
        this.entryCalId = calendarEntry != null ? calendarEntry.getCalendarId() : 0L;
        this.entryTitle = calendarEntry != null ? calendarEntry.getSummaryString() : null;
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            Component component = this.tabPanel.getComponentAt(i);
            if (component instanceof JScrollPane) {
                component = ((JScrollPane)component).getViewport().getView();
            }
            if (!(component instanceof CalendarEntryViewAddonPanel)) continue;
            CalendarEntryViewAddonPanel calendarEntryViewAddonPanel = (CalendarEntryViewAddonPanel)((Object)component);
            try {
                calendarEntryViewAddonPanel.load(calendarEntry);
                calendarEntryViewAddonPanel.getValidationHandler().init();
                this.tabPanel.setTitleAt(i, calendarEntryViewAddonPanel.getTitle());
                this.tabPanel.setEnabledAt(i, calendarEntryViewAddonPanel.isFormEnabled() && !calendarEntryViewAddonPanel.isLoadedInBackground());
                continue;
            }
            catch (Exception exception) {
                LOGGER.error((Object)"could not load calendar-form!");
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                this.tabPanel.setEnabledAt(i, false);
            }
        }
        this.titleLabel.setTitle(StringUtils.abbreviate((String)this.getTabTitle(), (int)40));
        this.actionButton.setEnabled(this.entryUId != null && this.entryCalId > 0L);
        ImmoToolUtils.updateTabs();
    }

    public void setDate(Date date) {
        this.entryFormPanel.setDate(date);
    }

    public void setDateInterval(Date date, Date date2) {
        this.entryFormPanel.setDateInterval(date, date2);
    }

    public void setEditable(boolean bl) {
        this.submitButton.setEnabled(bl);
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            Component component = this.tabPanel.getComponentAt(i);
            if (component instanceof JScrollPane) {
                component = ((JScrollPane)component).getViewport().getView();
            }
            if (!(component instanceof CalendarEntryViewAddonPanel)) continue;
            CalendarEntryViewAddonPanel calendarEntryViewAddonPanel = (CalendarEntryViewAddonPanel)((Object)component);
            calendarEntryViewAddonPanel.setEditable(bl);
        }
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.submitButton = new JButton();
        this.actionButton = new JButton();
        this.helpButton = new JButton();
        this.closeButton = new JButton();
        this.tabPanel = new JTabbedPane();
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle("titleLabel");
        this.submitButton.setText("doSubmit");
        this.submitButton.setName("submitButton");
        this.actionButton.setText("doAction");
        this.actionButton.setName("actionButton");
        this.helpButton.setText("doHelp");
        this.helpButton.setName("helpButton");
        this.closeButton.setText("doClose");
        this.closeButton.setName("closeButton");
        this.tabPanel.setTabPlacement(2);
        this.tabPanel.setName("tabPanel");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabPanel, -1, 713, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 317, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.helpButton).addComponent(this.actionButton).addComponent(this.submitButton)).addComponent((Component)this.titleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabPanel, -1, 367, Short.MAX_VALUE).addContainerGap()));
    }

    private final class NotesPanel
    extends CalendarEntryViewAddonPanel {
        private ModificationHandler modifications = ImmoToolUtils.createModificationHandler();
        private RTextArea notesField = null;

        public NotesPanel() {
            JXTitledSeparator jXTitledSeparator = ImmoToolUtils.createHead2Separator((String)"");
            jXTitledSeparator.setName("notesLabel");
            jXTitledSeparator.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            CalendarEntryViewPanel.this.resourceMap.injectComponent((Component)jXTitledSeparator);
            this.notesField = new RTextArea();
            this.notesField.setName("notesField");
            this.notesField.setLineWrap(true);
            this.notesField.setWrapStyleWord(true);
            if (this.notesField.getPopupMenu() != null) {
                this.notesField.getPopupMenu().add(new JMenuItem(CalendarEntryViewPanel.this.actionMap.get("doPrintNotes")));
            }
            CalendarEntryViewPanel.this.resourceMap.injectComponent((Component)this.notesField);
            JScrollPane jScrollPane = new JScrollPane((Component)this.notesField);
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(11, 13, 11, 13));
            this.add((Component)jXTitledSeparator, "North");
            this.add(jScrollPane, "Center");
            this.revalidate();
            this.repaint();
        }

        @Override
        public String getTitle() {
            return CalendarEntryViewPanel.this.resourceMap.getString("notesTabTitle", new Object[0]);
        }

        public boolean isFormEnabled() {
            return true;
        }

        public boolean isFormModified() {
            return this.modifications.isModified();
        }

        public boolean isFormUsable() {
            return true;
        }

        @Override
        public void load(CalendarEntry calendarEntry) throws ImmoToolException {
            this.notesField.setText(calendarEntry != null ? calendarEntry.getDescriptionString() : "");
            this.modifications.clear();
            this.modifications.putValue((JComponent)this.notesField);
        }

        @Override
        public void save(CalendarEntry calendarEntry) throws ImmoToolException {
            Description description = calendarEntry.getDescription();
            if (description == null) {
                description = new Description();
                description.setValue(this.notesField.getText().trim());
                calendarEntry.getProperties().add((Property)description);
            } else {
                description.setValue(this.notesField.getText().trim());
            }
        }

        @Override
        public void saveFinished(CalendarObject calendarObject, CalendarEntry calendarEntry) throws ImmoToolException {
        }

        @Override
        public void setEditable(boolean bl) {
            super.setEditable(bl);
            this.notesField.setEditable(bl);
        }
    }
}

