/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarEntryViewPanel;
import com.openindex.openestate.tool.calendar.CalendarEventEntry;
import com.openindex.openestate.tool.calendar.CalendarJournalEntry;
import com.openindex.openestate.tool.calendar.CalendarSource;
import com.openindex.openestate.tool.calendar.CalendarTodoEntry;
import com.openindex.openestate.tool.utils.TabComponent;
import org.jdesktop.application.ResourceMap;

public class CalendarEntryViewTask
extends ImmoToolTask<CalendarEntryViewPanel> {
    private final ResourceMap resourceMap;
    private final CalendarEntry entry;

    public CalendarEntryViewTask(CalendarEntry calendarEntry) {
        this.entry = calendarEntry;
        this.resourceMap = ImmoToolUtils.getResourceMap(CalendarEntryViewTask.class);
        this.setTitle(this.resourceMap.getString("title", new Object[0]));
    }

    protected CalendarEntryViewPanel executeTask() throws Exception {
        int n = -1;
        if (this.entry == null) {
            throw new Exception("empty entry!");
        }
        if (this.entry instanceof CalendarEventEntry) {
            n = 0;
        } else if (this.entry instanceof CalendarJournalEntry) {
            n = 2;
        } else if (this.entry instanceof CalendarTodoEntry) {
            n = 1;
        } else {
            throw new Exception("Unknown type of calendar-entry: " + this.entry.getClass().getName());
        }
        if (this.entry.getCalendarId() <= 0L) {
            throw new Exception("No calendar was defined!");
        }
        CalendarSource calendarSource = CalendarSource.load(this.entry.getCalendarId());
        if (calendarSource == null) {
            throw new Exception("Can't find calendar #" + this.entry.getCalendarId());
        }
        String string = CalendarEntryViewPanel.getInstanceTabTitle(this.entry.getUId(), this.entry.getCalendarId(), n);
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        CalendarEntryViewPanel calendarEntryViewPanel = new CalendarEntryViewPanel(n);
        calendarEntryViewPanel.setCalendarEntry(this.entry);
        calendarEntryViewPanel.setEditable(true);
        return calendarEntryViewPanel;
    }

    protected void failed(Throwable throwable) {
        super.failed(throwable);
        ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.cantLoadCalendarEntry", new Object[0]), (Throwable)throwable);
    }

    protected void succeeded(CalendarEntryViewPanel calendarEntryViewPanel) {
        super.succeeded((Object)calendarEntryViewPanel);
        if (calendarEntryViewPanel != null) {
            calendarEntryViewPanel.executeFormTasks();
            ImmoToolUtils.showPanel((TabComponent)calendarEntryViewPanel);
        }
    }
}

