/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarPlugin;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.ResourceMap;

public class CalendarEntryWeekModel
extends DefaultTableModel {
    public static final int COLUMN_TIME = 0;
    public static final int COLUMN_DAY1 = 1;
    public static final int COLUMN_DAY2 = 2;
    public static final int COLUMN_DAY3 = 3;
    public static final int COLUMN_DAY4 = 4;
    public static final int COLUMN_DAY5 = 5;
    public static final int COLUMN_DAY6 = 6;
    public static final int COLUMN_DAY7 = 7;
    private static final Map<Integer, String> COLUMN_NAMES = new HashMap<Integer, String>();
    private static final Map<Integer, Class> COLUMN_CLASSES;
    private final ResourceMap resourceMap;
    private boolean fullView = false;

    public CalendarEntryWeekModel() {
        this.setColumnCount(COLUMN_NAMES.size());
        this.clear(new Date());
        this.resourceMap = ImmoToolUtils.getResourceMap(CalendarEntryWeekModel.class);
    }

    public void addCalendarEntries(CalendarEntry[] calendarEntryArray) {
        if (calendarEntryArray == null || calendarEntryArray.length == 0) {
            return;
        }
        Calendar calendar = !this.isFullView() ? CalendarPlugin.getWorkTimeBegin() : null;
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(calendarEntryArray[0].getBegin());
        calendar2.set(7, 2);
        calendar2.set(11, 0);
        calendar2.set(12, 0);
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        int n = 0;
        do {
            Comparable<Date> comparable;
            Comparable<Calendar> comparable2;
            CalendarEntry calendarEntry;
            int n2;
            Calendar calendar3 = Calendar.getInstance();
            calendar3.setTimeInMillis(calendar2.getTimeInMillis());
            calendar3.set(11, this.isFullView() ? 0 : calendar.get(11));
            calendar3.set(12, this.isFullView() ? 0 : calendar.get(12));
            calendar3.set(13, 0);
            calendar3.set(14, 0);
            Calendar calendar4 = null;
            if (this.isFullView()) {
                calendar4 = Calendar.getInstance();
                calendar4.setTime(calendar2.getTime());
                calendar4.set(11, 23);
                calendar4.set(12, 59);
                calendar4.set(13, 59);
            } else {
                calendar4 = CalendarPlugin.getWorkTimeEnd();
                calendar4.set(1, calendar2.get(1));
                calendar4.set(6, calendar2.get(6));
                calendar4.set(13, 0);
                calendar4.set(14, 0);
            }
            ArrayList<CalendarEntry> arrayList = new ArrayList<CalendarEntry>();
            CalendarEntry[] calendarEntryArray2 = calendarEntryArray;
            int n3 = calendarEntryArray2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                calendarEntry = calendarEntryArray2[n2];
                comparable2 = Calendar.getInstance();
                ((Calendar)comparable2).setTimeInMillis(calendar3.getTimeInMillis());
                ((Calendar)comparable2).add(10, 24);
                comparable = calendarEntry.getBegin();
                Date date = calendarEntry.getEnd();
                if (comparable == null || ((Date)comparable).getTime() >= ((Calendar)comparable2).getTimeInMillis() || date != null && date.getTime() <= calendar3.getTimeInMillis()) continue;
                arrayList.add(calendarEntry);
            }
            ++n;
            for (int i = 0; i < this.getRowCount(); ++i) {
                CalendarEntry[] calendarEntryArray3 = arrayList.toArray(new CalendarEntry[arrayList.size()]);
                for (n2 = 0; n2 < calendarEntryArray3.length; ++n2) {
                    Date date;
                    calendarEntry = calendarEntryArray3[n2];
                    if (calendarEntry.getBegin() == null) {
                        calendarEntryArray3[n2] = null;
                        continue;
                    }
                    comparable2 = calendarEntry.getBegin();
                    comparable = Calendar.getInstance();
                    ((Calendar)comparable).setTime((Date)comparable2);
                    int n4 = ((Calendar)comparable).get(12);
                    int n5 = n4 % 15;
                    if (n5 > 0) {
                        ((Calendar)comparable).add(12, n5 * -1);
                        comparable2 = ((Calendar)comparable).getTime();
                    }
                    if ((date = calendarEntry.getEnd()) != null) {
                        Calendar calendar5 = Calendar.getInstance();
                        calendar5.setTime(date);
                        n4 = calendar5.get(12);
                        n5 = n4 % 15;
                        if (n5 > 0) {
                            calendar5.add(12, 15 - n5);
                            date = calendar5.getTime();
                        }
                    }
                    if (((Date)comparable2).getTime() <= calendar3.getTimeInMillis() && (date == null || date.getTime() > calendar3.getTimeInMillis())) continue;
                    calendarEntryArray3[n2] = null;
                }
                this.setValueAt(calendarEntryArray3, i, n);
                calendar3.add(12, 15);
                if (calendar3.after(calendar4)) break;
            }
            calendar2.add(10, 24);
        } while (calendar2.get(7) != 2);
    }

    public void clear(Date date) {
        while (this.getRowCount() > 0) {
            this.removeRow(0);
        }
        Calendar calendar = !this.isFullView() ? CalendarPlugin.getWorkTimeBegin() : null;
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        calendar2.set(7, 2);
        calendar2.set(11, this.isFullView() ? 0 : calendar.get(11));
        calendar2.set(12, this.isFullView() ? 0 : calendar.get(12));
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        Calendar calendar3 = null;
        if (this.isFullView()) {
            calendar3 = Calendar.getInstance();
            calendar3.setTime(calendar2.getTime());
            calendar3.set(11, 23);
            calendar3.set(12, 59);
            calendar3.set(13, 59);
        } else {
            calendar3 = CalendarPlugin.getWorkTimeEnd();
            calendar3.set(1, calendar2.get(1));
            calendar3.set(6, calendar2.get(6));
            calendar3.set(13, 0);
            calendar3.set(14, 0);
        }
        while (!calendar2.after(calendar3)) {
            this.addRow(new Object[]{calendar2.getTime(), null, null, null, null, null, null, null});
            calendar2.add(12, 15);
        }
    }

    public Class getColumnClass(int n) {
        return COLUMN_CLASSES.containsKey(n) ? COLUMN_CLASSES.get(n) : null;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES.containsKey(n) ? this.resourceMap.getString(COLUMN_NAMES.get(n), new Object[0]) : null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public boolean isFullView() {
        return this.fullView;
    }

    public void setFullView(boolean bl) {
        this.fullView = bl;
    }

    static {
        COLUMN_NAMES.put(0, "col.week");
        COLUMN_NAMES.put(1, "col.monday");
        COLUMN_NAMES.put(2, "col.tuesday");
        COLUMN_NAMES.put(3, "col.wednesday");
        COLUMN_NAMES.put(4, "col.thursday");
        COLUMN_NAMES.put(5, "col.friday");
        COLUMN_NAMES.put(6, "col.saturday");
        COLUMN_NAMES.put(7, "col.sunday");
        COLUMN_CLASSES = new HashMap<Integer, Class>();
        COLUMN_CLASSES.put(0, Date.class);
        COLUMN_CLASSES.put(1, CalendarEntry[].class);
        COLUMN_CLASSES.put(2, CalendarEntry[].class);
        COLUMN_CLASSES.put(3, CalendarEntry[].class);
        COLUMN_CLASSES.put(4, CalendarEntry[].class);
        COLUMN_CLASSES.put(5, CalendarEntry[].class);
        COLUMN_CLASSES.put(6, CalendarEntry[].class);
        COLUMN_CLASSES.put(7, CalendarEntry[].class);
    }
}

