/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolTabPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarEntryRemoveTask;
import com.openindex.openestate.tool.calendar.CalendarEntryViewPanel;
import com.openindex.openestate.tool.calendar.CalendarEntryViewTask;
import com.openindex.openestate.tool.calendar.CalendarEntryWeekModel;
import com.openindex.openestate.tool.calendar.CalendarEventEntry;
import com.openindex.openestate.tool.calendar.CalendarJournalEntry;
import com.openindex.openestate.tool.calendar.CalendarObject;
import com.openindex.openestate.tool.calendar.CalendarPlugin;
import com.openindex.openestate.tool.calendar.CalendarSource;
import com.openindex.openestate.tool.calendar.CalendarTodoEntry;
import com.openindex.openestate.tool.calendar.VirtualCalendarObject;
import com.openindex.openestate.tool.utils.TabComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerDateModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.fortuna.ical4j.model.property.Status;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.PinstripePainter;

public class CalendarEntryWeekPanel
extends ImmoToolTabPanel {
    private static final Logger LOGGER = Logger.getLogger(CalendarEntryWeekPanel.class);
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private JPopupMenu actionsMenu;
    private JPopupMenu addMenu;
    private CalendarEntryWeekModel weekTableModel;
    private JComboBox searchCalendarBox;
    private JComboBox searchEntryBox;
    private JComboBox searchStatusBox;
    private JSpinner searchWeekField;
    private DateFormat dateTimeBeginFormatter;
    private DateFormat dateTimeEndFormatter;
    private DateFormat fullTitleFormatter;
    private DateFormat timeFormatter;
    private DateFormat weekBeginFormatter;
    private DateFormat weekEndFormatter;
    private DateFormat weekNumberFormatter;
    private Map<Class, VirtualCalendarObject> virtualCalendars;
    private boolean isSearching = false;
    private JButton actionButton;
    private JButton addButton;
    private JButton closeButton;
    private JPanel formPanel;
    private JButton helpButton;
    private JButton nextPageButton;
    private JButton prevPageButton;
    private JButton searchButton;
    private JToggleButton switchToFullViewButton;
    private JXTitledSeparator titleLabel;
    private JButton todayPageButton;
    private JXTitledSeparator weekLabel;
    private JXTable weekTable;
    private JScrollPane weekTableScroller;

    public CalendarEntryWeekPanel() {
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(CalendarEntryWeekPanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(CalendarEntryWeekPanel.class);
        this.initComponents();
        this.buildFormPanel();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.virtualCalendars = new HashMap<Class, VirtualCalendarObject>();
        try {
            for (VirtualCalendarObject virtualCalendarObject : VirtualCalendarObject.getUsableCalendars()) {
                this.virtualCalendars.put(virtualCalendarObject.getClass(), virtualCalendarObject);
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't load virtual calendars!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        this.dateTimeBeginFormatter = new SimpleDateFormat(this.resourceMap.getString("format.dateTime.begin", new Object[0]));
        this.dateTimeEndFormatter = new SimpleDateFormat(this.resourceMap.getString("format.dateTime.end", new Object[0]));
        this.fullTitleFormatter = new SimpleDateFormat(this.resourceMap.getString("format.full.title", new Object[0]));
        this.timeFormatter = new SimpleDateFormat(this.resourceMap.getString("format.time", new Object[0]));
        this.weekBeginFormatter = new SimpleDateFormat(this.resourceMap.getString("format.weekBegin", new Object[0]));
        this.weekEndFormatter = new SimpleDateFormat(this.resourceMap.getString("format.weekEnd", new Object[0]));
        this.weekNumberFormatter = new SimpleDateFormat(this.resourceMap.getString("format.weekNumber", new Object[0]));
        this.actionsMenu = new JPopupMenu();
        this.addMenu = new JPopupMenu();
        this.addMenu.add(new JMenuItem(this.actionMap.get("doAddTodo")));
        this.addMenu.add(new JMenuItem(this.actionMap.get("doAddEvent")));
        ImmoToolUtils.configureTable((JXTable)this.weekTable);
        this.weekTable.setHighlighters(new Highlighter[0]);
        this.weekTableModel = new CalendarEntryWeekModel();
        this.weekTable.setModel((TableModel)this.weekTableModel);
        this.weekTable.getTableHeader().setReorderingAllowed(false);
        this.weekTable.getColumn(0).setMaxWidth(50);
        this.weekTable.getColumn(0).setMinWidth(50);
        this.weekTable.setColumnSelectionAllowed(true);
        this.weekTable.setRowSelectionAllowed(true);
        this.weekTable.setSortable(false);
        this.weekTable.setShowGrid(false);
        this.weekTable.setColumnMargin(1);
        this.weekTable.setRowMargin(0);
        this.weekTable.setDefaultRenderer(Date.class, (TableCellRenderer)new CalendarTimeRenderer());
        this.weekTable.setDefaultRenderer(CalendarEntry[].class, (TableCellRenderer)new CalendarEntriesRenderer());
        this.weekTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 || mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
                    int n = CalendarEntryWeekPanel.this.weekTable.rowAtPoint(mouseEvent.getPoint());
                    if (n < 0) {
                        n = CalendarEntryWeekPanel.this.weekTable.getSelectedRow();
                    }
                    if (n < 0) {
                        return;
                    }
                    int n2 = CalendarEntryWeekPanel.this.weekTable.columnAtPoint(mouseEvent.getPoint());
                    if (n2 < 0) {
                        n2 = CalendarEntryWeekPanel.this.weekTable.getSelectedColumn();
                    }
                    if (n2 < 0) {
                        return;
                    }
                    if (n >= 0 && n != CalendarEntryWeekPanel.this.weekTable.getSelectedRow() || n2 >= 0 && n2 != CalendarEntryWeekPanel.this.weekTable.getSelectedColumn()) {
                        CalendarEntryWeekPanel.this.weekTable.clearSelection();
                        CalendarEntryWeekPanel.this.weekTable.changeSelection(n, n2, false, false);
                    }
                    CalendarEntryWeekPanel.this.showActions((JComponent)CalendarEntryWeekPanel.this.weekTable, ((CalendarEntryWeekPanel)CalendarEntryWeekPanel.this).weekTable.getMousePosition().x, ((CalendarEntryWeekPanel)CalendarEntryWeekPanel.this).weekTable.getMousePosition().y);
                }
            }
        });
        this.weekTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CalendarEntryWeekPanel.this.actionButton.setEnabled(CalendarEntryWeekPanel.this.weekTable.getSelectedRow() >= 0 && CalendarEntryWeekPanel.this.weekTable.getSelectedColumn() > 0);
            }
        });
        this.nextPageButton.setAction(this.actionMap.get(this.nextPageButton.getText()));
        this.prevPageButton.setAction(this.actionMap.get(this.prevPageButton.getText()));
        this.todayPageButton.setAction(this.actionMap.get(this.todayPageButton.getText()));
        this.searchButton.setAction(this.actionMap.get(this.searchButton.getText()));
        this.addButton.setAction(this.actionMap.get(this.addButton.getText()));
        this.closeButton.setAction(this.actionMap.get(this.closeButton.getText()));
        this.helpButton.setAction(this.actionMap.get(this.helpButton.getText()));
        this.switchToFullViewButton.setAction(this.actionMap.get(this.switchToFullViewButton.getText()));
        this.actionButton.setAction(this.actionMap.get(this.actionButton.getText()));
        this.actionButton.setEnabled(false);
        this.searchEntryBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CalendarEntryWeekPanel.this.searchEntryBox.isEnabled()) {
                    return;
                }
                int n = CalendarEntryWeekPanel.this.searchEntryBox.getSelectedIndex();
                CalendarEntryWeekPanel.this.searchStatusBox.setEnabled(false);
                CalendarEntryWeekPanel.this.searchStatusBox.removeAllItems();
                CalendarEntryWeekPanel.this.searchStatusBox.addItem(null);
                if (n > 0) {
                    Integer n2 = (Integer)CalendarEntryWeekPanel.this.searchEntryBox.getItemAt(n);
                    Status[] statusArray = null;
                    statusArray = n2 == 1 ? CalendarEventEntry.getStatusOptions() : (n2 == 2 ? CalendarTodoEntry.getStatusOptions() : (n2 == 4 ? CalendarJournalEntry.getStatusOptions() : new Status[]{}));
                    for (Status status : statusArray) {
                        CalendarEntryWeekPanel.this.searchStatusBox.addItem(status);
                    }
                    CalendarEntryWeekPanel.this.searchStatusBox.setSelectedIndex(0);
                }
                CalendarEntryWeekPanel.this.searchStatusBox.setEnabled(true);
            }
        });
    }

    private void buildFormPanel() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && !CalendarEntryWeekPanel.this.isSearching) {
                    ImmoToolUtils.executeTask((Task)CalendarEntryWeekPanel.this.doSearch());
                }
            }
        };
        this.searchCalendarBox = new JComboBox();
        this.searchCalendarBox.setName("searchCalendarBox");
        this.searchCalendarBox.addItem(null);
        this.searchCalendarBox.setRenderer(new CalendarSourceRenderer());
        this.searchEntryBox = new JComboBox();
        this.searchEntryBox.setName("searchEntryBox");
        this.searchEntryBox.addItem(null);
        this.searchEntryBox.addItem(1);
        this.searchEntryBox.addItem(2);
        this.searchEntryBox.addItem(4);
        this.searchEntryBox.setRenderer(new CalendarEntryRenderer());
        this.searchStatusBox = new JComboBox();
        this.searchStatusBox.setName("searchStatusBox");
        this.searchStatusBox.addItem(null);
        this.searchStatusBox.setRenderer(new CalendarStatusRenderer());
        this.searchStatusBox.setEnabled(false);
        this.searchWeekField = new JSpinner(new SpinnerDateModel());
        ((SpinnerDateModel)this.searchWeekField.getModel()).setCalendarField(3);
        this.searchWeekField.setName("searchWeekField");
        this.searchWeekField.setEditor(new JSpinner.DateEditor(this.searchWeekField, this.resourceMap.getString("format.weekField", new Object[0])));
        this.searchWeekField.getEditor().addKeyListener(keyAdapter);
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:pref, 3dlu, pref:grow, 3dlu, right:pref, 3dlu, pref:grow", (JPanel)this.formPanel);
        defaultFormBuilder.append(this.resourceMap.getString("label.search.calendar", new Object[0]), (Component)this.searchCalendarBox);
        defaultFormBuilder.append(this.resourceMap.getString("label.search.entries", new Object[0]), (Component)this.searchEntryBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.search.week", new Object[0]), (Component)this.searchWeekField);
        defaultFormBuilder.append(this.resourceMap.getString("label.search.status", new Object[0]), (Component)this.searchStatusBox);
        defaultFormBuilder.nextLine();
        this.formPanel.revalidate();
        this.formPanel.repaint();
    }

    @Action
    public void doAction() {
        this.showActions(this.actionButton, 0, this.actionButton.getSize().height);
    }

    @Action
    public void doAdd() {
        this.addMenu.show(this.addButton, 0, this.addButton.getSize().height);
    }

    @Action
    public Task doAddEvent() {
        String string = CalendarEntryViewPanel.getInstanceTabTitle((String)null, 0L, 0);
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<CalendarEntryViewPanel>(){

            protected CalendarEntryViewPanel executeTask() throws Exception {
                CalendarEntryViewPanel calendarEntryViewPanel = new CalendarEntryViewPanel(0);
                calendarEntryViewPanel.setCalendarEntry(null);
                calendarEntryViewPanel.setEditable(true);
                int n = CalendarEntryWeekPanel.this.weekTable.getSelectedRow();
                int n2 = CalendarEntryWeekPanel.this.weekTable.getSelectedColumn();
                if (n >= 0 && n2 > 0) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime((Date)CalendarEntryWeekPanel.this.weekTable.getValueAt(n, 0));
                    calendar.add(10, 24 * (n2 - 1));
                    calendarEntryViewPanel.setDateInterval(calendar.getTime(), null);
                }
                return calendarEntryViewPanel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarEntryWeekPanel.this.resourceMap.getString("error.cantCreateForm", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                CalendarEntryWeekPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(CalendarEntryViewPanel calendarEntryViewPanel) {
                super.succeeded((Object)calendarEntryViewPanel);
                calendarEntryViewPanel.executeFormTasks();
                ImmoToolUtils.showPanel((TabComponent)calendarEntryViewPanel);
            }
        };
    }

    @Action
    public Task doAddTodo() {
        String string = CalendarEntryViewPanel.getInstanceTabTitle((String)null, 0L, 1);
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<CalendarEntryViewPanel>(){

            protected CalendarEntryViewPanel executeTask() throws Exception {
                CalendarEntryViewPanel calendarEntryViewPanel = new CalendarEntryViewPanel(1);
                calendarEntryViewPanel.setCalendarEntry(null);
                calendarEntryViewPanel.setEditable(true);
                int n = CalendarEntryWeekPanel.this.weekTable.getSelectedRow();
                int n2 = CalendarEntryWeekPanel.this.weekTable.getSelectedColumn();
                if (n >= 0 && n2 > 0) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime((Date)CalendarEntryWeekPanel.this.weekTable.getValueAt(n, 0));
                    calendar.add(10, 24 * (n2 - 1));
                    calendarEntryViewPanel.setDateInterval(calendar.getTime(), null);
                }
                return calendarEntryViewPanel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarEntryWeekPanel.this.resourceMap.getString("error.cantCreateForm", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                CalendarEntryWeekPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(CalendarEntryViewPanel calendarEntryViewPanel) {
                super.succeeded((Object)calendarEntryViewPanel);
                calendarEntryViewPanel.executeFormTasks();
                ImmoToolUtils.showPanel((TabComponent)calendarEntryViewPanel);
            }
        };
    }

    @Action
    public void doClose() {
        ImmoToolUtils.removePanel((String)this.getTabTitle());
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog((String)"calendar.entries");
    }

    @Action
    public Task doNextPage() {
        try {
            this.searchWeekField.commitEdit();
        }
        catch (Exception exception) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidWeek", new Object[0]), (Throwable)exception);
            return null;
        }
        this.searchWeekField.setValue(this.searchWeekField.getNextValue());
        return this.doSearch();
    }

    @Action
    public Task doPrevPage() {
        try {
            this.searchWeekField.commitEdit();
        }
        catch (Exception exception) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidWeek", new Object[0]), (Throwable)exception);
            return null;
        }
        this.searchWeekField.setValue(this.searchWeekField.getPreviousValue());
        return this.doSearch();
    }

    @Action
    public Task doSearch() {
        try {
            this.searchWeekField.commitEdit();
        }
        catch (Exception exception) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidWeek", new Object[0]), (Throwable)exception);
            return null;
        }
        this.weekTable.setEnabled(false);
        this.weekTableModel.clear((Date)this.searchWeekField.getValue());
        this.setButtonsEnabled(false);
        final Integer n = this.searchEntryBox.isEnabled() ? (Integer)this.searchEntryBox.getSelectedItem() : null;
        final Status status = this.searchStatusBox.isEnabled() ? (Status)this.searchStatusBox.getSelectedItem() : null;
        final Object object = this.searchCalendarBox != null ? this.searchCalendarBox.getSelectedItem() : null;
        return new ImmoToolTask<CalendarObject>(){

            protected CalendarObject executeTask() throws Exception {
                CalendarObject calendarObject = new CalendarObject();
                if (object instanceof VirtualCalendarObject) {
                    VirtualCalendarObject virtualCalendarObject = (VirtualCalendarObject)object;
                    CalendarEntry[] calendarEntryArray = null;
                    if (n == null) {
                        calendarEntryArray = virtualCalendarObject.getEntries();
                    } else if (n == 1) {
                        calendarEntryArray = virtualCalendarObject.getEventEntries();
                    } else if (n == 2) {
                        calendarEntryArray = virtualCalendarObject.getTodoEntries();
                    } else if (n == 4) {
                        calendarEntryArray = virtualCalendarObject.getJournalEntries();
                    } else {
                        throw new Exception("Unknown entry-type: " + n);
                    }
                    for (CalendarEntry calendarEntry : calendarEntryArray) {
                        if (status != null && !calendarEntry.getStatus().equals((Object)status)) continue;
                        calendarObject.add(calendarEntry);
                    }
                } else if (object instanceof CalendarSource) {
                    CalendarEntry[] calendarEntryArray;
                    CalendarSource calendarSource = (CalendarSource)object;
                    int n2 = 0;
                    if (n != null) {
                        n2 = n;
                    } else {
                        n2 |= 1;
                        n2 |= 4;
                        n2 |= 2;
                    }
                    for (CalendarEntry calendarEntry : calendarEntryArray = CalendarObject.search(new long[]{calendarSource.getCalendarId()}, status, n2)) {
                        calendarObject.add(calendarEntry);
                    }
                } else {
                    int n3 = 0;
                    if (n != null) {
                        n3 = n;
                    } else {
                        n3 |= 1;
                        n3 |= 4;
                        n3 |= 2;
                    }
                    CalendarEntry[] calendarEntryArray = CalendarObject.search(null, status, n3);
                    for (CalendarEntry calendarEntry : calendarEntryArray) {
                        calendarObject.add(calendarEntry);
                    }
                    for (VirtualCalendarObject virtualCalendarObject : CalendarEntryWeekPanel.this.virtualCalendars.values()) {
                        calendarEntryArray = null;
                        if (n == null) {
                            calendarEntryArray = virtualCalendarObject.getEntries();
                        } else if (n == 1) {
                            calendarEntryArray = virtualCalendarObject.getEventEntries();
                        } else if (n == 2) {
                            calendarEntryArray = virtualCalendarObject.getTodoEntries();
                        } else if (n == 4) {
                            calendarEntryArray = virtualCalendarObject.getJournalEntries();
                        } else {
                            throw new Exception("Unknown entry-type: " + n);
                        }
                        for (CalendarEntry calendarEntry : calendarEntryArray) {
                            if (status != null && !calendarEntry.getStatus().equals((Object)status)) continue;
                            calendarObject.add(calendarEntry);
                        }
                    }
                }
                return calendarObject;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarEntryWeekPanel.this.resourceMap.getString("error.cantExecuteSearch", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                CalendarEntryWeekPanel.this.weekTable.setEnabled(true);
                CalendarEntryWeekPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(CalendarObject calendarObject) {
                super.succeeded((Object)calendarObject);
                Date date = (Date)CalendarEntryWeekPanel.this.searchWeekField.getValue();
                Calendar calendar = Calendar.getInstance();
                if (date == null) {
                    calendar.setTimeInMillis(0L);
                } else {
                    calendar.setTime(date);
                }
                calendar.set(7, 2);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                Date date2 = calendar.getTime();
                calendar.add(3, 1);
                calendar.set(14, -1);
                Date date3 = calendar.getTime();
                ArrayList<CalendarEntry> arrayList = new ArrayList<CalendarEntry>();
                arrayList.addAll(Arrays.asList(calendarObject.filterEntries(date2, date3, true)));
                CalendarEntryWeekPanel.this.weekTableModel.addCalendarEntries(arrayList.toArray(new CalendarEntry[arrayList.size()]));
                CalendarEntryWeekPanel.this.weekTable.getColumn(0).setMaxWidth(50);
                CalendarEntryWeekPanel.this.weekTable.getColumn(0).setMinWidth(50);
                for (int i = 1; i < CalendarEntryWeekPanel.this.weekTable.getColumnCount() - 1; ++i) {
                    CalendarEntryWeekPanel.this.weekTable.packColumn(i, 5, 100);
                }
                CalendarEntryWeekPanel.this.weekLabel.setTitle(CalendarEntryWeekPanel.this.resourceMap.getString("weekLabel.title", new Object[0]) + " / " + CalendarEntryWeekPanel.this.weekNumberFormatter.format(date2) + ", " + CalendarEntryWeekPanel.this.weekBeginFormatter.format(date2) + " " + CalendarEntryWeekPanel.this.weekEndFormatter.format(date3));
            }
        };
    }

    @Action
    public Task doSwitchToFullView() {
        this.weekTableModel.setFullView(this.switchToFullViewButton.isSelected());
        return this.doSearch();
    }

    @Action
    public Task doTodayPage() {
        try {
            this.searchWeekField.commitEdit();
        }
        catch (Exception exception) {
            ImmoToolUtils.showMessageErrorDialog((String)this.resourceMap.getString("error.invalidWeek", new Object[0]), (Throwable)exception);
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.searchWeekField.setValue(calendar.getTime());
        return this.doSearch();
    }

    public static String getInstanceTabTitle() {
        return ImmoToolUtils.getResourceMap(CalendarEntryWeekPanel.class).getString("tabTitle", new Object[0]);
    }

    public String getTabInfo() {
        return this.resourceMap.getString("tabInfo", new Object[0]);
    }

    public String getTabTitle() {
        return CalendarEntryWeekPanel.getInstanceTabTitle();
    }

    public void loadSources() throws ImmoToolDbException {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        for (CalendarSource calendarSource : CalendarSource.loadSources()) {
            String string = calendarSource.getName();
            int n = 0;
            while (treeMap.containsKey(string)) {
                string = calendarSource.getName() + "_" + n;
            }
            treeMap.put(string, calendarSource);
        }
        try {
            for (VirtualCalendarObject virtualCalendarObject : this.virtualCalendars.values()) {
                String string = virtualCalendarObject.getTitle();
                int n = 0;
                while (treeMap.containsKey(string)) {
                    string = virtualCalendarObject.getTitle() + "_" + n;
                }
                treeMap.put(string, virtualCalendarObject);
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't load virtual calendars!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
        this.searchCalendarBox.setEnabled(false);
        this.searchCalendarBox.removeAllItems();
        this.searchCalendarBox.addItem(null);
        for (Object e : treeMap.values()) {
            this.searchCalendarBox.addItem(e);
        }
        this.searchCalendarBox.setSelectedIndex(0);
        this.searchCalendarBox.setEnabled(true);
    }

    public void refreshTab() {
        ImmoToolUtils.executeTask((Task)this.doSearch());
    }

    private void setButtonsEnabled(boolean bl) {
        this.addButton.setEnabled(bl);
        this.searchButton.setEnabled(bl);
        this.actionButton.setEnabled(bl && this.weekTable.getSelectedRowCount() > 0);
        this.nextPageButton.setEnabled(bl);
        this.prevPageButton.setEnabled(bl);
        this.todayPageButton.setEnabled(bl);
        this.switchToFullViewButton.setEnabled(bl);
        this.searchWeekField.setEnabled(bl);
    }

    private void showActions(JComponent jComponent, int n, int n2) {
        int n3 = this.weekTable.getSelectedRow();
        int n4 = this.weekTable.getSelectedColumn();
        if (n3 < 0 || n4 < 0) {
            return;
        }
        this.actionsMenu.setVisible(false);
        this.actionsMenu.removeAll();
        Date date = (Date)this.weekTable.getValueAt(n3, 0);
        if (n4 == 0) {
            this.actionsMenu.add(new JLabel("<html>&nbsp;<b>" + this.timeFormatter.format(date) + "</b></html>"));
            this.actionsMenu.show(jComponent, n, n2);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(11, 24 * (n4 - 1));
        JLabel jLabel = new JLabel("<html>" + this.fullTitleFormatter.format(calendar.getTime()) + "</html>");
        jLabel.setOpaque(true);
        jLabel.setBackground(Color.WHITE);
        this.actionsMenu.add(jLabel);
        this.actionsMenu.addSeparator();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doAddEvent")));
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doAddTodo")));
        CalendarEntry[] calendarEntryArray = (CalendarEntry[])this.weekTable.getValueAt(n3, n4);
        if (calendarEntryArray == null || calendarEntryArray.length == 0) {
            this.actionsMenu.show(jComponent, n, n2);
            return;
        }
        boolean bl = false;
        for (final CalendarEntry calendarEntry : calendarEntryArray) {
            Object object;
            Serializable serializable;
            if (calendarEntry == null) continue;
            JMenu jMenu = new JMenu(calendarEntry.getSummaryString());
            if (calendarEntry.getCalendarId() > 0L) {
                serializable = null;
                object = null;
                if (calendarEntry instanceof CalendarEventEntry) {
                    jMenu.setIcon(CalendarPlugin.EVENT_ICON);
                    serializable = new JMenuItem(this.resourceMap.getString("label.event.open", new Object[0]));
                    object = new JMenuItem(this.resourceMap.getString("label.event.remove", new Object[0]));
                } else if (calendarEntry instanceof CalendarTodoEntry) {
                    jMenu.setIcon(CalendarPlugin.TODO_ICON);
                    serializable = new JMenuItem(this.resourceMap.getString("label.task.open", new Object[0]));
                    object = new JMenuItem(this.resourceMap.getString("label.task.remove", new Object[0]));
                } else if (calendarEntry instanceof CalendarJournalEntry) {
                    jMenu.setIcon(CalendarPlugin.JOURNAL_ICON);
                    serializable = new JMenuItem(this.resourceMap.getString("label.journal.open", new Object[0]));
                }
                if (serializable != null) {
                    jMenu.add((JMenuItem)serializable);
                    ((AbstractButton)serializable).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ImmoToolUtils.executeTask((Task)new CalendarEntryViewTask(calendarEntry));
                        }
                    });
                }
                if (object != null) {
                    jMenu.add((JMenuItem)object);
                    object.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            CalendarEntryRemoveTask calendarEntryRemoveTask = new CalendarEntryRemoveTask(calendarEntry){

                                @Override
                                protected void succeeded(Boolean bl) {
                                    super.succeeded(bl);
                                    ImmoToolUtils.executeTask((Task)CalendarEntryWeekPanel.this.doSearch());
                                }
                            };
                            ImmoToolUtils.executeTask((Task)calendarEntryRemoveTask);
                        }
                    });
                }
                if (!bl) {
                    this.actionsMenu.addSeparator();
                }
                bl = true;
                this.actionsMenu.add(jMenu);
                continue;
            }
            serializable = calendarEntry.getVirtualCalendarClassFromComment();
            if (serializable == null || !this.virtualCalendars.containsKey(serializable) || (object = this.virtualCalendars.get(serializable).getActions(calendarEntry)) == null || ((javax.swing.Action[])object).length == 0) continue;
            for (javax.swing.Action action : object) {
                jMenu.add(new JMenuItem(action));
            }
            if (!bl) {
                this.actionsMenu.addSeparator();
            }
            bl = true;
            this.actionsMenu.add(jMenu);
        }
        this.actionsMenu.show(jComponent, n, n2);
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.searchButton = new JButton();
        this.addButton = new JButton();
        this.actionButton = new JButton();
        this.helpButton = new JButton();
        this.closeButton = new JButton();
        this.formPanel = new JPanel();
        this.weekLabel = ImmoToolUtils.createHead2Separator((String)"");
        this.prevPageButton = new JButton();
        this.todayPageButton = new JButton();
        this.nextPageButton = new JButton();
        this.weekTableScroller = new JScrollPane();
        this.weekTable = new CalendarWeekTable();
        this.switchToFullViewButton = new JToggleButton();
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle("titleLabel");
        this.searchButton.setText("doSearch");
        this.searchButton.setName("searchButton");
        this.addButton.setText("doAdd");
        this.addButton.setName("addButton");
        this.actionButton.setText("doAction");
        this.actionButton.setName("actionButton");
        this.helpButton.setText("doHelp");
        this.helpButton.setName("helpButton");
        this.closeButton.setText("doClose");
        this.closeButton.setName("closeButton");
        this.formPanel.setName("formPanel");
        GroupLayout groupLayout = new GroupLayout(this.formPanel);
        this.formPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 830, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 41, Short.MAX_VALUE));
        this.weekLabel.setName("weekLabel");
        this.weekLabel.setTitle("weekLabel");
        this.prevPageButton.setText("doPrevPage");
        this.prevPageButton.setName("prevPageButton");
        this.todayPageButton.setText("doTodayPage");
        this.todayPageButton.setName("todayPageButton");
        this.nextPageButton.setText("doNextPage");
        this.nextPageButton.setName("nextPageButton");
        this.weekTableScroller.setName("weekTableScroller");
        this.weekTable.setName("weekTable");
        this.weekTableScroller.setViewportView((Component)this.weekTable);
        this.switchToFullViewButton.setText("doSwitchToFullView");
        this.switchToFullViewButton.setName("switchToFullViewButton");
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.weekTableScroller, GroupLayout.Alignment.LEADING, -1, 830, Short.MAX_VALUE).addComponent(this.formPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 343, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.searchButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton)).addGroup(groupLayout2.createSequentialGroup().addComponent((Component)this.weekLabel, -1, 255, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.switchToFullViewButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.prevPageButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.todayPageButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextPageButton))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.helpButton).addComponent(this.actionButton).addComponent(this.addButton).addComponent(this.searchButton)).addComponent((Component)this.titleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.formPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nextPageButton).addComponent(this.todayPageButton).addComponent(this.prevPageButton).addComponent(this.switchToFullViewButton)).addComponent((Component)this.weekLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.weekTableScroller, -1, 340, Short.MAX_VALUE).addContainerGap()));
    }

    private class CalendarWeekTable
    extends JXTable {
        private CalendarWeekTable() {
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.columnAtPoint(mouseEvent.getPoint());
            int n2 = this.rowAtPoint(mouseEvent.getPoint());
            if (n < 0 || n2 < 0) {
                return null;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)this.getValueAt(n2, 0));
            calendar.add(11, 24 * (n - 1));
            StringBuilder stringBuilder = new StringBuilder();
            if (n <= 0) {
                stringBuilder.append("<b>").append(CalendarEntryWeekPanel.this.timeFormatter.format(calendar.getTime())).append("</b>");
            } else {
                stringBuilder.append(CalendarEntryWeekPanel.this.fullTitleFormatter.format(calendar.getTime())).append("<hr>");
            }
            if (n > 0) {
                CalendarEntry[] calendarEntryArray = (CalendarEntry[])this.getValueAt(n2, n);
                boolean bl = false;
                if (calendarEntryArray != null) {
                    for (CalendarEntry calendarEntry : calendarEntryArray) {
                        String string;
                        if (calendarEntry == null) continue;
                        bl = true;
                        stringBuilder.append("<p style=\"margin-top:3px; margin-bottom:3px;\">");
                        stringBuilder.append("<b>").append(calendarEntry.getSummaryString()).append("</b>");
                        Color color = calendarEntry.getStatusColor();
                        if (color == null) {
                            color = Color.BLACK;
                        }
                        if (!StringUtils.isEmpty((String)(string = calendarEntry.writeStatus()))) {
                            stringBuilder.append("<br>\u00bb <span style=\"color:#").append(ImmoToolUtils.writeHexColor((Color)color)).append("\">").append(string).append("</span>");
                        }
                        if (calendarEntry.getBegin() != null) {
                            stringBuilder.append("<br>\u00bb ").append(CalendarEntryWeekPanel.this.dateTimeBeginFormatter.format(calendarEntry.getBegin()));
                        }
                        if (calendarEntry.getEnd() != null) {
                            stringBuilder.append("<br>\u00bb ").append(CalendarEntryWeekPanel.this.dateTimeEndFormatter.format(calendarEntry.getEnd()));
                        }
                        stringBuilder.append("</p>");
                    }
                }
                if (!bl) {
                    stringBuilder.append("<i>").append(CalendarEntryWeekPanel.this.resourceMap.getString("label.noEntries", new Object[0])).append("</i>");
                }
            }
            return "<html><div style=\"margin:5px;\">" + stringBuilder.toString() + "</div></html>";
        }
    }

    private static class CalendarTimeRenderer
    extends JLabel
    implements TableCellRenderer {
        private DateFormat formatter;

        public CalendarTimeRenderer() {
            this.setOpaque(true);
            this.formatter = new SimpleDateFormat("HH:mm");
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            if (object instanceof Date) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((Date)object);
                int n3 = calendar.get(12);
                String string = this.formatter.format(calendar.getTime());
                string = n3 == 0 ? "<b>" + string + "</b>" : "<span style=\"font-size:0.9em;\">" + string + "</span>";
                this.setText("<html>" + string + "</html>");
            } else {
                this.setText("");
            }
            return this;
        }
    }

    private class CalendarStatusRenderer
    extends JLabel
    implements ListCellRenderer {
        public CalendarStatusRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof Status) {
                Status status = (Status)object;
                if (CalendarEventEntry.CANCELLED.equals((Object)status)) {
                    this.setText(CalendarEventEntry.writeStatus(CalendarEventEntry.CANCELLED));
                } else if (CalendarEventEntry.CONFIRMED.equals((Object)status)) {
                    this.setText(CalendarEventEntry.writeStatus(CalendarEventEntry.CONFIRMED));
                } else if (CalendarEventEntry.TENTATIVE.equals((Object)status)) {
                    this.setText(CalendarEventEntry.writeStatus(CalendarEventEntry.TENTATIVE));
                } else if (CalendarTodoEntry.CANCELLED.equals((Object)status)) {
                    this.setText(CalendarTodoEntry.writeStatus(CalendarTodoEntry.CANCELLED));
                } else if (CalendarTodoEntry.COMPLETED.equals((Object)status)) {
                    this.setText(CalendarTodoEntry.writeStatus(CalendarTodoEntry.COMPLETED));
                } else if (CalendarTodoEntry.IN_PROCESS.equals((Object)status)) {
                    this.setText(CalendarTodoEntry.writeStatus(CalendarTodoEntry.IN_PROCESS));
                } else if (CalendarTodoEntry.NEEDS_ACTION.equals((Object)status)) {
                    this.setText(CalendarTodoEntry.writeStatus(CalendarTodoEntry.NEEDS_ACTION));
                } else if (CalendarJournalEntry.CANCELLED.equals((Object)status)) {
                    this.setText(CalendarJournalEntry.writeStatus(CalendarJournalEntry.CANCELLED));
                } else if (CalendarJournalEntry.DRAFT.equals((Object)status)) {
                    this.setText(CalendarJournalEntry.writeStatus(CalendarJournalEntry.DRAFT));
                } else if (CalendarJournalEntry.FINAL.equals((Object)status)) {
                    this.setText(CalendarJournalEntry.writeStatus(CalendarJournalEntry.FINAL));
                } else {
                    this.setText("");
                }
            } else {
                this.setText(n == 0 ? "[ " + CalendarEntryWeekPanel.this.resourceMap.getString("label.search.status.all", new Object[0]) + " ]" : "");
            }
            return this;
        }
    }

    private class CalendarSourceRenderer
    extends JLabel
    implements ListCellRenderer {
        public CalendarSourceRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof CalendarSource) {
                this.setText(((CalendarSource)object).getName());
            } else if (object instanceof VirtualCalendarObject) {
                this.setText(((VirtualCalendarObject)object).getTitle());
            } else {
                this.setText(n == 0 ? "[ " + CalendarEntryWeekPanel.this.resourceMap.getString("label.search.calendar.all", new Object[0]) + " ]" : "");
            }
            return this;
        }
    }

    private class CalendarEntryRenderer
    extends JLabel
    implements ListCellRenderer {
        public CalendarEntryRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof Integer) {
                Integer n2 = (Integer)object;
                if (n2 == 1) {
                    this.setText(CalendarEntryWeekPanel.this.resourceMap.getString("label.event", new Object[0]));
                } else if (n2 == 2) {
                    this.setText(CalendarEntryWeekPanel.this.resourceMap.getString("label.task", new Object[0]));
                } else if (n2 == 4) {
                    this.setText(CalendarEntryWeekPanel.this.resourceMap.getString("label.journal", new Object[0]));
                } else {
                    this.setText("");
                }
            } else {
                this.setText(n == 0 ? "[ " + CalendarEntryWeekPanel.this.resourceMap.getString("label.search.entries.all", new Object[0]) + " ]" : "");
            }
            return this;
        }
    }

    private static class CalendarEntriesRenderer
    extends JXPanel
    implements TableCellRenderer {
        private JLabel emptyLabel;
        private transient Painter todayPainter;

        public CalendarEntriesRenderer() {
            this.setOpaque(true);
            this.emptyLabel = new JLabel();
            this.emptyLabel.setOpaque(false);
            this.todayPainter = new PinstripePainter((Paint)Color.WHITE.darker().darker(), 30.0, 0.5, 8.5);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime((Date)jTable.getValueAt(n, 0));
            calendar2.set(7, 2);
            calendar2.add(7, n2 - 1);
            boolean bl3 = calendar2.get(1) == calendar.get(1) && calendar2.get(2) == calendar.get(2) && calendar2.get(5) == calendar.get(5);
            this.removeAll();
            CalendarEntry[] calendarEntryArray = (CalendarEntry[])object;
            if (calendarEntryArray == null || calendarEntryArray.length == 0) {
                this.setLayout(new BorderLayout(0, 0));
                this.emptyLabel.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
                this.add(this.emptyLabel, "Center");
                this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
                this.setBackgroundPainter(bl3 ? this.todayPainter : null);
                return this;
            }
            this.setLayout(new GridLayout(1, calendarEntryArray.length, 0, 0));
            for (int i = 0; i < calendarEntryArray.length; ++i) {
                Color color;
                CalendarEntry calendarEntry = calendarEntryArray[i];
                boolean bl4 = n == 0 || ((CalendarEntry[])jTable.getValueAt(n - 1, n2))[i] == null;
                boolean bl5 = n == jTable.getRowCount() - 1 || ((CalendarEntry[])jTable.getValueAt(n + 1, n2))[i] == null;
                Color color2 = Color.WHITE;
                Color color3 = color = calendarEntry != null ? calendarEntry.getStatusColor() : null;
                if (color == null) {
                    color = Color.BLACK;
                }
                ImageIcon imageIcon = null;
                String string = "";
                if (calendarEntry == null) {
                    string = "";
                } else if (calendarEntry instanceof CalendarEventEntry) {
                    string = bl4 ? calendarEntry.getSummaryString() : "";
                    imageIcon = bl4 ? CalendarPlugin.EVENT_ICON : null;
                    color2 = CalendarPlugin.EVENT_BG_COLOR;
                } else if (calendarEntry instanceof CalendarJournalEntry) {
                    string = bl4 ? calendarEntry.getSummaryString() : "";
                    imageIcon = bl4 ? CalendarPlugin.JOURNAL_ICON : null;
                    color2 = CalendarPlugin.JOURNAL_BG_COLOR;
                } else {
                    if (!(calendarEntry instanceof CalendarTodoEntry)) continue;
                    string = bl4 ? calendarEntry.getSummaryString() : "";
                    imageIcon = bl4 ? CalendarPlugin.TODO_ICON : null;
                    color2 = CalendarPlugin.TODO_BG_COLOR;
                }
                if (bl4 && string.trim().length() > 0) {
                    string = "<html>&nbsp;<span style=\"font-size:0.9em;\">" + string + "</span></html>";
                }
                JXLabel jXLabel = new JXLabel(string);
                jXLabel.setOpaque(true);
                Color color4 = bl ? jTable.getSelectionBackground() : color2;
                Color color5 = new Color(color4.getRed(), color4.getGreen(), color4.getBlue(), 100);
                if (calendarEntryArray.length == 1 && bl3) {
                    jXLabel.setBackgroundPainter((Painter)new CompoundPainter(new Painter[]{new MattePainter((Paint)color5), this.todayPainter}));
                } else {
                    jXLabel.setBackgroundPainter((Painter)new MattePainter((Paint)color5));
                }
                jXLabel.setForeground(bl ? jTable.getSelectionForeground() : color);
                if (imageIcon != null) {
                    jXLabel.setIcon((Icon)imageIcon);
                }
                if (calendarEntry != null && (bl4 || bl5)) {
                    jXLabel.setBorder((Border)BorderFactory.createMatteBorder(bl4 ? 2 : 0, 0, bl5 ? 2 : 0, 0, color4));
                }
                this.add((Component)jXLabel);
            }
            this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            if (calendarEntryArray.length > 1) {
                this.setBackgroundPainter(bl3 ? this.todayPainter : null);
            }
            return this;
        }
    }
}

