/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import java.awt.Color;
import java.util.Calendar;
import java.util.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Status;

public class CalendarEventEntry
extends CalendarEntry<VEvent> {
    public static final Status CANCELLED = Status.VEVENT_CANCELLED;
    public static final Status CONFIRMED = Status.VEVENT_CONFIRMED;
    public static final Status TENTATIVE = Status.VEVENT_TENTATIVE;

    public CalendarEventEntry() {
        this(new VEvent());
    }

    public CalendarEventEntry(VEvent vEvent) {
        super(vEvent);
    }

    @Override
    public Date getBegin() {
        if (((VEvent)this.getComponent()).getStartDate() == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(((VEvent)this.getComponent()).getStartDate().getDate().getTime());
        return calendar.getTime();
    }

    @Override
    public Date getEnd() {
        if (((VEvent)this.getComponent()).getEndDate() == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(((VEvent)this.getComponent()).getEndDate().getDate().getTime());
        return calendar.getTime();
    }

    @Override
    public String getEntryName() {
        return ImmoToolUtils.getResourceMap(CalendarEntry.class).getString("type.event", new Object[0]);
    }

    @Override
    public Color getStatusColor() {
        return CalendarEventEntry.getStatusColor(this.getStatus());
    }

    public static Color getStatusColor(Status status) {
        if (Status.VEVENT_CANCELLED.equals((Object)status)) {
            return Color.GRAY;
        }
        if (Status.VEVENT_CONFIRMED.equals((Object)status)) {
            return Color.BLACK;
        }
        if (Status.VEVENT_TENTATIVE.equals((Object)status)) {
            return Color.RED;
        }
        return null;
    }

    public static Status[] getStatusOptions() {
        return new Status[]{CANCELLED, CONFIRMED, TENTATIVE};
    }

    @Override
    public boolean hasBeginDate() {
        DtStart dtStart = (DtStart)this.getProperty("DTSTART");
        return dtStart != null && dtStart.getDate() != null && !DateTime.class.isInstance(dtStart.getDate());
    }

    @Override
    public boolean hasBeginTime() {
        DtStart dtStart = (DtStart)this.getProperty("DTSTART");
        return dtStart != null && dtStart.getDate() != null && DateTime.class.isInstance(dtStart.getDate());
    }

    @Override
    public boolean hasEndDate() {
        DtEnd dtEnd = (DtEnd)this.getProperty("DTEND");
        return dtEnd != null && dtEnd.getDate() != null && !DateTime.class.isInstance(dtEnd.getDate());
    }

    @Override
    public boolean hasEndTime() {
        DtEnd dtEnd = (DtEnd)this.getProperty("DTEND");
        return dtEnd != null && dtEnd.getDate() != null && DateTime.class.isInstance(dtEnd.getDate());
    }

    @Override
    public void setBeginDate(Date date) {
        if (date == null) {
            this.removeProperty("DTSTART");
        } else {
            this.putProperty((Property)new DtStart(new net.fortuna.ical4j.model.Date(date)));
        }
    }

    @Override
    public void setBeginTime(Date date) {
        if (date == null) {
            this.removeProperty("DTSTART");
        } else {
            TimeZone timeZone = CalendarEventEntry.getTimeZone();
            Calendar calendar = Calendar.getInstance((java.util.TimeZone)timeZone);
            calendar.setTimeInMillis(date.getTime());
            DateTime dateTime = new DateTime(calendar.getTime());
            dateTime.setTimeZone(timeZone);
            this.putProperty((Property)new DtStart((net.fortuna.ical4j.model.Date)dateTime));
        }
    }

    @Override
    public void setEndDate(Date date) {
        if (date == null) {
            this.removeProperty("DTEND");
        } else {
            this.putProperty((Property)new DtEnd(new net.fortuna.ical4j.model.Date(date)));
        }
    }

    @Override
    public void setEndTime(Date date) {
        if (date == null) {
            this.removeProperty("DTEND");
        } else {
            TimeZone timeZone = CalendarEventEntry.getTimeZone();
            Calendar calendar = Calendar.getInstance((java.util.TimeZone)timeZone);
            calendar.setTimeInMillis(date.getTime());
            DateTime dateTime = new DateTime(calendar.getTime());
            dateTime.setTimeZone(timeZone);
            this.putProperty((Property)new DtEnd((net.fortuna.ical4j.model.Date)dateTime));
        }
    }

    public void setSingleDay(Date date) {
        if (date == null) {
            this.removeProperty("DTSTART");
            this.removeProperty("DTEND");
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.setBeginDate(calendar.getTime());
        calendar.add(6, 1);
        calendar.add(14, -1);
        this.setEndTime(calendar.getTime());
    }

    @Override
    public String writeStatus() {
        return CalendarEventEntry.writeStatus(this.getStatus());
    }

    public static String writeStatus(Status status) {
        return CalendarEventEntry.writeStatusForEvent(status);
    }
}

