/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntryPanel;
import com.openindex.openestate.tool.calendar.CalendarEventEntry;
import com.openindex.openestate.tool.utils.ModificationHandler;
import com.openindex.openestate.tool.utils.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.Geo;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.Status;
import org.apache.commons.lang.StringUtils;
import org.fife.ui.rtextarea.RTextArea;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXDatePicker;

public class CalendarEventEntryPanel
extends CalendarEntryPanel<CalendarEventEntry> {
    private ResourceMap resourceMap;
    private ModificationHandler modifications;
    private ButtonGroup eventTypeGroup;
    private JRadioButton eventSingleDayButton;
    private JRadioButton eventIntervalButton;
    private JXDatePicker eventDateField;
    private JSpinner eventBeginTimeField;
    private JSpinner eventFinishTimeField;
    private JComboBox eventPriorityField;
    private JComboBox eventStatusField;
    private RTextArea eventLocationField;
    private JFormattedTextField eventLocationLongitudeField;
    private JFormattedTextField eventLocationLatitudeField;

    public CalendarEventEntryPanel() {
        this.build();
    }

    private void build() {
        this.modifications = ImmoToolUtils.createModificationHandler();
        this.resourceMap = ImmoToolUtils.getResourceMap(CalendarEventEntryPanel.class);
        this.buildPanel();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.selectEventType();
        this.eventSingleDayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarEventEntryPanel.this.selectEventType();
                if (CalendarEventEntryPanel.this.eventDateField.getDate() == null) {
                    CalendarEventEntryPanel.this.eventDateField.setDate(new Date());
                }
                CalendarEventEntryPanel.this.getValidationHandler().validate((JComponent)CalendarEventEntryPanel.this.eventDateField.getEditor());
            }
        });
        this.eventIntervalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarEventEntryPanel.this.selectEventType();
                if (CalendarEventEntryPanel.this.eventBeginTimeField.getValue() == null) {
                    CalendarEventEntryPanel.this.eventBeginTimeField.setValue(new Date());
                }
                if (CalendarEventEntryPanel.this.eventFinishTimeField.getValue() == null) {
                    CalendarEventEntryPanel.this.eventFinishTimeField.setValue(new Date());
                }
            }
        });
        this.eventBeginTimeField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CalendarEventEntryPanel.this.getValidationHandler().validate((JComponent)CalendarEventEntryPanel.this.eventBeginTimeField);
                CalendarEventEntryPanel.this.getValidationHandler().validate((JComponent)CalendarEventEntryPanel.this.eventFinishTimeField);
            }
        });
        this.eventFinishTimeField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CalendarEventEntryPanel.this.getValidationHandler().validate((JComponent)CalendarEventEntryPanel.this.eventBeginTimeField);
                CalendarEventEntryPanel.this.getValidationHandler().validate((JComponent)CalendarEventEntryPanel.this.eventFinishTimeField);
            }
        });
    }

    @Override
    public CalendarEventEntry createEntry() {
        return new CalendarEventEntry();
    }

    @Override
    protected JPanel createEntryPanel() {
        this.eventLocationField = new RTextArea();
        this.eventLocationField.setName("eventLocationField");
        this.eventLocationLongitudeField = new JFormattedTextField();
        this.eventLocationLongitudeField.setName("eventLocationLongitudeField");
        this.eventLocationLatitudeField = new JFormattedTextField();
        this.eventLocationLatitudeField.setName("eventLocationLatitudeField");
        this.eventDateField = new JXDatePicker();
        this.eventDateField.setName("eventDateField");
        this.eventPriorityField = new JComboBox<Object>(new Object[]{"[ " + this.resourceMap.getString("label.priority.select", new Object[0]) + " ]", Priority.UNDEFINED, Priority.LOW, Priority.MEDIUM, Priority.HIGH});
        this.eventPriorityField.setName("eventPriorityField");
        this.eventPriorityField.setRenderer(new CalendarEntryPanel.PriorityRenderer(this));
        this.eventStatusField = new JComboBox<Object>(new Object[]{"[ " + this.resourceMap.getString("label.status.select", new Object[0]) + " ]", Status.VEVENT_TENTATIVE, Status.VEVENT_CONFIRMED, Status.VEVENT_CANCELLED});
        this.eventStatusField.setName("eventStatusField");
        this.eventStatusField.setRenderer(new StatusRenderer());
        this.eventSingleDayButton = new JRadioButton();
        this.eventSingleDayButton.setName("eventSingleDayButton");
        this.eventIntervalButton = new JRadioButton();
        this.eventIntervalButton.setName("eventIntervalButton");
        this.eventTypeGroup = new ButtonGroup();
        this.eventTypeGroup.add(this.eventSingleDayButton);
        this.eventTypeGroup.add(this.eventIntervalButton);
        this.eventSingleDayButton.setSelected(true);
        this.eventBeginTimeField = new JSpinner();
        this.eventBeginTimeField.setName("eventBeginTimeField");
        this.eventBeginTimeField.setModel(new SpinnerNullDateModel());
        this.eventBeginTimeField.setEditor(new JSpinner.DateEditor(this.eventBeginTimeField, this.resourceMap.getString("format.dateTime", new Object[0])));
        this.eventFinishTimeField = new JSpinner();
        this.eventFinishTimeField.setName("eventFinishTimeField");
        this.eventFinishTimeField.setModel(new SpinnerNullDateModel());
        this.eventFinishTimeField.setEditor(new JSpinner.DateEditor(this.eventFinishTimeField, this.resourceMap.getString("format.dateTime", new Object[0])));
        this.getValidationHandler().putRule((JComponent)this.eventPriorityField, (ValidationRule)new NonEmptyComboBoxRule(this.eventPriorityField));
        this.getValidationHandler().putRule((JComponent)this.eventStatusField, (ValidationRule)new NonEmptyComboBoxRule(this.eventStatusField));
        this.getValidationHandler().putRule((JComponent)this.eventDateField.getEditor(), new ValidationRule(){

            public boolean isValid(Object object) {
                String string = StringUtils.defaultIfBlank((String)CalendarEventEntryPanel.this.eventDateField.getEditor().getText(), null);
                if (string == null) {
                    return false;
                }
                Date date = null;
                for (DateFormat dateFormat : CalendarEventEntryPanel.this.eventDateField.getFormats()) {
                    try {
                        date = dateFormat.parse(string);
                        if (date == null) continue;
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (date == null) {
                    return false;
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                int n = calendar.get(1);
                return n >= 1000 && n <= 9999;
            }
        });
        this.getValidationHandler().putRule((JComponent)this.eventBeginTimeField, new ValidationRule(){

            public boolean isValid(Object object) {
                try {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime((Date)object);
                    Calendar calendar2 = Calendar.getInstance();
                    calendar2.setTime((Date)CalendarEventEntryPanel.this.eventFinishTimeField.getValue());
                    Calendar calendar3 = Calendar.getInstance();
                    calendar3.setTime((Date)object);
                    int n = calendar3.get(1);
                    return n >= 1000 && n <= 9999 && calendar.before(calendar2);
                }
                catch (Exception exception) {
                    return false;
                }
            }
        });
        this.getValidationHandler().putRule((JComponent)this.eventFinishTimeField, new ValidationRule(){

            public boolean isValid(Object object) {
                try {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime((Date)CalendarEventEntryPanel.this.eventBeginTimeField.getValue());
                    Calendar calendar2 = Calendar.getInstance();
                    calendar2.setTime((Date)object);
                    Calendar calendar3 = Calendar.getInstance();
                    calendar3.setTime((Date)object);
                    int n = calendar3.get(1);
                    return n >= 1000 && n <= 9999 && calendar.before(calendar2);
                }
                catch (Exception exception) {
                    return false;
                }
            }
        });
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:[50dlu,pref], 3dlu, pref:grow, 3dlu, right:pref, 3dlu, pref:grow");
        defaultFormBuilder.border(Borders.DIALOG);
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("formTitle", new Object[0])), 3);
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("optionTitle", new Object[0])), 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.eventSingleDayButton, 3);
        defaultFormBuilder.append(this.resourceMap.getString("label.status", new Object[0]), (Component)this.eventStatusField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.date", new Object[0]), (Component)this.eventDateField);
        defaultFormBuilder.append(this.resourceMap.getString("label.priority", new Object[0]), (Component)this.eventPriorityField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.eventIntervalButton, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.begin", new Object[0]), (Component)this.eventBeginTimeField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.end", new Object[0]), (Component)this.eventFinishTimeField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(" "), 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("locationTitle", new Object[0])), 7);
        defaultFormBuilder.nextLine();
        JScrollPane jScrollPane = new JScrollPane((Component)this.eventLocationField);
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        defaultFormBuilder.defaultRowSpec(RowSpec.decode((String)"top:pref"));
        defaultFormBuilder.append(this.resourceMap.getString("label.location", new Object[0]), (Component)jScrollPane, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.defaultRowSpec(FormSpecs.PREF_ROWSPEC);
        defaultFormBuilder.append(this.resourceMap.getString("label.geo.longitude", new Object[0]), (Component)this.eventLocationLongitudeField);
        defaultFormBuilder.append(this.resourceMap.getString("label.geo.latitude", new Object[0]), (Component)this.eventLocationLatitudeField);
        defaultFormBuilder.nextLine();
        return defaultFormBuilder.getPanel();
    }

    @Override
    public String getTitle() {
        return this.resourceMap.getString("title", new Object[0]);
    }

    public boolean isFormEnabled() {
        return true;
    }

    @Override
    public boolean isFormModified() {
        return this.modifications.isModified() || super.isFormModified();
    }

    public boolean isFormUsable() {
        return true;
    }

    @Override
    public void load(CalendarEventEntry calendarEventEntry) throws ImmoToolException {
        Status status;
        Status status2;
        Priority priority;
        Calendar calendar;
        super.load(calendarEventEntry);
        this.eventTypeGroup.getSelection().setSelected(false);
        if (calendarEventEntry != null) {
            if (calendarEventEntry.getEnd() == null) {
                this.eventSingleDayButton.setSelected(true);
            } else {
                this.eventIntervalButton.setSelected(true);
            }
        }
        this.selectEventType();
        this.eventDateField.setDate(null);
        if (this.eventSingleDayButton.isSelected() && calendarEventEntry != null && calendarEventEntry.getBegin() != null) {
            this.eventDateField.setDate(calendarEventEntry.getBegin());
        }
        this.eventBeginTimeField.setValue(null);
        this.eventFinishTimeField.setValue(null);
        if (this.eventIntervalButton.isSelected() && calendarEventEntry != null) {
            if (calendarEventEntry.getBegin() != null) {
                calendar = Calendar.getInstance();
                calendar.setTimeInMillis(calendarEventEntry.getBegin().getTime());
                this.eventBeginTimeField.setValue(calendar.getTime());
            }
            if (calendarEventEntry.getEnd() != null) {
                calendar = Calendar.getInstance();
                calendar.setTimeInMillis(calendarEventEntry.getEnd().getTime());
                this.eventFinishTimeField.setValue(calendar.getTime());
            }
        }
        this.eventPriorityField.setSelectedIndex(1);
        Object object = calendar = calendarEventEntry != null ? ((VEvent)calendarEventEntry.getComponent()).getPriority() : null;
        if (calendar != null) {
            for (int i = 1; i < this.eventPriorityField.getItemCount(); ++i) {
                priority = (Priority)this.eventPriorityField.getItemAt(i);
                if (!priority.equals((Object)calendar)) continue;
                this.eventPriorityField.setSelectedIndex(i);
                break;
            }
        }
        this.eventStatusField.setSelectedIndex(1);
        Status status3 = status2 = calendarEventEntry != null ? ((VEvent)calendarEventEntry.getComponent()).getStatus() : null;
        if (status2 != null) {
            for (int i = 1; i < this.eventStatusField.getItemCount(); ++i) {
                status = (Status)this.eventStatusField.getItemAt(i);
                if (!status.equals((Object)status2)) continue;
                this.eventStatusField.setSelectedIndex(i);
                break;
            }
        }
        this.eventLocationField.setText("");
        Location location = priority = calendarEventEntry != null ? ((VEvent)calendarEventEntry.getComponent()).getLocation() : null;
        if (priority != null) {
            this.eventLocationField.setText(priority.getValue());
        }
        this.eventLocationLatitudeField.setValue(null);
        this.eventLocationLongitudeField.setValue(null);
        Geo geo = status = calendarEventEntry != null ? ((VEvent)calendarEventEntry.getComponent()).getGeographicPos() : null;
        if (status != null) {
            if (status.getLatitude() != null) {
                this.eventLocationLatitudeField.setValue(status.getLatitude().doubleValue());
            }
            if (status.getLongitude() != null) {
                this.eventLocationLongitudeField.setValue(status.getLongitude().doubleValue());
            }
        }
        this.getValidationHandler().validate();
        this.modifications.clear();
        this.modifications.putValue((JComponent)this.eventSingleDayButton);
        this.modifications.putValue((JComponent)this.eventIntervalButton);
        this.modifications.putValue((JComponent)this.eventDateField);
        this.modifications.putValue((JComponent)this.eventBeginTimeField);
        this.modifications.putValue((JComponent)this.eventFinishTimeField);
        this.modifications.putValue((JComponent)this.eventPriorityField);
        this.modifications.putValue((JComponent)this.eventStatusField);
        this.modifications.putValue((JComponent)this.eventLocationField);
        this.modifications.putValue((JComponent)this.eventLocationLongitudeField);
        this.modifications.putValue((JComponent)this.eventLocationLatitudeField);
    }

    @Override
    public void save(CalendarEventEntry calendarEventEntry) throws ImmoToolException {
        super.save(calendarEventEntry);
        if (this.eventSingleDayButton.isSelected()) {
            calendarEventEntry.setSingleDay(this.eventDateField.getDate());
        } else if (this.eventIntervalButton.isSelected()) {
            calendarEventEntry.setBeginTime((Date)this.eventBeginTimeField.getValue());
            calendarEventEntry.setEndTime((Date)this.eventFinishTimeField.getValue());
        }
        if (this.eventPriorityField.getSelectedIndex() <= 0) {
            calendarEventEntry.removeProperty("PRIORITY");
        } else {
            calendarEventEntry.putProperty((Property)((Priority)this.eventPriorityField.getSelectedItem()));
        }
        if (this.eventStatusField.getSelectedIndex() <= 0) {
            calendarEventEntry.removeProperty("STATUS");
        } else {
            calendarEventEntry.putProperty((Property)((Status)this.eventStatusField.getSelectedItem()));
        }
        String string = this.eventLocationField.getText().trim();
        if (string.length() == 0) {
            calendarEventEntry.removeProperty("LOCATION");
        } else {
            calendarEventEntry.putProperty((Property)new Location(string));
        }
        Number number = (Number)this.eventLocationLatitudeField.getValue();
        Number number2 = (Number)this.eventLocationLongitudeField.getValue();
        if (number == null || number2 == null) {
            calendarEventEntry.removeProperty("GEO");
        } else {
            calendarEventEntry.putProperty((Property)new Geo(BigDecimal.valueOf(number.doubleValue()), BigDecimal.valueOf(number2.doubleValue())));
        }
    }

    private void selectEventType() {
        boolean bl = this.eventSingleDayButton.isSelected();
        boolean bl2 = this.eventIntervalButton.isSelected();
        this.eventDateField.setEnabled(bl);
        this.eventBeginTimeField.setEnabled(bl2);
        this.eventFinishTimeField.setEnabled(bl2);
        this.getValidationHandler().validate((JComponent)this.eventDateField.getEditor());
        this.getValidationHandler().validate((JComponent)this.eventBeginTimeField);
        this.getValidationHandler().validate((JComponent)this.eventFinishTimeField);
    }

    @Override
    public void setDate(Date date) {
        this.eventSingleDayButton.setSelected(true);
        this.eventDateField.setDate(date);
        this.selectEventType();
    }

    @Override
    public void setDateInterval(Date date, Date date2) {
        this.eventIntervalButton.setSelected(true);
        this.eventBeginTimeField.setValue(date);
        this.eventFinishTimeField.setValue(date2 != null ? date2 : date);
        this.selectEventType();
    }

    @Override
    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.eventSingleDayButton.setEnabled(bl);
        this.eventDateField.setEditable(this.eventSingleDayButton.isSelected() && bl);
        this.eventIntervalButton.setEnabled(bl);
        this.eventBeginTimeField.setEnabled(this.eventIntervalButton.isSelected() && bl);
        this.eventFinishTimeField.setEnabled(this.eventIntervalButton.isSelected() && bl);
        this.eventPriorityField.setEnabled(bl);
        this.eventStatusField.setEnabled(bl);
        this.eventLocationField.setEditable(bl);
        this.eventLocationLatitudeField.setEditable(bl);
        this.eventLocationLongitudeField.setEditable(bl);
    }

    private static class StatusRenderer
    extends JLabel
    implements ListCellRenderer {
        private Font normalFont;
        private Font boldFont;

        public StatusRenderer() {
            this.setOpaque(true);
            this.normalFont = this.getFont();
            this.boldFont = this.normalFont.deriveFont(1);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            if (object instanceof Status) {
                Status status = (Status)object;
                this.setText(CalendarEventEntry.writeStatus(status));
                this.setForeground(CalendarEventEntry.getStatusColor(status));
                this.setFont(this.boldFont);
            } else {
                this.setText(object != null ? object.toString() : "");
                this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
                this.setFont(this.normalFont);
            }
            return this;
        }
    }

    private static class SpinnerNullDateModel
    extends SpinnerDateModel {
        private Object val = null;

        public SpinnerNullDateModel() {
            this.setCalendarField(11);
            this.setValue(null);
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public void setValue(Object object) {
            this.val = object;
            if (this.val != null) {
                super.setValue(this.val);
            }
        }
    }
}

