/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import java.awt.Color;
import java.util.Calendar;
import java.util.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.component.VJournal;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Status;

public class CalendarJournalEntry
extends CalendarEntry<VJournal> {
    public static final Status CANCELLED = Status.VJOURNAL_CANCELLED;
    public static final Status DRAFT = Status.VJOURNAL_DRAFT;
    public static final Status FINAL = Status.VJOURNAL_FINAL;

    public CalendarJournalEntry() {
        this(new VJournal());
    }

    public CalendarJournalEntry(VJournal vJournal) {
        super(vJournal);
        this.putProperty((Property)FINAL);
    }

    @Override
    public Date getBegin() {
        if (((VJournal)this.getComponent()).getStartDate() == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(((VJournal)this.getComponent()).getStartDate().getDate().getTime());
        return calendar.getTime();
    }

    @Override
    public Date getEnd() {
        return null;
    }

    @Override
    public String getEntryName() {
        return ImmoToolUtils.getResourceMap(CalendarEntry.class).getString("type.journal", new Object[0]);
    }

    @Override
    public Color getStatusColor() {
        return null;
    }

    public static Status[] getStatusOptions() {
        return new Status[]{CANCELLED, DRAFT, FINAL};
    }

    @Override
    public boolean hasBeginDate() {
        DtStart dtStart = (DtStart)this.getProperty("DTSTART");
        return dtStart != null && dtStart.getDate() != null && !DateTime.class.isInstance(dtStart.getDate());
    }

    @Override
    public boolean hasBeginTime() {
        DtStart dtStart = (DtStart)this.getProperty("DTSTART");
        return dtStart != null && dtStart.getDate() != null && DateTime.class.isInstance(dtStart.getDate());
    }

    @Override
    public boolean hasEndDate() {
        return false;
    }

    @Override
    public boolean hasEndTime() {
        return false;
    }

    @Override
    public void setBeginDate(Date date) {
        if (date == null) {
            this.removeProperty("DTSTART");
        } else {
            this.putProperty((Property)new DtStart(new net.fortuna.ical4j.model.Date(date)));
        }
    }

    @Override
    public void setBeginTime(Date date) {
        if (date == null) {
            this.removeProperty("DTSTART");
        } else {
            TimeZone timeZone = CalendarJournalEntry.getTimeZone();
            Calendar calendar = Calendar.getInstance((java.util.TimeZone)timeZone);
            calendar.setTimeInMillis(date.getTime());
            DateTime dateTime = new DateTime(calendar.getTime());
            dateTime.setUtc(false);
            dateTime.setTimeZone(timeZone);
            this.putProperty((Property)new DtStart((net.fortuna.ical4j.model.Date)dateTime));
        }
    }

    @Override
    public void setEndDate(Date date) {
    }

    @Override
    public void setEndTime(Date date) {
    }

    @Override
    public String writeStatus() {
        return CalendarJournalEntry.writeStatus(this.getStatus());
    }

    public static String writeStatus(Status status) {
        return CalendarJournalEntry.writeStatusForJournal(status);
    }
}

