/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntryPanel;
import com.openindex.openestate.tool.calendar.CalendarJournalEntry;
import com.openindex.openestate.tool.utils.FormatRule;
import com.openindex.openestate.tool.utils.ModificationHandler;
import com.openindex.openestate.tool.utils.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.Component;
import java.text.Format;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VJournal;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Status;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXDatePicker;

public class CalendarJournalEntryPanel
extends CalendarEntryPanel<CalendarJournalEntry> {
    private ResourceMap resourceMap;
    private ModificationHandler modifications;
    private JXDatePicker journalDateField;
    private JComboBox journalStatusField;

    public CalendarJournalEntryPanel() {
        this.build();
    }

    private void build() {
        this.modifications = ImmoToolUtils.createModificationHandler();
        this.resourceMap = ImmoToolUtils.getResourceMap(CalendarJournalEntryPanel.class);
        this.buildPanel();
        this.resourceMap.injectComponents((Component)((Object)this));
    }

    @Override
    public CalendarJournalEntry createEntry() {
        return new CalendarJournalEntry();
    }

    @Override
    protected JPanel createEntryPanel() {
        this.journalDateField = new JXDatePicker();
        this.journalDateField.setName("journalDateField");
        this.journalStatusField = new JComboBox<Object>(new Object[]{" [ " + this.resourceMap.getString("label.status.select", new Object[0]) + " ] ", new StatusItem(Status.VJOURNAL_CANCELLED), new StatusItem(Status.VJOURNAL_DRAFT), new StatusItem(Status.VJOURNAL_FINAL)});
        this.journalStatusField.setName("journalStatusField");
        this.getValidationHandler().putRule((JComponent)this.journalDateField, (ValidationRule)new FormatRule((Format)this.journalDateField.getFormats()[0]));
        this.getValidationHandler().putRule((JComponent)this.journalStatusField, (ValidationRule)new NonEmptyComboBoxRule(this.journalStatusField));
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:[50dlu,pref], 3dlu, pref:grow, 3dlu, right:pref, 3dlu, pref:grow");
        defaultFormBuilder.border(Borders.DIALOG);
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("formTitle", new Object[0])), 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.date", new Object[0]), (Component)this.journalDateField);
        defaultFormBuilder.append(this.resourceMap.getString("label.status", new Object[0]), (Component)this.journalStatusField);
        defaultFormBuilder.nextLine();
        return defaultFormBuilder.getPanel();
    }

    @Override
    public String getTitle() {
        return this.resourceMap.getString("title", new Object[0]);
    }

    public boolean isFormEnabled() {
        return true;
    }

    @Override
    public boolean isFormModified() {
        return this.modifications.isModified() || super.isFormModified();
    }

    public boolean isFormUsable() {
        return true;
    }

    @Override
    public void load(CalendarJournalEntry calendarJournalEntry) throws ImmoToolException {
        Status status;
        super.load(calendarJournalEntry);
        DtStart dtStart = calendarJournalEntry != null ? ((VJournal)calendarJournalEntry.getComponent()).getStartDate() : null;
        this.journalDateField.setDate((java.util.Date)(dtStart != null ? dtStart.getDate() : null));
        this.journalStatusField.setSelectedIndex(0);
        Status status2 = status = calendarJournalEntry != null ? ((VJournal)calendarJournalEntry.getComponent()).getStatus() : null;
        if (status != null) {
            for (int i = 1; i < this.journalStatusField.getItemCount(); ++i) {
                StatusItem statusItem = (StatusItem)this.journalStatusField.getItemAt(i);
                if (!statusItem.getStatus().equals((Object)status)) continue;
                this.journalStatusField.setSelectedIndex(i);
                break;
            }
        }
        this.getValidationHandler().validate();
        this.modifications.clear();
        this.modifications.putValue((JComponent)this.journalDateField);
        this.modifications.putValue((JComponent)this.journalStatusField);
    }

    @Override
    public void save(CalendarJournalEntry calendarJournalEntry) throws ImmoToolException {
        super.save(calendarJournalEntry);
        calendarJournalEntry.putProperty((Property)new DtStart(new Date(this.journalDateField.getDate())));
        if (this.journalStatusField.getSelectedIndex() <= 0) {
            calendarJournalEntry.removeProperty("STATUS");
        } else {
            calendarJournalEntry.putProperty((Property)((StatusItem)this.journalStatusField.getSelectedItem()).getStatus());
        }
    }

    @Override
    public void setDate(java.util.Date date) {
        this.journalDateField.setDate(date);
    }

    @Override
    public void setDateInterval(java.util.Date date, java.util.Date date2) {
        this.journalDateField.setDate(date);
    }

    @Override
    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.journalDateField.setEditable(bl);
        this.journalStatusField.setEnabled(bl);
    }

    private static class StatusItem {
        private Status status;

        protected StatusItem(Status status) {
            this.status = status;
        }

        public Status getStatus() {
            return this.status;
        }

        public String toString() {
            return " " + CalendarJournalEntry.writeStatus(this.status);
        }
    }
}

