/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDb;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarEventEntry;
import com.openindex.openestate.tool.calendar.CalendarJournalEntry;
import com.openindex.openestate.tool.calendar.CalendarPluginUtils;
import com.openindex.openestate.tool.calendar.CalendarSource;
import com.openindex.openestate.tool.calendar.CalendarTodoEntry;
import com.openindex.openestate.tool.calendar.utils.XCalUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.xml.transform.TransformerException;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.filter.Filter;
import net.fortuna.ical4j.filter.PeriodRule;
import net.fortuna.ical4j.filter.Rule;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VJournal;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Version;
import org.apache.log4j.Logger;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class CalendarObject {
    private static final Logger LOGGER = Logger.getLogger(CalendarObject.class);
    public static final CalendarBuilder BUILDER = new CalendarBuilder();
    public static final int EVENT = 1;
    public static final int TODO = 2;
    public static final int JOURNAL = 4;
    private Calendar calendar;
    private long id = 0L;

    public CalendarObject() {
        this(CalendarObject.newCalendar());
    }

    public CalendarObject(Calendar calendar) {
        this.calendar = calendar;
    }

    public void add(CalendarEntry calendarEntry) {
        if (calendarEntry.getUId() == null) {
            calendarEntry.putProperty((Property)CalendarEventEntry.generateUid());
        }
        this.calendar.getComponents().add(calendarEntry.getComponent());
    }

    public static CalendarObject create(CalendarSource calendarSource) {
        if (calendarSource == null) {
            return null;
        }
        CalendarObject calendarObject = new CalendarObject();
        calendarObject.setId(calendarSource.getCalendarId());
        return calendarObject;
    }

    public static CalendarObject createFromICal(InputStream inputStream) throws ImmoToolException {
        try {
            return new CalendarObject(BUILDER.build(inputStream));
        }
        catch (Exception exception) {
            throw new ImmoToolException((Throwable)exception);
        }
    }

    public static CalendarObject createFromICal(Reader reader) throws ImmoToolException {
        try {
            return new CalendarObject(BUILDER.build(reader));
        }
        catch (Exception exception) {
            throw new ImmoToolException((Throwable)exception);
        }
    }

    public static CalendarObject createFromXCal(InputStream inputStream) throws ImmoToolException {
        return CalendarObject.createFromXCal(new InputStreamReader(inputStream));
    }

    public static CalendarObject createFromXCal(Reader reader) throws ImmoToolException {
        try {
            return new CalendarObject(XCalUtils.read(reader));
        }
        catch (Exception exception) {
            throw new ImmoToolException((Throwable)exception);
        }
    }

    public static void defaultCalendar(CalendarObject calendarObject) {
        calendarObject.putProperty((Property)new ProdId("-//OpenEstate.org//iCal4j 1.0//EN"));
        calendarObject.putProperty((Property)Version.VERSION_2_0);
        calendarObject.putProperty((Property)CalScale.GREGORIAN);
    }

    public CalendarEntry[] filterEntries(Date date, Date date2, boolean bl) {
        return this.filterEntries(date, date2, null, bl);
    }

    public CalendarEntry[] filterEntries(Date date, Date date2, String string, boolean bl) {
        Period period = new Period(new DateTime(date), new DateTime(date2));
        Filter filter = new Filter(new Rule[]{new PeriodRule(period)}, 2);
        ComponentList componentList = string != null ? this.getCalendar().getComponents(string) : this.getCalendar().getComponents();
        Collection collection = filter.filter((Collection)componentList);
        ArrayList<CalendarEntry> arrayList = new ArrayList<CalendarEntry>();
        for (Object e : collection) {
            CalendarEntry calendarEntry;
            VEvent vEvent;
            if (e instanceof VEvent) {
                vEvent = (VEvent)e;
                calendarEntry = new CalendarEventEntry(vEvent);
                calendarEntry.setCalendarId(calendarEntry.getLocalCalendarIdFromComment());
                if (!bl) {
                    arrayList.add(calendarEntry);
                    continue;
                }
                PeriodList periodList = vEvent.calculateRecurrenceSet(period);
                for (Object e2 : periodList) {
                    try {
                        Period period2 = (Period)e2;
                        CalendarEventEntry calendarEventEntry = new CalendarEventEntry((VEvent)vEvent.copy());
                        calendarEventEntry.setCalendarId(calendarEntry.getCalendarId());
                        if (((CalendarEventEntry)calendarEntry).hasBeginDate()) {
                            calendarEventEntry.setBeginDate((Date)period2.getStart());
                        } else if (((CalendarEventEntry)calendarEntry).hasBeginTime()) {
                            calendarEventEntry.setBeginTime((Date)period2.getStart());
                        }
                        if (((CalendarEventEntry)calendarEntry).hasEndDate()) {
                            calendarEventEntry.setEndDate((Date)period2.getEnd());
                        } else if (((CalendarEventEntry)calendarEntry).hasEndTime()) {
                            calendarEventEntry.setEndTime((Date)period2.getEnd());
                        }
                        arrayList.add(calendarEventEntry);
                    }
                    catch (Exception exception) {
                        LOGGER.warn((Object)"Can't copy recurred calendar entry!");
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                }
                continue;
            }
            if (e instanceof VToDo) {
                vEvent = (VToDo)e;
                calendarEntry = new CalendarTodoEntry((VToDo)vEvent);
                calendarEntry.setCalendarId(calendarEntry.getLocalCalendarIdFromComment());
                arrayList.add(calendarEntry);
                continue;
            }
            if (!(e instanceof VJournal)) continue;
            vEvent = (VJournal)e;
            calendarEntry = new CalendarJournalEntry((VJournal)vEvent);
            calendarEntry.setCalendarId(calendarEntry.getLocalCalendarIdFromComment());
            arrayList.add(calendarEntry);
        }
        return arrayList.toArray(new CalendarEntry[arrayList.size()]);
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public CalendarEntry[] getEntries() {
        return this.getEntries(null);
    }

    public CalendarEntry[] getEntries(String string) {
        ArrayList<CalendarEntry> arrayList = new ArrayList<CalendarEntry>();
        ComponentList componentList = string != null ? this.getCalendar().getComponents(string) : this.getCalendar().getComponents();
        for (int i = 0; i < componentList.size(); ++i) {
            VEvent vEvent;
            Component component = (Component)componentList.get(i);
            if (component instanceof VEvent) {
                vEvent = (VEvent)component;
                if (vEvent.getUid() == null) continue;
                arrayList.add(new CalendarEventEntry(vEvent));
                continue;
            }
            if (component instanceof VJournal) {
                vEvent = (VJournal)component;
                if (vEvent.getUid() == null) continue;
                arrayList.add(new CalendarJournalEntry((VJournal)vEvent));
                continue;
            }
            if (!(component instanceof VToDo) || (vEvent = (VToDo)component).getUid() == null) continue;
            arrayList.add(new CalendarTodoEntry((VToDo)vEvent));
        }
        return arrayList.toArray(new CalendarEntry[arrayList.size()]);
    }

    public CalendarEventEntry[] getEventEntries() {
        ArrayList<CalendarEventEntry> arrayList = new ArrayList<CalendarEventEntry>();
        for (CalendarEntry calendarEntry : this.getEntries("VEVENT")) {
            arrayList.add((CalendarEventEntry)calendarEntry);
        }
        return arrayList.toArray(new CalendarEventEntry[arrayList.size()]);
    }

    public CalendarEntry getFirstEntry() {
        return this.getFirstEntry(null);
    }

    public CalendarEntry getFirstEntry(String string) {
        ComponentList componentList = string != null ? this.getCalendar().getComponents(string) : this.getCalendar().getComponents();
        for (int i = 0; i < componentList.size(); ++i) {
            VEvent vEvent;
            Component component = (Component)componentList.get(i);
            if (component instanceof VEvent) {
                vEvent = (VEvent)component;
                if (vEvent.getUid() == null) continue;
                return new CalendarEventEntry(vEvent);
            }
            if (component instanceof VJournal) {
                vEvent = (VJournal)component;
                if (vEvent.getUid() == null) continue;
                return new CalendarJournalEntry((VJournal)vEvent);
            }
            if (!(component instanceof VToDo) || (vEvent = (VToDo)component).getUid() == null) continue;
            return new CalendarTodoEntry((VToDo)vEvent);
        }
        return null;
    }

    public CalendarEventEntry getFirstEventEntry() {
        return (CalendarEventEntry)this.getFirstEntry("VEVENT");
    }

    public CalendarJournalEntry getFirstJournalEntry() {
        return (CalendarJournalEntry)this.getFirstEntry("VJOURNAL");
    }

    public CalendarTodoEntry getFirstTodoEntry() {
        return (CalendarTodoEntry)this.getFirstEntry("VTODO");
    }

    public PropertyList getProperties() {
        return this.getCalendar().getProperties();
    }

    public Property getProperty(String string) {
        return this.getProperties().getProperty(string);
    }

    public long getId() {
        return this.id;
    }

    public CalendarJournalEntry[] getJournalEntries() {
        ArrayList<CalendarJournalEntry> arrayList = new ArrayList<CalendarJournalEntry>();
        for (CalendarEntry calendarEntry : this.getEntries("VJOURNAL")) {
            arrayList.add((CalendarJournalEntry)calendarEntry);
        }
        return arrayList.toArray(new CalendarJournalEntry[arrayList.size()]);
    }

    public CalendarTodoEntry[] getTodoEntries() {
        ArrayList<CalendarTodoEntry> arrayList = new ArrayList<CalendarTodoEntry>();
        for (CalendarEntry calendarEntry : this.getEntries("VTODO")) {
            arrayList.add((CalendarTodoEntry)calendarEntry);
        }
        return arrayList.toArray(new CalendarTodoEntry[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CalendarObject load(long l) throws ImmoToolDbException {
        org.xmldb.api.base.Collection collection = null;
        try {
            collection = CalendarPluginUtils.openPluginCollection("");
            CalendarObject calendarObject = CalendarObject.load(l, collection);
            return calendarObject;
        }
        finally {
            ImmoToolDbUtils.close((org.xmldb.api.base.Collection)collection);
        }
    }

    public static CalendarObject load(long l, org.xmldb.api.base.Collection collection) throws ImmoToolDbException {
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Calendar")) {
                throw new ImmoToolDbException("invalid collection!");
            }
            String string = "calendar." + l + ".xml";
            String string2 = "document('ImmoTool/OpenEstate-Calendar/" + string + "')";
            ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((org.xmldb.api.base.Collection)collection, (String)string2);
            XMLResource xMLResource = (XMLResource)resourceSet.getResource(0L);
            CalendarObject calendarObject = CalendarObject.createFromXCal(new StringReader((String)xMLResource.getContent()));
            calendarObject.setId(l);
            return calendarObject;
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public static Calendar newCalendar() {
        CalendarObject calendarObject = new CalendarObject(new Calendar());
        CalendarObject.defaultCalendar(calendarObject);
        return calendarObject.getCalendar();
    }

    public void putProperty(Property property) {
        Property property2 = null;
        try {
            property2 = this.getProperty(property.getName());
            if (property2 != null) {
                this.getProperties().remove(property2);
            }
            this.getProperties().add(property);
        }
        catch (Exception exception) {
            if (property2 != null) {
                this.removeProperty(property2.getName());
            }
            LOGGER.warn((Object)("could not put property: " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() throws ImmoToolDbException {
        org.xmldb.api.base.Collection collection = null;
        try {
            collection = CalendarPluginUtils.openPluginCollection("");
            this.remove(collection);
        }
        finally {
            ImmoToolDbUtils.close((org.xmldb.api.base.Collection)collection);
        }
    }

    public void remove(org.xmldb.api.base.Collection collection) throws ImmoToolDbException {
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Calendar")) {
                throw new ImmoToolDbException("invalid collection!");
            }
            String string = "calendar." + this.getId() + ".xml";
            if (!ImmoToolDbUtils.hasResource((org.xmldb.api.base.Collection)collection, (String)string)) {
                throw new Exception("unknown resource: " + string);
            }
            XMLResource xMLResource = ImmoToolDbUtils.loadXMLResource((org.xmldb.api.base.Collection)collection, (String)string);
            if (xMLResource == null) {
                throw new Exception("resource not found: " + string);
            }
            ImmoToolDbUtils.removeResource((org.xmldb.api.base.Collection)collection, (Resource)xMLResource);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void removeProperty(String string) {
        Property property = this.getProperty(string);
        if (property != null) {
            this.getProperties().remove(property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws ImmoToolDbException {
        org.xmldb.api.base.Collection collection = null;
        try {
            collection = CalendarPluginUtils.openPluginCollection("");
            this.save(collection);
        }
        finally {
            ImmoToolDbUtils.close((org.xmldb.api.base.Collection)collection);
        }
    }

    public void save(org.xmldb.api.base.Collection collection) throws ImmoToolDbException {
        this.save(collection, ImmoToolApp.getApplication().getDatabase());
    }

    public void save(org.xmldb.api.base.Collection collection, ImmoToolDb immoToolDb) throws ImmoToolDbException {
        try {
            XMLResource xMLResource;
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Calendar")) {
                throw new ImmoToolDbException("invalid collection!");
            }
            if (this.getId() <= 0L) {
                this.setId(immoToolDb.getNextSequence("OpenEstate-Calendar.Calendar"));
            }
            if (this.getId() <= 0L) {
                throw new ImmoToolDbException("could not get sequence-value!");
            }
            String string = "calendar." + this.getId() + ".xml";
            XMLResource xMLResource2 = xMLResource = !ImmoToolDbUtils.hasResource((org.xmldb.api.base.Collection)collection, (String)string) ? ImmoToolDbUtils.createXmlResource((org.xmldb.api.base.Collection)collection, (String)string) : ImmoToolDbUtils.loadXMLResource((org.xmldb.api.base.Collection)collection, (String)string);
            if (xMLResource == null) {
                throw new Exception("unknown resource: " + string);
            }
            for (int i = 0; i < this.getCalendar().getComponents().size(); ++i) {
                VEvent vEvent;
                Component component = (Component)this.getCalendar().getComponents().get(i);
                if (component instanceof VEvent) {
                    vEvent = (VEvent)component;
                    if (vEvent.getUid() != null) continue;
                    vEvent.getProperties().add((Property)CalendarEntry.generateUid());
                    continue;
                }
                if (component instanceof VJournal) {
                    vEvent = (VJournal)component;
                    if (vEvent.getUid() != null) continue;
                    vEvent.getProperties().add((Property)CalendarEntry.generateUid());
                    continue;
                }
                if (!(component instanceof VToDo) || (vEvent = (VToDo)component).getUid() != null) continue;
                vEvent.getProperties().add((Property)CalendarEntry.generateUid());
            }
            StringWriter stringWriter = new StringWriter();
            CalendarObject.defaultCalendar(this);
            XCalUtils.write(this.getCalendar(), (Writer)stringWriter);
            xMLResource.setContent((Object)stringWriter.toString());
            ImmoToolDbUtils.storeResource((org.xmldb.api.base.Collection)collection, (Resource)xMLResource);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CalendarEntry[] search(long[] lArray, Status status, int n) throws ImmoToolDbException, XMLDBException, IOException, ParserException, TransformerException {
        org.xmldb.api.base.Collection collection = null;
        try {
            ResourceSet resourceSet;
            collection = CalendarPluginUtils.openPluginCollection("");
            String string = "declare namespace xCal=\"http://ietf.org/rfc/rfcXXXX.txt\";\ndeclare namespace util=\"http://exist-db.org/xquery/util\";\ndeclare namespace xmldb=\"http://exist-db.org/xquery/xmldb\";\ndeclare option exist:output-size-limit \"0\";\n";
            if (lArray != null && lArray.length > 0) {
                string = string + "let $cals := xmldb:document( ";
                for (int i = 0; i < lArray.length; ++i) {
                    if (i > 0) {
                        string = string + ", ";
                    }
                    string = string + "'ImmoTool/OpenEstate-Calendar/calendar." + lArray[i] + ".xml'";
                }
                string = string + " )//xCal:vcalendar\n";
            } else {
                string = string + "let $cals := xmldb:xcollection( 'ImmoTool/OpenEstate-Calendar' )//xCal:vcalendar\n";
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (status != null) {
                arrayList.add("$e/xCal:status/text()='" + status.getValue() + "'");
            }
            String string2 = "";
            if (!arrayList.isEmpty()) {
                string2 = string2 + "      where ";
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (i > 0) {
                        string2 = string2 + "and ";
                    }
                    string2 = string2 + "(" + (String)arrayList.get(i) + ") ";
                }
                string2 = string2 + "\n";
            }
            string = string + "return\n<iCalendar>\n<xCal:vcalendar xmlns:xCal=\"http://ietf.org/rfc/rfcXXXX.txt\">\n<xCal:prodid>-//OpenEstate.org//iCal4j 1.0//EN</xCal:prodid>\n<xCal:version>2.0</xCal:version>\n<xCal:calscale>GREGORIAN</xCal:calscale>\n";
            if ((n & 2) == 2) {
                string = string + "{\n  for $entry in $cals/xCal:vtodo\n" + string2 + "    return \n" + "      <" + "xCal" + ":vtodo>\n" + "        { for $node in $entry/* return $node }\n" + "        <" + "xCal" + ":comment>" + "LOCAL-CALENDAR" + ":{ util:document-name($entry) }</" + "xCal" + ":comment>\n" + "      </" + "xCal" + ":vtodo>\n" + "}\n";
            }
            if ((n & 4) == 4) {
                string = string + "{\n  for $entry in $cals/xCal:vjournal\n" + string2 + "    return \n" + "      <" + "xCal" + ":vjournal>\n" + "        { for $node in $entry/* return $node }\n" + "        <" + "xCal" + ":comment>" + "LOCAL-CALENDAR" + ":{ util:document-name($entry) }</" + "xCal" + ":comment>\n" + "      </" + "xCal" + ":vjournal>\n" + "}\n";
            }
            if ((n & 1) == 1) {
                string = string + "{\n  for $entry in $cals/xCal:vevent\n" + string2 + "    return \n" + "      <" + "xCal" + ":vevent>\n" + "        { for $node in $entry/* return $node }\n" + "        <" + "xCal" + ":comment>" + "LOCAL-CALENDAR" + ":{ util:document-name($entry) }</" + "xCal" + ":comment>\n" + "      </" + "xCal" + ":vevent>\n" + "}\n";
            }
            if ((resourceSet = ImmoToolDbUtils.executeXQuery((org.xmldb.api.base.Collection)collection, (String)(string = string + "</xCal:vcalendar>\n</iCalendar>"))) == null) {
                throw new ImmoToolDbException("Can't load result-calendar!");
            }
            XMLResource xMLResource = (XMLResource)resourceSet.getResource(0L);
            if (xMLResource == null) {
                throw new ImmoToolDbException("Can't get result-calendar!");
            }
            String string3 = xMLResource.getContent().toString();
            CalendarObject calendarObject = new CalendarObject();
            calendarObject.setCalendar(XCalUtils.read(new StringReader(string3.toString())));
            ArrayList<CalendarEntry> arrayList2 = new ArrayList<CalendarEntry>();
            for (CalendarEntry calendarEntry : calendarObject.getEntries()) {
                calendarEntry.setCalendarId(calendarEntry.getLocalCalendarIdFromComment());
                arrayList2.add(calendarEntry);
            }
            CalendarEntry[] calendarEntryArray = arrayList2.toArray(new CalendarEntry[arrayList2.size()]);
            return calendarEntryArray;
        }
        finally {
            ImmoToolDbUtils.close((org.xmldb.api.base.Collection)collection);
        }
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
        CalendarObject.defaultCalendar(this);
    }

    public void setId(long l) {
        this.id = l;
    }

    public static String wrap(String string) {
        return ImmoToolUtils.wrapAndIndentString((String)string, (String)"  ", (int)50).trim();
    }
}

