/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDb;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolPlugin;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolSetupPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolTaskException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntryDayPanel;
import com.openindex.openestate.tool.calendar.CalendarEntryMonthPanel;
import com.openindex.openestate.tool.calendar.CalendarEntryTablePanel;
import com.openindex.openestate.tool.calendar.CalendarEntryWeekPanel;
import com.openindex.openestate.tool.calendar.CalendarObject;
import com.openindex.openestate.tool.calendar.CalendarPluginUtils;
import com.openindex.openestate.tool.calendar.CalendarSetupGeneralPanel;
import com.openindex.openestate.tool.calendar.CalendarSource;
import com.openindex.openestate.tool.calendar.CalendarSourceSyncTask;
import com.openindex.openestate.tool.calendar.CalendarSourceTablePanel;
import com.openindex.openestate.tool.utils.JOptionFileChooser;
import com.openindex.openestate.tool.utils.TabComponent;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskEvent;
import org.jdesktop.application.TaskListener;
import org.jdesktop.swingx.JXTaskPane;
import org.xmldb.api.base.Collection;

public final class CalendarPlugin
extends ImmoToolPlugin {
    private static final Logger LOGGER = Logger.getLogger(CalendarPlugin.class);
    public static final String PLUGIN_NAME = "OpenEstate-Calendar";
    public static final String PLUGIN_URL = "http://media.openestate.org/Plugins/OpenEstate-Tool-Calendar.xml";
    public static final String PLUGIN_DB_PATH = "ImmoTool/OpenEstate-Calendar";
    public static final String PLUGIN_RES_PATH = "/com/openindex/openestate/tool/calendar/resources/";
    public static final String KEY_WORKTIME_BEGIN = "Calendar.WorkTime.Begin";
    public static final String KEY_WORKTIME_END = "Calendar.WorkTime.End";
    public static final String DB_SEQUENCE_CALENDAR = "OpenEstate-Calendar.Calendar";
    public static final Color JOURNAL_BG_COLOR = new Color(255, 244, 191);
    public static final ImageIcon JOURNAL_ICON = new ImageIcon(CalendarEntryDayPanel.class.getResource("/com/openindex/openestate/tool/calendar/resources/icons/16x16/journal.png"));
    public static final ImageIcon JOURNAL_ICON_DISABLED = ImmoToolUtils.toGray((ImageIcon)JOURNAL_ICON);
    public static final Color TODO_BG_COLOR = new Color(191, 255, 206);
    public static final ImageIcon TODO_ICON = new ImageIcon(CalendarEntryDayPanel.class.getResource("/com/openindex/openestate/tool/calendar/resources/icons/16x16/todo.png"));
    public static final ImageIcon TODO_ICON_DISABLED = ImmoToolUtils.toGray((ImageIcon)TODO_ICON);
    public static final Color EVENT_BG_COLOR = new Color(255, 202, 191);
    public static final ImageIcon EVENT_ICON = new ImageIcon(CalendarEntryDayPanel.class.getResource("/com/openindex/openestate/tool/calendar/resources/icons/16x16/event.png"));
    public static final ImageIcon EVENT_ICON_DISABLED = ImmoToolUtils.toGray((ImageIcon)EVENT_ICON);

    public HelpSet createHelpSet() throws HelpSetException {
        URL uRL = ((Object)((Object)this)).getClass().getResource("/com/openindex/openestate/tool/calendar/resources/help/help.hs");
        return new HelpSet(null, uRL);
    }

    public JMenu createMenu() {
        JMenu jMenu = new JMenu(this.getResourceMap().getString("Title", new Object[0]));
        jMenu.add(new JMenuItem(this.getActionMap().get("doShowMonthView")));
        jMenu.add(new JMenuItem(this.getActionMap().get("doShowWeekView")));
        jMenu.add(new JMenuItem(this.getActionMap().get("doShowDayView")));
        jMenu.add(new JMenuItem(this.getActionMap().get("doShowTableView")));
        jMenu.addSeparator();
        jMenu.add(new JMenuItem(this.getActionMap().get("doShowSources")));
        jMenu.add(new JMenuItem(this.getActionMap().get("doSync")));
        return jMenu;
    }

    public List<ImmoToolSetupPanel> createSetupPanels() {
        List list = super.createSetupPanels();
        list.add(new CalendarSetupGeneralPanel());
        return list;
    }

    public JXTaskPane createTaskPane() {
        JXTaskPane jXTaskPane = new JXTaskPane();
        jXTaskPane.setTitle(this.getResourceMap().getString("Title", new Object[0]));
        jXTaskPane.add(this.getActionMap().get("doShowMonthView"));
        jXTaskPane.add(this.getActionMap().get("doShowWeekView"));
        jXTaskPane.add(this.getActionMap().get("doShowDayView"));
        jXTaskPane.add(this.getActionMap().get("doShowTableView"));
        return jXTaskPane;
    }

    public void destroy() {
    }

    @Action
    public Task doShowDayView() {
        String string = CalendarEntryDayPanel.getInstanceTabTitle();
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        final ResourceMap resourceMap = this.getResourceMap();
        return new ImmoToolTask<CalendarEntryDayPanel>(){

            protected CalendarEntryDayPanel executeTask() throws Exception {
                CalendarEntryDayPanel calendarEntryDayPanel = new CalendarEntryDayPanel();
                calendarEntryDayPanel.loadSources();
                return calendarEntryDayPanel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.cantLoadCalendarView", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(CalendarEntryDayPanel calendarEntryDayPanel) {
                super.succeeded((Object)calendarEntryDayPanel);
                Task task = calendarEntryDayPanel.doTodayPage();
                if (task == null) {
                    ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.cantLoadCalendarView", new Object[0]));
                    return;
                }
                ImmoToolUtils.showPanel((TabComponent)calendarEntryDayPanel);
                ImmoToolUtils.executeTask((Task)task);
            }
        };
    }

    @Action
    public Task doShowMonthView() {
        String string = CalendarEntryMonthPanel.getInstanceTabTitle();
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        final ResourceMap resourceMap = this.getResourceMap();
        return new ImmoToolTask<CalendarEntryMonthPanel>(){

            protected CalendarEntryMonthPanel executeTask() throws ImmoToolTaskException {
                try {
                    CalendarEntryMonthPanel calendarEntryMonthPanel = new CalendarEntryMonthPanel();
                    calendarEntryMonthPanel.loadSources();
                    return calendarEntryMonthPanel;
                }
                catch (Exception exception) {
                    throw new ImmoToolTaskException((Throwable)exception);
                }
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.cantLoadCalendarView", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(CalendarEntryMonthPanel calendarEntryMonthPanel) {
                super.succeeded((Object)calendarEntryMonthPanel);
                Task task = calendarEntryMonthPanel.doTodayPage();
                if (task == null) {
                    ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.cantLoadCalendarView", new Object[0]));
                    return;
                }
                ImmoToolUtils.showPanel((TabComponent)calendarEntryMonthPanel);
                ImmoToolUtils.executeTask((Task)task);
            }
        };
    }

    @Action
    public Task doShowSources() {
        String string = CalendarSourceTablePanel.getInstanceTabTitle();
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        final CalendarSourceTablePanel calendarSourceTablePanel = new CalendarSourceTablePanel();
        Task task = calendarSourceTablePanel.doRefresh();
        task.addTaskListener(new TaskListener(){

            public void doInBackground(TaskEvent taskEvent) {
            }

            public void process(TaskEvent taskEvent) {
            }

            public void succeeded(TaskEvent taskEvent) {
                ImmoToolUtils.showPanel((TabComponent)calendarSourceTablePanel);
            }

            public void failed(TaskEvent taskEvent) {
                ImmoToolUtils.showMessageErrorDialog((String)CalendarPlugin.this.getResourceMap().getString("error.cantLoadCalendarSources", new Object[0]));
            }

            public void cancelled(TaskEvent taskEvent) {
            }

            public void interrupted(TaskEvent taskEvent) {
            }

            public void finished(TaskEvent taskEvent) {
            }
        });
        return task;
    }

    @Action
    public Task doShowTableView() {
        String string = CalendarEntryTablePanel.getInstanceTabTitle();
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        final ResourceMap resourceMap = this.getResourceMap();
        return new ImmoToolTask<CalendarEntryTablePanel>(){

            protected CalendarEntryTablePanel executeTask() throws ImmoToolTaskException {
                try {
                    CalendarEntryTablePanel calendarEntryTablePanel = new CalendarEntryTablePanel();
                    calendarEntryTablePanel.loadSources();
                    return calendarEntryTablePanel;
                }
                catch (Exception exception) {
                    throw new ImmoToolTaskException((Throwable)exception);
                }
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.cantLoadCalendarView", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(CalendarEntryTablePanel calendarEntryTablePanel) {
                super.succeeded((Object)calendarEntryTablePanel);
                ImmoToolUtils.showPanel((TabComponent)calendarEntryTablePanel);
                Task task = calendarEntryTablePanel.doSearch();
                if (task == null) {
                    ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.cantLoadCalendarView", new Object[0]));
                    return;
                }
                ImmoToolUtils.showPanel((TabComponent)calendarEntryTablePanel);
                ImmoToolUtils.executeTask((Task)task);
            }
        };
    }

    @Action
    public Task doShowWeekView() {
        String string = CalendarEntryWeekPanel.getInstanceTabTitle();
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        final ResourceMap resourceMap = this.getResourceMap();
        return new ImmoToolTask<CalendarEntryWeekPanel>(){

            protected CalendarEntryWeekPanel executeTask() throws ImmoToolTaskException {
                try {
                    CalendarEntryWeekPanel calendarEntryWeekPanel = new CalendarEntryWeekPanel();
                    calendarEntryWeekPanel.loadSources();
                    return calendarEntryWeekPanel;
                }
                catch (Exception exception) {
                    throw new ImmoToolTaskException((Throwable)exception);
                }
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.cantLoadCalendarView", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(CalendarEntryWeekPanel calendarEntryWeekPanel) {
                super.succeeded((Object)calendarEntryWeekPanel);
                Task task = calendarEntryWeekPanel.doTodayPage();
                if (task == null) {
                    ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.cantLoadCalendarView", new Object[0]));
                    return;
                }
                ImmoToolUtils.showPanel((TabComponent)calendarEntryWeekPanel);
                ImmoToolUtils.executeTask((Task)task);
            }
        };
    }

    @Action
    public Task doSync() {
        final ResourceMap resourceMap = this.getResourceMap();
        return new ImmoToolTask<ImmoToolTaskDialog>(){

            protected ImmoToolTaskDialog executeTask() throws ImmoToolTaskException {
                try {
                    int n = 0;
                    ImmoToolTaskDialog immoToolTaskDialog = new ImmoToolTaskDialog();
                    for (CalendarSource calendarSource : CalendarSource.loadSources()) {
                        if (calendarSource.isDbSource()) continue;
                        ++n;
                        immoToolTaskDialog.addTask((ImmoToolTask)new CalendarSourceSyncTask(calendarSource));
                    }
                    return n > 0 ? immoToolTaskDialog : null;
                }
                catch (Exception exception) {
                    throw new ImmoToolTaskException((Throwable)exception);
                }
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)resourceMap.getString("error.cantSyncExternalCalendars", new Object[0]), (Throwable)throwable);
            }

            protected void succeeded(ImmoToolTaskDialog immoToolTaskDialog) {
                super.succeeded((Object)immoToolTaskDialog);
                if (immoToolTaskDialog == null) {
                    ImmoToolUtils.showMessageInfoDialog((String)resourceMap.getString("message.noExternalCalendarsConfigured", new Object[0]));
                } else {
                    immoToolTaskDialog.execute();
                }
            }
        };
    }

    public void exportDatabase(File file, ImmoToolDb immoToolDb, ImmoToolProject immoToolProject, JOptionFileChooser jOptionFileChooser, ImmoToolTask.Callback callback) throws ImmoToolException {
        File file2 = new File(file.getAbsolutePath() + File.separator + "OpenEstate-Tool-Calendar");
        if (!file2.exists() && !file2.mkdir()) {
            throw new ImmoToolException("Can't create directory: " + file2.getAbsolutePath());
        }
        File file3 = new File(file2.getAbsolutePath() + File.separator + "calendars");
        if (!file3.exists() && !file3.mkdir()) {
            throw new ImmoToolException("Can't create directory: " + file3.getAbsolutePath());
        }
        File file4 = new File(file2.getAbsolutePath() + File.separator + "entries");
        if (!file4.exists() && !file4.mkdir()) {
            throw new ImmoToolException("Can't create directory: " + file4.getAbsolutePath());
        }
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        String string = "exported at " + dateFormat.format(new Date());
        Collection collection = null;
        try {
            collection = CalendarPluginUtils.openPluginCollection("");
            for (CalendarSource calendarSource : CalendarSource.loadSources(collection)) {
                Object object;
                FileOutputStream fileOutputStream = null;
                try {
                    if (callback != null) {
                        callback.setMessage("> /source." + calendarSource.getCalendarId() + ".xml");
                    }
                    object = new Properties();
                    calendarSource.save((Properties)object);
                    fileOutputStream = new FileOutputStream(new File(file3.getAbsolutePath() + File.separator + calendarSource.getCalendarId() + ".xml"));
                    ((Properties)object).storeToXML(fileOutputStream, string);
                    fileOutputStream.flush();
                }
                catch (Exception exception) {
                    try {
                        if (callback != null) {
                            callback.setMessage("> Can't save setup for calendar #" + calendarSource.getCalendarId());
                            callback.setMessage("> " + exception.getLocalizedMessage());
                        }
                        throw new Exception("Can't save setup for calendar #" + calendarSource.getCalendarId(), exception);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fileOutputStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
                object = null;
                try {
                    CalendarObject calendarObject = CalendarObject.load(calendarSource.getCalendarId(), collection);
                    object = new FileWriter(file4.getAbsolutePath() + File.separator + calendarSource.getCalendarId() + ".ics");
                    ((Writer)object).write(calendarObject.getCalendar().toString());
                }
                catch (Exception exception) {
                    if (callback != null) {
                        callback.setMessage("> Can't save entries for calendar #" + calendarSource.getCalendarId());
                        callback.setMessage("> " + exception.getLocalizedMessage());
                    }
                    throw new Exception("Can't save entries for calendar #" + calendarSource.getCalendarId(), exception);
                }
                finally {
                    IOUtils.closeQuietly((Writer)object);
                }
            }
        }
        catch (Exception exception) {
            if (callback != null) {
                callback.setMessage("> Can't save calendars!");
                callback.setMessage("> " + exception.getLocalizedMessage());
            }
            throw new ImmoToolException("Can't save calendars!", (Throwable)exception);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public BufferedImage getIcon() {
        try {
            return ImageIO.read(((Object)((Object)this)).getClass().getResourceAsStream(this.getResourceMap().getString("Plugin.Icon", new Object[0])));
        }
        catch (Exception exception) {
            LOGGER.error((Object)"could not load plugin-icon!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return null;
        }
    }

    public static CalendarPlugin getInstance() {
        return (CalendarPlugin)ImmoToolApp.getApplication().getProject().getPlugin(PLUGIN_NAME);
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public static Calendar getWorkTimeBegin() {
        String[] stringArray;
        String string = ImmoToolApp.getApplication().getProject().getProperty(KEY_WORKTIME_BEGIN, null);
        int[] nArray = null;
        if (string != null && (stringArray = string.split("-")).length == 2) {
            nArray = new int[2];
            try {
                nArray[0] = Integer.valueOf(stringArray[0]);
                nArray[1] = Integer.valueOf(stringArray[1]);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)("Invalid begin of worktime: " + ArrayUtils.toString((Object)stringArray)), (Throwable)exception);
                nArray = null;
            }
        }
        stringArray = Calendar.getInstance();
        stringArray.set(6, 1);
        stringArray.set(1, 2000);
        stringArray.set(11, nArray != null ? nArray[0] : 0);
        stringArray.set(12, nArray != null ? nArray[1] : 0);
        stringArray.set(13, 0);
        stringArray.set(14, 0);
        return stringArray;
    }

    public static Calendar getWorkTimeEnd() {
        String[] stringArray;
        String string = ImmoToolApp.getApplication().getProject().getProperty(KEY_WORKTIME_END, null);
        int[] nArray = null;
        if (string != null && (stringArray = string.split("-")).length == 2) {
            nArray = new int[2];
            try {
                nArray[0] = Integer.valueOf(stringArray[0]);
                nArray[1] = Integer.valueOf(stringArray[1]);
            }
            catch (Exception exception) {
                LOGGER.warn((Object)("Invalid end of worktime: " + ArrayUtils.toString((Object)stringArray)), (Throwable)exception);
                nArray = null;
            }
        }
        stringArray = Calendar.getInstance();
        stringArray.set(6, 1);
        stringArray.set(1, 2000);
        stringArray.set(11, nArray != null ? nArray[0] : 23);
        stringArray.set(12, nArray != null ? nArray[1] : 59);
        stringArray.set(13, 59);
        stringArray.set(14, 0);
        return stringArray;
    }

    public final URI getURI() {
        try {
            return new URL(PLUGIN_URL).toURI();
        }
        catch (Exception exception) {
            throw new RuntimeException("could not load plugin: " + exception.getLocalizedMessage(), exception);
        }
    }

    public boolean hasOptions() {
        return false;
    }

    public void init(Object ... objectArray) {
    }

    public void initDatabase(ImmoToolDb immoToolDb, ImmoToolProject immoToolProject, ImmoToolTask.Callback callback) throws ImmoToolException {
        super.initDatabase(immoToolDb, immoToolProject, callback);
        Collection collection = null;
        try {
            collection = CalendarPluginUtils.openPluginCollection(immoToolDb, "");
            if (collection == null) {
                collection = immoToolDb.createCollection(PLUGIN_DB_PATH);
            }
            if (immoToolDb.getCurrentSequence(DB_SEQUENCE_CALENDAR) == 0L) {
                CalendarSource calendarSource = new CalendarSource();
                calendarSource.setType(0);
                calendarSource.setName(this.getResourceMap().getString("label.defaultCalendar.business", new Object[0]));
                calendarSource.setDescription(this.getResourceMap().getString("label.defaultCalendar.business.info", new Object[0]));
                calendarSource.save(collection, immoToolDb);
                calendarSource = new CalendarSource();
                calendarSource.setType(0);
                calendarSource.setName(this.getResourceMap().getString("label.defaultCalendar.private", new Object[0]));
                calendarSource.setDescription(this.getResourceMap().getString("label.defaultCalendar.private.info", new Object[0]));
                calendarSource.save(collection, immoToolDb);
            }
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("db-init-error: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void load() {
        super.load();
    }

    public void openOptions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildDatabase(ImmoToolDb immoToolDb, ImmoToolProject immoToolProject, ImmoToolTask.Callback callback) {
        Collection collection = null;
        try {
            collection = CalendarPluginUtils.openPluginCollection("");
            for (CalendarSource calendarSource : CalendarSource.loadSources(collection)) {
                try {
                    if (callback != null) {
                        callback.setMessage("> /source." + calendarSource.getCalendarId() + ".xml");
                    }
                    calendarSource.save(collection);
                }
                catch (Exception exception) {
                    LOGGER.warn((Object)("Can't rebuild calendar #" + calendarSource.getCalendarId()));
                    LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    if (callback == null) continue;
                    callback.setMessage("> ERROR: " + exception.getLocalizedMessage());
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't rebuild calendars!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            if (callback != null) {
                callback.setMessage("> ERROR: " + exception.getLocalizedMessage());
            }
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static void setWorkTimeBegin(Date date) {
        if (date == null) {
            CalendarPlugin.setWorkTimeBegin((Calendar)null);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        CalendarPlugin.setWorkTimeBegin(calendar);
    }

    public static void setWorkTimeBegin(Calendar calendar) {
        if (calendar == null) {
            ImmoToolApp.getApplication().getProject().setProperty(KEY_WORKTIME_BEGIN, (String)null);
        } else {
            String string = calendar.get(11) + "-" + calendar.get(12);
            ImmoToolApp.getApplication().getProject().setProperty(KEY_WORKTIME_BEGIN, string);
        }
    }

    public static void setWorkTimeEnd(Date date) {
        if (date == null) {
            CalendarPlugin.setWorkTimeEnd((Calendar)null);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        CalendarPlugin.setWorkTimeEnd(calendar);
    }

    public static void setWorkTimeEnd(Calendar calendar) {
        if (calendar == null) {
            ImmoToolApp.getApplication().getProject().setProperty(KEY_WORKTIME_END, (String)null);
        } else {
            String string = calendar.get(11) + "-" + calendar.get(12);
            ImmoToolApp.getApplication().getProject().setProperty(KEY_WORKTIME_END, string);
        }
    }

    public void update(ImmoToolProject immoToolProject, ImmoToolDb immoToolDb, String string, String string2) throws ImmoToolException {
        super.update(immoToolProject, immoToolDb, string, string2);
    }
}

