/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolSetupPanel;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarPlugin;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import org.apache.commons.lang.SystemUtils;
import org.jdesktop.application.ResourceMap;

public class CalendarSetupGeneralPanel
extends ImmoToolSetupPanel {
    private final ResourceMap resourceMap = ImmoToolUtils.getResourceMap(CalendarSetupGeneralPanel.class);
    private final ValidationHandler validationHandler = ImmoToolUtils.createValidationHandler();
    private JSpinner calendarBeginSpinner;
    private JSpinner calendarEndSpinner;

    public CalendarSetupGeneralPanel() {
        this.buildForm();
        this.resourceMap.injectComponents((Component)((Object)this));
        if (SystemUtils.IS_OS_MAC_OSX) {
            // empty if block
        }
    }

    private void buildForm() {
        this.calendarBeginSpinner = new JSpinner();
        this.calendarBeginSpinner.setModel(new SpinnerDateModel(new Date(), null, null, 11));
        this.calendarBeginSpinner.setEditor(new JSpinner.DateEditor(this.calendarBeginSpinner, this.resourceMap.getString("format.calendarTime", new Object[0])));
        this.calendarBeginSpinner.setName("calendarBeginSpinner");
        this.calendarEndSpinner = new JSpinner();
        this.calendarEndSpinner.setModel(new SpinnerDateModel(new Date(), null, null, 11));
        this.calendarEndSpinner.setEditor(new JSpinner.DateEditor(this.calendarEndSpinner, this.resourceMap.getString("format.calendarTime", new Object[0])));
        this.calendarEndSpinner.setName("calendarEndSpinner");
        this.validationHandler.putRule((JComponent)this.calendarBeginSpinner, new ValidationRule(){

            public boolean isValid(Object object) {
                Date date = (Date)object;
                if (date == null) {
                    return false;
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.set(1, 2000);
                calendar.set(6, 1);
                calendar.set(14, 0);
                Date date2 = (Date)CalendarSetupGeneralPanel.this.calendarEndSpinner.getValue();
                Calendar calendar2 = Calendar.getInstance();
                calendar2.setTime(date2);
                calendar2.set(1, 2000);
                calendar2.set(6, 1);
                calendar2.set(14, 0);
                return calendar.before(calendar2);
            }
        });
        this.validationHandler.putRule((JComponent)this.calendarEndSpinner, new ValidationRule(){

            public boolean isValid(Object object) {
                Date date = (Date)CalendarSetupGeneralPanel.this.calendarBeginSpinner.getValue();
                if (date == null) {
                    return false;
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.set(1, 2000);
                calendar.set(6, 1);
                calendar.set(14, 0);
                Date date2 = (Date)object;
                Calendar calendar2 = Calendar.getInstance();
                calendar2.setTime(date2);
                calendar2.set(1, 2000);
                calendar2.set(6, 1);
                calendar2.set(14, 0);
                return calendar2.after(calendar);
            }
        });
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, 30dlu:grow", (JPanel)((Object)this));
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.calendarTime", new Object[0])), 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(this.resourceMap.getString("info.calendarTime", new Object[0])), 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.calendarBeginSpinner", new Object[0]), (Component)this.calendarBeginSpinner);
        defaultFormBuilder.append(this.resourceMap.getString("label.calendarEndSpinner", new Object[0]), (Component)this.calendarEndSpinner);
        defaultFormBuilder.nextLine();
        this.revalidate();
        this.repaint();
    }

    public void doLoad() throws ImmoToolException {
        this.calendarBeginSpinner.setValue(CalendarPlugin.getWorkTimeBegin().getTime());
        this.calendarEndSpinner.setValue(CalendarPlugin.getWorkTimeEnd().getTime());
        this.validationHandler.validate();
    }

    public void doSave() throws ImmoToolException {
        CalendarPlugin.setWorkTimeBegin((Date)this.calendarBeginSpinner.getValue());
        CalendarPlugin.setWorkTimeEnd((Date)this.calendarEndSpinner.getValue());
    }

    public boolean doValidate() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    public String getTitle() {
        return this.resourceMap.getString("panelTitle", new Object[0]);
    }
}

