/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDb;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarJournalEntry;
import com.openindex.openestate.tool.calendar.CalendarObject;
import com.openindex.openestate.tool.calendar.CalendarPluginUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import org.jdesktop.application.ResourceMap;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.modules.XMLResource;

public class CalendarSource {
    public static final int SOURCE_DB = 0;
    public static final int SOURCE_FILE = 1;
    public static final int SOURCE_URL = 2;
    public static final int AUTH_DISABLED = 0;
    public static final int AUTH_HTTP_BASIC = 1;
    private static final String KEY_CALENDER_ID = "calendarId";
    private static final String KEY_NAME = "name";
    private static final String KEY_LOCATION = "location";
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_TYPE = "type";
    private static final String KEY_AUTH_METHOD = "auth.method";
    private static final String KEY_AUTH_USER = "auth.user";
    private static final String KEY_AUTH_PASS = "auth.pass";
    private long calendarId = 0L;
    private String name = "";
    private Object location = "";
    private String description = "";
    private int type = 0;
    private int authMethod = 0;
    private String authUser = null;
    private String authPass = null;

    public int getAuthMethod() {
        return this.authMethod;
    }

    public String getAuthPass() {
        return this.authPass;
    }

    public String getAuthUser() {
        return this.authUser;
    }

    public long getCalendarId() {
        return this.calendarId;
    }

    public String getDescription() {
        return this.description;
    }

    public Object getLocation() {
        return this.location;
    }

    public String getLocationAsDbPath() {
        return (String)this.getLocation();
    }

    public File getLocationAsFile() {
        return (File)this.getLocation();
    }

    public URL getLocationAsUrl() {
        return (URL)this.getLocation();
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public boolean isDbSource() {
        return this.getType() == 0;
    }

    public boolean isFileSource() {
        return this.getType() == 1;
    }

    public boolean isUrlSource() {
        return this.getType() == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CalendarSource load(long l) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = CalendarPluginUtils.openPluginCollection("");
            CalendarSource calendarSource = CalendarSource.load(l, collection);
            return calendarSource;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static CalendarSource load(long l, Collection collection) throws ImmoToolDbException {
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Calendar")) {
                throw new ImmoToolDbException("invalid collection!");
            }
            String string = "source." + l + ".xml";
            if (!ImmoToolDbUtils.hasResource((Collection)collection, (String)string)) {
                return null;
            }
            Properties properties = ImmoToolDbUtils.loadProperties((Collection)collection, (String)string);
            CalendarSource calendarSource = new CalendarSource();
            calendarSource.load(properties);
            return calendarSource;
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void load(Properties properties) throws MalformedURLException {
        this.setCalendarId(ImmoToolUtils.getPropertyAsLong((String)KEY_CALENDER_ID, (Long)0L, (Properties)properties));
        this.setType(ImmoToolUtils.getPropertyAsInteger((String)KEY_TYPE, (Integer)0, (Properties)properties));
        this.setName(properties.getProperty(KEY_NAME, ""));
        this.setDescription(properties.getProperty(KEY_DESCRIPTION, ""));
        if (this.isDbSource()) {
            this.setLocation(properties.getProperty(KEY_LOCATION, ""));
        } else if (this.isFileSource()) {
            this.setLocation(new File(properties.getProperty(KEY_LOCATION, "")));
        } else if (this.isUrlSource()) {
            this.setLocation(new URL(properties.getProperty(KEY_LOCATION, "")));
        } else {
            this.setLocation((String)null);
        }
        this.setAuthMethod(ImmoToolUtils.getPropertyAsInteger((String)KEY_AUTH_METHOD, (Integer)0, (Properties)properties));
        this.setAuthUser(this.getAuthMethod() > 0 ? properties.getProperty(KEY_AUTH_USER, null) : null);
        this.setAuthPass(this.getAuthMethod() > 0 ? properties.getProperty(KEY_AUTH_PASS, null) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CalendarSource[] loadSources() throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = CalendarPluginUtils.openPluginCollection("");
            CalendarSource[] calendarSourceArray = CalendarSource.loadSources(collection);
            return calendarSourceArray;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public static CalendarSource[] loadSources(Collection collection) throws ImmoToolDbException {
        try {
            if (collection == null) {
                throw new ImmoToolDbException("empty collection!");
            }
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Calendar")) {
                throw new ImmoToolDbException("invalid collection!");
            }
            ArrayList<CalendarSource> arrayList = new ArrayList<CalendarSource>();
            for (String string : collection.listResources()) {
                String[] stringArray = string.split("\\.");
                if (stringArray.length != 3 || !stringArray[0].equals("source") || !stringArray[2].equals("xml")) continue;
                Long l = Long.valueOf(stringArray[1]);
                arrayList.add(CalendarSource.load(l, collection));
            }
            return arrayList.toArray(new CalendarSource[arrayList.size()]);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = CalendarPluginUtils.openPluginCollection("");
            this.remove(collection);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public void remove(Collection collection) throws ImmoToolDbException {
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Calendar")) {
                throw new ImmoToolDbException("invalid collection!");
            }
            String string = "source." + this.getCalendarId() + ".xml";
            if (!ImmoToolDbUtils.hasResource((Collection)collection, (String)string)) {
                throw new Exception("unknown resource: " + string);
            }
            XMLResource xMLResource = ImmoToolDbUtils.loadXMLResource((Collection)collection, (String)string);
            if (xMLResource == null) {
                throw new Exception("resource not found: " + string);
            }
            ImmoToolDbUtils.removeResource((Collection)collection, (Resource)xMLResource);
            String string2 = "calendar." + this.getCalendarId() + ".xml";
            if (!ImmoToolDbUtils.hasResource((Collection)collection, (String)string2)) {
                return;
            }
            xMLResource = ImmoToolDbUtils.loadXMLResource((Collection)collection, (String)string2);
            if (xMLResource == null) {
                throw new Exception("resource not found: " + string2);
            }
            ImmoToolDbUtils.removeResource((Collection)collection, (Resource)xMLResource);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = CalendarPluginUtils.openPluginCollection("");
            this.save(collection);
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    public void save(Collection collection) throws ImmoToolDbException {
        this.save(collection, ImmoToolApp.getApplication().getDatabase());
    }

    public void save(Collection collection, ImmoToolDb immoToolDb) throws ImmoToolDbException {
        ResourceMap resourceMap = ImmoToolUtils.getResourceMap(CalendarSource.class);
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Calendar")) {
                throw new ImmoToolDbException("invalid collection!");
            }
            if (this.getCalendarId() <= 0L) {
                this.setCalendarId(immoToolDb.getNextSequence("OpenEstate-Calendar.Calendar"));
            }
            if (this.getCalendarId() <= 0L) {
                throw new ImmoToolDbException("could not get sequence-value!");
            }
            Properties properties = new Properties();
            this.save(properties);
            ImmoToolDbUtils.storeProperties((Collection)collection, (Properties)properties, (String)("source." + this.getCalendarId() + ".xml"));
            if (!ImmoToolDbUtils.hasResource((Collection)collection, (String)("calendar." + this.getCalendarId() + ".xml"))) {
                CalendarObject calendarObject = CalendarObject.create(this);
                CalendarJournalEntry calendarJournalEntry = new CalendarJournalEntry();
                calendarJournalEntry.setBeginTime(new Date());
                calendarJournalEntry.setSummary(resourceMap.getString("label.newSourceCreated", new Object[]{this.getName()}));
                calendarObject.add(calendarJournalEntry);
                calendarObject.save(collection, immoToolDb);
            }
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void save(Properties properties) {
        properties.setProperty(KEY_DESCRIPTION, this.getDescription().trim());
        properties.setProperty(KEY_CALENDER_ID, String.valueOf(this.getCalendarId()));
        properties.setProperty(KEY_LOCATION, this.getLocation() != null ? this.getLocation().toString() : "");
        properties.setProperty(KEY_NAME, this.getName());
        properties.setProperty(KEY_TYPE, String.valueOf(this.getType()));
        if (this.getAuthMethod() > 0) {
            properties.setProperty(KEY_AUTH_METHOD, String.valueOf(this.getAuthMethod()));
            properties.setProperty(KEY_AUTH_USER, this.getAuthUser());
            properties.setProperty(KEY_AUTH_PASS, this.getAuthPass());
        } else {
            if (properties.contains(KEY_AUTH_METHOD)) {
                properties.remove(KEY_AUTH_METHOD);
            }
            if (properties.contains(KEY_AUTH_USER)) {
                properties.remove(KEY_AUTH_USER);
            }
            if (properties.contains(KEY_AUTH_PASS)) {
                properties.remove(KEY_AUTH_PASS);
            }
        }
    }

    public void setAuthMethod(int n) {
        this.authMethod = n;
    }

    public void setAuthPass(String string) {
        this.authPass = string;
    }

    public void setAuthUser(String string) {
        this.authUser = string;
    }

    public void setCalendarId(long l) {
        this.calendarId = l;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setLocation(String string) {
        this.setType(0);
        this.location = string;
    }

    public void setLocation(File file) {
        this.setType(1);
        this.location = file;
    }

    public void setLocation(URL uRL) {
        this.setType(2);
        this.location = uRL;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setType(int n) {
        this.type = n;
    }
}

