/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarObject;
import com.openindex.openestate.tool.calendar.CalendarSource;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.property.Organizer;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.jdesktop.application.ResourceMap;

public class CalendarSourceSyncTask
extends ImmoToolTask<Boolean> {
    private final ResourceMap resourceMap;
    private final CalendarSource calendarSource;

    public CalendarSourceSyncTask(CalendarSource calendarSource) {
        this.calendarSource = calendarSource;
        this.resourceMap = ImmoToolUtils.getResourceMap(CalendarSourceSyncTask.class);
        this.setTitle(this.resourceMap.getString("title", new Object[]{calendarSource != null ? calendarSource.getName() : "NULL"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Boolean executeTask() throws Exception {
        String string;
        void var7_14;
        int n;
        HttpEntity httpEntity;
        Serializable serializable;
        CalendarObject calendarObject;
        CalendarObject calendarObject2;
        block23: {
            CalendarBuilder calendarBuilder;
            block22: {
                if (this.calendarSource == null) {
                    throw new NullPointerException("no calendar-source defined!");
                }
                calendarObject2 = CalendarObject.load(this.calendarSource.getCalendarId());
                if (calendarObject2 == null) {
                    calendarObject2 = CalendarObject.create(this.calendarSource);
                }
                calendarObject = new CalendarObject();
                if (!this.calendarSource.isFileSource()) break block22;
                serializable = this.calendarSource.getLocationAsFile();
                if (serializable != null && ((File)serializable).isFile()) {
                    httpEntity = null;
                    try {
                        this.setMessage(this.resourceMap.getString("message.doOpenFile", new Object[]{((File)serializable).getAbsolutePath()}));
                        httpEntity = new FileReader((File)serializable);
                        calendarBuilder = new CalendarBuilder();
                        calendarObject.setCalendar(calendarBuilder.build((Reader)httpEntity));
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(httpEntity);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)httpEntity);
                    break block23;
                } else {
                    this.setMessage(this.resourceMap.getString("error.fileNotFound", new Object[]{serializable != null ? ((File)serializable).getAbsolutePath() : "NULL"}));
                }
                break block23;
            }
            if (!this.calendarSource.isUrlSource()) {
                throw new Exception("invalid calendar-source!");
            }
            serializable = this.calendarSource.getLocationAsUrl();
            if (serializable == null) {
                this.setMessage(this.resourceMap.getString("error.urlNotFound", new Object[]{"NULL"}));
            } else {
                httpEntity = null;
                try {
                    this.setMessage(this.resourceMap.getString("message.doOpenUrl", new Object[]{((URL)serializable).toString()}));
                    calendarBuilder = null;
                    n = this.calendarSource.getAuthMethod();
                    calendarBuilder = n == 1 ? ImmoToolUtils.createHttpClient((String)this.calendarSource.getAuthUser(), (String)this.calendarSource.getAuthPass()) : ImmoToolUtils.createHttpClient();
                    HttpResponse object2 = calendarBuilder.execute((HttpUriRequest)new HttpGet(ImmoToolUtils.toIdnUrl((URL)serializable).toURI()));
                    httpEntity = object2.getEntity();
                    CalendarBuilder calendarBuilder2 = new CalendarBuilder();
                    calendarObject.setCalendar(calendarBuilder2.build(httpEntity.getContent()));
                }
                catch (Throwable throwable) {
                    EntityUtils.consume(httpEntity);
                    throw throwable;
                }
                EntityUtils.consume((HttpEntity)httpEntity);
            }
        }
        this.setMessage(this.resourceMap.getString("message.doMerge", new Object[0]));
        serializable = new HashMap();
        for (CalendarEntry calendarEntry : calendarObject2.getEntries()) {
            String string2;
            String string3 = string2 = calendarEntry.getUId() != null ? calendarEntry.getUId().getValue() : null;
            if (string2 == null) continue;
            serializable.put(string2, calendarEntry);
        }
        httpEntity = new ArrayList();
        CalendarEntry[] calendarEntryArray = calendarObject.getEntries();
        n = calendarEntryArray.length;
        boolean bl = false;
        while (var7_14 < n) {
            CalendarEntry calendarEntry = calendarEntryArray[var7_14];
            String string4 = string = calendarEntry.getUId() != null ? calendarEntry.getUId().getValue() : null;
            if (string != null) {
                if (calendarEntry.getProperty("ORGANIZER") == null) {
                    calendarEntry.putProperty((Property)new Organizer());
                }
                if (!serializable.containsKey(string)) {
                    this.setMessage("> add: " + string);
                    calendarObject2.add(calendarEntry);
                    serializable.put(string, calendarEntry);
                    if (!httpEntity.contains(string)) {
                        httpEntity.add(string);
                    }
                } else {
                    this.setMessage("> update: " + string);
                    calendarObject2.getCalendar().getComponents().remove(calendarEntry.getComponent());
                    calendarObject2.add(calendarEntry);
                    serializable.put(string, calendarEntry);
                    if (!httpEntity.contains(string)) {
                        httpEntity.add(string);
                    }
                }
            }
            ++var7_14;
        }
        calendarEntryArray = calendarObject2.getEntries();
        n = calendarEntryArray.length;
        boolean bl2 = false;
        while (true) {
            void var7_16;
            if (var7_16 >= n) {
                calendarObject2.save();
                return true;
            }
            CalendarEntry calendarEntry = calendarEntryArray[var7_16];
            String string5 = string = calendarEntry.getUId() != null ? calendarEntry.getUId().getValue() : null;
            if (string != null && !httpEntity.contains(string)) {
                this.setMessage("> remove: " + string);
                calendarObject2.getCalendar().getComponents().remove(calendarEntry.getComponent());
            }
            ++var7_16;
        }
    }
}

