/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarSource;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.ResourceMap;

public class CalendarSourceTableModel
extends DefaultTableModel {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_SOURCE = 3;
    private static final Map<Integer, String> COLUMN_NAMES = new HashMap<Integer, String>();
    private static final Map<Integer, Class> COLUMN_CLASSES;
    private final ResourceMap resourceMap = ImmoToolUtils.getResourceMap(CalendarSourceTableModel.class);

    public CalendarSourceTableModel() {
        this.setColumnCount(COLUMN_NAMES.size());
    }

    public void addCalendarSource(CalendarSource calendarSource) {
        this.addRow(this.buildRow(calendarSource));
    }

    private Object[] buildRow(CalendarSource calendarSource) {
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        treeMap.put(0, calendarSource.getCalendarId());
        treeMap.put(1, calendarSource.getName());
        if (calendarSource.isDbSource()) {
            treeMap.put(2, this.resourceMap.getString("type.intern", new Object[0]));
            treeMap.put(3, "");
        } else if (calendarSource.isFileSource()) {
            File file = calendarSource.getLocationAsFile();
            treeMap.put(2, this.resourceMap.getString("type.extern.file", new Object[0]));
            treeMap.put(3, file != null ? file.getAbsolutePath() : "");
        } else if (calendarSource.isUrlSource()) {
            URL uRL = calendarSource.getLocationAsUrl();
            treeMap.put(2, this.resourceMap.getString("type.extern.url", new Object[0]));
            treeMap.put(3, uRL != null ? uRL.toString() : "");
        } else {
            treeMap.put(2, this.resourceMap.getString("type.unknown", new Object[0]));
        }
        return treeMap.values().toArray(new Object[treeMap.size()]);
    }

    public void clear() {
        while (this.getRowCount() > 0) {
            this.removeRow(0);
        }
    }

    public Class getColumnClass(int n) {
        return COLUMN_CLASSES.containsKey(n) ? COLUMN_CLASSES.get(n) : null;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES.containsKey(n) ? this.resourceMap.getString(COLUMN_NAMES.get(n), new Object[0]) : null;
    }

    public Long getCalendarIdAt(int n) {
        int n2 = n;
        return (Long)this.getValueAt(n2, 0);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    static {
        COLUMN_NAMES.put(0, "col.id");
        COLUMN_NAMES.put(1, "col.name");
        COLUMN_NAMES.put(2, "col.type");
        COLUMN_NAMES.put(3, "col.source");
        COLUMN_CLASSES = new HashMap<Integer, Class>();
        COLUMN_CLASSES.put(0, Long.class);
        COLUMN_CLASSES.put(1, String.class);
        COLUMN_CLASSES.put(2, String.class);
        COLUMN_CLASSES.put(3, String.class);
    }
}

