/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolTabPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarPluginUtils;
import com.openindex.openestate.tool.calendar.CalendarSource;
import com.openindex.openestate.tool.calendar.CalendarSourceTableModel;
import com.openindex.openestate.tool.calendar.CalendarSourceViewPanel;
import com.openindex.openestate.tool.utils.QuickTableExport;
import com.openindex.openestate.tool.utils.TabComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;
import org.xmldb.api.base.Collection;

public class CalendarSourceTablePanel
extends ImmoToolTabPanel {
    private static final Logger LOGGER = Logger.getLogger(CalendarSourceTablePanel.class);
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private JPopupMenu actionsMenu;
    private CalendarSourceTableModel resultTableModel;
    private JButton actionButton;
    private JButton addButton;
    private JButton closeButton;
    private JButton helpButton;
    private JButton refreshButton;
    private JXTable resultTable;
    private JScrollPane resultTableScroller;
    private JXTitledSeparator titleLabel;

    public CalendarSourceTablePanel() {
        this.build();
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(CalendarSourceTablePanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(CalendarSourceTablePanel.class);
        this.initComponents();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.actionsMenu = new JPopupMenu();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doView")));
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doRemove")));
        this.resultTableModel = new CalendarSourceTableModel();
        this.resultTable.setModel((TableModel)this.resultTableModel);
        this.resultTable.setSortable(true);
        this.resultTable.getSelectionModel().setSelectionMode(0);
        this.resultTable.getColumn(0).setMaxWidth(75);
        this.resultTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    Task task = CalendarSourceTablePanel.this.doView();
                    if (task != null) {
                        ImmoToolUtils.executeTask((Task)task);
                    }
                } else if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
                    int n = CalendarSourceTablePanel.this.resultTable.rowAtPoint(mouseEvent.getPoint());
                    if (n >= 0 && n != CalendarSourceTablePanel.this.resultTable.getSelectedRow() && n >= 0) {
                        CalendarSourceTablePanel.this.resultTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    if (n < 0) {
                        n = CalendarSourceTablePanel.this.resultTable.getSelectedRow();
                    }
                    if (n < 0) {
                        return;
                    }
                    CalendarSourceTablePanel.this.actionsMenu.show((Component)CalendarSourceTablePanel.this.resultTable, ((CalendarSourceTablePanel)CalendarSourceTablePanel.this).resultTable.getMousePosition().x, ((CalendarSourceTablePanel)CalendarSourceTablePanel.this).resultTable.getMousePosition().y);
                }
            }
        });
        this.resultTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CalendarSourceTablePanel.this.actionButton.setEnabled(CalendarSourceTablePanel.this.resultTable.getSelectedRow() >= 0);
            }
        });
        this.resultTable.setColumnControl((JComponent)QuickTableExport.createColumnControl((JXTable)this.resultTable));
        ImmoToolUtils.configureTable((JXTable)this.resultTable);
        this.addButton.setAction(this.actionMap.get(this.addButton.getText()));
        this.closeButton.setAction(this.actionMap.get(this.closeButton.getText()));
        this.helpButton.setAction(this.actionMap.get(this.helpButton.getText()));
        this.refreshButton.setAction(this.actionMap.get(this.refreshButton.getText()));
        this.actionButton.setAction(this.actionMap.get(this.actionButton.getText()));
        this.actionButton.setEnabled(false);
    }

    @Action
    public void doAction() {
        this.actionsMenu.show(this.actionButton, 0, this.actionButton.getSize().height);
    }

    @Action
    public void doAdd() {
        String string = CalendarSourceViewPanel.getInstanceTabTitle(0L);
        if (ImmoToolUtils.selectPanel((String)string)) {
            return;
        }
        ImmoToolUtils.showPanel((TabComponent)new CalendarSourceViewPanel());
    }

    @Action
    public void doClose() {
        ImmoToolUtils.removePanel((String)this.getTabTitle());
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog((String)"calendar.sources");
    }

    @Action
    public Task doRefresh() {
        this.resultTableModel.clear();
        this.resultTable.setEnabled(false);
        this.setButtonsEnabled(false);
        return new ImmoToolTask<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Boolean executeTask() throws Exception {
                Collection collection = null;
                try {
                    collection = CalendarPluginUtils.openPluginCollection("");
                    for (String string : collection.listResources()) {
                        String[] stringArray = string.split("\\.");
                        if (stringArray.length != 3 || !stringArray[0].equals("source") || !stringArray[2].equals("xml")) continue;
                        CalendarSource calendarSource = CalendarSource.load(Long.valueOf(stringArray[1]), collection);
                        if (calendarSource == null) {
                            LOGGER.warn((Object)("could not load calendar-source from " + string));
                            continue;
                        }
                        CalendarSourceTablePanel.this.resultTableModel.addCalendarSource(calendarSource);
                    }
                    Boolean bl = true;
                    return bl;
                }
                finally {
                    ImmoToolDbUtils.close((Collection)collection);
                }
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarSourceTablePanel.this.resourceMap.getString("error.cantLoadCalendarSource", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                CalendarSourceTablePanel.this.resultTable.setEnabled(true);
                CalendarSourceTablePanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                CalendarSourceTablePanel.this.titleLabel.setTitle(CalendarSourceTablePanel.this.resourceMap.getString("titleLabel.title", new Object[0]) + " / " + CalendarSourceTablePanel.this.resourceMap.getString("message.resultCount", new Object[]{NumberFormat.getIntegerInstance().format(CalendarSourceTablePanel.this.resultTable.getRowCount())}));
                CalendarSourceTablePanel.this.resultTable.packAll();
            }
        };
    }

    @Action
    public Task doRemove() {
        if (this.resultTable.getSelectedRowCount() < 1) {
            return null;
        }
        int n = this.resultTable.getSelectedRow();
        int n2 = this.resultTable.convertRowIndexToModel(n);
        final long l = this.resultTableModel.getCalendarIdAt(n2);
        boolean bl = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyDeleteCalendarSource", new Object[]{l}));
        if (!bl) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<Boolean>(){

            protected Boolean executeTask() throws Exception {
                CalendarSource calendarSource = CalendarSource.load(l);
                if (calendarSource == null) {
                    throw new Exception("could not load calendar-source #" + l);
                }
                calendarSource.remove();
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarSourceTablePanel.this.resourceMap.getString("error.cantRemoveCalendarSource", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                CalendarSourceTablePanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                ImmoToolUtils.executeTask((Task)CalendarSourceTablePanel.this.doRefresh());
            }
        };
    }

    @Action
    public Task doView() {
        if (this.resultTable.getSelectedRowCount() < 1) {
            return null;
        }
        int n = this.resultTable.getSelectedRow();
        int n2 = this.resultTable.convertRowIndexToModel(n);
        final long l = this.resultTableModel.getCalendarIdAt(n2);
        String string = CalendarSourceViewPanel.getInstanceTabTitle(l);
        if (ImmoToolUtils.selectPanel((String)string)) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<CalendarSourceViewPanel>(){

            protected CalendarSourceViewPanel executeTask() throws Exception {
                CalendarSource calendarSource = CalendarSource.load(l);
                if (calendarSource == null) {
                    throw new Exception("could not load calendar-source #" + l);
                }
                CalendarSourceViewPanel calendarSourceViewPanel = new CalendarSourceViewPanel();
                calendarSourceViewPanel.load(calendarSource);
                return calendarSourceViewPanel;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarSourceTablePanel.this.resourceMap.getString("error.cantViewCalendarSource", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                CalendarSourceTablePanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(CalendarSourceViewPanel calendarSourceViewPanel) {
                super.succeeded((Object)calendarSourceViewPanel);
                ImmoToolUtils.showPanel((TabComponent)calendarSourceViewPanel);
            }
        };
    }

    public static String getInstanceTabTitle() {
        return ImmoToolUtils.getResourceMap(CalendarSourceTablePanel.class).getString("tabTitle", new Object[0]);
    }

    public String getTabInfo() {
        return this.resourceMap.getString("tabInfo", new Object[0]);
    }

    public String getTabTitle() {
        return CalendarSourceTablePanel.getInstanceTabTitle();
    }

    public void refreshTab() {
        ImmoToolUtils.executeTask((Task)this.doRefresh());
    }

    private void setButtonsEnabled(boolean bl) {
        this.addButton.setEnabled(bl);
        this.refreshButton.setEnabled(bl);
        if (!bl) {
            this.actionButton.setEnabled(false);
        } else {
            this.actionButton.setEnabled(this.resultTable.getSelectedRow() >= 0);
        }
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.refreshButton = new JButton();
        this.addButton = new JButton();
        this.actionButton = new JButton();
        this.helpButton = new JButton();
        this.closeButton = new JButton();
        this.resultTableScroller = new JScrollPane();
        this.resultTable = new JXTable();
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle("titleLabel");
        this.refreshButton.setText("doRefresh");
        this.refreshButton.setName("refreshButton");
        this.addButton.setText("doAdd");
        this.addButton.setName("addButton");
        this.actionButton.setText("doAction");
        this.actionButton.setName("actionButton");
        this.helpButton.setText("doHelp");
        this.helpButton.setName("helpButton");
        this.closeButton.setText("doClose");
        this.closeButton.setName("closeButton");
        this.resultTableScroller.setName("resultTableScroller");
        this.resultTable.setColumnControlVisible(true);
        this.resultTable.setName("resultTable");
        this.resultTableScroller.setViewportView((Component)this.resultTable);
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.resultTableScroller, GroupLayout.Alignment.LEADING, -1, 727, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 234, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.refreshButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.helpButton).addComponent(this.actionButton).addComponent(this.addButton).addComponent(this.refreshButton)).addComponent((Component)this.titleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultTableScroller, -1, 351, Short.MAX_VALUE).addContainerGap()));
    }
}

