/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolTabPanel;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarObject;
import com.openindex.openestate.tool.calendar.CalendarPluginUtils;
import com.openindex.openestate.tool.calendar.CalendarSource;
import com.openindex.openestate.tool.utils.ModificationHandler;
import com.openindex.openestate.tool.utils.ValidationHandler;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Printable;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.fife.ui.rtextarea.RTextArea;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTitledSeparator;
import org.w3c.dom.Node;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.modules.XMLResource;

public class CalendarSourceViewPanel
extends ImmoToolTabPanel {
    private static final Logger LOGGER = Logger.getLogger(CalendarSourceViewPanel.class);
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private ModificationHandler modifications;
    private ValidationHandler validationHandler;
    private JPopupMenu actionsMenu;
    private JTextField sourceNameField;
    private RTextArea sourceTextField;
    private JFormattedTextField sourceFileField;
    private JButton sourceFileButton;
    private JFormattedTextField sourceUrlField;
    private JButton sourceUrlButton;
    private ButtonGroup sourceTypeGroup;
    private JRadioButton sourceTypeInternalButton;
    private JRadioButton sourceTypeExternalFileButton;
    private JRadioButton sourceTypeExternalUrlButton;
    private JComboBox sourceAuthMethodBox;
    private JTextField sourceAuthUserField;
    private JPasswordField sourceAuthPassField;
    private long calendarId = 0L;
    private String calendarTitle = null;
    private long nextCalendarId = 0L;
    private long prevCalendarId = 0L;
    private JButton actionButton;
    private JButton closeButton;
    private JButton helpButton;
    private JButton nextButton;
    private JButton prevButton;
    private JPanel sourceFormPanel;
    private JButton submitButton;
    private JTabbedPane tabPanel;
    private JXTitledSeparator titleLabel;

    public CalendarSourceViewPanel() {
        this.build();
    }

    private void build() {
        this.modifications = ImmoToolUtils.createModificationHandler();
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.actionMap = ImmoToolUtils.getActionMap(CalendarSourceViewPanel.class, (Object)((Object)this));
        this.resourceMap = ImmoToolUtils.getResourceMap(CalendarSourceViewPanel.class);
        this.initComponents();
        this.buildSourceFormPanel();
        this.resourceMap.injectComponents((Component)((Object)this));
        this.tabPanel.setTitleAt(0, this.resourceMap.getString("sourceForm", new Object[0]));
        this.actionsMenu = new JPopupMenu();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doCopy")));
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doRemove")));
        this.actionsMenu.addSeparator();
        this.actionsMenu.add(new JMenuItem(this.actionMap.get("doPrintNotes")));
        this.getActionMap().put("doViewNext", this.actionMap.get("doViewNext"));
        this.getInputMap().put(KeyStroke.getKeyStroke("alt pressed PAGE_UP"), "doViewNext");
        this.getInputMap().put(KeyStroke.getKeyStroke("ctrl pressed RIGHT"), "doViewNext");
        this.getActionMap().put("doViewPrevious", this.actionMap.get("doViewPrevious"));
        this.getInputMap().put(KeyStroke.getKeyStroke("alt pressed PAGE_DOWN"), "doViewPrevious");
        this.getInputMap().put(KeyStroke.getKeyStroke("ctrl pressed LEFT"), "doViewPrevious");
        this.setButtonsEnabled(true);
        this.sourceTypeInternalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarSourceViewPanel.this.updateTypeSelection();
                CalendarSourceViewPanel.this.validationHandler.validate();
            }
        });
        this.sourceTypeExternalFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarSourceViewPanel.this.updateTypeSelection();
                CalendarSourceViewPanel.this.validationHandler.validate();
            }
        });
        this.sourceTypeExternalUrlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarSourceViewPanel.this.updateTypeSelection();
                CalendarSourceViewPanel.this.validationHandler.validate();
            }
        });
        this.sourceAuthMethodBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarSourceViewPanel.this.updateTypeSelection();
                CalendarSourceViewPanel.this.validationHandler.validate();
            }
        });
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.tabPanel.setTabPlacement(1);
        }
        this.updateTypeSelection();
        this.validationHandler.init();
    }

    private void buildSourceFormPanel() {
        this.sourceNameField = new JTextField();
        this.sourceNameField.setName("sourceNameField");
        this.sourceFileField = new JFormattedTextField();
        this.sourceFileField.setName("sourceFileField");
        this.sourceFileButton = new JButton(this.actionMap.get("doSelectFile"));
        this.sourceFileButton.setName("sourceFileButton");
        this.sourceUrlField = new JFormattedTextField();
        this.sourceUrlField.setName("sourceUrlField");
        this.sourceUrlButton = new JButton(this.actionMap.get("doTestUrl"));
        this.sourceUrlButton.setName("sourceUrlButton");
        this.sourceTypeInternalButton = new JRadioButton();
        this.sourceTypeInternalButton.setName("sourceTypeInternalButton");
        this.sourceTypeExternalFileButton = new JRadioButton();
        this.sourceTypeExternalFileButton.setName("sourceTypeExternalFileButton");
        this.sourceTypeExternalUrlButton = new JRadioButton();
        this.sourceTypeExternalUrlButton.setName("sourceTypeExternalUrlButton");
        this.sourceTypeGroup = new ButtonGroup();
        this.sourceTypeGroup.add(this.sourceTypeInternalButton);
        this.sourceTypeGroup.add(this.sourceTypeExternalFileButton);
        this.sourceTypeGroup.add(this.sourceTypeExternalUrlButton);
        this.sourceTypeInternalButton.setSelected(true);
        this.sourceTextField = new RTextArea();
        this.sourceTextField.setName("sourceTextField");
        this.sourceTextField.setLineWrap(true);
        this.sourceTextField.setWrapStyleWord(true);
        if (this.sourceTextField.getPopupMenu() != null) {
            this.sourceTextField.getPopupMenu().add(new JMenuItem(this.actionMap.get("doPrintNotes")));
        }
        this.sourceAuthMethodBox = new JComboBox();
        this.sourceAuthMethodBox.setName("sourceAuthMethodBox");
        this.sourceAuthMethodBox.addItem(0);
        this.sourceAuthMethodBox.addItem(1);
        this.sourceAuthMethodBox.setRenderer(new AuthRenderer());
        this.sourceAuthUserField = new JTextField();
        this.sourceAuthUserField.setName("sourceAuthUserField");
        this.sourceAuthPassField = new JPasswordField();
        this.sourceAuthPassField.setName("sourceAuthPassField");
        this.validationHandler.putRule((JComponent)this.sourceNameField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.sourceAuthUserField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.sourceFileField, new ValidationRule(){

            public boolean isValid(Object object) {
                return object != null && new File(object.toString()).isFile();
            }
        });
        this.validationHandler.putRule((JComponent)this.sourceUrlField, new ValidationRule(){

            public boolean isValid(Object object) {
                if (object == null) {
                    return false;
                }
                try {
                    URL uRL = new URL(object.toString());
                    return uRL != null;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        });
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"pref, 3dlu, 30dlu:grow, 3dlu, pref");
        defaultFormBuilder.border(Borders.DIALOG);
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.name", new Object[0])), 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.sourceNameField, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(" "), 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.description", new Object[0])), 5);
        defaultFormBuilder.nextLine();
        JScrollPane jScrollPane = new JScrollPane((Component)this.sourceTextField);
        jScrollPane.setPreferredSize(new Dimension(150, 150));
        jScrollPane.setViewportBorder(Borders.EMPTY);
        defaultFormBuilder.append((Component)jScrollPane, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(" "), 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("label.source", new Object[0])), 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.sourceTypeInternalButton, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.sourceTypeExternalFileButton, (Component)this.sourceFileField);
        defaultFormBuilder.append((Component)this.sourceFileButton);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.sourceTypeExternalUrlButton, (Component)this.sourceUrlField);
        defaultFormBuilder.append((Component)this.sourceUrlButton);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)CalendarSourceViewPanel.createLabel(this.resourceMap.getString("label.authType", new Object[0]), 4));
        defaultFormBuilder.append((Component)this.sourceAuthMethodBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)CalendarSourceViewPanel.createLabel(this.resourceMap.getString("label.authUser", new Object[0]), 4));
        defaultFormBuilder.append((Component)this.sourceAuthUserField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)CalendarSourceViewPanel.createLabel(this.resourceMap.getString("label.authPass", new Object[0]), 4));
        defaultFormBuilder.append((Component)this.sourceAuthPassField);
        defaultFormBuilder.nextLine();
        jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
        jScrollPane.setBorder(Borders.EMPTY);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.sourceFormPanel.setLayout(new BorderLayout());
        this.sourceFormPanel.add((Component)jScrollPane, "Center");
        this.sourceFormPanel.revalidate();
        this.sourceFormPanel.repaint();
    }

    private static JLabel createLabel(String string, int n) {
        JLabel jLabel = new JLabel(string + ":");
        jLabel.setHorizontalAlignment(n);
        return jLabel;
    }

    public static String getInstanceTabTitle(long l) {
        return l > 0L ? ImmoToolUtils.getResourceMap(CalendarSourceViewPanel.class).getString("tabTitle.edit", new Object[]{l}) : ImmoToolUtils.getResourceMap(CalendarSourceViewPanel.class).getString("tabTitle.new", new Object[0]);
    }

    public String getTabInfo() {
        if (this.calendarId <= 0L) {
            return this.resourceMap.getString("tabInfo.new", new Object[0]);
        }
        return StringEscapeUtils.escapeHtml((String)this.calendarTitle);
    }

    public String getTabTitle() {
        return CalendarSourceViewPanel.getInstanceTabTitle(this.calendarId);
    }

    public boolean isTabModified() {
        return this.modifications.isModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(CalendarSource calendarSource) {
        this.nextCalendarId = 0L;
        this.prevCalendarId = 0L;
        this.calendarId = calendarSource.getCalendarId();
        this.calendarTitle = this.calendarId > 0L ? calendarSource.getName() : null;
        this.titleLabel.setTitle(CalendarSourceViewPanel.getInstanceTabTitle(this.calendarId));
        this.sourceNameField.setText(calendarSource.getName());
        this.sourceTextField.setText(calendarSource.getDescription());
        this.sourceFileField.setText("");
        this.sourceUrlField.setText("");
        if (calendarSource.isDbSource()) {
            this.sourceTypeInternalButton.setSelected(true);
        } else if (calendarSource.isFileSource()) {
            this.sourceTypeExternalFileButton.setSelected(true);
            this.sourceFileField.setText(calendarSource.getLocationAsFile().getAbsolutePath());
        } else if (calendarSource.isUrlSource()) {
            this.sourceTypeExternalUrlButton.setSelected(true);
            this.sourceUrlField.setText(calendarSource.getLocationAsUrl().toString());
        }
        this.sourceAuthMethodBox.setSelectedItem(calendarSource.isUrlSource() ? calendarSource.getAuthMethod() : 0);
        this.sourceAuthPassField.setText(calendarSource.isUrlSource() && calendarSource.getAuthMethod() > 0 ? calendarSource.getAuthUser() : "");
        this.sourceAuthUserField.setText(calendarSource.isUrlSource() && calendarSource.getAuthMethod() > 0 ? calendarSource.getAuthPass() : "");
        if (this.calendarId > 0L) {
            long l = this.calendarId;
            Collection collection = null;
            try {
                collection = CalendarPluginUtils.openPluginCollection("");
                String string = "declare namespace xmldb=\"http://exist-db.org/xquery/xmldb\";\nfor $x in xmldb:xcollection('ImmoTool/OpenEstate-Calendar')/properties/entry[@key=\"calendarId\"]\nreturn <row id=\"{$x/text()}\" />";
                ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)string);
                for (long i = 0L; i < resourceSet.getSize(); ++i) {
                    try {
                        XMLResource xMLResource = (XMLResource)resourceSet.getResource(i);
                        Node node = xMLResource.getContentAsDOM();
                        Long l2 = Long.valueOf(node.getAttributes().getNamedItem("id").getNodeValue());
                        if (l2 > l && (l2 < this.nextCalendarId || this.nextCalendarId <= 0L)) {
                            this.nextCalendarId = l2;
                        }
                        if (l2 >= l || l2 <= this.prevCalendarId && this.prevCalendarId > 0L) continue;
                        this.prevCalendarId = l2;
                        continue;
                    }
                    catch (Exception exception) {
                        LOGGER.warn((Object)"Can't extract id!");
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                }
            }
            catch (Exception exception) {
                this.nextCalendarId = 0L;
                this.prevCalendarId = 0L;
                LOGGER.warn((Object)"Can't load previous and next entry!");
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
            finally {
                ImmoToolDbUtils.close((Collection)collection);
            }
        }
        ImmoToolUtils.updateTabs();
        this.setButtonsEnabled(true);
        this.updateTypeSelection();
        this.modifications.clear();
        this.modifications.putValue((JComponent)this.sourceNameField);
        this.modifications.putValue((JComponent)this.sourceTextField);
        this.modifications.putValue((JComponent)this.sourceFileField);
        this.modifications.putValue((JComponent)this.sourceUrlField);
        this.modifications.putValue((JComponent)this.sourceTypeInternalButton);
        this.modifications.putValue((JComponent)this.sourceTypeExternalFileButton);
        this.modifications.putValue((JComponent)this.sourceTypeExternalUrlButton);
        this.modifications.putValue((JComponent)this.sourceAuthMethodBox);
        this.modifications.putValue((JComponent)this.sourceAuthPassField);
        this.modifications.putValue((JComponent)this.sourceAuthUserField);
    }

    public void refreshTab() {
        if (this.calendarId <= 0L) {
            return;
        }
        ImmoToolTask<Boolean> immoToolTask = new ImmoToolTask<Boolean>(){

            protected Boolean executeTask() throws Exception {
                CalendarSourceViewPanel.this.load(CalendarSource.load(CalendarSourceViewPanel.this.calendarId));
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarSourceViewPanel.this.resourceMap.getString("error.cantRefresh", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                CalendarSourceViewPanel.this.setButtonsEnabled(true);
            }
        };
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((Task)immoToolTask);
    }

    public void save(CalendarSource calendarSource) throws MalformedURLException {
        calendarSource.setName(ImmoToolUtils.replaceTags((String)this.sourceNameField.getText()).trim());
        calendarSource.setDescription(ImmoToolUtils.replaceTags((String)this.sourceTextField.getText()).trim());
        if (this.sourceTypeInternalButton.isSelected()) {
            calendarSource.setLocation("");
        } else if (this.sourceTypeExternalFileButton.isSelected()) {
            calendarSource.setLocation(new File(this.sourceFileField.getText()));
        } else if (this.sourceTypeExternalUrlButton.isSelected()) {
            calendarSource.setLocation(new URL(this.sourceUrlField.getText()));
        }
        calendarSource.setAuthMethod(this.sourceAuthMethodBox.isEnabled() ? (Integer)this.sourceAuthMethodBox.getSelectedItem() : 0);
        calendarSource.setAuthPass(this.sourceAuthPassField.isEnabled() ? String.valueOf(this.sourceAuthPassField.getPassword()) : null);
        calendarSource.setAuthUser(this.sourceAuthUserField.isEnabled() ? this.sourceAuthUserField.getText() : null);
    }

    public ImmoToolTask saveModifications() {
        return (ImmoToolTask)this.doSubmit();
    }

    private void setButtonsEnabled(boolean bl) {
        this.submitButton.setEnabled(bl);
        this.closeButton.setEnabled(bl);
        this.actionButton.setEnabled(bl && this.calendarId > 0L);
        this.nextButton.setEnabled(bl && this.calendarId > 0L && this.nextCalendarId > 0L);
        this.prevButton.setEnabled(bl && this.calendarId > 0L && this.prevCalendarId > 0L);
    }

    private void updateTypeSelection() {
        this.sourceFileField.setEnabled(this.sourceTypeExternalFileButton.isSelected());
        this.sourceFileButton.setEnabled(this.sourceTypeExternalFileButton.isSelected());
        this.sourceUrlField.setEnabled(this.sourceTypeExternalUrlButton.isSelected());
        this.sourceUrlButton.setEnabled(this.sourceTypeExternalUrlButton.isSelected());
        this.sourceAuthMethodBox.setEnabled(this.sourceTypeExternalUrlButton.isSelected());
        this.sourceAuthPassField.setEnabled(this.sourceTypeExternalUrlButton.isSelected() && this.sourceAuthMethodBox.getSelectedIndex() > 0);
        this.sourceAuthUserField.setEnabled(this.sourceTypeExternalUrlButton.isSelected() && this.sourceAuthMethodBox.getSelectedIndex() > 0);
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.prevButton = new JButton();
        this.nextButton = new JButton();
        this.submitButton = new JButton();
        this.actionButton = new JButton();
        this.helpButton = new JButton();
        this.closeButton = new JButton();
        this.tabPanel = new JTabbedPane();
        this.sourceFormPanel = new JPanel();
        this.titleLabel.setName("titleLabel");
        ApplicationActionMap applicationActionMap = Application.getInstance().getContext().getActionMap(CalendarSourceViewPanel.class, (Object)this);
        this.prevButton.setAction(applicationActionMap.get("doViewPrevious"));
        this.prevButton.setName("prevButton");
        this.nextButton.setAction(applicationActionMap.get("doViewNext"));
        this.nextButton.setName("nextButton");
        this.submitButton.setAction(applicationActionMap.get("doSubmit"));
        this.submitButton.setName("submitButton");
        this.actionButton.setAction(applicationActionMap.get("doAction"));
        this.actionButton.setName("actionButton");
        this.helpButton.setAction(applicationActionMap.get("doHelp"));
        this.helpButton.setName("helpButton");
        this.closeButton.setAction(applicationActionMap.get("doClose"));
        this.closeButton.setName("closeButton");
        this.tabPanel.setTabPlacement(2);
        this.tabPanel.setName("tabPanel");
        this.sourceFormPanel.setName("sourceFormPanel");
        GroupLayout groupLayout = new GroupLayout(this.sourceFormPanel);
        this.sourceFormPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 488, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 439, Short.MAX_VALUE));
        this.tabPanel.addTab("sourceForm", this.sourceFormPanel);
        GroupLayout groupLayout2 = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabPanel, -1, 599, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent((Component)this.titleLabel, -1, 255, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.prevButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.helpButton).addComponent(this.actionButton).addComponent(this.submitButton).addComponent(this.nextButton).addComponent(this.prevButton)).addComponent((Component)this.titleLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabPanel, -1, 446, Short.MAX_VALUE).addContainerGap()));
        ResourceMap resourceMap = Application.getInstance().getContext().getResourceMap(CalendarSourceViewPanel.class);
        resourceMap.injectComponents((Component)((Object)this));
    }

    @Action
    public void doAction() {
        this.actionsMenu.show(this.actionButton, 0, this.actionButton.getSize().height);
    }

    @Action
    public void doClose() {
        ImmoToolUtils.removePanel((String)this.getTabTitle());
    }

    @Action
    public Task doCopy() {
        if (this.calendarId <= 0L) {
            return null;
        }
        this.validationHandler.validate();
        if (!this.validationHandler.isValid()) {
            ImmoToolUtils.showMessageWarningDialog((String)this.resourceMap.getString("error.invalidInput", new Object[0]));
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<CalendarSource>(this.resourceMap.getString("doCopy.Action.text", new Object[0])){

            protected CalendarSource executeTask() throws Exception {
                CalendarSource calendarSource = CalendarSource.load(CalendarSourceViewPanel.this.calendarId);
                if (calendarSource == null) {
                    throw new Exception("source for calendar #" + CalendarSourceViewPanel.this.calendarId + " not found!");
                }
                calendarSource.setCalendarId(0L);
                CalendarSourceViewPanel.this.save(calendarSource);
                calendarSource.save();
                return calendarSource;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarSourceViewPanel.this.resourceMap.getString("error.cantSaveCalendar", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                CalendarSourceViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(CalendarSource calendarSource) {
                super.succeeded((Object)calendarSource);
                CalendarSourceViewPanel.this.load(calendarSource);
                ImmoToolUtils.updateTabs();
            }
        };
    }

    @Action
    public void doHelp() {
        ImmoToolUtils.showHelpDialog((String)"calendar.sources.form");
    }

    @Action
    public void doPrintNotes() {
        try {
            ImmoToolUtils.print((Printable)this.sourceTextField);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Printing failed!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)"Printing failed!", (Throwable)exception);
        }
    }

    @Action
    public Task doRemove() {
        if (this.calendarId <= 0L) {
            return null;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)this.resourceMap.getString("question.reallyDeleteCalendarSource", new Object[]{this.calendarId}));
        if (!bl) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<Boolean>(this.resourceMap.getString("doRemove.Action.text", new Object[0])){

            protected Boolean executeTask() throws Exception {
                CalendarSource calendarSource = CalendarSource.load(CalendarSourceViewPanel.this.calendarId);
                if (calendarSource == null) {
                    throw new Exception("could not load calendar-source #" + CalendarSourceViewPanel.this.calendarId);
                }
                calendarSource.remove();
                return true;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarSourceViewPanel.this.resourceMap.getString("error.cantRemoveCalendarSource", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                CalendarSourceViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                ImmoToolUtils.removePanel((String)CalendarSourceViewPanel.this.getTabTitle(), (boolean)true);
            }
        };
    }

    @Action
    public void doSelectFile() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(this.resourceMap.getString("label.selectCalendarFile", new Object[0]));
        jFileChooser.setApproveButtonText(this.resourceMap.getString("label.selectCalendarFile.approve", new Object[0]));
        int n = jFileChooser.showOpenDialog((Component)((Object)this));
        if (n != 0) {
            return;
        }
        this.sourceFileField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        this.validationHandler.validate((JComponent)this.sourceFileField);
    }

    @Action
    public Task doSubmit() {
        this.validationHandler.validate();
        if (!this.validationHandler.isValid()) {
            ImmoToolUtils.showMessageWarningDialog((String)this.resourceMap.getString("error.invalidInput", new Object[0]));
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<CalendarSource>(this.resourceMap.getString("doSubmit.Action.text", new Object[0])){

            protected CalendarSource executeTask() throws Exception {
                CalendarSource calendarSource = null;
                calendarSource = CalendarSourceViewPanel.this.calendarId <= 0L ? new CalendarSource() : CalendarSource.load(CalendarSourceViewPanel.this.calendarId);
                if (calendarSource == null) {
                    throw new Exception("source for calendar #" + CalendarSourceViewPanel.this.calendarId + " not found!");
                }
                CalendarSourceViewPanel.this.save(calendarSource);
                calendarSource.save();
                return calendarSource;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)CalendarSourceViewPanel.this.resourceMap.getString("error.cantSaveCalendar", new Object[0]), (Throwable)throwable);
            }

            protected void finished() {
                super.finished();
                CalendarSourceViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(CalendarSource calendarSource) {
                super.succeeded((Object)calendarSource);
                CalendarSourceViewPanel.this.load(calendarSource);
                ImmoToolUtils.updateTabs();
            }
        };
    }

    @Action
    public Task doTestUrl() {
        final CalendarSourceViewPanel calendarSourceViewPanel = this;
        return new ImmoToolTask<CalendarObject>(this.resourceMap.getString("doTestUrl.Action.text", new Object[0])){
            private StatusLine status;
            {
                super(string);
                this.status = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected CalendarObject executeTask() throws Exception {
                String string;
                String string2;
                HttpClient httpClient = null;
                Integer n = (Integer)CalendarSourceViewPanel.this.sourceAuthMethodBox.getSelectedItem();
                if (1 == n) {
                    string2 = CalendarSourceViewPanel.this.sourceAuthUserField.getText();
                    string = String.valueOf(CalendarSourceViewPanel.this.sourceAuthPassField.getPassword());
                    httpClient = ImmoToolUtils.createHttpClient((String)string2, (String)string);
                } else {
                    httpClient = ImmoToolUtils.createHttpClient();
                }
                string2 = httpClient.execute((HttpUriRequest)new HttpGet(ImmoToolUtils.toIdnUrl((String)CalendarSourceViewPanel.this.sourceUrlField.getText()).toURI()));
                string = null;
                try {
                    this.status = string2.getStatusLine();
                    string = string2.getEntity();
                    CalendarObject calendarObject = CalendarObject.createFromICal(string.getContent());
                    return calendarObject;
                }
                finally {
                    EntityUtils.consume((HttpEntity)string);
                }
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                LOGGER.info((Object)"URL test failed!");
                if (this.status != null) {
                    LOGGER.info((Object)("> code   : " + this.status.getStatusCode()));
                }
                if (this.status != null) {
                    LOGGER.info((Object)("> reason : " + this.status.getReasonPhrase()));
                }
                int n = this.status != null ? this.status.getStatusCode() : -1;
                ImmoToolUtils.showMessageErrorDialog((String)(CalendarSourceViewPanel.this.resourceMap.getString("error.urlTestFailed", new Object[0]) + " (" + n + ")"), (Throwable)throwable);
            }

            protected void succeeded(CalendarObject calendarObject) {
                super.succeeded((Object)calendarObject);
                ImmoToolUtils.showMessageInfoDialog((String)CalendarSourceViewPanel.this.resourceMap.getString("message.urlTestPassed", new Object[0]), (Component)((Object)calendarSourceViewPanel));
            }
        };
    }

    @Action
    public Task doViewNext() {
        if (this.nextCalendarId <= 0L) {
            return null;
        }
        if (!this.checkForModifications()) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<CalendarSource>(){

            protected CalendarSource executeTask() throws Exception {
                CalendarSource calendarSource = CalendarSource.load(CalendarSourceViewPanel.this.nextCalendarId);
                if (calendarSource == null) {
                    throw new Exception("Calendar #" + CalendarSourceViewPanel.this.nextCalendarId + " not found!");
                }
                CalendarSourceViewPanel.this.load(calendarSource);
                return calendarSource;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                CalendarSourceViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(CalendarSource calendarSource) {
                super.succeeded((Object)calendarSource);
                ImmoToolUtils.updateTabs();
                CalendarSourceViewPanel.this.requestFocus();
            }
        };
    }

    @Action
    public Task doViewPrevious() {
        if (this.prevCalendarId <= 0L) {
            return null;
        }
        if (!this.checkForModifications()) {
            return null;
        }
        this.setButtonsEnabled(false);
        return new ImmoToolTask<CalendarSource>(){

            protected CalendarSource executeTask() throws Exception {
                CalendarSource calendarSource = CalendarSource.load(CalendarSourceViewPanel.this.prevCalendarId);
                if (calendarSource == null) {
                    throw new Exception("Calendar #" + CalendarSourceViewPanel.this.prevCalendarId + " not found!");
                }
                CalendarSourceViewPanel.this.load(calendarSource);
                return calendarSource;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                CalendarSourceViewPanel.this.setButtonsEnabled(true);
            }

            protected void succeeded(CalendarSource calendarSource) {
                super.succeeded((Object)calendarSource);
                ImmoToolUtils.updateTabs();
                CalendarSourceViewPanel.this.requestFocus();
            }
        };
    }

    private class AuthRenderer
    extends JLabel
    implements ListCellRenderer {
        public AuthRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            if (object instanceof Integer) {
                int n2 = (Integer)object;
                if (1 == n2) {
                    this.setText(CalendarSourceViewPanel.this.resourceMap.getString("label.authType.httpBasic", new Object[0]));
                } else {
                    this.setText(CalendarSourceViewPanel.this.resourceMap.getString("label.authType.disabled", new Object[0]));
                }
            } else {
                this.setText("");
            }
            return this;
        }
    }
}

