/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import java.awt.Color;
import java.util.Calendar;
import java.util.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.property.Completed;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Status;

public class CalendarTodoEntry
extends CalendarEntry<VToDo> {
    public static final Status CANCELLED = Status.VTODO_CANCELLED;
    public static final Status COMPLETED = Status.VTODO_COMPLETED;
    public static final Status IN_PROCESS = Status.VTODO_IN_PROCESS;
    public static final Status NEEDS_ACTION = Status.VTODO_NEEDS_ACTION;

    public CalendarTodoEntry() {
        this(new VToDo());
    }

    public CalendarTodoEntry(VToDo vToDo) {
        super(vToDo);
    }

    @Override
    public Date getBegin() {
        if (((VToDo)this.getComponent()).getStartDate() == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(((VToDo)this.getComponent()).getStartDate().getDate().getTime());
        return calendar.getTime();
    }

    @Override
    public Date getEnd() {
        if (((VToDo)this.getComponent()).getDateCompleted() == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(((VToDo)this.getComponent()).getDateCompleted().getDate().getTime());
        return calendar.getTime();
    }

    @Override
    public String getEntryName() {
        return ImmoToolUtils.getResourceMap(CalendarEntry.class).getString("type.todo", new Object[0]);
    }

    @Override
    public Color getStatusColor() {
        return CalendarTodoEntry.getStatusColor(this.getStatus());
    }

    public static Color getStatusColor(Status status) {
        if (Status.VTODO_CANCELLED.equals((Object)status)) {
            return Color.GRAY;
        }
        if (Status.VTODO_COMPLETED.equals((Object)status)) {
            return Color.BLACK;
        }
        if (Status.VTODO_IN_PROCESS.equals((Object)status)) {
            return Color.RED;
        }
        if (Status.VTODO_NEEDS_ACTION.equals((Object)status)) {
            return Color.ORANGE.darker();
        }
        return null;
    }

    public static Status[] getStatusOptions() {
        return new Status[]{CANCELLED, COMPLETED, IN_PROCESS, NEEDS_ACTION};
    }

    @Override
    public boolean hasBeginDate() {
        DtStart dtStart = (DtStart)this.getProperty("DTSTART");
        return dtStart != null && dtStart.getDate() != null && !DateTime.class.isInstance(dtStart.getDate());
    }

    @Override
    public boolean hasBeginTime() {
        DtStart dtStart = (DtStart)this.getProperty("DTSTART");
        return dtStart != null && dtStart.getDate() != null && DateTime.class.isInstance(dtStart.getDate());
    }

    @Override
    public boolean hasEndDate() {
        Completed completed = (Completed)this.getProperty("COMPLETED");
        return completed != null && completed.getDate() != null && !DateTime.class.isInstance(completed.getDate());
    }

    @Override
    public boolean hasEndTime() {
        Completed completed = (Completed)this.getProperty("COMPLETED");
        return completed != null && completed.getDate() != null && DateTime.class.isInstance(completed.getDate());
    }

    @Override
    public void setBeginDate(Date date) {
        if (date == null) {
            this.removeProperty("DTSTART");
        } else {
            this.putProperty((Property)new DtStart(new net.fortuna.ical4j.model.Date(date)));
        }
    }

    @Override
    public void setBeginTime(Date date) {
        if (date == null) {
            this.removeProperty("DTSTART");
        } else {
            TimeZone timeZone = CalendarTodoEntry.getTimeZone();
            Calendar calendar = Calendar.getInstance((java.util.TimeZone)timeZone);
            calendar.setTimeInMillis(date.getTime());
            DateTime dateTime = new DateTime(calendar.getTime());
            dateTime.setUtc(false);
            dateTime.setTimeZone(timeZone);
            this.putProperty((Property)new DtStart((net.fortuna.ical4j.model.Date)dateTime));
        }
    }

    @Override
    public void setEndDate(Date date) {
        if (date == null) {
            this.removeProperty("COMPLETED");
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.add(6, 1);
            calendar.add(14, -1);
            this.setEndTime(calendar.getTime());
        }
    }

    @Override
    public void setEndTime(Date date) {
        if (date == null) {
            this.removeProperty("COMPLETED");
        } else {
            TimeZone timeZone = CalendarTodoEntry.getTimeZone();
            Calendar calendar = Calendar.getInstance((java.util.TimeZone)timeZone);
            calendar.setTimeInMillis(date.getTime());
            DateTime dateTime = new DateTime(calendar.getTime());
            dateTime.setUtc(false);
            dateTime.setTimeZone(timeZone);
            this.putProperty((Property)new Completed(dateTime));
        }
    }

    @Override
    public String writeStatus() {
        return CalendarTodoEntry.writeStatus(this.getStatus());
    }

    public static String writeStatus(Status status) {
        return CalendarTodoEntry.writeStatusForTodo(status);
    }
}

