/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntryPanel;
import com.openindex.openestate.tool.calendar.CalendarTodoEntry;
import com.openindex.openestate.tool.utils.FormatRule;
import com.openindex.openestate.tool.utils.ModificationHandler;
import com.openindex.openestate.tool.utils.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.ValidationRule;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.property.Completed;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Geo;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.PercentComplete;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.Status;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.fife.ui.rtextarea.RTextArea;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXDatePicker;

public class CalendarTodoEntryPanel
extends CalendarEntryPanel<CalendarTodoEntry> {
    private static final Logger LOGGER = Logger.getLogger(CalendarTodoEntryPanel.class);
    private ResourceMap resourceMap;
    private ModificationHandler modifications;
    private JXDatePicker todoBeginDateField;
    private JXDatePicker todoFinishDateField;
    private JComboBox todoPriorityField;
    private JComboBox todoStatusField;
    private RTextArea todoLocationField;
    private JFormattedTextField todoLocationLongitudeField;
    private JFormattedTextField todoLocationLatitudeField;
    private JSpinner todoPercentCompleteField;

    public CalendarTodoEntryPanel() {
        this.build();
    }

    private void build() {
        this.modifications = ImmoToolUtils.createModificationHandler();
        this.resourceMap = ImmoToolUtils.getResourceMap(CalendarTodoEntryPanel.class);
        this.buildPanel();
        this.resourceMap.injectComponents((Component)((Object)this));
    }

    @Override
    public CalendarTodoEntry createEntry() {
        return new CalendarTodoEntry();
    }

    @Override
    protected JPanel createEntryPanel() {
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        DateFormat dateFormat = DateFormat.getDateInstance(2);
        this.todoLocationField = new RTextArea();
        this.todoLocationField.setName("todoLocationField");
        this.todoLocationLongitudeField = new JFormattedTextField();
        this.todoLocationLongitudeField.setName("todoLocationLongitudeField");
        this.todoLocationLatitudeField = new JFormattedTextField();
        this.todoLocationLatitudeField.setName("todoLocationLatitudeField");
        this.todoPercentCompleteField = new JSpinner(new SpinnerNumberModel(0.0, 0.0, 1.0, 0.05));
        this.todoPercentCompleteField.setEditor(new JSpinner.NumberEditor(this.todoPercentCompleteField, "#.##%"));
        this.todoPercentCompleteField.setName("todoPerscentCompleteField");
        this.todoBeginDateField = new JXDatePicker();
        this.todoBeginDateField.setFormats(new DateFormat[]{dateFormat});
        this.todoBeginDateField.setName("todoBeginDateField");
        this.todoFinishDateField = new JXDatePicker();
        this.todoFinishDateField.setFormats(new DateFormat[]{dateFormat});
        this.todoFinishDateField.setName("todoFinishDateField");
        this.todoPriorityField = new JComboBox<Object>(new Object[]{"[ " + this.resourceMap.getString("label.priority.select", new Object[0]) + " ]", Priority.UNDEFINED, Priority.LOW, Priority.MEDIUM, Priority.HIGH});
        this.todoPriorityField.setName("todoPriorityField");
        this.todoPriorityField.setRenderer(new CalendarEntryPanel.PriorityRenderer(this));
        this.todoStatusField = new JComboBox<Object>(new Object[]{"[ " + this.resourceMap.getString("label.status.select", new Object[0]) + " ]", Status.VTODO_NEEDS_ACTION, Status.VTODO_IN_PROCESS, Status.VTODO_COMPLETED, Status.VTODO_CANCELLED});
        this.todoStatusField.setName("todoStatusField");
        this.todoStatusField.setRenderer(new StatusRenderer());
        if (this.todoBeginDateField == null) {
            throw new RuntimeException("invalid date-field!");
        }
        this.getValidationHandler().putRule((JComponent)this.todoPercentCompleteField, (ValidationRule)new FormatRule((Format)numberFormat));
        this.getValidationHandler().putRule((JComponent)this.todoPriorityField, (ValidationRule)new NonEmptyComboBoxRule(this.todoPriorityField));
        this.getValidationHandler().putRule((JComponent)this.todoStatusField, (ValidationRule)new NonEmptyComboBoxRule(this.todoStatusField));
        this.getValidationHandler().putRule((JComponent)this.todoBeginDateField.getEditor(), new ValidationRule(){

            public boolean isValid(Object object) {
                String string = StringUtils.defaultIfBlank((String)CalendarTodoEntryPanel.this.todoBeginDateField.getEditor().getText(), null);
                if (string == null) {
                    return false;
                }
                Date date = null;
                for (DateFormat dateFormat : CalendarTodoEntryPanel.this.todoBeginDateField.getFormats()) {
                    try {
                        date = dateFormat.parse(string);
                        if (date == null) continue;
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (date == null) {
                    return false;
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                int n = calendar.get(1);
                return n >= 1000 && n <= 9999;
            }
        });
        this.getValidationHandler().putRule((JComponent)this.todoFinishDateField.getEditor(), (ValidationRule)new FormatRule(dateFormat){

            public boolean isValid(Object object) {
                String string = StringUtils.defaultIfBlank((String)CalendarTodoEntryPanel.this.todoFinishDateField.getEditor().getText(), null);
                if (string == null) {
                    return true;
                }
                Date date = null;
                for (DateFormat dateFormat : CalendarTodoEntryPanel.this.todoFinishDateField.getFormats()) {
                    try {
                        date = dateFormat.parse(string);
                        if (date == null) continue;
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (date == null) {
                    return false;
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                int n = calendar.get(1);
                Date date2 = CalendarTodoEntryPanel.this.todoBeginDateField.getDate();
                return n >= 1000 && n <= 9999 && date2 != null && date2.before(date);
            }
        });
        DefaultFormBuilder defaultFormBuilder = ImmoToolUtils.createFormBuilder((String)"right:[50dlu,pref], 3dlu, pref:grow, 3dlu, right:pref, 3dlu, pref:grow");
        defaultFormBuilder.border(Borders.DIALOG);
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("formTitle", new Object[0])), 3);
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("optionTitle", new Object[0])), 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.begin", new Object[0]), (Component)this.todoBeginDateField);
        defaultFormBuilder.append(this.resourceMap.getString("label.status", new Object[0]), (Component)this.todoStatusField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.progress", new Object[0]), (Component)this.todoPercentCompleteField);
        defaultFormBuilder.append(this.resourceMap.getString("label.priority", new Object[0]), (Component)this.todoPriorityField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.resourceMap.getString("label.finish", new Object[0]), (Component)this.todoFinishDateField);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)new JLabel(" "), 7);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)ImmoToolUtils.createHead2Separator((String)this.resourceMap.getString("locationTitle", new Object[0])), 7);
        defaultFormBuilder.nextLine();
        JScrollPane jScrollPane = new JScrollPane((Component)this.todoLocationField);
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        defaultFormBuilder.defaultRowSpec(RowSpec.decode((String)"top:pref"));
        defaultFormBuilder.append(this.resourceMap.getString("label.location", new Object[0]), (Component)jScrollPane, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.defaultRowSpec(FormSpecs.PREF_ROWSPEC);
        defaultFormBuilder.append(this.resourceMap.getString("label.geo.longitude", new Object[0]), (Component)this.todoLocationLongitudeField);
        defaultFormBuilder.append(this.resourceMap.getString("label.geo.latitude", new Object[0]), (Component)this.todoLocationLatitudeField);
        defaultFormBuilder.nextLine();
        return defaultFormBuilder.getPanel();
    }

    @Override
    public String getTitle() {
        return this.resourceMap.getString("title", new Object[0]);
    }

    public boolean isFormEnabled() {
        return true;
    }

    @Override
    public boolean isFormModified() {
        return this.modifications.isModified() || super.isFormModified();
    }

    public boolean isFormUsable() {
        return true;
    }

    @Override
    public void load(CalendarTodoEntry calendarTodoEntry) throws ImmoToolException {
        Status status;
        Status status2;
        Priority priority;
        Priority priority2;
        super.load(calendarTodoEntry);
        DtStart dtStart = calendarTodoEntry != null ? ((VToDo)calendarTodoEntry.getComponent()).getStartDate() : null;
        this.todoBeginDateField.setDate((Date)(dtStart != null ? dtStart.getDate() : null));
        Completed completed = calendarTodoEntry != null ? ((VToDo)calendarTodoEntry.getComponent()).getDateCompleted() : null;
        this.todoFinishDateField.setDate((Date)(completed != null ? completed.getDate() : null));
        PercentComplete percentComplete = calendarTodoEntry != null ? ((VToDo)calendarTodoEntry.getComponent()).getPercentComplete() : null;
        this.todoPercentCompleteField.setValue(0.0);
        if (percentComplete != null) {
            double d = (double)percentComplete.getPercentage() / 100.0;
            this.todoPercentCompleteField.setValue(d);
        }
        this.todoPriorityField.setSelectedIndex(1);
        Priority priority3 = priority2 = calendarTodoEntry != null ? ((VToDo)calendarTodoEntry.getComponent()).getPriority() : null;
        if (priority2 != null) {
            for (int i = 1; i < this.todoPriorityField.getItemCount(); ++i) {
                priority = (Priority)this.todoPriorityField.getItemAt(i);
                if (!priority.equals((Object)priority2)) continue;
                this.todoPriorityField.setSelectedIndex(i);
                break;
            }
        }
        this.todoStatusField.setSelectedIndex(1);
        Status status3 = status2 = calendarTodoEntry != null ? ((VToDo)calendarTodoEntry.getComponent()).getStatus() : null;
        if (status2 != null) {
            for (int i = 1; i < this.todoStatusField.getItemCount(); ++i) {
                status = (Status)this.todoStatusField.getItemAt(i);
                if (!status.equals((Object)status2)) continue;
                this.todoStatusField.setSelectedIndex(i);
                break;
            }
        }
        this.todoLocationField.setText("");
        Location location = priority = calendarTodoEntry != null ? ((VToDo)calendarTodoEntry.getComponent()).getLocation() : null;
        if (priority != null) {
            this.todoLocationField.setText(priority.getValue());
        }
        this.todoLocationLatitudeField.setValue(null);
        this.todoLocationLongitudeField.setValue(null);
        Geo geo = status = calendarTodoEntry != null ? ((VToDo)calendarTodoEntry.getComponent()).getGeographicPos() : null;
        if (status != null) {
            if (status.getLatitude() != null) {
                this.todoLocationLatitudeField.setValue(status.getLatitude().doubleValue());
            }
            if (status.getLongitude() != null) {
                this.todoLocationLongitudeField.setValue(status.getLongitude().doubleValue());
            }
        }
        this.getValidationHandler().validate();
        this.modifications.clear();
        this.modifications.putValue((JComponent)this.todoBeginDateField);
        this.modifications.putValue((JComponent)this.todoFinishDateField);
        this.modifications.putValue((JComponent)this.todoPriorityField);
        this.modifications.putValue((JComponent)this.todoStatusField);
        this.modifications.putValue((JComponent)this.todoLocationField);
        this.modifications.putValue((JComponent)this.todoLocationLongitudeField);
        this.modifications.putValue((JComponent)this.todoLocationLatitudeField);
        this.modifications.putValue((JComponent)this.todoPercentCompleteField);
    }

    @Override
    public void save(CalendarTodoEntry calendarTodoEntry) throws ImmoToolException {
        super.save(calendarTodoEntry);
        try {
            this.todoBeginDateField.commitEdit();
            this.todoFinishDateField.commitEdit();
        }
        catch (ParseException parseException) {
            throw new ImmoToolException("Can't parse interval!", (Throwable)parseException);
        }
        calendarTodoEntry.setBeginDate(this.todoBeginDateField.getDate());
        if (this.todoFinishDateField.getDate() != null) {
            calendarTodoEntry.setEndDate(this.todoFinishDateField.getDate());
        } else {
            calendarTodoEntry.setEndDate(this.todoBeginDateField.getDate());
        }
        if (this.todoPercentCompleteField.getValue() != null) {
            try {
                this.todoPercentCompleteField.commitEdit();
                int n = (int)(((Number)this.todoPercentCompleteField.getValue()).doubleValue() * 100.0);
                calendarTodoEntry.putProperty((Property)new PercentComplete(n));
            }
            catch (Exception exception) {
                LOGGER.warn((Object)("Can't read percentage value: " + exception.getLocalizedMessage()), (Throwable)exception);
                calendarTodoEntry.removeProperty("PERCENT-COMPLETE");
            }
        } else {
            calendarTodoEntry.removeProperty("PERCENT-COMPLETE");
        }
        if (this.todoPriorityField.getSelectedIndex() <= 0) {
            calendarTodoEntry.removeProperty("PRIORITY");
        } else {
            calendarTodoEntry.putProperty((Property)((Priority)this.todoPriorityField.getSelectedItem()));
        }
        if (this.todoStatusField.getSelectedIndex() <= 0) {
            calendarTodoEntry.removeProperty("STATUS");
        } else {
            calendarTodoEntry.putProperty((Property)((Status)this.todoStatusField.getSelectedItem()));
        }
        String string = this.todoLocationField.getText().trim();
        if (string.length() == 0) {
            calendarTodoEntry.removeProperty("LOCATION");
        } else {
            calendarTodoEntry.putProperty((Property)new Location(string));
        }
        Number number = (Number)this.todoLocationLatitudeField.getValue();
        Number number2 = (Number)this.todoLocationLongitudeField.getValue();
        if (number == null || number2 == null) {
            calendarTodoEntry.removeProperty("GEO");
        } else {
            calendarTodoEntry.putProperty((Property)new Geo(BigDecimal.valueOf(number.doubleValue()), BigDecimal.valueOf(number2.doubleValue())));
        }
    }

    @Override
    public void setDate(Date date) {
        this.todoBeginDateField.setDate(date);
    }

    @Override
    public void setDateInterval(Date date, Date date2) {
        this.todoBeginDateField.setDate(date);
        this.todoFinishDateField.setDate(date2);
    }

    @Override
    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.todoBeginDateField.setEditable(bl);
        this.todoFinishDateField.setEditable(bl);
        this.todoPriorityField.setEnabled(bl);
        this.todoStatusField.setEnabled(bl);
        this.todoLocationField.setEditable(bl);
        this.todoLocationLongitudeField.setEditable(bl);
        this.todoLocationLatitudeField.setEditable(bl);
        this.todoPercentCompleteField.setEnabled(bl);
    }

    private static class StatusRenderer
    extends JLabel
    implements ListCellRenderer {
        private Font normalFont;
        private Font boldFont;

        public StatusRenderer() {
            this.setOpaque(true);
            this.normalFont = this.getFont();
            this.boldFont = this.normalFont.deriveFont(1);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            if (object instanceof Status) {
                Status status = (Status)object;
                this.setText(CalendarTodoEntry.writeStatus(status));
                this.setForeground(CalendarTodoEntry.getStatusColor(status));
                this.setFont(this.boldFont);
            } else {
                this.setText(object != null ? object.toString() : "");
                this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
                this.setFont(this.normalFont);
            }
            return this;
        }
    }
}

