/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarEventEntry;
import com.openindex.openestate.tool.calendar.CalendarJournalEntry;
import com.openindex.openestate.tool.calendar.CalendarTodoEntry;
import com.openindex.openestate.tool.utils.Service;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Action;

public abstract class VirtualCalendarObject {
    public Action[] getActions(CalendarEntry calendarEntry) {
        Action[] actionArray;
        Action action = this.getViewAction(calendarEntry);
        if (action != null) {
            Action[] actionArray2 = new Action[1];
            actionArray = actionArray2;
            actionArray2[0] = action;
        } else {
            actionArray = null;
        }
        return actionArray;
    }

    public CalendarEntry[] getEntries() throws ImmoToolException {
        return this.getEntries(null);
    }

    public abstract CalendarEntry[] getEntries(String var1) throws ImmoToolException;

    public CalendarEventEntry[] getEventEntries() throws ImmoToolException {
        ArrayList<CalendarEventEntry> arrayList = new ArrayList<CalendarEventEntry>();
        for (CalendarEntry calendarEntry : this.getEntries("VEVENT")) {
            arrayList.add((CalendarEventEntry)calendarEntry);
        }
        return arrayList.toArray(new CalendarEventEntry[arrayList.size()]);
    }

    public CalendarJournalEntry[] getJournalEntries() throws ImmoToolException {
        ArrayList<CalendarJournalEntry> arrayList = new ArrayList<CalendarJournalEntry>();
        for (CalendarEntry calendarEntry : this.getEntries("VJOURNAL")) {
            arrayList.add((CalendarJournalEntry)calendarEntry);
        }
        return arrayList.toArray(new CalendarJournalEntry[arrayList.size()]);
    }

    public abstract String getTitle();

    public CalendarTodoEntry[] getTodoEntries() throws ImmoToolException {
        ArrayList<CalendarTodoEntry> arrayList = new ArrayList<CalendarTodoEntry>();
        for (CalendarEntry calendarEntry : this.getEntries("VTODO")) {
            arrayList.add((CalendarTodoEntry)calendarEntry);
        }
        return arrayList.toArray(new CalendarTodoEntry[arrayList.size()]);
    }

    public static VirtualCalendarObject[] getUsableCalendars() throws InstantiationException, IllegalAccessException {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = Service.providers(VirtualCalendarObject.class);
        while (iterator.hasNext()) {
            VirtualCalendarObject virtualCalendarObject = (VirtualCalendarObject)iterator.next();
            if (!virtualCalendarObject.isUsable()) continue;
            arrayList.add(virtualCalendarObject.getClass().newInstance());
        }
        return arrayList.toArray(new VirtualCalendarObject[arrayList.size()]);
    }

    public Action getViewAction(CalendarEntry calendarEntry) {
        return null;
    }

    public abstract boolean isUsable();
}

