/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar.utils;

import com.openindex.openestate.tool.calendar.CalendarEntry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.text.ParseException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.CalendarParser;
import net.fortuna.ical4j.data.CalendarParserFactory;
import net.fortuna.ical4j.data.ContentHandler;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ValidationException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;

public class XCalUtils {
    private static final Logger LOGGER = Logger.getLogger(XCalUtils.class);
    public static final String XCAL_NAMESPACE = "http://ietf.org/rfc/rfcXXXX.txt";
    public static final String XCAL_PREFIX = "xCal";
    public static final String XQUERY_CLASSPATH = "declare namespace xCal=\"http://ietf.org/rfc/rfcXXXX.txt\";";
    private static final String XSLT_PATH = "/com/openindex/openestate/tool/calendar/resources/xCal2iCal-1-3.xslt";
    private static final CalendarBuilder BUILDER = new CalendarBuilder(CalendarEntry.getTimeZoneRegistry());
    private static Transformer XSLT_TRANSFORMER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Calendar read(Reader reader) throws TransformerConfigurationException, TransformerException, IOException, ParserException {
        Object object;
        String string = null;
        StringWriter stringWriter = null;
        try {
            stringWriter = new StringWriter();
            XCalUtils.read(reader, stringWriter);
            string = stringWriter.toString();
            if (!string.contains("BEGIN:")) {
                Calendar calendar = null;
                return calendar;
            }
            string = string.substring(string.indexOf("BEGIN:"));
        }
        finally {
            IOUtils.closeQuietly((Writer)stringWriter);
        }
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new StringReader(string));
            while (bufferedReader.ready() && (string2 = bufferedReader.readLine()) != null) {
                object = string2.trim();
                if (((String)object).length() == 0) continue;
                if (!string2.startsWith(" ")) {
                    stringBuilder.append(SystemUtils.LINE_SEPARATOR);
                }
                stringBuilder.append((String)object);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedReader);
            string = null;
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
        string = null;
        try {
            return BUILDER.build((Reader)new StringReader(stringBuilder.toString().trim()));
        }
        catch (ParserException parserException) {
            LOGGER.warn((Object)"Can't parse iCal!");
            LOGGER.warn((Object)("> at line #" + parserException.getLineNo()));
            LOGGER.warn((Object)("> " + parserException.getLocalizedMessage()));
            object = null;
            try {
                LOGGER.warn((Object)"------------------------------------------");
                int n = parserException.getLineNo();
                n = n > 10 ? (n -= 10) : 0;
                int n2 = parserException.getLineNo() + 10;
                object = new LineNumberReader(new StringReader(stringBuilder.toString().trim()));
                ((LineNumberReader)object).setLineNumber(n);
                String string3 = ((LineNumberReader)object).readLine();
                while (string3 != null && ((LineNumberReader)object).getLineNumber() <= n2) {
                    LOGGER.warn((Object)(((LineNumberReader)object).getLineNumber() + " | " + string3));
                    string3 = ((LineNumberReader)object).readLine();
                }
                LOGGER.warn((Object)"------------------------------------------");
            }
            catch (Exception exception) {
                LOGGER.error((Object)"Can't read problematic iCal-lines!");
                LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
            finally {
                IOUtils.closeQuietly((Reader)object);
            }
            throw parserException;
        }
    }

    public static void read(Reader reader, Writer writer) throws TransformerConfigurationException, TransformerException {
        StreamSource streamSource = new StreamSource(reader);
        StreamResult streamResult = new StreamResult(writer);
        if (XSLT_TRANSFORMER == null) {
            throw new TransformerException("unknown xslt-transformer!");
        }
        XSLT_TRANSFORMER.transform(streamSource, streamResult);
    }

    public static void write(Calendar calendar, Writer writer) throws XMLStreamException, IOException, ParserException, XMLStreamException, ValidationException {
        XCalUtils.write(new StringReader(calendar.toString()), writer);
    }

    public static void write(Reader reader, Writer writer) throws XMLStreamException, IOException, ParserException, XMLStreamException {
        CalendarParser calendarParser = CalendarParserFactory.getInstance().createParser();
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        xMLOutputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        XMLStreamWriter xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(writer);
        XMLHandler xMLHandler = new XMLHandler(xMLStreamWriter);
        xMLStreamWriter.writeStartDocument();
        calendarParser.parse(reader, (ContentHandler)xMLHandler);
        xMLStreamWriter.writeEndDocument();
        xMLStreamWriter.close();
    }

    static {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            StreamSource streamSource = new StreamSource(XCalUtils.class.getResourceAsStream(XSLT_PATH));
            XSLT_TRANSFORMER = transformerFactory.newTransformer(streamSource);
        }
        catch (Exception exception) {
            XSLT_TRANSFORMER = null;
            LOGGER.fatal((Object)"Can't load XSLT-transformer!");
            LOGGER.fatal((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    private static final class XMLHandler
    implements ContentHandler {
        private final XMLStreamWriter xmlWriter;

        public XMLHandler(XMLStreamWriter xMLStreamWriter) {
            this.xmlWriter = xMLStreamWriter;
        }

        public void startCalendar() {
            try {
                this.writeStartElement("", "", "iCalendar");
                this.writeStartElement("vcalendar");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void endCalendar() {
            this.writeEndElement();
            this.writeEndElement();
        }

        public void startComponent(String string) {
            this.writeStartElement(string.toLowerCase());
        }

        public void endComponent(String string) {
            this.writeEndElement();
        }

        public void startProperty(String string) {
            this.writeStartElement(string.toLowerCase());
        }

        public void propertyValue(String string) throws URISyntaxException, ParseException, IOException {
            this.writeCharacters(string);
        }

        public void endProperty(String string) {
            this.writeEndElement();
        }

        public void parameter(String string, String string2) throws URISyntaxException {
            this.writeAttribute(string, string2);
        }

        private void writeStartElement(String string) {
            this.writeStartElement(XCalUtils.XCAL_NAMESPACE, XCalUtils.XCAL_PREFIX, string);
        }

        private void writeStartElement(String string, String string2, String string3) {
            try {
                if (string != null && string2 != null) {
                    this.xmlWriter.writeStartElement(string2, string3, string);
                } else if (string != null) {
                    this.xmlWriter.writeStartElement(string, string3);
                } else {
                    this.xmlWriter.writeStartElement(string3);
                }
            }
            catch (XMLStreamException xMLStreamException) {
                throw new IllegalStateException("got xml error while writing", xMLStreamException);
            }
        }

        private void writeCharacters(String string) {
            try {
                this.xmlWriter.writeCharacters(string);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new IllegalStateException("got xml error while writing", xMLStreamException);
            }
        }

        private void writeAttribute(String string, String string2) {
            try {
                this.xmlWriter.writeAttribute(string.toLowerCase(), string2);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new IllegalStateException("got xml error while writing", xMLStreamException);
            }
        }

        private void writeEndElement() {
            try {
                this.xmlWriter.writeEndElement();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new IllegalStateException("got xml error while writing", xMLStreamException);
            }
        }
    }
}

