/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import net.fortuna.ical4j.model.Calendar;
import org.apache.commons.lang.StringEscapeUtils;

public class XCalWriter {
    public static void writeXCal(Calendar calendar, Writer writer) throws IOException {
        XCalWriter.writeXCal(new StringReader(calendar.toString()), writer);
    }

    public static void writeXCal(Reader reader, Writer writer) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        writer.write("<iCalendar xmlns:xCal=\"http://ietf.org/rfc/rfcXXXX.txt\">");
        while ((string = bufferedReader.readLine()) != null) {
            XCalWriter.writeXcalLine(string.trim(), writer);
        }
        writer.write("</iCalendar>");
        writer.flush();
    }

    private static void writeXcalLine(String string, Writer writer) throws IOException {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        int n = string.indexOf(":");
        if (n <= 0) {
            return;
        }
        String string2 = string.substring(0, n);
        String string3 = string.length() > n + 1 ? string.substring(n + 1) : "";
        String[] stringArray = string2.split(";");
        String string4 = stringArray[0];
        if (string4.trim().equalsIgnoreCase("BEGIN")) {
            writer.write("<" + StringEscapeUtils.escapeXml((String)string3.toString().trim().toLowerCase()) + ">");
        } else if (string4.trim().equalsIgnoreCase("END")) {
            writer.write("</" + StringEscapeUtils.escapeXml((String)string3.toString().trim().toLowerCase()) + ">");
        } else {
            writer.write("<" + StringEscapeUtils.escapeXml((String)string3.toString().trim().toLowerCase()));
            for (int i = 1; i < stringArray.length; ++i) {
                String string5;
                int n2 = stringArray[i].indexOf("=");
                if (n2 < 0) continue;
                String string6 = stringArray[i].substring(0, n2);
                String string7 = string5 = stringArray[i].length() > n2 + 1 ? stringArray[i].substring(n2 + 1) : "";
                if (string5.startsWith("\"") || string5.startsWith("'")) {
                    string5 = string5.substring(1);
                }
                if (string5.endsWith("\"") || string5.endsWith("'")) {
                    string5 = string5.substring(0, string5.length() - 1);
                }
                if (string6.trim().equalsIgnoreCase("language")) {
                    writer.write(" xml:lang=\"" + StringEscapeUtils.escapeXml((String)string5) + "\"");
                    continue;
                }
                writer.write(" " + string6.trim().toLowerCase() + "=\"" + StringEscapeUtils.escapeXml((String)string5) + "\"");
            }
            writer.write(">" + string3.trim() + "</" + StringEscapeUtils.escapeXml((String)string3.toString().trim().toLowerCase()) + ">");
        }
    }
}

