/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.impl.CompanyAdressImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.PersonAdressImpl;
import com.openindex.openestate.impl.SerializableXmlElement;
import com.openindex.openestate.impl.SimpleAdressImpl;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDb;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolDbUtils;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsPluginUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.jdesktop.application.ResourceMap;
import org.w3c.dom.Node;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class ContactsEntry {
    private static final Logger LOGGER = Logger.getLogger(ContactsEntry.class);
    public static final String VALUE_AUSWEIS_NR = "ausweis_nr";
    public static final String VALUE_AUSWEIS_ART = "ausweis_art";
    public static final String VALUE_AUSWEIS_BEHOERDE = "ausweis_behoerde";
    public static final String VALUE_CITIZENSHIP = "citizenship";
    public static final String VALUE_CONTACT_ALLOWED = "contact_allowed";
    public static final String VALUE_DAY_OF_BIRTH = "day_of_birth";
    public static final String VALUE_PLACE_OF_BIRTH = "place_of_birth";
    public static final String VALUE_KONTO_INHABER = "konto_inhaber";
    public static final String VALUE_KONTO_INSTITUT = "konto_institut";
    public static final String VALUE_KONTO_NR = "konto_nr";
    public static final String VALUE_KONTO_BLZ = "konto_blz";
    public static final String VALUE_KONTO_IBAN = "konto_iban";
    public static final String VALUE_KONTO_BIC = "konto_bic";
    public static final String VALUE_SPRACHEN = "sprachen";
    public static final String VALUE_STATUS = "status";
    public static final String VALUE_STEUER_NR = "steuer_nr";
    public static final String VALUE_STEUER_IDNR = "steuer_idnr";
    public static final String VALUE_STEUER_UMSATZ_IDNR = "steuer_umsatz_idnr";
    public static final String VALUE_WIRTSCHAFT_IDNR = "wirtschaft_idnr";
    public static final String VALUE_TEXT = "text";
    public static final String STATUS_ACTIVE = "active";
    public static final String STATUS_INACTIVE = "inactive";
    public static final String AUSWEIS_PERSONALAUSWEIS = "IDENTIFICATION_CARD";
    public static final String AUSWEIS_REISEPASS = "PASSPORT";
    public static final String AUSWEIS_FUEHERERSCHEIN = "DRIVING_LICENSE";
    private long id = 0L;
    private long groupId = 0L;
    private SimpleAdressImpl adress = new CompanyAdressImpl();

    public Row createRow() {
        Row row = new Row();
        row.id = this.getId();
        row.group = this.getGroupId();
        row.status = this.getStatus();
        row.adressCity = this.getCompanyAdress().getCity();
        row.adressCountry = this.getCompanyAdress().getCountry();
        row.adressPostalCode = this.getCompanyAdress().getPostalCode();
        row.adressStreet = this.getCompanyAdress().getStreet();
        row.adressStreetNr = this.getCompanyAdress().getStreetNr();
        row.company = this.getCompanyAdress().getCompanyName();
        row.firstName = this.getCompanyAdress().getPersonFirstName();
        row.lastName = this.getCompanyAdress().getPersonLastName();
        row.mail = this.getCompanyAdress().getPersonMail();
        row.dayOfBirth = this.getDayOfBirth();
        if (row.mail == null || row.mail.trim().length() == 0) {
            row.mail = this.getCompanyAdress().getCompanyMail();
        }
        row.phone = this.getCompanyAdress().getPersonPhone();
        if (row.phone == null || row.phone.trim().length() == 0) {
            row.phone = this.getCompanyAdress().getCompanyPhone();
        }
        return row;
    }

    public SimpleAdressImpl getAdress() {
        return this.adress;
    }

    public String getAusweisArt() {
        if (!this.getCompanyAdress().getCustomValues().hasCustomValue(VALUE_AUSWEIS_ART)) {
            return "";
        }
        return this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_AUSWEIS_ART).isText() ? this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_AUSWEIS_ART).getText() : this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_AUSWEIS_ART).getString();
    }

    public String getAusweisBehoerde() {
        if (!this.getCompanyAdress().getCustomValues().hasCustomValue(VALUE_AUSWEIS_BEHOERDE)) {
            return "";
        }
        return this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_AUSWEIS_BEHOERDE).isText() ? this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_AUSWEIS_BEHOERDE).getText() : this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_AUSWEIS_BEHOERDE).getString();
    }

    public String getAusweisNr() {
        if (!this.getCompanyAdress().getCustomValues().hasCustomValue(VALUE_AUSWEIS_NR)) {
            return "";
        }
        return this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_AUSWEIS_NR).isText() ? this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_AUSWEIS_NR).getText() : this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_AUSWEIS_NR).getString();
    }

    public String getCitizenship() {
        if (!this.getCompanyAdress().getCustomValues().hasCustomValue(VALUE_CITIZENSHIP)) {
            return "";
        }
        return this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_CITIZENSHIP).isText() ? this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_CITIZENSHIP).getText() : this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_CITIZENSHIP).getString();
    }

    public CompanyAdressImpl getCompanyAdress() {
        return (CompanyAdressImpl)this.adress;
    }

    public Date getDayOfBirth() {
        if (!this.getCompanyAdress().getCustomValues().hasCustomValue(VALUE_DAY_OF_BIRTH)) {
            return null;
        }
        return this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_DAY_OF_BIRTH).getDate();
    }

    public long getGroupId() {
        return this.groupId;
    }

    public long getId() {
        return this.id;
    }

    public String getKontoBic() {
        if (!this.getCompanyAdress().getCustomValues().hasCustomValue(VALUE_KONTO_BIC)) {
            return "";
        }
        return this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_KONTO_BIC).isText() ? this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_KONTO_BIC).getText() : this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_KONTO_BIC).getString();
    }

    public String getKontoBlz() {
        if (!this.getCompanyAdress().getCustomValues().hasCustomValue(VALUE_KONTO_BLZ)) {
            return "";
        }
        return this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_KONTO_BLZ).isText() ? this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_KONTO_BLZ).getText() : this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_KONTO_BLZ).getString();
    }

    public String getKontoIban() {
        if (!this.getCompanyAdress().getCustomValues().hasCustomValue(VALUE_KONTO_IBAN)) {
            return "";
        }
        return this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_KONTO_IBAN).isText() ? this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_KONTO_IBAN).getText() : this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_KONTO_IBAN).getString();
    }

    public String getKontoInhaber() {
        if (!this.getCompanyAdress().getCustomValues().hasCustomValue(VALUE_KONTO_INHABER)) {
            return "";
        }
        return this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_KONTO_INHABER).isText() ? this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_KONTO_INHABER).getText() : this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_KONTO_INHABER).getString();
    }

    public String getKontoInstitut() {
        if (!this.getCompanyAdress().getCustomValues().hasCustomValue(VALUE_KONTO_INSTITUT)) {
            return "";
        }
        return this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_KONTO_INSTITUT).isText() ? this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_KONTO_INSTITUT).getText() : this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_KONTO_INSTITUT).getString();
    }

    public String getKontoNr() {
        if (!this.getCompanyAdress().getCustomValues().hasCustomValue(VALUE_KONTO_NR)) {
            return "";
        }
        return this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_KONTO_NR).isText() ? this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_KONTO_NR).getText() : this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_KONTO_NR).getString();
    }

    public String getPlaceOfBirth() {
        if (!this.getCompanyAdress().getCustomValues().hasCustomValue(VALUE_PLACE_OF_BIRTH)) {
            return "";
        }
        return this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_PLACE_OF_BIRTH).isText() ? this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_PLACE_OF_BIRTH).getText() : this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_PLACE_OF_BIRTH).getString();
    }

    public Locale[] getSprachen() {
        if (!this.getCompanyAdress().getCustomValues().hasCustomValue(VALUE_SPRACHEN)) {
            return new Locale[0];
        }
        String string = this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_SPRACHEN).isText() ? this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_SPRACHEN).getText() : this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_SPRACHEN).getString();
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        for (String string2 : string.split(",")) {
            arrayList.add(new Locale(string2));
        }
        return arrayList.toArray(new Locale[arrayList.size()]);
    }

    public String getStatus() {
        if (!this.getCompanyAdress().getCustomValues().hasCustomValue(VALUE_STATUS)) {
            return STATUS_ACTIVE;
        }
        return this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_STATUS).isText() ? this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_STATUS).getText() : this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_STATUS).getString();
    }

    public String getSteuerIdNr() {
        if (!this.getCompanyAdress().getCustomValues().hasCustomValue(VALUE_STEUER_IDNR)) {
            return "";
        }
        return this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_STEUER_IDNR).isText() ? this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_STEUER_IDNR).getText() : this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_STEUER_IDNR).getString();
    }

    public String getSteuerNr() {
        if (!this.getCompanyAdress().getCustomValues().hasCustomValue(VALUE_STEUER_NR)) {
            return "";
        }
        return this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_STEUER_NR).isText() ? this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_STEUER_NR).getText() : this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_STEUER_NR).getString();
    }

    public String getSteuerUmsatzIdNr() {
        if (!this.getCompanyAdress().getCustomValues().hasCustomValue(VALUE_STEUER_UMSATZ_IDNR)) {
            return "";
        }
        return this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_STEUER_UMSATZ_IDNR).isText() ? this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_STEUER_UMSATZ_IDNR).getText() : this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_STEUER_UMSATZ_IDNR).getString();
    }

    public String getText() {
        if (!this.getCompanyAdress().getCustomValues().hasCustomValue(VALUE_TEXT)) {
            return "";
        }
        return this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_TEXT).isText() ? this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_TEXT).getText() : this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_TEXT).getString();
    }

    public String getWirtschaftIdNr() {
        if (!this.getCompanyAdress().getCustomValues().hasCustomValue(VALUE_WIRTSCHAFT_IDNR)) {
            return "";
        }
        return this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_WIRTSCHAFT_IDNR).isText() ? this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_WIRTSCHAFT_IDNR).getText() : this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_WIRTSCHAFT_IDNR).getString();
    }

    public PersonAdressImpl getPersonAdress() {
        return (PersonAdressImpl)this.adress;
    }

    public boolean isCompanyAdress() {
        return this.adress instanceof CompanyAdressImpl;
    }

    public boolean isContactAllowed() {
        return this.getCompanyAdress().getCustomValues().hasCustomValue(VALUE_CONTACT_ALLOWED) && Boolean.TRUE.equals(this.getCompanyAdress().getCustomValues().getCustomValue(VALUE_CONTACT_ALLOWED).getBoolean());
    }

    public boolean isPersonAdress() {
        return this.adress instanceof PersonAdressImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContactsEntry load(long l, long l2) throws ImmoToolDbException {
        ContactsEntry contactsEntry;
        Collection collection = null;
        try {
            collection = ContactsPluginUtils.openPluginCollection("/" + String.valueOf(l));
            contactsEntry = ContactsEntry.load(l, l2, collection);
        }
        catch (Throwable throwable) {
            ImmoToolDbUtils.close(collection);
            throw throwable;
        }
        ImmoToolDbUtils.close((Collection)collection);
        return contactsEntry;
    }

    public static ContactsEntry load(long l, long l2, Collection collection) throws ImmoToolDbException {
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Contacts/" + l)) {
                throw new ImmoToolDbException("invalid collection!");
            }
            String string = "contact." + l2 + ".xml";
            if (!ImmoToolDbUtils.hasResource((Collection)collection, (String)string)) {
                return null;
            }
            XMLResource xMLResource = ImmoToolDbUtils.loadXMLResource((Collection)collection, (String)string);
            if (xMLResource == null) {
                throw new ImmoToolDbException("contact-resource not found: " + string);
            }
            ContactsEntry contactsEntry = new ContactsEntry();
            contactsEntry.load(xMLResource, l);
            return contactsEntry;
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void load(XMLResource xMLResource) throws ImmoToolDbException {
        try {
            String[] stringArray = xMLResource.getParentCollection().getName().split("/");
            this.load(xMLResource, Long.valueOf(stringArray[stringArray.length - 1]));
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void load(XMLResource xMLResource, long l) throws DocumentException, XMLDBException, ImmoToolDbException {
        String[] stringArray = xMLResource.getId().split("\\.");
        if (stringArray.length == 3) {
            this.setId(Long.valueOf(stringArray[1]));
        }
        this.setGroupId(l);
        Document document = OpenEstateUtils.loadDocument((Reader)new StringReader((String)xMLResource.getContent()));
        String string = document.getRootElement().getName();
        if ("CompanyAdress".equals(string)) {
            this.setAdress((SimpleAdressImpl)new CompanyAdressImpl(document));
        } else if ("PersonAdress".equals(string)) {
            this.setAdress((SimpleAdressImpl)new PersonAdressImpl(document));
        } else if ("SimpleAdress".equals(string)) {
            this.setAdress(new SimpleAdressImpl(document));
        } else {
            throw new ImmoToolDbException("xml-resource does not contain an adress on root: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Row[] loadRows(Long[] longArray, Long[] longArray2, String string, String string2) throws ImmoToolDbException {
        Collection collection = null;
        try {
            collection = ContactsPluginUtils.openPluginCollection("");
            Row[] rowArray = ContactsEntry.loadRows(longArray, longArray2, string, string2, collection);
            return rowArray;
        }
        finally {
            ImmoToolDbUtils.close((Collection)collection);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Row[] loadRows(Long[] longArray, Long[] longArray2, String string, String string2, Collection collection) throws ImmoToolDbException {
        if (collection == null) {
            throw new ImmoToolDbException("no collection provided!");
        }
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Contacts")) {
                throw new ImmoToolDbException("invalid collection!");
            }
            ArrayList<Row> arrayList = new ArrayList<Row>();
            int n = longArray != null && longArray.length > 0 ? (int)Math.ceil((double)longArray.length / 100.0) : 1;
            for (int i = 0; i < n; ++i) {
                void var11_40;
                void var11_37;
                String string3 = null;
                StringBuilder stringBuilder = new StringBuilder();
                if (longArray2 != null && longArray2.length > 0) {
                    string3 = "xmldb:xcollection";
                    for (Long l : longArray2) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append("'").append("ImmoTool/OpenEstate-Contacts").append("/").append(l).append("'");
                    }
                } else {
                    string3 = "collection";
                    stringBuilder.append("'").append("ImmoTool/OpenEstate-Contacts").append("'");
                }
                String string24 = "declare namespace xmldb=\"http://exist-db.org/xquery/xmldb\";\ndeclare namespace openestate=\"http://www.openestate.org/1.0/\";\ndeclare namespace util=\"http://exist-db.org/xquery/util\";\nfor $x in " + string3 + "(" + stringBuilder.toString() + ")/openestate:CompanyAdress\n";
                string24 = string24 + "let $id := util:document-name($x)\n";
                string24 = string24 + "let $group := util:collection-name($x)\n";
                string24 = string24 + "let $adressStreet := $x/@Street\n";
                string24 = string24 + "let $adressStreetNr := $x/@StreetNr\n";
                string24 = string24 + "let $adressPostalCode := $x/@PostalCode\n";
                string24 = string24 + "let $adressCity := $x/@City\n";
                string24 = string24 + "let $adressCountry := $x/@Country\n";
                string24 = string24 + "let $company := $x/@CompanyName\n";
                string24 = string24 + "let $firstName := $x/@PersonFirstName\n";
                string24 = string24 + "let $lastName := $x/@PersonLastName\n";
                string24 = string24 + "let $lastName_lowercase := lower-case($lastName)\n";
                string24 = string24 + "let $personMail := $x/@PersonMail\n";
                string24 = string24 + "let $personPhone := $x/@PersonPhone\n";
                string24 = string24 + "let $personMobilePhone := $x/@PersonMobilePhone\n";
                string24 = string24 + "let $companyMail := $x/@CompanyMail\n";
                string24 = string24 + "let $companyPhone := $x/@CompanyPhone\n";
                string24 = string24 + "let $companyMobilePhone := $x/@CompanyMobilePhone\n";
                string24 = string24 + "let $status := $x/openestate:CustomValues/openestate:CustomValue[@Key='status']/openestate:String/text()\n";
                string24 = string24 + "let $dayOfBirth := $x/openestate:CustomValues/openestate:CustomValue[@Key='day_of_birth']/openestate:Date/text()\n";
                string24 = string24 + "let $contactAllowed := $x/openestate:CustomValues/openestate:CustomValue[@Key='contact_allowed']/openestate:Boolean/text()\n";
                StringBuilder stringBuilder2 = new StringBuilder();
                if (longArray != null && longArray.length > 0) {
                    StringBuilder stringBuilder3 = new StringBuilder();
                    int n2 = i * 100;
                    if (longArray.length <= n2) break;
                    for (int j = n2; j < n2 + 100 && j < longArray.length; ++j) {
                        if (stringBuilder3.length() > 0) {
                            stringBuilder3.append(" or ");
                        }
                        stringBuilder3.append("$id='contact.").append(longArray[j]).append(".xml'");
                    }
                    stringBuilder2.append("(").append(stringBuilder3.toString()).append(")");
                }
                if (string != null && string.trim().length() > 0) {
                    if (stringBuilder2.length() > 0) {
                        stringBuilder2.append(" and ");
                    }
                    stringBuilder2.append("(").append(string).append(")");
                }
                if (stringBuilder2.length() > 0) {
                    String string25 = string24 + "where (" + stringBuilder2.toString() + ")\n";
                }
                if (string2 != null && string2.trim().length() > 0) {
                    String string26 = (String)var11_37 + "order by " + string2 + "\n";
                } else {
                    String string27 = (String)var11_37 + "order by $lastName_lowercase\n";
                }
                String object = (String)var11_40 + "return <row id=\"{$id}\" group=\"{$group}\" adressStreet=\"{$adressStreet}\" adressStreetNr=\"{$adressStreetNr}\" adressPostalCode=\"{$adressPostalCode}\" adressCity=\"{$adressCity}\" adressCountry=\"{$adressCountry}\" company=\"{$company}\" firstName=\"{$firstName}\" lastName=\"{$lastName}\" personMail=\"{$personMail}\" personPhone=\"{$personPhone}\" personMobilePhone=\"{$personMobilePhone}\" companyMail=\"{$companyMail}\" companyPhone=\"{$companyPhone}\" companyMobilePhone=\"{$companyMobilePhone}\" status=\"{$status}\" dayOfBirth=\"{$dayOfBirth}\" contactAllowed=\"{$contactAllowed}\" />";
                ResourceSet resourceSet = ImmoToolDbUtils.executeXQuery((Collection)collection, (String)object);
                if (resourceSet.getSize() <= 0L) continue;
                for (long j = 0L; j < resourceSet.getSize(); ++j) {
                    Object object2;
                    XMLResource xMLResource = (XMLResource)resourceSet.getResource(j);
                    Node node = xMLResource.getContentAsDOM();
                    Row row = new Row();
                    try {
                        object2 = node.getAttributes().getNamedItem("id").getNodeValue().split("\\.");
                        row.id = object2 != null && ((String[])object2).length > 1 ? Long.valueOf(object2[1]) : 0L;
                    }
                    catch (Exception exception) {
                        LOGGER.warn((Object)"cant load contact-id!");
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                    try {
                        object2 = node.getAttributes().getNamedItem("group").getNodeValue().split("/");
                        row.group = object2 != null && ((String[])object2).length > 0 ? Long.valueOf(object2[((String[])object2).length - 1]) : 0L;
                    }
                    catch (Exception exception) {
                        LOGGER.warn((Object)"cant load contact-group-id!");
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                    row.adressCity = node.getAttributes().getNamedItem("adressCity").getNodeValue().trim();
                    row.adressCountry = node.getAttributes().getNamedItem("adressCountry").getNodeValue().trim();
                    row.adressPostalCode = node.getAttributes().getNamedItem("adressPostalCode").getNodeValue().trim();
                    row.adressStreet = node.getAttributes().getNamedItem("adressStreet").getNodeValue().trim();
                    row.adressStreetNr = node.getAttributes().getNamedItem("adressStreetNr").getNodeValue().trim();
                    row.company = node.getAttributes().getNamedItem("company").getNodeValue().trim();
                    row.firstName = node.getAttributes().getNamedItem("firstName").getNodeValue();
                    row.lastName = node.getAttributes().getNamedItem("lastName").getNodeValue();
                    row.mail = node.getAttributes().getNamedItem("personMail").getNodeValue();
                    if (StringUtils.isBlank((String)row.mail)) {
                        row.mail = node.getAttributes().getNamedItem("companyMail").getNodeValue();
                    }
                    row.phone = node.getAttributes().getNamedItem("personPhone").getNodeValue();
                    if (StringUtils.isBlank((String)row.phone)) {
                        row.phone = node.getAttributes().getNamedItem("companyPhone").getNodeValue();
                    }
                    row.mobilePhone = node.getAttributes().getNamedItem("personMobilePhone").getNodeValue();
                    if (StringUtils.isBlank((String)row.mobilePhone)) {
                        row.mobilePhone = node.getAttributes().getNamedItem("companyMobilePhone").getNodeValue();
                    }
                    row.status = node.getAttributes().getNamedItem(VALUE_STATUS).getNodeValue();
                    if (StringUtils.isBlank((String)row.status)) {
                        row.status = STATUS_ACTIVE;
                    }
                    row.contactAllowed = Boolean.TRUE.toString().equalsIgnoreCase(node.getAttributes().getNamedItem("contactAllowed").getNodeValue());
                    object2 = node.getAttributes().getNamedItem("dayOfBirth").getNodeValue();
                    try {
                        if (object2 != null && ((String)object2).trim().length() > 0) {
                            row.dayOfBirth = DatatypeConverter.parseDate((String)object2).getTime();
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.warn((Object)("Can't parse day of birth: " + (String)object2));
                        LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                    }
                    arrayList.add(row);
                }
            }
            return arrayList.toArray(new Row[arrayList.size()]);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException("could not load contact-entry-rows: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() throws ImmoToolDbException {
        Collection collection = null;
        try {
            if (this.getGroupId() <= 0L) {
                throw new ImmoToolDbException("no group defined!");
            }
            if (this.getId() <= 0L) {
                throw new ImmoToolDbException("no id defined!");
            }
            collection = ContactsPluginUtils.openPluginCollection("/" + String.valueOf(this.getGroupId()));
            this.remove(collection);
        }
        catch (Throwable throwable) {
            ImmoToolDbUtils.close(collection);
            throw throwable;
        }
        ImmoToolDbUtils.close((Collection)collection);
    }

    public void remove(Collection collection) throws ImmoToolDbException {
        try {
            if (this.getGroupId() <= 0L) {
                throw new ImmoToolDbException("no group defined!");
            }
            if (this.getId() <= 0L) {
                throw new ImmoToolDbException("no id defined!");
            }
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Contacts/" + this.getGroupId())) {
                throw new ImmoToolDbException("invalid collection!");
            }
            String string = "contact." + this.id + ".xml";
            if (!ImmoToolDbUtils.hasResource((Collection)collection, (String)string)) {
                throw new ImmoToolDbException("resource '" + string + "' not found!");
            }
            XMLResource xMLResource = ImmoToolDbUtils.loadXMLResource((Collection)collection, (String)string);
            if (xMLResource == null) {
                throw new ImmoToolDbException("could not load resource '" + string + "'!");
            }
            ImmoToolDbUtils.removeResource((Collection)collection, (Resource)xMLResource);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws ImmoToolDbException {
        if (this.getGroupId() <= 0L) {
            throw new ImmoToolDbException("invalid group-id!");
        }
        Collection collection = null;
        try {
            collection = ContactsPluginUtils.openPluginCollection("/" + String.valueOf(this.getGroupId()));
            this.save(collection);
        }
        catch (Throwable throwable) {
            ImmoToolDbUtils.close(collection);
            throw throwable;
        }
        ImmoToolDbUtils.close((Collection)collection);
    }

    public void save(Collection collection) throws ImmoToolDbException {
        this.save(collection, ImmoToolApp.getApplication().getDatabase());
    }

    public void save(Collection collection, ImmoToolDb immoToolDb) throws ImmoToolDbException {
        try {
            if (!collection.getName().endsWith("ImmoTool/OpenEstate-Contacts/" + this.getGroupId())) {
                throw new ImmoToolDbException("invalid collection!");
            }
            if (this.getId() <= 0L) {
                this.setId(immoToolDb.getNextSequence("OpenEstate-Contacts.Contact"));
            }
            if (this.getId() <= 0L) {
                throw new ImmoToolDbException("could not get sequence-value!");
            }
            XMLResource xMLResource = null;
            String string = "contact." + this.getId() + ".xml";
            xMLResource = !ImmoToolDbUtils.hasResource((Collection)collection, (String)string) ? ImmoToolDbUtils.createXmlResource((Collection)collection, (String)string) : ImmoToolDbUtils.loadXMLResource((Collection)collection, (String)string);
            if (xMLResource == null) {
                throw new ImmoToolDbException("could not xml-resource!");
            }
            this.save(xMLResource);
            ImmoToolDbUtils.storeResource((Collection)collection, (Resource)xMLResource);
        }
        catch (ImmoToolDbException immoToolDbException) {
            throw immoToolDbException;
        }
        catch (Exception exception) {
            throw new ImmoToolDbException(exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void save(XMLResource xMLResource) throws IOException, DocumentException, XMLDBException {
        StringWriter stringWriter = new StringWriter();
        OpenEstateUtils.serializeToXML((SerializableXmlElement)this.getAdress(), (Writer)stringWriter, (boolean)true);
        xMLResource.setContent((Object)stringWriter.toString());
    }

    public void setAdress(SimpleAdressImpl simpleAdressImpl) {
        this.adress = simpleAdressImpl;
    }

    public void setAusweisArt(String string) {
        this.getCompanyAdress().getCustomValues().putCustomValue(VALUE_AUSWEIS_ART, (Object)string, 5);
    }

    public void setAusweisBehoerde(String string) {
        this.getCompanyAdress().getCustomValues().putCustomValue(VALUE_AUSWEIS_BEHOERDE, (Object)string, 5);
    }

    public void setAusweisNr(String string) {
        this.getCompanyAdress().getCustomValues().putCustomValue(VALUE_AUSWEIS_NR, (Object)string, 5);
    }

    public void setCitizenship(String string) {
        this.getCompanyAdress().getCustomValues().putCustomValue(VALUE_CITIZENSHIP, (Object)string, 5);
    }

    public void setContactAllowed(boolean bl) {
        this.getCompanyAdress().getCustomValues().putCustomValue(VALUE_CONTACT_ALLOWED, (Object)bl, 0);
    }

    public void setDayOfBirth(Date date) {
        this.getCompanyAdress().getCustomValues().putCustomValue(VALUE_DAY_OF_BIRTH, (Object)date, 1);
    }

    public void setGroupId(long l) {
        this.groupId = l;
    }

    public void setId(long l) {
        this.id = l;
    }

    public void setKontoBic(String string) {
        this.getCompanyAdress().getCustomValues().putCustomValue(VALUE_KONTO_BIC, (Object)string, 5);
    }

    public void setKontoBlz(String string) {
        this.getCompanyAdress().getCustomValues().putCustomValue(VALUE_KONTO_BLZ, (Object)string, 5);
    }

    public void setKontoIban(String string) {
        this.getCompanyAdress().getCustomValues().putCustomValue(VALUE_KONTO_IBAN, (Object)string, 5);
    }

    public void setKontoInhaber(String string) {
        this.getCompanyAdress().getCustomValues().putCustomValue(VALUE_KONTO_INHABER, (Object)string, 5);
    }

    public void setKontoInstitut(String string) {
        this.getCompanyAdress().getCustomValues().putCustomValue(VALUE_KONTO_INSTITUT, (Object)string, 5);
    }

    public void setKontoNr(String string) {
        this.getCompanyAdress().getCustomValues().putCustomValue(VALUE_KONTO_NR, (Object)string, 5);
    }

    public void setPlaceOfBirth(String string) {
        this.getCompanyAdress().getCustomValues().putCustomValue(VALUE_PLACE_OF_BIRTH, (Object)string, 5);
    }

    public void setSprachen(Locale[] localeArray) {
        if (localeArray == null || localeArray.length <= 0) {
            this.getCompanyAdress().getCustomValues().putCustomValue(VALUE_SPRACHEN, null, 5);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (Locale locale : localeArray) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(locale.getLanguage());
            }
            this.getCompanyAdress().getCustomValues().putCustomValue(VALUE_SPRACHEN, (Object)stringBuilder.toString(), 5);
        }
    }

    public void setStatus(String string) {
        this.getCompanyAdress().getCustomValues().putCustomValue(VALUE_STATUS, (Object)string, 5);
    }

    public void setSteuerIdNr(String string) {
        this.getCompanyAdress().getCustomValues().putCustomValue(VALUE_STEUER_IDNR, (Object)string, 5);
    }

    public void setSteuerNr(String string) {
        this.getCompanyAdress().getCustomValues().putCustomValue(VALUE_STEUER_NR, (Object)string, 5);
    }

    public void setSteuerUmsatzIdNr(String string) {
        this.getCompanyAdress().getCustomValues().putCustomValue(VALUE_STEUER_UMSATZ_IDNR, (Object)string, 5);
    }

    public void setText(String string) {
        this.getCompanyAdress().getCustomValues().putCustomValue(VALUE_TEXT, (Object)string, 6);
    }

    public void setWirtschaftIdNr(String string) {
        this.getCompanyAdress().getCustomValues().putCustomValue(VALUE_WIRTSCHAFT_IDNR, (Object)string, 5);
    }

    public String writeStatus() {
        return ContactsEntry.writeStatus(this.getStatus());
    }

    public static String writeStatus(String string) {
        return ImmoToolUtils.getResourceMap(ContactsEntry.class).getString("label.status." + string, new Object[0]);
    }

    public static class Row {
        public long id = 0L;
        public long group = 0L;
        public String company = null;
        public String firstName = null;
        public String lastName = null;
        public String adressStreet = null;
        public String adressStreetNr = null;
        public String adressPostalCode = null;
        public String adressCity = null;
        public String adressCountry = null;
        public String phone = null;
        public String mobilePhone = null;
        public String mail = null;
        public String status = null;
        public Date dayOfBirth = null;
        public boolean contactAllowed = false;

        public String writeAdressLine1() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.adressStreet != null) {
                stringBuilder.append(this.adressStreet.trim());
                if (this.adressStreetNr != null) {
                    stringBuilder.append(" ").append(this.adressStreetNr.trim());
                }
            }
            return stringBuilder.toString();
        }

        public String writeAdressLine2() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.adressPostalCode != null) {
                stringBuilder.append(this.adressPostalCode.trim());
            }
            if (this.adressCity != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(this.adressCity.trim());
            }
            return stringBuilder.toString();
        }

        public String writeAdressLine2WithCountry() {
            if (this.adressCountry != null) {
                return this.adressCountry + "-" + this.writeAdressLine2();
            }
            return this.writeAdressLine2();
        }

        public String writeCountry() {
            String string = SimpleAdressImpl.writeCountry((String)this.adressCountry);
            return string != null && string.trim().length() > 0 ? string : this.adressCountry;
        }

        public String writePerson() {
            String string = "";
            if (this.lastName != null) {
                string = string + this.lastName;
            }
            if (this.firstName != null) {
                if (string.length() > 0) {
                    string = string + ", ";
                }
                string = string + this.firstName;
            }
            return string.trim();
        }

        public String writeToolTip() {
            ResourceMap resourceMap = ImmoToolUtils.getResourceMap(ContactsEntry.class);
            return "<html><div style=\"margin:5px;\"><h2 style=\"margin:0;\">" + resourceMap.getString("label.tooltip.adress", new Object[]{this.id}) + "</h2><hr>" + StringEscapeUtils.escapeHtml((String)this.writePerson()) + (this.company != null && this.company.trim().length() > 0 ? "<br>" + StringEscapeUtils.escapeHtml((String)this.company) : "") + "<hr>" + StringEscapeUtils.escapeHtml((String)this.writeAdressLine1()) + "<br>" + StringEscapeUtils.escapeHtml((String)this.writeAdressLine2()) + "<br>" + this.writeCountry() + "<hr>" + resourceMap.getString("label.tooltip.email", new Object[]{StringEscapeUtils.escapeHtml((String)this.mail)}) + "<br>" + resourceMap.getString("label.tooltip.phone", new Object[]{StringEscapeUtils.escapeHtml((String)this.phone)}) + "</div></html>";
        }
    }
}

