/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolDbException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsGroupItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.nio.charset.Charset;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.apache.commons.lang.SystemUtils;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledSeparator;

public class ContactsEntryExportDialog
extends JDialog {
    public static final int OPENED = 0;
    public static final int CANCELLED = 1;
    public static final int APPROVED = 2;
    private int status = 0;
    private ActionMap actionMap;
    private ResourceMap resourceMap;
    private JButton cancelButton;
    private JComboBox charsetBox;
    private JLabel charsetLabel;
    private JComboBox formatBox;
    private JLabel formatLabel;
    private JComboBox groupBox;
    private JLabel groupLabel;
    private JButton helpButton;
    private JButton submitButton;
    private JXTitledSeparator titleLabel;

    public ContactsEntryExportDialog() {
        this((Frame)ImmoToolApp.getApplication().getMainFrame(), true);
    }

    public ContactsEntryExportDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.build();
        this.setLocationRelativeTo(frame);
    }

    private void build() {
        this.actionMap = ImmoToolUtils.getActionMap(ContactsEntryExportDialog.class, (Object)this);
        this.resourceMap = ImmoToolUtils.getResourceMap(ContactsEntryExportDialog.class);
        this.setContentPane((Container)new JXPanel());
        this.initComponents();
        this.resourceMap.injectComponents((Component)this);
        this.formatBox.setModel(new DefaultComboBoxModel());
        this.formatBox.addItem(this.resourceMap.getString("label.format.csv", new Object[0]));
        this.formatBox.addItem(this.resourceMap.getString("label.format.xls", new Object[0]));
        this.formatBox.addItem(this.resourceMap.getString("label.format.vcard", new Object[0]));
        this.charsetBox.setModel(new DefaultComboBoxModel());
        this.charsetBox.setSelectedIndex(-1);
        for (Charset charset : Charset.availableCharsets().values()) {
            ((DefaultComboBoxModel)this.charsetBox.getModel()).addElement(charset);
            if (!Charset.defaultCharset().equals(charset)) continue;
            this.charsetBox.setSelectedIndex(this.charsetBox.getModel().getSize() - 1);
        }
        this.cancelButton.setAction(this.actionMap.get(this.cancelButton.getText()));
        this.submitButton.setAction(this.actionMap.get(this.submitButton.getText()));
        this.helpButton.setAction(this.actionMap.get(this.helpButton.getText()));
        this.helpButton.setEnabled(false);
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.cancelButton.setOpaque(false);
            this.submitButton.setOpaque(false);
            this.helpButton.setOpaque(false);
        }
        this.groupBox.setModel(new DefaultComboBoxModel());
        ImmoToolUtils.configureDialog((JDialog)this, (JXPanel)((JXPanel)this.getContentPane()));
    }

    @Action
    public void doCancel() {
        this.status = 1;
        this.setVisible(false);
    }

    @Action
    public void doHelp() {
    }

    @Action
    public void doSubmit() {
        this.status = 2;
        this.setVisible(false);
    }

    public Charset getSelectedCharset() {
        return (Charset)this.charsetBox.getSelectedItem();
    }

    public Long getSelectedContactGroup() {
        if (this.groupBox.getSelectedIndex() <= 0) {
            return null;
        }
        return ((ContactsGroupItem)this.groupBox.getSelectedItem()).getGroupId();
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isCsvSelected() {
        return this.formatBox.getSelectedIndex() == 0;
    }

    public boolean isVCardSelected() {
        return this.formatBox.getSelectedIndex() == 2;
    }

    public boolean isXlsSelected() {
        return this.formatBox.getSelectedIndex() == 1;
    }

    public void loadContactGroups() throws ImmoToolDbException {
        ((DefaultComboBoxModel)this.groupBox.getModel()).removeAllElements();
        ((DefaultComboBoxModel)this.groupBox.getModel()).addElement("[ " + this.resourceMap.getString("label.group.all", new Object[0]) + " ]");
        ContactsGroupItem.load(this.groupBox);
    }

    public void setGroupSelectionVisible(boolean bl) {
        this.groupBox.setVisible(bl);
        this.groupLabel.setVisible(bl);
    }

    private void initComponents() {
        this.titleLabel = ImmoToolUtils.createHead1Separator((String)"");
        this.charsetLabel = new JLabel();
        this.charsetBox = new JComboBox();
        this.formatLabel = new JLabel();
        this.formatBox = new JComboBox();
        this.groupLabel = new JLabel();
        this.groupBox = new JComboBox();
        this.helpButton = new JButton();
        this.submitButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.titleLabel.setName("titleLabel");
        this.titleLabel.setTitle("titleLabel");
        this.charsetLabel.setHorizontalAlignment(4);
        this.charsetLabel.setText("charset:");
        this.charsetLabel.setName("charsetLabel");
        this.charsetBox.setName("charsetBox");
        this.formatLabel.setHorizontalAlignment(4);
        this.formatLabel.setText("format:");
        this.formatLabel.setName("formatLabel");
        this.formatBox.setName("formatBox");
        this.groupLabel.setHorizontalAlignment(4);
        this.groupLabel.setText("group:");
        this.groupLabel.setName("groupLabel");
        this.groupBox.setName("groupBox");
        this.helpButton.setText("doHelp");
        this.helpButton.setName("helpButton");
        this.submitButton.setText("doSubmit");
        this.submitButton.setName("submitButton");
        this.cancelButton.setText("doCancel");
        this.cancelButton.setName("cancelButton");
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.titleLabel, -1, 457, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 167, Short.MAX_VALUE).addComponent(this.submitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.groupLabel, GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.formatLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.charsetLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.groupBox, 0, 386, Short.MAX_VALUE).addComponent(this.formatBox, 0, 386, Short.MAX_VALUE).addComponent(this.charsetBox, 0, 386, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.titleLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.charsetLabel).addComponent(this.charsetBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.formatLabel).addComponent(this.formatBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.groupLabel).addComponent(this.groupBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 144, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.helpButton).addComponent(this.cancelButton).addComponent(this.submitButton)).addContainerGap()));
        this.pack();
    }
}

