/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsEntry;
import com.openindex.openestate.tool.contacts.ContactsGroup;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.Property;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.VCardOutputter;
import net.fortuna.ical4j.vcard.parameter.Encoding;
import net.fortuna.ical4j.vcard.parameter.Type;
import net.fortuna.ical4j.vcard.property.Address;
import net.fortuna.ical4j.vcard.property.BDay;
import net.fortuna.ical4j.vcard.property.Email;
import net.fortuna.ical4j.vcard.property.Fn;
import net.fortuna.ical4j.vcard.property.Gender;
import net.fortuna.ical4j.vcard.property.Geo;
import net.fortuna.ical4j.vcard.property.Lang;
import net.fortuna.ical4j.vcard.property.N;
import net.fortuna.ical4j.vcard.property.Name;
import net.fortuna.ical4j.vcard.property.Note;
import net.fortuna.ical4j.vcard.property.Org;
import net.fortuna.ical4j.vcard.property.Role;
import net.fortuna.ical4j.vcard.property.Telephone;
import net.fortuna.ical4j.vcard.property.Title;
import net.fortuna.ical4j.vcard.property.Url;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;

public class ContactsEntryExportVcardTask
extends ImmoToolTask<Long> {
    private static final Logger LOGGER = Logger.getLogger(ContactsEntryExportVcardTask.class);
    private File exportFile = null;
    private Charset exportCharset = null;
    private Long exportGroupId = null;
    private ResourceMap resourceMap;

    public ContactsEntryExportVcardTask(File file, Charset charset) {
        this(file, charset, null);
    }

    public ContactsEntryExportVcardTask(File file, Charset charset, Long l) {
        this.exportFile = file;
        this.exportCharset = charset;
        this.exportGroupId = l;
        this.resourceMap = ImmoToolUtils.getResourceMap(ContactsEntryExportVcardTask.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long executeTask() throws Exception {
        long l = 0L;
        OutputStream outputStream = null;
        Writer writer = null;
        try {
            VCardOutputter vCardOutputter = new VCardOutputter();
            vCardOutputter.setValidating(false);
            for (ContactsEntry contactsEntry : this.loadContacts()) {
                outputStream = new FileOutputStream(this.exportFile, l > 0L);
                writer = new OutputStreamWriter(outputStream, this.exportCharset);
                VCard vCard = new VCard();
                this.writeContactToVcard(contactsEntry, vCard);
                vCardOutputter.output(vCard, writer);
                ++l;
            }
            Long l2 = l;
            return l2;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    protected ContactsEntry[] loadContacts() throws ImmoToolException {
        this.setMessage(this.resourceMap.getString("message.doLoadAdresses", new Object[0]));
        if (this.exportGroupId != null) {
            ContactsGroup contactsGroup = ContactsGroup.load(this.exportGroupId);
            if (contactsGroup == null) {
                throw new ImmoToolException("adress-group #" + this.exportGroupId + " not found!");
            }
            return contactsGroup.listEntries();
        }
        ArrayList<ContactsEntry> arrayList = new ArrayList<ContactsEntry>();
        for (ContactsGroup contactsGroup : ContactsGroup.loadGroups()) {
            arrayList.addAll(Arrays.asList(contactsGroup.listEntries()));
        }
        return arrayList.toArray(new ContactsEntry[arrayList.size()]);
    }

    protected void writeContactToVcard(ContactsEntry contactsEntry, VCard vCard) {
        URL uRL;
        Object object;
        String string;
        Locale[] localeArray;
        String string2 = null;
        String string3 = null;
        String string4 = contactsEntry.getAdress().writeStreet();
        String string5 = contactsEntry.getAdress().getCity() + " " + contactsEntry.getAdress().getCityPart();
        String string6 = contactsEntry.getAdress().getRegion();
        String string7 = contactsEntry.getAdress().getPostalCode();
        String string8 = contactsEntry.getAdress().getCountry();
        vCard.getProperties().add(this.writePropertyParams((Property)new Address(string2 != null ? string2.trim() : "", string3 != null ? string3.trim() : "", string4 != null ? string4.trim() : "", string5 != null ? string5.trim() : "", string6 != null ? string6.trim() : "", string7 != null ? string7.trim() : "", string8 != null ? string8.trim() : "", new Type[0])));
        java.util.Date date = contactsEntry.getDayOfBirth();
        if (date != null) {
            vCard.getProperties().add(this.writePropertyParams((Property)new BDay(new Date(date))));
        }
        String string9 = contactsEntry.getPersonAdress().getPersonMail();
        String string10 = contactsEntry.getCompanyAdress().getCompanyMail();
        if (string9 != null && string9.trim().length() > 0) {
            vCard.getProperties().add(this.writePropertyParams((Property)new Email(Group.HOME, string9)));
        }
        if (string10 != null && string10.trim().length() > 0) {
            vCard.getProperties().add(this.writePropertyParams((Property)new Email(Group.WORK, string10)));
        }
        vCard.getProperties().add(this.writePropertyParams((Property)new Fn(contactsEntry.getPersonAdress().writePersonFullName())));
        if (contactsEntry.getPersonAdress().isFemale()) {
            vCard.getProperties().add(Gender.FEMALE);
        } else if (contactsEntry.getPersonAdress().isMale()) {
            vCard.getProperties().add(Gender.MALE);
        }
        if (contactsEntry.getAdress().getLatitude() != null && contactsEntry.getAdress().getLongitude() != null) {
            vCard.getProperties().add(this.writePropertyParams((Property)new Geo(BigDecimal.valueOf(contactsEntry.getAdress().getLatitude()), BigDecimal.valueOf(contactsEntry.getAdress().getLongitude()))));
        }
        if ((localeArray = contactsEntry.getSprachen()) != null && localeArray.length > 0) {
            vCard.getProperties().add(this.writePropertyParams((Property)new Lang(localeArray)));
        }
        String string11 = contactsEntry.getPersonAdress().getPersonLastName();
        String string12 = contactsEntry.getPersonAdress().getPersonFirstName() + " " + contactsEntry.getPersonAdress().getPersonMiddleName();
        String[] stringArray = null;
        String[] stringArray2 = new String[]{};
        String[] stringArray3 = new String[]{};
        vCard.getProperties().add(this.writePropertyParams((Property)new N(string11 != null ? string11.trim() : "", string12 != null ? string12.trim() : "", stringArray != null ? stringArray : new String[]{}, stringArray2 != null ? stringArray2 : new String[]{}, stringArray3 != null ? stringArray3 : new String[]{})));
        vCard.getProperties().add(this.writePropertyParams((Property)new Name(contactsEntry.getPersonAdress().writePersonFullName())));
        String string13 = contactsEntry.getText();
        if (string13 != null && string13.trim().length() > 0) {
            vCard.getProperties().add(this.writePropertyParams((Property)new Note(string13.trim())));
        }
        String string14 = contactsEntry.getCompanyAdress().getCompanyName();
        String string15 = contactsEntry.getCompanyAdress().getCompanyNameAddition();
        vCard.getProperties().add(this.writePropertyParams((Property)new Org(Group.WORK, new String[]{string14 != null ? string14 : "", string15 != null ? string15 : ""})));
        String string16 = contactsEntry.getCompanyAdress().getCompanyPosition();
        if (string16 != null && string16.trim().length() > 0) {
            vCard.getProperties().add(this.writePropertyParams((Property)new Role(string16.trim())));
        }
        if ((string = contactsEntry.getPersonAdress().getPersonPhone()) != null && string.trim().length() > 0) {
            try {
                object = new Telephone(Group.HOME, new ArrayList(), string);
                object.getParameters().add(Type.PREF);
                vCard.getProperties().add(this.writePropertyParams((Property)object));
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"Can't write phone-nr");
                LOGGER.warn((Object)("> " + string));
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        if ((string = contactsEntry.getPersonAdress().getPersonMobilePhone()) != null && string.trim().length() > 0) {
            try {
                object = new Telephone(Group.HOME, new ArrayList(), string);
                object.getParameters().add(new Type("CELL"));
                vCard.getProperties().add(this.writePropertyParams((Property)object));
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"Can't write phone-nr");
                LOGGER.warn((Object)("> " + string));
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        if ((string = contactsEntry.getPersonAdress().getPersonFax()) != null && string.trim().length() > 0) {
            try {
                object = new Telephone(Group.HOME, new ArrayList(), string);
                object.getParameters().add(new Type("FAX"));
                vCard.getProperties().add(this.writePropertyParams((Property)object));
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"Can't write phone-nr");
                LOGGER.warn((Object)("> " + string));
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        if ((string = contactsEntry.getCompanyAdress().getCompanyPhone()) != null && string.trim().length() > 0) {
            try {
                object = new Telephone(Group.WORK, new ArrayList(), string);
                object.getParameters().add(Type.PREF);
                vCard.getProperties().add(this.writePropertyParams((Property)object));
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"Can't write phone-nr");
                LOGGER.warn((Object)("> " + string));
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        if ((string = contactsEntry.getCompanyAdress().getCompanyMobilePhone()) != null && string.trim().length() > 0) {
            try {
                object = new Telephone(Group.WORK, new ArrayList(), string);
                object.getParameters().add(new Type("CELL"));
                vCard.getProperties().add(this.writePropertyParams((Property)object));
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"Can't write phone-nr");
                LOGGER.warn((Object)("> " + string));
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        if ((string = contactsEntry.getCompanyAdress().getCompanyFax()) != null && string.trim().length() > 0) {
            try {
                object = new Telephone(Group.WORK, new ArrayList(), string);
                object.getParameters().add(new Type("FAX"));
                vCard.getProperties().add(this.writePropertyParams((Property)object));
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"Can't write phone-nr");
                LOGGER.warn((Object)("> " + string));
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
        if ((object = contactsEntry.getPersonAdress().getPersonTitle()) != null && ((String)object).trim().length() > 0) {
            vCard.getProperties().add(this.writePropertyParams((Property)new Title(((String)object).trim())));
        }
        if ((uRL = contactsEntry.getCompanyAdress().getCompanyWebsite()) != null && uRL.getHost() != null && uRL.getHost().toString().length() > 0) {
            try {
                vCard.getProperties().add(this.writePropertyParams((Property)new Url(uRL.toURI())));
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"Can't write URL!");
                LOGGER.warn((Object)("> " + uRL.toString()));
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
    }

    private Property writePropertyParams(Property property) {
        property.getParameters().add(new Encoding(this.exportCharset.name()));
        return property;
    }
}

