/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsEntry;
import com.openindex.openestate.tool.contacts.ContactsEntryExportFields;
import com.openindex.openestate.tool.contacts.ContactsGroup;
import com.openindex.openestate.tool.utils.XlsExportTask;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.application.ResourceMap;

public class ContactsEntryExportXlsTask
extends XlsExportTask<ContactsEntry>
implements ContactsEntryExportFields {
    private Long exportGroupId;
    private ResourceMap resourceMap;
    private Map<Long, String> groupNames;

    public ContactsEntryExportXlsTask(File file, Charset charset) {
        this(file, charset, null);
    }

    public ContactsEntryExportXlsTask(File file, Charset charset, Long l) {
        super(file, charset, ImmoToolUtils.getResourceMap(ContactsEntryExportXlsTask.class).getString("sheetTitle", new Object[0]));
        this.exportGroupId = l;
        this.resourceMap = ImmoToolUtils.getResourceMap(ContactsEntryExportXlsTask.class);
        this.groupNames = new HashMap<Long, String>();
        this.setTitle(this.resourceMap.getString("title", new Object[0]));
    }

    protected String getFieldTitle(int n) {
        switch (n) {
            case 0: {
                return this.resourceMap.getString("field.id", new Object[0]);
            }
            case 1: {
                return this.resourceMap.getString("field.group", new Object[0]);
            }
            case 2: {
                return this.resourceMap.getString("field.status", new Object[0]);
            }
            case 3: {
                return this.resourceMap.getString("field.contactAllowed", new Object[0]);
            }
            case 7: {
                return this.resourceMap.getString("field.adress.city", new Object[0]);
            }
            case 8: {
                return this.resourceMap.getString("field.adress.cityPart", new Object[0]);
            }
            case 9: {
                return this.resourceMap.getString("field.adress.country", new Object[0]);
            }
            case 11: {
                return this.resourceMap.getString("field.adress.latitude", new Object[0]);
            }
            case 12: {
                return this.resourceMap.getString("field.adress.longitude", new Object[0]);
            }
            case 6: {
                return this.resourceMap.getString("field.adress.postalCode", new Object[0]);
            }
            case 10: {
                return this.resourceMap.getString("field.adress.region", new Object[0]);
            }
            case 4: {
                return this.resourceMap.getString("field.adress.street", new Object[0]);
            }
            case 5: {
                return this.resourceMap.getString("field.adress.streetNr", new Object[0]);
            }
            case 21: {
                return this.resourceMap.getString("field.person.fax", new Object[0]);
            }
            case 15: {
                return this.resourceMap.getString("field.person.firstName", new Object[0]);
            }
            case 16: {
                return this.resourceMap.getString("field.person.gender", new Object[0]);
            }
            case 13: {
                return this.resourceMap.getString("field.person.lastName", new Object[0]);
            }
            case 18: {
                return this.resourceMap.getString("field.person.mail", new Object[0]);
            }
            case 14: {
                return this.resourceMap.getString("field.person.middleName", new Object[0]);
            }
            case 20: {
                return this.resourceMap.getString("field.person.mobilePhone", new Object[0]);
            }
            case 19: {
                return this.resourceMap.getString("field.person.phone", new Object[0]);
            }
            case 17: {
                return this.resourceMap.getString("field.person.title", new Object[0]);
            }
            case 32: {
                return this.resourceMap.getString("field.company.business", new Object[0]);
            }
            case 25: {
                return this.resourceMap.getString("field.company.department", new Object[0]);
            }
            case 30: {
                return this.resourceMap.getString("field.company.fax", new Object[0]);
            }
            case 27: {
                return this.resourceMap.getString("field.company.mail", new Object[0]);
            }
            case 29: {
                return this.resourceMap.getString("field.company.mobilePhone", new Object[0]);
            }
            case 22: {
                return this.resourceMap.getString("field.company.name", new Object[0]);
            }
            case 23: {
                return this.resourceMap.getString("field.company.nameAddition", new Object[0]);
            }
            case 28: {
                return this.resourceMap.getString("field.company.phone", new Object[0]);
            }
            case 26: {
                return this.resourceMap.getString("field.company.position", new Object[0]);
            }
            case 24: {
                return this.resourceMap.getString("field.company.type", new Object[0]);
            }
            case 31: {
                return this.resourceMap.getString("field.company.website", new Object[0]);
            }
            case 33: {
                return this.resourceMap.getString("field.details.dayOfBirth", new Object[0]);
            }
            case 34: {
                return this.resourceMap.getString("field.details.placeOfBirth", new Object[0]);
            }
            case 35: {
                return this.resourceMap.getString("field.details.citizenship", new Object[0]);
            }
            case 36: {
                return this.resourceMap.getString("field.details.sprachen", new Object[0]);
            }
            case 37: {
                return this.resourceMap.getString("field.details.kontoInhaber", new Object[0]);
            }
            case 38: {
                return this.resourceMap.getString("field.details.kontoInstitut", new Object[0]);
            }
            case 39: {
                return this.resourceMap.getString("field.details.kontoNr", new Object[0]);
            }
            case 40: {
                return this.resourceMap.getString("field.details.kontoBlz", new Object[0]);
            }
            case 41: {
                return this.resourceMap.getString("field.details.kontoIban", new Object[0]);
            }
            case 42: {
                return this.resourceMap.getString("field.details.kontoBic", new Object[0]);
            }
            case 43: {
                return this.resourceMap.getString("field.details.steuerNr", new Object[0]);
            }
            case 44: {
                return this.resourceMap.getString("field.details.steuerIdNr", new Object[0]);
            }
            case 45: {
                return this.resourceMap.getString("field.details.steuerUstId", new Object[0]);
            }
            case 46: {
                return this.resourceMap.getString("field.details.wirtschaftIdNr", new Object[0]);
            }
            case 47: {
                return this.resourceMap.getString("field.details.ausweisNr", new Object[0]);
            }
            case 48: {
                return this.resourceMap.getString("field.details.ausweisArt", new Object[0]);
            }
            case 49: {
                return this.resourceMap.getString("field.details.ausweisBehoerde", new Object[0]);
            }
            case 50: {
                return this.resourceMap.getString("field.notes", new Object[0]);
            }
        }
        return null;
    }

    protected int getHeadlineRowspan() {
        return 2;
    }

    protected String[] getHeadlineValues(int n) {
        if (n == 0) {
            String[] stringArray = this.loadEmptyContainer();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i == 4) {
                    stringArray[i] = this.resourceMap.getString("header.adress", new Object[0]);
                    continue;
                }
                if (i == 13) {
                    stringArray[i] = this.resourceMap.getString("header.person", new Object[0]);
                    continue;
                }
                if (i == 22) {
                    stringArray[i] = this.resourceMap.getString("header.company", new Object[0]);
                    continue;
                }
                if (i != 33) continue;
                stringArray[i] = this.resourceMap.getString("header.details", new Object[0]);
            }
            return stringArray;
        }
        if (n == 1) {
            return super.getHeadlineValues(n);
        }
        return null;
    }

    protected String[] loadEmptyContainer() {
        return new String[51];
    }

    protected ContactsEntry[] loadXlsObjects() throws ImmoToolException {
        this.setMessage(this.resourceMap.getString("message.doLoadAdresses", new Object[0]));
        this.groupNames.clear();
        if (this.exportGroupId != null) {
            ContactsGroup contactsGroup = ContactsGroup.load(this.exportGroupId);
            if (contactsGroup == null) {
                throw new ImmoToolException("adress-group #" + this.exportGroupId + " not found!");
            }
            this.groupNames.put(contactsGroup.getId(), contactsGroup.getName());
            return contactsGroup.listEntries();
        }
        ArrayList<ContactsEntry> arrayList = new ArrayList<ContactsEntry>();
        for (ContactsGroup contactsGroup : ContactsGroup.loadGroups()) {
            this.groupNames.put(contactsGroup.getId(), contactsGroup.getName());
            arrayList.addAll(Arrays.asList(contactsGroup.listEntries()));
        }
        return arrayList.toArray(new ContactsEntry[arrayList.size()]);
    }

    protected void writeValues(ContactsEntry contactsEntry, String[] stringArray) {
        long l;
        this.writeValue(0, String.valueOf(contactsEntry.getId()), stringArray);
        this.writeValue(2, contactsEntry.writeStatus(), stringArray);
        this.writeValue(3, String.valueOf(contactsEntry.isContactAllowed()), stringArray);
        this.writeValue(7, contactsEntry.getAdress().getCity(), stringArray);
        this.writeValue(8, contactsEntry.getAdress().getCityPart(), stringArray);
        this.writeValue(9, contactsEntry.getAdress().getCountry(), stringArray);
        this.writeValue(6, contactsEntry.getAdress().getPostalCode(), stringArray);
        this.writeValue(10, contactsEntry.getAdress().getRegion(), stringArray);
        this.writeValue(4, contactsEntry.getAdress().getStreet(), stringArray);
        this.writeValue(5, contactsEntry.getAdress().getStreetNr(), stringArray);
        this.writeValue(21, contactsEntry.getPersonAdress().getPersonFax(), stringArray);
        this.writeValue(15, contactsEntry.getPersonAdress().getPersonFirstName(), stringArray);
        this.writeValue(16, contactsEntry.getPersonAdress().getPersonGender(), stringArray);
        this.writeValue(13, contactsEntry.getPersonAdress().getPersonLastName(), stringArray);
        this.writeValue(18, contactsEntry.getPersonAdress().getPersonMail(), stringArray);
        this.writeValue(14, contactsEntry.getPersonAdress().getPersonMiddleName(), stringArray);
        this.writeValue(20, contactsEntry.getPersonAdress().getPersonMobilePhone(), stringArray);
        this.writeValue(19, contactsEntry.getPersonAdress().getPersonPhone(), stringArray);
        this.writeValue(17, contactsEntry.getPersonAdress().getPersonTitle(), stringArray);
        this.writeValue(32, contactsEntry.getCompanyAdress().getCompanyBusiness(), stringArray);
        this.writeValue(25, contactsEntry.getCompanyAdress().getCompanyDepartment(), stringArray);
        this.writeValue(30, contactsEntry.getCompanyAdress().getCompanyFax(), stringArray);
        this.writeValue(27, contactsEntry.getCompanyAdress().getCompanyMail(), stringArray);
        this.writeValue(29, contactsEntry.getCompanyAdress().getCompanyMobilePhone(), stringArray);
        this.writeValue(22, contactsEntry.getCompanyAdress().getCompanyName(), stringArray);
        this.writeValue(23, contactsEntry.getCompanyAdress().getCompanyNameAddition(), stringArray);
        this.writeValue(28, contactsEntry.getCompanyAdress().getCompanyPhone(), stringArray);
        this.writeValue(26, contactsEntry.getCompanyAdress().getCompanyPosition(), stringArray);
        this.writeValue(24, contactsEntry.getCompanyAdress().getCompanyType(), stringArray);
        this.writeValue(48, contactsEntry.getAusweisArt(), stringArray);
        this.writeValue(49, contactsEntry.getAusweisBehoerde(), stringArray);
        this.writeValue(47, contactsEntry.getAusweisNr(), stringArray);
        this.writeValue(35, contactsEntry.getCitizenship(), stringArray);
        this.writeValue(42, contactsEntry.getKontoBic(), stringArray);
        this.writeValue(40, contactsEntry.getKontoBlz(), stringArray);
        this.writeValue(41, contactsEntry.getKontoIban(), stringArray);
        this.writeValue(37, contactsEntry.getKontoInhaber(), stringArray);
        this.writeValue(38, contactsEntry.getKontoInstitut(), stringArray);
        this.writeValue(39, contactsEntry.getKontoNr(), stringArray);
        this.writeValue(34, contactsEntry.getPlaceOfBirth(), stringArray);
        this.writeValue(44, contactsEntry.getSteuerIdNr(), stringArray);
        this.writeValue(43, contactsEntry.getSteuerNr(), stringArray);
        this.writeValue(45, contactsEntry.getSteuerUmsatzIdNr(), stringArray);
        this.writeValue(46, contactsEntry.getWirtschaftIdNr(), stringArray);
        Double d = contactsEntry.getAdress().getLatitude();
        this.writeValue(11, d != null ? d.toString() : null, stringArray);
        Double d2 = contactsEntry.getAdress().getLongitude();
        this.writeValue(12, d2 != null ? d2.toString() : null, stringArray);
        URL uRL = contactsEntry.getCompanyAdress().getCompanyWebsite();
        this.writeValue(31, uRL != null ? uRL.toString() : null, stringArray);
        Date date = contactsEntry.getDayOfBirth();
        this.writeValue(33, date != null ? DateFormat.getDateInstance().format(date) : null, stringArray);
        Object[] objectArray = contactsEntry.getSprachen();
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object object : objectArray) {
                arrayList.add(((Locale)object).getLanguage());
            }
            this.writeValue(36, StringUtils.join(arrayList, (String)", "), stringArray);
        }
        this.writeValue(1, (l = contactsEntry.getGroupId()) > 0L && this.groupNames.containsKey(l) ? this.groupNames.get(l) : "", stringArray);
        String string = contactsEntry.getText();
        this.writeValue(50, !StringUtils.isBlank((String)string) ? string.trim() : "", stringArray);
    }
}

