/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsEntry;
import com.openindex.openestate.tool.contacts.ContactsEntryImportFields;
import com.openindex.openestate.tool.contacts.ContactsGroup;
import com.openindex.openestate.tool.utils.CsvImportTask;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;

public class ContactsEntryImportCsvTask
extends CsvImportTask<ContactsEntry>
implements ContactsEntryImportFields {
    private static final Logger LOGGER = Logger.getLogger(ContactsEntryImportCsvTask.class);
    private final ResourceMap resourceMap = ImmoToolUtils.getResourceMap(ContactsEntryImportCsvTask.class);
    private ContactsGroup importGroup = null;
    private Date importDate = null;

    public ContactsEntryImportCsvTask(File file) {
        super(file);
        this.setTitle(this.resourceMap.getString("title", new Object[0]));
    }

    protected ContactsEntry createCsvObject() {
        return new ContactsEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long executeImport() throws ImmoToolException, IOException {
        ContactsEntryImportCsvTask contactsEntryImportCsvTask = this;
        synchronized (contactsEntryImportCsvTask) {
            this.importDate = new Date();
            this.importGroup = null;
        }
        return super.executeImport();
    }

    private static DateFormat getDateFormat() {
        return DateFormat.getDateTimeInstance(2, 3);
    }

    protected int getDefinedFieldCount() {
        return 47;
    }

    protected final String getFieldTitle(int n) {
        switch (n) {
            case 3: {
                return this.resourceMap.getString("label.prefix.address", new Object[0]) + ", " + this.resourceMap.getString("field.adress.city", new Object[0]);
            }
            case 4: {
                return this.resourceMap.getString("label.prefix.address", new Object[0]) + ", " + this.resourceMap.getString("field.adress.cityPart", new Object[0]);
            }
            case 5: {
                return this.resourceMap.getString("label.prefix.address", new Object[0]) + ", " + this.resourceMap.getString("field.adress.country", new Object[0]);
            }
            case 7: {
                return this.resourceMap.getString("label.prefix.address", new Object[0]) + ", " + this.resourceMap.getString("field.adress.latitude", new Object[0]);
            }
            case 8: {
                return this.resourceMap.getString("label.prefix.address", new Object[0]) + ", " + this.resourceMap.getString("field.adress.longitude", new Object[0]);
            }
            case 2: {
                return this.resourceMap.getString("label.prefix.address", new Object[0]) + ", " + this.resourceMap.getString("field.adress.postalCode", new Object[0]);
            }
            case 6: {
                return this.resourceMap.getString("label.prefix.address", new Object[0]) + ", " + this.resourceMap.getString("field.adress.region", new Object[0]);
            }
            case 0: {
                return this.resourceMap.getString("label.prefix.address", new Object[0]) + ", " + this.resourceMap.getString("field.adress.street", new Object[0]);
            }
            case 1: {
                return this.resourceMap.getString("label.prefix.address", new Object[0]) + ", " + this.resourceMap.getString("field.adress.streetNr", new Object[0]);
            }
            case 17: {
                return this.resourceMap.getString("label.prefix.person", new Object[0]) + ", " + this.resourceMap.getString("field.person.fax", new Object[0]);
            }
            case 11: {
                return this.resourceMap.getString("label.prefix.person", new Object[0]) + ", " + this.resourceMap.getString("field.person.firstName", new Object[0]);
            }
            case 12: {
                return this.resourceMap.getString("label.prefix.person", new Object[0]) + ", " + this.resourceMap.getString("field.person.gender", new Object[0]);
            }
            case 9: {
                return this.resourceMap.getString("label.prefix.person", new Object[0]) + ", " + this.resourceMap.getString("field.person.lastName", new Object[0]);
            }
            case 14: {
                return this.resourceMap.getString("label.prefix.person", new Object[0]) + ", " + this.resourceMap.getString("field.person.mail", new Object[0]);
            }
            case 10: {
                return this.resourceMap.getString("label.prefix.person", new Object[0]) + ", " + this.resourceMap.getString("field.person.middleName", new Object[0]);
            }
            case 16: {
                return this.resourceMap.getString("label.prefix.person", new Object[0]) + ", " + this.resourceMap.getString("field.person.mobilePhone", new Object[0]);
            }
            case 15: {
                return this.resourceMap.getString("label.prefix.person", new Object[0]) + ", " + this.resourceMap.getString("field.person.phone", new Object[0]);
            }
            case 13: {
                return this.resourceMap.getString("label.prefix.person", new Object[0]) + ", " + this.resourceMap.getString("field.person.title", new Object[0]);
            }
            case 28: {
                return this.resourceMap.getString("label.prefix.company", new Object[0]) + ", " + this.resourceMap.getString("field.company.business", new Object[0]);
            }
            case 21: {
                return this.resourceMap.getString("label.prefix.company", new Object[0]) + ", " + this.resourceMap.getString("field.company.department", new Object[0]);
            }
            case 26: {
                return this.resourceMap.getString("label.prefix.company", new Object[0]) + ", " + this.resourceMap.getString("field.company.fax", new Object[0]);
            }
            case 23: {
                return this.resourceMap.getString("label.prefix.company", new Object[0]) + ", " + this.resourceMap.getString("field.company.mail", new Object[0]);
            }
            case 25: {
                return this.resourceMap.getString("label.prefix.company", new Object[0]) + ", " + this.resourceMap.getString("field.company.mobilePhone", new Object[0]);
            }
            case 18: {
                return this.resourceMap.getString("label.prefix.company", new Object[0]) + ", " + this.resourceMap.getString("field.company.name", new Object[0]);
            }
            case 19: {
                return this.resourceMap.getString("label.prefix.company", new Object[0]) + ", " + this.resourceMap.getString("field.company.nameAddition", new Object[0]);
            }
            case 24: {
                return this.resourceMap.getString("label.prefix.company", new Object[0]) + ", " + this.resourceMap.getString("field.company.phone", new Object[0]);
            }
            case 22: {
                return this.resourceMap.getString("label.prefix.company", new Object[0]) + ", " + this.resourceMap.getString("field.company.position", new Object[0]);
            }
            case 20: {
                return this.resourceMap.getString("label.prefix.company", new Object[0]) + ", " + this.resourceMap.getString("field.company.type", new Object[0]);
            }
            case 27: {
                return this.resourceMap.getString("label.prefix.company", new Object[0]) + ", " + this.resourceMap.getString("field.company.website", new Object[0]);
            }
            case 29: {
                return this.resourceMap.getString("label.prefix.details", new Object[0]) + ", " + this.resourceMap.getString("field.details.dayOfBirth", new Object[0]);
            }
            case 30: {
                return this.resourceMap.getString("label.prefix.details", new Object[0]) + ", " + this.resourceMap.getString("field.details.placeOfBirth", new Object[0]);
            }
            case 31: {
                return this.resourceMap.getString("label.prefix.details", new Object[0]) + ", " + this.resourceMap.getString("field.details.citizenship", new Object[0]);
            }
            case 32: {
                return this.resourceMap.getString("label.prefix.details", new Object[0]) + ", " + this.resourceMap.getString("field.details.sprachen", new Object[0]);
            }
            case 33: {
                return this.resourceMap.getString("label.prefix.details", new Object[0]) + ", " + this.resourceMap.getString("field.details.kontoInhaber", new Object[0]);
            }
            case 34: {
                return this.resourceMap.getString("label.prefix.details", new Object[0]) + ", " + this.resourceMap.getString("field.details.kontoInstitut", new Object[0]);
            }
            case 35: {
                return this.resourceMap.getString("label.prefix.details", new Object[0]) + ", " + this.resourceMap.getString("field.details.kontoNr", new Object[0]);
            }
            case 36: {
                return this.resourceMap.getString("label.prefix.details", new Object[0]) + ", " + this.resourceMap.getString("field.details.kontoBlz", new Object[0]);
            }
            case 37: {
                return this.resourceMap.getString("label.prefix.details", new Object[0]) + ", " + this.resourceMap.getString("field.details.kontoIban", new Object[0]);
            }
            case 38: {
                return this.resourceMap.getString("label.prefix.details", new Object[0]) + ", " + this.resourceMap.getString("field.details.kontoBic", new Object[0]);
            }
            case 39: {
                return this.resourceMap.getString("label.prefix.details", new Object[0]) + ", " + this.resourceMap.getString("field.details.steuerNr", new Object[0]);
            }
            case 40: {
                return this.resourceMap.getString("label.prefix.details", new Object[0]) + ", " + this.resourceMap.getString("field.details.steuerIdNr", new Object[0]);
            }
            case 41: {
                return this.resourceMap.getString("label.prefix.details", new Object[0]) + ", " + this.resourceMap.getString("field.details.steuerUstId", new Object[0]);
            }
            case 42: {
                return this.resourceMap.getString("label.prefix.details", new Object[0]) + ", " + this.resourceMap.getString("field.details.wirtschaftIdNr", new Object[0]);
            }
            case 43: {
                return this.resourceMap.getString("label.prefix.details", new Object[0]) + ", " + this.resourceMap.getString("field.details.ausweisNr", new Object[0]);
            }
            case 44: {
                return this.resourceMap.getString("label.prefix.details", new Object[0]) + ", " + this.resourceMap.getString("field.details.ausweisArt", new Object[0]);
            }
            case 45: {
                return this.resourceMap.getString("label.prefix.details", new Object[0]) + ", " + this.resourceMap.getString("field.details.ausweisBehoerde", new Object[0]);
            }
            case 46: {
                return this.resourceMap.getString("field.notes", new Object[0]);
            }
        }
        return null;
    }

    public boolean isMultipleSelectionAllowed(int n) {
        return n == 46;
    }

    protected void readValues(String[] stringArray, ContactsEntry contactsEntry) {
        Object object;
        Object object2;
        String string;
        contactsEntry.getAdress().setCity(this.readValue(3, stringArray));
        contactsEntry.getAdress().setCityPart(this.readValue(4, stringArray));
        contactsEntry.getAdress().setPostalCode(this.readValue(2, stringArray));
        contactsEntry.getAdress().setRegion(this.readValue(6, stringArray));
        contactsEntry.getAdress().setStreet(this.readValue(0, stringArray));
        contactsEntry.getAdress().setStreetNr(this.readValue(1, stringArray));
        String string2 = this.readValue(5, stringArray);
        if (!StringUtils.isBlank((String)string2)) {
            contactsEntry.getAdress().setCountry(ImmoToolUtils.getCountryCodeFromText((String)string2.trim()));
        }
        try {
            string = this.readValue(7, stringArray);
            object2 = this.readValue(8, stringArray);
            if (!StringUtils.isBlank((String)string) && !StringUtils.isBlank((String)object2)) {
                if (!string.contains(".") && string.contains(",")) {
                    string = StringUtils.replace((String)string, (String)",", (String)".");
                }
                contactsEntry.getAdress().setLatitude(Double.valueOf(string));
                if (!((String)object2).contains(".") && ((String)object2).contains(",")) {
                    object2 = StringUtils.replace((String)object2, (String)",", (String)".");
                }
                contactsEntry.getAdress().setLongitude(Double.valueOf((String)object2));
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't read latitude / longitude!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            contactsEntry.getAdress().setLatitude(null);
            contactsEntry.getAdress().setLongitude(null);
        }
        contactsEntry.getPersonAdress().setPersonFax(this.readValue(17, stringArray));
        contactsEntry.getPersonAdress().setPersonFirstName(this.readValue(11, stringArray));
        contactsEntry.getPersonAdress().setPersonGender(this.readValue(12, stringArray));
        contactsEntry.getPersonAdress().setPersonLastName(this.readValue(9, stringArray));
        contactsEntry.getPersonAdress().setPersonMail(this.readValue(14, stringArray));
        contactsEntry.getPersonAdress().setPersonMiddleName(this.readValue(10, stringArray));
        contactsEntry.getPersonAdress().setPersonMobilePhone(this.readValue(16, stringArray));
        contactsEntry.getPersonAdress().setPersonPhone(this.readValue(15, stringArray));
        contactsEntry.getPersonAdress().setPersonTitle(this.readValue(13, stringArray));
        string = this.readValue(12, stringArray);
        if ("FEMALE".equalsIgnoreCase(string)) {
            contactsEntry.getPersonAdress().setPersonGender("FEMALE");
        } else if ("MALE".equalsIgnoreCase(string)) {
            contactsEntry.getPersonAdress().setPersonGender("MALE");
        } else {
            object2 = this.resourceMap.getString("label.gender.female", new Object[0]).split(";");
            boolean bl = false;
            for (String string3 : object2) {
                if (string3.trim().length() <= 0 || !string3.trim().toLowerCase().equals(string)) continue;
                bl = true;
                contactsEntry.getPersonAdress().setPersonGender("FEMALE");
                break;
            }
            if (!bl) {
                object = this.resourceMap.getString("label.gender.male", new Object[0]).split(";");
                for (String string4 : object) {
                    if (string4.trim().length() <= 0 || !string4.trim().toLowerCase().equals(string)) continue;
                    contactsEntry.getPersonAdress().setPersonGender("MALE");
                    break;
                }
            }
        }
        contactsEntry.getCompanyAdress().setCompanyBusiness(this.readValue(28, stringArray));
        contactsEntry.getCompanyAdress().setCompanyDepartment(this.readValue(21, stringArray));
        contactsEntry.getCompanyAdress().setCompanyFax(this.readValue(26, stringArray));
        contactsEntry.getCompanyAdress().setCompanyMail(this.readValue(23, stringArray));
        contactsEntry.getCompanyAdress().setCompanyMobilePhone(this.readValue(25, stringArray));
        contactsEntry.getCompanyAdress().setCompanyName(this.readValue(18, stringArray));
        contactsEntry.getCompanyAdress().setCompanyNameAddition(this.readValue(19, stringArray));
        contactsEntry.getCompanyAdress().setCompanyPhone(this.readValue(24, stringArray));
        contactsEntry.getCompanyAdress().setCompanyPosition(this.readValue(22, stringArray));
        contactsEntry.getCompanyAdress().setCompanyType(this.readValue(20, stringArray));
        try {
            object2 = this.readValue(27, stringArray);
            if (object2 != null && ((String)object2).length() > 0) {
                if (!((String)object2).toLowerCase().startsWith("http://") && !((String)object2).toLowerCase().startsWith("https://")) {
                    object2 = "http://";
                }
                contactsEntry.getCompanyAdress().setCompanyWebsite(new URL((String)object2));
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't read company-website!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            contactsEntry.getCompanyAdress().setCompanyWebsite(null);
        }
        contactsEntry.setAusweisArt(this.readValue(44, stringArray));
        contactsEntry.setAusweisBehoerde(this.readValue(45, stringArray));
        contactsEntry.setAusweisNr(this.readValue(43, stringArray));
        contactsEntry.setCitizenship(this.readValue(31, stringArray));
        contactsEntry.setKontoBic(this.readValue(38, stringArray));
        contactsEntry.setKontoBlz(this.readValue(36, stringArray));
        contactsEntry.setKontoIban(this.readValue(37, stringArray));
        contactsEntry.setKontoInhaber(this.readValue(33, stringArray));
        contactsEntry.setKontoInstitut(this.readValue(34, stringArray));
        contactsEntry.setKontoNr(this.readValue(35, stringArray));
        contactsEntry.setPlaceOfBirth(this.readValue(30, stringArray));
        contactsEntry.setSteuerIdNr(this.readValue(40, stringArray));
        contactsEntry.setSteuerNr(this.readValue(39, stringArray));
        contactsEntry.setSteuerUmsatzIdNr(this.readValue(41, stringArray));
        contactsEntry.setWirtschaftIdNr(this.readValue(42, stringArray));
        try {
            object2 = this.readValue(29, stringArray);
            if (!StringUtils.isBlank((String)object2)) {
                contactsEntry.setDayOfBirth(DateFormat.getDateInstance().parse((String)object2));
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't read day of birth!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            contactsEntry.setDayOfBirth(null);
        }
        try {
            object2 = this.readValue(32, stringArray);
            if (!StringUtils.isBlank((String)object2)) {
                String[] stringArray2 = ((String)(object2 = ((String)object2).trim())).contains(",") ? StringUtils.split((String)object2, (String)",") : (((String)object2).contains(";") ? StringUtils.split((String)object2, (String)";") : (((String)object2).contains(" ") ? StringUtils.split((String)object2, (String)" ") : new String[]{}));
                object = new ArrayList();
                block10: for (String string4 : stringArray2) {
                    if (StringUtils.isBlank((String)string4)) continue;
                    string4 = string4.trim();
                    for (Locale locale : Locale.getAvailableLocales()) {
                        if (!locale.getLanguage().equalsIgnoreCase(string4) && !locale.getDisplayLanguage().equalsIgnoreCase(string4)) continue;
                        object.add(locale);
                        continue block10;
                    }
                }
                if (!object.isEmpty()) {
                    contactsEntry.setSprachen(object.toArray(new Locale[object.size()]));
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn((Object)"Can't read languages!");
            LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            contactsEntry.setSprachen(null);
        }
        object2 = this.readValue(46, stringArray);
        if (!StringUtils.isBlank((String)object2)) {
            contactsEntry.setText(((String)object2).replace("<br>", SystemUtils.LINE_SEPARATOR).replace("<br/>", SystemUtils.LINE_SEPARATOR).replace("<br />", SystemUtils.LINE_SEPARATOR).trim());
        }
    }

    protected synchronized boolean saveCsvObject(ContactsEntry contactsEntry) {
        try {
            if (this.importGroup == null) {
                this.setMessage(this.resourceMap.getString("message.doSaveGroup", new Object[0]));
                this.importGroup = new ContactsGroup();
                this.importGroup.setName(this.resourceMap.getString("label.group", new Object[]{ContactsEntryImportCsvTask.getDateFormat().format(this.importDate)}));
                this.importGroup.setDescription(this.resourceMap.getString("label.group.info", new Object[0]));
                this.importGroup.save();
            }
            this.setMessage(this.resourceMap.getString("message.doSaveAdress", new Object[0]));
            if (this.importGroup.getId() <= 0L) {
                throw new Exception("Ung\u00fcltige Adressgruppe!");
            }
            contactsEntry.setGroupId(this.importGroup.getId());
            contactsEntry.save();
            return true;
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Can't save adress!");
            LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            return false;
        }
    }
}

