/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsEntry;
import com.openindex.openestate.tool.contacts.ContactsGroup;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.GroupRegistry;
import net.fortuna.ical4j.vcard.Parameter;
import net.fortuna.ical4j.vcard.ParameterFactoryRegistry;
import net.fortuna.ical4j.vcard.Property;
import net.fortuna.ical4j.vcard.PropertyFactoryRegistry;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.VCardBuilder;
import net.fortuna.ical4j.vcard.parameter.Type;
import net.fortuna.ical4j.vcard.property.Address;
import net.fortuna.ical4j.vcard.property.BDay;
import net.fortuna.ical4j.vcard.property.Email;
import net.fortuna.ical4j.vcard.property.Fn;
import net.fortuna.ical4j.vcard.property.Gender;
import net.fortuna.ical4j.vcard.property.Geo;
import net.fortuna.ical4j.vcard.property.Lang;
import net.fortuna.ical4j.vcard.property.N;
import net.fortuna.ical4j.vcard.property.Note;
import net.fortuna.ical4j.vcard.property.Org;
import net.fortuna.ical4j.vcard.property.Role;
import net.fortuna.ical4j.vcard.property.Telephone;
import net.fortuna.ical4j.vcard.property.Title;
import net.fortuna.ical4j.vcard.property.Url;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.application.ResourceMap;

public class ContactsEntryImportVCardTask
extends ImmoToolTask<Integer> {
    private static final Logger LOGGER = Logger.getLogger(ContactsEntryImportVCardTask.class);
    private final ResourceMap resourceMap;
    private ContactsGroup importGroup = null;
    private final File importFile;
    private Date importDate = null;

    public ContactsEntryImportVCardTask(File file) {
        this.importFile = file;
        this.resourceMap = ImmoToolUtils.getResourceMap(ContactsEntryImportVCardTask.class);
        this.setTitle(this.resourceMap.getString("title", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer executeTask() throws Exception {
        Integer n;
        if (this.importFile == null) {
            throw new ImmoToolException("Unknown vcard-file!");
        }
        if (!this.importFile.isFile()) {
            throw new ImmoToolException("Invalid vcard-file: " + this.importFile.getAbsolutePath());
        }
        DateFormat dateFormat = ContactsEntryImportVCardTask.getDateFormat();
        int n2 = 0;
        this.importDate = new Date();
        this.importGroup = null;
        FileReader fileReader = null;
        StringReader stringReader = null;
        try {
            String string;
            Object object2;
            fileReader = new FileReader(this.importFile);
            StringBuilder stringBuilder = new StringBuilder();
            for (Object object2 : IOUtils.readLines((Reader)fileReader)) {
                string = (String)object2;
                if (string.startsWith("item1.ADR;") || string.startsWith("item2.ADR;")) {
                    stringBuilder.append(string.substring(6)).append(SystemUtils.LINE_SEPARATOR);
                    continue;
                }
                stringBuilder.append(string).append(SystemUtils.LINE_SEPARATOR);
            }
            stringReader = new StringReader(stringBuilder.toString());
            CompatibilityHints.setHintEnabled((String)"ical4j.parsing.relaxed", (boolean)true);
            CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)true);
            CompatibilityHints.setHintEnabled((String)"ical4j.validation.relaxed", (boolean)true);
            GroupRegistry groupRegistry = new GroupRegistry();
            object2 = new PropertyFactoryRegistry();
            string = new ParameterFactoryRegistry();
            VCardBuilder vCardBuilder = new VCardBuilder((Reader)stringReader, groupRegistry, object2, (ParameterFactoryRegistry)string);
            List list = vCardBuilder.buildAll();
            for (VCard vCard : list) {
                try {
                    ContactsEntry contactsEntry = new ContactsEntry();
                    this.writeVCardToContact(vCard, contactsEntry);
                    if (this.importGroup == null) {
                        this.setMessage(this.resourceMap.getString("message.doSaveGroup", new Object[0]));
                        this.importGroup = new ContactsGroup();
                        this.importGroup.setName(this.resourceMap.getString("label.group", new Object[]{dateFormat.format(this.importDate)}));
                        this.importGroup.setDescription(this.resourceMap.getString("label.group.info", new Object[0]));
                        this.importGroup.save();
                    }
                    this.setMessage(this.resourceMap.getString("message.doSaveAdress", new Object[0]));
                    if (this.importGroup.getId() <= 0L) {
                        throw new Exception("Ung\u00fcltige Adressgruppe!");
                    }
                    contactsEntry.setGroupId(this.importGroup.getId());
                    contactsEntry.save();
                    ++n2;
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"Can't store contact!");
                    LOGGER.error((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
                }
            }
            n = n2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileReader);
            IOUtils.closeQuietly(stringReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)fileReader);
        IOUtils.closeQuietly((Reader)stringReader);
        return n;
    }

    private static DateFormat getDateFormat() {
        return DateFormat.getDateTimeInstance(2, 3);
    }

    protected void succeeded(Integer n) {
        super.succeeded((Object)n);
        this.setMessage(this.resourceMap.getString("message.finished", new Object[]{n}));
    }

    protected void writeVCardToContact(VCard vCard, ContactsEntry contactsEntry) {
        Property property3;
        Object object;
        Role role;
        Object object22;
        Fn fn;
        N n;
        String string;
        Email email;
        Object object3;
        Property property22;
        Address address = null;
        for (Property property22 : vCard.getProperties(Property.Id.ADR)) {
            if (property22 == null) continue;
            address = (Address)property22;
            break;
        }
        if (address != null) {
            object3 = address.getCountry();
            if (object3 != null && object3.trim().length() > 0) {
                contactsEntry.getAdress().setCountry(ImmoToolUtils.getCountryCodeFromText((String)object3.trim()));
            }
            contactsEntry.getAdress().setCity(address.getLocality());
            contactsEntry.getAdress().setPostalCode(address.getPostcode());
            contactsEntry.getAdress().setRegion(address.getRegion());
            contactsEntry.getAdress().setStreet(address.getStreet());
        }
        for (Property property22 : vCard.getProperties(Property.Id.EMAIL)) {
            email = (Email)property22;
            string = email.getValue();
            if (string == null || string.trim().length() == 0) continue;
            n = email.getGroup();
            fn = new ArrayList();
            for (Object object22 : email.getParameters(Parameter.Id.TYPE)) {
                role = object22.getValue().toLowerCase().trim();
                if (role.length() == 0 || fn.contains(role)) continue;
                fn.add(role);
            }
            if (Group.HOME.equals((Object)n) || fn.contains(Type.HOME.getValue().toLowerCase())) {
                if (contactsEntry.getPersonAdress().getPersonMail() != null) continue;
                contactsEntry.getPersonAdress().setPersonMail(string.trim());
                continue;
            }
            if (contactsEntry.getCompanyAdress().getCompanyMail() != null) continue;
            contactsEntry.getCompanyAdress().setCompanyMail(string.trim());
        }
        object3 = (BDay)vCard.getProperty(Property.Id.BDAY);
        if (object3 != null) {
            contactsEntry.setDayOfBirth((Date)object3.getDate());
        }
        if ((property22 = (Gender)vCard.getProperty(Property.Id.GENDER)) != null) {
            if (Gender.FEMALE.equals((Object)property22)) {
                contactsEntry.getPersonAdress().setPersonGender("FEMALE");
            } else if (Gender.MALE.equals((Object)property22)) {
                contactsEntry.getPersonAdress().setPersonGender("MALE");
            }
        }
        if ((email = (Geo)vCard.getProperty(Property.Id.GEO)) != null && email.getLatitude() != null && email.getLongitude() != null) {
            contactsEntry.getAdress().setLatitude(Double.valueOf(email.getLatitude().doubleValue()));
            contactsEntry.getAdress().setLongitude(Double.valueOf(email.getLongitude().doubleValue()));
        }
        if ((string = (Lang)vCard.getProperty(Property.Id.LANG)) != null && (n = string.getLocales()) != null && ((N)n).length > 0) {
            contactsEntry.setSprachen((Locale[])n);
        }
        n = (N)vCard.getProperty(Property.Id.N);
        fn = (Fn)vCard.getProperty(Property.Id.FN);
        if (n != null) {
            if (n.getFamilyName() != null) {
                contactsEntry.getPersonAdress().setPersonLastName(n.getFamilyName());
            }
            if (n.getGivenName() != null) {
                contactsEntry.getPersonAdress().setPersonFirstName(n.getGivenName());
            }
        } else if (fn != null) {
            contactsEntry.getPersonAdress().setPersonLastName(fn.getValue());
        }
        StringBuilder stringBuilder = new StringBuilder();
        object22 = vCard.getProperties(Property.Id.NOTE).iterator();
        while (object22.hasNext()) {
            role = (Property)object22.next();
            object = (Note)role;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(SystemUtils.LINE_SEPARATOR).append(SystemUtils.LINE_SEPARATOR);
            }
            stringBuilder.append(object.getValue());
        }
        if (stringBuilder.length() > 0) {
            contactsEntry.setText(stringBuilder.toString());
        }
        if ((object22 = (Org)vCard.getProperty(Property.Id.ORG)) != null) {
            role = object22.getValues();
            if (role != null && ((Role)role).length > 0) {
                contactsEntry.getCompanyAdress().setCompanyName((String)role[0]);
            }
            if (role != null && ((Role)role).length > 1) {
                contactsEntry.getCompanyAdress().setCompanyNameAddition((String)role[1]);
            }
        }
        if ((role = (Role)vCard.getProperty(Property.Id.ROLE)) != null) {
            contactsEntry.getCompanyAdress().setCompanyPosition(role.getValue());
        }
        for (Property property3 : vCard.getProperties(Property.Id.TEL)) {
            Telephone telephone = (Telephone)property3;
            String string2 = telephone.getValue();
            if (string2 == null || string2.trim().length() == 0) continue;
            Group group = telephone.getGroup();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Parameter parameter : telephone.getParameters(Parameter.Id.TYPE)) {
                String string3 = parameter.getValue().toLowerCase().trim();
                if (string3.length() == 0 || arrayList.contains(string3)) continue;
                arrayList.add(string3);
            }
            if (Group.HOME.equals((Object)group) || arrayList.contains(Type.HOME.getValue().toLowerCase())) {
                if (arrayList.contains("cell")) {
                    if (contactsEntry.getPersonAdress() != null) continue;
                    contactsEntry.getPersonAdress().setPersonMobilePhone(string2.trim());
                    continue;
                }
                if (arrayList.contains("fax")) {
                    if (contactsEntry.getPersonAdress() != null) continue;
                    contactsEntry.getPersonAdress().setPersonFax(string2.trim());
                    continue;
                }
                if (contactsEntry.getPersonAdress() != null) continue;
                contactsEntry.getPersonAdress().setPersonPhone(string2.trim());
                continue;
            }
            if (arrayList.contains("cell")) {
                if (contactsEntry.getCompanyAdress().getCompanyMobilePhone() != null) continue;
                contactsEntry.getCompanyAdress().setCompanyMobilePhone(string2.trim());
                continue;
            }
            if (arrayList.contains("fax")) {
                if (contactsEntry.getCompanyAdress().getCompanyFax() != null) continue;
                contactsEntry.getCompanyAdress().setCompanyFax(string2.trim());
                continue;
            }
            if (contactsEntry.getCompanyAdress().getCompanyPhone() != null) continue;
            contactsEntry.getCompanyAdress().setCompanyPhone(string2.trim());
        }
        object = (Title)vCard.getProperty(Property.Id.TITLE);
        if (object != null) {
            contactsEntry.getPersonAdress().setPersonTitle(object.getValue());
        }
        if ((property3 = (Url)vCard.getProperty(Property.Id.URL)) != null) {
            try {
                contactsEntry.getCompanyAdress().setCompanyWebsite(property3.getUri().toURL());
            }
            catch (Exception exception) {
                LOGGER.warn((Object)"Can't read url from vcard!");
                LOGGER.warn((Object)("> " + property3.getUri().toString()));
                LOGGER.warn((Object)("> " + exception.getLocalizedMessage()), (Throwable)exception);
            }
        }
    }
}

